library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity top is
	port (
		CLOCK_50 : in std_logic;
		
		PS2_CLK : inout std_logic;
		PS2_DAT : inout std_logic;
		
		SRAM_ADDR : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
		SRAM_CE_N : OUT STD_LOGIC;
		SRAM_DQ : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
		SRAM_LB_N : OUT STD_LOGIC;
		SRAM_OE_N : OUT STD_LOGIC;
		SRAM_UB_N : OUT STD_LOGIC;
		SRAM_WE_N : OUT STD_LOGIC;


        VGA_CLK,
        VGA_HS,
        VGA_VS,
        VGA_BLANK,
        VGA_SYNC : out std_logic;
        VGA_R,
        VGA_G,
        VGA_B : out STD_LOGIC_VECTOR(9 downto 0);
        
        ENET_DATA : inout std_logic_vector(15 downto 0);
        ENET_CMD,
        ENET_CS_N,
        ENET_WR_N,
        ENET_RD_N,
        ENET_RST_N,
        ENET_CLK : out std_logic;
        ENET_INT : in std_logic
	);
end top;

architecture rtl of top is
 	signal clk25 : std_logic;
begin
        process (CLOCK_50)
        begin
            if rising_edge(CLOCK_50) then
				clk25 <= not clk25;
			end if;
		end process;

		ENET_CLK <= clk25;

		U1 : entity work.pong port map
		(
              -- 1) global signals:
                 clk => CLOCK_50,
                 reset_n => '1',

              -- the_ps2slave_inst
                 PS2_CLK_to_and_from_the_de2_ps2_inst => PS2_CLK,
                 PS2_DAT_to_and_from_the_de2_ps2_inst => PS2_DAT,
                   

              -- the_sram_inst
                 SRAM_ADDR_from_the_sram_inst => SRAM_ADDR,
                 SRAM_CE_N_from_the_sram_inst => SRAM_CE_N,
                 SRAM_DQ_to_and_from_the_sram_inst => SRAM_DQ,
                 SRAM_LB_N_from_the_sram_inst => SRAM_LB_N,
                 SRAM_OE_N_from_the_sram_inst => SRAM_OE_N,
                 SRAM_UB_N_from_the_sram_inst => SRAM_UB_N,
                 SRAM_WE_N_from_the_sram_inst => SRAM_WE_N,


              -- the_de2_vga_raster_inst
                 CLOCK_50_to_the_de2_vga_raster_inst => CLOCK_50,
                 VGA_BLANK_from_the_de2_vga_raster_inst => VGA_BLANK,
                 VGA_B_from_the_de2_vga_raster_inst => VGA_B,
                 VGA_CLK_from_the_de2_vga_raster_inst => VGA_CLK,
                 VGA_G_from_the_de2_vga_raster_inst => VGA_G,
                 VGA_HS_from_the_de2_vga_raster_inst => VGA_HS,
                 VGA_R_from_the_de2_vga_raster_inst => VGA_R,
                 VGA_SYNC_from_the_de2_vga_raster_inst => VGA_SYNC,
                 VGA_VS_from_the_de2_vga_raster_inst => VGA_VS,


              -- the_de2_enet_inst

                 ENET_CMD_from_the_de2_enet_inst => ENET_CMD,
                 ENET_CS_N_from_the_de2_enet_inst => ENET_CS_N,
                 ENET_DATA_to_and_from_the_de2_enet_inst => ENET_DATA,
                 ENET_INT_to_the_de2_enet_inst => ENET_INT,
                 ENET_RD_N_from_the_de2_enet_inst => ENET_RD_N,
                 ENET_RST_N_from_the_de2_enet_inst => ENET_RST_N,
                 ENET_WR_N_from_the_de2_enet_inst => ENET_WR_N
		);

end rtl;
