library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


--
-- 307,200 bit memory to store foreground bitmap
-- Stored as 19,200 16-bit half-words
--

entity ram_fg is
port (
	
	-- avalon side
	clk 		: in std_logic; -- dual clocked
	addr		: in unsigned (14 downto 0);
	cs			: in std_logic; -- chipselect
	w_en		: in std_logic; -- write enable
	din			: in unsigned (15 downto 0); 
	dout		: out unsigned (15 downto 0);
	
	--vga side
	clk2		: in std_logic; -- dual clocked
	addr2		: in unsigned (14 downto 0);
	dout2		: out unsigned (15 downto 0)
	
	);
end ram_fg;


architecture rtl of ram_fg is

	type ram_type is array (0 to 4800) of unsigned (15 downto 0);
	signal RAM : ram_type;
	
	begin
		
		process (clk) begin
			if rising_edge(clk) then
				if w_en = '1' then RAM(to_integer(addr)) <= din;
						dout <= din;
				else dout <= RAM(to_integer(addr));
				end if;
			end if;
		end process;
		
		
		process (clk2) begin
			if rising_edge(clk2) then
				 dout2 <= RAM(to_integer(addr2));
				end if;
		end process;
		
	
		
	end rtl;
