#include "packet.h"
#include "game.h"
#include "mouse.h"
#include <stdio.h>

#include "ui.h"
#include "graphics.h"

#include "banner.h"
#include <unistd.h>
#include "dm9000a.h"

void ui_updatescore()
{
    char score1[4];
    char score2[4];

    sprintf(score1, "%d", gs.p1.score);
    sprintf(score2, "%2d", gs.p2.score);
    
    // clear the top
//    clr_fg_sub(0, 800);
    
    put_vga_string( "  ", 1, 0 );
    put_vga_string (score1, 1, 0);

    put_vga_string( "  ", 37, 0);
    put_vga_string (score2, 37, 0);
    
}

int ui_getplayer()
{
    clr_fg();

    // display menu    
    
    ui_pong(100);
    
    // default is player 1
  
    draw_vline_dotted(20, 100, 160);
    draw_vline_dotted(20, 180, 240);
    
    inv_vga_string ("Player 1", 16, 160);
    put_vga_string ("Player 2", 16, 180);
    
    int sel = 1;
    int done = 0;
    
    int vx, vy, b;
  
  
    
    while (done == 0)
    {
 //       mouse_poll();
        usleep(1000);
        
        if (mouse_event( &vx, &vy, &b))
        {
            if (sel == 1 && (vy < -10))
            {
                // clear the screen 
                clr_fg_sub(6400,7820);
                put_vga_string ("Player 1", 16, 160);
                inv_vga_string ("Player 2", 16, 180);
                sel = 2;
                
            }
            
            if (sel == 2 && (vy > 10))
            {
                clr_fg_sub(6400,7820);
                inv_vga_string ("Player 1", 16, 160);
                put_vga_string ("Player 2", 16, 180);
                sel = 1;
            }
            
            if (b & MOUSE_LB)
            {
                
               if (sel == 1)
               {
                  return 1;
               }
               if (sel == 2)
               {
                  return 2;
               }
               
            }
                
        }
    }

    return -1;
}


void ui_waitopponent()
{
    rgs.ball.x = 0xdead;

    inv_vga_string( "Waiting for Opponent...", 8, 120 );    

    while ( rgs.ball.x == 0xdead )
    {        
        transmit_state();
        usleep( 1000000 );   
    }

    put_vga_string( "                       ", 8, 120 );    

    draw_centerline();
    ui_updatescore();

    dm9000a_flush();


}

void ui_updatescore_text()
{
    printf( "Score: P1=%d P2=%d\n", gs.p1.score, gs.p2.score );
    
}


void ui_winner()
{
    ui_win(100);

    usleep(1000000);
}

void ui_loser()
{
    ui_lose(100);
  
    usleep(1000000);
}


