#ifndef	PACKET_H
#define	PACKET_H

#include "types.h"

// nios is byteswap?
#define	BYTESWAP

#ifdef BYTESWAP
#define HTONS(a) \
	((((a) & 0xff00) >> 8) | (((a) & 0x00ff) << 8))
#define HTONL(a) \
	((((a) & 0xff000000) >> 24)	| \
	 (((a) & 0x00ff0000) >> 8)	| \
	 (((a) & 0x0000ff00) << 8) 	| \
	 (((a) & 0x000000ff) << 24) )
#else
#define	HTONS(a)	(a)
#define	HTONL(a)	(a)
#endif

#define	NTOHS(a)	HTONS(a)
#define	NTOHL(a)	HTONL(a)

// always in HOST order
#define	IP(a,b,c,d)	( ((a)<<24) | ((b)<<16) | ((c)<<8) | ((d)<<0) )


typedef struct
{
	// ethernet
	struct
	{
		u8	daddr[6];
		u8	saddr[6];
		u16	type;

	} __attribute__((packed)) enet;
	
	struct
	{
		u8	vhl;		// 7-4: version 3-0: hdr len, in 32-bit words
		u8	ds;			// diff services
		u16	len;		// length of entire IP datagram, header included
	
		u16	id;
		u8	flag;		// 7-5: reserved, df, mf 4-0: high frag bits
		u8	frag;
	
		u8	ttl;
		u8	proto;
		u16	cksum;		// header checksum only
	
		u32	saddr;
		u32	daddr;
	} __attribute__((packed)) ip;

	struct
	{
		u16	sport;
		u16	dport;
		
		u16	len;		// length of udp header and data
		u16	cksum;

	} __attribute__((packed)) udp;

	
	u8 data[64];

} __attribute__((packed)) packet_t;


extern packet_t txpkt;
extern packet_t rxpkt;

#endif
