#include "types.h"
#include "packet.h"
#include <string.h>

packet_t txpkt =
{
	.enet =
	{
		.daddr = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },
		.saddr = { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },

#ifdef  PACKET_L3L4
		.type = HTONS(0x0800)		// ip
#else
        .type = HTONS(0xdead)
#endif

	},

#ifdef  PACKET_L3L4
	.ip = 
	{
		.vhl = 0x45,
		.ds = 0,
		.len =						// 20+8+256 = 0x011c
			HTONS(sizeof(txpkt.ip)+sizeof(txpkt.udp)+sizeof(txpkt.data)),

		.id = HTONS(0xabcd),
		.flag = 0,
		.frag = 0,
		.ttl = 0xff,
		.proto = 0x11,				// udp
//		.cksum = HTONS(0x8ab2),		// header sum = 0x3754a, ones comp = 0x754d, cksum = 0x8ab2
        .cksum = 0xffff,
		.saddr = HTONL(IP(192,168,1,1)),	// c0 a8 01 01
		.daddr = HTONL(IP(192,168,1,255))	// c0 a8 01 ff
	},

	.udp =
	{
		.sport = HTONS(1234),
		.dport = HTONS(5678),
	
		.len = 					// length of udp header and data
			HTONS(sizeof(txpkt.udp)+sizeof(txpkt.data)),
			
		.cksum = 0
	}
#endif

};


packet_t rxpkt;


void ip_cksum( packet_t* pkt )
{
#ifdef  PACKET_L3L4
	pkt->ip.cksum = 0;
	u32 cksum=0;
	u16* pt;
	u16* pe;

    // size in 16-bit words
	pe = (u16*)&pkt->ip + sizeof(pkt->ip)/2;
	
	for (pt=(u16*)&pkt->ip ; pt!=pe ; pt++)
		cksum += *pt;

    // the peculiar thing about checksums... don't need HTONS conversion,
    // since this is already taken care of by counters
	pkt->ip.cksum = ~((cksum & 0xffff) + (cksum >> 16) );

#endif
}



void udp_data( packet_t* pkt, u8* buf, u16 len )
{
	memcpy( pkt->data, buf, len );
	pkt->ip.len = HTONS( sizeof(pkt->udp)+len );
}


int pkt_valid( packet_t* pkt )
{
	return
		pkt->enet.type == NTOHS(0x0800)
		&& pkt->ip.proto == 0x11;
}


int pkt_datalen( packet_t* pkt )
{
	return NTOHS(pkt->udp.len) - sizeof(pkt->udp);
}
