#ifndef	MOUSE_H
#define	MOUSE_H

typedef struct
{
	int x, y, b, vx, vy;	
	char data[3];
	unsigned int n;
} mouse_t;

extern mouse_t mouse;

#define	MOUSE_YOF	(1<<7)
#define	MOUSE_XOF	(1<<6)
#define	MOUSE_YSI	(1<<5)
#define	MOUSE_XSI	(1<<4)
#define	MOUSE_MB	(1<<2)
#define	MOUSE_RB	(1<<1)
#define	MOUSE_LB	(1<<0)

#define	MOUSE_CTL	(mouse.data[0])
#define	MOUSE_X		(mouse.data[1])
#define	MOUSE_Y		(mouse.data[2])

inline void mouse_ie(int en);
void	mouse_isr( void );
int	mouse_event( int* x, int* y, int* button );
int	mouse_write( unsigned char cmd );
int	mouse_read( unsigned char* c );
int	mouse_read_blocking( unsigned char* buf );
void	mouse_flush( void );
void	mouse_stream( void );
int	mouse_data( char* buf );
int	mouse_init( void );
void	mouse_start( void );
void	mouse_poll( void );



#endif


