#include <system.h>
#include <alt_types.h>
#include <sys/alt_irq.h>
#include <stdio.h>

#include "mouse.h"
#include "xio.h"

#define MOUSE_BASE  DE2_PS2_INST_BASE

#include <stdio.h>
#include <unistd.h>


mouse_t mouse;

inline void mouse_ie(int en)
{
    if (en)
        IOWR32(MOUSE_BASE+4, 0x0001);
    else
        IOWR32(MOUSE_BASE+4, 0x0000);   
}






void mouse_isr()
{
    putchar( 'M' );

    static int n=0;
    unsigned char d;
    
    // magic sleep.  without it, third byte of mouse data packet gets lost in FIFO,
    // only to be read at next interrupt.  this is bad.  long live magic sleep!
    // (putting a sleep in an ISR is probably not an entirely great idea)

    int event=0;

    int i;
    for (i=0 ; i<2000 ; i++)
        ;

    while ( mouse_read( &d ) )
    {
        mouse.data[n] = d;
        if ( ++n==3 )
        {
            mouse.n++;
            n=0;   

            // process new packet...
            int x, y;
            
            x = (int)MOUSE_X;
            if ( MOUSE_CTL & MOUSE_XSI )
                x |= 0xffffff00;

            y = (int)MOUSE_Y;
            if ( MOUSE_CTL & MOUSE_YSI )
                y |= 0xffffff00;

            mouse.vx = x;
            mouse.vy = y;
 
            mouse.x += x;
            mouse.y += y;

            mouse.b |= (MOUSE_CTL & (MOUSE_LB | MOUSE_RB | MOUSE_MB) );

            event++;
        }
    }
}




int mouse_event( int* x, int* y, int* button )
{
    static unsigned int n = 0;
    
    // no new events from isr
    if ( n == mouse.n )
        return 0;    

    n = mouse.n;

//    if ( button != 0 )
//        *button = MOUSE_CTL & (MOUSE_LB | MOUSE_RB | MOUSE_MB);
    
    *x = mouse.x;
    *y = mouse.y;
    
    if ( button )
        *button = mouse.b;

    // disable interrupts, clear global mouse position counter
    mouse_ie(0);
    mouse.x = 0;
    mouse.y = 0;
    mouse.b = 0;
    mouse_ie(1);
 
    return 1;
}


int mouse_write( unsigned char cmd )
{
    IOWR32(MOUSE_BASE, cmd);

    return 1;   
}


int mouse_read( unsigned char* c )
{
    unsigned int tmp = IORD32(MOUSE_BASE);

    if ( (tmp>>16) != 0 )
    {
        *c = (tmp&0xff);
        return 1;
    }
    else
    {
        return 0;
    }
}

int mouse_read_blocking( unsigned char* buf )
{
    unsigned int tmp;
    
    // that's right, real men poll!
    do {
        tmp = IORD32(MOUSE_BASE);
//        printf( "%08x\n", tmp );
//        usleep( 100000 );
    } while ( (tmp>>16) == 0 );


    if (buf == 0)
        return 0;
        
    *buf = (unsigned char)tmp;
    return 1;
}



void mouse_flush()
{
    unsigned int tmp;
    
    // that's right, real men poll!
    do {
        tmp = IORD32(MOUSE_BASE);
    } while ( (tmp>>16) != 0 );
}

void mouse_stream()
{
    char buf;
    
    mouse_write( 0xf3 );    // set sample rate
    mouse_read_blocking(&buf);
    mouse_write( 20 );      // 10Hz
    mouse_read_blocking(&buf);

//    mouse_write( 0xe8 );    // set resolution
//    mouse_read(0);          // ack
//    mouse_write( 3 );       // 8 counts/mm
//    mouse_read(0);          // ack

    
    mouse_write( 0xf4 );    // enable
    mouse_read_blocking(&buf);

}

int mouse_data( char* buf )
{
    mouse_read( &buf[0] );
    mouse_read( &buf[1] );
    mouse_read( &buf[2] );

    return 1;
}

int mouse_init()
{
    unsigned char ack, res, id;
    int i;
    
    mouse_flush();
    
    for (i=0 ; i<4 ; i++)
    {
    	mouse_write( 0xff );
        
        if ( mouse_read_blocking(&ack) && mouse_read_blocking(&res) && mouse_read_blocking(&id) )
        {
            if ( ack!=-0xfa && res!=0xaa )
                return 0;
        }
    }
    
    printf( "Mouse detected.\n" );
    return 1;
}


void mouse_start()
{
    mouse_ie(0);

    mouse_init();
    mouse_stream();

//    usleep(100000);
//    mouse_flush();

    // register interrupt
    alt_irq_register( DE2_PS2_INST_IRQ, NULL, (void*)mouse_isr );
    // enable interrupt in peripheral
    mouse_ie(1);
}


void mouse_poll()
{
    unsigned char buf[4];
    int i;

    while (1)
    {
        mouse_write( 0xeb );

        // mouse sends 0xfa then movement packet
        for (i=0 ; i<4 ; i++)
        {
            mouse_read_blocking( &buf[i] );

            usleep(2000);
            
            if (i==0 && buf[0] != 0xfa)
                break;

        }
 
        if (buf[0] == 0xfa)
            break;
        else          
        {
            printf( "error\n" );
            mouse_flush();
//            mouse_write(0xff);
        }
    }

    mouse.n++;

//    printf( "%02x %02x %02x %02x\n", buf[0], buf[1], buf[2], buf[3] );

    //                  0    1    2  3
    // packet contains: ack, ctl, x, y

    int x, y;

    x = (int)buf[2];
    if ( buf[1] & MOUSE_XSI )
        x |= 0xffffff00;

    y = (int)buf[3];
    if ( buf[1] & MOUSE_YSI )
        y |= 0xffffff00;

    mouse.vx = x;
    mouse.vy = y;
 
    mouse.x += x;
    mouse.y += y;

    mouse.b |= (buf[1] & (MOUSE_LB | MOUSE_RB | MOUSE_MB) );

}

