#include <stdio.h>
#include <system.h>
#include <stdlib.h>
#include <alt_types.h>
#include <sys/alt_irq.h>

#include "xio.h"

#include "mouse.h"
#include "game.h"
#include "packet.h"
#include "bg.h"
#include "dm9000a.h"
#include "graphics.h"


void init()
{
    mouse_start();
    printf( "Mouse init done.\n" );
 
    dm9000a_start();
    printf( "Ethernet init done.\n" );


    gs.pn = ui_getplayer();
//    ui_waitopponent();
    
    // clear the logos
    clr_fg();
    // draw vertical line
    draw_centerline(); 
    ui_updatescore();
   

    txpkt.enet.saddr[5] = gs.pn;

#ifdef PACKET_L3L4
    txpkt.ip.saddr = HTONL( IP( 192, 168, 0, pn ) );
#endif
    if (gs.pn==1)
    {
        gs.p2.c = 0;
        gs.p2.l = 0;
    }
    else
    {
        gs.p1.c = 0;
        gs.p1.l = 0;
    }
}


static inline void game()
{
    int vx, vy, y, b;

    // DURING ACTIVE SCAN ---------------------------------
    while (IORD16(VGA_SYNC) == 0 )
        ;
        
    update_state();

    if ( mouse_event( &vx, &vy, &b ) )
    {
        y = gs_pl()->c;

        // mouse up is -y direction in paddle-space
        y += -1*vy;

        if ( y < (gs_pl()->l/2) )
            y = gs_pl()->l/2;
        else if ( y>(SCREEN_Y-gs_pl()->l/2) )
            y = (SCREEN_Y-gs_pl()->l/2);

        gs_pl()->c = y;
    }

    // when not to display the ball: when not on our screen, and on other serve
    if ( gs.ball.side!=gs.pn || (gs.sn>0 && gs.sn!=gs.pn) )
    {
        gs.ball.x = 10;
        gs.ball.y = 10;   
    }

    // local player has ball to serve/start
    if (gs.sn == gs.pn)
    {
        ui_updatescore();

        gs.ball.y = gs_pl()->c;

        gs.ball.x = (gs.pn==1) ? 60 : SCREEN_X-60;

        gs.ball.vx = 0;
        gs.ball.vy = 0;
        
        // button press, local player has serve
        if (b & MOUSE_LB)
        {
            gs.ball.vx = get_player()==1 ? -BALL_SPEED : BALL_SPEED;
            gs.sn = 0;   
        }
        
    }


    // DURING SYNC INTERVAL ---------------------------
    while (IORD16(VGA_SYNC) != 0 )
        ;

    show_state();

}



int main()
{
    printf("NIOS boot successful.\n");
    
    IOWR16( VGA_FG_COLOR, 0x0fa5);
    IOWR16( VGA_SC_COLOR, 0x80ff);
    IOWR16( VGA_GO_COLOR, 0xffff);

    init();

    while (1)
    {
        game();
//        import_state();
//        transmit_state();
//        mouse_poll();
 
    }
}
