#ifndef	GAME_H
#define	GAME_H

#include "ui.h"

#define	PADDLE_MIN(p) \
	(p.c-(p.l/2))

#define	PADDLE_MAX(p) \
	(p.c+(p.l/2))

#define	PADDLE_WIDTH	5
#define	PADDLE_OFFSET	20
#define	BALL_RADIUS		8

#define SCREEN_X        640
#define SCREEN_Y        480

#define	PADDLE_EDGE_LEFT	(0+PADDLE_OFFSET+PADDLE_WIDTH+BALL_RADIUS)
#define	PADDLE_EDGE_RIGHT (SCREEN_X-(PADDLE_OFFSET+PADDLE_WIDTH)-BALL_RADIUS)

#define BALL_SCORE_LEFT (1)
#define BALL_SCORE_RIGHT (SCREEN_X-1)

#define BALL_SPEED      4


#include "vga.h"
#include "types.h"

typedef struct
{
	u16 x, y;
	short int vx, vy;

    short int side;
} ball_t;

typedef struct
{
	u16 c;
	u8	l;
	u8	score;
} player_t;

typedef struct
{
	ball_t	ball;

	player_t p1;
	player_t p2;

    short int pn;         // player number
    short int sn;         // server number (0=none)
    
    
} state_t;

extern state_t gs;
extern state_t rgs;

void	import_state(char*);
void	show_state( void );
int	score_position( void );
void	paddle_spin( void );
int	paddle_bounce( void );
int	wall_bounce( void );
void	update_state( void );
void	transmit_state( void );
int	get_player( void );
player_t* gs_pl();
player_t* gs_pr();
void handoff( void );

#endif


