#include "game.h"
#include <system.h>
#include <io.h>
#include "packet.h"
#include <stdio.h>
#include "mouse.h"
#include "vga.h"
#include <stdlib.h>		// for abs()
#include <string.h>		// for memcpy()
#include "dm9000a.h"

#define IOWR16(base,data) \
    IOWR_16DIRECT(base,0,data)

state_t gs = { .sn=0, .p1 = {SCREEN_Y/2, 80, 0}, .p2={SCREEN_Y/2, 80, 0}, .ball={SCREEN_X/2, SCREEN_Y/2, -1*BALL_SPEED, 0, 1} };

// remote game state
state_t rgs;


player_t* gs_pl()
{
    if ( gs.pn == 1 )
        return &gs.p1;
    else
        return &gs.p2;   
}

player_t* gs_pr()
{
    if ( gs.pn == 1 )
        return &gs.p2;
    else
        return &gs.p1;   
}

void import_state(char* buf)
{
    state_t* ptr = (state_t*)((packet_t*)buf)->data;
    
    memcpy( &gs.ball, &ptr->ball, sizeof(ball_t) );
    gs.sn = ptr->sn; 
    
    gs.p1.score = ptr->p1.score;
    gs.p2.score = ptr->p2.score;
}


void show_state()
{
    short tmp;

	IOWR16(VGA_BX, gs.ball.x);
	IOWR16(VGA_BY, gs.ball.y);
	
	tmp=gs.p1.c-gs.p1.l/2;
	IOWR16(VGA_P1A, tmp<0 ? 0 : tmp);
	IOWR16(VGA_P1B, gs.p1.c+gs.p1.l/2);

    tmp=gs.p2.c-gs.p2.l/2;
	IOWR16(VGA_P2A, tmp<0 ? 0 : tmp);
	IOWR16(VGA_P2B, gs.p2.c+gs.p2.l/2);
}



// returns player who gets point, NOT side on which ball crossed
int score_position()
{
    // ball next x-position
    int xn = gs.ball.x + gs.ball.vx;
    
    // right side: point for player 1
    if (gs.ball.x <= BALL_SCORE_RIGHT && xn > BALL_SCORE_RIGHT )
        return 1;

    // left side: point for player 2
    if (gs.ball.x >= BALL_SCORE_LEFT && xn < BALL_SCORE_LEFT )
        return 2;

    return 0;
}

void paddle_spin()
{
    // TODO: make sure it's the local player
    
    if (abs(mouse.vy) > 15)
        gs.ball.vy -= (mouse.vy/2);
    else if (abs(mouse.vy) > 7)
        gs.ball.vy -= (mouse.vy/8);   
}

void handoff()
{
    printf( "handoff from %d vx=%d sn=%d\n", gs.pn, gs.ball.vx, gs.sn );

    // change screen of ball
    gs.ball.side = (gs.pn==1) ? 2 : 1;
    
    // mirror about x-axis
    gs.ball.x = SCREEN_X - gs.ball.x;
    printf( "new ball x=%d\n", gs.ball.x );    
    
    // transmit packet   
    transmit_state();

    // hide ball on our side
    gs.ball.x = 10;
    gs.ball.y = 10;

}

int paddle_bounce()
{
    int xn = gs.ball.x + gs.ball.vx;
    
    if (gs.ball.x >= PADDLE_EDGE_LEFT && xn < PADDLE_EDGE_LEFT
        && PADDLE_MIN(gs.p1) <= gs.ball.y && PADDLE_MAX(gs.p1) >= gs.ball.y )
       return 1;
    
    if (gs.ball.x <= PADDLE_EDGE_RIGHT && xn > PADDLE_EDGE_RIGHT
        && PADDLE_MIN(gs.p2) <= gs.ball.y && PADDLE_MAX(gs.p2) >= gs.ball.y )
        return 2;
    
    return 0;
}


int wall_bounce()
{
    // bounce off top and bottom
    return ( gs.ball.y < BALL_RADIUS || gs.ball.y > (SCREEN_Y-BALL_RADIUS) );
}

void update_state()
{
//	printf( "x=%d y=%d vx=%d vy=%d\n", gs.ball.x, gs.ball.y, gs.ball.vx, gs.ball.vy );
    
    
	// to keep the math easy...
	gs.ball.x %= 1024;
	gs.ball.y %= 1024;

    int b;
    if (wall_bounce())
    {
        gs.ball.vy *= -1;
        printf( "wall bounce on %d\n", gs.pn );
    }

    else if ( (b=paddle_bounce()) == get_player())
    {
        gs.ball.vx *= -1;
        
        if (gs.ball.vx > 0)
            gs.ball.vx++;
        else
            gs.ball.vx--;
            
        paddle_spin();
        
        printf( "paddle bounce vy=%d on %d\n", mouse.vy, gs.pn );
        
    }
    
    int pn;
    if ( (pn = score_position())  )
    {
        // other player scored on  you
        if (pn!=get_player())
        {
            printf( "you lose a point\n" );

            gs.ball.vx = 0;
            gs.ball.vy = 0;
            gs_pr()->score++;
            gs.sn = (gs.pn == 1) ? 2 : 1;

            ui_updatescore(); 
            handoff();
        }
        else if ( (gs.pn==1 && gs.ball.vx>0) || (gs.pn==2 && gs.ball.vx<0) ) 
        {
            handoff();
            return;
        }                
    }
 
    gs.ball.x += gs.ball.vx;
    gs.ball.y += gs.ball.vy;

}


void transmit_state()
{
    memcpy( txpkt.data, &gs, sizeof(gs) );
    dm9000a_tx( (u8*)&txpkt, sizeof(txpkt) );
}

int get_player()
{
    return gs.pn;
}

