library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity invaders_top is
  
  port (
    signal CLOCK_50 : in std_logic;                	-- 50 MHz clock
	signal VGA_CLK,                         		-- Clock
    VGA_HS,                          				-- H_SYNC
    VGA_VS,                          				-- V_SYNC
    VGA_BLANK,                       				-- BLANK
    VGA_SYNC : out std_logic;        				-- SYNC
    signal VGA_R,                           		-- Red[9:0]
    VGA_G,                           				-- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0); 		-- Blue[9:0]

    PS2_DAT,                    					-- Data
    PS2_CLK : in std_logic;     					-- Clock

    SRAM_DQ : inout std_logic_vector(15 downto 0); 	-- Data bus 16 Bits
    SRAM_ADDR : out std_logic_vector(17 downto 0); 	-- Address bus 18 Bits
    SRAM_UB_N,                                     	-- High-byte Data Mask
    SRAM_LB_N,                                     	-- Low-byte Data Mask
    SRAM_WE_N,                                     	-- Write Enable
    SRAM_CE_N,                                     	-- Chip Enable
    SRAM_OE_N : out std_logic;                      	-- Output Enable

    AUD_ADCLRCK : inout std_logic;                  -- ADC LR Clock
    AUD_ADCDAT : in std_logic;                      -- ADC Data
    AUD_DACLRCK : inout std_logic;                  -- DAC LR Clock
    AUD_DACDAT : out std_logic;                     -- DAC Data
    AUD_BCLK : inout std_logic;                     -- Bit-Stream Clock
    AUD_XCK : out std_logic;                        -- Chip Clock

    I2C_SDAT : inout std_logic; 					-- I2C Data
    I2C_SCLK : out std_logic   						-- I2C Clock  
  );
end invaders_top;

architecture rtl of invaders_top is
  
  
 
  component de2_wm8731_audio is
   port (
    clk : in std_logic;                 --    Audio CODEC Chip Clock AUD_XCK
    reset_n : in std_logic;
    test_mode : in std_logic;           --    Audio CODEC controller test mode
    audio_request : out std_logic;      --    Audio controller request new data
    data : in std_logic_vector(15 downto 0);
  
    -- Audio interface signals
    AUD_ADCLRCK  : out std_logic;       --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in  std_logic;       --    Audio CODEC ADC Data
    AUD_DACLRCK  : out std_logic;       --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out std_logic;       --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic ;     --    Audio CODEC Bit-Stream Clock
	freq_in :in std_logic_vector(15 downto 0);
	mod_depth_in:in std_logic_vector(3 downto 0);
	on_off_in: in std_logic_vector(15 downto 0)
);
  end component;


  component de2_i2c_av_config is
	port (
		iCLK : in std_logic;
		iRST_N : in std_logic;
		I2C_SCLK : out std_logic;
		I2C_SDAT : inout std_logic
	);
  end component;



  signal audio_clock : unsigned(1 downto 0) := "00";
  signal audio_request : std_logic;
  signal freq: std_logic_vector (15 downto 0);
  signal mod_depth: std_logic_vector (3 downto 0);
  signal on_off: std_logic_vector(15 downto 0);
  signal counter : std_logic := '0';
  signal reset_n : std_logic;

  
begin

  process (CLOCK_50)
  begin
	if rising_edge(CLOCK_50) then
      audio_clock <= audio_clock + "1";
    end if;
  end process;

  AUD_XCK <= audio_clock(1);


  
  i2c : de2_i2c_av_config port map (
    iCLK     => CLOCK_50,
    iRST_n   => '1',
    I2C_SCLK => I2C_SCLK,
    I2C_SDAT => I2C_SDAT
  );



  process (CLOCK_50)
  begin
    if rising_edge(CLOCK_50) then
      if counter = '0' then
        reset_n <= '0';
      else
        reset_n <= '0';
        counter <= '1';
      end if;
    end if;
  end process;


  V1: de2_wm8731_audio port map (
    clk => audio_clock(1),
    reset_n => '1',
    test_mode => '1',                   -- Output a sine wave
    audio_request => audio_request,
    data => "0000000000000000",
  
    -- Audio interface signals
    AUD_ADCLRCK  => AUD_ADCLRCK,
    AUD_ADCDAT   => AUD_ADCDAT,
    AUD_DACLRCK  => AUD_DACLRCK,
    AUD_DACDAT   => AUD_DACDAT,
    AUD_BCLK     => AUD_BCLK,
	freq_in => freq,
	mod_depth_in=>mod_depth,
	on_off_in=>on_off
  );


  nios : entity work.nios_system port map (
    clk                          => CLOCK_50,
    reset_n                      => '1',
    SRAM_ADDR_from_the_sram      => SRAM_ADDR,
    SRAM_CE_N_from_the_sram      => SRAM_CE_N,
    SRAM_DQ_to_and_from_the_sram => SRAM_DQ,
    SRAM_LB_N_from_the_sram      => SRAM_LB_N,
    SRAM_OE_N_from_the_sram      => SRAM_OE_N,
    SRAM_UB_N_from_the_sram      => SRAM_UB_N,
    SRAM_WE_N_from_the_sram      => SRAM_WE_N,
    PS2_Data_to_the_ps2		=> PS2_DAT,
    PS2_Clk_to_the_ps2		=> PS2_CLK,
	VGA_BLANK_from_the_vga => VGA_BLANK,
	VGA_B_from_the_vga => VGA_B(9 downto 0),
    VGA_CLK_from_the_vga => VGA_CLK,
    VGA_G_from_the_vga => VGA_G(9 downto 0),
    VGA_HS_from_the_vga => VGA_HS,
    VGA_R_from_the_vga => VGA_R(9 downto 0),
    VGA_SYNC_from_the_vga => VGA_SYNC,
    VGA_VS_from_the_vga => VGA_VS,
    freq_from_the_audio => freq,
	mod_depth_from_the_audio => mod_depth,
	on_off_from_the_audio => on_off
    );

end rtl;
