library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    test_mode : in std_logic;       --    Audio CODEC controller test mode
    audio_request : out std_logic;  --    Audio controller request new data
    data : in unsigned(15 downto 0);
  
    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic;  --    Audio CODEC Bit-Stream Clock

	--info from software
	freq_in :in std_logic_vector(15 downto 0);
	mod_depth_in:in std_logic_vector(3 downto 0);
	on_off_in: in std_logic_vector(15 downto 0)
  );
end  de2_wm8731_audio;

architecture rtl of de2_wm8731_audio is     

--
--type rom_type is array (0 to 255) of unsigned (15 downto 0);
--constant ROM : rom_type :=
-- (
--"0111111111110101",
--"0111111111010111",
--"0111111110100110",
--"0111111101100001",
--"0111111100001000",
--"0111111010011100",
--"0111111000011100",
--"0111110110001001",
--"0111110011100010",
--"0111110000101001",
--"0111101101011100",
--"0111101001111100",
--"0111100110001001",
--"0111100010000011",
--"0111011101101011",
--"0111011001000000",
--"0111010100000011",
--"0111001110110101",
--"0111001001010100",
--"0111000011100001",
--"0110111101011110",
--"0110110111001001",
--"0110110000100011",
--"0110101001101100",
--"0110100010100101",
--"0110011011001110",
--"0110010011100111",
--"0110001011110001",
--"0110000011101011",
--"0101111011010110",
--"0101110010110011",
--"0101101010000001",
--"0101100001000010",
--"0101010111110100",
--"0101001110011010",
--"0101000100110011",
--"0100111010111111",
--"0100110000111111",
--"0100100110110011",
--"0100011100011100",
--"0100010001111010",
--"0100000111001101",
--"0011111100010110",
--"0011110001010110",
--"0011100110001100",
--"0011011010111001",
--"0011001111011110",
--"0011000011111011",
--"0010111000010000",
--"0010101100011110",
--"0010100000100110",
--"0010010100100111",
--"0010001000100011",
--"0001111100011001",
--"0001110000001011",
--"0001100011111000",
--"0001010111100001",
--"0001001011000111",
--"0000111110101011",
--"0000110010001011",
--"0000100101101010",
--"0000011001000111",
--"0000001100100100",
--"0000000000000000",
--"1111110011011100",
--"1111100110111001",
--"1111011010010110",
--"1111001101110101",
--"1111000001010101",
--"1110110100111001",
--"1110101000011111",
--"1110011100001000",
--"1110001111110101",
--"1110000011100111",
--"1101110111011101",
--"1101101011011001",
--"1101011111011010",
--"1101010011100010",
--"1101000111110000",
--"1100111100000101",
--"1100110000100010",
--"1100100101000111",
--"1100011001110100",
--"1100001110101010",
--"1100000011101010",
--"1011111000110011",
--"1011101110000110",
--"1011100011100100",
--"1011011001001101",
--"1011001111000001",
--"1011000101000001",
--"1010111011001101",
--"1010110001100110",
--"1010101000001100",
--"1010011110111110",
--"1010010101111111",
--"1010001101001101",
--"1010000100101010",
--"1001111100010101",
--"1001110100001111",
--"1001101100011001",
--"1001100100110010",
--"1001011101011011",
--"1001010110010100",
--"1001001111011101",
--"1001001000110111",
--"1001000010100010",
--"1000111100011111",
--"1000110110101100",
--"1000110001001011",
--"1000101011111101",
--"1000100111000000",
--"1000100010010101",
--"1000011101111101",
--"1000011001110111",
--"1000010110000100",
--"1000010010100100",
--"1000001111010111",
--"1000001100011110",
--"1000001001110111",
--"1000000111100100",
--"1000000101100100",
--"1000000011111000",
--"1000000010011111",
--"1000000001011010",
--"1000000000101001",
--"1000000000001011",
--"1000000000000001",
--"1000000000001011",
--"1000000000101001",
--"1000000001011010",
--"1000000010011111",
--"1000000011111000",
--"1000000101100100",
--"1000000111100100",
--"1000001001110111",
--"1000001100011110",
--"1000001111010111",
--"1000010010100100",
--"1000010110000100",
--"1000011001110111",
--"1000011101111101",
--"1000100010010101",
--"1000100111000000",
--"1000101011111101",
--"1000110001001011",
--"1000110110101100",
--"1000111100011111",
--"1001000010100010",
--"1001001000110111",
--"1001001111011101",
--"1001010110010100",
--"1001011101011011",
--"1001100100110010",
--"1001101100011001",
--"1001110100001111",
--"1001111100010101",
--"1010000100101010",
--"1010001101001101",
--"1010010101111111",
--"1010011110111110",
--"1010101000001100",
--"1010110001100110",
--"1010111011001101",
--"1011000101000001",
--"1011001111000001",
--"1011011001001101",
--"1011100011100100",
--"1011101110000110",
--"1011111000110011",
--"1100000011101010",
--"1100001110101010",
--"1100011001110100",
--"1100100101000111",
--"1100110000100010",
--"1100111100000101",
--"1101000111110000",
--"1101010011100010",
--"1101011111011010",
--"1101101011011001",
--"1101110111011101",
--"1110000011100111",
--"1110001111110101",
--"1110011100001000",
--"1110101000011111",
--"1110110100111001",
--"1111000001010101",
--"1111001101110101",
--"1111011010010110",
--"1111100110111001",
--"1111110011011100",
--"0000000000000000",
--"0000001100100100",
--"0000011001000111",
--"0000100101101010",
--"0000110010001011",
--"0000111110101011",
--"0001001011000111",
--"0001010111100001",
--"0001100011111000",
--"0001110000001011",
--"0001111100011001",
--"0010001000100011",
--"0010010100100111",
--"0010100000100110",
--"0010101100011110",
--"0010111000010000",
--"0011000011111011",
--"0011001111011110",
--"0011011010111001",
--"0011100110001100",
--"0011110001010110",
--"0011111100010110",
--"0100000111001101",
--"0100010001111010",
--"0100011100011100",
--"0100100110110011",
--"0100110000111111",
--"0100111010111111",
--"0101000100110011",
--"0101001110011010",
--"0101010111110100",
--"0101100001000010",
--"0101101010000001",
--"0101110010110011",
--"0101111011010110",
--"0110000011101011",
--"0110001011110001",
--"0110010011100111",
--"0110011011001110",
--"0110100010100101",
--"0110101001101100",
--"0110110000100011",
--"0110110111001001",
--"0110111101011110",
--"0111000011100001",
--"0111001001010100",
--"0111001110110101",
--"0111010100000011",
--"0111011001000000",
--"0111011101101011",
--"0111100010000011",
--"0111100110001001",
--"0111101001111100",
--"0111101101011100",
--"0111110000101001",
--"0111110011100010",
--"0111110110001001",
--"0111111000011100",
--"0111111010011100",
--"0111111100001000",
--"0111111101100001",
--"0111111110100110",
--"0111111111010111",
--"0111111111110101",
--"0111111111110101"
----"0111111111111111"
-- );
    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck  : std_logic;
    
    signal lrck_divider : unsigned(7 downto 0); 
    signal bclk_divider : unsigned(3 downto 0);
    
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal clr_bclk : std_logic;
    signal lrck_lat : std_logic;
    
    signal shift_out : unsigned(15 downto 0);

    signal sin_out     : unsigned(15 downto 0);
    signal sin_counter : unsigned(5 downto 0);    

	
	signal sin_counter2: unsigned (7 downto 0);
	signal ramp2	   : unsigned (15 downto 0):=x"0000";
	signal cos_table_en: std_logic;
	signal ramp_max: unsigned(15 downto 0):=x"ea60";
	signal ramp: unsigned(15 downto 0):=x"0000";
	signal frq_reg: unsigned(15 downto 0):=x"0000";
	signal mod_depth_reg : unsigned (3 downto 0):=x"0";
	signal frq:unsigned(15 downto 0);
	signal mod_depth:unsigned(3 downto 0);   
    shared variable counter:std_logic_vector(15 downto 0);
	shared variable cnt:unsigned(7 downto 0);
begin
  
    -- LRCK divider 
    -- Audio chip main clock is 18.432MHz / Sample rate 48KHz
    -- Divider is 18.432 MHz / 48KHz = 192 (X"C0")
    -- Left justify mode set by I2C controller
   
  process (clk)
  begin

    if rising_edge(clk) then

	  counter:=freq_in;
	  cnt:=unsigned(counter(7 downto 0));	
		
      if reset_n = '0' then 
        lrck_divider <= (others => '0');
      elsif lrck_divider = cnt  then        -- "C0" minus 1
        lrck_divider <= X"00";
      else 
        lrck_divider <= lrck_divider + 1;
      end if;
    end if;   
  end process;

  process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then 
        bclk_divider <= (others => '0');
      elsif bclk_divider = X"B" or set_lrck = '1'  then  
        bclk_divider <= X"0";
      else 
        bclk_divider <= bclk_divider + 1;
      end if;
    end if;
  end process;

  set_lrck <= '1' when lrck_divider = cnt else '0';
    
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        lrck <= '0';
      elsif set_lrck = '1' then 
        lrck <= not lrck;
      end if;
    end if;
  end process;
    
  -- BCLK divider
  set_bclk <= '1' when bclk_divider(3 downto 0) = "0101" else '0';
  clr_bclk <= '1' when bclk_divider(3 downto 0) = "1011" else '0';
  
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        bclk <= '0';
      elsif set_lrck = '1' or clr_bclk = '1' then
        bclk <= '0';
      elsif set_bclk = '1' then 
        bclk <= '1';
      end if;
    end if;
  end process;
  -- Audio data shift output
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        shift_out <= (others => '0');
      elsif set_lrck = '1' then
        if test_mode = '1' and on_off_in = X"1111" then 
          shift_out <= sin_out;
			
        else 
          shift_out <= data;
        end if;
      elsif clr_bclk = '1' then 
        shift_out <= shift_out (14 downto 0) & '0';
      end if;
    end if;   
  end process;

    -- Audio outputs
		
		AUD_ADCLRCK  <= lrck;          
		AUD_DACLRCK  <= lrck;          
		AUD_DACDAT   <= shift_out(15); 
		AUD_BCLK     <= bclk;          
		
		 -- Self test with Sin wave
    
    process(clk)      
    begin
      if rising_edge(clk) then
        if reset_n = '0' then 
            sin_counter <= (others => '0');
        elsif lrck_lat = '1' and lrck = '0'  then  
          if sin_counter = "101111" then 
            sin_counter <= "000000";
          else  
            sin_counter <= sin_counter + 1;
          end if;
        end if;
      end if;
    end process;

    process(clk)
    begin
      if rising_edge(clk) then
        lrck_lat <= lrck;
      end if;
    end process;

    process (clk) 
    begin
      if rising_edge(clk) then 
        if lrck_lat = '1' and lrck = '0' then
          audio_request <= '1';
        else 
          audio_request <= '0';
        end if;
      end if;
    end process;





--		process(clk)
--		begin
--			if rising_edge(clk) then
--				if reset_n = '0' then
--					ramp<=x"0000";
--				elsif ramp > ramp_max then ramp<=x"0000";--sin_counter<=x"00";
--				elsif lrck_lat = '1' and lrck = '0' then
--					ramp<=ramp+frq_reg;
--					sin_counter(7 downto 0) <= ramp(15 downto 8);
--				end if;	
--			end if;
--		end process;
--
--		process(clk)
--		begin
--			if rising_edge(clk) then
--				if reset_n = '0' then
--					ramp2 <= x"0000";
--				elsif ramp2 > ramp_max then ramp2<=x"0000";--sin_counter<=x"00";
--				elsif lrck_lat = '1' and lrck = '0' then
--					ramp2<=ramp2+frq_reg+frq_reg+frq_reg;
--					sin_counter2(7 downto 0) <= ramp2(15 downto 8);
--				end if;	
--			end if;
--		end process;
--
--		process(clk)
--		begin
--		  if rising_edge(clk) then
--			lrck_lat <= lrck;
--		  end if;
--		end process;
--
--		process (clk) 
--		begin
--		  if rising_edge(clk) then 
--			if lrck_lat = '1' and lrck = '0' then
--			  audio_request <= '1';
--			else 
--			  audio_request <= '0';
--			end if;
--		  end if;
--		end process;
--
--
--		sin_out <=  ROM ( to_integer(sin_counter) + 
--						  ((to_integer(mod_depth_reg )*  to_integer( ROM(to_integer(sin_counter2)))) mod 256 ));
--		 

  with sin_counter select sin_out <=
    X"0000" when "000000",
    X"10b4" when "000001",
    X"2120" when "000010",
    X"30fb" when "000011",
    X"3fff" when "000100",
    X"4deb" when "000101",
    X"5a81" when "000110",
    X"658b" when "000111",
    X"6ed9" when "001000",
    X"7640" when "001001",
    X"7ba2" when "001010",
    X"7ee6" when "001011",
    X"7fff" when "001100",
    X"7ee6" when "001101",
    X"7ba2" when "001110",
    X"7640" when "001111",
    X"6ed9" when "010000",
    X"658b" when "010001",
    X"5a81" when "010010",
    X"4deb" when "010011",
    X"3fff" when "010100",
    X"30fb" when "010101",
    X"2120" when "010110",
    X"10b4" when "010111",
    X"0000" when "011000",
    X"ef4b" when "011001",
    X"dee0" when "011010",
    X"cf05" when "011011",
    X"c001" when "011100",
    X"b215" when "011101",
    X"a57e" when "011110",
    X"9a74" when "011111",
    X"9127" when "100000",
    X"89bf" when "100001",
    X"845d" when "100010",
    X"8119" when "100011",
    X"8000" when "100100",
    X"8119" when "100101",
    X"845d" when "100110",
    X"89bf" when "100111",
    X"9127" when "101000",
    X"9a74" when "101001",
    X"a57e" when "101010",
    X"b215" when "101011",
    X"c000" when "101100",
    X"cf05" when "101101",
    X"dee0" when "101110",
    X"ef4b" when "101111",
    X"0000" when others;      

end architecture;


