-------------------------------------------------------------------------------
--
-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_vga_raster is
  
  port (
    reset 		: in std_logic;
    clk   		: in std_logic;                    -- Should be 25.125 MHz
    read       	: in  std_logic;
    write      	: in  std_logic;
    chipselect 	: in  std_logic;
    address    	: in  unsigned(15 downto 0);
    readdata   	: out unsigned(15 downto 0);
    writedata  	: in  unsigned(15 downto 0);

    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out unsigned(9 downto 0) -- Blue[9:0]
    );

end de2_vga_raster;

architecture rtl of de2_vga_raster is
  
  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;

  -- Space Invader Game Parameter

  constant HOME_VSTART 		: integer := 440; -- vertical starting position of home ship	
  constant SHIP_LENGTH 		: integer := 32; 	
  constant SHIP_WIDTH 		: integer := 32; 
  constant ALIEN_LENGTH 	: integer := 16; 	
  constant ALIEN_WIDTH 		: integer := 16;
  constant GAP_LENGTH 		: integer := 32;	
  constant GAP_WIDTH 		: integer := 16; 
  constant HOME_MISSILE_LENGTH : integer := 16; 
  constant HOME_MISSILE_WIDTH : integer := 2;	
  
  constant STAR_LENGTH 	    : integer := 16; 	
  constant STAR_WIDTH 		: integer := 16;
  constant STAR1_H_COORD    : integer := 70;
  constant STAR1_V_COORD    : integer := 90;
  constant STAR2_H_COORD    : integer := 156;
  constant STAR2_V_COORD    : integer := 300;
  constant STAR3_H_COORD    : integer := 228;
  constant STAR3_V_COORD    : integer := 450;
  constant STAR4_H_COORD    : integer := 280;
  constant STAR4_V_COORD    : integer := 50;
  constant STAR5_H_COORD    : integer := 390;
  constant STAR5_V_COORD    : integer := 200;
  constant STAR6_H_COORD    : integer := 400;
  constant STAR6_V_COORD    : integer := 400;
  constant STAR7_H_COORD    : integer := 500;
  constant STAR7_V_COORD    : integer := 33;
  constant STAR8_H_COORD    : integer := 460;
  constant STAR8_V_COORD    : integer := 103;
  constant STAR9_H_COORD    : integer := 580;
  constant STAR9_V_COORD    : integer := 300;
  constant STAR10_H_COORD    : integer := 600;
  constant STAR10_V_COORD    : integer := 420;
  constant STAR11_H_COORD    : integer := 170;
  constant STAR11_V_COORD    : integer := 190;
  constant STAR12_H_COORD    : integer := 20;
  constant STAR12_V_COORD    : integer := 500;
  constant STAR13_H_COORD    : integer := 128;
  constant STAR13_V_COORD    : integer := 450;
  constant STAR14_H_COORD    : integer := 180;
  constant STAR14_V_COORD    : integer := 50;
  constant STAR15_H_COORD    : integer := 290;
  constant STAR15_V_COORD    : integer := 200;
  constant STAR16_H_COORD    : integer := 275;
  constant STAR16_V_COORD    : integer := 90;
  constant STAR17_H_COORD    : integer := 345;
  constant STAR17_V_COORD    : integer := 300;
  
  constant NUM_ALIENS_PER_ROW: integer := 12;	
  constant NUM_ALIEN_ROWS 	: integer := 5;	

  constant TEXT_LENGTH 		: integer := 16; 	
  constant TEXT_WIDTH 		: integer := 80; 
  constant NUM_LENGTH 		: integer := 16; 	
  constant NUM_WIDTH 		: integer := 16; 	

  constant OFFSET_X 		: integer := 32; 	
  constant OFFSET_Y 		: integer := 32; 

  constant SCORE_X		: integer :=100;
  constant SCORE_Y		: integer :=20;

  constant TIMER_H_COORD    : integer := 520;
  constant TIMER_V_COORD    : integer := 64;
  constant TIMER_H_COORD_1  : integer := 536;
  constant TIMER_V_COORD_1  : integer := 80;  
  constant TIMER_H_COORD_2  : integer := 552;
  constant TIMER_V_COORD_2  : integer := 80;

  constant BARRICADE1_H_COORD: integer := 125;
  constant BARRICADE1_V_COORD: integer := 375;
  constant BARRICADE2_H_COORD: integer := 225;
  constant BARRICADE2_V_COORD: integer := 375;
  constant BARRICADE3_H_COORD: integer := 325;
  constant BARRICADE3_V_COORD: integer := 375;
  constant BARRICADE4_H_COORD: integer := 425;
  constant BARRICADE4_V_COORD: integer := 375;
  constant BARRICADE_LENGTH: integer := 32; 
  constant BARRICADE_WIDTH: integer := 32; 	
  constant NUM_H_BLOCKS_BARRICADE : integer := 4; 
  constant BARRICADE_BLOCK_LENGTH : integer := 2; 
  constant BARRICADE_BLOCK_WIDTH : integer := 8; 


  constant SCORE_H_COORD	: integer := 520;  
  constant SCORE_V_COORD	: integer := 20;
  constant NUM_DIGITS : integer := 5;
  constant SCORE_H_COORD_1	: integer := 520; 
  constant SCORE_V_COORD_1	: integer := 36; 
  constant SCORE_LENGTH : integer := 16; 
  constant SCORE_WIDTH : integer := 16; 
  constant SCORE_GAP : integer := 0; 

  constant LIVES_H_COORD	: integer := 10;
  constant LIVES_V_COORD	: integer := 20;
  constant LIVES_H_COORD_1	: integer := 18;
  constant LIVES_V_COORD_1	: integer := 36;
  constant LIVES_H_COORD_2	: integer := 42;
  constant LIVES_V_COORD_2	: integer := 36;
  constant LIVES_H_COORD_3	: integer := 66;
  constant LIVES_V_COORD_3	: integer := 36;

  -- Signals for the video controller

  signal clk25 : std_logic := '0';	
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;
  signal vga_hblank, vga_hsync, vga_vblank, vga_vsync : std_logic;  -- Sync. signals

  signal  pixel_set, home_bit, wave_bit, score_bit,
score_bit_1, barricade1_bit,barricade2_bit, barricade3_bit,barricade4_bit,star1_bit,star2_bit,star3_bit,star4_bit,
star5_bit,star6_bit,star7_bit,star8_bit,star9_bit,star10_bit,star11_bit,star12_bit,star13_bit,star14_bit,star15_bit,
star16_bit,star17_bit,homemissile_bit,timer_bit,timer_bit_1,timer_bit_2,timer_bit_3,timer_bit_4,intro_bit,game_over_bit,
lives_bit,lives_bit_1,lives_bit_2,lives_bit_3 : std_logic;

	type alien_missile_array is array(9 downto 0) of std_logic; 
	
    signal alienmissile_bits  : alien_missile_array;  

  --type ram_type is array(15 downto 0) of unsigned(15 downto 0);	
  --signal state_vector : ram_type ;	
  signal home_status	: std_logic;
  signal ram_address	: unsigned(15 downto 0);
  signal home_h_coord 	: unsigned(15 downto 0);
  signal home_h_coord_temp 	: unsigned(15 downto 0);

  --signal state : states;
  signal wave_h_coord 	: unsigned(15 downto 0);
  signal wave_v_coord 	: unsigned(15 downto 0);

  signal wave_h_coord_temp 	: unsigned(15 downto 0);
  signal wave_v_coord_temp 	: unsigned(15 downto 0);	
	
  signal wave_h_counter : integer := 0; 
  signal wave_v_counter : integer := 0;	
  
  signal alien_h_coord	: unsigned(15 downto 0); 
  signal alien_v_coord 	: unsigned(15 downto 0);
	
    
  signal score : unsigned(31 downto 0);
  type score_type is array(4 downto 0) of integer; 	
  signal score_array 	: score_type;
  signal lives1_num     : integer;
  signal lives2_num     : integer;
  signal lives3_num     : integer;
  signal timer1_num     : integer;
  signal timer2_num     : integer;
  signal timer3_num     : integer;
  signal timer4_num     : integer;
  
  
  signal star_h_coord	: unsigned(15 downto 0); 
  signal star_v_coord 	: unsigned(15 downto 0);  

  signal home_missile_x : integer; 
  signal home_missile_y : integer;		
  	
  signal home_missile_x_temp : integer; 
  signal home_missile_y_temp : integer;	
  

  type alien_missiles is array(9 downto 0) of integer; 
  signal alien_missile_x : alien_missiles; 
  signal alien_missile_y : alien_missiles; 	
  signal alien_missile_x_temp : alien_missiles; 
  signal alien_missile_y_temp : alien_missiles; 

  --type bit_status is array(59 downto 0) of std_logic;	
  --signal alien_status : bit_status;  
  signal alien_status_1 : unsigned(31 downto 0);
  signal alien_status_2 : unsigned(31 downto 0);	

--  type score_disp is array(15 downto 0) of unsigned(79 downto 0); 	
--  signal score_text : score_disp;
--  type lives_disp is array(15 downto 0) of unsigned(79 downto 0);
--  signal lives_text : lives_disp;  
  
  type disp is array(15 downto 0) of unsigned(79 downto 0); 	
  signal score_text : disp;
  signal timer_text : disp;
  signal lives_text : disp;

  signal score_row : unsigned (79 downto 0);	
  signal score_col : unsigned (79 downto 0);
  signal lives_row : unsigned (79 downto 0);
  signal lives_col : unsigned (79 downto 0);
  signal timer_row : unsigned (79 downto 0);
  signal counter:integer:=0;	

  signal lives_row_1 : unsigned (15 downto 0);
  signal lives_row_2 : unsigned (15 downto 0);
  signal lives_row_3 : unsigned (15 downto 0);
  signal timer_row_1 : unsigned (15 downto 0); 
  signal timer_row_2 : unsigned (15 downto 0);
  signal timer_row_3 : unsigned (15 downto 0);
  signal timer_row_4 : unsigned (15 downto 0);
  -----------------------------------

  type arr is array (29 downto 0) of integer;
  type matrix is array (15 downto 0,15 downto 0) of integer;

  type image_32_32 is array(31 downto 0) of unsigned(31 downto 0); 		
  signal home_ship : image_32_32;	

  type image_16_16 is array(15 downto 0) of unsigned(15 downto 0); 		
  signal alien_ship : image_16_16;
  signal alien_ship2: image_16_16;
  signal alien_explode:image_16_16;
  signal star_sprite: image_16_16;
  signal star_sprite2:image_16_16;
  signal lives_sprite:image_16_16;

  signal sprite_0, sprite_1, sprite_2, sprite_3, sprite_4, sprite_5, sprite_6, sprite_7, sprite_8, sprite_9 :image_16_16;
  signal home_ship_barricade : image_32_32;	
  
  type per_barricade_bits is array(63 downto 0) of std_logic; 	
  type barr_status_bits is array(3 downto 0) of per_barricade_bits; 
  signal barricade_status : barr_status_bits;
 
--------------------------------------------------

------------------------------------------------------------------------- 
--game state = 1:hello screen
--game state = 2:game in progress
--game state = 3:game over
  signal game_state : integer:=1;	

 type intro_array is array(86 downto 0) of unsigned(299 downto 0);
 signal intro: intro_array;
 signal intro_row:unsigned(299 downto 0);
 constant INTRO_H_COORD	: integer := 170;  
 constant INTRO_V_COORD	: integer := 120;



 type game_over_arr is array(39 downto 0) of unsigned(299 downto 0);
 signal game_over : game_over_arr;
 signal game_over_row:unsigned(299 downto 0);
 constant GAME_OVER_H_COORD: integer :=180;
 constant GAME_OVER_V_COORD: integer :=120;

--------------------------------------------------------------------------

begin

  -- Horizontal and vertical counters

 --home_h_coord <= to_unsigned(300,16); -- home ship location
 home_ship(0)  <= "00000000000000011000000000000000" ;
 home_ship(1)  <= "00000000000000111100000000000000" ;  
 home_ship(2)  <= "00000000000001111110000000000000" ;
 home_ship(3)  <= "00000000000011111111000000000000" ; 
 home_ship(4)  <= "00000000000111111111100000000000" ; 
 home_ship(5)  <= "00000000001110111101110000000000" ;
 home_ship(6)  <= "00000000011111000011111000000000" ;
 home_ship(7)  <= "00000000111111000011111100000000" ;
 home_ship(8)  <= "00000001111111100111111110000000" ;
 home_ship(9)  <= "00000011111111111111111111000000" ;
 home_ship(10) <= "00000111111011111111011111100000" ;
 home_ship(11) <= "00001111110011111111001111110000" ;
 home_ship(12) <= "00011111100111111111100111111000" ;
 home_ship(13) <= "00111111100111111111100111111100" ;
 home_ship(14) <= "01111111110011111111001111111110" ;
 home_ship(15) <= "11111111111111111111111111111111" ; 
 home_ship(16) <= "11111111111011111111011111111111" ;
 home_ship(17) <= "01111111110001111110001111111110" ;
 home_ship(18) <= "00111111100000111100000111111100" ;
 home_ship(19) <= "00011111000000011000000011111000" ;
 home_ship(20) <= "00001110000000000000000001110000" ;
 home_ship(21) <= "00000100000000000000000000100000" ;
 home_ship(22) <= "00000000000000000000000000000000" ;
 home_ship(23) <= "00000000000000000000000000000000" ; 
 home_ship(24) <= "00000000000000000000000000000000" ;
 home_ship(25) <= "00000000000000000000000000000000" ;
 home_ship(26) <= "00000000000000000000000000000000" ;
 home_ship(27) <= "00000000000000000000000000000000" ; 
 home_ship(28) <= "00000000000000000000000000000000" ;
 home_ship(29) <= "00000000000000000000000000000000" ;
 home_ship(30) <= "00000000000000000000000000000000" ;
 home_ship(31) <= "00000000000000000000000000000000" ; 
---------------------------------------------------------------

 alien_ship(0) <=  "0000011111100000" ;  
 alien_ship(1) <=  "0000111111110000" ; 
 alien_ship(2) <=  "0001111111111000" ;
 alien_ship(3) <=  "0011101111011100" ;
 alien_ship(4) <=  "0111000110001110" ;
 alien_ship(5) <=  "1111101111011111" ;
 alien_ship(6) <=  "1111111111111111" ;
 alien_ship(7) <=  "1111111111111111" ;
 alien_ship(8) <=  "0011000000001100" ;
 alien_ship(9) <=  "0011000000001100" ;
 alien_ship(10) <= "0000111111110000" ;
 alien_ship(11) <= "0000111111110000" ;
 alien_ship(12) <= "0011000000001100" ;
 alien_ship(13) <= "0011000000001100" ;
 alien_ship(14) <= "1100000000000011" ;
 alien_ship(15) <= "1100000000000011" ; 

 alien_ship2(0) <=  "0000011111100000" ;  
 alien_ship2(1) <=  "0000111111110000" ; 
 alien_ship2(2) <=  "0001111111111000" ;
 alien_ship2(3) <=  "0011101111011100" ;
 alien_ship2(4) <=  "0111000110001110" ;
 alien_ship2(5) <=  "1111101111011111" ;
 alien_ship2(6) <=  "1111111111111111" ;
 alien_ship2(7) <=  "1111111111111111" ;
 alien_ship2(8) <=  "1111111111111111" ;
 alien_ship2(9) <=  "1100000000000011" ;
 alien_ship2(10) <= "1100000000000011" ;
 alien_ship2(11) <= "1100000000000011" ;
 alien_ship2(12) <= "0110000000000110" ;
 alien_ship2(13) <= "0011000000001100" ;
 alien_ship2(14) <= "0001100000011000" ;
 alien_ship2(15) <= "0000110000110000" ;

 alien_explode(0) <=  "1000000100000001" ;  
 alien_explode(1) <=  "0100000010000010" ; 
 alien_explode(2) <=  "0010000100000100" ;
 alien_explode(3) <=  "0001000010001000" ;
 alien_explode(4) <=  "0000100100010000" ;
 alien_explode(5) <=  "0000010010100000" ;
 alien_explode(6) <=  "0000000100000000" ;
 alien_explode(7) <=  "1111110000111111" ;
 alien_explode(8) <=  "0000000000000000" ;
 alien_explode(9) <=  "0000010100100000" ;
 alien_explode(10) <= "0000100010010000" ;
 alien_explode(11) <= "0001000100001000" ;
 alien_explode(12) <= "0010000010000100" ;
 alien_explode(13) <= "0100000100000010" ;
 alien_explode(14) <= "1000000010000001" ;
 alien_explode(15) <= "0000000100000000" ; 

 star_sprite(0) <=  "0000000010000000" ;  
 star_sprite(1) <=  "0000000111000000" ; 
 star_sprite(2) <=  "0000000010000000" ;
 star_sprite(3) <=  "0000000000000000" ;
 star_sprite(4) <=  "0000000000000000" ;
 star_sprite(5) <=  "0000000000000000" ;
 star_sprite(6) <=  "0000000000000000" ;
 star_sprite(7) <=  "0000000000000000" ;
 star_sprite(8) <=  "0000000000000000" ;
 star_sprite(9) <=  "0000000000000000" ;
 star_sprite(10) <= "0000000000000000" ;
 star_sprite(11) <= "0000000000000000" ;
 star_sprite(12) <= "0000000000000000" ;
 star_sprite(13) <= "0000000000000000" ;
 star_sprite(14) <= "0000000000000000" ;
 star_sprite(15) <= "0000000000000000" ; 
 
 star_sprite2(0) <=  "0000000000000000" ;  
 star_sprite2(1) <=  "0000000000000000" ; 
 star_sprite2(2) <=  "0000000000000000" ;
 star_sprite2(3) <=  "0000000000000000" ;
 star_sprite2(4) <=  "0000000000000000" ;
 star_sprite2(5) <=  "0000000000000000" ;
 star_sprite2(6) <=  "0000000000000000" ;
 star_sprite2(7) <=  "0000000000000000" ;
 star_sprite2(8) <=  "0000000000000000" ;
 star_sprite2(9) <=  "0000000000000000" ;
 star_sprite2(10) <= "0000000000000000" ;
 star_sprite2(11) <= "0000000000000000" ;
 star_sprite2(12) <= "0000000000000000" ;
 star_sprite2(13) <= "0000000000000000" ;
 star_sprite2(14) <= "0000000000000000" ;
 star_sprite2(15) <= "0000000000000000" ;
----------------------------------------------------------------------------------------------------
 lives_sprite(0) <=  "0000000110000000" ;  
 lives_sprite(1) <=  "0000001111000000" ; 
 lives_sprite(2) <=  "0000011111100000" ;
 lives_sprite(3) <=  "0000110110110000" ;
 lives_sprite(4) <=  "0001111001111000" ;
 lives_sprite(5) <=  "0010011111001100" ;
 lives_sprite(6) <=  "0110111111101110" ;
 lives_sprite(7) <=  "1110011111001111" ;
 lives_sprite(8) <=  "1111111111111111" ;
 lives_sprite(9) <=  "1111101111011111" ;
 lives_sprite(10) <= "0111000110001110" ;
 lives_sprite(11) <= "0010000000000100" ;
 lives_sprite(12) <= "0000000000000000" ;
 lives_sprite(13) <= "0000000000000000" ;
 lives_sprite(14) <= "0000000000000000" ;
 lives_sprite(15) <= "0000000000000000" ;
----------------------------------------------------------------------------------------------------
score_text( 0) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
score_text( 1) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
score_text( 2) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
score_text( 3) <= "00001111111110000000111111111000000011111111000000001111111100000001111111111000";
score_text( 4) <= "00011111111110000001111111111000000111111111100000011111111110000001111111111000";
score_text( 5) <= "00011000000000000001100000000000000110000001100000011000000110000001100000000000";
score_text( 6) <= "00011000000000000001100000000000000110000001100000011000000110000001100000000000";
score_text( 7) <= "00011111111110000001100000000000000110000001100000011111111110000001111111111000";
score_text( 8) <= "00001111111110000001100000000000000110000001100000011111111110000001111111111000";
score_text( 9) <= "00000000000110000001100000000000000110000001100000011001110000000001100000000000";
score_text(10) <= "00000000000110000001100000000000000110000001100000011000111000000001100000000000";
score_text(11) <= "00011111111110000001111111111000000111111111100000011000011100000001111111111000";
score_text(12) <= "00011111111100000000111111111000000011111111000000011000001110000001111111111000";
score_text(13) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
score_text(14) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
score_text(15) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
-----------------------------------------------------------------------------------------------------
lives_text( 0) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
lives_text( 1) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
lives_text( 2) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
lives_text( 3) <= "00000011000000000001111111111000000110000011000001111111110000000111111111000000";
lives_text( 4) <= "00000011000000000001111111111000000110000011000001111111110000001111111111000000";
lives_text( 5) <= "00000011000000000000000110000000000110000011000001100000000000001100000000000000";
lives_text( 6) <= "00000011000000000000000110000000000011000110000001100000000000001100000000000000";
lives_text( 7) <= "00000011000000000000000110000000000011000110000001111111110000001111111111000000";
lives_text( 8) <= "00000011000000000000000110000000000011000110000001111111110000000111111111000000";
lives_text( 9) <= "00000011000000000000000110000000000001101100000001100000000000000000000011000000";
lives_text(10) <= "00000011000000000000000110000000000001101100000001100000000000000000000011000000";
lives_text(11) <= "00000011111111100001111111111000000001101100000001111111110000001111111111000000";
lives_text(12) <= "00000011111111100001111111111000000000111000000001111111110000001111111110000000";
lives_text(13) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
lives_text(14) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
lives_text(15) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";


-----------------------------------------------------------------------------------------------------
timer_text( 0) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
timer_text( 1) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
timer_text( 2) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
timer_text( 3) <= "00000011000000000001111111111100000110000011000001111111110000011000000000000000";
timer_text( 4) <= "00000011000000000001111111111100000110000011000001111111110000011000000000000000";
timer_text( 5) <= "00000011000000000001100000000000000110000011000001100000000000011000000000000000";
timer_text( 6) <= "00000011000000000001100000000000000011000110000001100000000000011000000000000000";
timer_text( 7) <= "00000011000000000001111111111100000011000110000001111111110000011000000000000000";
timer_text( 8) <= "00000011000000000001111111111100000011000110000001111111110000011000000000000000";
timer_text( 9) <= "00000011000000000001100000000000000001101100000001100000000000011000000000000000";
timer_text(10) <= "00000011000000000001100000000000000001101100000001100000000000011000000000000000";
timer_text(11) <= "00000011111111100001111111111100000001101100000001111111110000011111111100000000";
timer_text(12) <= "00000011111111100001111111111100000000111000000001111111110000011111111100000000";
timer_text(13) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
timer_text(14) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
timer_text(15) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000";



-----------------------------------------------------------------------------------------------------
sprite_0( 0) <= "0000000000000000";
sprite_0( 1) <= "0000000000000000";
sprite_0( 2) <= "0000000000000000";
sprite_0( 3) <= "0000111111110000";
sprite_0( 4) <= "0001111111111000";
sprite_0( 5) <= "0001100000011000";
sprite_0( 6) <= "0001100000011000";
sprite_0( 7) <= "0001100000011000";
sprite_0( 8) <= "0001100000011000";
sprite_0( 9) <= "0001100000011000";
sprite_0(10) <= "0001100000011000";
sprite_0(11) <= "0001111111111000";
sprite_0(12) <= "0000111111110000";
sprite_0(13) <= "0000000000000000";
sprite_0(14) <= "0000000000000000";
sprite_0(15) <= "0000000000000000";

sprite_1( 0) <= "0000000000000000";
sprite_1( 1) <= "0000000000000000";
sprite_1( 2) <= "0000000000000000";
sprite_1( 3) <= "0000001111000000";
sprite_1( 4) <= "0000011111000000";
sprite_1( 5) <= "0000111111000000";
sprite_1( 6) <= "0000000111000000";
sprite_1( 7) <= "0000000111000000";
sprite_1( 8) <= "0000000111000000";
sprite_1( 9) <= "0000000111000000";
sprite_1(10) <= "0000000111000000";
sprite_1(11) <= "0000000111000000";
sprite_1(12) <= "0000000111000000";
sprite_1(13) <= "0000000000000000";
sprite_1(14) <= "0000000000000000";
sprite_1(15) <= "0000000000000000";

sprite_2( 0) <= "0000000000000000";
sprite_2( 1) <= "0000000000000000";
sprite_2( 2) <= "0000000000000000";
sprite_2( 3) <= "0000111111110000";
sprite_2( 4) <= "0001111111111000";
sprite_2( 5) <= "0001110000111000";
sprite_2( 6) <= "0000000000111000";
sprite_2( 7) <= "0000000001110000";
sprite_2( 8) <= "0000000011100000";
sprite_2( 9) <= "0000000111000000";
sprite_2(10) <= "0000001110000000";
sprite_2(11) <= "0000111111111000";
sprite_2(12) <= "0001111111111000";
sprite_2(13) <= "0000000000000000";
sprite_2(14) <= "0000000000000000";
sprite_2(15) <= "0000000000000000";

sprite_3( 0) <= "0000000000000000";
sprite_3( 1) <= "0000000000000000";
sprite_3( 2) <= "0000000000000000";
sprite_3( 3) <= "0000111111110000";
sprite_3( 4) <= "0001111111111000";
sprite_3( 5) <= "0001100000011000";
sprite_3( 6) <= "0000000000011000";
sprite_3( 7) <= "0000000111110000";
sprite_3( 8) <= "0000000111110000";
sprite_3( 9) <= "0000000000011000";
sprite_3(10) <= "0001100000011000";
sprite_3(11) <= "0001111111111000";
sprite_3(12) <= "0000111111110000";
sprite_3(13) <= "0000000000000000";
sprite_3(14) <= "0000000000000000";
sprite_3(15) <= "0000000000000000";

sprite_4( 0) <= "0000000000000000";
sprite_4( 1) <= "0000000000000000";
sprite_4( 2) <= "0000000000000000";
sprite_4( 3) <= "0000000011111000";
sprite_4( 4) <= "0000000111111000";
sprite_4( 5) <= "0000001110011000";
sprite_4( 6) <= "0000011100011000";
sprite_4( 7) <= "0000111000011000";
sprite_4( 8) <= "0001111111111100";
sprite_4( 9) <= "0001111111111100";
sprite_4(10) <= "0000000000011000";
sprite_4(11) <= "0000000000011000";
sprite_4(12) <= "0000000000011000";
sprite_4(13) <= "0000000000000000";
sprite_4(14) <= "0000000000000000";
sprite_4(15) <= "0000000000000000";

sprite_5( 0) <= "0000000000000000";
sprite_5( 1) <= "0000000000000000";
sprite_5( 2) <= "0000000000000000";
sprite_5( 3) <= "0001111111111000";
sprite_5( 4) <= "0001111111111000";
sprite_5( 5) <= "0001100000000000";
sprite_5( 6) <= "0001100000000000";
sprite_5( 7) <= "0001111111110000";
sprite_5( 8) <= "0001111111111000";
sprite_5( 9) <= "0000000000011000";
sprite_5(10) <= "0001100000011000";
sprite_5(11) <= "0001111111111000";
sprite_5(12) <= "0000111111110000";
sprite_5(13) <= "0000000000000000";
sprite_5(14) <= "0000000000000000";
sprite_5(15) <= "0000000000000000";

sprite_6( 0) <= "0000000000000000";
sprite_6( 1) <= "0000000000000000";
sprite_6( 2) <= "0000000000000000";
sprite_6( 3) <= "0000111111110000";
sprite_6( 4) <= "0001111111111000";
sprite_6( 5) <= "0001100000011000";
sprite_6( 6) <= "0001100000000000";
sprite_6( 7) <= "0001111111110000";
sprite_6( 8) <= "0001111111111000";
sprite_6( 9) <= "0001100000011000";
sprite_6(10) <= "0001100000011000";
sprite_6(11) <= "0001111111111000";
sprite_6(12) <= "0000111111110000";
sprite_6(13) <= "0000000000000000";
sprite_6(14) <= "0000000000000000";
sprite_6(15) <= "0000000000000000";

sprite_7( 0) <= "0000000000000000";
sprite_7( 1) <= "0000000000000000";
sprite_7( 2) <= "0000000000000000";
sprite_7( 3) <= "0001111111111000";
sprite_7( 4) <= "0001111111111000";
sprite_7( 5) <= "0000000001110000";
sprite_7( 6) <= "0000000001110000";
sprite_7( 7) <= "0000000011100000";
sprite_7( 8) <= "0000000011100000";
sprite_7( 9) <= "0000000111000000";
sprite_7(10) <= "0000000111000000";
sprite_7(11) <= "0000001110000000";
sprite_7(12) <= "0000001110000000";
sprite_7(13) <= "0000000000000000";
sprite_7(14) <= "0000000000000000";
sprite_7(15) <= "0000000000000000";

sprite_8( 0) <= "0000000000000000";
sprite_8( 1) <= "0000000000000000";
sprite_8( 2) <= "0000000000000000";
sprite_8( 3) <= "0000111111110000";
sprite_8( 4) <= "0001111111111000";
sprite_8( 5) <= "0001100000011000";
sprite_8( 6) <= "0001100000011000";
sprite_8( 7) <= "0000111111110000";
sprite_8( 8) <= "0000111111110000";
sprite_8( 9) <= "0001100000011000";
sprite_8(10) <= "0001100000011000";
sprite_8(11) <= "0001111111111000";
sprite_8(12) <= "0000111111110000";
sprite_8(13) <= "0000000000000000";
sprite_8(14) <= "0000000000000000";
sprite_8(15) <= "0000000000000000";

sprite_9( 0) <= "0000000000000000";
sprite_9( 1) <= "0000000000000000";
sprite_9( 2) <= "0000000000000000";
sprite_9( 3) <= "0000111111110000";
sprite_9( 4) <= "0001111111111000";
sprite_9( 5) <= "0001100000011000";
sprite_9( 6) <= "0001100000011000";
sprite_9( 7) <= "0001111111111000";
sprite_9( 8) <= "0000111111111000";
sprite_9( 9) <= "0000000000011000";
sprite_9(10) <= "0001100000011000";
sprite_9(11) <= "0001111111111000";
sprite_9(12) <= "0000111111110000";
sprite_9(13) <= "0000000000000000";
sprite_9(14) <= "0000000000000000";
sprite_9(15) <= "0000000000000000";
----------------------------------------------------------------
 home_ship_barricade(0) <=  "11111111000001111100000111111111" ;  
 home_ship_barricade(1) <=  "11111111000001111100000111111111" ; 
 home_ship_barricade(2) <=  "11111111000001111100000111111111" ;
 home_ship_barricade(3) <=  "11111111000001111100000111111111" ;
 home_ship_barricade(4) <=  "11111111000001111100000111111111" ;
 home_ship_barricade(5) <=  "11111111000001111100000111111111" ;
 home_ship_barricade(6) <=  "11111111111111111111111111111111" ;
 home_ship_barricade(7) <=  "11111111111111111111111111111111" ;
 home_ship_barricade(8) <=  "11111111111111111111111111111111" ;
 home_ship_barricade(9) <=  "11111111111110000011111111111111" ;
 home_ship_barricade(10) <= "11111111111110000011111111111111" ;
 home_ship_barricade(11) <= "11111111111110000011111111111111" ;
 home_ship_barricade(12) <= "11111111111110000011111111111111" ;
 home_ship_barricade(13) <= "11111111111111111111111111111111" ;
 home_ship_barricade(14) <= "11111111111111111111111111111111" ;
 home_ship_barricade(15) <= "11111111111111111111111111111111" ;
 home_ship_barricade(16) <= "11111111111111111111111111111111" ;
 home_ship_barricade(17) <= "11111111111110000011111111111111" ;
 home_ship_barricade(18) <= "11111111111110000011111111111111" ;
 home_ship_barricade(19) <= "11111111111110000011111111111111" ;
 home_ship_barricade(20) <= "11111111111110000011111111111111" ;
 home_ship_barricade(21) <= "11111111111111111111111111111111" ;
 home_ship_barricade(22) <= "11111111111111111111111111111111" ;
 home_ship_barricade(23) <= "11111111111111111111111111111111" ;
 home_ship_barricade(24) <= "11111111111111111111111111111111" ;
 home_ship_barricade(25) <= "11111111111111111111111111111111" ;
 home_ship_barricade(26) <= "11111111111111111111111111111111" ;
 home_ship_barricade(27) <= "11111111111111111111111111111111" ;
 home_ship_barricade(28) <= "11111111111111111111111111111111" ;
 home_ship_barricade(29) <= "11111111111111111111111111111111" ;
 home_ship_barricade(30) <= "11111111111111111111111111111111" ;
 home_ship_barricade(31) <= "11111111111111111111111111111111" ;


----------------------------------------------------------------

-----------------------------------------------------------------------------------------------------

intro(0)<=   "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(1)<=   "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(2)<=   "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(3)<=   "000000000011111111111111110000001111000000000000000000111100000000000000000000000000011111111111111111110000001111100000000011110000001111000000000000001111000000111111111111111100000011111111111111111000000000011111111111111111110000001111111111111111100000001111111111111111100000000000000000000000";
intro(4)<=   "000000000011111111111111110000001111000000000000000000111100000000000000000000000000011111111111111111110000001111110000000011110000000111100000000000011110000000111111111111111100000011111111111111111100000000011111111111111111110000001111111111111111100000001111111111111111100000000000000000000000";
intro(5)<=   "000000000011100000000001110000001111000000000000000000111100000000000000000000000000000000001111100000000000001111111100000011110000000011110000000000111100000000111000000000011100000011100000000000001110000000011100000000000000000000001110000000000011100000001110000000000000000000000000000000000000";
intro(6)<=   "000000000011100000000001110000001111000000000000000000111100000000000000000000000000000000001111100000000000001111100111000011110000000001111000000001111000000000111000000000011100000011100000000000001110000000011100000000000000000000001110000000000011100000001110000000000000000000000000000000000000";
intro(7)<=   "000000000011111111111111110000001111000000000000000000111100000000000000000000000000000000001111100000000000001111100011100011110000000000111100000011110000000000111111111111111100000011100000000000000111000000011111111111111000000000001111111111111111100000001111111111111111100000000000000000000000";
intro(8)<=   "000000000011111111111111110000001111000000000000000000111100000000000000000000000000000000001111100000000000001111100001110011110000000000011110000111100000000000111111111111111100000011100000000000000011100000011111111111111000000000001111111111111111100000001111111111111111100000000000000000000000";
intro(9)<=   "000000000011100000000001110000001111000000000000000000111100000000000000000000000000000000001111100000000000001111100000111011110000000000011111111111000000000000111000000000011100000011100000000000001110000000011100000000000000000000001110000001110000000000000000000000000011100000000000000000000000";
intro(10)<=  "000000000011100000000001110000001111000000000000000000111100000000000000000000000000000000001111100000000000001111100000011111110000000000000111111100000000000000111000000000011100000011100000000000001110000000011100000000000000000000001110000000111000000000000000000000000011100000000000000000000000";
intro(11)<=  "000000000011100000000001110000001111111111111111000000111111111111111100000000000000011111111111111111110000001111100000001111110000000000000011111100000000000000111000000000011100000011111111111111111100000000011111111111111111110000001110000000011100000000001111111111111111100000000000000000000000";
intro(12)<=  "000000000011100000000001110000001111111111111111000000111111111111111100000000000000011111111111111111110000001111100000000111110000000000000011111100000000000000111000000000011100000011111111111111111100000000011111111111111111110000001110000000001111100000001111111111111111100000000000000000000000";
intro(13)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(14)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(15)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(16)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(17)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(18)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111110000001111111111111111100000011111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(19)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111110000001111111111111111100000011111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(20)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000001110000001110000000000011100000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(21)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000001110000001110000000000011100000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(22)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111110000001111111111111111100000011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(23)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111110000001111111111111111100000011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(24)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000001110000001110000001110000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(25)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000001110000001110000000111000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(26)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000001110000001110000000001110000000011111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(27)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000001110000001110000000000111100000011111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(28)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(29)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(30)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(31)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(32)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(33)<=  "000000000000000000000111111111111111100000011111111111111110000001111000000000000000000111111111111111100000011111100000001111100000011111111111111111000000000000000111111111111111111110000001111111111111111000000000000001110000000000001110000001111111111111111100000000000000000000000000000000000000";
intro(34)<=  "000000000000000000000111111111111111100000011111111111111110000001111000000000000000000111111111111111100000011111110000001111100000011111111111111111000000000000000111111111111111111110000001111111111111111000000000000001110000000000001110000001111111111111111100000000000000000000000000000000000000";
intro(35)<=  "000000000000000000000111000000000011100000011100000000000000000001111000000000000000000111000000000011100000011111011100001111100000011100000000000000000000000000000000000011111100000000000001110000000000111000000000000001110000000000001110000001110000000000000000000000000000000000000000000000000000";
intro(36)<=  "000000000000000000000111000000000011100000011100000000000000000001111000000000000000000111000000000011100000011111001110001111100000011100000000000000000000000000000000000011111100000000000001110000000000111000000000000001110000000000001110000001110000000000000000000000000000000000000000000000000000";
intro(37)<=  "000000000000000000000111111111111111100000011111111111100000000001111000000000000000000111000000000011100000011111000111001111100000011100000001111111000000000000000000000011111100000000000001110000000000111000000000000001110000000000001110000001111111111111111100000000000000000000000000000000000000";
intro(38)<=  "000000000000000000000111111111111111100000011111111111100000000001111000000000000000000111000000000011100000011111000011101111100000011100000001111111000000000000000000000011111100000000000001110000000000111000000000000001110000000000001110000001111111111111111100000000000000000000000000000000000000";
intro(39)<=  "000000000000000000000111000000000011100000011100000000000000000001111000000000000000000111000000000011100000011111000001111111100000011100000000000111000000000000000000000011111100000000000001110000000000111000000000000001110000000000001110000000000000000000011100000000000000000000000000000000000000";
intro(40)<=  "000000000000000000000111000000000011100000011100000000000000000001111000000000000000000111000000000011100000011111000000111111100000011100000000000111000000000000000000000011111100000000000001110000000000111000000000000001110000000000001110000000000000000000011100000000000000000000000000000000000000";
intro(41)<=  "000000000000000000000111111111111111100000011111111111111110000001111111111111111000000111111111111111100000011111000000011111100000011111111111111111000000000000000000000011111100000000000001111111111111111000000000000001111111111111111110000001111111111111111100000000000000000000000000000000000000";
intro(42)<=  "000000000000000000000111111111111111100000011111111111111110000001111111111111111000000111111111111111100000011111000000001111100000011111111111111111000000000000000000000011111100000000000001111111111111111000000000000001111111111111111110000001111111111111111100000000000000000000000000000000000000";
intro(43)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(44)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(45)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(46)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(47)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(48)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(49)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(50)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(51)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(52)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(53)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(54)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(55)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(56)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(57)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(58)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(59)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(60)<=  "000000000000000000000000000000000000000000000000001111111111111111100000011111111111111110000001111000000000000001111000000111111111111111100000000000000000111111111111111111000000001110000000000001110000000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(61)<=  "000000000000000000000000000000000000000000000000001111111111111111100000011111111111111110000000111100000000000011110000000111111111111111100000000000000000111111111111111111000000001110000000000001110000000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(62)<=  "000000000000000000000000000000000000000000000000001110000000000000000000011100000000001110000000011110000000000111100000000111000000000000000000000000000000000000111111000000000000001110000000000001110000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(63)<=  "000000000000000000000000000000000000000000000000001110000000000000000000011100000000001110000000001111000000001111000000000111000000000000000000000000000000000000111111000000000000001110000000000001110000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(64)<=  "000000000000000000000000000000000000000000000000001111111111111111100000011111111111111110000000000111100000011110000000000111111111111000000000000000000000000000111111000000000000001111111111111111110000000011111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(65)<=  "000000000000000000000000000000000000000000000000001111111111111111100000011111111111111110000000000011110000111100000000000111111111111000000000000000000000000000111111000000000000001111111111111111110000000011111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(66)<=  "000000000000000000000000000000000000000000000000000000000000000011100000011100000000001110000000000001110000111000000000000111000000000000000000000000000000000000111111000000000000001110000000000001110000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(67)<=  "000000000000000000000000000000000000000000000000000000000000000011100000011100000000001110000000000000111111110000000000000111000000000000000000000000000000000000111111000000000000001110000000000001110000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(68)<=  "000000000000000000000000000000000000000000000000001111111111111111100000011100000000001110000000000000011111100000000000000111111111111111100000000000000000000000111111000000000000001110000000000001110000000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(69)<=  "000000000000000000000000000000000000000000000000001111111111111111100000011100000000001110000000000000001111000000000000000111111111111111100000000000000000000000111111000000000000001110000000000001110000000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(70)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(71)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(72)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(73)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(74)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(75)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(76)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110000001111000000000000000000111111111111111100000011111100000001111100000011111111111111110000001111111111111111111000000001111111111111111100000000000000000000000000000000000000000000000000000000000000000000";
intro(77)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110000001111000000000000000000111111111111111100000011111110000001111100000011111111111111110000001111111111111111111000000001111111111111111100000000000000000000000000000000000000000000000000000000000000000000";
intro(78)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111000000000001110000001111000000000000000000111000000000011100000011111011100001111100000011100000000000000000000000000111110000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000";
intro(79)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111000000000001110000001111000000000000000000111000000000011100000011111001110001111100000011100000000000000000000000000111110000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000";
intro(80)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110000001111000000000000000000111111111111111100000011111000111001111100000011111111110000000000000000000111110000000000000000000111111111111100000000000000000000000000000000000000000000000000000000000000000000";
intro(81)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110000001111000000000000000000111111111111111100000011111000011101111100000011111111110000000000000000000111110000000000000000000111111111111100000000000000000000000000000000000000000000000000000000000000000000";
intro(82)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000001111000000000000000000111000000000011100000011111000001111111100000011100000000000000000000000000111110000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(83)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000001111000000000000000000111000000000011100000011111000000111111100000011100000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(84)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000001111111111111111000000111000000000011100000011111000000011111100000011111111111111110000000000000111110000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(85)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000001111111111111111000000111000000000011100000011111000000000111100000011111111111111110000000000000111110000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000";
intro(86)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";



game_over(0)<=   "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(1)<=   "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(2)<=   "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(3)<=   "000000000001111111111111111110000000111111111111111110000001111111111111111100000011111111111111111000000000000000000111111111111111110000001111000000000000001111000000111111111111111110000001111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(4)<=   "000000000001111111111111111110000000111111111111111110000001111111111111111100000011111111111111111000000000000000000111111111111111110000000111100000000000011110000000111111111111111110000001111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(5)<=   "000000000001110000000000000000000000111000000000001110000001110000111000011100000011100000000000000000000000000000000111000000000001110000000011110000000000111100000000111000000000000000000001110000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(6)<=   "000000000001110000000000000000000000111000000000001110000001110000111000011100000011100000000000000000000000000000000111000000000001110000000001111000000001111000000000111000000000000000000001110000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(7)<=   "000000000001110000000011111110000000111111111111111110000001110000111000011100000011111111111000000000000000000000000111000000000001110000000000111100000011110000000000111111111100000000000001111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(8)<=   "000000000001110000000011111110000000111111111111111110000001110000111000011100000011111111111000000000000000000000000111000000000001110000000000011110000111100000000000111111111100000000000001111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(9)<=   "000000000001110000000000001110000000111000000000001110000001110000000000011100000011100000000000000000000000000000000111000000000001110000000000001111001111000000000000111000000000000000000001110000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(10)<=  "000000000001110000000000001110000000111000000000001110000001110000000000011100000011100000000000000000000000000000000111000000000001110000000000000111111110000000000000111000000000000000000001110000000011100000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(11)<=  "000000000001111111111111111110000000111000000000001110000001110000000000011100000011111111111111111000000000000000000111111111111111110000000000000011111110000000000000111111111111111110000001110000000000111000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(12)<=  "000000000001111111111111111110000000111000000000001110000001110000000000011100000011111111111111111000000000000000000111111111111111110000000000000001111100000000000000111111111111111110000001110000000000011110000000001111000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(13)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(14)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(15)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(16)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(17)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(18)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(19)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001110000000000000111000000111111111111111111100000011111111111111111100000011111100000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(20)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001110000000000000111000000111111111111111111100000011111111111111111100000011111100000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(21)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001110000000000000111000000111000001110000011100000011100000000000011100000011101110000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(22)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001110000000000000111000000111000001110000011100000011100000000000011100000011100111000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(23)<=  "000000000000000000000000000000000000000000000000111111111111111111110000001110000000000000111000000111000001110000011100000011111111111111111100000011100011100000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(24)<=  "000000000000000000000000000000000000000000000000111111111111111111110000001110000000000000111000000111000001110000011100000011111111111111111100000011100001110000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(25)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001110000000000000111000000111000000000000011100000011100000000000011100000011100000111000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(26)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001110000000000000111000000111000000000000011100000011100000000000011100000011100000011100001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(27)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001110000000000000111000000111000000000000011100000011100000000000011100000011100000001110001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(28)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001111111111111111111000000111000000000000011100000011100000000000011100000011100000000111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(29)<=  "000000000000000000000000000000000000000000000000111000000000000001110000001111111111111111111000000111000000000000011100000011100000000000011100000011100000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(30)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(31)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(32)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(33)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(34)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(35)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(36)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(37)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(38)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
game_over(39)<=  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";




-----------------------------------------------------------------------------------------------------  
  
process (clk)
  begin
    if rising_edge(clk) then
      clk25 <= not clk25;
    end if;
  end process;

  HCounter : process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        Hcount <= (others => '0');
	  elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        Vcount <= (others => '0');
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount <= (others => '0');
        else
          Vcount <= Vcount + 1;
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then     
      if reset = '1' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
		wave_h_coord <= wave_h_coord_temp; 
		home_h_coord <= home_h_coord_temp;
		
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then    
      if reset = '1' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0'; 	
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
          wave_v_coord <= wave_v_coord_temp;
          home_missile_x <= home_missile_x_temp;
          home_missile_y <= home_missile_y_temp;
		  alien_missile_x(0) <= alien_missile_x_temp(0) ;  
		  alien_missile_y(0) <= alien_missile_y_temp(0) ; 
		  alien_missile_x(1) <= alien_missile_x_temp(1) ;
		  alien_missile_y(1) <= alien_missile_y_temp(1) ;
		  alien_missile_x(2) <= alien_missile_x_temp(2) ;
		  alien_missile_y(2) <= alien_missile_y_temp(2) ;
		  alien_missile_x(3) <=	alien_missile_x_temp(3) ;
		  alien_missile_y(3) <= alien_missile_y_temp(3) ;
		  alien_missile_x(4) <= alien_missile_x_temp(4) ;
		  alien_missile_y(4) <= alien_missile_y_temp(4) ;
		  alien_missile_x(5) <= alien_missile_x_temp(5) ;
		  alien_missile_y(5) <= alien_missile_y_temp(5) ;
		  alien_missile_x(6) <=	alien_missile_x_temp(6) ;
		  alien_missile_y(6) <=	alien_missile_y_temp(6) ;
		  alien_missile_x(7) <=	alien_missile_x_temp(7) ;
		  alien_missile_y(7) <=	alien_missile_y_temp(7) ;
		  alien_missile_x(8) <=	alien_missile_x_temp(8) ;
		  alien_missile_y(8) <=	alien_missile_y_temp(8) ;
		  alien_missile_x(9) <=	alien_missile_x_temp(9) ;
		  alien_missile_y(9) <=	alien_missile_y_temp(9) ;	
        end if;
      end if;
    end if;
  end process VBlankGen;

---------------------------------------------------------------------------------------------------  		
DrawHomeShip : process (clk25 )

variable home_h_counter: integer := 0; 
variable home_v_counter : integer := 0; 
variable home_row : unsigned (31 downto 0);
	
begin
	if rising_edge(clk25) and game_state=2 then
	  if home_status = '1' then
		if EndOfLine = '1' then 
			if ( home_v_counter > 0 ) then
				home_v_counter := home_v_counter + 1;
			end if;
			if Vcount = VSYNC + VBACK_PORCH - 1 + HOME_VSTART then
				home_v_counter := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + HOME_VSTART + SHIP_LENGTH-1 then
				home_v_counter := 0;
			end if; 
			
		end if;
			
		if ( home_h_counter > 0 ) then
			home_h_counter := home_h_counter + 1;
		end if;
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + home_h_coord then
			home_h_counter := 1;
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + home_h_coord + SHIP_WIDTH - 1 then
			home_h_counter := 0;
		end if;	
		 
		if (( home_h_counter > 0 ) and (home_v_counter > 0)) then		 
			home_row := home_ship(home_v_counter-1);
			home_bit <= home_row(SHIP_WIDTH-home_h_counter);	
		else
			home_bit <= '0';
		end if;
	  end if; 
	end if;
end process DrawHomeShip;	

---------------------------------------------------------------------------------------------------  	


---------------------------------------------------------------------------------------------------
DrawAlien1 : process (clk25)
--variable count:integer:=0;
variable alien_h_counter: integer := 0; 
variable alien_v_counter : integer := 0; 
variable alien_row : unsigned (15 downto 0);
variable gap_h_counter: integer := 0;
variable gap_v_counter: integer := 0;
variable alien_id : integer := 0;
variable first_alien_inrow : integer := 0;
variable alive_bit : std_logic := '1';
variable anime_counter : integer := 0;
variable toggle : std_logic := '0'; 
variable exploded1 : std_logic_vector(31 downto 0);
variable exploded2 : std_logic_vector(31 downto 0);
variable explode_bit : std_logic := '0'; 
variable explode_counter : integer := 0;

begin
	if rising_edge(clk25) and game_state=2 then
		
		if ((Hcount = HSYNC + HBACK_PORCH - 1 + wave_h_coord) 
			and (Vcount = VSYNC + VBACK_PORCH - 1 + wave_v_coord)) then
		
			alien_id := 0; 
			first_alien_inrow := 0;
		
		elsif ( (Hcount = HSYNC + HBACK_PORCH - 1 + wave_h_coord 
			+ (NUM_ALIENS_PER_ROW*ALIEN_WIDTH) + ((NUM_ALIENS_PER_ROW-1)*GAP_WIDTH))
			and (Vcount = VSYNC + VBACK_PORCH - 1 + wave_v_coord 
			+ ((first_alien_inrow+1)*ALIEN_LENGTH) + ((first_alien_inrow)*GAP_LENGTH) ))then
		
			first_alien_inrow := first_alien_inrow + 1;
		end if;		 
	 
		if EndOfLine = '1' then 

			if ( alien_v_counter > 0 ) then
				alien_v_counter := alien_v_counter + 1;
			end if;
			
			if Vcount = VSYNC + VBACK_PORCH - 1 + wave_v_coord + gap_v_counter then
				alien_v_counter := 1;
				
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + wave_v_coord + ALIEN_LENGTH-1+gap_v_counter then
				if ( gap_v_counter < (ALIEN_LENGTH + GAP_LENGTH)*(NUM_ALIEN_ROWS-1) ) then
					gap_v_counter := gap_v_counter + ALIEN_LENGTH + GAP_LENGTH; 
				else
					gap_v_counter := 0;
				end if;
			
				alien_v_counter := 0;
			end if;
			
			alien_id := first_alien_inrow*NUM_ALIENS_PER_ROW;
		
		end if;
	
		if ( alien_h_counter > 0 ) then
			alien_h_counter := alien_h_counter + 1;
		end if;
	
		if Hcount = HSYNC + HBACK_PORCH - 1 + wave_h_coord + gap_h_counter then
				  alien_h_counter := 1;
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + wave_h_coord + ALIEN_WIDTH - 1 + gap_h_counter then
		
			if ( gap_h_counter < (ALIEN_WIDTH + GAP_WIDTH)*(NUM_ALIENS_PER_ROW-1) ) then
				gap_h_counter := gap_h_counter + ALIEN_WIDTH + GAP_WIDTH;
			else
				gap_h_counter := 0;
			end if; 
			alien_h_counter := 0;
			
			alien_id := alien_id + 1;
		end if;	

		if ( alien_id < 32 ) then 
				alive_bit := alien_status_1(alien_id);
				if alive_bit = '1' then
					exploded1(alien_id) := '0';--reset
				else
					explode_bit := exploded1(alien_id);
				end if;
		else
				alive_bit := alien_status_2(alien_id - 31);
				if alive_bit = '1' then
					exploded2(alien_id) := '0';--reset
				else
					explode_bit := exploded2(alien_id);
				end if;
		end if; 
		
		if (( alien_h_counter > 0 ) and (alien_v_counter > 0)) then
			if alive_bit = '1' then
				if toggle = '1' then
					alien_row := alien_ship(alien_v_counter-1);
				else
					alien_row := alien_ship2(alien_v_counter-1);
				end if;
				wave_bit <= alien_row(ALIEN_WIDTH-alien_h_counter);
					
			elsif (not (alive_bit = '1')) and explode_bit = '0' then
				if explode_counter < 1250 then
					alien_row := alien_explode(alien_v_counter-1);
					wave_bit <= alien_row(ALIEN_WIDTH-alien_h_counter);
					explode_counter := explode_counter+1;
				else 
					if ( alien_id < 32 ) then 
						exploded1(alien_id) := '1';--exploded already
					else
						exploded2(alien_id) := '1';
					end if;
					explode_counter := 0;--reset counter 
				end if;
			else
				wave_bit <= '0';
			end if;
		else
			wave_bit <= '0';
		end if;
		
		if anime_counter = 25000000 then
			anime_counter := 0; 
			toggle := not toggle;
		else
			anime_counter := anime_counter + 1;
		end if;
	end if;
end process DrawAlien1;	

----------------------------------------------------------------------------------------------------------- 
DrawScoreText : process (clk25)
variable score_x:integer;
variable score_y:integer;
variable score_v_counter : integer := 0;
variable score_h_counter : integer := 0;
begin
if rising_edge(clk25) and game_state/=1 then

	if EndOfLine = '1' then 
		if ( score_v_counter > 0 ) then
			score_v_counter := score_v_counter + 1;
		end if;
		
		if Vcount = VSYNC + VBACK_PORCH - 1 + SCORE_V_COORD then
			score_v_counter := 1;
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + SCORE_V_COORD  + TEXT_LENGTH-1 then
			score_v_counter := 0;
		end if;
		
	end if;
	
	if ( score_h_counter > 0 ) then
		score_h_counter := score_h_counter + 1;
	end if;
	
	if Hcount = HSYNC + HBACK_PORCH - 1 + SCORE_H_COORD then
		score_h_counter := 1;				
	elsif Hcount = HSYNC + HBACK_PORCH - 1 + SCORE_H_COORD + TEXT_WIDTH - 1 then
			score_h_counter := 0;
	end if;	
	 
	if (( score_h_counter > 0 ) and (score_v_counter > 0)) then
		score_row <= score_text(score_v_counter-1);
		score_bit <= score_row(80-score_h_counter);
	else
		score_bit <= '0';
	end if;
		 
end if;
end process DrawScoreText;	
------------------------------------------------------------------------------------------------------------
DrawLivesText : process (clk25)
variable lives_x:integer;
variable lives_y:integer;
variable lives_v_counter : integer := 0;
variable lives_h_counter : integer := 0;

begin
if rising_edge(clk25) and game_state=2 then

	if EndOfLine = '1' then 
		if ( lives_v_counter > 0 ) then
			lives_v_counter := lives_v_counter + 1;
		end if;
		
		if Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD then
			lives_v_counter := 1;
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD  + TEXT_LENGTH-1 then
			lives_v_counter := 0;
		end if;
		
		end if;
		
		if ( lives_h_counter > 0 ) then
			lives_h_counter := lives_h_counter + 1;
		end if;
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD then
			lives_h_counter := 1;				
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD + TEXT_WIDTH - 1 then
			lives_h_counter := 0;
		end if;	
		 
		if (( lives_h_counter > 0 ) and (lives_v_counter > 0)) then
			lives_row <= lives_text(lives_v_counter-1);
			lives_bit <= lives_row(80-lives_h_counter);
		else
			lives_bit <= '0';
		end if;
			 
	end if;
end process DrawLivesText;
-------------------------------------------------------------------------------------
DrawTimerText : process (clk25)
variable timer_x:integer;
variable timer_y:integer;
variable timer_v_counter : integer := 0;
variable timer_h_counter : integer := 0;
begin
if rising_edge(clk25) and game_state/=1 then

	if EndOfLine = '1' then 
			if ( timer_v_counter > 0 ) then
				timer_v_counter := timer_v_counter + 1;
			end if;

			if Vcount = VSYNC + VBACK_PORCH - 1 + TIMER_V_COORD then
				timer_v_counter := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + TIMER_V_COORD  + TEXT_LENGTH-1 then
				timer_v_counter := 0;
			end if;

	end if;

	if ( timer_h_counter > 0 ) then
			timer_h_counter := timer_h_counter + 1;
	end if;

			if Hcount = HSYNC + HBACK_PORCH - 1 + TIMER_H_COORD then
				timer_h_counter := 1;				
			elsif Hcount = HSYNC + HBACK_PORCH - 1 + TIMER_H_COORD + TEXT_WIDTH - 1 then
				timer_h_counter := 0;
			end if;	
 
	if (( timer_h_counter > 0 ) and (timer_v_counter > 0)) then

			timer_row <= timer_text(timer_v_counter-1);
			timer_bit <= timer_row(80-timer_h_counter);
	else
			timer_bit <= '0';
	end if;
     
end if;
end process DrawTimerText;
---------------------------------------------------------------------------------
DrawTimerVal_1 : process (clk25)
variable timer_x:integer;
variable timer_y:integer;
variable num:integer;
variable timer_h_counter_1:integer := 0;
variable timer_v_counter_1:integer := 0;
begin
if rising_edge(clk25) and  game_state/=1 then
	num:=timer1_num;


	if EndOfLine = '1' then 
		if ( timer_v_counter_1 > 0 ) then
			timer_v_counter_1 := timer_v_counter_1 + 1;
		end if;
		if Vcount = VSYNC + VBACK_PORCH - 1 + TIMER_V_COORD_1  then
			timer_v_counter_1 := 1;
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + TIMER_V_COORD_1  + NUM_LENGTH-1 then
			timer_v_counter_1 := 0;
		end if;

	end if;

    if ( timer_h_counter_1 > 0 ) then
			timer_h_counter_1 := timer_h_counter_1 + 1;
	end if;

	if Hcount = HSYNC + HBACK_PORCH - 1 + TIMER_H_COORD_1 then
			timer_h_counter_1 := 1;				
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + TIMER_H_COORD_1 + NUM_WIDTH - 1 then
			timer_h_counter_1 := 0;
	end if;	
 
	if (( timer_h_counter_1 > 0 ) and (timer_v_counter_1 > 0)) then
			if(num = 0) then			
			timer_row_1 <= sprite_0(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 1) then 
			timer_row_1 <= sprite_1(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 2) then 
			timer_row_1 <= sprite_2(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 3) then 
			timer_row_1 <= sprite_3(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 4) then 
			timer_row_1 <= sprite_4(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 5) then 
			timer_row_1 <= sprite_5(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 6) then 
			timer_row_1 <= sprite_6(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 7) then 
			timer_row_1 <= sprite_7(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 8) then 
			timer_row_1 <= sprite_8(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			elsif(num = 9) then 
			timer_row_1 <= sprite_9(timer_v_counter_1-1);
			timer_bit_1 <= timer_row_1(80-timer_h_counter_1);
			end if;
	else
			timer_bit_1 <= '0';	
	end if;
     
end if;
end process DrawTimerVal_1;
-----------------------------------------------------------------------------------
DrawTimerVal_2 : process (clk25)
variable timer_x:integer;
variable timer_y:integer;
variable num:integer;
variable timer_h_counter_2:integer := 0;
variable timer_v_counter_2:integer := 0;
begin
	if rising_edge(clk25) and  game_state/=1 then
		num:=timer2_num;


		if EndOfLine = '1' then 
			if ( timer_v_counter_2 > 0 ) then
				timer_v_counter_2 := timer_v_counter_2 + 1;
			end if;
			if Vcount = VSYNC + VBACK_PORCH - 1 + TIMER_V_COORD_2  then
				timer_v_counter_2 := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + TIMER_V_COORD_2  + NUM_LENGTH-1 then
				timer_v_counter_2 := 0;
			end if;

		end if;

		if ( timer_h_counter_2 > 0 ) then
				timer_h_counter_2 := timer_h_counter_2 + 1;
		end if;

		if Hcount = HSYNC + HBACK_PORCH - 1 + TIMER_H_COORD_2 then
				timer_h_counter_2 := 1;				
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + TIMER_H_COORD_2 + NUM_WIDTH - 1 then
				timer_h_counter_2 := 0;
		end if;	
 
	if (( timer_h_counter_2 > 0 ) and (timer_v_counter_2 > 0)) then

		if(num = 0) then			
				timer_row_2 <= sprite_0(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 1) then 
				timer_row_2 <= sprite_1(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 2) then 
				timer_row_2 <= sprite_2(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 3) then 
				timer_row_2 <= sprite_3(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 4) then 
				timer_row_2 <= sprite_4(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 5) then 
				timer_row_2 <= sprite_5(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 6) then 
				timer_row_2 <= sprite_6(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 7) then 
				timer_row_2 <= sprite_7(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 8) then 
				timer_row_2 <= sprite_8(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		elsif(num = 9) then 
				timer_row_2 <= sprite_9(timer_v_counter_2-1);
				timer_bit_2 <= timer_row_2(80-timer_h_counter_2);
		end if;

		else
				timer_bit_2 <= '0';
	end if;
     
end if;
end process DrawTimerVal_2;	

-----------------------------------------------------------------------------------
DrawLivesVal_1 : process (clk25)
variable lives_x:integer;
variable lives_y:integer;
variable num:integer;
variable lives_h_counter_1:integer := 0;
variable lives_v_counter_1:integer := 0;
begin
if rising_edge(clk25) and game_state=2 then
		num:=lives1_num;

		if ( lives1_num > 0) then 
			if EndOfLine = '1' then 	
				if ( lives_v_counter_1 > 0 ) then
					lives_v_counter_1 := lives_v_counter_1 + 1;
				end if;
				if Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD_1  then
					lives_v_counter_1 := 1;
				elsif Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD_1  + NUM_LENGTH-1 then
					lives_v_counter_1 := 0;
				end if;

			end if;

				if ( lives_h_counter_1 > 0 ) then
					lives_h_counter_1 := lives_h_counter_1 + 1;
				end if;

				if Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD_1 then
					lives_h_counter_1 := 1;				
				elsif Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD_1 + NUM_WIDTH - 1 then
					lives_h_counter_1 := 0;
				end if;	
 
			if (( lives_h_counter_1 > 0 ) and (lives_v_counter_1 > 0)) then
					lives_row_1 <= lives_sprite(lives_v_counter_1-1);
					lives_bit_1 <= lives_row_1(80 - lives_h_counter_1);
			else
					lives_bit_1 <= '0';	
			end if;
		end if;
     
end if;
end process DrawLivesVal_1;	
-----------------------------------------------------------------------------------
DrawLivesVal_2 : process (clk25)
variable lives_x:integer;
variable lives_y:integer;
variable num:integer;
variable lives_h_counter_2:integer := 0;
variable lives_v_counter_2:integer := 0;
begin
if rising_edge(clk25) and game_state=2 then
	num:=lives2_num;

	if ( lives1_num > 1) then 
		if EndOfLine = '1' then 
			if ( lives_v_counter_2 > 0 ) then
				lives_v_counter_2 := lives_v_counter_2 + 1;
			end if;
			if Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD_2  then
				lives_v_counter_2 := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD_2  + NUM_LENGTH-1 then
				lives_v_counter_2 := 0;
			end if;

		end if;

			if ( lives_h_counter_2 > 0 ) then
				lives_h_counter_2 := lives_h_counter_2 + 1;
			end if;

		if Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD_2 then
				lives_h_counter_2 := 1;				
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD_2 + NUM_WIDTH - 1 then
				lives_h_counter_2 := 0;
		end if;	
		 
		if (( lives_h_counter_2 > 0 ) and (lives_v_counter_2 > 0)) then
			lives_row_2 <= lives_sprite(lives_v_counter_2-1);
			lives_bit_2 <= lives_row_2(80 - lives_h_counter_2);
		else
			lives_bit_2 <= '0';	
		end if;
	end if;
     
end if;
end process DrawLivesVal_2;	
-----------------------------------------------------------------------------------
DrawLivesVal_3 : process (clk25)
variable lives_x:integer;
variable lives_y:integer;
variable num:integer;
variable lives_h_counter_3:integer := 0;
variable lives_v_counter_3:integer := 0;
begin
if rising_edge(clk25) and game_state=2 then
			num:=lives3_num;

			if ( lives1_num > 2 ) then 
				if EndOfLine = '1' then 
					if ( lives_v_counter_3 > 0 ) then
						lives_v_counter_3 := lives_v_counter_3 + 1;
					end if;
					if Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD_3  then
						lives_v_counter_3 := 1;
					elsif Vcount = VSYNC + VBACK_PORCH - 1 + LIVES_V_COORD_3  + NUM_LENGTH-1 then
						lives_v_counter_3 := 0;
					end if;

				end if;

				if ( lives_h_counter_3 > 0 ) then
					lives_h_counter_3 := lives_h_counter_3 + 1;
				end if;

				if Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD_3 then
					lives_h_counter_3 := 1;				
				elsif Hcount = HSYNC + HBACK_PORCH - 1 + LIVES_H_COORD_3 + NUM_WIDTH - 1 then
					lives_h_counter_3 := 0;
				end if;	
 
				if (( lives_h_counter_3 > 0 ) and (lives_v_counter_3 > 0)) then
					lives_row_3 <= lives_sprite(lives_v_counter_3-1);
					lives_bit_3 <= lives_row_3(80 - lives_h_counter_3);
				else
					lives_bit_3 <= '0';	
				end if;
			end if;
     
end if;
end process DrawLivesVal_3;	


---------------------------------------------------------------------------------
DrawBarricade1 : process (clk25 )
variable barricade_x:integer;
variable barricade_y:integer;
variable barricade1_v_counter : integer := 0;
variable barricade1_h_counter : integer := 0;
variable barricade1_row : unsigned(31 downto 0);
variable vert_block : integer := 0;
variable barricade_block_id : integer := 0;
variable active_bit : std_logic := '1';
begin
	if rising_edge(clk25) and game_state=2 then

		if EndOfLine = '1' then 
			if ( barricade1_v_counter > 0 ) then
				barricade1_v_counter := barricade1_v_counter + 1;
			end if;
			if Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE1_V_COORD then
				barricade1_v_counter := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE1_V_COORD + BARRICADE_LENGTH-1 then
				barricade1_v_counter := 0;
				vert_block := 0;
			end if;
		end if;
		
		if ( barricade1_h_counter > 0 ) then
			barricade1_h_counter := barricade1_h_counter + 1;
		end if;
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE1_H_COORD then
				  barricade1_h_counter := 1;
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE1_H_COORD + BARRICADE_WIDTH - 1 then
				  barricade1_h_counter := 0;
					
					if ( Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE1_V_COORD + (vert_block + 1) * BARRICADE_BLOCK_LENGTH ) then 
						vert_block := vert_block + 1; 
					end if; 
					barricade_block_id := vert_block * NUM_H_BLOCKS_BARRICADE;	
		end if;	
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE1_H_COORD + (barricade_block_id + 1 - (vert_block*NUM_H_BLOCKS_BARRICADE))*BARRICADE_BLOCK_WIDTH then 
			barricade_block_id := barricade_block_id + 1;
		end if;
		
		active_bit := barricade_status(0)(barricade_block_id);
		
		if (( barricade1_h_counter > 0 ) and (barricade1_v_counter > 0) and active_bit = '1') then
		
			barricade1_row := home_ship_barricade(barricade1_v_counter-1);
			barricade1_bit <= barricade1_row(32-barricade1_h_counter);
		
		else
			barricade1_bit <= '0';
		end if;
		 
	end if;
end process DrawBarricade1;	

----------------------------------
--------------------------------------------------------------------------------------------
DrawBarricade2 : process (clk25 )
variable barricade_x:integer;
variable barricade_y:integer;
variable barricade2_v_counter : integer := 0;
variable barricade2_h_counter : integer := 0;
variable barricade2_row : unsigned(31 downto 0);
variable vert_block : integer := 0;
variable barricade_block_id : integer := 0;
variable active_bit : std_logic := '1';
begin
	if rising_edge(clk25) and game_state=2 then
		if EndOfLine = '1' then 
			if ( barricade2_v_counter > 0 ) then
				barricade2_v_counter := barricade2_v_counter + 1;
			end if;
			if Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE2_V_COORD then
				barricade2_v_counter := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE2_V_COORD + BARRICADE_LENGTH-1 then
				barricade2_v_counter := 0;
				vert_block := 0;
			end if;
		end if;
		
		if ( barricade2_h_counter > 0 ) then
			barricade2_h_counter := barricade2_h_counter + 1;
		end if;
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE2_H_COORD then
			barricade2_h_counter := 1;
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE2_H_COORD + BARRICADE_WIDTH - 1 then
			barricade2_h_counter := 0;
			if ( Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE2_V_COORD + (vert_block + 1) * BARRICADE_BLOCK_LENGTH ) then 
						vert_block := vert_block + 1; 
			end if; 
			barricade_block_id := vert_block * NUM_H_BLOCKS_BARRICADE;	
		end if;	
		 
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE2_H_COORD + (barricade_block_id + 1 - (vert_block*NUM_H_BLOCKS_BARRICADE))*BARRICADE_BLOCK_WIDTH then 
			barricade_block_id := barricade_block_id + 1;
		end if;
		
		active_bit := barricade_status(1)(barricade_block_id);
		
		if (( barricade2_h_counter > 0 ) and (barricade2_v_counter > 0) and active_bit = '1') then
			barricade2_row := home_ship_barricade(barricade2_v_counter-1);
			barricade2_bit <= barricade2_row(32-barricade2_h_counter);
		else
			barricade2_bit <= '0';
		end if;
			 
	end if;
end process DrawBarricade2;	
-------------------------------------------------------------------------------------------------
 DrawBarricade3 : process (clk25 )
  
variable barricade_x:integer;
variable barricade_y:integer;
variable barricade3_v_counter : integer := 0;
variable barricade3_h_counter : integer := 0;
variable barricade3_row : unsigned(31 downto 0);
variable vert_block : integer := 0;
variable barricade_block_id : integer := 0;
variable active_bit : std_logic := '1';
begin
	if rising_edge(clk25) and game_state=2 then
		if EndOfLine = '1' then 
			if ( barricade3_v_counter > 0 ) then
				barricade3_v_counter := barricade3_v_counter + 1;
			end if;
			if Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE3_V_COORD then
				barricade3_v_counter := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE3_V_COORD + BARRICADE_LENGTH-1 then
				barricade3_v_counter := 0;
				vert_block := 0;
			end if;
		end if;
		
		if ( barricade3_h_counter > 0 ) then
			barricade3_h_counter := barricade3_h_counter + 1;
		end if;
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE3_H_COORD then
				 barricade3_h_counter := 1;
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE3_H_COORD + BARRICADE_WIDTH - 1 then
				barricade3_h_counter := 0;
				if ( Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE3_V_COORD + (vert_block + 1) * BARRICADE_BLOCK_LENGTH ) then 
						vert_block := vert_block + 1; 
				end if; 
				barricade_block_id := vert_block * NUM_H_BLOCKS_BARRICADE;	
		end if;	
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE3_H_COORD + (barricade_block_id + 1 - (vert_block*NUM_H_BLOCKS_BARRICADE))*BARRICADE_BLOCK_WIDTH then 
			barricade_block_id := barricade_block_id + 1;
		end if;
		
		active_bit := barricade_status(2)(barricade_block_id);
		 
		if (( barricade3_h_counter > 0 ) and (barricade3_v_counter > 0) and active_bit = '1') then
			barricade3_row := home_ship_barricade(barricade3_v_counter-1);
			barricade3_bit <= barricade3_row(32-barricade3_h_counter);
		else
			barricade3_bit <= '0';
		end if;
		 
	end if; 
end process DrawBarricade3;	
--------------------------------------------------------------------------------------------
 DrawBarricade4 : process (clk25 )
  
variable barricade_x:integer;
variable barricade_y:integer;
variable barricade4_v_counter : integer := 0;
variable barricade4_h_counter : integer := 0;
variable barricade4_row : unsigned(31 downto 0);
variable vert_block : integer := 0;
variable barricade_block_id : integer := 0;
variable active_bit : std_logic := '1';
begin
	if rising_edge(clk25) and game_state=2 then
		if EndOfLine = '1' then 
			if ( barricade4_v_counter > 0 ) then
				barricade4_v_counter := barricade4_v_counter + 1;
			end if;
			if Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE4_V_COORD then
				barricade4_v_counter := 1;
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE4_V_COORD + BARRICADE_LENGTH-1 then
				barricade4_v_counter := 0;
				vert_block := 0;
			end if;
		end if;
		
		if ( barricade4_h_counter > 0 ) then
			barricade4_h_counter := barricade4_h_counter + 1;
		end if;
		
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE4_H_COORD then
			barricade4_h_counter := 1;
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE4_H_COORD + BARRICADE_WIDTH - 1 then
			barricade4_h_counter := 0;
			if ( Vcount = VSYNC + VBACK_PORCH - 1 + BARRICADE4_V_COORD + (vert_block + 1) * BARRICADE_BLOCK_LENGTH ) then 
						vert_block := vert_block + 1; 
			end if; 
			barricade_block_id := vert_block * NUM_H_BLOCKS_BARRICADE;	
		end if;	
		 
		if Hcount = HSYNC + HBACK_PORCH - 1 + BARRICADE4_H_COORD + (barricade_block_id + 1 - (vert_block*NUM_H_BLOCKS_BARRICADE))*BARRICADE_BLOCK_WIDTH then 
			barricade_block_id := barricade_block_id + 1;
		end if;
		
		active_bit := barricade_status(3)(barricade_block_id);
		
		if (( barricade4_h_counter > 0 ) and (barricade4_v_counter > 0) and active_bit = '1') then
			barricade4_row := home_ship_barricade(barricade4_v_counter-1);	
			barricade4_bit <= barricade4_row(32-barricade4_h_counter);
		else
			barricade4_bit <= '0';
		end if;
			 
	end if;
end process DrawBarricade4;	
-------------------------------------

--------------------------------------------------------------------------------------------------- 
DrawIntro : process (clk25)
--variable intro:integer;
variable intro_y:integer;
variable intro_v_counter : integer := 0;
variable intro_h_counter : integer := 0;
begin
		if rising_edge(clk25) and game_state=1 then

			if EndOfLine = '1' then 
				if ( intro_v_counter > 0 ) then
					intro_v_counter := intro_v_counter + 1;
				end if;

				if Vcount = VSYNC + VBACK_PORCH - 1 + INTRO_V_COORD then
					intro_v_counter := 1;
				elsif Vcount = VSYNC + VBACK_PORCH - 1 + INTRO_V_COORD  + 86 then
					intro_v_counter := 0;
				end if;

			end if;

				if ( intro_h_counter > 0 ) then
					intro_h_counter := intro_h_counter + 1;
				end if;

				if Hcount = HSYNC + HBACK_PORCH - 1 + INTRO_H_COORD then
					intro_h_counter := 1;				
				elsif Hcount = HSYNC + HBACK_PORCH - 1 + INTRO_H_COORD + 299 then
					intro_h_counter := 0;
				end if;	
				 
				if (( intro_h_counter > 0 ) and (intro_v_counter > 0)) then
					intro_row <= intro(intro_v_counter-1);
					intro_bit <= intro_row(300-intro_h_counter);
				else
					intro_bit <= '0';
				end if;
 
		end if;
		
end process DrawIntro;	

----------------------------------------------------------------------------------------------------
DrawGameOver : process (clk25)

variable game_over_v_counter : integer := 0;
variable game_over_h_counter : integer := 0;
begin
	if rising_edge(clk25) and game_state=3 then

		if EndOfLine = '1' then 
			if ( game_over_v_counter > 0 ) then
				game_over_v_counter := game_over_v_counter + 1;
			end if;

		if Vcount = VSYNC + VBACK_PORCH - 1 + game_over_V_COORD then
			game_over_v_counter := 1;
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + game_over_V_COORD  + 39 then
			game_over_v_counter := 0;
		end if;

		end if;

		if ( game_over_h_counter > 0 ) then
			game_over_h_counter := game_over_h_counter + 1;
		end if;

		if Hcount = HSYNC + HBACK_PORCH - 1 + game_over_H_COORD then
			game_over_h_counter := 1;				
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + game_over_H_COORD + 299 then
			game_over_h_counter := 0;
		end if;	
 
		if (( game_over_h_counter > 0 ) and (game_over_v_counter > 0)) then
			game_over_row <= game_over(game_over_v_counter-1);
			game_over_bit <= game_over_row(300-game_over_h_counter);
		else
			game_over_bit <= '0';
		end if;
 
	end if;
end process DrawGameOver;	


---------------------------------------------------------------------------------------------------   	
DrawScore1 : process (clk25)
variable score_h_counter: integer := 0; 
variable score_v_counter : integer := 0; 
variable score_row_1 : unsigned (15 downto 0);
variable gap_h_counter: integer := 0;
variable score_id : integer := 0;
variable num : integer := 0;
begin
	if rising_edge(clk25) and game_state/=1 then
	 
		if EndOfLine = '1' then 
			
			if ( score_v_counter > 0 ) then
				score_v_counter := score_v_counter + 1;
			end if;
			
			-----
			if Vcount = VSYNC + VBACK_PORCH - 1 + SCORE_V_COORD_1  then
				score_v_counter := 1;
			elsif  Vcount = VSYNC + VBACK_PORCH - 1 + SCORE_V_COORD_1 + SCORE_LENGTH then
				score_v_counter := 0;	
			end if; 
					
			score_id := 0;
		
		end if;
	
		if ( score_h_counter > 0 ) then
			score_h_counter := score_h_counter + 1;
		end if;
	
		if Hcount = HSYNC + HBACK_PORCH - 1 + SCORE_H_COORD_1 + gap_h_counter then
				  score_h_counter := 1;
		elsif Hcount = HSYNC + HBACK_PORCH - 1 + SCORE_H_COORD_1 + SCORE_WIDTH - 1 + gap_h_counter then
		
			-----------------------------
			if ( gap_h_counter < (SCORE_WIDTH + SCORE_GAP)*(NUM_DIGITS-1) ) then
				gap_h_counter := gap_h_counter + SCORE_WIDTH + SCORE_GAP;
			else
				gap_h_counter := 0;
			end if; 
			score_h_counter := 0;
			
			score_id := score_id + 1;
		end if;	
		
		num := score_array(score_id);
		
		if (( score_h_counter > 0 ) and (score_v_counter > 0)) then 
		------------------------
			if(num = 0) then			
				score_row_1 := sprite_0(score_v_counter-1);
			
			elsif(num = 1) then 
				score_row_1 := sprite_1(score_v_counter-1);
				
			elsif(num = 2) then 
				score_row_1 := sprite_2(score_v_counter-1);
				
			elsif(num = 3) then 
				score_row_1 := sprite_3(score_v_counter-1);
				
			elsif(num = 4) then 
				score_row_1 := sprite_4(score_v_counter-1);
				
			elsif(num = 5) then 
				score_row_1 := sprite_5(score_v_counter-1);
				
			elsif(num = 6) then 
				score_row_1 := sprite_6(score_v_counter-1);
				
			elsif(num = 7) then 
				score_row_1 := sprite_7(score_v_counter-1);
				
			elsif(num = 8) then 
				score_row_1 := sprite_8(score_v_counter-1);
				
			elsif(num = 9) then 
				score_row_1 := sprite_9(score_v_counter-1);
				
			end if;
			
			score_bit_1 <= score_row_1(SCORE_WIDTH-score_h_counter);
			
		else
			score_bit_1 <= '0';
		end if;
	end if;
end process DrawScore1;	

--------------------------------------------------------------------------------------------------------- 


DrawHomeMissile : process (clk25 )
  
	
	variable homemissile_v_counter : integer := 0;
	variable homemissile_h_counter : integer := 0;

	begin
		if rising_edge(clk25) and game_state=2 then
			
			if ( home_missile_y > 0 ) then 
			
				if EndOfLine = '1' then 
					if ( homemissile_v_counter > 0 ) then
						homemissile_v_counter := homemissile_v_counter + 1;
					end if;
					if Vcount = VSYNC + VBACK_PORCH - 1 + home_missile_y then
						homemissile_v_counter := 1;
					elsif Vcount > VSYNC + VBACK_PORCH - 1 + home_missile_y + HOME_MISSILE_LENGTH-1 then
						homemissile_v_counter := 0;
					end if;	
				end if;
			
				if ( homemissile_h_counter > 0 ) then
					homemissile_h_counter := homemissile_h_counter + 1;
				end if;
			
				if Hcount = HSYNC + HBACK_PORCH - 1 + home_missile_x then
					homemissile_h_counter := 1;
				elsif Hcount > HSYNC + HBACK_PORCH - 1 + home_missile_x + HOME_MISSILE_WIDTH - 1 then
					homemissile_h_counter := 0;
				end if;	
				 
				if ((homemissile_h_counter > 0 ) and (homemissile_v_counter > 0)) then
						homemissile_bit <= '1';
				else
						homemissile_bit <= '0';
				end if;
		 else 	
				homemissile_bit <= '0';	
		 end if; -- home_missile_y > 0
	end if;
end process DrawHomeMissile;
-------------------------------------------------

		
process(clk25) 
	variable alienmissile_v_counter : alien_missiles;
	variable alienmissile_h_counter : alien_missiles;

	begin
		if rising_edge(clk25) and game_state=2 then
			for i in 0 to 9 loop  
			if ( alien_missile_y(i) > 0 ) then 
			
				if EndOfLine = '1' then 
					if ( alienmissile_v_counter(i) > 0 ) then
						alienmissile_v_counter(i) := alienmissile_v_counter(i) + 1;
					end if;
					if Vcount = VSYNC + VBACK_PORCH - 1 + alien_missile_y(i) then
						alienmissile_v_counter(i) := 1;
					elsif Vcount > VSYNC + VBACK_PORCH - 1 + alien_missile_y(i) + HOME_MISSILE_LENGTH-1 then
						alienmissile_v_counter(i) := 0;
					end if;	
				end if;
			
				if ( alienmissile_h_counter(i) > 0 ) then
					alienmissile_h_counter(i) := alienmissile_h_counter(i) + 1;
				end if;
			
				if Hcount = HSYNC + HBACK_PORCH - 1 + alien_missile_x(i) then
					alienmissile_h_counter(i) := 1;
				elsif Hcount > HSYNC + HBACK_PORCH - 1 + alien_missile_x(i) + HOME_MISSILE_WIDTH - 1 then
					alienmissile_h_counter(i) := 0;
				end if;	
				 
				if ((alienmissile_h_counter(i) > 0 ) and (alienmissile_v_counter(i) > 0)) then
						alienmissile_bits(i) <= '1';
				else
						alienmissile_bits(i) <= '0';
				end if;
		 else 	
				alienmissile_bits(i) <= '0';	
		 end if; -- home_missile_y > 0
		 end loop; 
		
	end if;
	
end process; 
---------------------------------------------
------------------------------------------------------------------------------------------------- .
DrawStar1 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star1_v_counter : integer := 0;
variable star1_h_counter : integer := 0;
variable star1_row : unsigned(15 downto 0);
variable star_toggle1: std_logic := '0';
variable star_counter1: integer := 0;

begin
if rising_edge(clk25) then
	if EndOfLine = '1' then 
		if ( star1_v_counter > 0 ) then
			star1_v_counter := star1_v_counter + 1;
		end if;
		
		if Vcount = VSYNC + VBACK_PORCH - 1 + STAR1_V_COORD then
			star1_v_counter := 1;
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR1_V_COORD + STAR_LENGTH-1 then
			star1_v_counter := 0;
		end if;
	end if;

    if ( star1_h_counter > 0 ) then
		star1_h_counter := star1_h_counter + 1;
	end if;

	if Hcount = HSYNC + HBACK_PORCH - 1 + STAR1_H_COORD then
          star1_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR1_H_COORD + STAR_WIDTH - 1 then
          star1_h_counter := 0;
	end if;	
 
	if (( star1_h_counter > 0 ) and (star1_v_counter > 0)) then
		if star_toggle1 = '1' then
			star1_row := star_sprite(star1_v_counter-1);
		else 
			star1_row := star_sprite2(star1_v_counter-1);
	end if;
star1_bit <= star1_row(16-star1_h_counter);

else
	star1_bit <= '0';
end if;
	if star_counter1 = 10000000 then
		star_counter1 := 0;
		star_toggle1 := not star_toggle1;
	else
		star_counter1 := star_counter1 + 1;
	end if;

end if;
end process DrawStar1;	
---------------------------------------------------------------------------------------------------- 	
Drawstar2 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star2_v_counter : integer := 0;
variable star2_h_counter : integer := 0;
variable star2_row : unsigned(15 downto 0);
variable star_toggle2: std_logic := '0';
variable star_counter2: integer := 0;

begin
if rising_edge(clk25) then
	if EndOfLine = '1' then 
		if ( star2_v_counter > 0 ) then
			star2_v_counter := star2_v_counter + 1;
		end if;
		if Vcount = VSYNC + VBACK_PORCH - 1 + STAR2_V_COORD then
			star2_v_counter := 1;
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR2_V_COORD + STAR_LENGTH-1 then
		star2_v_counter := 0;
	end if;
end if;

if ( star2_h_counter > 0 ) then
	star2_h_counter := star2_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR2_H_COORD then
    star2_h_counter := 1;
elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR2_H_COORD + STAR_WIDTH - 1 then
    star2_h_counter := 0;
end if;	
 
if (( star2_h_counter > 0 ) and (star2_v_counter > 0)) then
	if star_toggle2 = '1' then
		star2_row := star_sprite(star2_v_counter-1);
	else 
star2_row := star_sprite2(star2_v_counter-1);
end if;
	
star2_bit <= star2_row(16-star2_h_counter);
else
	star2_bit <= '0';
end if;
if star_counter2 = 13000000 then
	star_counter2 := 0;
	star_toggle2 := not star_toggle2;
else
	star_counter2 := star_counter2 + 1;
end if;

end if;
end process Drawstar2;	
----------------------------------------------------------------------------------------------------
Drawstar3 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star3_v_counter : integer := 0;
variable star3_h_counter : integer := 0;
variable star3_row : unsigned(15 downto 0);
variable star_toggle3: std_logic := '0';
variable star_counter3: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
	if ( star3_v_counter > 0 ) then
		star3_v_counter := star3_v_counter + 1;
	end if;
	if Vcount = VSYNC + VBACK_PORCH - 1 + STAR3_V_COORD then
		star3_v_counter := 1;
	elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR3_V_COORD + STAR_LENGTH-1 then
		star3_v_counter := 0;
	end if;
end if;

if ( star3_h_counter > 0 ) then
	star3_h_counter := star3_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR3_H_COORD then
    star3_h_counter := 1;
elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR3_H_COORD + STAR_WIDTH - 1 then
    star3_h_counter := 0;
end if;	
 
if (( star3_h_counter > 0 ) and (star3_v_counter > 0)) then
	if star_toggle3 = '1' then
		star3_row := star_sprite(star3_v_counter-1);
	else 
	star3_row := star_sprite2(star3_v_counter-1);
end if;

star3_bit <= star3_row(16-star3_h_counter);
else
star3_bit <= '0';
end if;
if star_counter3 = 16000000 then
	star_counter3 := 0;
	star_toggle3 := not star_toggle3;
else
	star_counter3 := star_counter3 + 1;
end if;

end if;
end process Drawstar3;	
----------------------------------------------------------------------------------------------------
DrawStar4 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star4_v_counter : integer := 0;
variable star4_h_counter : integer := 0;
variable star4_row : unsigned(15 downto 0);
variable star_toggle4: std_logic := '0';
variable star_counter4: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star4_v_counter > 0 ) then
star4_v_counter := star4_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR4_V_COORD then
star4_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR4_V_COORD + STAR_LENGTH-1 then
star4_v_counter := 0;
end if;
end if;

    if ( star4_h_counter > 0 ) then
star4_h_counter := star4_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR4_H_COORD then
          star4_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR4_H_COORD + STAR_WIDTH - 1 then
          star4_h_counter := 0;
end if;	
 
if (( star4_h_counter > 0 ) and (star4_v_counter > 0)) then
 if star_toggle4 = '1' then
star4_row := star_sprite(star4_v_counter-1);
else 
star4_row := star_sprite2(star4_v_counter-1);
end if;
star4_bit <= star4_row(16-star4_h_counter);
else
star4_bit <= '0';
end if;
if star_counter4 = 19000000 then
star_counter4 := 0;
star_toggle4 := not star_toggle4;
else
star_counter4 := star_counter4 + 1;
end if;

end if;
end process DrawStar4;		
----------------------------------------------------------------------------------------------------  
Drawstar5 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star5_v_counter : integer := 0;
variable star5_h_counter : integer := 0;
variable star5_row : unsigned(15 downto 0);
variable star_toggle5: std_logic := '0';
variable star_counter5: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star5_v_counter > 0 ) then
star5_v_counter := star5_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR5_V_COORD then
star5_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR5_V_COORD + STAR_LENGTH-1 then
star5_v_counter := 0;
end if;
end if;

    if ( star5_h_counter > 0 ) then
star5_h_counter := star5_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR5_H_COORD then
          star5_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR5_H_COORD + STAR_WIDTH - 1 then
          star5_h_counter := 0;
end if;	
 
if (( star5_h_counter > 0 ) and (star5_v_counter > 0)) then
 if star_toggle5 = '1' then
star5_row := star_sprite(star5_v_counter-1);
else 
star5_row := star_sprite2(star5_v_counter-1);
end if;
star5_bit <= star5_row(16-star5_h_counter);

else
star5_bit <= '0';
end if;
if star_counter5 = 22000000 then
star_counter5 := 0;
star_toggle5 := not star_toggle5;
else
star_counter5 := star_counter5 + 1;
end if;

end if;
end process Drawstar5;	
-----------------------------------------------------------------------------------------------------
Drawstar6 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star6_v_counter : integer := 0;
variable star6_h_counter : integer := 0;
variable star6_row : unsigned(15 downto 0);
variable star_toggle6: std_logic := '0';
variable star_counter6: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star6_v_counter > 0 ) then
star6_v_counter := star6_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR6_V_COORD then
star6_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR6_V_COORD + STAR_LENGTH-1 then
star6_v_counter := 0;
end if;
end if;

    if ( star6_h_counter > 0 ) then
star6_h_counter := star6_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR6_H_COORD then
          star6_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR6_H_COORD + STAR_WIDTH - 1 then
          star6_h_counter := 0;
end if;	
 
if (( star6_h_counter > 0 ) and (star6_v_counter > 0)) then
 if star_toggle6 = '1' then
star6_row := star_sprite(star6_v_counter-1);
else 
star6_row := star_sprite2(star6_v_counter-1);
end if;
star6_bit <= star6_row(16-star6_h_counter);

else
star6_bit <= '0';
end if;
if star_counter6 = 25000000 then
star_counter6 := 0;
star_toggle6 := not star_toggle6;
else
star_counter6 := star_counter6 + 1;
end if;

end if;
end process Drawstar6;	
-----------------------------------------------------------------------------------------------------
Drawstar7 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star7_v_counter : integer := 0;
variable star7_h_counter : integer := 0;
variable star7_row : unsigned(15 downto 0);
variable star_toggle7: std_logic := '0';
variable star_counter7: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star7_v_counter > 0 ) then
star7_v_counter := star7_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR7_V_COORD then
star7_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR7_V_COORD + STAR_LENGTH-1 then
star7_v_counter := 0;
end if;
end if;

    if ( star7_h_counter > 0 ) then
star7_h_counter := star7_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR7_H_COORD then
          star7_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR7_H_COORD + STAR_WIDTH - 1 then
          star7_h_counter := 0;
end if;	
 
if (( star7_h_counter > 0 ) and (star7_v_counter > 0)) then
 if star_toggle7 = '1' then
star7_row := star_sprite(star7_v_counter-1);
else 
star7_row := star_sprite2(star7_v_counter-1);
end if;
star7_bit <= star7_row(16-star7_h_counter);

else
star7_bit <= '0';
end if;
if star_counter7 = 8000000 then
star_counter7 := 0;
star_toggle7 := not star_toggle7;
else
star_counter7 := star_counter7 + 1;
end if;

end if;
end process Drawstar7;	
-----------------------------------------------------------------------------------------------------
Drawstar9 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star9_v_counter : integer := 0;
variable star9_h_counter : integer := 0;
variable star9_row : unsigned(15 downto 0);
variable star_toggle9: std_logic := '0';
variable star_counter9: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star9_v_counter > 0 ) then
star9_v_counter := star9_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR9_V_COORD then
star9_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR9_V_COORD + STAR_LENGTH-1 then
star9_v_counter := 0;
end if;
end if;

    if ( star9_h_counter > 0 ) then
star9_h_counter := star9_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR9_H_COORD then
          star9_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR9_H_COORD + STAR_WIDTH - 1 then
          star9_h_counter := 0;
end if;	
 
if (( star9_h_counter > 0 ) and (star9_v_counter > 0)) then
 if star_toggle9 = '1' then
star9_row := star_sprite(star9_v_counter-1);
else 
star9_row := star_sprite2(star9_v_counter-1);
end if;
star9_bit <= star9_row(16-star9_h_counter);

else
star9_bit <= '0';
end if;
if star_counter9 = 19000000 then
star_counter9 := 0;
star_toggle9 := not star_toggle9;
else
star_counter9 := star_counter9 + 1;
end if;

end if;
end process Drawstar9;	
-----------------------------------------------------------------------------------------------------
Drawstar8 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star8_v_counter : integer := 0;
variable star8_h_counter : integer := 0;
variable star8_row : unsigned(15 downto 0);
variable star_toggle8: std_logic := '0';
variable star_counter8: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star8_v_counter > 0 ) then
star8_v_counter := star8_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR8_V_COORD then
star8_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR8_V_COORD + STAR_LENGTH-1 then
star8_v_counter := 0;
end if;
end if;

    if ( star8_h_counter > 0 ) then
star8_h_counter := star8_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR8_H_COORD then
          star8_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR8_H_COORD + STAR_WIDTH - 1 then
          star8_h_counter := 0;
end if;	
 
if (( star8_h_counter > 0 ) and (star8_v_counter > 0)) then
 if star_toggle8 = '1' then
star8_row := star_sprite(star8_v_counter-1);
else 
star8_row := star_sprite2(star8_v_counter-1);
end if;

star8_bit <= star8_row(16-star8_h_counter);

else
star8_bit <= '0';
end if;
if star_counter8 = 17000000 then
star_counter8 := 0;
star_toggle8 := not star_toggle8;
else
star_counter8 := star_counter8 + 1;
end if;

end if;
end process Drawstar8;	
------------------------------------------------------------------------------------------------------
Drawstar10 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star10_v_counter : integer := 0;
variable star10_h_counter : integer := 0;
variable star10_row : unsigned(15 downto 0);
variable star_toggle10: std_logic := '0';
variable star_counter10: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star10_v_counter > 0 ) then
star10_v_counter := star10_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR10_V_COORD then
star10_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR10_V_COORD + STAR_LENGTH-1 then
star10_v_counter := 0;
end if;
end if;

    if ( star10_h_counter > 0 ) then
star10_h_counter := star10_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR10_H_COORD then
          star10_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR10_H_COORD + STAR_WIDTH - 1 then
          star10_h_counter := 0;
end if;	
 
if (( star10_h_counter > 0 ) and (star10_v_counter > 0)) then
 if star_toggle10 = '1' then
star10_row := star_sprite(star10_v_counter-1);
else 
star10_row := star_sprite2(star10_v_counter-1);
end if;

star10_bit <= star10_row(16-star10_h_counter);

else
star10_bit <= '0';
end if;
if star_counter10 = 10000000 then
star_counter10 := 0;
star_toggle10 := not star_toggle10;
else
star_counter10 := star_counter10 + 1;
end if;

end if;
end process Drawstar10;	
-----------------------------------------------------------------------------------------------------
DrawStar11 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star11_v_counter : integer := 0;
variable star11_h_counter : integer := 0;
variable star11_row : unsigned(15 downto 0);
variable star_toggle11: std_logic := '0';
variable star_counter11: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star11_v_counter > 0 ) then
star11_v_counter := star11_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR11_V_COORD then
star11_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR11_V_COORD + STAR_LENGTH-1 then
star11_v_counter := 0;
end if;
end if;

    if ( star11_h_counter > 0 ) then
star11_h_counter := star11_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR11_H_COORD then
          star11_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR11_H_COORD + STAR_WIDTH - 1 then
          star11_h_counter := 0;
end if;	
 
if (( star11_h_counter > 0 ) and (star11_v_counter > 0)) then
 if star_toggle11 = '1' then
star11_row := star_sprite(star11_v_counter-1);
else 
star11_row := star_sprite2(star11_v_counter-1);
end if;
star11_bit <= star11_row(16-star11_h_counter);

else
star11_bit <= '0';
end if;
if star_counter11 = 7000000 then
star_counter11 := 0;
star_toggle11 := not star_toggle11;
else
star_counter11 := star_counter11 + 1;
end if;

end if;
end process DrawStar11;	
------------------------------------------------------------------------------------------------------
DrawStar12 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star12_v_counter : integer := 0;
variable star12_h_counter : integer := 0;
variable star12_row : unsigned(15 downto 0);
variable star_toggle12: std_logic := '0';
variable star_counter12: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star12_v_counter > 0 ) then
star12_v_counter := star12_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR12_V_COORD then
star12_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR12_V_COORD + STAR_LENGTH-1 then
star12_v_counter := 0;
end if;
end if;

    if ( star12_h_counter > 0 ) then
star12_h_counter := star12_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR12_H_COORD then
          star12_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR12_H_COORD + STAR_WIDTH - 1 then
          star12_h_counter := 0;
end if;	
 
if (( star12_h_counter > 0 ) and (star12_v_counter > 0)) then
 if star_toggle12 = '1' then
star12_row := star_sprite(star12_v_counter-1);
else 
star12_row := star_sprite2(star12_v_counter-1);
end if;
star12_bit <= star12_row(16-star12_h_counter);

else
star12_bit <= '0';
end if;
if star_counter12 = 5000000 then
star_counter12 := 0;
star_toggle12 := not star_toggle12;
else
star_counter12 := star_counter12 + 1;
end if;

end if;
end process DrawStar12;	
------------------------------------------------------------------------------------------------------
DrawStar13 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star13_v_counter : integer := 0;
variable star13_h_counter : integer := 0;
variable star13_row : unsigned(15 downto 0);
variable star_toggle13: std_logic := '0';
variable star_counter13: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star13_v_counter > 0 ) then
star13_v_counter := star13_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR13_V_COORD then
star13_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR13_V_COORD + STAR_LENGTH-1 then
star13_v_counter := 0;
end if;
end if;

    if ( star13_h_counter > 0 ) then
star13_h_counter := star13_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR13_H_COORD then
          star13_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR13_H_COORD + STAR_WIDTH - 1 then
          star13_h_counter := 0;
end if;	
 
if (( star13_h_counter > 0 ) and (star13_v_counter > 0)) then
 if star_toggle13 = '1' then
star13_row := star_sprite(star13_v_counter-1);
else 
star13_row := star_sprite2(star13_v_counter-1);
end if;
star13_bit <= star13_row(16-star13_h_counter);

else
star13_bit <= '0';
end if;
if star_counter13 = 6000000 then
star_counter13 := 0;
star_toggle13 := not star_toggle13;
else
star_counter13 := star_counter13 + 1;
end if;

end if;
end process DrawStar13;	
-------------------------------------------------------------------------------------------------------
DrawStar14 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star14_v_counter : integer := 0;
variable star14_h_counter : integer := 0;
variable star14_row : unsigned(15 downto 0);
variable star_toggle14: std_logic := '0';
variable star_counter14: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star14_v_counter > 0 ) then
star14_v_counter := star14_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR14_V_COORD then
star14_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR14_V_COORD + STAR_LENGTH-1 then
star14_v_counter := 0;
end if;
end if;

    if ( star14_h_counter > 0 ) then
star14_h_counter := star14_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR14_H_COORD then
          star14_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR14_H_COORD + STAR_WIDTH - 1 then
          star14_h_counter := 0;
end if;	
 
if (( star14_h_counter > 0 ) and (star14_v_counter > 0)) then
 if star_toggle14 = '1' then
star14_row := star_sprite(star14_v_counter-1);
else 
star14_row := star_sprite2(star14_v_counter-1);
end if;
star14_bit <= star14_row(16-star14_h_counter);

else
star14_bit <= '0';
end if;
if star_counter14 = 8000000 then
star_counter14 := 0;
star_toggle14 := not star_toggle14;
else
star_counter14 := star_counter14 + 1;
end if;

end if;
end process DrawStar14;	
-------------------------------------------------------------------------------------------------------
DrawStar15 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star15_v_counter : integer := 0;
variable star15_h_counter : integer := 0;
variable star15_row : unsigned(15 downto 0);
variable star_toggle15: std_logic := '0';
variable star_counter15: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star15_v_counter > 0 ) then
star15_v_counter := star15_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR15_V_COORD then
star15_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR15_V_COORD + STAR_LENGTH-1 then
star15_v_counter := 0;
end if;
end if;

    if ( star15_h_counter > 0 ) then
star15_h_counter := star15_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR15_H_COORD then
          star15_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR15_H_COORD + STAR_WIDTH - 1 then
          star15_h_counter := 0;
end if;	
 
if (( star15_h_counter > 0 ) and (star15_v_counter > 0)) then
 if star_toggle15 = '1' then
star15_row := star_sprite(star15_v_counter-1);
else 
star15_row := star_sprite2(star15_v_counter-1);
end if;
star15_bit <= star15_row(16-star15_h_counter);

else
star15_bit <= '0';
end if;
if star_counter15 = 10000000 then
star_counter15 := 0;
star_toggle15 := not star_toggle15;
else
star_counter15 := star_counter15 + 1;
end if;

end if;
end process DrawStar15;	
--------------------------------------------------------------------------------------------------------
DrawStar16 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star16_v_counter : integer := 0;
variable star16_h_counter : integer := 0;
variable star16_row : unsigned(15 downto 0);
variable star_toggle16: std_logic := '0';
variable star_counter16: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star16_v_counter > 0 ) then
star16_v_counter := star16_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR16_V_COORD then
star16_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR16_V_COORD + STAR_LENGTH-1 then
star16_v_counter := 0;
end if;
end if;

    if ( star16_h_counter > 0 ) then
star16_h_counter := star16_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR16_H_COORD then
          star16_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR16_H_COORD + STAR_WIDTH - 1 then
          star16_h_counter := 0;
end if;	
 
if (( star16_h_counter > 0 ) and (star16_v_counter > 0)) then
 if star_toggle16 = '1' then
star16_row := star_sprite(star16_v_counter-1);
else 
star16_row := star_sprite2(star16_v_counter-1);
end if;
star16_bit <= star16_row(16-star16_h_counter);

else
star16_bit <= '0';
end if;
if star_counter16 = 10000000 then
star_counter16 := 0;
star_toggle16 := not star_toggle16;
else
star_counter16 := star_counter16 + 1;
end if;

end if;
end process DrawStar16;	
---------------------------------------------------------------------------------------------------------
DrawStar17 : process (clk25 )
variable star_x:integer;
variable star_y:integer;
variable star17_v_counter : integer := 0;
variable star17_h_counter : integer := 0;
variable star17_row : unsigned(15 downto 0);
variable star_toggle17: std_logic := '0';
variable star_counter17: integer := 0;
begin
if rising_edge(clk25) then



if EndOfLine = '1' then 
if ( star17_v_counter > 0 ) then
star17_v_counter := star17_v_counter + 1;
end if;
if Vcount = VSYNC + VBACK_PORCH - 1 + STAR17_V_COORD then
star17_v_counter := 1;
elsif Vcount = VSYNC + VBACK_PORCH - 1 + STAR17_V_COORD + STAR_LENGTH-1 then
star17_v_counter := 0;
end if;
end if;

    if ( star17_h_counter > 0 ) then
star17_h_counter := star17_h_counter + 1;
end if;

if Hcount = HSYNC + HBACK_PORCH - 1 + STAR17_H_COORD then
          star17_h_counter := 1;
    elsif Hcount = HSYNC + HBACK_PORCH - 1 + STAR17_H_COORD + STAR_WIDTH - 1 then
          star17_h_counter := 0;
end if;	
 
if (( star17_h_counter > 0 ) and (star17_v_counter > 0)) then
 if star_toggle17 = '1' then
star17_row := star_sprite(star17_v_counter-1);
else 
star17_row := star_sprite2(star17_v_counter-1);
end if;
star17_bit <= star17_row(16-star17_h_counter);

else
star17_bit <= '0';
end if;
if star_counter17 = 7500000 then
star_counter17 := 0;
star_toggle17 := not star_toggle17;
else
star_counter17 := star_counter17 + 1;
end if;

end if;
end process DrawStar17;	

--Listening to Software Updates
ram_address <= address(15 downto 0);
 ListenForUpdates: process( clk )
variable kill_info : unsigned(6 downto 0);
variable barricade_info : unsigned(2 downto 0);
begin
	if rising_edge(clk) then
		if reset = '1' then
			home_h_coord_temp <= (others => '0');
			home_status <= '1';
			wave_h_coord_temp <= (others => '0');
			wave_v_coord_temp <= (others => '0');	
			score_array(0) <= 0; 
			score_array(1) <= 0; 
			score_array(2) <= 0; 
			score_array(3) <= 0; 
			score_array(4) <= 0;
			timer1_num <= 0;
			timer2_num <= 0;
			timer3_num <= 0;
			timer4_num <= 0; 
			lives1_num <= 0;
			home_missile_x_temp <= 0;
			home_missile_y_temp <= 0;
			alien_missile_x_temp(0) <= 0;  
			alien_missile_y_temp(0) <= 0; 
			alien_missile_x_temp(1) <= 0;
			alien_missile_y_temp(1) <= 0;
			alien_missile_x_temp(2) <= 0;
			alien_missile_y_temp(2) <= 0;
			alien_missile_x_temp(3) <= 0;
			alien_missile_y_temp(3) <= 0;
			alien_missile_x_temp(4) <= 0;
			alien_missile_y_temp(4) <= 0;
			alien_missile_x_temp(5) <= 0;
			alien_missile_y_temp(5) <= 0;
			alien_missile_x_temp(6) <= 0;
			alien_missile_y_temp(6) <= 0;
			alien_missile_x_temp(7) <= 0;
			alien_missile_y_temp(7) <= 0;
			alien_missile_x_temp(8) <= 0;
			alien_missile_y_temp(8) <= 0;
			alien_missile_x_temp(9) <= 0;
			alien_missile_y_temp(9) <= 0;
			
			
			alien_status_1 <= x"FFFFFFFF";
			alien_status_2 <= x"FFFFFFFF";
			barricade_status(0) <= x"FFFFFFFFFFFFFFFF";
			barricade_status(1) <= x"FFFFFFFFFFFFFFFF";
			barricade_status(2) <= x"FFFFFFFFFFFFFFFF";
			barricade_status(3) <= x"FFFFFFFFFFFFFFFF";
			
			
		else 
			if ( chipselect = '1' ) then
				if ( write = '1' ) then
					if  ram_address = x"FFFF" then 
							-- reset from software
							alien_status_1 <= x"FFFFFFFF"; 
							alien_status_2 <= x"FFFFFFFF"; 
							
							home_status <= '1';	
							---------------------------------
							barricade_status(0) <= x"FFFFFFFFFFFFFFFF";
							barricade_status(1) <= x"FFFFFFFFFFFFFFFF";
							barricade_status(2) <= x"FFFFFFFFFFFFFFFF";
							barricade_status(3) <= x"FFFFFFFFFFFFFFFF";
							
							alien_missile_x_temp(0) <= 0;  
							alien_missile_y_temp(0) <= 0; 
							alien_missile_x_temp(1) <= 0;
							alien_missile_y_temp(1) <= 0;
							alien_missile_x_temp(2) <= 0;
							alien_missile_y_temp(2) <= 0;
							alien_missile_x_temp(3) <= 0;
							alien_missile_y_temp(3) <= 0;
							alien_missile_x_temp(4) <= 0;
							alien_missile_y_temp(4) <= 0;
							alien_missile_x_temp(5) <= 0;
							alien_missile_y_temp(5) <= 0;
							alien_missile_x_temp(6) <= 0;
							alien_missile_y_temp(6) <= 0;
							alien_missile_x_temp(7) <= 0;
							alien_missile_y_temp(7) <= 0;
							alien_missile_x_temp(8) <= 0;
							alien_missile_y_temp(8) <= 0;
							alien_missile_x_temp(9) <= 0;
							alien_missile_y_temp(9) <= 0;
			
					
					elsif ram_address = x"0000" then
						home_h_coord_temp <= writedata(15 downto 0); -- home ship x coordinate
					elsif ram_address = x"0001" then 
						wave_h_coord_temp <= writedata(15 downto 0);
					elsif ram_address = x"0002" then
						wave_v_coord_temp <= writedata(15 downto 0);
					-------------------------------------------
					elsif ram_address = x"0003" then 
						score_array(0) <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"0004" then 
						score_array(1) <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"0005" then 
						score_array(2) <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"0006" then 
						score_array(3) <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"0007" then 
						score_array(4) <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"0008" then 
						lives1_num <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"0009" then 
						home_missile_x_temp <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"000a" then 
						home_missile_y_temp <= to_integer(writedata(15 downto 0));
					elsif ram_address = x"000b" then
						home_status <= writedata(0);
					elsif ram_address >= x"0010" and ram_address <= x"0019" then 
						alien_missile_x_temp(to_integer(ram_address(3 downto 0))) <= to_integer(writedata(15 downto 0)); 
					elsif ram_address >= x"0020" and ram_address <= x"0029" then 
						alien_missile_y_temp(to_integer(ram_address(3 downto 0))) <= to_integer(writedata(15 downto 0)); 
					elsif ram_address  = x"0030" then
					    timer1_num <= to_integer(writedata(15 downto 0));
					elsif ram_address  = x"0031" then
					    timer2_num <= to_integer(writedata(15 downto 0));  
					elsif ram_address  = x"0032" then
					    timer3_num <= to_integer(writedata(15 downto 0));
					elsif ram_address  = x"0033" then
					    timer4_num <= to_integer(writedata(15 downto 0));
					
					
					elsif ram_address(15) = '1' then 
						if ( ram_address(14) = '0' ) then 
							kill_info := ram_address(6 downto 0);
							if ( kill_info <= 31 ) then 
								alien_status_1(to_integer(kill_info)) <= '0';
							else 
								alien_status_2(to_integer(kill_info-31)) <= '0';
							end if;
						elsif ( ram_address(14) = '1' ) then 
							barricade_status(to_integer(ram_address(7 downto 6)))(to_integer(ram_address(5 downto 0))) <= '0';
						end if;
						
						
						---------------------------------------------------
						elsif ram_address=x"0034" then
							game_state<=to_integer(writedata(15 downto 0));
							--game_state<=3;
					   ---------------------------------------------------
					end if ; 	
				end if;
	
				if ( read = '1' ) then
					if ram_address = "00000000" then
						readdata <= home_h_coord;
					elsif ram_address = "00000001" then 
						readdata <= wave_h_coord;
					elsif ram_address = "00000010" then
						readdata <= wave_v_coord;
					end if ;
				end if; -- read  
			end if; -- chipselect
		end if; -- reset 
	end if; -- rising edge 

end process ListenForUpdates; 

  -- Registered video signals going to the video DAC

VideoOut: process (clk25, reset)
begin
    if reset = '1' then
		VGA_R <= "0000000000";
		VGA_G <= "0000000000";
		VGA_B <= "0000000000";

    elsif clk25'event and clk25 = '1' then
		if home_bit = '1' then
			VGA_R <= "1111111111";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";
		
		elsif wave_bit = '1' then
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "0000000000";
		
		elsif homemissile_bit = '1' then 
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "1111111111";
			
		elsif alienmissile_bits(0) = '1' or alienmissile_bits(1) = '1' or alienmissile_bits(2) = '1'
		or alienmissile_bits(3) = '1' or alienmissile_bits(4) = '1' or alienmissile_bits(5) = '1'
		or alienmissile_bits(6) = '1' or alienmissile_bits(7) = '1' or alienmissile_bits(8)='1' or alienmissile_bits(9)='1'
		then 
			VGA_R <= "1111111111";
			VGA_G <= "0000000000";
			VGA_B <= "1111111111";

		elsif score_bit = '1' then  
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "1111111111";
			
		elsif score_bit_1='1' then	
			VGA_R <= "0000000000";
			VGA_G <= "1111111111";
			VGA_B <= "0000000000";
			
		elsif intro_bit = '1' then  
			VGA_R <= "0000000000";
			VGA_G <= "1111111111";
			VGA_B <= "0000000000";	

		elsif game_over_bit = '1' then  
			VGA_R <= "1111111111";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";	
	
		elsif lives_bit = '1' then
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "1111111111"; 
			
		elsif lives_bit_1 = '1' or lives_bit_2 = '1' or lives_bit_3 = '1' then
			VGA_R <= "1111111111";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";
			
		elsif timer_bit = '1' or timer_bit_1 = '1' or timer_bit_2 = '1' 
		or timer_bit_3 = '1' or timer_bit_4 = '1'  then
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "1111111111"; 	
			
		elsif barricade1_bit = '1' or barricade2_bit = '1' or barricade3_bit = '1' or barricade4_bit = '1' then
			VGA_R <= "0000000000";
			VGA_G <= "1111111111";
			VGA_B <= "0000000000"; 	
			
			
		elsif star1_bit = '1' or star2_bit = '1' or star3_bit = '1' or star4_bit = '1' or star5_bit = '1' 
        or star6_bit = '1' or star7_bit = '1' or star8_bit = '1' or star9_bit = '1' or star10_bit = '1' 
        or star11_bit = '1' or star12_bit = '1' or star13_bit = '1' or star14_bit = '1' or star15_bit = '1' 
        or star16_bit  = '1' or star17_bit = '1' then
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "1111111111";	

		elsif vga_hblank = '0' and vga_vblank ='0' then
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";
		else
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";    
		end if;
	end if;
end process VideoOut;

VGA_CLK <= clk25;
VGA_HS <= not vga_hsync;
VGA_VS <= not vga_vsync;
VGA_SYNC <= '0';
VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;
