--audio peripheral
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity audio_peripheral is

port(
	
	avs_s1_clk : in std_logic;
	avs_s1_reset_n : in std_logic;
	avs_s1_read : in std_logic;
	avs_s1_write: in std_logic;
	avs_s1_chipselect: in std_logic;
	avs_s1_address: in std_logic;
	avs_s1_readdata: out unsigned(31 downto 0);
	avs_s1_writedata: in unsigned(31 downto 0);
	freq : out std_logic_vector(15 downto 0);
	mod_depth: out std_logic_vector(3 downto 0);
	--on_off: out std_logic
	on_off:out std_logic_vector(15 downto 0)
);

end audio_peripheral;


architecture rtl of audio_peripheral is 

	signal frq_reg: unsigned(31 downto 0);
	signal mod_depth_reg:unsigned(3 downto 0);
	signal cnt:unsigned(27 downto 0):=x"0000000";
	signal x: std_logic:='0';
	signal y: std_logic:='0';
	signal flag: unsigned(2 downto 0):="011";
	signal clk : std_logic:='0';

begin  


clk<=avs_s1_clk;

 peripheral:process(clk)
	begin
		if rising_edge(clk) then
			if avs_s1_reset_n = '0' then

					avs_s1_readdata<=(others=>'0');
			else
			    if avs_s1_chipselect = '1' then
                  if avs_s1_write = '1' then
					if avs_s1_address = '0' then
						frq_reg<=avs_s1_writedata(31 downto 0);
					end if;
				  end if;
				end if;
			end if;
		end if;
end process peripheral;


	process(clk)
	variable time_counter : integer := 0; 
		begin
		 if rising_edge(clk) then	
				
				freq<= std_logic_vector(frq_reg(15 downto 0));
				--freq<=X"00AA";
				mod_depth<=x"A";
				
						
				on_off<=std_logic_vector(frq_reg(31 downto 16));
				--on_off<=x"1111";
		end if;
		
	end process;
end rtl;		