--Legal Notice: (C)2007 Altera Corporation. All rights reserved.  Your
--use of Altera Corporation's design tools, logic functions and other
--software and tools, and its AMPP partner logic functions, and any
--output files any of the foregoing (including device programming or
--simulation files), and any associated documentation or information are
--expressly subject to the terms and conditions of the Altera Program
--License Subscription Agreement or other applicable license agreement,
--including, without limitation, that your use is for the sole purpose
--of programming logic devices manufactured by Altera and sold by Altera
--or its authorized distributors.  Please refer to the applicable
--agreement for further details.


-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity transfer is 
        port (
              -- inputs:
                 signal address : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal chipselect : IN STD_LOGIC;
                 signal clk50 : IN STD_LOGIC;
                 signal read : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal write : IN STD_LOGIC;
                 signal writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);

              -- outputs:
                 signal ch : OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
                 signal cv : OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
                 signal h : OUT STD_LOGIC;
                 signal r : OUT STD_LOGIC_VECTOR (5 DOWNTO 0);
                 signal readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
              );
end entity transfer;


architecture europa of transfer is
component data_transfer is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk50 : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);

                 -- outputs:
                    signal ch : OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
                    signal cv : OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
                    signal h : OUT STD_LOGIC;
                    signal r : OUT STD_LOGIC_VECTOR (5 DOWNTO 0);
                    signal readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
                 );
end component data_transfer;

                signal internal_ch :  STD_LOGIC_VECTOR (11 DOWNTO 0);
                signal internal_cv :  STD_LOGIC_VECTOR (11 DOWNTO 0);
                signal internal_h :  STD_LOGIC;
                signal internal_r :  STD_LOGIC_VECTOR (5 DOWNTO 0);
                signal internal_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);

begin

  --the_data_transfer, which is an e_instance
  the_data_transfer : data_transfer
    port map(
      ch => internal_ch,
      cv => internal_cv,
      h => internal_h,
      r => internal_r,
      readdata => internal_readdata,
      address => address,
      chipselect => chipselect,
      clk50 => clk50,
      read => read,
      reset_n => reset_n,
      write => write,
      writedata => writedata
    );


  --vhdl renameroo for output signals
  ch <= internal_ch;
  --vhdl renameroo for output signals
  cv <= internal_cv;
  --vhdl renameroo for output signals
  h <= internal_h;
  --vhdl renameroo for output signals
  r <= internal_r;
  --vhdl renameroo for output signals
  readdata <= internal_readdata;

end europa;

