library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity silhouette_generator is

	port (
		clk : in std_logic;
		fg : in unsigned(23 downto 0);
		bg : in unsigned(23 downto 0);
		rx : out unsigned(6 downto 0);
		ry : out unsigned(5 downto 0);
		xo : out unsigned(4 downto 0);
		yo : out unsigned(3 downto 0);
		do : out std_logic
	);

end silhouette_generator;

architecture arch of silhouette_generator is

	constant Y_TOL : integer := 127;
	constant Cb_TOL : integer := 2;
	constant Cr_TOL : integer := 2;
	
	signal x80 : unsigned(6 downto 0);
	signal y60 : unsigned(5 downto 0);
	
	type buf_type5 is array(0 to 19) of unsigned(4 downto 0);
	signal count : buf_type5 := (others => (others => '0'));
	
	signal sil_buf : std_logic_vector(0 to 19) := (others => '0');

begin

	XYCounter : process (clk)
	begin
		if rising_edge(clk) then
			if x80 < 79 then
				x80 <= x80 + 1;
			else
				x80 <= (others => '0');
				if y60 < 59 then
					y60 <= y60 + 1;
				else
					y60 <= (others => '0');
				end if;
			end if;
		end if;
	end process XYCounter;

	process (clk)
	begin
		if rising_edge(clk) then
			----------------------------------------------------------------------------------------------------
			if x80(1 downto 0) = "00" and y60(1 downto 0) = "00" then
				
				if fg(23 downto 16) > bg(23 downto 16) then
					if fg(23 downto 16) - bg(23 downto 16) > Y_TOL then
						count(to_integer(x80(6 downto 2))) <= "00001";
					else
						if fg(15 downto 8) > bg(15 downto 8) then
							if fg(15 downto 8) - bg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= "00001";
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								end if;
							end if;
						else
							if bg(15 downto 8) - fg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= "00001";
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								end if;
							end if;
						end if;
					end if;
				else
					if bg(23 downto 16) - fg(23 downto 16) > Y_TOL then
						count(to_integer(x80(6 downto 2))) <= "00001";
					else
						if fg(15 downto 8) > bg(15 downto 8) then
							if fg(15 downto 8) - bg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= "00001";
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								end if;
							end if;
						else
							if bg(15 downto 8) - fg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= "00001";
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= "00001";
									else
										count(to_integer(x80(6 downto 2))) <= (others => '0');
									end if;
								end if;
							end if;
						end if;
					end if;
				end if;
			----------------------------------------------------------------------------------------------------
			elsif x80(1 downto 0) = "11" and y60(1 downto 0) = "11" then
			
				if count(to_integer(x80(6 downto 2))) < 8 then
					sil_buf(to_integer(x80(6 downto 2))) <= '0';
				elsif count(to_integer(x80(6 downto 2))) > 8 then
					sil_buf(to_integer(x80(6 downto 2))) <= '1';
				-- borderline case; must evaluate 16th square
				elsif fg(23 downto 16) > bg(23 downto 16) then
					if fg(23 downto 16) - bg(23 downto 16) > Y_TOL then
						sil_buf(to_integer(x80(6 downto 2))) <= '1';
					else
						if fg(15 downto 8) > bg(15 downto 8) then
							if fg(15 downto 8) - bg(15 downto 8) > Cb_TOL then
								sil_buf(to_integer(x80(6 downto 2))) <= '1';
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								end if;
							end if;
						else
							if bg(15 downto 8) - fg(15 downto 8) > Cb_TOL then
								sil_buf(to_integer(x80(6 downto 2))) <= '1';
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								end if;
							end if;
						end if;
					end if;
				else
					if bg(23 downto 16) - fg(23 downto 16) > Y_TOL then
						sil_buf(to_integer(x80(6 downto 2))) <= '1';
					else
						if fg(15 downto 8) > bg(15 downto 8) then
							if fg(15 downto 8) - bg(15 downto 8) > Cb_TOL then
								sil_buf(to_integer(x80(6 downto 2))) <= '1';
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								end if;
							end if;
						else
							if bg(15 downto 8) - fg(15 downto 8) > Cb_TOL then
								sil_buf(to_integer(x80(6 downto 2))) <= '1';
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										sil_buf(to_integer(x80(6 downto 2))) <= '1';
									else
										sil_buf(to_integer(x80(6 downto 2))) <= '0';
									end if;
								end if;
							end if;
						end if;
					end if;
				end if;
				
			----------------------------------------------------------------------------------------------------
			else
			
				if fg(23 downto 16) > bg(23 downto 16) then
					if fg(23 downto 16) - bg(23 downto 16) > Y_TOL then
						count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
					else
						if fg(15 downto 8) > bg(15 downto 8) then
							if fg(15 downto 8) - bg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								end if;
							end if;
						else
							if bg(15 downto 8) - fg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								end if;
							end if;
						end if;
					end if;
				else
					if bg(23 downto 16) - fg(23 downto 16) > Y_TOL then
						count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
					else
						if fg(15 downto 8) > bg(15 downto 8) then
							if fg(15 downto 8) - bg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								end if;
							end if;
						else
							if bg(15 downto 8) - fg(15 downto 8) > Cb_TOL then
								count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
							else
								if fg(7 downto 0) > bg(7 downto 0) then
									if fg(7 downto 0) - bg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								else
									if bg(7 downto 0) - fg(7 downto 0) > Cr_TOL then
										count(to_integer(x80(6 downto 2))) <= count(to_integer(x80(6 downto 2))) + 1;
									end if;
								end if;
							end if;
						end if;
					end if;
				end if;
				
			end if;
			
			-- outputs
			xo <= to_unsigned(to_integer(y60(1 downto 0))*5 + to_integer(x80(6 downto 4)), 5);
			if y60 > 3 then
				yo <= y60(5 downto 2) - 1;
			else
				yo <= "1110"; -- 14
			end if;
			do <= sil_buf(to_integer(y60(1 downto 0))*5 + to_integer(x80(6 downto 4)));
			
		end if;
	end process;

	rx <= x80; -- not sure why this works
	ry <= y60; -- thought that rx and ry needed to be 1 cycle ahead of x80 and y60

end arch;
