library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity ram_img is

	port (
		wclk : in std_logic;
		rclk : in std_logic;
		we : in std_logic;
		wx : in unsigned(6 downto 0);
		wy : in unsigned(5 downto 0);
		di : in unsigned(23 downto 0);
		rx : in unsigned(6 downto 0);
		ry : in unsigned(5 downto 0);
		do : out unsigned(23 downto 0)
	);

end ram_img;

architecture rtl of ram_img is
type ram_type is array(0 to 4799) of unsigned(23 downto 0);
signal RAM : ram_type := (others => (others => '0'));

begin

process (wclk)
begin
	if rising_edge(wclk) then
		if we = '1' then
			RAM(to_integer(wy)*80 + to_integer(wx)) <= di;
		end if;
	end if;
end process;

process (rclk)
begin
	if rising_edge(rclk) then
		do <= RAM(to_integer(ry)*80 + to_integer(rx));
	end if;
end process;

end rtl;
