library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity downscaler is

	port (
		clk : in std_logic;
		blank : in std_logic;
		sync : in std_logic;
		hs : in std_logic;
		vs : in std_logic;
		x640 : in unsigned(9 downto 0);
		y480 : in unsigned(8 downto 0);
		Y : in unsigned(7 downto 0);
		Cb : in unsigned(7 downto 0);
		Cr : in unsigned(7 downto 0);
		x80 : out unsigned(6 downto 0);
		y60 : out unsigned(5 downto 0);
		YCbCr : out unsigned(23 downto 0)
	);

end downscaler;

architecture arch of downscaler is

	type buf_type14 is array(0 to 79) of unsigned(13 downto 0);
	signal Y_buf : buf_type14 := (others => (others => '0'));
	signal Cb_buf : buf_type14 := (others => (others => '0'));
	signal Cr_buf : buf_type14 := (others => (others => '0'));
	
	type buf_type24 is array(0 to 79) of unsigned(23 downto 0);
	signal YCbCr_buf : buf_type24 := (others => (others => '0'));

begin

	-- downscale a line
	process (clk)
	begin
		if rising_edge(clk) then
			--if hs = '0' and vs = '0' then
				if x640(2 downto 0) = "000" and y480(2 downto 0) = "000" then
					Y_buf(to_integer(x640(9 downto 3))) <= "000000" & Y;
					Cb_buf(to_integer(x640(9 downto 3))) <= "000000" & Cb;
					Cr_buf(to_integer(x640(9 downto 3))) <= "000000" & Cr;
				elsif x640(2 downto 0) = "111" and y480(2 downto 0) = "111" then
					YCbCr_buf(to_integer(x640(9 downto 3))) <=
							(Y_buf(to_integer(x640(9 downto 3)))(13 downto 6) + Y(7 downto 6))
							& (Cb_buf(to_integer(x640(9 downto 3)))(13 downto 6) + Cb(7 downto 6))
							& (Cr_buf(to_integer(x640(9 downto 3)))(13 downto 6) + Cr(7 downto 6));
							-- averaging not perfect, but close
				else
					Y_buf(to_integer(x640(9 downto 3))) <= Y_buf(to_integer(x640(9 downto 3))) + Y;
					Cb_buf(to_integer(x640(9 downto 3))) <= Cb_buf(to_integer(x640(9 downto 3))) + Cb;
					Cr_buf(to_integer(x640(9 downto 3))) <= Cr_buf(to_integer(x640(9 downto 3))) + Cr;
				end if;
				
				-- outputs
				x80 <= to_unsigned(to_integer(y480(2 downto 0))*10 + to_integer(x640(9 downto 6)), 7);
				if y480 > 7 then
					y60 <= y480(8 downto 3) - 1;
				else
					y60 <= "111011"; -- 59
				end if;
				YCbCr <= YCbCr_buf(to_integer(y480(2 downto 0))*10 + to_integer(x640(9 downto 6)));
			--end if;
		end if;
	end process;

end arch;
