module TV_to_VGA (
			OSC_27,
			RESET,
 			VGA_BLANK,
			VGA_SYNC,
			VGA_CLOCK,
			VGA_HS,
 			VGA_VS,
			x640,						// Modified by VL
			y480,						// Modified by VL
//			VGA_R,						// Modified by VL
// 			VGA_G,						// Modified by VL
// 			VGA_B,						// Modified by VL
			Y,							// Modified by VL
			Cb,							// Modified by VL
			Cr,							// Modified by VL
 			TD_D,
 			TD_HS,
 			TD_VS
);
input		    OSC_27;
input			RESET;
output 			VGA_BLANK;
output			VGA_SYNC;
output			VGA_CLOCK;
output			VGA_HS;
output 			VGA_VS;
output 			[9:0]x640;				// Modified by VL
output 			[8:0]y480;				// Modified by VL
//output			[9:0]VGA_R;			// Modified by VL
//output 			[9:0]VGA_G;			// Modified by VL
//output 			[9:0]VGA_B;			// Modified by VL
input 			[7:0]TD_D;
input 			TD_HS;
input 			TD_VS;


output [7:0]	Y;       //4:4:4 Y		// Modified by VL
output [7:0]	Cb;      //4:4:4 Cb		// Modified by VL
output [7:0]	Cr;      //4:4:4 Cr		// Modified by VL
wire mTD_HSx2;

itu_r656_decoder U1
(
	.CLOCK(OSC_27),		//system clock
	.TD_D(TD_D[7:0]),	//4:2:2 video data stream
 	.TD_HS(TD_HS),		//Decoder_hs 
	.TD_VS(TD_VS),		//Decoder_vs	
	.Y(Y[7:0]),       	//4:4:4 Y
	.Cb(Cb[7:0]),      	//4:4:4 Cb
	.Cr(Cr[7:0]),      	//4:4:4 Cr
    .HSx2(mTD_HSx2),       
	.blank(VGA_BLANK)
);

//YCbCr2RGB U2(							// Modified by VL
//	.Red(VGA_R[9:0]),					// Modified by VL
//	.Green(VGA_G[9:0]),					// Modified by VL
//	.Blue(VGA_B[9:0]),					// Modified by VL
//	.iY(Y[7:0]),						// Modified by VL
//	.iCb(Cb[7:0]),						// Modified by VL
//	.iCr(Cr[7:0]),						// Modified by VL
//	.iRESET(!RESET),					// Modified by VL
//	.iCLK(OSC_27)						// Modified by VL
//	);									// Modified by VL

`include "VGA_Param.h"
reg 	[10:0]L_COUNTER;//<<
reg 	[10:0]RL_COUNTER;//<<
wire 	sync_reset=(RL_COUNTER==9)?1:0;//<<
reg  	sync_en;//<<
reg  	[7:0]delay;//<<

reg		[9:0]	H_Cont;
reg		[9:0]	V_Cont;
reg		[9:0]	X_Count;				// Modified by VL
reg		[8:0]	Y_Count;				// Modified by VL
reg				oVGA_H_SYNC;
reg				oVGA_V_SYNC;
reg				Pre_HS;
reg				Pre_VS;
reg				mACT_HS;
reg				mACT_VS;

always@(posedge OSC_27 or negedge sync_en)//<<
begin
	if(!sync_en)//<<
	begin
		Pre_HS		<=	0;
		mACT_HS		<=	0;
		H_Cont		<=	0;
		oVGA_H_SYNC	<=	0;
		X_Count		<=	0;				// Modified by VL
	end
	else
	begin
		Pre_HS	<=	mTD_HSx2;
		if({Pre_HS,mTD_HSx2}==2'b10)
		mACT_HS	<=	1;
		if(mACT_HS)
		begin
			//	H_Sync Counter
			if( H_Cont < 852 )
			H_Cont	<=	H_Cont+1;
			else
			begin
				H_Cont	<=	0;
				mACT_HS	<=	0;
			end
			//	H_Sync Generator
			if( H_Cont < H_SYNC_CYC )
			oVGA_H_SYNC	<=	0;
			else
			oVGA_H_SYNC	<=	1;
			//	X_Count Generator		// Modified by VL
			if( H_Cont > X_START && X_Count < 639 )	// Modified by VL
			X_Count	<=	X_Count+1;		// Modified by VL
			else						// Modified by VL
			X_Count	<=	0;				// Modified by VL
		end
		else
		begin
			oVGA_H_SYNC	<=	0;
			H_Cont		<=	0;
		end
	end
end

always@(posedge OSC_27 or negedge sync_en)//<<
begin
	if(!sync_en)//<<
	begin
		Pre_VS		<=	1;
		mACT_VS		<=	0;
		V_Cont		<=	0;
		oVGA_V_SYNC	<=	0;
		Y_Count		<=	0;				// Modified by VL
	end
	else
	begin
		Pre_VS	<=	TD_VS;
		if({Pre_VS,TD_VS}==2'b01)
		mACT_VS	<=	1;
		if( (H_Cont==1) && mACT_VS)
		begin
			//	V_Sync Counter
			if( V_Cont < 524 )
			V_Cont	<=	V_Cont+1;
			else
			V_Cont	<=	0;
			//	V_Sync Generator
			if(	V_Cont < V_SYNC_CYC )
			oVGA_V_SYNC	<=	0;
			else
			oVGA_V_SYNC	<=	1;
			//	Y_Count Generator		// Modified by VL
			if( V_Cont > Y_START && Y_Count < 479 )	// Modified by VL
			Y_Count	<=	Y_Count+1;		// Modified by VL
			else						// Modified by VL
			Y_Count	<=	0;				// Modified by VL
		end
	end
end

assign	x640		=	X_Count;		// Modified by VL
assign	y480		=	Y_Count;		// Modified by VL
assign	VGA_HS		=	oVGA_H_SYNC;
assign	VGA_VS		=	oVGA_V_SYNC;
assign	VGA_SYNC	=	1'b0;
assign	VGA_CLOCK	=	OSC_27;


//>>lock detector
always @(posedge TD_HS) begin
if (TD_VS) L_COUNTER=0;		  
			else L_COUNTER=L_COUNTER+1;
end			

always @(posedge TD_VS) begin
		RL_COUNTER=L_COUNTER;//1714
end	
always@(negedge sync_reset or posedge TD_VS) begin
if (!sync_reset)
	delay=0;
    else if (delay < 250)
	 delay=delay+1;
end	

always@(negedge sync_reset or negedge TD_VS) begin
if (!sync_reset)     
		sync_en=0; 
else if (delay < 100)
    sync_en=0; 
    else
	sync_en=1;
end
//<<

endmodule
