#include <io.h>
#include <system.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
    
#define maxFlyingBeeNum 7
#define maxPlaneLife 3
#define maxBeeLife 36

int flags = 0;
volatile unsigned int data;

typedef struct {
    int flying;
    int angle;
    int flyingH;
    int flyingV;
    int row;
    int column;
    int flySide;
    int angleCount;
    int circleCount;
    int smoothCount;
    int flyCount;
    int flyCountToBe;
    int bulletLeftCount;
    int done;
    int k;
    int turn;
    int track;
    int type;
    int bulletLeft;
} bee;

typedef struct bullet{
    int h;
    int v;
    int k;
    int number;
    int beeBulletMoveDown;
    struct bullet* prevBullet;
    struct bullet* nextBullet;
} bullet;

static inline void resetFlyingBee (bee* thisBee)
{
    thisBee->flying = 0;
    thisBee->angle = 0;
    thisBee->flyingH = 600;
    thisBee->flyingV = 440;
    thisBee->row = -1;
    thisBee->column = -1;
    thisBee->flySide = 0;
    thisBee->angleCount = 0;
    thisBee->circleCount = 0;
    thisBee->smoothCount = 0;
    thisBee->flyCount = 0;
    thisBee->flyCountToBe = 0;
    thisBee->bulletLeftCount = 0;
    thisBee->done = 0;
    thisBee->k = -1;
    thisBee->turn = 0;
    thisBee->track = 0;
    thisBee->type = 0;
    thisBee->bulletLeft = 0;
}

static inline void showStart (int startPicV)
{
    flags = 1;
    data = (flags << 20) + (startPicV << 10) + 1;
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void hideStart (int startPicV)
{
    flags = 1;
    data = (flags << 20) + (startPicV << 10);
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void showInfo (int level, int life)
{
    flags = 2;
    data = (flags << 20) + (life << 3) + (level+1);
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void clearScreen()
{
    flags = 3;
    data = (flags << 20);
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void showReady()
{
    flags = 4;
    data = (flags << 20) + 1;
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void hideReady()
{
    flags = 4;
    data = (flags << 20);
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void showPause()
{
    flags = 5;
    data = (flags << 20) + 1;
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void hidePause()
{
    flags = 5;
    data = (flags << 20);
    IOWR_32DIRECT(VGA_BASE, 16, data);
}

static inline void showGameOver ()
{
    int i, j = 0;
    int gameover[8][2] = {{100, 50}, {310, 50}, {120, 450}, {330, 450}, {150, 450}, {360, 50}, {170, 50}, {380, 450}};
    int path[8][2] = { {1, 2}, {-1, 2}, {1, -2}, {-1, -2}, {1, -2}, {-1, 2}, {1, 2}, {-1, -2}};
    
    flags = 6;
    while (j++ < 100) {
        IOWR_32DIRECT(VGA_BASE, 52, 0);
        for (i = 0; i < 8; i++) {
            gameover[i][0] += path[i][0];
            gameover[i][1] += path[i][1];
            data = ((flags + i) << 20) + (gameover[i][0] << 10) + gameover[i][1];
            IOWR_32DIRECT(VGA_BASE, 16, data);
        }
        usleep(10000);
        while (IORD_32DIRECT(VGA_BASE, 0) != 0x0F);
    }
    
    while (1) {
        if(IORD_8DIRECT(PS2_BASE, 0)) {
            if (IORD_8DIRECT(PS2_BASE, 4) == 0x3B) {
                break;
            }
        }
    }
    for (i = 0; i < 8; i++) {
        data = ((flags + i) << 20) + (600 << 10) + 400;
        IOWR_32DIRECT(VGA_BASE, 16, data);
    }
    
}

static inline void showPlane (int planeH, int planeV)
{
    data = (planeH << 10) + planeV;
    IOWR_32DIRECT(VGA_BASE, 28, data);    
}

static inline void showBullet(int bulletH, int bulletV)
{
    data = (bulletH << 10) + bulletV;
    IOWR_32DIRECT(VGA_BASE, 24, data);
}

static inline void showBeeBullet(bullet* thisBullet)
{
    flags = thisBullet->number;
    data = (flags << 20) + (thisBullet->h << 10) + thisBullet->v;
    IOWR_32DIRECT(VGA_BASE, 40, data);
}

static inline void addBullet(int planeH, int planeV, int flyingH, int flyingV, int number, bullet** head)
{
    bullet* newBullet = malloc(sizeof(bullet));
    if (newBullet == NULL)
        return;
    
    if (planeH < flyingH - 10)
        newBullet->k = -1;
    else if (planeH > flyingH + 10)
        newBullet->k = 1;
    else
        newBullet->k = 0;
        
    newBullet->h = flyingH;
    newBullet->v = flyingV;
    newBullet->number = number;
    newBullet->beeBulletMoveDown = 0;
    
    if (head == NULL) {
        newBullet->prevBullet = NULL;
        newBullet->nextBullet = NULL;
        *head = newBullet;
    } else {
        newBullet->prevBullet = NULL;
        newBullet->nextBullet = *head;
        (*head)->prevBullet = newBullet;
        *head = newBullet;
    }
}

static inline void delBullet(bullet* thisBullet)
{
    thisBullet->h = 600;
    thisBullet->v = 400;
    showBeeBullet(thisBullet);
    if (thisBullet->prevBullet != NULL)
        thisBullet->prevBullet->nextBullet = thisBullet->nextBullet;
    if (thisBullet->nextBullet != NULL)
        thisBullet->nextBullet->prevBullet = thisBullet->prevBullet;
    free(thisBullet);
    thisBullet = NULL;
}

static inline void clearBulletList(bullet* head)
{
    bullet* curr;
    while (head != NULL) {
        curr = head;
        head = curr->nextBullet;
        delBullet(curr);
    }
}

static inline void showBeeMax(int beeMaxH, int beeMaxV)
{
    data = (beeMaxH << 10) + beeMaxV;
    IOWR_32DIRECT(VGA_BASE, 32, data);
}

static inline void showAlive(int alive[])
{
    int i = 0;
    for (i = 0; i < 5; i++) {
        data = (1 << (i + 20)) + alive[i]; 
        IOWR_32DIRECT(VGA_BASE, 20, data);
    }
}

static inline void showFlyingBee(bee thisBee, int i)
{
    flags = (thisBee.angle << 7) + (thisBee.type << 3) + i; 
    data = (flags << 20) + (thisBee.flyingH << 10) + thisBee.flyingV;
    IOWR_32DIRECT(VGA_BASE, 48, data);
}

static inline void showExplosion (int expH, int expV, int small)
{
    data = (small << 20) + (expH << 10) + expV;
    IOWR_32DIRECT(VGA_BASE, 8, data);
}

static inline void showPlaneExplosion (int expH, int expV, int small)
{
    data = (small << 20) + (expH << 10) + expV;
    IOWR_32DIRECT(VGA_BASE, 12, data);
}

static inline void showScore (int *hiScore, int score)
{
    int first, second, third, fourth, fifth;

    fifth = score / 10000;
    fourth = score / 1000 - fifth*10;
    third = score / 100 - fifth*100 - fourth*10;
    second = score / 10 - fifth*1000 - fourth*100 - third*10;
    first = score - fifth*10000 - fourth*1000 - third*100 - second*10;
    
    if (*hiScore < score) {
        *hiScore = score;
        data = (first << 16) + (second << 12) + (third << 8) + (fourth << 4) + fifth;
        IOWR_32DIRECT(VGA_BASE, 4, data);
    }

    data = (first << 16) + (second << 12) + (third << 8) + (fourth << 4) + fifth;
    IOWR_32DIRECT(VGA_BASE, 0, data);
}

static inline int chooseBeeToFly(bee* thisBee, int alive[])
{   
    int i, j;
    int side = rand()%10;
    if (side < 5) {
        for (i = 0; i < 19; i+=2) {
            for (j = 0; j < 5; j++) {
                if ((alive[j] & (1 << (19 - i))) >> (19 - i) == 1) {
                    thisBee->row = i;
                    thisBee->column = j<<1;
                    thisBee->flySide = 1;
                    alive[j] ^= 1 << (19 -i);
                    return 1;
                }
            }
        }
    } else {
        for (i = 18; i >= 0; i-=2) {
            for (j = 0; j < 5; j++) {
                if ((alive[j] & (1 << (19 - i))) >> (19 - i) == 1) {
                    thisBee->row = i;
                    thisBee->column = j<<1;
                    thisBee->flySide = -1;
                    alive[j] ^= 1 << (19 -i);
                    return 1;
                }
            }
        }
    }
    
    return 0;
}

static inline int convertAngle (int original, int invert)
{
    int transAngle;
    float angle = original * 180 / 106;
    if (invert < 0)
        angle = 360 - angle;
    
    if ((angle >= 0 && angle < 10) || (angle >= 350 && angle < 360)) {
        transAngle = 0;                             // 0 0 0 0 = 0
    } else if (angle >= 10 && angle < 30) {
        transAngle = 4;                             // 0 1 0 0 = 4
    } else if (angle >= 30 && angle < 60) {
        transAngle = 8;                             // 1 0 0 0 = 8
    } else if (angle >= 60 && angle < 80) {
        transAngle = 12;                            // 1 1 0 0 = 12 
    } else if (angle >= 80 && angle < 100) {
        transAngle = 1;                             // 0 0 0 1 = 1
    } else if (angle >= 100 && angle < 120) {
        transAngle = 14;                            // 1 1 1 0 = 14
    } else if (angle >= 120 && angle < 150) {
        transAngle = 10;                            // 1 0 1 0 = 10
    } else if (angle >= 150 && angle < 170) {
        transAngle = 6;                             // 0 1 1 0 = 6          
    } else if (angle >= 170 && angle < 190) {
        transAngle = 2;                             // 0 0 1 0 = 2
    } else if (angle >= 190 && angle < 210) {
        transAngle = 7;                             // 0 1 1 1 = 7
    } else if (angle >= 210 && angle < 240) {
        transAngle = 11;                            // 1 0 1 1 = 11
    } else if (angle >= 240 && angle < 260) {
        transAngle = 15;                            // 1 1 1 1 = 15
    } else if (angle >= 260 && angle < 280) {
        transAngle = 3;                             // 0 0 1 1 = 3
    } else if (angle >= 280 && angle < 300) {
        transAngle = 13;                            // 1 1 0 1 = 13
    } else if (angle >= 300 && angle < 330) {
        transAngle = 9;                             // 1 0 0 1 = 9
    } else if (angle >= 330 && angle < 350) {
        transAngle = 5;                             // 0 1 0 1 = 5
    }
    
    return transAngle;
}

static inline void facePlane (bee* thisBee, int planeH, int planeV)
{
    if (planeH == thisBee->flyingH) {
        if (planeV >= thisBee->flyingV)
            thisBee->angle = 2;
        else
            thisBee->angle = 0;
        return;
    }
    
    float k = (float) (planeV - thisBee->flyingV) / (planeH - thisBee->flyingH);
    
    if (planeV >= thisBee->flyingV) {
        if (k >= 5.67128) {
            thisBee->angle = 2;
        } else if (k >= 1.73205) {
            thisBee->angle = 7;
        } else if (k >= 0.57735) {
            thisBee->angle = 11;
        } else if (k > 0) {
            thisBee->angle = 15;
        } else if (k == 0) {
            if (planeH < thisBee->flyingH)
                thisBee->angle = 1;
            else
                thisBee->angle = 3;
        } else if (k >= -0.01) {
            thisBee->angle = 1;
        } else if (k >= -0.57735) {
            thisBee->angle = 14;
        } else if (k >= -1.73205) {
            thisBee->angle = 10;
        } else if (k >= -5.67128) {
            thisBee->angle = 6;
        } else {
            thisBee->angle = 2;
        }
    } 
    else {
        if (k >= 5.67128) {
            thisBee->angle = 0;
        } else if (k >= 1.73205) {
            thisBee->angle = 4;
        } else if (k >= 0.57735) {
            thisBee->angle = 8;
        } else if (k > 0) {
            thisBee->angle = 12;
        } else if (k == 0) {
            if (planeH < thisBee->flyingH)
                thisBee->angle = 1;
            else
                thisBee->angle = 3;
        } else if (k >= -0.01) {
            thisBee->angle = 3;
        } else if (k >= -0.57735) {
            thisBee->angle = 13;
        } else if (k >= -1.73205) {
            thisBee->angle = 9;
        } else if (k >= -5.67128) {
            thisBee->angle = 5;
        } else {
            thisBee->angle = 0;
        }
    }
}
              
int main() {
    
    int i;
    int fire = 0;
    int bulletAllowed = 1;
    int beeMaxDirection = 1;
    int beeMaxMoveWait = 0;
    int beeMaxMoveHold = 0;
    int breakcode = 0;
    int leftMove = 0;
    int rightMove = 0;
    int pause = 0;
    unsigned char code;
    
    int planeMoveCount = 0;
    int beeMaxMoveCount = 0;
    int bulletCount = 0;
    int beeBulletCount = 0;
    int explodeCount = 0;
    int outExplodeCount = 0;
    int planeExplodeCount = 0;
    int rebornCount = 0;
    int waitCount = 0;
    
    int bulletNum = 0;
    int flyingBeeNum = 0;
    int planeLife = maxPlaneLife;
    int beeLife = maxBeeLife;
    
    int bulletH;
    int bulletV = 400;
    int planeH = 267;
    int planeV = 400;
    int beeMaxH = 100;
    int beeMaxV = 50;
    int outExpH;
    int outExpV;    
    int startPicV = 480;
    
    const int BEEMAX_LONG = 304;
    const int BEEMAX_HEIGHT = 144;
    
    int level = 0;
    int score = 0;
    int hiScore = 5000;

    bullet* head = NULL;
    bee flyingBee[maxFlyingBeeNum];
    int alive[5] = {8320, 43680, 174760, 699050, 699050};
    const int initAlive[5] = {8320, 43680, 174760, 699050, 699050};
    int scoreArray[5] = {60, 50, 40, 30, 30};
    int backAngle[16] = {0, 0, 5, 4, 9, 8, 13, 12, 3, 1, 15, 14, 11, 10, 7, 6};
    int beeBullet[8] = {1, 2, 2, 3, 3, 3, 4, 4};
    int waitTime = 2000;
    int beeLifeThreshold[8][4] = {{20, 10, 5, 1},
                                  {22, 12, 6, 2},
                                  {24, 14, 7, 3},
                                  {26, 16, 8, 4},
                                  {28, 18, 9, 5},
                                  {30, 20, 10, 6},
                                  {32, 22, 11, 7},
                                  {34, 24, 12, 8}};
                       
    int waitTimeThreshold[8][5] = {{7600, 7100,  6600,  6100, 5600},
                                   {7400, 6900,  6400,  5900, 5400},
                                   {7200, 6700,  6200,  5700, 5200},
                                   {7000, 6500,  6000,  5500, 5000},
                                   {6800, 6300,  5800,  5300, 4800},
                                   {6600, 6100,  5600,  5100, 4600},
                                   {6400, 5900,  5400,  4900, 4400},
                                   {6200, 5700,  5200,  4700, 4200}};
                                   
    int circleChangeH[132] = { 0, 0, 0, 0, 0, 0,-1, 0, 0, 0,
                              -1, 0, 0,-1, 0, 0,-1, 0,-1,-1,
                               0,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                              -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                              -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                              -1,-1,-1,
                              -1,-1,-1,
                              -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                              -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                               0,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                              -1, 0, 0,-1, 0, 0,-1, 0,-1,-1,
                               0, 0, 0, 0, 0, 0,-1, 0, 0, 0,
                               
                               0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
                               1, 1, 0, 1, 0, 0, 1, 0, 0, 1,
                               1, 1, 1, 1, 1, 1};
                                 
    int circleChangeV[132] = {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                              -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                              -1,-1,-1,-1,-1,-1,-1,-1,-1, 0,
                              -1,-1, 0,-1,-1, 0,-1, 0, 0,-1,
                               0, 0,-1, 0, 0, 0,-1, 0, 0, 0,
                               0, 0, 0,
                               0, 0, 0,
                               0, 0, 1, 0, 0, 0, 1, 0, 0, 0,
                               1, 1, 0, 1, 1, 0, 1, 0, 0, 1,
                               1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
                               1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                               1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                               
                               1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                               1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                               0, 1, 1, 1, 1, 1};
                                   
    int turnChangeH[20] = { 1, 0, 1, 1, 0, 0, 1, 0, 0, 0,
                            0, 0, 0,-1, 0, 0,-1,-1, 0,-1};

start:     
    // clear any flying bee left on the screen                            
    for (i = 0; i < maxFlyingBeeNum; i++) {
        resetFlyingBee(&flyingBee[i]);
        showFlyingBee(flyingBee[i], i);
    }
    
    // clear gameover if left on the screen
    for (i = 0; i < 8; i++) {
        data = ((flags + i) << 20) + (600 << 10) + 400;
        IOWR_32DIRECT(VGA_BASE, 16, data);
    }
    hideReady();
    hidePause();    
    showScore(&hiScore, score);
    showInfo(level, planeLife);
   
    /*-----game start screen-----*/
    for (i = 480; i > 100; i--) {
        startPicV = i;
        showStart(startPicV);
        usleep(10000);
        while(IORD_8DIRECT(PS2_BASE, 0) == 1) {
            code = IORD_8DIRECT(PS2_BASE, 4);
        }
    }
    
    while (1) {
        if(IORD_8DIRECT(PS2_BASE, 0)) {
            if (IORD_8DIRECT(PS2_BASE, 4) == 0x5A) {
                hideStart(startPicV);
                break;
            }
        }
    }
            
    while (1) {
        IOWR_32DIRECT(VGA_BASE, 52, 0);
        showInfo(level, planeLife);
        
        /*-----keyboard control plane coordinate-----*/
        if(IORD_8DIRECT(PS2_BASE, 0)) {
            
            code = IORD_8DIRECT(PS2_BASE, 4);
            
            if (breakcode == 1) {
                breakcode = 0;
                switch (code) {
                case 0x1C:
                    leftMove = 0;
                    break;
                case 0x23:
                    rightMove = 0;
                    break;
                default:
                    break;
                }
            } else {
                switch (code) {
                case 0x29:
                    if (fire == 0 && rebornCount == 0) {
                        IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000061);
                        IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000008);
                        fire = 1;
                        bulletH = planeH + 10;
                    }
                    break;
                case 0x1C:
                    leftMove = -1;
                    break;
                case 0x23:
                    rightMove = 1;
                    break;
                case 0x5A:
                    pause = 1;
                    leftMove = 0;
                    rightMove = 0;
                    showPause();
                case 0xF0:
                    breakcode = 1;   
                }
            }
        }
        
        while (pause == 1) {
            
            if(IORD_8DIRECT(PS2_BASE, 0)) {
                code = IORD_8DIRECT(PS2_BASE, 4);
                
                if (breakcode == 1) {
                    breakcode = 0;
                    if (code == 0x5A) {
                        pause = 0;
                        hidePause();
                        break;
                    }
                } else {
                    if (code == 0xF0)
                        breakcode = 1;
                }
            }
        }
        
        
        if (planeLife == 0 && planeExplodeCount == 0 && outExplodeCount == 0 && explodeCount == 0) {
            showGameOver();
            
            fire = 0;
            bulletV = 400;
            level = 0;
            score = 0;
            showScore(&hiScore, score);
            planeLife = maxPlaneLife;
            memcpy(alive, initAlive, sizeof(alive));
            beeLife = maxBeeLife;
            waitCount = 0;
            rebornCount = 0;

            clearBulletList(head);
            leftMove = 0;
            rightMove = 0;
            goto start;
        }
        
        if (rebornCount == 0 && planeLife > 0) {
            if (planeMoveCount == 10) {
                planeMoveCount = 0;
                if ((planeH == 50 && leftMove == -1) || (planeH == 480 && rightMove == 1)) {
                }
                else
                    planeH += leftMove + rightMove;
            } else
                planeMoveCount++;
                
            showPlane(planeH, planeV);
            showBullet(bulletH, bulletV);
                
        } else {
            if (rebornCount == 1000 && planeLife > 0)
                showReady();
            rebornCount--;
            if (rebornCount == 0) {
                bulletAllowed = 1;
                hideReady();
            }
        }
        
        /*-----bullet coordinate-----*/
        if (bulletCount == 1) {
            bulletCount = 0;

            if (fire == 1) {
                bulletV--;
                if (bulletV == 0) {
                    bulletV = 400;
                    fire = 0;
                    showBullet(600, 400);
                    if (rebornCount > 0)
                        bulletAllowed = 0;
                }
                
            } else {
                bulletH = planeH + 10;
            }
            
            if (bulletAllowed == 1 && bulletV < 400)
                showBullet(bulletH, bulletV);

        } else
            bulletCount++;
            
        /*-----bee alive matrix-----*/
        
        if (beeLife == 0 && explodeCount == 0 && outExplodeCount == 0 && 
            planeExplodeCount == 0 && fire == 0 && head == NULL) {
               
            if (level < 7) 
                level++;
                
            beeLife = maxBeeLife;
            planeH = 267;
            memcpy(alive, initAlive, sizeof(alive));
            usleep(1000000);
            waitCount = 0;
            // clear plane moving direction
            leftMove = 0;
            rightMove = 0;
            while(IORD_8DIRECT(PS2_BASE, 0) == 1) {
                  code = IORD_8DIRECT(PS2_BASE, 4);
            }
            
        }
        
        showAlive(alive);
                 
        /*-----bee matrix coordinate-----*/
        if (beeMaxMoveCount == 20) {
            beeMaxMoveCount = 0;
            
            if (beeMaxMoveWait == 0) {
                beeMaxH += beeMaxDirection;
                if (beeMaxH <= 100)
                    beeMaxDirection = 1;
                else if (beeMaxH >= 150)
                    beeMaxDirection = -1;
                beeMaxMoveHold++;
                if (beeMaxMoveHold == 10)
                    beeMaxMoveWait = 1;
                showBeeMax(beeMaxH, beeMaxV);
            } else {
                beeMaxMoveHold--;
                if (beeMaxMoveHold == 0)
                    beeMaxMoveWait = 0;
            }
            
        } else
            beeMaxMoveCount++; 
        
        /*-----bullet hits bee in matrix-----*/ 
        if (bulletV >= beeMaxV && bulletV <= beeMaxV + BEEMAX_HEIGHT && 
            bulletH >= beeMaxH && bulletH <= beeMaxH + BEEMAX_LONG) {

            int col = (bulletV - beeMaxV) / 16;
            int row = (bulletH - beeMaxH) / 16;
                
            if (col%2 == 0 && (alive[col>>1] & (1 << (19 - row))) >> (19 - row) == 1) {
                alive[col>>1] &= ~ (1 << (19 - row));
                beeLife--;
                score += scoreArray[col>>1];
                showScore(&hiScore, score);
                fire = 0;
                bulletV = 400;
                outExpH = beeMaxH + 16*row;
                outExpV = beeMaxV + 16*col;
                showExplosion(outExpH, outExpV, 1);
                IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000062);
                IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000008);
                showBullet(600, 400);
                explodeCount = 1;
            }
        }

        
        /*----------explode count-----------*/
        if (explodeCount != 0) {
            if (explodeCount != 300) {
                explodeCount++;
                if (explodeCount == 150) {
                    showExplosion(outExpH, outExpV, 0);
                }
            } else {
                explodeCount = 0;
                showExplosion(600, 400, 0);
            }
        }
        
        /*----------out explode count-----------*/
        if (outExplodeCount != 0) {
            if (outExplodeCount != 300) {
                outExplodeCount++;
                if (outExplodeCount == 150) {
                    showExplosion(outExpH, outExpV, 0);
                }
            } else {
                outExplodeCount = 0;
                showExplosion(600, 400, 0);
            }
        }  
        
        /*----------plane explode count-----------*/
        if (planeExplodeCount != 0) {
            if (planeExplodeCount != 300) {
                planeExplodeCount++;
                if (planeExplodeCount == 150) {
                    showPlaneExplosion(planeH, planeV, 0);
                }
            } else {
                planeExplodeCount = 0;
                showPlaneExplosion(600, 400, 0);
                planeH = 267;
            }
        }

        
        /*-----flying bee coordinate-----*/
        if (beeLife > beeLifeThreshold[level][0])
            waitTime = waitTimeThreshold[level][0];
        else if (beeLife > beeLifeThreshold[level][1])
            waitTime = waitTimeThreshold[level][1];
        else if (beeLife > beeLifeThreshold[level][2])
            waitTime = waitTimeThreshold[level][2];
        else if (beeLife > beeLifeThreshold[level][3])
            waitTime = waitTimeThreshold[level][3];
        else
            waitTime = waitTimeThreshold[level][4];
        
        if (waitCount < waitTime)
            waitCount++;
        else {
            if (flyingBeeNum < maxFlyingBeeNum){
                int chosenRow[2];
                int chosenCol[2];
                int chosenSide;
                int chosenNum = 0;
                for (i = 0; i < maxFlyingBeeNum; i++) {
                    if (flyingBee[i].flying == 0) {
                        if (chosenNum > 0) {
                            chosenNum--;
                            flyingBee[i].row = chosenRow[chosenNum];
                            flyingBee[i].column = chosenCol[chosenNum];
                            flyingBee[i].flySide = chosenSide;
                            alive[flyingBee[i].column>>1] ^= 1 << (19 - flyingBee[i].row);
                            flyingBeeNum++;
                            flyingBee[i].flying = 1;
                            flyingBee[i].flyingH = beeMaxH + 16*flyingBee[i].row;
                            flyingBee[i].flyingV = beeMaxV + 16*flyingBee[i].column;
                            flyingBee[i].bulletLeft = beeBullet[level];
                            switch (flyingBee[i].column) {
                                case 0:
                                flyingBee[i].type = 3;
                                flyingBee[i].flyCountToBe = 7;
                                break;
                                case 2:
                                flyingBee[i].type = 2;
                                flyingBee[i].flyCountToBe = 7;
                                break;
                                case 4:
                                flyingBee[i].type = 1;
                                flyingBee[i].flyCountToBe = 6;
                                break;
                                default:
                                flyingBee[i].type = 0;
                                flyingBee[i].flyCountToBe = 8;
                                break;
                            }
                            waitCount = 0;
                        } else if (chooseBeeToFly(&flyingBee[i], alive) == 1) {
                            IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000063);
                            IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000008);
                            flyingBeeNum++;
                            flyingBee[i].flying = 1;
                            flyingBee[i].flyingH = beeMaxH + 16*flyingBee[i].row;
                            flyingBee[i].flyingV = beeMaxV + 16*flyingBee[i].column;
                            flyingBee[i].bulletLeft = beeBullet[level];
                            
                            switch (flyingBee[i].column) {
                                case 0:
                                flyingBee[i].type = 3;
                                flyingBee[i].flyCountToBe = 7;
                                break;
                                case 2:
                                flyingBee[i].type = 2;
                                flyingBee[i].flyCountToBe = 7;
                                break;
                                case 4:
                                flyingBee[i].type = 1;
                                flyingBee[i].flyCountToBe = 6;
                                break;
                                default:
                                flyingBee[i].type = 0;
                                flyingBee[i].flyCountToBe = 8;
                                break;
                            }

                            waitCount = 0;
                        
                            chosenSide = flyingBee[i].flySide;
                            if (flyingBee[i].column == 0) {
                                if ((alive[1] & (1 << (19 - flyingBee[i].row))) >> (19 - flyingBee[i].row) == 1) {
                                    chosenRow[chosenNum] = flyingBee[i].row;
                                    chosenCol[chosenNum] = 2;
                                    chosenNum++;
                                }
                                
                                if (flyingBee[i].row < 10) {
                                    
                                    if ((alive[1] & (1 << (19 - flyingBee[i].row + 2))) >> (19 - flyingBee[i].row + 2) == 1) {
                                        chosenRow[chosenNum] = flyingBee[i].row - 2;
                                        chosenCol[chosenNum] = 2;
                                        chosenNum++;
                                    }
                                    if (chosenNum == 2)
                                        continue;
                                    if ((alive[1] & (1 << (19 - flyingBee[i].row - 2))) >> (19 - flyingBee[i].row - 2) == 1) {
                                        chosenRow[chosenNum] = flyingBee[i].row + 2;
                                        chosenCol[chosenNum] = 2;
                                        chosenNum++;
                                    }
                                        
                                } else {
                                    
                                    if ((alive[1] & (1 << (19 - flyingBee[i].row - 2))) >> (19 - flyingBee[i].row - 2) == 1) {
                                        chosenRow[chosenNum] = flyingBee[i].row + 2;
                                        chosenCol[chosenNum] = 2;
                                        chosenNum++;
                                    }
                                    if (chosenNum == 2)
                                        continue;
                                    if ((alive[1] & (1 << (19 - flyingBee[i].row + 2))) >> (19 - flyingBee[i].row + 2) == 1) {
                                        chosenRow[chosenNum] = flyingBee[i].row - 2;
                                        chosenCol[chosenNum] = 2;
                                        chosenNum++;
                                    }
                                }  
                                
                            } else if (flyingBee[i].column == 2) {
                                
                                if (flyingBee[i].row < 10) {
                                    if ((alive[0] & (1 << (19 - 6))) >> (19 - 6) == 1) {
                                        chosenRow[chosenNum] = 6;
                                        chosenCol[chosenNum] = 0;
                                        chosenNum++;
                                    } else {
                                        break;
                                    }
                                    
                                    switch (flyingBee[i].row) {
                                        case 4:
                                            if ((alive[1] & (1 << (19 - 6))) >> (19 - 6) == 1) {
                                                chosenRow[chosenNum] = 6;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            if (chosenNum == 2)
                                                break;
                                            if ((alive[1] & (1 << (19 - 8))) >> (19 - 8) == 1) {
                                                chosenRow[chosenNum] = 8;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            break;
                                        case 8:
                                            if ((alive[1] & (1 << (19 - 6))) >> (19 - 6) == 1) {
                                                chosenRow[chosenNum] = 6;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            if (chosenNum == 2)
                                                break;
                                            if ((alive[1] & (1 << (19 - 4))) >> (19 - 4) == 1) {
                                                chosenRow[chosenNum] = 4;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            break;
                                        default:
                                            break;
                                    }
                                        
                                } else {
                                    if ((alive[0] & (1 << (19 - 12))) >> (19 - 12) == 1) {
                                        chosenRow[chosenNum] = 12;
                                        chosenCol[chosenNum] = 0;
                                        chosenNum++;
                                    } else {
                                        break;
                                    }
                                    
                                    switch (flyingBee[i].row) {
                                        case 14:
                                            if ((alive[1] & (1 << (19 - 12))) >> (19 - 12) == 1) {
                                                chosenRow[chosenNum] = 12;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            if (chosenNum == 2)
                                                break;
                                            if ((alive[1] & (1 << (19 - 10))) >> (19 - 10) == 1) {
                                                chosenRow[chosenNum] = 10;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            break;
                                        case 10:
                                            if ((alive[1] & (1 << (19 - 12))) >> (19 - 12) == 1) {
                                                chosenRow[chosenNum] = 12;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            if (chosenNum == 2)
                                                break;
                                            if ((alive[1] & (1 << (19 - 14))) >> (19 - 14) == 1) {
                                                chosenRow[chosenNum] = 14;
                                                chosenCol[chosenNum] = 2;
                                                chosenNum++;
                                            }
                                            break;
                                        default:
                                            break;
                                    }
                                }
                            }
                        }
                        
                        if (chosenNum == 0)
                            break;
                    }
                }
            }
        }
        
        if (flyingBeeNum > 0) {
            for (i = 0; i < maxFlyingBeeNum; i++) {
                if (flyingBee[i].flying == 1) {
                    if (flyingBee[i].angleCount < 132) {
                        if (flyingBee[i].circleCount == flyingBee[i].flyCountToBe) {
                            
                            flyingBee[i].circleCount = 0;
                            flyingBee[i].flyingH += flyingBee[i].flySide * circleChangeH[flyingBee[i].angleCount];
                            flyingBee[i].flyingV += circleChangeV[flyingBee[i].angleCount];
                            flyingBee[i].angle = convertAngle(flyingBee[i].angleCount, flyingBee[i].flySide);
                            flyingBee[i].angleCount++;
                            
                            if (flyingBee[i].angleCount == 106 &&
                                ((flyingBee[i].flySide > 0 && flyingBee[i].flyingH > planeH) ||
                                 (flyingBee[i].flySide < 0 && flyingBee[i].flyingH < planeH)))
                                flyingBee[i].angleCount = 132;
                            
                            if (flyingBee[i].angleCount == 132) {
                                flyingBee[i].k = flyingBee[i].flySide;
                                flyingBee[i].track = flyingBee[i].flyingV;
                            }
                            showFlyingBee(flyingBee[i], i);
                            
                        } else
                            flyingBee[i].circleCount++;
                            
                    } else {
                        
                        if (flyingBee[i].flyCount == flyingBee[i].flyCountToBe) {
                            flyingBee[i].flyCount = 0;
                            
                            switch (flyingBee[i].done) {
                                case 1:
                                flyingBee[i].flyingH = beeMaxH + 16*flyingBee[i].row;
                                if (beeMaxV + 16*flyingBee[i].column - flyingBee[i].flyingV > 0 &&
                                    beeMaxV + 16*flyingBee[i].column - flyingBee[i].flyingV < 33 &&
                                    (beeMaxV + 16*flyingBee[i].column - flyingBee[i].flyingV)%4 == 0) {
                                
                                    flyingBee[i].angle = backAngle[((beeMaxV + 16*flyingBee[i].column - flyingBee[i].flyingV) >> 1) - flyingBee[i].row/10 - 1];
                        
                                } else if (flyingBee[i].flyingV == beeMaxV + 16*flyingBee[i].column) {
                            
                                    flyingBeeNum--;
                                    alive[flyingBee[i].column>>1] ^= 1 << (19 -flyingBee[i].row);
                                    resetFlyingBee(&flyingBee[i]);
                                }
                                break;
                                
                                case 0:
                                if (rebornCount == 0)
                                    facePlane(&flyingBee[i], planeH, planeV);
                                
                                if (flyingBee[i].flyingV == flyingBee[i].track) {
                                    if ((flyingBee[i].flyingH+8) - (planeH+10) < 0) {
                                        if (flyingBee[i].k != 1) {
                                            flyingBee[i].k = 1;
                                            flyingBee[i].turn = 1;
                                        }
                                    } else {
                                        if (flyingBee[i].k != -1) {
                                            flyingBee[i].k = -1;
                                            flyingBee[i].turn = -1;
                                        }
                                    }
                                    
                                    if (flyingBee[i].flyingH >= 20 && flyingBee[i].flyingH <= 510) {
                                        addBullet(planeH+10, planeV+10, flyingBee[i].flyingH+8, flyingBee[i].flyingV+8, bulletNum++, &head);
                                        flyingBee[i].bulletLeft--;
                                    }
                                }
                                
                                // smoothly turn
                                if (flyingBee[i].turn != 0) {
                                    if (flyingBee[i].smoothCount < 20) {
                                        flyingBee[i].flyingH -= flyingBee[i].turn*turnChangeH[flyingBee[i].smoothCount++];
                                    } else if (flyingBee[i].smoothCount == 20) {
                                        flyingBee[i].smoothCount = 0;
                                        flyingBee[i].turn = 0;
                                        flyingBee[i].flyingH += flyingBee[i].k;
                                    }
                                } else {
                                    flyingBee[i].flyingH += flyingBee[i].k;
                                
                                    // change direction before flying out of the screen
                                    if (flyingBee[i].flyingV < 420) {
                                        if (flyingBee[i].flyingH > 500 && flyingBee[i].k == 1) {
                                            flyingBee[i].k = -1;
                                            flyingBee[i].turn = -1;
                                        } else if (flyingBee[i].flyingH < 20 && flyingBee[i].k == -1) {
                                            flyingBee[i].k = 1;
                                            flyingBee[i].turn = 1;
                                        }
                                    }
                                    
                                    if (flyingBee[i].flyingV == beeMaxV + 16*flyingBee[i].column + 150) {
                                        if (rebornCount == 0) {
                                        
                                            if ((flyingBee[i].flyingH+8) - (planeH+10) < 0) {
                                                if (flyingBee[i].k != 1) {
                                                    flyingBee[i].k = 1;
                                                    flyingBee[i].turn = 1;
                                                }
                                            } else {
                                                if (flyingBee[i].k != -1) {
                                                    flyingBee[i].k = -1;
                                                    flyingBee[i].turn = -1;
                                                }
                                            }
                                            if (flyingBee[i].type == 1)
                                                addBullet(planeH+10, planeV+10, flyingBee[i].flyingH+8, flyingBee[i].flyingV+8, bulletNum++, &head);
                                        }
                                    } 
                                }
                                
                                break;
                                
                                default:
                                break;
                            }
                            flyingBee[i].flyingV++;                            
                            showFlyingBee(flyingBee[i], i); 
                            
                            // fly out the screen
                            if (flyingBee[i].flyingV == 470) {
                                flyingBee[i].flyingV = 0;
                                if (beeLife > level) {
                                    flyingBee[i].angle = 2;
                                    flyingBee[i].done = 1;
                                } else {
                                    flyingBee[i].bulletLeft = beeBullet[level];
                                }
                            }
                            
                            if (bulletNum >= 30)
                                    bulletNum = 0;
                            
                            // shoot bullet to plane
                            if (flyingBee[i].bulletLeft > 0 && flyingBee[i].bulletLeft < beeBullet[level]) {
                                if (flyingBee[i].bulletLeftCount == 30) {
                                    flyingBee[i].bulletLeftCount = 0;
                                    addBullet(planeH+10, planeV+10, flyingBee[i].flyingH+8, flyingBee[i].flyingV+8, bulletNum++, &head);
                                    flyingBee[i].bulletLeft--;
                                } else
                                    flyingBee[i].bulletLeftCount++;
                            }
                                    
                            
                            // flying bee hits the plane
                            if (flyingBee[i].flyingV >= 388 && flyingBee[i].flyingV <= 416 &&
                                fabs(flyingBee[i].flyingH - planeH -2) <= 16 && 
                                rebornCount ==0 && planeLife > 0) {
                                showPlaneExplosion(planeH, planeV, 1);
                                planeExplodeCount = 1;
                                score += scoreArray[flyingBee[i].column>>1]>>1;
                                showScore(&hiScore, score);
                                resetFlyingBee(&flyingBee[i]);
                                showFlyingBee(flyingBee[i], i);
                                showPlane(600, 400);
                                showBullet(600, 400);
                                flyingBeeNum--;
                                beeLife--;
                                planeLife--;
                                rebornCount = 2000;
                                // clear plane moving direction
                                leftMove = 0;
                                rightMove = 0;
                                while(IORD_8DIRECT(PS2_BASE, 0) == 1) {
                                    code = IORD_8DIRECT(PS2_BASE, 4);
                                }
                            }
                            
                        }
                        flyingBee[i].flyCount++;
                    }
                    
                    // bullet hits flying bee
                    if (bulletV <= flyingBee[i].flyingV+16 && bulletV >= flyingBee[i].flyingV &&
                    bulletH <= flyingBee[i].flyingH+14 && bulletH >= flyingBee[i].flyingH+2 &&
                        fire == 1) {
                        outExpH = flyingBee[i].flyingH;
                        outExpV = flyingBee[i].flyingV;
                        IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000062);
                        IOWR_32DIRECT(AUDIO_BASE, 0, 0x00000008);
                        showExplosion(outExpH, outExpV, 1);
                        outExplodeCount = 1;
                        score += scoreArray[flyingBee[i].column>>1]<<1;
                        showScore(&hiScore, score);
                        fire = 0;
                        bulletV = 400;
                        showBullet(600, 400);
                        resetFlyingBee(&flyingBee[i]);
                        showFlyingBee(flyingBee[i], i);
                        flyingBeeNum--;
                        beeLife--;
                    }
                }
            }
        }
        
        /*-----bee bullet coordinate-----*/
        if (beeBulletCount == 3) {
            beeBulletCount = 0;
            bullet* curr;
            curr = head;
            while (curr != NULL) {
                bullet* next;
                next = curr->nextBullet;
                
                // bee bullet flying out of screen
                if (curr->v >= 477 || curr->h >= 500 || curr->h <= 0) {
                    if (head == curr)
                        head = next;
                    
                    delBullet(curr);
                    curr = next;
                    continue;
                }
                
                // bee bullet hits the plane
                if (curr->v >= 400 && curr->v <= 420 &&
                    curr->h - planeH <= 20 && curr->h >= planeH &&
                    rebornCount == 0 && planeLife > 0) {
                    showPlaneExplosion(planeH, planeV, 1);
                    planeExplodeCount = 1;
                    showPlane(600, 400);
                    leftMove = 0;
                    rightMove = 0;
                    showBullet(600, 400);
                    planeLife--;
                    rebornCount = 2000;
                    if (head == curr)
                        head = next;
                    
                    delBullet(curr);
                    curr = next;
                    continue;
                }
                
                if (curr->beeBulletMoveDown == 1) {
                    curr->h += curr->k;
                    curr->beeBulletMoveDown = 0;
                } else {
                    curr->beeBulletMoveDown = 1;
                }
                curr->v++;
                showBeeBullet(curr);
                curr = next;
            }
        } else
            beeBulletCount++;
        
        while (IORD_32DIRECT(VGA_BASE, 0) != 0x0F);
        
    }
    
    return 0;
}                                                    
