library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity lab3 is
  
  port (
    signal CLOCK_50 : in std_logic;                -- 50 MHz clock
    signal LEDR : out std_logic_vector(17 downto 0); -- Red LEDs

	VGA_CLK,                                            -- Clock
	VGA_HS,                                             -- H_SYNC
	VGA_VS,                                             -- V_SYNC
	VGA_BLANK,                                          -- BLANK
	VGA_SYNC : out std_logic;                           -- SYNC
	VGA_R,                                              -- Red[9:0]
	VGA_G,                                              -- Green[9:0]
	VGA_B : out STD_LOGIC_VECTOR (9 downto 0);          -- Blue[9:0]

	PS2_CLK,
    PS2_DAT          : in std_logic;

	AUD_ADCLRCK : inout std_logic;                      -- ADC LR Clock
    AUD_ADCDAT : in std_logic;                          -- ADC Data
    AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
    AUD_DACDAT : out std_logic;                         -- DAC Data
    AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
	AUD_XCK : out std_logic;                            -- Chip Clock
	I2C_SDAT : inout std_logic; 						-- I2C Data
    I2C_SCLK : out std_logic;   						-- I2C Clock

    SRAM_DQ : inout std_logic_vector(15 downto 0); -- Data bus 16 Bits
    SRAM_ADDR : out std_logic_vector(17 downto 0); -- Address bus 18 Bits
    SRAM_UB_N,                                     -- High-byte Data Mask
    SRAM_LB_N,                                     -- Low-byte Data Mask
    SRAM_WE_N,                                     -- Write Enable
    SRAM_CE_N,                                     -- Chip Enable
    SRAM_OE_N : out std_logic                      -- Output Enable
    );
  
end lab3;

architecture rtl of lab3 is
  
  signal counter : unsigned(15 downto 0);
  signal reset_n : std_logic := '1';

  signal audio_request : std_logic;
  signal audio_clock_18 : std_logic;
  signal audio_counter : unsigned(31 downto 0);
  signal temp : std_logic_vector(31 downto 0);
-------------------------------------------------------


component audio_driver is 
port(
	clock_50 : in std_logic;
	clock_18 : in std_logic;
	cpu_cmd : in std_logic_vector(31 downto 0);

	-- Audio interface signals
	AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
	AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
	AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
	AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
	AUD_BCLK     : inout std_logic   --    Audio CODEC Bit-Stream Clock
);
end component;

component de2_i2c_av_config is
port (
	iCLK : in std_logic;
	iRST_N : in std_logic;
	I2C_SCLK : out std_logic;
	I2C_SDAT : inout std_logic
);
end component;

component audio_pll is
port (
	inclk0		: in std_logic  := '0';
	c0			: out std_logic 
);
end component;
  
begin

pll : audio_pll port map(
	inclk0 => CLOCK_50,
	c0 => audio_clock_18
);

AUD_XCK <= audio_clock_18;

i2c : de2_i2c_av_config port map (
	iCLK     => CLOCK_50,
	iRST_n   => '1',
	I2C_SCLK => I2C_SCLK,
	I2C_SDAT => I2C_SDAT
);


v1: audio_driver port map (
	clock_50 =>CLOCK_50,
	clock_18 => audio_clock_18,
	cpu_cmd => temp,

	--Audio interface signals
	AUD_ADCLRCK  => AUD_ADCLRCK,
	AUD_ADCDAT   => AUD_ADCDAT,
	AUD_DACLRCK  => AUD_DACLRCK,
	AUD_DACDAT   => AUD_DACDAT,
	AUD_BCLK     => AUD_BCLK
);

process (CLOCK_50)
 begin
	if rising_edge(CLOCK_50) then
		if counter = x"ffff" then
			reset_n <= '1';
		else
			reset_n <= '0';
			counter <= counter + 1;
		end if;
	end if;
 end process;

  nios : entity work.nios_system port map (
    clk                          => CLOCK_50,
    reset_n                      => reset_n,

    SRAM_ADDR_from_the_sram      => SRAM_ADDR,
    SRAM_CE_N_from_the_sram      => SRAM_CE_N,
    SRAM_DQ_to_and_from_the_sram => SRAM_DQ,
    SRAM_LB_N_from_the_sram      => SRAM_LB_N,
    SRAM_OE_N_from_the_sram      => SRAM_OE_N,
    SRAM_UB_N_from_the_sram      => SRAM_UB_N,
    SRAM_WE_N_from_the_sram      => SRAM_WE_N,

	VGA_BLANK_from_the_vga		 => VGA_BLANK,
	VGA_B_from_the_vga			 => VGA_B,
	VGA_CLK_from_the_vga		 => VGA_CLK,
    VGA_G_from_the_vga			 => VGA_G,
	VGA_HS_from_the_vga			 => VGA_HS,
	VGA_R_from_the_vga			 => VGA_R,
	VGA_SYNC_from_the_vga		 => VGA_SYNC,
	VGA_VS_from_the_vga			 => VGA_VS,
	
	PS2_Clk_to_the_ps2			 => PS2_CLK,
    PS2_Data_to_the_ps2			 => PS2_DAT,
	data_from_the_audio 		 => temp
);

end rtl;
