library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    clk_50 : in std_logic;
    disable : in std_logic; --when '1', no output from wm8731
    sound : in std_logic_vector(3 downto 0); -- select which sound will be played
    sound_finish1 : out std_logic;-- exp
    sound_finish2 : out std_logic;-- fire
    sound_finish3 : out std_logic;-- fall
    -- Audio interface signals

    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  de2_wm8731_audio;

architecture rtl of de2_wm8731_audio is     

    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck  : std_logic;   
    signal lrck_divider : unsigned(7 downto 0); 
    signal bclk_divider : unsigned(3 downto 0);    
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal clr_bclk : std_logic;
    signal lrck_lat : std_logic;   
    signal shift_out : unsigned(15 downto 0);

    signal rom_data_bullet : unsigned(15 downto 0);-- from "bullet" rom to mux
    signal rom_data_explo : unsigned(15 downto 0); -- from "exploration" rom to mux
    signal rom_data_fall : unsigned(15 downto 0);-- from "fall" rom to mux
--signal rom_data_begin : unsigned(15 downto 0);
    signal mem_addr_bullet : unsigned(12 downto 0);
    signal mem_addr_explo : unsigned(12 downto 0);
signal mem_addr_fall : unsigned(13 downto 0);
--signal mem_addr_begin : unsigned(13 downto 0);
    signal counter1 : unsigned(2 downto 0);
    signal counter2 : unsigned(2 downto 0);
    signal counter3 : unsigned(3 downto 0);
--signal counter4 : unsigned(3 downto 0);
    signal data_from_mux : unsigned(15 downto 0);
    
    
    signal temp : std_logic; -- control the output from wm8731
    
    


component beebullet is
port
(
address		: IN STD_LOGIC_VECTOR (12 DOWNTO 0);
clock		: IN STD_LOGIC ;
q		: OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
);
end component;

component beeexplo is
port
(
address		: IN STD_LOGIC_VECTOR (12 DOWNTO 0);
clock		: IN STD_LOGIC ;
q		: OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
);
end component;

component beefall is
port
(
address		: IN STD_LOGIC_VECTOR (13 DOWNTO 0);
clock		: IN STD_LOGIC ;
q		: OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
);
end component;  

begin
  
    -- LRCK divider 
    -- Audio chip main clock is 18.432MHz / Sample rate 48KHz
    -- Divider is 18.432 MHz / 48KHz = 192 (X"C0")
    -- Left justify mode set by I2C controller
    
 audio_bullet : beebullet port map(
	address => std_logic_vector(mem_addr_bullet),
	clock => clk_50,
	unsigned(q) => rom_data_bullet
 );
 
audio_explo : beeexplo port map (	
	address	=> std_logic_vector(mem_addr_explo),
	clock => clk_50,
	unsigned(q) => rom_data_explo
);


audio_fall : beefall port map(
	address	=> std_logic_vector(mem_addr_fall),
	clock => clk_50,
	unsigned(q) => rom_data_fall
);
  
process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then 
			lrck_divider <= (others => '0');
		elsif lrck_divider = X"BF"  then        -- "C0" minus 1
			lrck_divider <= X"00";
		else 
			lrck_divider <= lrck_divider + 1;
		end if;
	end if;   
end process;

process (clk)
begin
	if rising_edge(clk) then      
		if reset_n = '0' then 
			bclk_divider <= (others => '0');
		elsif bclk_divider = X"B" or set_lrck = '1'  then  
			bclk_divider <= X"0";
		else 
			bclk_divider <= bclk_divider + 1;
		end if;
	end if;
end process;

  set_lrck <= '1' when lrck_divider = X"BF" else '0';
    
process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			lrck <= '0';
		elsif set_lrck = '1' then 
			lrck <= not lrck;
		end if;
	end if;
end process;
    
  -- BCLK divider
  set_bclk <= '1' when bclk_divider(3 downto 0) = "0101" else '0';
  clr_bclk <= '1' when bclk_divider(3 downto 0) = "1011" else '0';
  
process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			bclk <= '0';
		elsif set_lrck = '1' or clr_bclk = '1' then
			bclk <= '0';
		elsif set_bclk = '1' then 
			bclk <= '1';
		end if;
	end if;
end process;

  -- Audio data shift output
process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			shift_out <= (others => '0');
		elsif set_lrck = '1' then
			shift_out <= data_from_mux;
		elsif clr_bclk = '1' then 
			shift_out <= shift_out (14 downto 0) & '0';
		end if;
		-- when disable = 1, no audio data output, which means mute.      
		if disable = '1' then
			temp <= '0';
		else
			temp <= shift_out(15);
		end if; 
	end if;   
end process;

    -- Audio outputs
    
    AUD_ADCLRCK  <= lrck;          
    AUD_DACLRCK  <= lrck;          
    AUD_DACDAT   <= temp; 
    AUD_BCLK     <= bclk;          

    -- read data from ROM
    
    -- mux to select which sound to be played
    
data_from_mux <= rom_data_bullet  when sound = "0001" else
				 rom_data_explo   when sound = "0010" else
				 rom_data_fall    when sound = "0100" else
				 x"0000";
    
    
    -- counter 1 for bullet
process(clk)      
begin
	if rising_edge(clk) then
		if reset_n = '0' then 
			mem_addr_bullet <= (others => '0');
			sound_finish1 <= '0';
			counter1<="000";
		elsif lrck_lat = '1' and lrck = '0' then
			if counter1 = "101" then
				counter1 <= "000";
				if mem_addr_bullet = x"0dff" then 
					mem_addr_bullet <= (others => '0');
					sound_finish1 <='1';
				else  
					mem_addr_bullet <= mem_addr_bullet + 1;
				end if;
			else
				counter1 <= counter1 + 1;
			end if;
		end if;
	end if;
end process;
    
    -- counter 2 for explo
process(clk)      
begin
	if rising_edge(clk) then
		if reset_n = '0' then 
			mem_addr_explo <= "0000000000000";
			sound_finish2 <= '0';
			counter2<="000";
		elsif lrck_lat = '1' and lrck = '0' then
			if counter2 = "101" then
				counter2 <= "000";
				if mem_addr_explo = x"1049" then 
					mem_addr_explo <= "0000000000000";
					sound_finish2 <='1';
				else  
					mem_addr_explo <= mem_addr_explo + 1;
				end if;
			else
				counter2 <= counter2 + 1;
			end if;
		end if;
	end if;
end process;
    
    -- counter 3 for fall
process(clk)      
begin
	if rising_edge(clk) then
		if reset_n = '0' then 
			mem_addr_fall <= "00000000000000";
			sound_finish3 <= '0';
			counter3<="0000";
		elsif lrck_lat = '1' and lrck = '0' then
			if counter3 = "1010" then
				counter3 <= "0000";
				if mem_addr_fall = x"2845" then 
					mem_addr_fall <= "00000000000000";
					sound_finish3 <='1';
				else  
					mem_addr_fall <= mem_addr_fall + 1;
				end if;
			else
				counter3 <= counter3 + 1;
			end if;
		end if;
	end if;
end process;

----------------------------------    
    
process(clk)
begin
	if rising_edge(clk) then
		lrck_lat <= lrck;
	end if;
end process;
    
end architecture;


