-------------------------------------------------------------------------------
-- sync from the hardware to software
-- commit all the extra places


-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity de2_vga_raster is
  
	port (
		clk        : in  std_logic;
		reset_n    : in  std_logic;
		read       : in  std_logic;
		write      : in  std_logic;
		chipselect : in  std_logic;
		address    : in  unsigned(4 downto 0);
		readdata   : out unsigned(31 downto 0);
		writedata  : in  unsigned(31 downto 0);

		VGA_CLK,                         -- Clock
		VGA_HS,                          -- H_SYNC
		VGA_VS,                          -- V_SYNC
		VGA_BLANK,                       -- BLANK
		VGA_SYNC : out std_logic;        -- SYNC
		VGA_R,                           -- Red[9:0]
		VGA_G,                           -- Green[9:0]
		VGA_B : out std_logic_vector(9 downto 0) -- Blue[9:0]
	);

end de2_vga_raster;

architecture rtl of de2_vga_raster is
	constant CoorGlaH : integer := 145;
	constant CoorGlaV : integer := 100;
	constant GLA_LONG: integer := 250;
	constant GLA_HEIGHT: integer := 300;
	signal glaH, glaV, glaG, glaColorG : std_logic;
	signal galaxianColor : unsigned (2 downto 0);
	
	-- Video parameters
	constant HTOTAL       : integer := 800;
	constant HSYNC        : integer := 96;
	constant HBACK_PORCH  : integer := 48;
	constant HACTIVE      : integer := 640;
	constant HFRONT_PORCH : integer := 16;

	constant VTOTAL       : integer := 525;
	constant VSYNC        : integer := 2;
	constant VBACK_PORCH  : integer := 33;
	constant VACTIVE      : integer := 480;
	constant VFRONT_PORCH : integer := 10;

	-- Signals for the video controller
	signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
	signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
	signal EndOfLine, EndOfField : std_logic;

	signal vga_hblank, vga_hsync,
	vga_vblank, vga_vsync : std_logic;  -- Sync. signals

	
	signal b1V, b1H, b2V, b2H, b3V, b3H :unsigned (9 downto 0);
	signal Rb1V, Rb1H, Rb2V, Rb2H, Rb3V, Rb3H :unsigned (9 downto 0);
	signal b1Hshow, b1Vshow, b2Hshow, b2Vshow, b3Hshow, b3Vshow : std_logic;
	signal b1, b2, b3 :std_logic;
	
	constant BULLET_LONG : integer := 1;
	constant BULLET_HEIGHT   : integer := 3;

	signal clk25 : std_logic := '0';
	
	signal TransColorSignal : unsigned (2 downto 0);
	
	--------------signal for the plane-------------------
	signal planeH, planeV, planeG :std_logic;
	signal CoorPlaneH, TCoorPlaneH : unsigned (9 downto 0) 		:= "0000011001";
	signal CoorPlaneV, TCoorPlaneV : unsigned (9 downto 0) 		:= "0110010000";
	constant PLANE_SIZE : integer := 20;
	
	----------------signal for the bee-------------------
	signal bee_GreenG, bee_PurpleG, bee_RedG, big_beeG :std_logic;
	signal CoorBeeH : unsigned (9 downto 0) 		:= "0000011001";
	signal CoorBeeV : unsigned (9 downto 0) 		:= "0001100100";
	constant BEE_SIZE : integer := 16;
	
	----------------signal for the flying bee-------------------
	type CoorBeeSet 	is array (0 to 7) of unsigned (9 downto 0);
	type BeeAngleSet 	is array (0 to 7) of unsigned (3 downto 0);
	type BeeTypeSet 	is array (0 to 7) of unsigned (1 downto 0);
	signal FlybeeH, FlybeeV, FlybeeGback, FlybeeG : unsigned (0 to 7);
	signal FlyBeeType: BeeTypeSet:= (
	("00"),("00"),("00"),("00"),("00"),("00"),("00"),("00"));
	signal TCoorFlyBeeH, CoorFlyBeeH : CoorBeeSet:= (
	("0000011001"),("0000011001"),("0000011001"),("0000011001"),
	("0000011001"),("0000011001"),("0000011001"),("0000011001"));
	signal TCoorFlyBeeV, CoorFlyBeeV : CoorBeeSet:= (
	("0001100100"),("0001100100"),("0001100100"),("0001100100"),
	("0001100100"),("0001100100"),("0001100100"),("0001100100"));
	signal FlyBeeAngle : BeeAngleSet:= (
	("0000"),("0000"),("0000"),("0000"),("0000"),("0000"),("0000"),("0000"));
	
	----------------signal for the Explode-------------------
	signal ExplodeH, ExplodeV, ExplodeG :std_logic;
	signal BigExplodeH, BigExplodeV, BigExplodeG :std_logic;
	signal CoorExplodeH, planeExplodeH : unsigned (9 downto 0) 	:= "0000000000";
	signal CoorExplodeV, planeExplodeV : unsigned (9 downto 0) 	:= "0000000000";
	signal TCoorExplodeH, TplaneExplodeH: unsigned (9 downto 0) := "1001011000";
	signal TCoorExplodeV, TplaneExplodeV: unsigned (9 downto 0) := "0000000000";
	signal Small: std_logic := '0';
	signal planeSmall: std_logic:= '0';
	
	----------------signal for the bee matrix-------------------
	signal beeMaxH, beeMaxV, beeMaxG :std_logic;
	signal CoorBeeMaxH : unsigned (9 downto 0) 		:= "0000110010";
	signal CoorBeeMaxV : unsigned (9 downto 0) 		:= "0000110010";
	constant BEEMAX_LONG : integer := 304;
	constant BEEMAX_HEIGHT : integer := 144;
	
	----------------signal for the box-------------------
	constant BOX_LONG : integer := 100;
	constant BOX_HEIGHT: integer := 480;
	signal boxG : std_logic;
	
	----------------------signal for the data send back-------------------
	signal dataSendBack: unsigned (31 downto 0);
	
	---------------------signal for time delay count-------------------
	signal timeDelayCount: integer := 0;
	signal windFlipCount: integer := 0;
	signal startCount: std_logic := '0';
	constant synctime: integer := 60000;
	signal windFlip: std_logic := '0';
	
	---------------------alive matrix--------------------
	type alive_max_type is array (0 to 8) of unsigned (0 to 19);
	signal AliveMax: alive_max_type := (
	("10101010101010101000"),("00000000000000000000"),
	("10101010101010100010"),("00000000000000000000"),
	("10101010101010001010"),("00000000000000000000"),
	("10101010101010001010"),("00000000000000000000"),
	("10101010101000101010"));
	
	signal tmpM1, tmpM2, tmpM3, tmpM4, tmpM5 : unsigned (19 downto 0) := "10101010101010101010";
	
	---------------------bee type matrix-------------------
	type bee_type_max is array (0 to 8) of unsigned (0 to 1);
	constant BeeTypeMax : bee_type_max := (
	("11"),("00"),("10"),("00"),("01"),("00"),("00"),("00"),("00"));
	
	---------------------score data-----------------------
	type score_type is array (0 to 4) of unsigned (3 downto 0);
	signal hiScoreData, scoreData : score_type := (
	("0000"),("0101"),("0000"),("0000"),("0000"));
	
	--------------------bee bullet-----------------------
	type bee_bullet_type is array (0 to 29) of unsigned (9 downto 0);
	signal CoorBeeBulletH, CoorBeeBulletV :bee_bullet_type;
	signal TCoorBeeBulletH, TCoorBeeBulletV :bee_bullet_type;
	signal beeBulletH, beeBulletV, beeBulletG: unsigned (0 to 29);
	signal getBullet: std_logic;
	
	----------------signal for the star-------------------
	signal flipstate : std_logic :='0';
	signal flipcount : integer := 0;
	signal flipstate1 : std_logic := '0';
	signal flipstate2 : std_logic := '1';
	signal flipstate3 : std_logic := '1';

	type starposition is array(integer range 0 to 27) of integer;
	signal stararrayV :starposition:= (189,393,53,461,257,121,325,423,
	83,491,287,151,355,219,38,446,242,106,310,174,378,295,159,363,23,431,227,91);
	signal roll :starposition:= (189,393,53,461,257,121,325,423,
	83,491,287,151,355,219,38,446,242,106,310,174,378,295,159,363,23,431,227,91);
	signal coorstarH : unsigned (9 downto 0) := "1001101010";
	signal coorstarV : unsigned (9 downto 0) := "0000011000";
	signal starH, starV, starG :std_logic;
	signal shinecount : integer :=1;
	signal shine : unsigned (2 downto 0):= "001";
	----------------signal for the star1-------------------
	signal starH1, starV1, starG1 :std_logic;
	signal shinecount1 : integer :=1;
	signal shine1 : unsigned (2 downto 0):= "011";
	----------------signal for the star2-------------------
	signal starH2, starV2, starG2 :std_logic;
	signal shinecount2 : integer :=1;
	signal shine2 : unsigned (2 downto 0):= "101";
	----------------signal for the star3-------------------
	signal starH3, starV3, starG3 :std_logic;
	signal shinecount3 : integer :=1;
	signal shine3 : unsigned (2 downto 0):= "111";
	
	----------------------color signal-------------------
	type textMatrix1 is array(0 to 9) of unsigned (0 to 54);
	type textMatrix2 is array(0 to 9) of unsigned (0 to 21);
	type normalMatrix is array(integer range 0 to 15, integer range 0 to 15) of unsigned(1 downto 0);
	type matrix is array(integer range 0 to 15, integer range 0 to 15) of unsigned(2 downto 0);
	type matrix24 is array(integer range 0 to 19, integer range 0 to 19) of unsigned(2 downto 0);
	
	------------------------information--------------------
	signal mainPic: std_logic := '1';
	signal planeLife : unsigned (2 downto 0);
	signal level : unsigned (2 downto 0);
	signal mainPicV: unsigned (9 downto 0) := "0001100100";
	signal TmpClearScr, clearScr : std_logic := '0';
	signal readySignal, pauseSignal : std_logic := '0';
	signal readyH, readyV, readyG : std_logic;
	signal pauseH, pauseV, pauseG : std_logic;
	signal readyColor, pauseColor: unsigned (2 downto 0);
	constant CoorReadyH: integer:= 250;
	constant CoorReadyV: integer:= 350;
	constant READY_LONG: integer:= 50;
	constant READY_HEIGHT: integer:= 14;
	
	--------------------------the matrix for text-------------------------------------
	signal hiScore: textMatrix1 := (
	("0000000000000000000000000000000000000000000000000000000"),
	("0110011011111100000001111000111100011110011111001111110"),
	("0110011011111100000011111101111110111111011111101111110"),
	("0110011000110000000011000001100110110011011001101100000"),
	("0111111000110001111011111001100000110011011001101111110"),
	("0111111000110001111001111101100000110011011111001111110"),
	("0110011000110000000000001101100110110011011111001100000"),
	("0110011011111100000011111101111110111111011011101111110"),
	("0110011011111100000001111000111100011110011001101111110"),
	("0000000000000000000000000000000000000000000000000000000"));
	signal oneUP: textMatrix2 := (
	("0000000000000000000000"),("0001100011001101111100"),
	("0011100011001101111110"),("0111100011001101100110"),
	("0001100011001101100110"),("0001100011001101111110"),
	("0001100011001101111100"),("0111111011111101100000"),
	("0111111001111001100000"),("0000000000000000000000"));
	
	constant CoorTextH : integer := 550;
	constant CoorTextV : integer := 50;
	constant textMatrixLong : integer := 55;
	constant textMatrixHeight : integer := 55;
	signal TextG, TextH, TextV :std_logic;
	
	---------------------------number---------------------------
	signal hiScoreColorSignal, scoreColorSignal : unsigned (2 downto 0);
	type numberMatrix is array(0 to 9) of unsigned (0 to 5);
	signal one: numberMatrix := (
	("000000"),("001100"),("011100"),("111100"),("001100"),
	("001100"),("001100"),("111111"),("111111"),("000000"));
	signal two: numberMatrix := (
	("000000"),("011110"),("111111"),("110011"),("000011"),
	("001110"),("011100"),("111111"),("111111"),("000000"));
	signal three: numberMatrix := (
	("000000"),("011110"),("111111"),("110011"),("000110"),
	("000110"),("110011"),("111111"),("011110"),("000000"));
	signal four: numberMatrix := (
	("000000"),("000110"),("001110"),("011110"),("110110"),
	("111111"),("111111"),("000110"),("000110"),("000000"));
	signal five: numberMatrix := (
	("000000"),("011111"),("111111"),("110000"),("111110"),
	("111111"),("000011"),("111111"),("111110"),("000000"));
	signal six: numberMatrix := (
	("000000"),("011111"),("111111"),("110000"),("111110"),
	("111111"),("110011"),("111111"),("011110"),("000000"));
	signal seven: numberMatrix := (
	("000000"),("111111"),("111111"),("110011"),("000110"),
	("000110"),("001100"),("001100"),("001100"),("000000"));
	signal eight: numberMatrix := (
	("000000"),("011110"),("111111"),("110011"),("011110"),
	("011110"),("110011"),("111111"),("011110"),("000000"));
	signal nine: numberMatrix := (
	("000000"),("011110"),("111111"),("110011"),("111111"),
	("011110"),("000110"),("001100"),("001100"),("000000"));
	signal zero: numberMatrix := (
	("000000"),("011110"),("111111"),("110011"),("110011"),
	("110011"),("110011"),("111111"),("011110"),("000000"));
	
	--------------------------start-----------------------------------
	type startType is array(0 to 13) of unsigned (0 to 49);
	signal start:startType := (
	("00000000000000000000000000000000000000000000000000"),
	("00011111000111111110000111100001111111000111111110"),
	("00111111100111111110001111110001111111100111111110"),
	("01110001100100110010001100110001100001100100110010"),
	("01100000000000110000001100110001100001100000110000"),
	("01100000000000110000001100110001100011100000110000"),
	("01111111000000110000001111110001111111000000110000"),
	("00111111100000110000011111111001111110000000110000"),
	("00000001100000110000011000011001111100000000110000"),
	("00000001100000110000011000011001101110000000110000"),
	("01100011100000110000011000011001100111000000110000"),
	("01111111000000110000011000011001100011100000110000"),
	("00111110000000110000011000011001100001100000110000"),
	("00000000000000000000000000000000000000000000000000"));
	
	signal ready:startType := (
	("00000000000000000000000000000000000000000000000000"),
	("01111111000111111110000111100001111110000110000110"),
	("01111111100111111110001111110001111111000110000110"),
	("01100001100110000000001100110001100011100110000110"),
	("01100001100110000000001100110001100001100110000110"),
	("01100011100110000000001100110001100001100011001100"),
	("01111111000111111110001111110001100001100011111100"),
	("01111110000111111110011111111001100001100001111000"),
	("01111100000110000000011100111001100001100000110000"),
	("01101110000110000000011000011001100001100000110000"),
	("01100111000110000000011000011001100011100000110000"),
	("01100011100111111110011000011001111111000000110000"),
	("01100001100111111110011000011001111110000000110000"),
	("00000000000000000000000000000000000000000000000000"));
	
	signal pause:startType := (
	("00000000000000000000000000000000000000000000000000"),
	("01111111000001111000011000011000011111000111111110"),
	("01111111100011111100011000011000111111100111111110"),
	("01100001100011001100011000011001110001100110000000"),
	("01100001100011001100011000011001100000000110000000"),
	("01100001100011001100011000011001100000000110000000"),
	("01111111100011111100011000011001111111000111111110"),
	("01111111000111111110011000011000111111100111111110"),
	("01100000000110000110011000011000000001100110000000"),
	("01100000000110000110011000011000000001100110000000"),
	("01100000000110000110011000011001100011100110000000"),
	("01100000000110000110011111111001111111000111111110"),
	("01100000000110000110001111110000111110000111111110"),
	("00000000000000000000000000000000000000000000000000"));
	
	------------------------gameover------------------------------
	type alphaMatrix is array(0 to 13) of unsigned (0 to 9);
	signal g: alphaMatrix := (
	("0000000000"),
	("0001111000"),
	("0011111100"),
	("0110000110"),
	("0110000110"),
	("0110000000"),
	("0110000000"),
	("0110111100"),
	("0110111110"),
	("0110000110"),
	("0110000110"),
	("0011111110"),
	("0001111100"),
	("0000000000"));
	signal a: alphaMatrix := (
	("0000000000"),
	("0001111000"),
	("0011111100"),
	("0011001100"),
	("0011001100"),
	("0011001100"),
	("0011111100"),
	("0111111110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0000000000"));
	signal m: alphaMatrix := (
	("0000000000"),
	("0110000110"),
	("0110000110"),
	("0111001110"),
	("0111001110"),
	("0111111110"),
	("0110110110"),
	("0110110110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0000000000"));
	signal e: alphaMatrix := (
	("0000000000"),
	("0111111110"),
	("0111111110"),
	("0110000000"),
	("0110000000"),
	("0110000000"),
	("0111111110"),
	("0111111110"),
	("0110000000"),
	("0110000000"),
	("0110000000"),
	("0111111110"),
	("0111111110"),
	("0000000000"));
	signal o: alphaMatrix := (
	("0000000000"),
	("0001111000"),
	("0011111100"),
	("0011001100"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0011001100"),
	("0011111100"),
	("0001111000"),
	("0000000000"));
	signal v: alphaMatrix := (
	("0000000000"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0110000110"),
	("0011001100"),
	("0011001100"),
	("0011001100"),
	("0011001100"),
	("0000110000"),
	("0000110000"),
	("0000110000"),
	("0000000000"));
	signal r: alphaMatrix := (
	("0000000000"),
	("0111111100"),
	("0111111110"),
	("0110000110"),
	("0110000110"),
	("0110001110"),
	("0111111100"),
	("0111111000"),
	("0111110000"),
	("0110111000"),
	("0110011100"),
	("0110001110"),
	("0110000110"),
	("0000000000"));
	
	signal gH, tmpgH, aH, tmpaH, mH, tmpmH, e1H, tmpe1H,
		   oH, tmpoH, vH, tmpvH, e2H, tmpe2H, rH, tmprH: unsigned (9 downto 0);
	signal gV, tmpgV, aV, tmpaV, mV, tmpmV, e1V, tmpe1V,
		   oV, tmpoV, vV, tmpvV, e2V, tmpe2V, rV, tmprV: unsigned (9 downto 0);
	signal gHG, aHG, mHG, e1HG, oHG, vHG, e2HG, rHG: std_logic;
	signal gVG, aVG, mVG, e1VG, oVG, vVG, e2VG, rVG: std_logic;
	signal gG, aG, mG, e1G, oG, vG, e2G, rG: std_logic;
	constant ALPHALONG : integer := 10;
	constant ALPHAHEIGHT: integer := 14;
	signal gameoverSignal : std_logic;
	signal gameoverColorSignal : unsigned (2 downto 0);

	type xiaotianType is array(0 to 13) of unsigned (0 to 139);
	signal xiaotian: xiaotianType:= (
	("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"),
	("01100001100011111100000111100000011110000111111110001111110000011110000111000110000000000000000000000000000000000000000000011110000011111100"),
	("01100001100011111100001111110000111111000111111110001111110000111111000111000110000000000000000000000000000000000000000000111111000011111100"),
	("01100001100000110000001100110000110011000100110010000011000000110011000111100110000000000000000000000000000000000000000001100001100000110000"),
	("00110011000000110000001100110001100001100000110000000011000000110011000111100110000000000000000000000000000000000000000001100001100000110000"),
	("00111111000000110000001100110001100001100000110000000011000000110011000111110110000000000000000000000000000000000000000001100001100000110000"),
	("00001100000000110000001111110001100001100000110000000011000000111111000110110110000000000000000000000000000000000000000001100001100000110000"),
	("00001100000000110000011111111001100001100000110000000011000001111111100110110110000000000000000000000000000000000000000001101101100000110000"),
	("00111111000000110000011000011001100001100000110000000011000001100001100110011110000000000000000000000000000000000000000001101101100000110000"),
	("00110011000000110000011000011001100001100000110000000011000001100001100110011110000000000000000000000000000000000000000001100111000000110000"),
	("01100001100000110000011000011000110011000000110000000011000001100001100110011110000000000000000000000000000000000000000001110111000000110000"),
	("01100001100011111100011000011000111111000000110000001111110001100001100110001110000000000000000000000000000000000000000000111111100011111100"),
	("01100001100011111100011000011000011110000000110000001111110001100001100110001110000000000000000000000000000000000000000000011101100011111100"),
	("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"));
	
	type yaolongType is array(0 to 13) of unsigned (0 to 159);
	signal yaolong: yaolongType:= (
	("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"),
	("0110000110000111100000011110000110000000000111100001110001100001111000000000000000000000000000000000000000000000000000000111111110011111111001110001100001111000"),
	("0110000110001111110000111111000110000000001111110001110001100011111100000000000000000000000000000000000000000000000000000111111110011111111001110001100011111100"),
	("0110000110001100110000110011000110000000001100110001111001100110000110000000000000000000000000000000000000000000000000000110000000011000000001111001100110000110"),
	("0110000110001100110001100001100110000000011000011001111001100110000110000000000000000000000000000000000000000000000000000110000000011000000001111001100110000110"),
	("0011001100001100110001100001100110000000011000011001111101100110000000000000000000000000000000000000000000000000000000000110000000011000000001111101100110000000"),
	("0011111100001111110001100001100110000000011000011001101101100110000000000000000000000000000000000000000000000000000000000111111100011111111001101101100110000000"),
	("0001111000011111111001100001100110000000011000011001101101100110111100000000000000000000000000000000000000000000000000000111111100011111111001101101100110111100"),
	("0000110000011000011001100001100110000000011000011001100111100110111110000000000000000000000000000000000000000000000000000110000000011000000001100111100110111110"),
	("0000110000011000011001100001100110000000011000011001100111100110000110000000000000000000000000000000000000000000000000000110000000011000000001100111100110000110"),
	("0000110000011000011000110011000110000000001100110001100111100110000110000000000000000000000000000000000000000000000000000110000000011000000001100111100110000110"),
	("0000110000011000011000111111000111111110001111110001100011100011111110000000000000000000000000000000000000000000000000000110000000011111111001100011100011111110"),
	("0000110000011000011000011110000111111110000111100001100011100001111100000000000000000000000000000000000000000000000000000110000000011111111001100011100001111100"),
	("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"));
	
	---------------------------trademarkMatrix-----------------------------
	type trademarkMatrix is array(0 to 14) of unsigned (0 to 127);
	signal trademark: trademarkMatrix := (
	("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"),
	("00000000000000000000000000000000000000000000000000011111000001111100011111111001111111100000111100001111110000001111000011111100"),
	("00001111100000000000000000000000000000000000000000111111100011111110011111111001111111100000111100011111111000001111000111111110"),
	("00010000010000000000000000000000000000000000000001110001100111000110011000000001100000000001101100011000011000011011000110000110"),
	("00100111001000001111000111100001100000110000000001100000000110000000011000000001100000000001101100011000011000011011000110000110"),
	("01001000100100011111101111110011100001110000000001100000000110000000011000000001100000000011001100011000011000110011000110000110"),
	("01010000000100011001101100110111100011110000000001100000000111111100011111111001111111100011001100001111110000110011000110000110"),
	("01010000000100000001101100110001100000110000000001100000000011111110011111111001111111100110001100001111110001100011000110000110"),
	("01010000000100000111001100110001100000110000000001100000000000000110011000000001100000000111111110011000011001111111100110000110"),
	("01001000100100001110001100110001100000110000000001100000000000000110011000000001100000000111111110011000011001111111100110000110"),
	("00100111001000011111101111110111111011111100000001110001100110001110011000000001100000000000001100011000011000000011000110000110"),
	("00010000010000011111100111100111111011111100000000111111100111111100011111111001111111100000001100001111110000000011000111111110"),
	("00001111100000000000000000000000000000000000000000011111000011111000011111111001111111100000001100001111110000000011000011111100"),
	("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"),
	("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"));
	
	---------------------------the matrix for the plane and bees------------------------
	signal plane :matrix24:= (
	("000","000","000","000","000","000","000","000","000","011","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","011","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","011","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","011","011","011","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","011","011","011","011","011","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","011","011","011","011","011","011","011","000","000","000","000","000","000","000"),
	("000","000","000","000","000","011","011","011","011","011","011","011","011","011","000","000","000","000","000","000"),
	("000","000","000","000","000","011","011","011","011","011","011","011","011","011","000","000","000","000","000","000"),
	("000","000","010","000","000","011","000","000","001","011","001","000","000","011","000","000","010","000","000","000"),
	("000","010","010","010","000","000","000","001","001","011","001","001","000","000","000","010","010","010","000","000"),
	("000","010","001","010","000","000","000","001","001","011","001","001","000","000","000","010","001","010","000","000"),
	("000","010","001","010","000","000","001","001","001","011","001","001","001","000","000","010","001","010","000","000"),
	("000","010","001","001","001","001","001","001","001","011","001","001","001","001","001","001","001","010","000","000"),
	("010","010","001","001","001","001","001","001","001","011","001","001","001","001","001","001","001","010","010","000"),
	("010","010","001","001","001","001","000","001","001","011","001","001","000","001","001","001","001","010","010","000"),
	("010","010","001","001","010","000","000","001","001","000","001","001","000","000","010","001","001","010","010","000"),
	("000","010","001","010","010","000","000","001","000","000","000","001","000","000","010","010","001","010","000","000"),
	("000","010","001","010","000","000","000","000","000","000","000","000","000","000","000","010","001","010","000","000"),
	("000","010","010","010","000","000","000","000","000","000","000","000","000","000","000","010","010","010","000","000"),
	("000","000","010","000","000","000","000","000","000","000","000","000","000","000","000","000","010","000","000","000")
	);
	
	signal small_explode :matrix:= (
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","011","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","011","011","100","000","011","000","000","000","000","000"),
	("000","000","000","000","000","000","100","100","011","000","100","011","000","000","000","000"),
	("000","000","000","000","100","011","000","100","100","100","011","100","000","000","000","000"),
	("000","000","000","000","011","011","011","011","100","011","011","100","011","000","000","000"),
	("000","000","000","000","000","011","100","100","011","011","100","000","000","000","000","000"),
	("000","000","000","000","100","000","100","011","100","000","011","000","000","000","000","000"),
	("000","000","000","000","000","000","000","011","000","000","011","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000")
	);
	
	signal big_bee :matrix:= (
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","011","011","011","011","000","000","000","000","000","000"),
	("000","001","001","000","000","011","011","011","011","011","011","000","000","001","001","000"),
	("000","001","001","000","011","011","010","011","011","010","011","011","000","001","001","000"),
	("000","001","001","011","011","011","011","011","011","011","011","011","011","001","001","000"),
	("000","001","001","100","011","011","011","011","011","011","011","011","100","001","001","000"),
	("000","001","001","100","100","011","011","011","011","011","011","100","100","001","001","000"),
	("000","000","001","001","100","100","100","100","100","100","100","100","001","001","000","000"),
	("000","000","000","001","001","100","100","100","100","100","100","001","001","000","000","000"),
	("000","000","000","000","001","001","000","100","100","000","001","001","000","000","000","000"),
	("000","000","000","000","000","001","000","100","100","000","001","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"));

	signal explode :matrix:= (
	("000","000","000","000","000","000","000","000","000","101","000","000","000","000","000","000"),
	("000","000","000","000","000","101","100","100","100","101","101","101","101","000","000","000"),
	("100","101","000","000","000","101","101","101","101","100","101","101","101","000","000","000"),
	("100","100","100","100","101","101","101","100","101","100","101","100","101","101","101","000"),
	("101","100","101","100","101","101","100","100","100","101","101","100","100","100","101","000"),
	("000","101","101","100","101","101","100","100","100","101","100","100","100","101","101","000"),
	("000","000","000","100","100","101","101","101","101","100","100","101","100","101","101","000"),
	("000","000","000","000","100","100","101","101","101","101","100","100","101","101","101","000"),
	("000","000","101","101","100","101","101","100","101","100","100","101","101","000","000","000"),
	("000","000","101","101","101","101","101","100","101","100","100","101","101","000","000","000"),
	("101","101","101","100","100","100","100","101","101","101","100","100","101","000","000","000"),
	("101","101","100","100","100","101","100","100","101","100","100","100","100","101","101","000"),
	("101","100","101","101","101","101","101","101","000","101","101","101","100","100","101","000"),
	("101","100","101","101","000","000","100","101","000","000","000","101","101","100","100","000"),
	("101","101","000","000","000","000","100","100","000","000","000","101","101","101","101","000"),
	("000","000","000","000","000","000","101","101","000","000","000","000","000","000","000","000"));

	signal bee:normalMatrix:= (
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","01","00","00","01","00","00","00","00","00","00"),
	("00","01","00","00","00","00","01","01","01","01","00","00","00","00","01","00"),
	("00","01","00","00","00","01","11","01","01","11","01","00","00","00","01","00"),
	("00","01","01","01","01","01","01","01","01","01","01","01","01","01","01","00"),
	("00","01","01","01","01","01","01","01","01","01","01","01","01","01","01","00"),
	("00","00","00","00","01","01","01","01","01","01","01","01","00","00","00","00"),
	("00","00","00","00","01","01","01","01","01","01","01","01","00","00","00","00"),
	("00","00","00","00","00","01","01","01","01","01","01","00","00","00","00","00"),
	("00","10","10","00","00","01","01","01","01","01","01","00","00","10","10","00"),
	("00","10","10","10","10","10","01","01","01","01","10","10","10","10","10","00"),
	("00","10","10","10","00","00","00","01","01","00","00","00","10","10","10","00"),
	("00","10","10","00","00","00","00","01","01","00","00","00","00","10","10","00"),
	("00","10","00","00","00","00","00","01","01","00","00","00","00","00","10","00"),
	("00","00","00","00","00","00","00","01","01","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00")
	);

	signal beef:normalMatrix:= (
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","01","00","00","01","00","00","00","00","00","00"),
	("00","01","00","00","00","00","01","01","01","01","00","00","00","00","01","00"),
	("00","01","00","00","00","01","11","01","01","11","01","00","00","00","01","00"),
	("00","01","01","01","01","01","01","01","01","01","01","01","01","01","01","00"),
	("00","01","01","01","01","01","01","01","01","01","01","01","01","01","01","00"),
	("00","00","00","00","01","01","01","01","01","01","01","01","00","00","00","00"),
	("00","10","00","00","01","01","01","01","01","01","01","01","00","00","10","00"),
	("00","10","10","00","00","01","01","01","01","01","01","00","00","10","10","00"),
	("00","10","10","10","00","01","01","01","01","01","01","00","10","10","10","00"),
	("00","10","10","10","10","10","01","01","01","01","10","10","10","10","10","00"),
	("00","00","00","00","00","00","00","01","01","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","00","01","01","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","00","01","01","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","00","01","01","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00")
	);

	signal bee30:normalMatrix:= (
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"),
	("00","00","10","10","00","00","00","00","00","00","00","00","00","00","00","00"),
	("00","00","10","10","00","00","00","00","00","00","00","00","00","00","00","00"),
	("00","00","10","10","00","00","00","00","01","01","00","00","00","00","10","00"),
	("00","00","10","10","10","10","01","01","01","01","01","00","00","10","10","00"),
	("00","00","00","10","10","10","01","01","01","01","01","00","00","10","10","00"),
	("00","00","00","00","00","01","01","01","01","01","01","10","10","10","10","00"),
	("00","01","01","01","01","01","01","01","01","01","01","10","10","10","00","00"),
	("00","01","01","00","01","01","01","01","01","01","00","00","00","00","00","00"),
	("00","01","01","00","01","11","01","01","01","01","00","00","00","00","00","00"),
	("00","00","00","00","01","01","01","11","01","01","01","01","00","00","00","00"),
	("00","00","00","00","01","01","01","01","01","00","00","01","01","00","00","00"),
	("00","00","00","01","00","00","00","01","00","00","00","01","01","00","00","00"),
	("00","00","00","00","00","00","01","00","00","00","00","01","00","00","00","00"),
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00")
    );

	signal bee45:normalMatrix:= (
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"),
	("00","00","00","00","00","00","10","00","00","00","00","00","00","00","00","00"),
	("00","00","00","00","00","10","10","00","00","00","00","00","00","00","00","00"),
	("00","00","00","00","10","10","10","00","00","00","00","00","00","00","00","00"),
	("00","00","00","00","10","10","10","00","00","01","01","01","00","00","00","00"),
	("00","01","01","00","00","10","10","01","01","01","01","01","00","00","00","00"),
	("00","01","01","01","00","01","01","10","01","01","01","01","00","00","00","00"),
	("00","01","00","01","01","01","01","01","01","01","01","00","00","00","00","00"),
	("00","00","00","01","01","01","01","01","01","10","01","00","00","00","00","00"),
	("00","00","00","01","11","01","01","01","01","01","10","10","10","10","10","00"),
	("00","00","01","01","01","01","01","01","01","01","10","10","10","10","00","00"),
	("00","01","00","01","01","01","11","01","01","00","00","10","10","00","00","00"),
	("00","00","00","00","01","01","01","01","01","01","00","00","00","00","00","00"),
	("00","00","00","00","00","01","00","00","00","01","01","00","00","00","00","00"),
	("00","00","00","00","01","00","00","00","01","01","01","00","00","00","00","00"),
	("00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00")
    );

	signal small_plane:matrix:= (
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","011","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","011","011","011","000","000","000","000","000","000","000"),
	("000","000","000","000","000","011","011","011","011","011","000","000","000","000","000","000"),
	("000","000","000","000","011","011","011","011","011","011","011","000","000","000","000","000"),
	("000","000","000","000","011","000","000","011","000","000","011","000","000","000","000","000"),
	("000","000","000","000","000","000","001","011","001","000","000","000","000","000","000","000"),
	("000","000","010","000","000","000","001","011","001","000","000","000","010","000","000","000"),
	("000","010","010","010","000","001","001","011","001","001","000","010","010","010","000","000"),
	("000","010","001","010","001","001","001","011","001","001","001","010","001","010","000","000"),
	("000","010","001","001","001","001","001","011","001","001","001","001","001","010","000","000"),
	("000","010","001","001","001","000","001","011","001","000","001","001","001","010","000","000"),
	("000","010","001","010","000","000","001","011","001","000","000","010","001","010","000","000"),
	("000","010","010","010","000","000","001","000","001","000","000","010","010","010","000","000"),
	("000","000","010","000","000","000","000","000","000","000","000","000","010","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"));
	
	signal bigbee30:matrix:= (
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000"),
	("000","000","000","000","001","001","000","000","000","100","100","000","000","000","000","000"),
	("000","000","000","001","001","000","000","000","100","100","000","000","000","000","000","000"),
	("000","000","001","001","000","000","000","000","100","100","000","001","001","000","000","000"),
	("000","001","001","000","000","000","000","100","100","000","000","000","001","001","000","000"),
	("000","001","100","100","100","100","100","100","100","100","000","000","000","001","001","000"),
	("000","001","100","100","100","100","100","100","100","100","100","100","100","100","001","000"),
	("000","001","001","100","100","100","100","100","100","100","100","100","100","001","001","000"),
	("000","001","000","011","011","100","100","100","100","100","100","100","000","001","001","000"),
	("000","000","000","011","011","011","011","011","011","011","011","000","000","001","001","000"),
	("000","000","000","000","011","010","011","011","011","011","000","000","000","000","000","000"),
	("000","000","000","000","011","011","011","010","011","000","000","000","000","000","000","000"),
	("000","000","000","000","000","011","011","011","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"));
	
	signal bigbee45:matrix:= (
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","001","001","001","001","001","000","000","000","000","100","100","000"),
	("000","001","001","001","001","001","001","001","001","000","000","000","100","100","100","000"),
	("000","001","001","100","100","100","000","000","000","000","000","100","100","100","000","000"),
	("000","001","001","001","000","100","100","100","000","000","100","100","100","000","000","000"),
	("000","000","000","011","100","100","100","100","100","100","100","100","000","000","000","000"),
	("000","000","000","011","100","100","100","100","100","100","100","000","000","000","000","000"),
	("000","000","000","011","011","100","100","100","100","100","100","000","000","001","001","000"),
	("000","000","000","011","011","011","100","100","100","100","100","100","000","001","001","000"),
	("000","000","000","011","010","011","011","100","100","100","100","100","000","001","001","000"),
	("000","000","000","011","011","011","011","011","100","100","100","100","100","001","001","000"),
	("000","000","000","000","011","011","010","011","011","100","100","000","100","001","001","000"),
	("000","000","000","000","000","011","011","011","011","011","011","001","100","001","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","001","001","001","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","001","001","001","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"));
	
	signal red_flag:matrix24:= (
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","011","011","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","011","011","011","011","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","011","011","011","011","011","011","000","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","011","011","011","011","011","011","011","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","011","011","011","011","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","011","011","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","011","011","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","011","011","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","011","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","010","010","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"));

	constant INFO_H: integer := 550;
	constant INFO_V: integer := 125;
	constant info_size: integer := 50;
	signal infoH, infoV, infoG : std_logic;
	signal infoColor :unsigned(2 downto 0);

	signal big_explode: matrix24:= (
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","101","101","000","000","000","000","101","101","101","101","000","000","000","000","000","000","000"),
	("000","101","000","101","101","101","000","000","000","101","101","101","101","000","000","101","101","101","000","000"),
	("000","101","101","100","100","101","101","000","000","101","100","100","101","000","101","100","100","100","100","000"),
	("000","101","100","100","100","100","101","000","000","101","101","100","101","000","101","101","100","101","101","000"),
	("000","101","101","100","101","100","100","101","101","101","101","100","101","101","100","101","101","000","000","000"),
	("000","000","000","100","100","101","100","100","101","101","100","100","100","100","100","101","101","000","000","000"),
	("000","000","000","000","000","101","101","101","100","101","100","101","100","100","101","000","000","000","000","000"),
	("000","000","000","000","000","100","101","100","100","101","100","101","101","100","101","101","101","000","000","000"),
	("000","000","000","101","100","101","101","100","101","101","100","101","100","100","101","101","101","000","000","000"),
	("000","000","101","101","100","101","100","100","100","100","101","101","101","100","100","101","101","000","000","000"),
	("000","100","100","101","101","100","100","100","101","101","100","101","101","100","100","101","000","000","000","000"),
	("000","100","100","101","101","100","100","100","101","101","100","100","100","100","101","101","101","101","000","000"),
	("000","101","100","101","101","101","100","100","100","100","101","100","101","100","101","100","100","100","000","000"),
	("000","101","000","000","000","101","101","101","100","101","100","101","101","101","101","101","100","100","000","000"),
	("000","000","000","101","100","101","101","100","101","101","101","100","101","101","101","101","100","101","000","000"),
	("000","000","101","101","100","100","100","100","101","101","101","101","101","100","100","101","000","000","000","000"),
	("000","000","101","100","101","100","101","101","101","101","101","000","101","101","101","101","101","101","101","101"),
	("000","101","101","101","101","101","101","000","101","000","000","000","000","000","101","101","100","100","101","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"));

	type cursorType is array(0 to 15) of unsigned (0 to 15);
	signal cursor: cursorType:= (
	("0000000000000000"),("0000000000000000"),("0000000000000000"),("0011000000000000"),("0011110000000000"),
	("0011111100000000"),("0011111111000000"),("0011111111110000"),("0011111111111100"),("0011111111110000"),
	("0011111111000000"),("0011111100000000"),("0011110000000000"),("0011000000000000"),("0000000000000000"),
	("0000000000000000"));
	
	type picMatrix is array(integer range 0 to 99, integer range 0 to 49) of unsigned(2 downto 0);
	signal galaxian1: picMatrix := (
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100"),
	("111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"));
	signal galaxian2: picMatrix := (
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","111","111","111","111","111","111","111"),
	("100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","111","111","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100"),
	("000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","000","000","000","000","000"),
	("100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","100","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","100","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","100","000","000","000","000","000","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000"),
	("111","100","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","100","100","100","100","100","100","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","100","100","100","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","100","100","100","111","111","111","111","111","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","100","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","000","000","000","000","100","100","100","100","100","100","111","111","111","111","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111")
	);
	signal galaxian3: picMatrix := (
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111"),
	("100","100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","100","100","100"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111"),
	("100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","100","100","100","100","100","111","111","111","111","111","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","100","100","100","100","111","111","111","111","111"),
	("100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111"),
	("100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111"),
	("100","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100"),
	("100","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000"),
	("100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000"),
	("100","111","111","111","100","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000"),
	("100","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000"),
	("100","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000"),
	("100","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","100","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","100","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","111","100","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","111","100","100","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000"),
	("100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000"),
	("100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","100","100","000","000"),
	("100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000"),
	("100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","100","000"),
	("100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","100"),
	("100","111","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","100","111","111","111","111","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"));
	signal galaxian4: picMatrix := (
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","100","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","100","100","100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","000","000","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","000","000","000","000","000","100","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","100","100","100","100","100","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","000","000","000","000","000","000","100","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","100","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000"),
	("111","111","111","111","111","111","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","100"),
	("111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100"),
	("111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","100","100","100","100","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","100","100","111","100","100","100","000","000","000","000","000","000","000","000","000","100","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","100","100","100","111"),
	("000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100"),
	("000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100"),
	("000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000"),
	("000","000","000","000","000","000","100","100","100","100","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","100","100","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","100","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","100","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","100","000","000","000","000","000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
	("111","111","100","100","100","100","100","100","100","100","100","100","100","000","000","000","000","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","100","100","100","100","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"));
	signal galaxian5: picMatrix := (
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","100","100","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","100","100","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","100","100","100","100","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","100","000","000","000","000","000","000","000","100","100","100","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","100","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","100","100","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","100","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","100","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","100","100","100","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","100","000","000","000","000","000","100","100","111","111","111","100","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","100","111","100","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","100","100","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","100","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","100","100","100","100","111","111","111","111","111","111","111","111","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","100","111","111","111","111","111","111","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","100","111","111","111","111","111","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","100","100","100","100","100","100","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","100","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","100","000","000","000","000","000","000","000","000","100","100","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("100","111","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","100","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","100","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","100","111","111","100","100","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","100","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","100","100","100","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","100","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","100","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","100","111","111","100","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","100","100","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","100","111","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111"),
	("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111"),
	("100","100","100","000","000","000","100","100","100","100","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","100","100","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","100","000","000","000","100","111","111","111","100","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","100","000","000","000","000","000","000","000","000","000","000","100","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","100","100","100","111","111","111","111","111","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","100","100","100","100","100","100","100","100","100","100","100","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"),
	("111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111","111"));

begin

Delay : process (clk)
begin
	if rising_edge(clk) then
		clk25 <= not clk25;
	end if;
end process Delay;

DataProcess : process (clk)
variable flag :unsigned (11 downto 0);
variable beeNum: integer;
variable bulletNum : integer;
variable chipAndWrite : std_logic;
variable convertFlag: integer;
begin
	if rising_edge(clk) then 
		if reset_n = '0' then
			readdata <= (others => '0');
		else
			chipAndWrite := chipselect and write;
			if chipselect = '1' and read = '1' then
				readdata <= dataSendBack;
			elsif chipAndWrite = '1' and address = "01101" then
				startCount <= '1';
			else
				startCount <= '0';
			end if;

			flag := writedata(31 downto 20);	
			if chipAndWrite = '1' and address = "01100" then 		-- flying bee
				beeNum := to_integer(flag(2 downto 0));
				TCoorFlyBeeH(beeNum) <= writedata(19 downto 10);
				TCoorFlyBeeV(beeNum) <= writedata(9 downto 0);
				FlyBeeAngle(beeNum) <= flag(10 downto 7);
				FlyBeeType(beeNum) <= flag(4 downto 3);
			elsif chipAndWrite = '1' and address = "01010" then	 	-- bee bullet
				bulletNum := to_integer(flag(5 downto 0));						
				TCoorBeeBulletH(bulletNum) <= writedata(19 downto 10);
				TCoorBeeBulletV(bulletNum) <= writedata(9 downto 0);
			elsif chipAndWrite = '1' and address = "01000" then 		-- bee matrix
				CoorBeeMaxH <= writedata(19 downto 10);
				CoorBeeMaxV <= writedata(9 downto 0);
			elsif chipAndWrite = '1' and address = "00111" then 		-- plane
				TCoorPlaneH <= writedata(19 downto 10);
				TCoorPlaneV <= writedata(9 downto 0);
			elsif chipAndWrite = '1' and address = "00110" then 		-- plane bullet
				Rb1H <= writedata(19 downto 10);
				Rb1V <= writedata(9 downto 0);	
			elsif chipAndWrite = '1' and address = "00101" then 		-- alive matrix
				if (flag(0) = '1') then		-- alive 1
					tmpM1 <= writedata(19 downto 0);
				elsif (flag(1) = '1') then	-- alive 2
					tmpM2 <= writedata(19 downto 0);
				elsif (flag(2) = '1') then	-- alive 3
					tmpM3 <= writedata(19 downto 0);
				elsif (flag(3) = '1') then	-- alive 4
					tmpM4 <= writedata(19 downto 0);
				elsif (flag(4) = '1') then	-- alive 5
					tmpM5 <= writedata(19 downto 0);
				end if;
			elsif chipAndWrite = '1' and address = "00100" then		-- information
				convertFlag := to_integer(flag);
				if convertFlag = 1 then		-- main pic
					mainPic <= writedata(0);
					mainPicV <= writedata(19 downto 10);
				elsif convertFlag = 2 then	-- other information
					planeLife <= writedata(2 downto 0);
					level <= writedata(5 downto 3);
				elsif convertFlag = 3 then
					TmpClearScr <= '1';
				elsif convertFlag = 4 then	-- ready
					readySignal	<= writedata(0);
				elsif convertFlag = 5 then	-- pause
					pauseSignal <= writedata(0);
				elsif convertFlag = 6 then	-- g
					tmpgH <= writedata(19 downto 10);
					tmpgV <= writedata(9 downto 0);
				elsif convertFlag = 7 then	-- a
					tmpaH <= writedata(19 downto 10);
					tmpaV <= writedata(9 downto 0);
				elsif convertFlag = 8 then	-- m
					tmpmH <= writedata(19 downto 10);
					tmpmV <= writedata(9 downto 0);
				elsif convertFlag = 9 then	-- e
					tmpe1H <= writedata(19 downto 10);
					tmpe1V <= writedata(9 downto 0);
				elsif convertFlag = 10 then	-- o
					tmpoH <= writedata(19 downto 10);
					tmpoV <= writedata(9 downto 0);
				elsif convertFlag = 11 then	-- v
					tmpvH <= writedata(19 downto 10);
					tmpvV <= writedata(9 downto 0);
				elsif convertFlag = 12 then	-- e
					tmpe2H <= writedata(19 downto 10);
					tmpe2V <= writedata(9 downto 0);
				elsif convertFlag = 13 then	-- r
					tmprH <= writedata(19 downto 10);
					tmprV <= writedata(9 downto 0);
				end if;
			elsif chipAndWrite = '1' and address = "00011" then		-- plane explode
				if (flag(0) = '1') then
					planeSmall <= '1';
				else
					planeSmall <= '0';
				end if;
				TplaneExplodeH <= writedata(19 downto 10);
				TplaneExplodeV <= writedata(9 downto 0);
			elsif chipAndWrite = '1' and address = "00010" then 		-- bee explode
				if (flag(0) = '1') then 	-- small explode
					Small <= '1';
				else
					Small <= '0';
				end if;
				TCoorExplodeH <= writedata(19 downto 10);
				TCoorExplodeV <= writedata(9 downto 0);
			elsif chipAndWrite = '1' and address = "00001" then 		-- high score
				hiScoreData(0) <= writedata(3 downto 0);
				hiScoreData(1) <= writedata(7 downto 4);
				hiScoreData(2) <= writedata(11 downto 8);
				hiScoreData(3) <= writedata(15 downto 12);
				hiScoreData(4) <= writedata(19 downto 16);
			elsif chipAndWrite = '1' and address = "00000" then		-- score
				scoreData(0) <= writedata(3 downto 0);
				scoreData(1) <= writedata(7 downto 4);
				scoreData(2) <= writedata(11 downto 8);
				scoreData(3) <= writedata(15 downto 12);
				scoreData(4) <= writedata(19 downto 16);
			end if;
		end if;
	end if;
end process DataProcess;

SyncProcess: process (clk25)
begin
    if rising_edge(clk25) then
        if(vga_vsync = '1' and vga_hsync = '1') then
			b1V 						<= Rb1V;
			b1H							<= Rb1H;
			AliveMax(0) 				<= tmpM1;
			AliveMax(2) 				<= tmpM2;
			AliveMax(4) 				<= tmpM3;
			AliveMax(6) 				<= tmpM4;
			AliveMax(8) 				<= tmpM5;
			CoorExplodeH 				<= TCoorExplodeH;
			CoorExplodeV 				<= TCoorExplodeV;
			planeExplodeH 				<= TplaneExplodeH;
			planeExplodeV 				<= TplaneExplodeV;
			CoorPlaneH					<= TCoorPlaneH;
			CoorPlaneV					<= TCoorPlaneV;
			clearScr					<= TmpClearScr;
			for i in 0 to 6 loop
				CoorFlyBeeH(i) 			<= TCoorFlyBeeH(i);
				CoorFlyBeeV(i) 			<= TCoorFlyBeeV(i);
			end loop;
			for j in 0 to 29 loop
				CoorBeeBulletV(j)		<= TCoorBeeBulletV(j);
				CoorBeeBulletH(j)		<= TCoorBeeBulletH(j);
			end loop;
			gH <= tmpgH; aH <= tmpaH; mH <= tmpmH; e1H <= tmpe1H;
			oH <= tmpoH; vH <= tmpvH; e2H <= tmpe2H; rH <= tmprH;
			gV <= tmpgV; aV <= tmpaV; mV <= tmpmV; e1V <= tmpe1V;
			oV <= tmpoV; vV <= tmpvV; e2V <= tmpe2V; rV <= tmprV;
        end if;
    end if;
end process SyncProcess;

  -- Horizontal and vertical counters
HCounter : process (clk25)
begin
	if rising_edge(clk25) then      
		if reset_n = '0' then
			Hcount <= (others => '0');
		elsif EndOfLine = '1' then
			Hcount <= (others => '0');
		else
			Hcount <= Hcount + 1;
		end if;      
	end if;
end process HCounter;

EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
VCounter: process (clk25)
begin
	if rising_edge(clk25) then      
		if reset_n = '0' then
			Vcount <= (others => '0');
		elsif EndOfLine = '1' then
			if EndOfField = '1' then
				Vcount <= (others => '0');
			else
				Vcount <= Vcount + 1;
			end if;
		end if;
	end if;
end process VCounter;

EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK
HSyncGen : process (clk25)
begin
	if rising_edge(clk25) then     
		if reset_n = '0' or EndOfLine = '1' then
			vga_hsync <= '1';
		elsif Hcount = HSYNC - 1 then
			vga_hsync <= '0';
		end if;
	end if;
end process HSyncGen;
  
HBlankGen : process (clk25)
begin
	if rising_edge(clk25) then
		if reset_n = '0' then
			vga_hblank <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH then
			vga_hblank <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
			vga_hblank <= '1';
		end if;      
	end if;
end process HBlankGen;

VSyncGen : process (clk25)
begin
	if rising_edge(clk25) then
		if reset_n = '0' then
			vga_vsync <= '1';
		elsif EndOfLine ='1' then
			if EndOfField = '1' then
				vga_vsync <= '1';
			elsif Vcount = VSYNC - 1 then
				vga_vsync <= '0';
			end if;
		end if;      
	end if;
end process VSyncGen;

VBlankGen : process (clk25)
begin
	if rising_edge(clk25) then    
		if reset_n = '0' then
			vga_vblank <= '1';
		elsif EndOfLine = '1' then
			if Vcount = VSYNC + VBACK_PORCH - 1 then
				vga_vblank <= '0';
			elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
				vga_vblank <= '1';
			end if;
		end if;
	end if;
end process VBlankGen;

-------------------------plane Bullet--------------------------
Bullet1HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			b1Hshow <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + b1H then
			b1Hshow <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + BULLET_LONG + b1H then
			b1Hshow <= '0';
		end if;
	end if;
end process Bullet1HGen;

Bullet1VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			b1Vshow <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + b1V then
			b1Vshow <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + b1V + BULLET_HEIGHT then
			b1Vshow <= '0';
		end if;
	end if;
end process Bullet1VGen;

b1 <= b1Hshow and b1Vshow;

---------------------------plane--------------------------------
PlaneHGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			planeH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorPlaneH then
			planeH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorPlaneH + PLANE_SIZE then
			planeH <= '0';
		end if;
	end if;
end process PlaneHGen;

PlaneVGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			planeV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + CoorPlaneV then
			planeV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + CoorPlaneV + PLANE_SIZE then
			planeV <= '0';
		end if;
	end if;
end process PlaneVGen;

planeG <= planeV and planeH;

--------------------------bee matrix-----------------------
BeeMaxHGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			beeMaxH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorBeeMaxH then
			beeMaxH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorBeeMaxH + BEEMAX_LONG then
			beeMaxH <= '0';
		end if;
	end if;
end process BeeMaxHGen;

BeeMaxVGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			beeMaxV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH + CoorBeeMaxV - 1 then
			beeMaxV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH + CoorBeeMaxV - 1 + BEEMAX_HEIGHT then
			beeMaxV <= '0';
		end if;
	end if;
end process BeeMaxVGen;
beeMaxG <= beeMaxV and beeMaxH;

ExplodeHGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			ExplodeH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorExplodeH then
			ExplodeH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorExplodeH + BEE_SIZE then
			ExplodeH <= '0';
		end if;
	end if;
end process ExplodeHGen;

ExplodeVGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			ExplodeV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH + CoorExplodeV - 1 then
			ExplodeV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH + CoorExplodeV - 1 + BEE_SIZE then
			ExplodeV <= '0';
		end if;
	end if;
end process ExplodeVGen;

ExplodeG <= ExplodeV and ExplodeH;

BigExplodeHGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			BigExplodeH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + planeExplodeH then
			BigExplodeH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + planeExplodeH + PLANE_SIZE then
			BigExplodeH <= '0';
		end if;
	end if;
end process BigExplodeHGen;

BigExplodeVGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			BigExplodeV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH + planeExplodeV - 1 then
			BigExplodeV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH + planeExplodeV - 1 + PLANE_SIZE then
			BigExplodeV <= '0';
		end if;
	end if;
end process bigExplodeVGen;

BigExplodeG <= BigExplodeV and BigExplodeH;

TextHGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			TextH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorTextH then
			TextH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorTextH + textMatrixLong then
			TextH <= '0';
		end if;
	end if;
end process TextHGen;

TextVGen: process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			TextV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH + CoorTextV - 1 then
			TextV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH + CoorTextV - 1 + textMatrixHeight then
			TextV <= '0';
		end if;
	end if;
end process TextVGen;

TextG <= TextV and TextH;

BeeGen: process (clk)
variable resultTmpH :unsigned (9 downto 0);
variable resultTmpV :unsigned (9 downto 0);
variable resultH :integer;
variable resultV :integer;
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			big_beeG 	<= '0';
			bee_PurpleG <= '0';
			bee_GreenG 	<= '0';
			bee_RedG 	<= '0';
		elsif BeeMaxG = '1' then
			resultTmpH := to_integer(Hcount) - HSYNC - HBACK_PORCH - CoorBeeMaxH;
			resultH := to_integer(resultTmpH(9 downto 4));
			resultTmpV := to_integer(Vcount) - VSYNC - VBACK_PORCH - CoorBeeMaxV + 1;
			resultV := to_integer(resultTmpV(9 downto 4));
			if AliveMax (resultV)(resultH) = '1' then
				if BeeTypeMax(resultV) = "11" then
					big_beeG 	<= '1';
				elsif BeeTypeMax(resultV) = "10" then
					bee_RedG  	<= '1';
				elsif BeeTypeMax(resultV) = "01" then
					bee_PurpleG	<= '1';
				elsif BeeTypeMax(resultV) = "00" then
					bee_GreenG 	<= '1';
				end if;
			else
				big_beeG 		<= '0';
				bee_RedG 		<= '0';
				bee_PurpleG 	<= '0';
				bee_GreenG 		<= '0';
			end if;
		end if;
	end if;
end process BeeGen;

BoxProcess: process(clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			boxG <= '0';
		elsif Hcount >= HSYNC + HBACK_PORCH + HACTIVE - BOX_LONG and Vcount >= VSYNC + VBACK_PORCH - 1 then
			boxG <= '1';
		elsif Hcount <= HSYNC + HBACK_PORCH + HACTIVE 
		or Vcount <= VSYNC + VBACK_PORCH - 1 + BOX_HEIGHT then
			boxG <= '0';
		end if;
	end if;
end process BoxProcess;

----------------------------flying bees------------------------------
FlyBeeHGen: process (clk)
begin
	if rising_edge(clk) then
		for i in 0 to 6 loop			
			if reset_n = '0' then
				FlybeeH(i) <= '0';
			elsif Hcount = HSYNC + HBACK_PORCH + CoorFlyBeeH(i) then
				FlybeeH(i) <= '1';
			elsif Hcount = HSYNC + HBACK_PORCH + CoorFlyBeeH(i) + BEE_SIZE then
				FlybeeH(i) <= '0';
			end if;
		end loop;
	end if;
end process FlyBeeHGen;

FlyBeeVGen: process (clk)
begin
	if rising_edge(clk) then
		for i in 0 to 6 loop
			if reset_n = '0' then
				FlybeeV(i) <= '0';
			elsif Vcount = VSYNC + VBACK_PORCH + CoorFlyBeeV(i) - 1 then
				FlybeeV(i) <= '1';
			elsif Vcount = VSYNC + VBACK_PORCH + CoorFlyBeeV(i) - 1 + BEE_SIZE then
				FlybeeV(i) <= '0';
			end if;
		end loop;
	end if;
end process FlyBeeVGen;

FlybeeGBack(0) <= FlybeeV(0) and FlybeeH(0);
FlybeeGBack(1) <= FlybeeV(1) and FlybeeH(1);
FlybeeGBack(2) <= FlybeeV(2) and FlybeeH(2);
FlybeeGBack(3) <= FlybeeV(3) and FlybeeH(3);
FlybeeGBack(4) <= FlybeeV(4) and FlybeeH(4);
FlybeeGBack(5) <= FlybeeV(5) and FlybeeH(5);
FlybeeGBack(6) <= FlybeeV(6) and FlybeeH(6);


FlybeeGGen : process (clk)
variable colorSignal : unsigned (2 downto 0);
variable tmpSignal : unsigned (1 downto 0);
variable flyV : integer;
variable flyH : integer;
begin
	if rising_edge(clk) then
		for i in 0 to 6 loop
			if FlybeeGBack(i) = '1' then
				flyV := to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(CoorFlyBeeV(i));
				flyH := to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(CoorFlyBeeH(i));
				if FlyBeeType(i) = "11" then
					if FlyBeeAngle(i) = "0000" then
						colorSignal := big_bee(flyV, flyH);
					elsif FlyBeeAngle(i) = "0100" then
						colorSignal := bigbee30(16 - flyV, flyH);
					elsif FlyBeeAngle(i) = "1000" then
						colorSignal := bigbee45(16 - flyV, flyH);
					elsif FlyBeeAngle(i) = "1100" then
						colorSignal := bigbee30(16 - flyH - 1, flyV);
					elsif FlyBeeAngle(i) = "0001" then
						colorSignal := big_bee(flyH, flyV);
					elsif FlyBeeAngle(i) = "1110" then
						colorSignal := bigbee30(16 - flyH - 1, 16 - flyV);
					elsif FlyBeeAngle(i) = "1010" then
						colorSignal := bigbee45(flyV, flyH);
					elsif FlyBeeAngle(i) = "0110" then
						colorSignal := bigbee30(flyV, flyH);
					elsif FlyBeeAngle(i) = "0010" then
						colorSignal := big_bee(16 - flyV, flyH);
					elsif FlyBeeAngle(i) = "0111" then
						colorSignal := bigbee30(flyV, 16 - flyH - 1);
					elsif FlyBeeAngle(i) = "1011" then
						colorSignal := bigbee45(flyV, 16 - flyH - 1);
					elsif FlyBeeAngle(i) = "1111" then
						colorSignal := bigbee30(flyH, 16 - flyV);
					elsif FlyBeeAngle(i) = "0011" then
						colorSignal := big_bee(16 - flyH - 1, flyV);
					elsif FlyBeeAngle(i) = "1101" then
						colorSignal := bigbee30(flyH, flyV);
					elsif FlyBeeAngle(i) = "1001" then
						colorSignal := bigbee45(flyH, flyV);
					elsif FlyBeeAngle(i) = "0101" then
						colorSignal := bigbee30(16 - flyV, 16 - flyH - 1);
					end if;
					if colorSignal = "000" then
						FlybeeG(i) <= '0';
					else
						FlybeeG(i) <= '1';
					end if;
				else				
					if FlyBeeAngle(i) = "0000" then
						tmpSignal := bee(flyV, flyH);
					elsif FlyBeeAngle(i) = "0100" then
						tmpSignal := bee30(16 - flyV, flyH);
					elsif FlyBeeAngle(i) = "1000" then
						tmpSignal := bee45(16 - flyV, flyH);
					elsif FlyBeeAngle(i) = "1100" then
						tmpSignal := bee30(16 - flyH, flyV);
					elsif FlyBeeAngle(i) = "0001" then
						tmpSignal := bee(flyH, flyV);
					elsif FlyBeeAngle(i) = "1110" then
						tmpSignal := bee30(16 - flyH, 16 - flyV);
					elsif FlyBeeAngle(i) = "1010" then
						tmpSignal := bee45(flyV, flyH);
					elsif FlyBeeAngle(i) = "0110" then
						tmpSignal := bee30(flyV, flyH);
					elsif FlyBeeAngle(i) = "0010" then
						tmpSignal := bee(16 - flyV, flyH);
					elsif FlyBeeAngle(i) = "0111" then
						tmpSignal := bee30(flyV, 16 - flyH - 1);
					elsif FlyBeeAngle(i) = "1011" then
						tmpSignal := bee45(flyV, 16 - flyH - 1);
					elsif FlyBeeAngle(i) = "1111" then
						tmpSignal := bee30(flyH, 16 - flyV);
					elsif FlyBeeAngle(i) = "0011" then
						tmpSignal := bee(16 - flyH - 1, flyV);
					elsif FlyBeeAngle(i) = "1101" then
						tmpSignal := bee30(flyH, flyV);
					elsif FlyBeeAngle(i) = "1001" then
						tmpSignal := bee45(flyH, flyV);
					elsif FlyBeeAngle(i) = "0101" then
						tmpSignal := bee30(16 - flyV, 16 - flyH - 1);
					end if;
					
					if tmpSignal = "10" then
						colorSignal := "111";
					elsif tmpSignal = "11" then
						colorSignal := "100";
					elsif FlyBeeType(i) = "10" and tmpSignal = "01" then
						colorSignal := "011";
					elsif FlyBeeType(i) = "00" and tmpSignal = "01" then
						colorSignal := "110";
					elsif FlyBeeType(i) = "01" and tmpSignal = "01" then
						colorSignal := "001";
					end if;
					
					if tmpSignal = "00" then
						FlybeeG(i) <= '0';
					else
						FlybeeG(i) <= '1';
					end if;
				end if;
				TransColorSignal <= colorSignal;
			end if;
		end loop;
	end if;
end process FlybeeGGen;

----------------------------bee bullet---------------------------------
BeeBulletHGen : process (clk)
begin
	if rising_edge(clk) then
		for i in 0 to 29 loop
			if reset_n = '0' then
				beeBulletH(i) <= '0';
			elsif Hcount = HSYNC + HBACK_PORCH + coorBeeBulletH(i) then
				beeBulletH(i) <= '1';
			elsif Hcount = HSYNC + HBACK_PORCH + BULLET_LONG + coorBeeBulletH(i) then
				beeBulletH(i) <= '0';
			end if;
		end loop;
	end if;
end process BeeBulletHGen;

BeeBulletVGen : process (clk)
begin
	if rising_edge(clk) then
		for i in 0 to 29 loop
			if reset_n = '0' then
				beeBulletV(i) <= '0';
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + coorBeeBulletV(i) then
				beeBulletV(i) <= '1';
			elsif Vcount = VSYNC + VBACK_PORCH - 1 + BULLET_HEIGHT + coorBeeBulletV(i) then
				beeBulletV(i) <= '0';
			end if;
		end loop;
	end if;
end process BeeBulletVGen;

BeeBulletGGen: process (clk)
variable tmp: std_logic;
begin
	if rising_edge(clk) then
		tmp := '0';
		for i in 0 to 29 loop
			beeBulletG(i) <= beeBulletH(i) and beeBulletV(i);
			if (beeBulletG(i) = '1' and tmp = '0') then
				tmp := '1';
			end if;
		end loop;
		getBullet <= tmp;
	end if;
end process BeeBulletGGen;

-----------------------------Score process-----------------------------
ScoreProcess : process (clk)
variable H : unsigned (9 downto 0);
variable V : unsigned (9 downto 0);
variable num : integer;
variable color : std_logic;
begin
	if rising_edge(clk) then
		H := Hcount - HSYNC - HBACK_PORCH - 1 - CoorTextH - 10;
		V := Vcount - VSYNC - VBACK_PORCH + 1 - 65;
		
		if to_integer(H) >= 0 and to_integer(H) <= 39 and 
			to_integer(V) >= 0 and to_integer(V) <= 9 then
			num := to_integer(hiScoreData(to_integer(H(9 downto 3))));
			if num = 1 then
				color := one(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 2 then
				color := two(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 3 then
				color := three(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 4 then
				color := four(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 5 then	
				color := five(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 6 then
				color := six(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 7 then
				color := seven(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 8 then
				color := eight(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 9 then
				color := nine(to_integer(V))(to_integer(H(2 downto 0)));
			elsif num = 0 then
				color := zero(to_integer(V))(to_integer(H(2 downto 0)));
			end if;
			if color = '0' then
				hiScoreColorSignal <= "000";
			elsif color = '1' then
				hiScoreColorSignal <= "111";
			end if;			
		end if;
	end if;
end process ScoreProcess;

ScoreProcess2 : process (clk)
variable H2 : unsigned (9 downto 0);
variable V2 : unsigned (9 downto 0);
variable num : integer;
variable color : std_logic;
begin
	if rising_edge(clk) then
		
		H2 := Hcount - HSYNC - HBACK_PORCH - 1 - CoorTextH - 10;
		V2 := Vcount - VSYNC - VBACK_PORCH + 1 - 95;
		
		if to_integer(H2) >= 0 and to_integer(H2) <= 39 and 
			to_integer(V2) >= 0 and to_integer(V2) <= 9 then
			num := to_integer(scoreData(to_integer(H2(9 downto 3))));
			if num = 1 then
				color := one(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 2 then
				color := two(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 3 then
				color := three(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 4 then
				color := four(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 5 then	
				color := five(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 6 then
				color := six(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 7 then
				color := seven(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 8 then
				color := eight(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 9 then
				color := nine(to_integer(V2))(to_integer(H2(2 downto 0)));
			elsif num = 0 then
				color := zero(to_integer(V2))(to_integer(H2(2 downto 0)));
			end if;
			if color = '0' then
				scoreColorSignal <= "000";
			elsif color = '1' then
				scoreColorSignal <= "010";
			end if;			
		end if;
	end if;
end process ScoreProcess2;

------------------------------stars background---------------------------
starGen: process (clk)
begin
	if rising_edge(clk) then
		starH <= '0';
		starH1 <= '0';
		starH2 <= '0';
		starH3 <= '0';
		for i in 0 to 6 loop
			if
			(to_integer(Hcount(9 downto 0))-HSYNC-HBACK_PORCH-to_integer(coorstarH)+88*i =0) and 
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(i) >=0)and
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(i) <=1)then
				starH <= '1';
			end if;
		end loop;
		for j in 0 to 6 loop
			if
			(to_integer(Hcount(9 downto 0))-HSYNC-HBACK_PORCH-to_integer(coorstarH)+88*j+22 =0) and 
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(j+7) >=0)and
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(j+7) <=1)then
				starH1 <= '1';
			end if;
		end loop;
		for m in 0 to 6 loop
			if
			(to_integer(Hcount(9 downto 0))-HSYNC-HBACK_PORCH-to_integer(coorstarH)+88*m+44 =0) and 
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(m+14) >=0)and
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(m+14) <=1)then
				starH2 <= '1';
			end if;
		end loop;

		for n in 0 to 6 loop
			if
			(to_integer(Hcount(9 downto 0))-HSYNC-HBACK_PORCH-to_integer(coorstarH)+88*n+66 =0) and 
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(n+21) >=0)and
			(to_integer(Vcount(9 downto 0))-VSYNC-VBACK_PORCH-roll(n+21) <=1)
			 then
			starH3 <= '1';
			end if;
		end loop;
	end if;
end process starGen;
------------------------------------------------

starG <= starH and flipstate;
starG1 <= starH1 and flipstate1;
starG2 <= starH2 and flipstate2;
starG3 <= starH3 and flipstate3;
-------------------------------------------------
flipGen: process (clk)
begin
	if rising_edge(clk) then
		if EndOfField = '1' then
			for l in 0 to 27 loop
				if to_integer(coorstarV)+stararrayV(l)>= 480 then
					roll(l)<=to_integer(coorstarV)+stararrayV(l)-480;
				else
					roll(l)<=to_integer(coorstarV)+stararrayV(l);
				end if;
			end loop;
			if shinecount =1600 then
				shinecount <= 0;
				if coorstarV = "0111011110" then
					coorstarV <= "0000000000";
				else
					coorstarV <= coorstarV + "0000000001";
				end if;
			else
				shinecount <= shinecount +1;
			end if;

			if flipcount = 40000 then 
				flipcount <= 0;
				if flipstate ='0' then
					flipstate <= '1';
				elsif flipstate ='1' then
					flipstate <= '0';
				end if;

				if shine = "111" then
					shine <= "001";
				else
					shine <= shine + "001";
				end if;

				if flipstate2 ='0' then
					flipstate2 <= '1';
				elsif flipstate2 ='1' then
					flipstate2 <= '0';
				end if;

				if shine2 = "001" then
					shine2 <= "111";
				else
					shine2 <= shine2 - "001";
				end if;
			elsif flipcount = 20000 then 
				flipcount <= flipcount +1;
				if flipstate1 ='0' then
					flipstate1 <= '1';
				elsif flipstate1 ='1' then
					flipstate1 <= '0';
				end if;
				if shine1 = "111" then
					shine1 <= "001";
				else
					shine1 <= shine1 + "001";
				end if;
				if flipstate3 ='0' then
					flipstate3 <= '1';
				elsif flipstate3 ='1' then
					flipstate3 <= '0';
				end if;
				if shine3 = "111" then
					shine3 <= "001";
				else
					shine3 <= shine3 + "001";
				end if;
			else
				flipcount <= flipcount +1;
			end if;
		end if;
	end if;
end process flipGen;

galaxianHGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			glaH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorGlaH then
			glaH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + GLA_LONG + CoorGlaH then
			glaH <= '0';
		end if;
	end if;
end process galaxianHGen;

galaxianVGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			glaV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + mainPicV then
			glaV <= '1';
		elsif (Vcount = VSYNC + VBACK_PORCH - 1 + GLA_HEIGHT + mainPicV) or 
				Vcount = VSYNC + VBACK_PORCH - 1 + VACTIVE then
			glaV <= '0';
		end if;
	end if;
end process galaxianVGen;

glaG <= glaH and glaV;

galaxianGen : process (clk)
variable h,v : integer;
begin
	if rising_edge(clk) then
		if glaG = '1' and mainPic = '1' then
			h := to_integer(Hcount) - (HSYNC + HBACK_PORCH + CoorGlaH );
			v := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(mainPicV));
			if v < 100 then											--------- big picture
				if h < 50 then
					galaxianColor <= galaxian1(v,h);
				elsif h >= 50 and h < 100 then
					galaxianColor <= galaxian2(v,h - 50);
				elsif h >= 100 and h < 150 then
					galaxianColor <= galaxian3(v,h - 100);
				elsif h >= 150 and h < 200 then
					galaxianColor <= galaxian4(v,h - 150);
				elsif h >= 200 and h < 250 then
					galaxianColor <= galaxian5(v,h - 200);
				end if;
			elsif v >= 205 and v < 220 and h >= 65 and h < 193 then	--------- trademark
				if trademark(v - 205)(h - 65) = '1' then
					galaxianColor <= "010";
				else
					galaxianColor <= "000";
				end if;
			elsif v >= 119 and v < 137  and h >= 87 and h < 103 then --------- cursor
				if cursor(v - 119)(h - 87) = '1' then
					galaxianColor <= "100";
				else
					galaxianColor <= "000";
				end if;
			elsif v >= 120 and v < 134 and h >= 108 and h < 158 then --------- start
				if start(v - 120)(h - 108) = '1' then
					galaxianColor <= "001";
				else
					galaxianColor <= "000";
				end if;
			elsif v >= 160 and v < 174  and h >= 45 and h < 185 then --------- xiaotian qi
				if xiaotian(v - 160)(h - 45) = '1' then
					galaxianColor <= "010";
				else
					galaxianColor <= "000";
				end if;
			elsif v >= 180 and v < 194  and h >= 45 and h < 205 then --------- yaolong feng
				if yaolong(v - 180)(h - 45) = '1' then
					galaxianColor <= "010";
				else
					galaxianColor <= "000";
				end if;
			else
				galaxianColor <= "000";
			end if;
		end if;
	end if;
end process galaxianGen;

--------------------------sync with software------------------------
timeCountDelay: process (clk)
begin
	if rising_edge(clk) then
		if startCount = '1' then
			timeDelayCount <= 0;
		end if;
		if timeDelayCount = synctime then
			dataSendBack <= x"0000000F";
		else
			timeDelayCount <= timeDelayCount + 1;
			dataSendBack <= (others => '1');
		end if;
	end if;
end process timeCountDelay;

--------------------------- wind flip ------------------------------
timeCountDelay2: process (clk)
begin
	if rising_edge(clk) then
		if timeDelayCount = synctime then
			if windFlipCount = 20000 then
				windFlip <= not(windFlip);
				windFlipCount <= 0;
			else
				windFlipCount <= windFlipCount + 1;
			end if;
		end if;
	end if;
end process timeCountDelay2;

------------------------ready---------------------------
readyHGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' or readySignal = '0' then
			readyH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorReadyH then
			readyH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + READY_LONG + CoorReadyH then
			readyH <= '0';
		end if;
	end if;
end process readyHGen;

readyVGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' or readySignal = '0' then
			readyV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + CoorReadyV then
			readyV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + READY_HEIGHT + CoorReadyV then
			readyV <= '0';
		end if;
	end if;
end process readyVGen;

readyG <= readyH and readyV;

readyGGen: process (clk)
begin
	if rising_edge(clk) then
		if readyG = '1' then
			if (ready(to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + CoorReadyV))
			(to_integer(Hcount) - (HSYNC + HBACK_PORCH + CoorReadyH)) = '1') then
				readyColor <= "011";
			else
				readyColor <= "000";
			end if;
		end if;
	end if;
end process readyGGen;

-----------------------pause----------------------
pauseHGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' or pauseSignal = '0' then
			pauseH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + CoorReadyH then
			pauseH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + READY_LONG + CoorReadyH then
			pauseH <= '0';
		end if;
	end if;
end process pauseHGen;

pauseVGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' or pauseSignal = '0' then
			pauseV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + CoorReadyV then
			pauseV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + READY_HEIGHT + CoorReadyV then
			pauseV <= '0';
		end if;
	end if;
end process pauseVGen;

pauseG <= pauseH and pauseV;

pauseGGen: process (clk)
begin
	if rising_edge(clk) then
		if pauseG = '1' then
			if (pause(to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + CoorReadyV))
			(to_integer(Hcount) - (HSYNC + HBACK_PORCH + CoorReadyH)) = '1') then
				pauseColor <= "011";
			else
				pauseColor <= "000";
			end if;
		end if;
	end if;
end process pauseGGen;

--------------------------gameover----------------------
gameover_g_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			gHG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + gH then
			gHG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + gH then
			gHG <= '0';
		end if;
	end if;
end process gameover_g_HGen;

gameover_g_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			gVG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + gV then
			gVG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + gV then
			gVG <= '0';
		end if;
	end if;
end process gameover_g_VGen;

gG <= gHG and gVG;

gameover_a_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			aHG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + aH then
			aHG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + aH then
			aHG <= '0';
		end if;
	end if;
end process gameover_a_HGen;

gameover_a_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			aVG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + aV then
			aVG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + aV then
			aVG <= '0';
		end if;
	end if;
end process gameover_a_VGen;

aG <= aHG and aVG;

gameover_m_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			mHG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + mH then
			mHG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + mH then
			mHG <= '0';
		end if;
	end if;
end process gameover_m_HGen;

gameover_m_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			mVG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + mV then
			mVG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + mV then
			mVG <= '0';
		end if;
	end if;
end process gameover_m_VGen;

mG <= mHG and mVG;

gameover_e1_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			e1HG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + e1H then
			e1HG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + e1H then
			e1HG <= '0';
		end if;
	end if;
end process gameover_e1_HGen;

gameover_e1_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			e1VG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + e1V then
			e1VG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + e1V then
			e1VG <= '0';
		end if;
	end if;
end process gameover_e1_VGen;

e1G <= e1HG and e1VG;

gameover_o_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			oHG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + oH then
			oHG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + oH then
			oHG <= '0';
		end if;
	end if;
end process gameover_o_HGen;

gameover_o_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			oVG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + oV then
			oVG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + oV then
			oVG <= '0';
		end if;
	end if;
end process gameover_o_VGen;

oG <= oVG and oHG;

gameover_v_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			vHG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + vH then
			vHG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + vH then
			vHG <= '0';
		end if;
	end if;
end process gameover_v_HGen;

gameover_v_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			vVG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + vV then
			vVG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + vV then
			vVG <= '0';
		end if;
	end if;
end process gameover_v_VGen;

vG <= vHG and vVG;

gameover_e2_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			e2HG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + e2H then
			e2HG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + e2H then
			e2HG <= '0';
		end if;
	end if;
end process gameover_e2_HGen;

gameover_e2_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			e2VG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + e2V then
			e2VG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + e2V then
			e2VG <= '0';
		end if;
	end if;
end process gameover_e2_VGen;

e2G <= e2HG and e2VG;

gameover_r_HGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			rHG <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + rH then
			rHG <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + ALPHALONG + rH then
			rHG <= '0';
		end if;
	end if;
end process gameover_r_HGen;

gameover_r_VGen : process (clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			rVG <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + rV then
			rVG <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + ALPHAHEIGHT + rV then
			rVG <= '0';
		end if;
	end if;
end process gameover_r_VGen;

rG <= rHG and rVG;

gameoverGen : process (clk)
variable ch, cv: integer;
begin
	if rising_edge(clk) then
		if gG = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(gH));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(gV));
			gameoverSignal <= g(cv)(ch);
		elsif aG = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(aH));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(aV));
			gameoverSignal <= a(cv)(ch);
		elsif mG = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(mH));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(mV));
			gameoverSignal <= m(cv)(ch);
		elsif e1G = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(e1H));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(e1V));
			gameoverSignal <= e(cv)(ch);
		elsif oG = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(oH));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(oV));
			gameoverSignal <= o(cv)(ch);
		elsif vG = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(vH));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(vV));
			gameoverSignal <= v(cv)(ch);
		elsif e2G = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(e2H));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(e2V));
			gameoverSignal <= e(cv)(ch);
		elsif rG = '1' then
			ch := to_integer(Hcount) - (HSYNC + HBACK_PORCH + to_integer(rH));
			cv := to_integer(Vcount) - (VSYNC + VBACK_PORCH - 1 + to_integer(rV));
			gameoverSignal <= r(cv)(ch);
		end if;
		
		if gameoverSignal = '1' then
			gameoverColorSignal <= "010";
		else
			gameoverColorSignal <= "000";
		end if;
	end if;
end process gameoverGen;

---------------------red flag------------------------
infoHGen : process(clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			infoH <= '0';
		elsif Hcount = HSYNC + HBACK_PORCH + INFO_H then
			infoH <= '1';
		elsif Hcount = HSYNC + HBACK_PORCH + info_size + INFO_H then
			infoH <= '0';
		end if;
	end if;
end process infoHGen;

infoVGen : process(clk)
begin
	if rising_edge(clk) then
		if reset_n = '0' then
			infoV <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + INFO_V then
			infoV <= '1';
		elsif Vcount = VSYNC + VBACK_PORCH - 1 + info_size + INFO_V then
			infoV <= '0';
		end if;
	end if;
end process infoVGen;

infoG <= infoH and infoV;

infoGen :process(clk)
variable H : integer;
variable V : integer;
variable tmpV : integer;
variable num : integer;
variable color : std_logic;
begin
	if rising_edge(clk) then
		if infoG = '1' then
			H := to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - INFO_H;
			V := to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - INFO_V;
			if H >= 0 and H < 20 and V >= 0 and V < 20 then
				infoColor <= red_flag(V, H);
			elsif H >= 0 and H < 16 and V >= 30 and V < 46 then
				infoColor <= small_plane(V - 30, H);
			elsif (H >= 25 and H < 31 and V >= 5 and V < 15) then
				tmpV := V - 5;
				num := to_integer(planeLife);
				if num = 1 then
					color := one(tmpV)(H - 25);
				elsif num = 2 then
					color := two(tmpV)(H - 25);
				elsif num = 3 then
					color := three(tmpV)(H - 25);
				elsif num = 4 then
					color := four(tmpV)(H - 25);
				elsif num = 5 then	
					color := five(tmpV)(H - 25);
				elsif num = 6 then
					color := six(tmpV)(H - 25);
				elsif num = 7 then
					color := seven(tmpV)(H - 25);
				elsif num = 8 then
					color := eight(tmpV)(H - 25);
				elsif num = 9 then
					color := nine(tmpV)(H - 25);
				elsif num = 0 then
					color := zero(tmpV)(H - 25);
				end if;
				if color = '0' then
					infoColor <= "000";
				elsif color = '1' then
					infoColor <= "100";
				end if;
			elsif (H >= 25 and H < 31 and V >= 35 and V < 45) then		
				tmpV := V - 35;
				num := to_integer(level);
				if num = 1 then
					color := one(tmpV)(H - 25);
				elsif num = 2 then
					color := two(tmpV)(H - 25);
				elsif num = 3 then
					color := three(tmpV)(H - 25);
				elsif num = 4 then
					color := four(tmpV)(H - 25);
				elsif num = 5 then	
					color := five(tmpV)(H - 25);
				elsif num = 6 then
					color := six(tmpV)(H - 25);
				elsif num = 7 then
					color := seven(tmpV)(H - 25);
				elsif num = 8 then
					color := eight(tmpV)(H - 25);
				elsif num = 9 then
					color := nine(tmpV)(H - 25);
				elsif num = 0 then
					color := zero(tmpV)(H - 25);
				end if;
				if color = '0' then
					infoColor <= "000";
				elsif color = '1' then
					infoColor <= "100";
				end if;
			else
				infoColor <= "000";
			end if;
		end if;
	end if;
end process infoGen;

VideoOut: process (clk, reset_n)
variable colorSignal : unsigned (2 downto 0);
variable flyV : integer;
variable flyH : integer;
variable tmpTextH: integer;
variable tmpTextV: integer;
variable tmpSignal : unsigned (1 downto 0);
variable tmpExplodeH, tmpExplodeV : integer;
begin
	if reset_n = '0' then
		VGA_R <= "0000000000";
		VGA_G <= "0000000000";
		VGA_B <= "0000000000";
	elsif clk'event and clk = '1' then
		if glaG = '1' and galaxianColor /= "000" and mainPic = '1' then
			colorSignal := galaxianColor;
		elsif TextG = '1' then
			tmptextH := to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - CoorTextH;
			tmptextV := to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - CoorTextV;
			if tmptextH >= 0 and tmptextH <= 54 and tmptextV >= 0 and tmptextV <= 9 then
				if hiScore (tmptextV)(tmptextH) = '1' then
					colorSignal := "011";
				else
					colorSignal := "000";
				end if;
			elsif tmptextH >= 10 and tmptextH <= 49 and tmptextV >= 15 and tmptextV <= 24 then
				colorSignal := hiScoreColorSignal;
			elsif tmptextH >= 0 and tmptextH <= 21 and tmptextV >= 30 and tmptextV <= 39 then
				if oneUP (tmpTextV - 30)(tmpTextH) = '1' then
					colorSignal := "011";
				else
					colorSignal := "000";
				end if;
			elsif tmptextH >= 10 and tmptextH <= 49 and tmptextV >= 45 and tmptextV <= 54 then
				colorSignal := scoreColorSignal;
			end if;
		elsif infoG = '1' then
			colorSignal := infoColor;		
		elsif boxG = '1' then
			colorSignal := "000";
		elsif (FlybeeG(0) = '1' or FlybeeG(1) = '1' or FlybeeG(2) = '1' or FlybeeG(3) = '1' or 
				FlybeeG(4) = '1' or FlybeeG(5) = '1' or FlybeeG(6) = '1') and mainPic = '0' then
				colorSignal := TransColorSignal;
		elsif readyG = '1' then
			colorSignal := readyColor;
		elsif pauseG = '1' then
			colorSignal := pauseColor;
		elsif gG = '1' or aG = '1' or mG = '1' or e1G = '1' or
			oG = '1' or vG = '1' or e2G = '1' or rG = '1' then
			colorSignal := gameoverColorSignal;
		elsif ExplodeG = '1' and mainPic = '0' then
			if Small = '1' then
				colorSignal := small_explode(
				to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(CoorExplodeV),
				to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(CoorExplodeH));
			elsif Small = '0' then
				colorSignal := explode(
				to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(CoorExplodeV),
				to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(CoorExplodeH));
			end if;
		elsif BigExplodeG = '1' and mainPic = '0' then			-- plane Explode
			tmpExplodeH := to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(planeExplodeH);
			tmpExplodeV := to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(planeExplodeV);
			if planeSmall = '1' then
				if tmpExplodeH < 16 and tmpExplodeV < 16 then
					colorSignal := explode(tmpExplodeV, tmpExplodeH);
				end if;
			elsif planeSmall = '0' then
				colorSignal := big_explode(tmpExplodeV, tmpExplodeH);
			end if;
		elsif planeG = '1' and mainPic = '0' then
			colorSignal := plane(
			to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(CoorPlaneV),
			to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(CoorPlaneH));
		elsif big_beeG = '1' and mainPic = '0' then
			colorSignal := big_bee(
			to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(CoorBeeMaxV),
			to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(CoorBeeMaxH));
		elsif (b1 = '1' or getBullet = '1') and mainPic = '0' then
			colorSignal := "010";
		elsif BeeMaxG = '1' and mainPic = '0' then
			if windFlip = '1' then
				tmpSignal := bee(
				to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(CoorBeeMaxV),
				to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(CoorBeeMaxH));
			else
				tmpSignal := beef(
				to_integer(Vcount) - VSYNC - VBACK_PORCH + 1 - to_integer(CoorBeeMaxV),
				to_integer(Hcount) - HSYNC - HBACK_PORCH - 1 - to_integer(CoorBeeMaxH));
			end if;
			if bee_RedG = '1' or bee_GreenG = '1' or bee_PurpleG = '1' then
				if tmpSignal = "10" then
					colorSignal := "111";
				elsif tmpSignal = "11" then
					colorSignal := "100";			
				elsif bee_RedG = '1' and tmpSignal = "01" then
					colorSignal := "101"; 
				elsif bee_GreenG = '1' and tmpSignal = "01" then
					colorSignal := "110";
				elsif bee_PurpleG = '1' and tmpSignal = "01" then
					colorSignal := "001";
				elsif tmpSignal = "00" then
					colorSignal := "000";
				end if;
			else
				colorSignal := "000";
			end if;
		elsif starG = '1' then
			colorSignal := shine;
		elsif starG1 = '1' then
			colorSignal := shine1;
		elsif starG2 = '1' then
			colorSignal := shine2;
		elsif starG3 = '1' then
			colorSignal := shine3;
		else
			colorSignal := "000";
		end if;
		
		if clearScr = '1' then
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";

		elsif colorSignal = "001" then   -- purple
			VGA_R <= "0101111011";
			VGA_G <= "0011001111";
			VGA_B <= "1111111111";

		elsif colorSignal = "011" then   -- red
			VGA_R <= "1111111111";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";

		elsif colorSignal = "100" then   -- yellow
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "0000000000";

		elsif colorSignal = "101" then   -- brown
			VGA_R <= "1100100000";
			VGA_G <= "0000011110";
			VGA_B <= "0000011110";

		elsif colorSignal = "110" then   -- green
			VGA_R <= "0000010101";
			VGA_G <= "1101111000";
			VGA_B <= "0000000111";

		elsif colorSignal = "111" then   -- light blue
			VGA_R <= "0000010000";
			VGA_G <= "1101010100";
			VGA_B <= "1101010111";
		
		elsif clearScr = '1' then
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";
			
		elsif colorSignal = "010" then   -- white
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "1111111111";
			
		-------------------------this is background----------------------
		elsif vga_hblank = '0' and vga_vblank ='0' then
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";
		else
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";
		end if;
	end if;
end process VideoOut;

	VGA_CLK <= clk25;
	VGA_HS <= not vga_hsync;
	VGA_VS <= not vga_vsync;
	VGA_SYNC <= '0';
	VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;
