library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity audio_bus is

  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    writedata  : in  unsigned(15 downto 0);
    cpu_cmd : in std_logic_vector(31 downto 0)
    );  
end audio_bus;

architecture rtl of audio_bus is

begin
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then       
        tone <= x"1000";
      else
        if chipselect = '1' then
		  if write = '1' then
			tone <= writedata;
          end if;
        end if;		
      end if;
    end if;
  end process;

end rtl;
