//megafunction wizard: %Altera SOPC Builder%
//GENERATION: STANDARD
//VERSION: WM1.0


//Legal Notice: (C)2007 Altera Corporation. All rights reserved.  Your
//use of Altera Corporation's design tools, logic functions and other
//software and tools, and its AMPP partner logic functions, and any
//output files any of the foregoing (including device programming or
//simulation files), and any associated documentation or information are
//expressly subject to the terms and conditions of the Altera Program
//License Subscription Agreement or other applicable license agreement,
//including, without limitation, that your use is for the sole purpose
//of programming logic devices manufactured by Altera and sold by Altera
//or its authorized distributors.  Please refer to the applicable
//agreement for further details.

// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module Audio_0_avalon_slave_0_arbitrator (
                                           // inputs:
                                            Audio_0_avalon_slave_0_readdata,
                                            clk,
                                            cpu_0_data_master_address_to_slave,
                                            cpu_0_data_master_read,
                                            cpu_0_data_master_waitrequest,
                                            cpu_0_data_master_write,
                                            cpu_0_data_master_writedata,
                                            reset_n,

                                           // outputs:
                                            Audio_0_avalon_slave_0_readdata_from_sa,
                                            Audio_0_avalon_slave_0_reset_n,
                                            Audio_0_avalon_slave_0_write,
                                            Audio_0_avalon_slave_0_writedata,
                                            cpu_0_data_master_granted_Audio_0_avalon_slave_0,
                                            cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0,
                                            cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0,
                                            cpu_0_data_master_requests_Audio_0_avalon_slave_0,
                                            d1_Audio_0_avalon_slave_0_end_xfer
                                         )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [ 15: 0] Audio_0_avalon_slave_0_readdata_from_sa;
  output           Audio_0_avalon_slave_0_reset_n;
  output           Audio_0_avalon_slave_0_write;
  output  [ 15: 0] Audio_0_avalon_slave_0_writedata;
  output           cpu_0_data_master_granted_Audio_0_avalon_slave_0;
  output           cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0;
  output           cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0;
  output           cpu_0_data_master_requests_Audio_0_avalon_slave_0;
  output           d1_Audio_0_avalon_slave_0_end_xfer;
  input   [ 15: 0] Audio_0_avalon_slave_0_readdata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            reset_n;

  wire             Audio_0_avalon_slave_0_allgrants;
  wire             Audio_0_avalon_slave_0_allow_new_arb_cycle;
  wire             Audio_0_avalon_slave_0_any_bursting_master_saved_grant;
  wire             Audio_0_avalon_slave_0_any_continuerequest;
  wire             Audio_0_avalon_slave_0_arb_counter_enable;
  reg     [  1: 0] Audio_0_avalon_slave_0_arb_share_counter;
  wire    [  1: 0] Audio_0_avalon_slave_0_arb_share_counter_next_value;
  wire    [  1: 0] Audio_0_avalon_slave_0_arb_share_set_values;
  wire             Audio_0_avalon_slave_0_beginbursttransfer_internal;
  wire             Audio_0_avalon_slave_0_begins_xfer;
  wire             Audio_0_avalon_slave_0_end_xfer;
  wire             Audio_0_avalon_slave_0_firsttransfer;
  wire             Audio_0_avalon_slave_0_grant_vector;
  wire             Audio_0_avalon_slave_0_in_a_read_cycle;
  wire             Audio_0_avalon_slave_0_in_a_write_cycle;
  wire             Audio_0_avalon_slave_0_master_qreq_vector;
  wire             Audio_0_avalon_slave_0_non_bursting_master_requests;
  wire    [ 15: 0] Audio_0_avalon_slave_0_readdata_from_sa;
  reg              Audio_0_avalon_slave_0_reg_firsttransfer;
  wire             Audio_0_avalon_slave_0_reset_n;
  reg              Audio_0_avalon_slave_0_slavearbiterlockenable;
  wire             Audio_0_avalon_slave_0_slavearbiterlockenable2;
  wire             Audio_0_avalon_slave_0_unreg_firsttransfer;
  wire             Audio_0_avalon_slave_0_waits_for_read;
  wire             Audio_0_avalon_slave_0_waits_for_write;
  wire             Audio_0_avalon_slave_0_write;
  wire    [ 15: 0] Audio_0_avalon_slave_0_writedata;
  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_requests_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_saved_grant_Audio_0_avalon_slave_0;
  reg              d1_Audio_0_avalon_slave_0_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_Audio_0_avalon_slave_0;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 23: 0] shifted_address_to_Audio_0_avalon_slave_0_from_cpu_0_data_master;
  wire             wait_for_Audio_0_avalon_slave_0_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~Audio_0_avalon_slave_0_end_xfer;
    end


  assign Audio_0_avalon_slave_0_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0));
  //assign Audio_0_avalon_slave_0_readdata_from_sa = Audio_0_avalon_slave_0_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign Audio_0_avalon_slave_0_readdata_from_sa = Audio_0_avalon_slave_0_readdata;

  assign cpu_0_data_master_requests_Audio_0_avalon_slave_0 = ({cpu_0_data_master_address_to_slave[23 : 2] , 2'b0} == 24'h90105c) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //Audio_0_avalon_slave_0_arb_share_counter set values, which is an e_mux
  assign Audio_0_avalon_slave_0_arb_share_set_values = 1;

  //Audio_0_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  assign Audio_0_avalon_slave_0_non_bursting_master_requests = cpu_0_data_master_requests_Audio_0_avalon_slave_0;

  //Audio_0_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  assign Audio_0_avalon_slave_0_any_bursting_master_saved_grant = 0;

  //Audio_0_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  assign Audio_0_avalon_slave_0_arb_share_counter_next_value = Audio_0_avalon_slave_0_firsttransfer ? (Audio_0_avalon_slave_0_arb_share_set_values - 1) : |Audio_0_avalon_slave_0_arb_share_counter ? (Audio_0_avalon_slave_0_arb_share_counter - 1) : 0;

  //Audio_0_avalon_slave_0_allgrants all slave grants, which is an e_mux
  assign Audio_0_avalon_slave_0_allgrants = |Audio_0_avalon_slave_0_grant_vector;

  //Audio_0_avalon_slave_0_end_xfer assignment, which is an e_assign
  assign Audio_0_avalon_slave_0_end_xfer = ~(Audio_0_avalon_slave_0_waits_for_read | Audio_0_avalon_slave_0_waits_for_write);

  //end_xfer_arb_share_counter_term_Audio_0_avalon_slave_0 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_Audio_0_avalon_slave_0 = Audio_0_avalon_slave_0_end_xfer & (~Audio_0_avalon_slave_0_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //Audio_0_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  assign Audio_0_avalon_slave_0_arb_counter_enable = (end_xfer_arb_share_counter_term_Audio_0_avalon_slave_0 & Audio_0_avalon_slave_0_allgrants) | (end_xfer_arb_share_counter_term_Audio_0_avalon_slave_0 & ~Audio_0_avalon_slave_0_non_bursting_master_requests);

  //Audio_0_avalon_slave_0_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          Audio_0_avalon_slave_0_arb_share_counter <= 0;
      else if (Audio_0_avalon_slave_0_arb_counter_enable)
          Audio_0_avalon_slave_0_arb_share_counter <= Audio_0_avalon_slave_0_arb_share_counter_next_value;
    end


  //Audio_0_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          Audio_0_avalon_slave_0_slavearbiterlockenable <= 0;
      else if ((|Audio_0_avalon_slave_0_master_qreq_vector & end_xfer_arb_share_counter_term_Audio_0_avalon_slave_0) | (end_xfer_arb_share_counter_term_Audio_0_avalon_slave_0 & ~Audio_0_avalon_slave_0_non_bursting_master_requests))
          Audio_0_avalon_slave_0_slavearbiterlockenable <= |Audio_0_avalon_slave_0_arb_share_counter_next_value;
    end


  //cpu_0/data_master Audio_0/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = Audio_0_avalon_slave_0_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //Audio_0_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign Audio_0_avalon_slave_0_slavearbiterlockenable2 = |Audio_0_avalon_slave_0_arb_share_counter_next_value;

  //cpu_0/data_master Audio_0/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = Audio_0_avalon_slave_0_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //Audio_0_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_assign
  assign Audio_0_avalon_slave_0_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0 = cpu_0_data_master_requests_Audio_0_avalon_slave_0 & ~((cpu_0_data_master_read & (~cpu_0_data_master_waitrequest)) | ((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //Audio_0_avalon_slave_0_writedata mux, which is an e_mux
  assign Audio_0_avalon_slave_0_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_Audio_0_avalon_slave_0 = cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0;

  //cpu_0/data_master saved-grant Audio_0/avalon_slave_0, which is an e_assign
  assign cpu_0_data_master_saved_grant_Audio_0_avalon_slave_0 = cpu_0_data_master_requests_Audio_0_avalon_slave_0;

  //allow new arb cycle for Audio_0/avalon_slave_0, which is an e_assign
  assign Audio_0_avalon_slave_0_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign Audio_0_avalon_slave_0_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign Audio_0_avalon_slave_0_master_qreq_vector = 1;

  //Audio_0_avalon_slave_0_reset_n assignment, which is an e_assign
  assign Audio_0_avalon_slave_0_reset_n = reset_n;

  //Audio_0_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  assign Audio_0_avalon_slave_0_firsttransfer = Audio_0_avalon_slave_0_begins_xfer ? Audio_0_avalon_slave_0_unreg_firsttransfer : Audio_0_avalon_slave_0_reg_firsttransfer;

  //Audio_0_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  assign Audio_0_avalon_slave_0_unreg_firsttransfer = ~(Audio_0_avalon_slave_0_slavearbiterlockenable & Audio_0_avalon_slave_0_any_continuerequest);

  //Audio_0_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          Audio_0_avalon_slave_0_reg_firsttransfer <= 1'b1;
      else if (Audio_0_avalon_slave_0_begins_xfer)
          Audio_0_avalon_slave_0_reg_firsttransfer <= Audio_0_avalon_slave_0_unreg_firsttransfer;
    end


  //Audio_0_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign Audio_0_avalon_slave_0_beginbursttransfer_internal = Audio_0_avalon_slave_0_begins_xfer;

  //Audio_0_avalon_slave_0_write assignment, which is an e_mux
  assign Audio_0_avalon_slave_0_write = cpu_0_data_master_granted_Audio_0_avalon_slave_0 & cpu_0_data_master_write;

  assign shifted_address_to_Audio_0_avalon_slave_0_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //d1_Audio_0_avalon_slave_0_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_Audio_0_avalon_slave_0_end_xfer <= 1;
      else if (1)
          d1_Audio_0_avalon_slave_0_end_xfer <= Audio_0_avalon_slave_0_end_xfer;
    end


  //Audio_0_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  assign Audio_0_avalon_slave_0_waits_for_read = Audio_0_avalon_slave_0_in_a_read_cycle & 0;

  //Audio_0_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  assign Audio_0_avalon_slave_0_in_a_read_cycle = cpu_0_data_master_granted_Audio_0_avalon_slave_0 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = Audio_0_avalon_slave_0_in_a_read_cycle;

  //Audio_0_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  assign Audio_0_avalon_slave_0_waits_for_write = Audio_0_avalon_slave_0_in_a_write_cycle & 0;

  //Audio_0_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  assign Audio_0_avalon_slave_0_in_a_write_cycle = cpu_0_data_master_granted_Audio_0_avalon_slave_0 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = Audio_0_avalon_slave_0_in_a_write_cycle;

  assign wait_for_Audio_0_avalon_slave_0_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //Audio_0/avalon_slave_0 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module SD_CLK_s1_arbitrator (
                              // inputs:
                               clk,
                               cpu_0_data_master_address_to_slave,
                               cpu_0_data_master_read,
                               cpu_0_data_master_waitrequest,
                               cpu_0_data_master_write,
                               cpu_0_data_master_writedata,
                               reset_n,

                              // outputs:
                               SD_CLK_s1_address,
                               SD_CLK_s1_chipselect,
                               SD_CLK_s1_reset_n,
                               SD_CLK_s1_write_n,
                               SD_CLK_s1_writedata,
                               cpu_0_data_master_granted_SD_CLK_s1,
                               cpu_0_data_master_qualified_request_SD_CLK_s1,
                               cpu_0_data_master_read_data_valid_SD_CLK_s1,
                               cpu_0_data_master_requests_SD_CLK_s1,
                               d1_SD_CLK_s1_end_xfer
                            )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [  1: 0] SD_CLK_s1_address;
  output           SD_CLK_s1_chipselect;
  output           SD_CLK_s1_reset_n;
  output           SD_CLK_s1_write_n;
  output           SD_CLK_s1_writedata;
  output           cpu_0_data_master_granted_SD_CLK_s1;
  output           cpu_0_data_master_qualified_request_SD_CLK_s1;
  output           cpu_0_data_master_read_data_valid_SD_CLK_s1;
  output           cpu_0_data_master_requests_SD_CLK_s1;
  output           d1_SD_CLK_s1_end_xfer;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            reset_n;

  wire    [  1: 0] SD_CLK_s1_address;
  wire             SD_CLK_s1_allgrants;
  wire             SD_CLK_s1_allow_new_arb_cycle;
  wire             SD_CLK_s1_any_bursting_master_saved_grant;
  wire             SD_CLK_s1_any_continuerequest;
  wire             SD_CLK_s1_arb_counter_enable;
  reg     [  1: 0] SD_CLK_s1_arb_share_counter;
  wire    [  1: 0] SD_CLK_s1_arb_share_counter_next_value;
  wire    [  1: 0] SD_CLK_s1_arb_share_set_values;
  wire             SD_CLK_s1_beginbursttransfer_internal;
  wire             SD_CLK_s1_begins_xfer;
  wire             SD_CLK_s1_chipselect;
  wire             SD_CLK_s1_end_xfer;
  wire             SD_CLK_s1_firsttransfer;
  wire             SD_CLK_s1_grant_vector;
  wire             SD_CLK_s1_in_a_read_cycle;
  wire             SD_CLK_s1_in_a_write_cycle;
  wire             SD_CLK_s1_master_qreq_vector;
  wire             SD_CLK_s1_non_bursting_master_requests;
  reg              SD_CLK_s1_reg_firsttransfer;
  wire             SD_CLK_s1_reset_n;
  reg              SD_CLK_s1_slavearbiterlockenable;
  wire             SD_CLK_s1_slavearbiterlockenable2;
  wire             SD_CLK_s1_unreg_firsttransfer;
  wire             SD_CLK_s1_waits_for_read;
  wire             SD_CLK_s1_waits_for_write;
  wire             SD_CLK_s1_write_n;
  wire             SD_CLK_s1_writedata;
  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_SD_CLK_s1;
  wire             cpu_0_data_master_qualified_request_SD_CLK_s1;
  wire             cpu_0_data_master_read_data_valid_SD_CLK_s1;
  wire             cpu_0_data_master_requests_SD_CLK_s1;
  wire             cpu_0_data_master_saved_grant_SD_CLK_s1;
  reg              d1_SD_CLK_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_SD_CLK_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 23: 0] shifted_address_to_SD_CLK_s1_from_cpu_0_data_master;
  wire             wait_for_SD_CLK_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~SD_CLK_s1_end_xfer;
    end


  assign SD_CLK_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_SD_CLK_s1));
  assign cpu_0_data_master_requests_SD_CLK_s1 = (({cpu_0_data_master_address_to_slave[23 : 4] , 4'b0} == 24'h901030) & (cpu_0_data_master_read | cpu_0_data_master_write)) & cpu_0_data_master_write;
  //SD_CLK_s1_arb_share_counter set values, which is an e_mux
  assign SD_CLK_s1_arb_share_set_values = 1;

  //SD_CLK_s1_non_bursting_master_requests mux, which is an e_mux
  assign SD_CLK_s1_non_bursting_master_requests = cpu_0_data_master_requests_SD_CLK_s1;

  //SD_CLK_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign SD_CLK_s1_any_bursting_master_saved_grant = 0;

  //SD_CLK_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign SD_CLK_s1_arb_share_counter_next_value = SD_CLK_s1_firsttransfer ? (SD_CLK_s1_arb_share_set_values - 1) : |SD_CLK_s1_arb_share_counter ? (SD_CLK_s1_arb_share_counter - 1) : 0;

  //SD_CLK_s1_allgrants all slave grants, which is an e_mux
  assign SD_CLK_s1_allgrants = |SD_CLK_s1_grant_vector;

  //SD_CLK_s1_end_xfer assignment, which is an e_assign
  assign SD_CLK_s1_end_xfer = ~(SD_CLK_s1_waits_for_read | SD_CLK_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_SD_CLK_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_SD_CLK_s1 = SD_CLK_s1_end_xfer & (~SD_CLK_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //SD_CLK_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign SD_CLK_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_SD_CLK_s1 & SD_CLK_s1_allgrants) | (end_xfer_arb_share_counter_term_SD_CLK_s1 & ~SD_CLK_s1_non_bursting_master_requests);

  //SD_CLK_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_CLK_s1_arb_share_counter <= 0;
      else if (SD_CLK_s1_arb_counter_enable)
          SD_CLK_s1_arb_share_counter <= SD_CLK_s1_arb_share_counter_next_value;
    end


  //SD_CLK_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_CLK_s1_slavearbiterlockenable <= 0;
      else if ((|SD_CLK_s1_master_qreq_vector & end_xfer_arb_share_counter_term_SD_CLK_s1) | (end_xfer_arb_share_counter_term_SD_CLK_s1 & ~SD_CLK_s1_non_bursting_master_requests))
          SD_CLK_s1_slavearbiterlockenable <= |SD_CLK_s1_arb_share_counter_next_value;
    end


  //cpu_0/data_master SD_CLK/s1 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = SD_CLK_s1_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //SD_CLK_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign SD_CLK_s1_slavearbiterlockenable2 = |SD_CLK_s1_arb_share_counter_next_value;

  //cpu_0/data_master SD_CLK/s1 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = SD_CLK_s1_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //SD_CLK_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign SD_CLK_s1_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_SD_CLK_s1 = cpu_0_data_master_requests_SD_CLK_s1 & ~(((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //SD_CLK_s1_writedata mux, which is an e_mux
  assign SD_CLK_s1_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_SD_CLK_s1 = cpu_0_data_master_qualified_request_SD_CLK_s1;

  //cpu_0/data_master saved-grant SD_CLK/s1, which is an e_assign
  assign cpu_0_data_master_saved_grant_SD_CLK_s1 = cpu_0_data_master_requests_SD_CLK_s1;

  //allow new arb cycle for SD_CLK/s1, which is an e_assign
  assign SD_CLK_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign SD_CLK_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign SD_CLK_s1_master_qreq_vector = 1;

  //SD_CLK_s1_reset_n assignment, which is an e_assign
  assign SD_CLK_s1_reset_n = reset_n;

  assign SD_CLK_s1_chipselect = cpu_0_data_master_granted_SD_CLK_s1;
  //SD_CLK_s1_firsttransfer first transaction, which is an e_assign
  assign SD_CLK_s1_firsttransfer = SD_CLK_s1_begins_xfer ? SD_CLK_s1_unreg_firsttransfer : SD_CLK_s1_reg_firsttransfer;

  //SD_CLK_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign SD_CLK_s1_unreg_firsttransfer = ~(SD_CLK_s1_slavearbiterlockenable & SD_CLK_s1_any_continuerequest);

  //SD_CLK_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_CLK_s1_reg_firsttransfer <= 1'b1;
      else if (SD_CLK_s1_begins_xfer)
          SD_CLK_s1_reg_firsttransfer <= SD_CLK_s1_unreg_firsttransfer;
    end


  //SD_CLK_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign SD_CLK_s1_beginbursttransfer_internal = SD_CLK_s1_begins_xfer;

  //~SD_CLK_s1_write_n assignment, which is an e_mux
  assign SD_CLK_s1_write_n = ~(cpu_0_data_master_granted_SD_CLK_s1 & cpu_0_data_master_write);

  assign shifted_address_to_SD_CLK_s1_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //SD_CLK_s1_address mux, which is an e_mux
  assign SD_CLK_s1_address = shifted_address_to_SD_CLK_s1_from_cpu_0_data_master >> 2;

  //d1_SD_CLK_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_SD_CLK_s1_end_xfer <= 1;
      else if (1)
          d1_SD_CLK_s1_end_xfer <= SD_CLK_s1_end_xfer;
    end


  //SD_CLK_s1_waits_for_read in a cycle, which is an e_mux
  assign SD_CLK_s1_waits_for_read = SD_CLK_s1_in_a_read_cycle & SD_CLK_s1_begins_xfer;

  //SD_CLK_s1_in_a_read_cycle assignment, which is an e_assign
  assign SD_CLK_s1_in_a_read_cycle = cpu_0_data_master_granted_SD_CLK_s1 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = SD_CLK_s1_in_a_read_cycle;

  //SD_CLK_s1_waits_for_write in a cycle, which is an e_mux
  assign SD_CLK_s1_waits_for_write = SD_CLK_s1_in_a_write_cycle & 0;

  //SD_CLK_s1_in_a_write_cycle assignment, which is an e_assign
  assign SD_CLK_s1_in_a_write_cycle = cpu_0_data_master_granted_SD_CLK_s1 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = SD_CLK_s1_in_a_write_cycle;

  assign wait_for_SD_CLK_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //SD_CLK/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module SD_CMD_s1_arbitrator (
                              // inputs:
                               SD_CMD_s1_readdata,
                               clk,
                               cpu_0_data_master_address_to_slave,
                               cpu_0_data_master_read,
                               cpu_0_data_master_waitrequest,
                               cpu_0_data_master_write,
                               cpu_0_data_master_writedata,
                               reset_n,

                              // outputs:
                               SD_CMD_s1_address,
                               SD_CMD_s1_chipselect,
                               SD_CMD_s1_readdata_from_sa,
                               SD_CMD_s1_reset_n,
                               SD_CMD_s1_write_n,
                               SD_CMD_s1_writedata,
                               cpu_0_data_master_granted_SD_CMD_s1,
                               cpu_0_data_master_qualified_request_SD_CMD_s1,
                               cpu_0_data_master_read_data_valid_SD_CMD_s1,
                               cpu_0_data_master_requests_SD_CMD_s1,
                               d1_SD_CMD_s1_end_xfer
                            )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [  1: 0] SD_CMD_s1_address;
  output           SD_CMD_s1_chipselect;
  output           SD_CMD_s1_readdata_from_sa;
  output           SD_CMD_s1_reset_n;
  output           SD_CMD_s1_write_n;
  output           SD_CMD_s1_writedata;
  output           cpu_0_data_master_granted_SD_CMD_s1;
  output           cpu_0_data_master_qualified_request_SD_CMD_s1;
  output           cpu_0_data_master_read_data_valid_SD_CMD_s1;
  output           cpu_0_data_master_requests_SD_CMD_s1;
  output           d1_SD_CMD_s1_end_xfer;
  input            SD_CMD_s1_readdata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            reset_n;

  wire    [  1: 0] SD_CMD_s1_address;
  wire             SD_CMD_s1_allgrants;
  wire             SD_CMD_s1_allow_new_arb_cycle;
  wire             SD_CMD_s1_any_bursting_master_saved_grant;
  wire             SD_CMD_s1_any_continuerequest;
  wire             SD_CMD_s1_arb_counter_enable;
  reg     [  1: 0] SD_CMD_s1_arb_share_counter;
  wire    [  1: 0] SD_CMD_s1_arb_share_counter_next_value;
  wire    [  1: 0] SD_CMD_s1_arb_share_set_values;
  wire             SD_CMD_s1_beginbursttransfer_internal;
  wire             SD_CMD_s1_begins_xfer;
  wire             SD_CMD_s1_chipselect;
  wire             SD_CMD_s1_end_xfer;
  wire             SD_CMD_s1_firsttransfer;
  wire             SD_CMD_s1_grant_vector;
  wire             SD_CMD_s1_in_a_read_cycle;
  wire             SD_CMD_s1_in_a_write_cycle;
  wire             SD_CMD_s1_master_qreq_vector;
  wire             SD_CMD_s1_non_bursting_master_requests;
  wire             SD_CMD_s1_readdata_from_sa;
  reg              SD_CMD_s1_reg_firsttransfer;
  wire             SD_CMD_s1_reset_n;
  reg              SD_CMD_s1_slavearbiterlockenable;
  wire             SD_CMD_s1_slavearbiterlockenable2;
  wire             SD_CMD_s1_unreg_firsttransfer;
  wire             SD_CMD_s1_waits_for_read;
  wire             SD_CMD_s1_waits_for_write;
  wire             SD_CMD_s1_write_n;
  wire             SD_CMD_s1_writedata;
  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_SD_CMD_s1;
  wire             cpu_0_data_master_qualified_request_SD_CMD_s1;
  wire             cpu_0_data_master_read_data_valid_SD_CMD_s1;
  wire             cpu_0_data_master_requests_SD_CMD_s1;
  wire             cpu_0_data_master_saved_grant_SD_CMD_s1;
  reg              d1_SD_CMD_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_SD_CMD_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 23: 0] shifted_address_to_SD_CMD_s1_from_cpu_0_data_master;
  wire             wait_for_SD_CMD_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~SD_CMD_s1_end_xfer;
    end


  assign SD_CMD_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_SD_CMD_s1));
  //assign SD_CMD_s1_readdata_from_sa = SD_CMD_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign SD_CMD_s1_readdata_from_sa = SD_CMD_s1_readdata;

  assign cpu_0_data_master_requests_SD_CMD_s1 = ({cpu_0_data_master_address_to_slave[23 : 4] , 4'b0} == 24'h901020) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //SD_CMD_s1_arb_share_counter set values, which is an e_mux
  assign SD_CMD_s1_arb_share_set_values = 1;

  //SD_CMD_s1_non_bursting_master_requests mux, which is an e_mux
  assign SD_CMD_s1_non_bursting_master_requests = cpu_0_data_master_requests_SD_CMD_s1;

  //SD_CMD_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign SD_CMD_s1_any_bursting_master_saved_grant = 0;

  //SD_CMD_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign SD_CMD_s1_arb_share_counter_next_value = SD_CMD_s1_firsttransfer ? (SD_CMD_s1_arb_share_set_values - 1) : |SD_CMD_s1_arb_share_counter ? (SD_CMD_s1_arb_share_counter - 1) : 0;

  //SD_CMD_s1_allgrants all slave grants, which is an e_mux
  assign SD_CMD_s1_allgrants = |SD_CMD_s1_grant_vector;

  //SD_CMD_s1_end_xfer assignment, which is an e_assign
  assign SD_CMD_s1_end_xfer = ~(SD_CMD_s1_waits_for_read | SD_CMD_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_SD_CMD_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_SD_CMD_s1 = SD_CMD_s1_end_xfer & (~SD_CMD_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //SD_CMD_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign SD_CMD_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_SD_CMD_s1 & SD_CMD_s1_allgrants) | (end_xfer_arb_share_counter_term_SD_CMD_s1 & ~SD_CMD_s1_non_bursting_master_requests);

  //SD_CMD_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_CMD_s1_arb_share_counter <= 0;
      else if (SD_CMD_s1_arb_counter_enable)
          SD_CMD_s1_arb_share_counter <= SD_CMD_s1_arb_share_counter_next_value;
    end


  //SD_CMD_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_CMD_s1_slavearbiterlockenable <= 0;
      else if ((|SD_CMD_s1_master_qreq_vector & end_xfer_arb_share_counter_term_SD_CMD_s1) | (end_xfer_arb_share_counter_term_SD_CMD_s1 & ~SD_CMD_s1_non_bursting_master_requests))
          SD_CMD_s1_slavearbiterlockenable <= |SD_CMD_s1_arb_share_counter_next_value;
    end


  //cpu_0/data_master SD_CMD/s1 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = SD_CMD_s1_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //SD_CMD_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign SD_CMD_s1_slavearbiterlockenable2 = |SD_CMD_s1_arb_share_counter_next_value;

  //cpu_0/data_master SD_CMD/s1 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = SD_CMD_s1_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //SD_CMD_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign SD_CMD_s1_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_SD_CMD_s1 = cpu_0_data_master_requests_SD_CMD_s1 & ~(((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //SD_CMD_s1_writedata mux, which is an e_mux
  assign SD_CMD_s1_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_SD_CMD_s1 = cpu_0_data_master_qualified_request_SD_CMD_s1;

  //cpu_0/data_master saved-grant SD_CMD/s1, which is an e_assign
  assign cpu_0_data_master_saved_grant_SD_CMD_s1 = cpu_0_data_master_requests_SD_CMD_s1;

  //allow new arb cycle for SD_CMD/s1, which is an e_assign
  assign SD_CMD_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign SD_CMD_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign SD_CMD_s1_master_qreq_vector = 1;

  //SD_CMD_s1_reset_n assignment, which is an e_assign
  assign SD_CMD_s1_reset_n = reset_n;

  assign SD_CMD_s1_chipselect = cpu_0_data_master_granted_SD_CMD_s1;
  //SD_CMD_s1_firsttransfer first transaction, which is an e_assign
  assign SD_CMD_s1_firsttransfer = SD_CMD_s1_begins_xfer ? SD_CMD_s1_unreg_firsttransfer : SD_CMD_s1_reg_firsttransfer;

  //SD_CMD_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign SD_CMD_s1_unreg_firsttransfer = ~(SD_CMD_s1_slavearbiterlockenable & SD_CMD_s1_any_continuerequest);

  //SD_CMD_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_CMD_s1_reg_firsttransfer <= 1'b1;
      else if (SD_CMD_s1_begins_xfer)
          SD_CMD_s1_reg_firsttransfer <= SD_CMD_s1_unreg_firsttransfer;
    end


  //SD_CMD_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign SD_CMD_s1_beginbursttransfer_internal = SD_CMD_s1_begins_xfer;

  //~SD_CMD_s1_write_n assignment, which is an e_mux
  assign SD_CMD_s1_write_n = ~(cpu_0_data_master_granted_SD_CMD_s1 & cpu_0_data_master_write);

  assign shifted_address_to_SD_CMD_s1_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //SD_CMD_s1_address mux, which is an e_mux
  assign SD_CMD_s1_address = shifted_address_to_SD_CMD_s1_from_cpu_0_data_master >> 2;

  //d1_SD_CMD_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_SD_CMD_s1_end_xfer <= 1;
      else if (1)
          d1_SD_CMD_s1_end_xfer <= SD_CMD_s1_end_xfer;
    end


  //SD_CMD_s1_waits_for_read in a cycle, which is an e_mux
  assign SD_CMD_s1_waits_for_read = SD_CMD_s1_in_a_read_cycle & SD_CMD_s1_begins_xfer;

  //SD_CMD_s1_in_a_read_cycle assignment, which is an e_assign
  assign SD_CMD_s1_in_a_read_cycle = cpu_0_data_master_granted_SD_CMD_s1 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = SD_CMD_s1_in_a_read_cycle;

  //SD_CMD_s1_waits_for_write in a cycle, which is an e_mux
  assign SD_CMD_s1_waits_for_write = SD_CMD_s1_in_a_write_cycle & 0;

  //SD_CMD_s1_in_a_write_cycle assignment, which is an e_assign
  assign SD_CMD_s1_in_a_write_cycle = cpu_0_data_master_granted_SD_CMD_s1 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = SD_CMD_s1_in_a_write_cycle;

  assign wait_for_SD_CMD_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //SD_CMD/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module SD_DAT_s1_arbitrator (
                              // inputs:
                               SD_DAT_s1_readdata,
                               clk,
                               cpu_0_data_master_address_to_slave,
                               cpu_0_data_master_read,
                               cpu_0_data_master_waitrequest,
                               cpu_0_data_master_write,
                               cpu_0_data_master_writedata,
                               reset_n,

                              // outputs:
                               SD_DAT_s1_address,
                               SD_DAT_s1_chipselect,
                               SD_DAT_s1_readdata_from_sa,
                               SD_DAT_s1_reset_n,
                               SD_DAT_s1_write_n,
                               SD_DAT_s1_writedata,
                               cpu_0_data_master_granted_SD_DAT_s1,
                               cpu_0_data_master_qualified_request_SD_DAT_s1,
                               cpu_0_data_master_read_data_valid_SD_DAT_s1,
                               cpu_0_data_master_requests_SD_DAT_s1,
                               d1_SD_DAT_s1_end_xfer
                            )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [  1: 0] SD_DAT_s1_address;
  output           SD_DAT_s1_chipselect;
  output           SD_DAT_s1_readdata_from_sa;
  output           SD_DAT_s1_reset_n;
  output           SD_DAT_s1_write_n;
  output           SD_DAT_s1_writedata;
  output           cpu_0_data_master_granted_SD_DAT_s1;
  output           cpu_0_data_master_qualified_request_SD_DAT_s1;
  output           cpu_0_data_master_read_data_valid_SD_DAT_s1;
  output           cpu_0_data_master_requests_SD_DAT_s1;
  output           d1_SD_DAT_s1_end_xfer;
  input            SD_DAT_s1_readdata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            reset_n;

  wire    [  1: 0] SD_DAT_s1_address;
  wire             SD_DAT_s1_allgrants;
  wire             SD_DAT_s1_allow_new_arb_cycle;
  wire             SD_DAT_s1_any_bursting_master_saved_grant;
  wire             SD_DAT_s1_any_continuerequest;
  wire             SD_DAT_s1_arb_counter_enable;
  reg     [  1: 0] SD_DAT_s1_arb_share_counter;
  wire    [  1: 0] SD_DAT_s1_arb_share_counter_next_value;
  wire    [  1: 0] SD_DAT_s1_arb_share_set_values;
  wire             SD_DAT_s1_beginbursttransfer_internal;
  wire             SD_DAT_s1_begins_xfer;
  wire             SD_DAT_s1_chipselect;
  wire             SD_DAT_s1_end_xfer;
  wire             SD_DAT_s1_firsttransfer;
  wire             SD_DAT_s1_grant_vector;
  wire             SD_DAT_s1_in_a_read_cycle;
  wire             SD_DAT_s1_in_a_write_cycle;
  wire             SD_DAT_s1_master_qreq_vector;
  wire             SD_DAT_s1_non_bursting_master_requests;
  wire             SD_DAT_s1_readdata_from_sa;
  reg              SD_DAT_s1_reg_firsttransfer;
  wire             SD_DAT_s1_reset_n;
  reg              SD_DAT_s1_slavearbiterlockenable;
  wire             SD_DAT_s1_slavearbiterlockenable2;
  wire             SD_DAT_s1_unreg_firsttransfer;
  wire             SD_DAT_s1_waits_for_read;
  wire             SD_DAT_s1_waits_for_write;
  wire             SD_DAT_s1_write_n;
  wire             SD_DAT_s1_writedata;
  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_SD_DAT_s1;
  wire             cpu_0_data_master_qualified_request_SD_DAT_s1;
  wire             cpu_0_data_master_read_data_valid_SD_DAT_s1;
  wire             cpu_0_data_master_requests_SD_DAT_s1;
  wire             cpu_0_data_master_saved_grant_SD_DAT_s1;
  reg              d1_SD_DAT_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_SD_DAT_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 23: 0] shifted_address_to_SD_DAT_s1_from_cpu_0_data_master;
  wire             wait_for_SD_DAT_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~SD_DAT_s1_end_xfer;
    end


  assign SD_DAT_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_SD_DAT_s1));
  //assign SD_DAT_s1_readdata_from_sa = SD_DAT_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign SD_DAT_s1_readdata_from_sa = SD_DAT_s1_readdata;

  assign cpu_0_data_master_requests_SD_DAT_s1 = ({cpu_0_data_master_address_to_slave[23 : 4] , 4'b0} == 24'h901010) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //SD_DAT_s1_arb_share_counter set values, which is an e_mux
  assign SD_DAT_s1_arb_share_set_values = 1;

  //SD_DAT_s1_non_bursting_master_requests mux, which is an e_mux
  assign SD_DAT_s1_non_bursting_master_requests = cpu_0_data_master_requests_SD_DAT_s1;

  //SD_DAT_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign SD_DAT_s1_any_bursting_master_saved_grant = 0;

  //SD_DAT_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign SD_DAT_s1_arb_share_counter_next_value = SD_DAT_s1_firsttransfer ? (SD_DAT_s1_arb_share_set_values - 1) : |SD_DAT_s1_arb_share_counter ? (SD_DAT_s1_arb_share_counter - 1) : 0;

  //SD_DAT_s1_allgrants all slave grants, which is an e_mux
  assign SD_DAT_s1_allgrants = |SD_DAT_s1_grant_vector;

  //SD_DAT_s1_end_xfer assignment, which is an e_assign
  assign SD_DAT_s1_end_xfer = ~(SD_DAT_s1_waits_for_read | SD_DAT_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_SD_DAT_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_SD_DAT_s1 = SD_DAT_s1_end_xfer & (~SD_DAT_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //SD_DAT_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign SD_DAT_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_SD_DAT_s1 & SD_DAT_s1_allgrants) | (end_xfer_arb_share_counter_term_SD_DAT_s1 & ~SD_DAT_s1_non_bursting_master_requests);

  //SD_DAT_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_DAT_s1_arb_share_counter <= 0;
      else if (SD_DAT_s1_arb_counter_enable)
          SD_DAT_s1_arb_share_counter <= SD_DAT_s1_arb_share_counter_next_value;
    end


  //SD_DAT_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_DAT_s1_slavearbiterlockenable <= 0;
      else if ((|SD_DAT_s1_master_qreq_vector & end_xfer_arb_share_counter_term_SD_DAT_s1) | (end_xfer_arb_share_counter_term_SD_DAT_s1 & ~SD_DAT_s1_non_bursting_master_requests))
          SD_DAT_s1_slavearbiterlockenable <= |SD_DAT_s1_arb_share_counter_next_value;
    end


  //cpu_0/data_master SD_DAT/s1 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = SD_DAT_s1_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //SD_DAT_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign SD_DAT_s1_slavearbiterlockenable2 = |SD_DAT_s1_arb_share_counter_next_value;

  //cpu_0/data_master SD_DAT/s1 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = SD_DAT_s1_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //SD_DAT_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign SD_DAT_s1_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_SD_DAT_s1 = cpu_0_data_master_requests_SD_DAT_s1 & ~(((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //SD_DAT_s1_writedata mux, which is an e_mux
  assign SD_DAT_s1_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_SD_DAT_s1 = cpu_0_data_master_qualified_request_SD_DAT_s1;

  //cpu_0/data_master saved-grant SD_DAT/s1, which is an e_assign
  assign cpu_0_data_master_saved_grant_SD_DAT_s1 = cpu_0_data_master_requests_SD_DAT_s1;

  //allow new arb cycle for SD_DAT/s1, which is an e_assign
  assign SD_DAT_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign SD_DAT_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign SD_DAT_s1_master_qreq_vector = 1;

  //SD_DAT_s1_reset_n assignment, which is an e_assign
  assign SD_DAT_s1_reset_n = reset_n;

  assign SD_DAT_s1_chipselect = cpu_0_data_master_granted_SD_DAT_s1;
  //SD_DAT_s1_firsttransfer first transaction, which is an e_assign
  assign SD_DAT_s1_firsttransfer = SD_DAT_s1_begins_xfer ? SD_DAT_s1_unreg_firsttransfer : SD_DAT_s1_reg_firsttransfer;

  //SD_DAT_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign SD_DAT_s1_unreg_firsttransfer = ~(SD_DAT_s1_slavearbiterlockenable & SD_DAT_s1_any_continuerequest);

  //SD_DAT_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SD_DAT_s1_reg_firsttransfer <= 1'b1;
      else if (SD_DAT_s1_begins_xfer)
          SD_DAT_s1_reg_firsttransfer <= SD_DAT_s1_unreg_firsttransfer;
    end


  //SD_DAT_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign SD_DAT_s1_beginbursttransfer_internal = SD_DAT_s1_begins_xfer;

  //~SD_DAT_s1_write_n assignment, which is an e_mux
  assign SD_DAT_s1_write_n = ~(cpu_0_data_master_granted_SD_DAT_s1 & cpu_0_data_master_write);

  assign shifted_address_to_SD_DAT_s1_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //SD_DAT_s1_address mux, which is an e_mux
  assign SD_DAT_s1_address = shifted_address_to_SD_DAT_s1_from_cpu_0_data_master >> 2;

  //d1_SD_DAT_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_SD_DAT_s1_end_xfer <= 1;
      else if (1)
          d1_SD_DAT_s1_end_xfer <= SD_DAT_s1_end_xfer;
    end


  //SD_DAT_s1_waits_for_read in a cycle, which is an e_mux
  assign SD_DAT_s1_waits_for_read = SD_DAT_s1_in_a_read_cycle & SD_DAT_s1_begins_xfer;

  //SD_DAT_s1_in_a_read_cycle assignment, which is an e_assign
  assign SD_DAT_s1_in_a_read_cycle = cpu_0_data_master_granted_SD_DAT_s1 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = SD_DAT_s1_in_a_read_cycle;

  //SD_DAT_s1_waits_for_write in a cycle, which is an e_mux
  assign SD_DAT_s1_waits_for_write = SD_DAT_s1_in_a_write_cycle & 0;

  //SD_DAT_s1_in_a_write_cycle assignment, which is an e_assign
  assign SD_DAT_s1_in_a_write_cycle = cpu_0_data_master_granted_SD_DAT_s1 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = SD_DAT_s1_in_a_write_cycle;

  assign wait_for_SD_DAT_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //SD_DAT/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module SEG7_Display_avalon_slave_0_arbitrator (
                                                // inputs:
                                                 clk,
                                                 cpu_0_data_master_address_to_slave,
                                                 cpu_0_data_master_read,
                                                 cpu_0_data_master_write,
                                                 cpu_0_data_master_writedata,
                                                 reset_n,

                                                // outputs:
                                                 SEG7_Display_avalon_slave_0_reset_n,
                                                 SEG7_Display_avalon_slave_0_write,
                                                 SEG7_Display_avalon_slave_0_writedata,
                                                 cpu_0_data_master_granted_SEG7_Display_avalon_slave_0,
                                                 cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0,
                                                 cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0,
                                                 cpu_0_data_master_requests_SEG7_Display_avalon_slave_0,
                                                 d1_SEG7_Display_avalon_slave_0_end_xfer
                                              )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           SEG7_Display_avalon_slave_0_reset_n;
  output           SEG7_Display_avalon_slave_0_write;
  output  [ 31: 0] SEG7_Display_avalon_slave_0_writedata;
  output           cpu_0_data_master_granted_SEG7_Display_avalon_slave_0;
  output           cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0;
  output           cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0;
  output           cpu_0_data_master_requests_SEG7_Display_avalon_slave_0;
  output           d1_SEG7_Display_avalon_slave_0_end_xfer;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            reset_n;

  wire             SEG7_Display_avalon_slave_0_allgrants;
  wire             SEG7_Display_avalon_slave_0_allow_new_arb_cycle;
  wire             SEG7_Display_avalon_slave_0_any_bursting_master_saved_grant;
  wire             SEG7_Display_avalon_slave_0_any_continuerequest;
  wire             SEG7_Display_avalon_slave_0_arb_counter_enable;
  reg     [  1: 0] SEG7_Display_avalon_slave_0_arb_share_counter;
  wire    [  1: 0] SEG7_Display_avalon_slave_0_arb_share_counter_next_value;
  wire    [  1: 0] SEG7_Display_avalon_slave_0_arb_share_set_values;
  wire             SEG7_Display_avalon_slave_0_beginbursttransfer_internal;
  wire             SEG7_Display_avalon_slave_0_begins_xfer;
  wire             SEG7_Display_avalon_slave_0_end_xfer;
  wire             SEG7_Display_avalon_slave_0_firsttransfer;
  wire             SEG7_Display_avalon_slave_0_grant_vector;
  wire             SEG7_Display_avalon_slave_0_in_a_read_cycle;
  wire             SEG7_Display_avalon_slave_0_in_a_write_cycle;
  wire             SEG7_Display_avalon_slave_0_master_qreq_vector;
  wire             SEG7_Display_avalon_slave_0_non_bursting_master_requests;
  reg              SEG7_Display_avalon_slave_0_reg_firsttransfer;
  wire             SEG7_Display_avalon_slave_0_reset_n;
  reg              SEG7_Display_avalon_slave_0_slavearbiterlockenable;
  wire             SEG7_Display_avalon_slave_0_slavearbiterlockenable2;
  wire             SEG7_Display_avalon_slave_0_unreg_firsttransfer;
  wire             SEG7_Display_avalon_slave_0_waits_for_read;
  wire             SEG7_Display_avalon_slave_0_waits_for_write;
  wire             SEG7_Display_avalon_slave_0_write;
  wire    [ 31: 0] SEG7_Display_avalon_slave_0_writedata;
  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_requests_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_saved_grant_SEG7_Display_avalon_slave_0;
  reg              d1_SEG7_Display_avalon_slave_0_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_SEG7_Display_avalon_slave_0;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 23: 0] shifted_address_to_SEG7_Display_avalon_slave_0_from_cpu_0_data_master;
  wire             wait_for_SEG7_Display_avalon_slave_0_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~SEG7_Display_avalon_slave_0_end_xfer;
    end


  assign SEG7_Display_avalon_slave_0_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0));
  assign cpu_0_data_master_requests_SEG7_Display_avalon_slave_0 = (({cpu_0_data_master_address_to_slave[23 : 2] , 2'b0} == 24'h901058) & (cpu_0_data_master_read | cpu_0_data_master_write)) & cpu_0_data_master_write;
  //SEG7_Display_avalon_slave_0_arb_share_counter set values, which is an e_mux
  assign SEG7_Display_avalon_slave_0_arb_share_set_values = 1;

  //SEG7_Display_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  assign SEG7_Display_avalon_slave_0_non_bursting_master_requests = cpu_0_data_master_requests_SEG7_Display_avalon_slave_0;

  //SEG7_Display_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  assign SEG7_Display_avalon_slave_0_any_bursting_master_saved_grant = 0;

  //SEG7_Display_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  assign SEG7_Display_avalon_slave_0_arb_share_counter_next_value = SEG7_Display_avalon_slave_0_firsttransfer ? (SEG7_Display_avalon_slave_0_arb_share_set_values - 1) : |SEG7_Display_avalon_slave_0_arb_share_counter ? (SEG7_Display_avalon_slave_0_arb_share_counter - 1) : 0;

  //SEG7_Display_avalon_slave_0_allgrants all slave grants, which is an e_mux
  assign SEG7_Display_avalon_slave_0_allgrants = |SEG7_Display_avalon_slave_0_grant_vector;

  //SEG7_Display_avalon_slave_0_end_xfer assignment, which is an e_assign
  assign SEG7_Display_avalon_slave_0_end_xfer = ~(SEG7_Display_avalon_slave_0_waits_for_read | SEG7_Display_avalon_slave_0_waits_for_write);

  //end_xfer_arb_share_counter_term_SEG7_Display_avalon_slave_0 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_SEG7_Display_avalon_slave_0 = SEG7_Display_avalon_slave_0_end_xfer & (~SEG7_Display_avalon_slave_0_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //SEG7_Display_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  assign SEG7_Display_avalon_slave_0_arb_counter_enable = (end_xfer_arb_share_counter_term_SEG7_Display_avalon_slave_0 & SEG7_Display_avalon_slave_0_allgrants) | (end_xfer_arb_share_counter_term_SEG7_Display_avalon_slave_0 & ~SEG7_Display_avalon_slave_0_non_bursting_master_requests);

  //SEG7_Display_avalon_slave_0_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SEG7_Display_avalon_slave_0_arb_share_counter <= 0;
      else if (SEG7_Display_avalon_slave_0_arb_counter_enable)
          SEG7_Display_avalon_slave_0_arb_share_counter <= SEG7_Display_avalon_slave_0_arb_share_counter_next_value;
    end


  //SEG7_Display_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SEG7_Display_avalon_slave_0_slavearbiterlockenable <= 0;
      else if ((|SEG7_Display_avalon_slave_0_master_qreq_vector & end_xfer_arb_share_counter_term_SEG7_Display_avalon_slave_0) | (end_xfer_arb_share_counter_term_SEG7_Display_avalon_slave_0 & ~SEG7_Display_avalon_slave_0_non_bursting_master_requests))
          SEG7_Display_avalon_slave_0_slavearbiterlockenable <= |SEG7_Display_avalon_slave_0_arb_share_counter_next_value;
    end


  //cpu_0/data_master SEG7_Display/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = SEG7_Display_avalon_slave_0_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //SEG7_Display_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign SEG7_Display_avalon_slave_0_slavearbiterlockenable2 = |SEG7_Display_avalon_slave_0_arb_share_counter_next_value;

  //cpu_0/data_master SEG7_Display/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = SEG7_Display_avalon_slave_0_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //SEG7_Display_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_assign
  assign SEG7_Display_avalon_slave_0_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0 = cpu_0_data_master_requests_SEG7_Display_avalon_slave_0;
  //SEG7_Display_avalon_slave_0_writedata mux, which is an e_mux
  assign SEG7_Display_avalon_slave_0_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_SEG7_Display_avalon_slave_0 = cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0;

  //cpu_0/data_master saved-grant SEG7_Display/avalon_slave_0, which is an e_assign
  assign cpu_0_data_master_saved_grant_SEG7_Display_avalon_slave_0 = cpu_0_data_master_requests_SEG7_Display_avalon_slave_0;

  //allow new arb cycle for SEG7_Display/avalon_slave_0, which is an e_assign
  assign SEG7_Display_avalon_slave_0_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign SEG7_Display_avalon_slave_0_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign SEG7_Display_avalon_slave_0_master_qreq_vector = 1;

  //SEG7_Display_avalon_slave_0_reset_n assignment, which is an e_assign
  assign SEG7_Display_avalon_slave_0_reset_n = reset_n;

  //SEG7_Display_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  assign SEG7_Display_avalon_slave_0_firsttransfer = SEG7_Display_avalon_slave_0_begins_xfer ? SEG7_Display_avalon_slave_0_unreg_firsttransfer : SEG7_Display_avalon_slave_0_reg_firsttransfer;

  //SEG7_Display_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  assign SEG7_Display_avalon_slave_0_unreg_firsttransfer = ~(SEG7_Display_avalon_slave_0_slavearbiterlockenable & SEG7_Display_avalon_slave_0_any_continuerequest);

  //SEG7_Display_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          SEG7_Display_avalon_slave_0_reg_firsttransfer <= 1'b1;
      else if (SEG7_Display_avalon_slave_0_begins_xfer)
          SEG7_Display_avalon_slave_0_reg_firsttransfer <= SEG7_Display_avalon_slave_0_unreg_firsttransfer;
    end


  //SEG7_Display_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign SEG7_Display_avalon_slave_0_beginbursttransfer_internal = SEG7_Display_avalon_slave_0_begins_xfer;

  //SEG7_Display_avalon_slave_0_write assignment, which is an e_mux
  assign SEG7_Display_avalon_slave_0_write = cpu_0_data_master_granted_SEG7_Display_avalon_slave_0 & cpu_0_data_master_write;

  assign shifted_address_to_SEG7_Display_avalon_slave_0_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //d1_SEG7_Display_avalon_slave_0_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_SEG7_Display_avalon_slave_0_end_xfer <= 1;
      else if (1)
          d1_SEG7_Display_avalon_slave_0_end_xfer <= SEG7_Display_avalon_slave_0_end_xfer;
    end


  //SEG7_Display_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  assign SEG7_Display_avalon_slave_0_waits_for_read = SEG7_Display_avalon_slave_0_in_a_read_cycle & SEG7_Display_avalon_slave_0_begins_xfer;

  //SEG7_Display_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  assign SEG7_Display_avalon_slave_0_in_a_read_cycle = cpu_0_data_master_granted_SEG7_Display_avalon_slave_0 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = SEG7_Display_avalon_slave_0_in_a_read_cycle;

  //SEG7_Display_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  assign SEG7_Display_avalon_slave_0_waits_for_write = SEG7_Display_avalon_slave_0_in_a_write_cycle & SEG7_Display_avalon_slave_0_begins_xfer;

  //SEG7_Display_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  assign SEG7_Display_avalon_slave_0_in_a_write_cycle = cpu_0_data_master_granted_SEG7_Display_avalon_slave_0 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = SEG7_Display_avalon_slave_0_in_a_write_cycle;

  assign wait_for_SEG7_Display_avalon_slave_0_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //SEG7_Display/avalon_slave_0 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module button_pio_s1_arbitrator (
                                  // inputs:
                                   button_pio_s1_irq,
                                   button_pio_s1_readdata,
                                   clk,
                                   cpu_0_data_master_address_to_slave,
                                   cpu_0_data_master_read,
                                   cpu_0_data_master_waitrequest,
                                   cpu_0_data_master_write,
                                   cpu_0_data_master_writedata,
                                   reset_n,

                                  // outputs:
                                   button_pio_s1_address,
                                   button_pio_s1_chipselect,
                                   button_pio_s1_irq_from_sa,
                                   button_pio_s1_readdata_from_sa,
                                   button_pio_s1_reset_n,
                                   button_pio_s1_write_n,
                                   button_pio_s1_writedata,
                                   cpu_0_data_master_granted_button_pio_s1,
                                   cpu_0_data_master_qualified_request_button_pio_s1,
                                   cpu_0_data_master_read_data_valid_button_pio_s1,
                                   cpu_0_data_master_requests_button_pio_s1,
                                   d1_button_pio_s1_end_xfer
                                )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [  1: 0] button_pio_s1_address;
  output           button_pio_s1_chipselect;
  output           button_pio_s1_irq_from_sa;
  output  [  3: 0] button_pio_s1_readdata_from_sa;
  output           button_pio_s1_reset_n;
  output           button_pio_s1_write_n;
  output  [  3: 0] button_pio_s1_writedata;
  output           cpu_0_data_master_granted_button_pio_s1;
  output           cpu_0_data_master_qualified_request_button_pio_s1;
  output           cpu_0_data_master_read_data_valid_button_pio_s1;
  output           cpu_0_data_master_requests_button_pio_s1;
  output           d1_button_pio_s1_end_xfer;
  input            button_pio_s1_irq;
  input   [  3: 0] button_pio_s1_readdata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            reset_n;

  wire    [  1: 0] button_pio_s1_address;
  wire             button_pio_s1_allgrants;
  wire             button_pio_s1_allow_new_arb_cycle;
  wire             button_pio_s1_any_bursting_master_saved_grant;
  wire             button_pio_s1_any_continuerequest;
  wire             button_pio_s1_arb_counter_enable;
  reg     [  1: 0] button_pio_s1_arb_share_counter;
  wire    [  1: 0] button_pio_s1_arb_share_counter_next_value;
  wire    [  1: 0] button_pio_s1_arb_share_set_values;
  wire             button_pio_s1_beginbursttransfer_internal;
  wire             button_pio_s1_begins_xfer;
  wire             button_pio_s1_chipselect;
  wire             button_pio_s1_end_xfer;
  wire             button_pio_s1_firsttransfer;
  wire             button_pio_s1_grant_vector;
  wire             button_pio_s1_in_a_read_cycle;
  wire             button_pio_s1_in_a_write_cycle;
  wire             button_pio_s1_irq_from_sa;
  wire             button_pio_s1_master_qreq_vector;
  wire             button_pio_s1_non_bursting_master_requests;
  wire    [  3: 0] button_pio_s1_readdata_from_sa;
  reg              button_pio_s1_reg_firsttransfer;
  wire             button_pio_s1_reset_n;
  reg              button_pio_s1_slavearbiterlockenable;
  wire             button_pio_s1_slavearbiterlockenable2;
  wire             button_pio_s1_unreg_firsttransfer;
  wire             button_pio_s1_waits_for_read;
  wire             button_pio_s1_waits_for_write;
  wire             button_pio_s1_write_n;
  wire    [  3: 0] button_pio_s1_writedata;
  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_button_pio_s1;
  wire             cpu_0_data_master_qualified_request_button_pio_s1;
  wire             cpu_0_data_master_read_data_valid_button_pio_s1;
  wire             cpu_0_data_master_requests_button_pio_s1;
  wire             cpu_0_data_master_saved_grant_button_pio_s1;
  reg              d1_button_pio_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_button_pio_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 23: 0] shifted_address_to_button_pio_s1_from_cpu_0_data_master;
  wire             wait_for_button_pio_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~button_pio_s1_end_xfer;
    end


  assign button_pio_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_button_pio_s1));
  //assign button_pio_s1_readdata_from_sa = button_pio_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign button_pio_s1_readdata_from_sa = button_pio_s1_readdata;

  assign cpu_0_data_master_requests_button_pio_s1 = ({cpu_0_data_master_address_to_slave[23 : 4] , 4'b0} == 24'h901000) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //button_pio_s1_arb_share_counter set values, which is an e_mux
  assign button_pio_s1_arb_share_set_values = 1;

  //button_pio_s1_non_bursting_master_requests mux, which is an e_mux
  assign button_pio_s1_non_bursting_master_requests = cpu_0_data_master_requests_button_pio_s1;

  //button_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign button_pio_s1_any_bursting_master_saved_grant = 0;

  //button_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign button_pio_s1_arb_share_counter_next_value = button_pio_s1_firsttransfer ? (button_pio_s1_arb_share_set_values - 1) : |button_pio_s1_arb_share_counter ? (button_pio_s1_arb_share_counter - 1) : 0;

  //button_pio_s1_allgrants all slave grants, which is an e_mux
  assign button_pio_s1_allgrants = |button_pio_s1_grant_vector;

  //button_pio_s1_end_xfer assignment, which is an e_assign
  assign button_pio_s1_end_xfer = ~(button_pio_s1_waits_for_read | button_pio_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_button_pio_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_button_pio_s1 = button_pio_s1_end_xfer & (~button_pio_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //button_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign button_pio_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_button_pio_s1 & button_pio_s1_allgrants) | (end_xfer_arb_share_counter_term_button_pio_s1 & ~button_pio_s1_non_bursting_master_requests);

  //button_pio_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          button_pio_s1_arb_share_counter <= 0;
      else if (button_pio_s1_arb_counter_enable)
          button_pio_s1_arb_share_counter <= button_pio_s1_arb_share_counter_next_value;
    end


  //button_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          button_pio_s1_slavearbiterlockenable <= 0;
      else if ((|button_pio_s1_master_qreq_vector & end_xfer_arb_share_counter_term_button_pio_s1) | (end_xfer_arb_share_counter_term_button_pio_s1 & ~button_pio_s1_non_bursting_master_requests))
          button_pio_s1_slavearbiterlockenable <= |button_pio_s1_arb_share_counter_next_value;
    end


  //cpu_0/data_master button_pio/s1 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = button_pio_s1_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //button_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign button_pio_s1_slavearbiterlockenable2 = |button_pio_s1_arb_share_counter_next_value;

  //cpu_0/data_master button_pio/s1 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = button_pio_s1_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //button_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign button_pio_s1_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_button_pio_s1 = cpu_0_data_master_requests_button_pio_s1 & ~(((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //button_pio_s1_writedata mux, which is an e_mux
  assign button_pio_s1_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_button_pio_s1 = cpu_0_data_master_qualified_request_button_pio_s1;

  //cpu_0/data_master saved-grant button_pio/s1, which is an e_assign
  assign cpu_0_data_master_saved_grant_button_pio_s1 = cpu_0_data_master_requests_button_pio_s1;

  //allow new arb cycle for button_pio/s1, which is an e_assign
  assign button_pio_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign button_pio_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign button_pio_s1_master_qreq_vector = 1;

  //button_pio_s1_reset_n assignment, which is an e_assign
  assign button_pio_s1_reset_n = reset_n;

  assign button_pio_s1_chipselect = cpu_0_data_master_granted_button_pio_s1;
  //button_pio_s1_firsttransfer first transaction, which is an e_assign
  assign button_pio_s1_firsttransfer = button_pio_s1_begins_xfer ? button_pio_s1_unreg_firsttransfer : button_pio_s1_reg_firsttransfer;

  //button_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign button_pio_s1_unreg_firsttransfer = ~(button_pio_s1_slavearbiterlockenable & button_pio_s1_any_continuerequest);

  //button_pio_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          button_pio_s1_reg_firsttransfer <= 1'b1;
      else if (button_pio_s1_begins_xfer)
          button_pio_s1_reg_firsttransfer <= button_pio_s1_unreg_firsttransfer;
    end


  //button_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign button_pio_s1_beginbursttransfer_internal = button_pio_s1_begins_xfer;

  //~button_pio_s1_write_n assignment, which is an e_mux
  assign button_pio_s1_write_n = ~(cpu_0_data_master_granted_button_pio_s1 & cpu_0_data_master_write);

  assign shifted_address_to_button_pio_s1_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //button_pio_s1_address mux, which is an e_mux
  assign button_pio_s1_address = shifted_address_to_button_pio_s1_from_cpu_0_data_master >> 2;

  //d1_button_pio_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_button_pio_s1_end_xfer <= 1;
      else if (1)
          d1_button_pio_s1_end_xfer <= button_pio_s1_end_xfer;
    end


  //button_pio_s1_waits_for_read in a cycle, which is an e_mux
  assign button_pio_s1_waits_for_read = button_pio_s1_in_a_read_cycle & button_pio_s1_begins_xfer;

  //button_pio_s1_in_a_read_cycle assignment, which is an e_assign
  assign button_pio_s1_in_a_read_cycle = cpu_0_data_master_granted_button_pio_s1 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = button_pio_s1_in_a_read_cycle;

  //button_pio_s1_waits_for_write in a cycle, which is an e_mux
  assign button_pio_s1_waits_for_write = button_pio_s1_in_a_write_cycle & 0;

  //button_pio_s1_in_a_write_cycle assignment, which is an e_assign
  assign button_pio_s1_in_a_write_cycle = cpu_0_data_master_granted_button_pio_s1 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = button_pio_s1_in_a_write_cycle;

  assign wait_for_button_pio_s1_counter = 0;
  //assign button_pio_s1_irq_from_sa = button_pio_s1_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign button_pio_s1_irq_from_sa = button_pio_s1_irq;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //button_pio/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_0_jtag_debug_module_arbitrator (
                                            // inputs:
                                             clk,
                                             cpu_0_data_master_address_to_slave,
                                             cpu_0_data_master_byteenable,
                                             cpu_0_data_master_debugaccess,
                                             cpu_0_data_master_read,
                                             cpu_0_data_master_waitrequest,
                                             cpu_0_data_master_write,
                                             cpu_0_data_master_writedata,
                                             cpu_0_instruction_master_address_to_slave,
                                             cpu_0_instruction_master_latency_counter,
                                             cpu_0_instruction_master_read,
                                             cpu_0_jtag_debug_module_readdata,
                                             cpu_0_jtag_debug_module_resetrequest,
                                             reset_n,

                                            // outputs:
                                             cpu_0_data_master_granted_cpu_0_jtag_debug_module,
                                             cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module,
                                             cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module,
                                             cpu_0_data_master_requests_cpu_0_jtag_debug_module,
                                             cpu_0_instruction_master_granted_cpu_0_jtag_debug_module,
                                             cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module,
                                             cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module,
                                             cpu_0_instruction_master_requests_cpu_0_jtag_debug_module,
                                             cpu_0_jtag_debug_module_address,
                                             cpu_0_jtag_debug_module_begintransfer,
                                             cpu_0_jtag_debug_module_byteenable,
                                             cpu_0_jtag_debug_module_chipselect,
                                             cpu_0_jtag_debug_module_debugaccess,
                                             cpu_0_jtag_debug_module_readdata_from_sa,
                                             cpu_0_jtag_debug_module_reset,
                                             cpu_0_jtag_debug_module_reset_n,
                                             cpu_0_jtag_debug_module_resetrequest_from_sa,
                                             cpu_0_jtag_debug_module_write,
                                             cpu_0_jtag_debug_module_writedata,
                                             d1_cpu_0_jtag_debug_module_end_xfer
                                          )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           cpu_0_data_master_granted_cpu_0_jtag_debug_module;
  output           cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module;
  output           cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module;
  output           cpu_0_data_master_requests_cpu_0_jtag_debug_module;
  output           cpu_0_instruction_master_granted_cpu_0_jtag_debug_module;
  output           cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module;
  output           cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module;
  output           cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  output  [  8: 0] cpu_0_jtag_debug_module_address;
  output           cpu_0_jtag_debug_module_begintransfer;
  output  [  3: 0] cpu_0_jtag_debug_module_byteenable;
  output           cpu_0_jtag_debug_module_chipselect;
  output           cpu_0_jtag_debug_module_debugaccess;
  output  [ 31: 0] cpu_0_jtag_debug_module_readdata_from_sa;
  output           cpu_0_jtag_debug_module_reset;
  output           cpu_0_jtag_debug_module_reset_n;
  output           cpu_0_jtag_debug_module_resetrequest_from_sa;
  output           cpu_0_jtag_debug_module_write;
  output  [ 31: 0] cpu_0_jtag_debug_module_writedata;
  output           d1_cpu_0_jtag_debug_module_end_xfer;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input   [  3: 0] cpu_0_data_master_byteenable;
  input            cpu_0_data_master_debugaccess;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input   [ 23: 0] cpu_0_instruction_master_address_to_slave;
  input            cpu_0_instruction_master_latency_counter;
  input            cpu_0_instruction_master_read;
  input   [ 31: 0] cpu_0_jtag_debug_module_readdata;
  input            cpu_0_jtag_debug_module_resetrequest;
  input            reset_n;

  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_requests_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_arbiterlock;
  wire             cpu_0_instruction_master_arbiterlock2;
  wire             cpu_0_instruction_master_continuerequest;
  wire             cpu_0_instruction_master_granted_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module;
  wire    [  8: 0] cpu_0_jtag_debug_module_address;
  wire             cpu_0_jtag_debug_module_allgrants;
  wire             cpu_0_jtag_debug_module_allow_new_arb_cycle;
  wire             cpu_0_jtag_debug_module_any_bursting_master_saved_grant;
  wire             cpu_0_jtag_debug_module_any_continuerequest;
  reg     [  1: 0] cpu_0_jtag_debug_module_arb_addend;
  wire             cpu_0_jtag_debug_module_arb_counter_enable;
  reg     [  1: 0] cpu_0_jtag_debug_module_arb_share_counter;
  wire    [  1: 0] cpu_0_jtag_debug_module_arb_share_counter_next_value;
  wire    [  1: 0] cpu_0_jtag_debug_module_arb_share_set_values;
  wire    [  1: 0] cpu_0_jtag_debug_module_arb_winner;
  wire             cpu_0_jtag_debug_module_arbitration_holdoff_internal;
  wire             cpu_0_jtag_debug_module_beginbursttransfer_internal;
  wire             cpu_0_jtag_debug_module_begins_xfer;
  wire             cpu_0_jtag_debug_module_begintransfer;
  wire    [  3: 0] cpu_0_jtag_debug_module_byteenable;
  wire             cpu_0_jtag_debug_module_chipselect;
  wire    [  3: 0] cpu_0_jtag_debug_module_chosen_master_double_vector;
  wire    [  1: 0] cpu_0_jtag_debug_module_chosen_master_rot_left;
  wire             cpu_0_jtag_debug_module_debugaccess;
  wire             cpu_0_jtag_debug_module_end_xfer;
  wire             cpu_0_jtag_debug_module_firsttransfer;
  wire    [  1: 0] cpu_0_jtag_debug_module_grant_vector;
  wire             cpu_0_jtag_debug_module_in_a_read_cycle;
  wire             cpu_0_jtag_debug_module_in_a_write_cycle;
  wire    [  1: 0] cpu_0_jtag_debug_module_master_qreq_vector;
  wire             cpu_0_jtag_debug_module_non_bursting_master_requests;
  wire    [ 31: 0] cpu_0_jtag_debug_module_readdata_from_sa;
  reg              cpu_0_jtag_debug_module_reg_firsttransfer;
  wire             cpu_0_jtag_debug_module_reset;
  wire             cpu_0_jtag_debug_module_reset_n;
  wire             cpu_0_jtag_debug_module_resetrequest_from_sa;
  reg     [  1: 0] cpu_0_jtag_debug_module_saved_chosen_master_vector;
  reg              cpu_0_jtag_debug_module_slavearbiterlockenable;
  wire             cpu_0_jtag_debug_module_slavearbiterlockenable2;
  wire             cpu_0_jtag_debug_module_unreg_firsttransfer;
  wire             cpu_0_jtag_debug_module_waits_for_read;
  wire             cpu_0_jtag_debug_module_waits_for_write;
  wire             cpu_0_jtag_debug_module_write;
  wire    [ 31: 0] cpu_0_jtag_debug_module_writedata;
  reg              d1_cpu_0_jtag_debug_module_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  reg              last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module;
  reg              last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module;
  wire    [ 23: 0] shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_data_master;
  wire    [ 23: 0] shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_instruction_master;
  wire             wait_for_cpu_0_jtag_debug_module_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~cpu_0_jtag_debug_module_end_xfer;
    end


  assign cpu_0_jtag_debug_module_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module | cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module));
  //assign cpu_0_jtag_debug_module_readdata_from_sa = cpu_0_jtag_debug_module_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign cpu_0_jtag_debug_module_readdata_from_sa = cpu_0_jtag_debug_module_readdata;

  assign cpu_0_data_master_requests_cpu_0_jtag_debug_module = ({cpu_0_data_master_address_to_slave[23 : 11] , 11'b0} == 24'h900800) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //cpu_0_jtag_debug_module_arb_share_counter set values, which is an e_mux
  assign cpu_0_jtag_debug_module_arb_share_set_values = 1;

  //cpu_0_jtag_debug_module_non_bursting_master_requests mux, which is an e_mux
  assign cpu_0_jtag_debug_module_non_bursting_master_requests = cpu_0_data_master_requests_cpu_0_jtag_debug_module |
    cpu_0_instruction_master_requests_cpu_0_jtag_debug_module |
    cpu_0_data_master_requests_cpu_0_jtag_debug_module |
    cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;

  //cpu_0_jtag_debug_module_any_bursting_master_saved_grant mux, which is an e_mux
  assign cpu_0_jtag_debug_module_any_bursting_master_saved_grant = 0;

  //cpu_0_jtag_debug_module_arb_share_counter_next_value assignment, which is an e_assign
  assign cpu_0_jtag_debug_module_arb_share_counter_next_value = cpu_0_jtag_debug_module_firsttransfer ? (cpu_0_jtag_debug_module_arb_share_set_values - 1) : |cpu_0_jtag_debug_module_arb_share_counter ? (cpu_0_jtag_debug_module_arb_share_counter - 1) : 0;

  //cpu_0_jtag_debug_module_allgrants all slave grants, which is an e_mux
  assign cpu_0_jtag_debug_module_allgrants = |cpu_0_jtag_debug_module_grant_vector |
    |cpu_0_jtag_debug_module_grant_vector |
    |cpu_0_jtag_debug_module_grant_vector |
    |cpu_0_jtag_debug_module_grant_vector;

  //cpu_0_jtag_debug_module_end_xfer assignment, which is an e_assign
  assign cpu_0_jtag_debug_module_end_xfer = ~(cpu_0_jtag_debug_module_waits_for_read | cpu_0_jtag_debug_module_waits_for_write);

  //end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module = cpu_0_jtag_debug_module_end_xfer & (~cpu_0_jtag_debug_module_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //cpu_0_jtag_debug_module_arb_share_counter arbitration counter enable, which is an e_assign
  assign cpu_0_jtag_debug_module_arb_counter_enable = (end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module & cpu_0_jtag_debug_module_allgrants) | (end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module & ~cpu_0_jtag_debug_module_non_bursting_master_requests);

  //cpu_0_jtag_debug_module_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_jtag_debug_module_arb_share_counter <= 0;
      else if (cpu_0_jtag_debug_module_arb_counter_enable)
          cpu_0_jtag_debug_module_arb_share_counter <= cpu_0_jtag_debug_module_arb_share_counter_next_value;
    end


  //cpu_0_jtag_debug_module_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_jtag_debug_module_slavearbiterlockenable <= 0;
      else if ((|cpu_0_jtag_debug_module_master_qreq_vector & end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module) | (end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module & ~cpu_0_jtag_debug_module_non_bursting_master_requests))
          cpu_0_jtag_debug_module_slavearbiterlockenable <= |cpu_0_jtag_debug_module_arb_share_counter_next_value;
    end


  //cpu_0/data_master cpu_0/jtag_debug_module arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = cpu_0_jtag_debug_module_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //cpu_0_jtag_debug_module_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign cpu_0_jtag_debug_module_slavearbiterlockenable2 = |cpu_0_jtag_debug_module_arb_share_counter_next_value;

  //cpu_0/data_master cpu_0/jtag_debug_module arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = cpu_0_jtag_debug_module_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //cpu_0/instruction_master cpu_0/jtag_debug_module arbiterlock, which is an e_assign
  assign cpu_0_instruction_master_arbiterlock = cpu_0_jtag_debug_module_slavearbiterlockenable & cpu_0_instruction_master_continuerequest;

  //cpu_0/instruction_master cpu_0/jtag_debug_module arbiterlock2, which is an e_assign
  assign cpu_0_instruction_master_arbiterlock2 = cpu_0_jtag_debug_module_slavearbiterlockenable2 & cpu_0_instruction_master_continuerequest;

  //cpu_0/instruction_master granted cpu_0/jtag_debug_module last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module <= 0;
      else if (1)
          last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module <= cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module ? 1 : (cpu_0_jtag_debug_module_arbitration_holdoff_internal | ~cpu_0_instruction_master_requests_cpu_0_jtag_debug_module) ? 0 : last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module;
    end


  //cpu_0_instruction_master_continuerequest continued request, which is an e_mux
  assign cpu_0_instruction_master_continuerequest = last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module & cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;

  //cpu_0_jtag_debug_module_any_continuerequest at least one master continues requesting, which is an e_mux
  assign cpu_0_jtag_debug_module_any_continuerequest = cpu_0_instruction_master_continuerequest |
    cpu_0_data_master_continuerequest;

  assign cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module = cpu_0_data_master_requests_cpu_0_jtag_debug_module & ~(((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write) | cpu_0_instruction_master_arbiterlock);
  //cpu_0_jtag_debug_module_writedata mux, which is an e_mux
  assign cpu_0_jtag_debug_module_writedata = cpu_0_data_master_writedata;

  //mux cpu_0_jtag_debug_module_debugaccess, which is an e_mux
  assign cpu_0_jtag_debug_module_debugaccess = cpu_0_data_master_debugaccess;

  assign cpu_0_instruction_master_requests_cpu_0_jtag_debug_module = (({cpu_0_instruction_master_address_to_slave[23 : 11] , 11'b0} == 24'h900800) & (cpu_0_instruction_master_read)) & cpu_0_instruction_master_read;
  //cpu_0/data_master granted cpu_0/jtag_debug_module last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module <= 0;
      else if (1)
          last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module <= cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module ? 1 : (cpu_0_jtag_debug_module_arbitration_holdoff_internal | ~cpu_0_data_master_requests_cpu_0_jtag_debug_module) ? 0 : last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module;
    end


  //cpu_0_data_master_continuerequest continued request, which is an e_mux
  assign cpu_0_data_master_continuerequest = last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module & cpu_0_data_master_requests_cpu_0_jtag_debug_module;

  assign cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module = cpu_0_instruction_master_requests_cpu_0_jtag_debug_module & ~((cpu_0_instruction_master_read & ((cpu_0_instruction_master_latency_counter != 0))) | cpu_0_data_master_arbiterlock);
  //local readdatavalid cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module, which is an e_mux
  assign cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module = cpu_0_instruction_master_granted_cpu_0_jtag_debug_module & cpu_0_instruction_master_read & ~cpu_0_jtag_debug_module_waits_for_read;

  //allow new arb cycle for cpu_0/jtag_debug_module, which is an e_assign
  assign cpu_0_jtag_debug_module_allow_new_arb_cycle = ~cpu_0_data_master_arbiterlock & ~cpu_0_instruction_master_arbiterlock;

  //cpu_0/instruction_master assignment into master qualified-requests vector for cpu_0/jtag_debug_module, which is an e_assign
  assign cpu_0_jtag_debug_module_master_qreq_vector[0] = cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module;

  //cpu_0/instruction_master grant cpu_0/jtag_debug_module, which is an e_assign
  assign cpu_0_instruction_master_granted_cpu_0_jtag_debug_module = cpu_0_jtag_debug_module_grant_vector[0];

  //cpu_0/instruction_master saved-grant cpu_0/jtag_debug_module, which is an e_assign
  assign cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module = cpu_0_jtag_debug_module_arb_winner[0] && cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;

  //cpu_0/data_master assignment into master qualified-requests vector for cpu_0/jtag_debug_module, which is an e_assign
  assign cpu_0_jtag_debug_module_master_qreq_vector[1] = cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module;

  //cpu_0/data_master grant cpu_0/jtag_debug_module, which is an e_assign
  assign cpu_0_data_master_granted_cpu_0_jtag_debug_module = cpu_0_jtag_debug_module_grant_vector[1];

  //cpu_0/data_master saved-grant cpu_0/jtag_debug_module, which is an e_assign
  assign cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module = cpu_0_jtag_debug_module_arb_winner[1] && cpu_0_data_master_requests_cpu_0_jtag_debug_module;

  //cpu_0/jtag_debug_module chosen-master double-vector, which is an e_assign
  assign cpu_0_jtag_debug_module_chosen_master_double_vector = {cpu_0_jtag_debug_module_master_qreq_vector, cpu_0_jtag_debug_module_master_qreq_vector} & ({~cpu_0_jtag_debug_module_master_qreq_vector, ~cpu_0_jtag_debug_module_master_qreq_vector} + cpu_0_jtag_debug_module_arb_addend);

  //stable onehot encoding of arb winner
  assign cpu_0_jtag_debug_module_arb_winner = (cpu_0_jtag_debug_module_allow_new_arb_cycle & | cpu_0_jtag_debug_module_grant_vector) ? cpu_0_jtag_debug_module_grant_vector : cpu_0_jtag_debug_module_saved_chosen_master_vector;

  //saved cpu_0_jtag_debug_module_grant_vector, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_jtag_debug_module_saved_chosen_master_vector <= 0;
      else if (cpu_0_jtag_debug_module_allow_new_arb_cycle)
          cpu_0_jtag_debug_module_saved_chosen_master_vector <= |cpu_0_jtag_debug_module_grant_vector ? cpu_0_jtag_debug_module_grant_vector : cpu_0_jtag_debug_module_saved_chosen_master_vector;
    end


  //onehot encoding of chosen master
  assign cpu_0_jtag_debug_module_grant_vector = {(cpu_0_jtag_debug_module_chosen_master_double_vector[1] | cpu_0_jtag_debug_module_chosen_master_double_vector[3]),
    (cpu_0_jtag_debug_module_chosen_master_double_vector[0] | cpu_0_jtag_debug_module_chosen_master_double_vector[2])};

  //cpu_0/jtag_debug_module chosen master rotated left, which is an e_assign
  assign cpu_0_jtag_debug_module_chosen_master_rot_left = (cpu_0_jtag_debug_module_arb_winner << 1) ? (cpu_0_jtag_debug_module_arb_winner << 1) : 1;

  //cpu_0/jtag_debug_module's addend for next-master-grant
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_jtag_debug_module_arb_addend <= 1;
      else if (|cpu_0_jtag_debug_module_grant_vector)
          cpu_0_jtag_debug_module_arb_addend <= cpu_0_jtag_debug_module_end_xfer? cpu_0_jtag_debug_module_chosen_master_rot_left : cpu_0_jtag_debug_module_grant_vector;
    end


  assign cpu_0_jtag_debug_module_begintransfer = cpu_0_jtag_debug_module_begins_xfer;
  //assign lhs ~cpu_0_jtag_debug_module_reset of type reset_n to cpu_0_jtag_debug_module_reset_n, which is an e_assign
  assign cpu_0_jtag_debug_module_reset = ~cpu_0_jtag_debug_module_reset_n;

  //cpu_0_jtag_debug_module_reset_n assignment, which is an e_assign
  assign cpu_0_jtag_debug_module_reset_n = reset_n;

  //assign cpu_0_jtag_debug_module_resetrequest_from_sa = cpu_0_jtag_debug_module_resetrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign cpu_0_jtag_debug_module_resetrequest_from_sa = cpu_0_jtag_debug_module_resetrequest;

  assign cpu_0_jtag_debug_module_chipselect = cpu_0_data_master_granted_cpu_0_jtag_debug_module | cpu_0_instruction_master_granted_cpu_0_jtag_debug_module;
  //cpu_0_jtag_debug_module_firsttransfer first transaction, which is an e_assign
  assign cpu_0_jtag_debug_module_firsttransfer = cpu_0_jtag_debug_module_begins_xfer ? cpu_0_jtag_debug_module_unreg_firsttransfer : cpu_0_jtag_debug_module_reg_firsttransfer;

  //cpu_0_jtag_debug_module_unreg_firsttransfer first transaction, which is an e_assign
  assign cpu_0_jtag_debug_module_unreg_firsttransfer = ~(cpu_0_jtag_debug_module_slavearbiterlockenable & cpu_0_jtag_debug_module_any_continuerequest);

  //cpu_0_jtag_debug_module_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_jtag_debug_module_reg_firsttransfer <= 1'b1;
      else if (cpu_0_jtag_debug_module_begins_xfer)
          cpu_0_jtag_debug_module_reg_firsttransfer <= cpu_0_jtag_debug_module_unreg_firsttransfer;
    end


  //cpu_0_jtag_debug_module_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign cpu_0_jtag_debug_module_beginbursttransfer_internal = cpu_0_jtag_debug_module_begins_xfer;

  //cpu_0_jtag_debug_module_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  assign cpu_0_jtag_debug_module_arbitration_holdoff_internal = cpu_0_jtag_debug_module_begins_xfer & cpu_0_jtag_debug_module_firsttransfer;

  //cpu_0_jtag_debug_module_write assignment, which is an e_mux
  assign cpu_0_jtag_debug_module_write = cpu_0_data_master_granted_cpu_0_jtag_debug_module & cpu_0_data_master_write;

  assign shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //cpu_0_jtag_debug_module_address mux, which is an e_mux
  assign cpu_0_jtag_debug_module_address = (cpu_0_data_master_granted_cpu_0_jtag_debug_module)? (shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_data_master >> 2) :
    (shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_instruction_master >> 2);

  assign shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_instruction_master = cpu_0_instruction_master_address_to_slave;
  //d1_cpu_0_jtag_debug_module_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_cpu_0_jtag_debug_module_end_xfer <= 1;
      else if (1)
          d1_cpu_0_jtag_debug_module_end_xfer <= cpu_0_jtag_debug_module_end_xfer;
    end


  //cpu_0_jtag_debug_module_waits_for_read in a cycle, which is an e_mux
  assign cpu_0_jtag_debug_module_waits_for_read = cpu_0_jtag_debug_module_in_a_read_cycle & cpu_0_jtag_debug_module_begins_xfer;

  //cpu_0_jtag_debug_module_in_a_read_cycle assignment, which is an e_assign
  assign cpu_0_jtag_debug_module_in_a_read_cycle = (cpu_0_data_master_granted_cpu_0_jtag_debug_module & cpu_0_data_master_read) | (cpu_0_instruction_master_granted_cpu_0_jtag_debug_module & cpu_0_instruction_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = cpu_0_jtag_debug_module_in_a_read_cycle;

  //cpu_0_jtag_debug_module_waits_for_write in a cycle, which is an e_mux
  assign cpu_0_jtag_debug_module_waits_for_write = cpu_0_jtag_debug_module_in_a_write_cycle & 0;

  //cpu_0_jtag_debug_module_in_a_write_cycle assignment, which is an e_assign
  assign cpu_0_jtag_debug_module_in_a_write_cycle = cpu_0_data_master_granted_cpu_0_jtag_debug_module & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = cpu_0_jtag_debug_module_in_a_write_cycle;

  assign wait_for_cpu_0_jtag_debug_module_counter = 0;
  //cpu_0_jtag_debug_module_byteenable byte enable port mux, which is an e_mux
  assign cpu_0_jtag_debug_module_byteenable = (cpu_0_data_master_granted_cpu_0_jtag_debug_module)? cpu_0_data_master_byteenable :
    -1;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //cpu_0/jtag_debug_module enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end


  //grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_0_data_master_granted_cpu_0_jtag_debug_module + cpu_0_instruction_master_granted_cpu_0_jtag_debug_module > 1)
        begin
          $write("%0d ns: > 1 of grant signals are active simultaneously", $time);
          $stop;
        end
    end


  //saved_grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module + cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module > 1)
        begin
          $write("%0d ns: > 1 of saved_grant signals are active simultaneously", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_0_data_master_arbitrator (
                                      // inputs:
                                       Audio_0_avalon_slave_0_readdata_from_sa,
                                       SD_CMD_s1_readdata_from_sa,
                                       SD_DAT_s1_readdata_from_sa,
                                       button_pio_s1_irq_from_sa,
                                       button_pio_s1_readdata_from_sa,
                                       clk,
                                       cpu_0_data_master_address,
                                       cpu_0_data_master_byteenable_sdram_s1,
                                       cpu_0_data_master_byteenable_sram_0_avalon_slave_0,
                                       cpu_0_data_master_debugaccess,
                                       cpu_0_data_master_granted_Audio_0_avalon_slave_0,
                                       cpu_0_data_master_granted_SD_CLK_s1,
                                       cpu_0_data_master_granted_SD_CMD_s1,
                                       cpu_0_data_master_granted_SD_DAT_s1,
                                       cpu_0_data_master_granted_SEG7_Display_avalon_slave_0,
                                       cpu_0_data_master_granted_button_pio_s1,
                                       cpu_0_data_master_granted_cpu_0_jtag_debug_module,
                                       cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave,
                                       cpu_0_data_master_granted_ps2_avalon_slave_0,
                                       cpu_0_data_master_granted_sdram_s1,
                                       cpu_0_data_master_granted_sram_0_avalon_slave_0,
                                       cpu_0_data_master_granted_vga_avalon_slave_0,
                                       cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0,
                                       cpu_0_data_master_qualified_request_SD_CLK_s1,
                                       cpu_0_data_master_qualified_request_SD_CMD_s1,
                                       cpu_0_data_master_qualified_request_SD_DAT_s1,
                                       cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0,
                                       cpu_0_data_master_qualified_request_button_pio_s1,
                                       cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module,
                                       cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave,
                                       cpu_0_data_master_qualified_request_ps2_avalon_slave_0,
                                       cpu_0_data_master_qualified_request_sdram_s1,
                                       cpu_0_data_master_qualified_request_sram_0_avalon_slave_0,
                                       cpu_0_data_master_qualified_request_vga_avalon_slave_0,
                                       cpu_0_data_master_read,
                                       cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0,
                                       cpu_0_data_master_read_data_valid_SD_CLK_s1,
                                       cpu_0_data_master_read_data_valid_SD_CMD_s1,
                                       cpu_0_data_master_read_data_valid_SD_DAT_s1,
                                       cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0,
                                       cpu_0_data_master_read_data_valid_button_pio_s1,
                                       cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module,
                                       cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave,
                                       cpu_0_data_master_read_data_valid_ps2_avalon_slave_0,
                                       cpu_0_data_master_read_data_valid_sdram_s1,
                                       cpu_0_data_master_read_data_valid_sdram_s1_shift_register,
                                       cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0,
                                       cpu_0_data_master_read_data_valid_vga_avalon_slave_0,
                                       cpu_0_data_master_requests_Audio_0_avalon_slave_0,
                                       cpu_0_data_master_requests_SD_CLK_s1,
                                       cpu_0_data_master_requests_SD_CMD_s1,
                                       cpu_0_data_master_requests_SD_DAT_s1,
                                       cpu_0_data_master_requests_SEG7_Display_avalon_slave_0,
                                       cpu_0_data_master_requests_button_pio_s1,
                                       cpu_0_data_master_requests_cpu_0_jtag_debug_module,
                                       cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave,
                                       cpu_0_data_master_requests_ps2_avalon_slave_0,
                                       cpu_0_data_master_requests_sdram_s1,
                                       cpu_0_data_master_requests_sram_0_avalon_slave_0,
                                       cpu_0_data_master_requests_vga_avalon_slave_0,
                                       cpu_0_data_master_write,
                                       cpu_0_data_master_writedata,
                                       cpu_0_jtag_debug_module_readdata_from_sa,
                                       d1_Audio_0_avalon_slave_0_end_xfer,
                                       d1_SD_CLK_s1_end_xfer,
                                       d1_SD_CMD_s1_end_xfer,
                                       d1_SD_DAT_s1_end_xfer,
                                       d1_SEG7_Display_avalon_slave_0_end_xfer,
                                       d1_button_pio_s1_end_xfer,
                                       d1_cpu_0_jtag_debug_module_end_xfer,
                                       d1_jtag_uart_0_avalon_jtag_slave_end_xfer,
                                       d1_ps2_avalon_slave_0_end_xfer,
                                       d1_sdram_s1_end_xfer,
                                       d1_sram_0_avalon_slave_0_end_xfer,
                                       d1_vga_avalon_slave_0_end_xfer,
                                       jtag_uart_0_avalon_jtag_slave_irq_from_sa,
                                       jtag_uart_0_avalon_jtag_slave_readdata_from_sa,
                                       jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa,
                                       ps2_avalon_slave_0_readdata_from_sa,
                                       ps2_avalon_slave_0_waitrequest_from_sa,
                                       reset_n,
                                       sdram_s1_readdata_from_sa,
                                       sdram_s1_waitrequest_from_sa,
                                       sram_0_avalon_slave_0_readdata_from_sa,
                                       sram_0_avalon_slave_0_wait_counter_eq_0,

                                      // outputs:
                                       cpu_0_data_master_address_to_slave,
                                       cpu_0_data_master_dbs_address,
                                       cpu_0_data_master_dbs_write_16,
                                       cpu_0_data_master_irq,
                                       cpu_0_data_master_no_byte_enables_and_last_term,
                                       cpu_0_data_master_readdata,
                                       cpu_0_data_master_waitrequest
                                    )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [ 23: 0] cpu_0_data_master_address_to_slave;
  output  [  1: 0] cpu_0_data_master_dbs_address;
  output  [ 15: 0] cpu_0_data_master_dbs_write_16;
  output  [ 31: 0] cpu_0_data_master_irq;
  output           cpu_0_data_master_no_byte_enables_and_last_term;
  output  [ 31: 0] cpu_0_data_master_readdata;
  output           cpu_0_data_master_waitrequest;
  input   [ 15: 0] Audio_0_avalon_slave_0_readdata_from_sa;
  input            SD_CMD_s1_readdata_from_sa;
  input            SD_DAT_s1_readdata_from_sa;
  input            button_pio_s1_irq_from_sa;
  input   [  3: 0] button_pio_s1_readdata_from_sa;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address;
  input   [  1: 0] cpu_0_data_master_byteenable_sdram_s1;
  input   [  1: 0] cpu_0_data_master_byteenable_sram_0_avalon_slave_0;
  input            cpu_0_data_master_debugaccess;
  input            cpu_0_data_master_granted_Audio_0_avalon_slave_0;
  input            cpu_0_data_master_granted_SD_CLK_s1;
  input            cpu_0_data_master_granted_SD_CMD_s1;
  input            cpu_0_data_master_granted_SD_DAT_s1;
  input            cpu_0_data_master_granted_SEG7_Display_avalon_slave_0;
  input            cpu_0_data_master_granted_button_pio_s1;
  input            cpu_0_data_master_granted_cpu_0_jtag_debug_module;
  input            cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave;
  input            cpu_0_data_master_granted_ps2_avalon_slave_0;
  input            cpu_0_data_master_granted_sdram_s1;
  input            cpu_0_data_master_granted_sram_0_avalon_slave_0;
  input            cpu_0_data_master_granted_vga_avalon_slave_0;
  input            cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0;
  input            cpu_0_data_master_qualified_request_SD_CLK_s1;
  input            cpu_0_data_master_qualified_request_SD_CMD_s1;
  input            cpu_0_data_master_qualified_request_SD_DAT_s1;
  input            cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0;
  input            cpu_0_data_master_qualified_request_button_pio_s1;
  input            cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module;
  input            cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave;
  input            cpu_0_data_master_qualified_request_ps2_avalon_slave_0;
  input            cpu_0_data_master_qualified_request_sdram_s1;
  input            cpu_0_data_master_qualified_request_sram_0_avalon_slave_0;
  input            cpu_0_data_master_qualified_request_vga_avalon_slave_0;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0;
  input            cpu_0_data_master_read_data_valid_SD_CLK_s1;
  input            cpu_0_data_master_read_data_valid_SD_CMD_s1;
  input            cpu_0_data_master_read_data_valid_SD_DAT_s1;
  input            cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0;
  input            cpu_0_data_master_read_data_valid_button_pio_s1;
  input            cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module;
  input            cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave;
  input            cpu_0_data_master_read_data_valid_ps2_avalon_slave_0;
  input            cpu_0_data_master_read_data_valid_sdram_s1;
  input            cpu_0_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0;
  input            cpu_0_data_master_read_data_valid_vga_avalon_slave_0;
  input            cpu_0_data_master_requests_Audio_0_avalon_slave_0;
  input            cpu_0_data_master_requests_SD_CLK_s1;
  input            cpu_0_data_master_requests_SD_CMD_s1;
  input            cpu_0_data_master_requests_SD_DAT_s1;
  input            cpu_0_data_master_requests_SEG7_Display_avalon_slave_0;
  input            cpu_0_data_master_requests_button_pio_s1;
  input            cpu_0_data_master_requests_cpu_0_jtag_debug_module;
  input            cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave;
  input            cpu_0_data_master_requests_ps2_avalon_slave_0;
  input            cpu_0_data_master_requests_sdram_s1;
  input            cpu_0_data_master_requests_sram_0_avalon_slave_0;
  input            cpu_0_data_master_requests_vga_avalon_slave_0;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input   [ 31: 0] cpu_0_jtag_debug_module_readdata_from_sa;
  input            d1_Audio_0_avalon_slave_0_end_xfer;
  input            d1_SD_CLK_s1_end_xfer;
  input            d1_SD_CMD_s1_end_xfer;
  input            d1_SD_DAT_s1_end_xfer;
  input            d1_SEG7_Display_avalon_slave_0_end_xfer;
  input            d1_button_pio_s1_end_xfer;
  input            d1_cpu_0_jtag_debug_module_end_xfer;
  input            d1_jtag_uart_0_avalon_jtag_slave_end_xfer;
  input            d1_ps2_avalon_slave_0_end_xfer;
  input            d1_sdram_s1_end_xfer;
  input            d1_sram_0_avalon_slave_0_end_xfer;
  input            d1_vga_avalon_slave_0_end_xfer;
  input            jtag_uart_0_avalon_jtag_slave_irq_from_sa;
  input   [ 31: 0] jtag_uart_0_avalon_jtag_slave_readdata_from_sa;
  input            jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;
  input   [ 31: 0] ps2_avalon_slave_0_readdata_from_sa;
  input            ps2_avalon_slave_0_waitrequest_from_sa;
  input            reset_n;
  input   [ 15: 0] sdram_s1_readdata_from_sa;
  input            sdram_s1_waitrequest_from_sa;
  input   [ 15: 0] sram_0_avalon_slave_0_readdata_from_sa;
  input            sram_0_avalon_slave_0_wait_counter_eq_0;

  wire    [ 23: 0] cpu_0_data_master_address_to_slave;
  reg     [  1: 0] cpu_0_data_master_dbs_address;
  wire    [  1: 0] cpu_0_data_master_dbs_increment;
  wire    [ 15: 0] cpu_0_data_master_dbs_write_16;
  wire    [ 31: 0] cpu_0_data_master_irq;
  reg              cpu_0_data_master_no_byte_enables_and_last_term;
  wire    [ 31: 0] cpu_0_data_master_readdata;
  wire             cpu_0_data_master_run;
  reg              cpu_0_data_master_waitrequest;
  reg     [ 15: 0] dbs_16_reg_segment_0;
  wire             dbs_count_enable;
  wire             dbs_counter_overflow;
  wire             last_dbs_term_and_run;
  wire    [  1: 0] next_dbs_address;
  wire    [ 15: 0] p1_dbs_16_reg_segment_0;
  wire    [ 31: 0] p1_registered_cpu_0_data_master_readdata;
  wire             pre_dbs_count_enable;
  wire             r_0;
  wire             r_1;
  wire             r_2;
  reg     [ 31: 0] registered_cpu_0_data_master_readdata;
  //r_0 master_run cascaded wait assignment, which is an e_assign
  assign r_0 = 1 & (cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0 | ~cpu_0_data_master_requests_Audio_0_avalon_slave_0) & ((~cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0 | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & (cpu_0_data_master_read | cpu_0_data_master_write)))) & ((~cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0 | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & (cpu_0_data_master_read | cpu_0_data_master_write)))) & 1 & (cpu_0_data_master_qualified_request_SD_CLK_s1 | ~cpu_0_data_master_requests_SD_CLK_s1) & ((~cpu_0_data_master_qualified_request_SD_CLK_s1 | ~cpu_0_data_master_read | (1 & 1 & cpu_0_data_master_read))) & ((~cpu_0_data_master_qualified_request_SD_CLK_s1 | ~cpu_0_data_master_write | (1 & cpu_0_data_master_write))) & 1 & (cpu_0_data_master_qualified_request_SD_CMD_s1 | ~cpu_0_data_master_requests_SD_CMD_s1) & ((~cpu_0_data_master_qualified_request_SD_CMD_s1 | ~cpu_0_data_master_read | (1 & 1 & cpu_0_data_master_read))) & ((~cpu_0_data_master_qualified_request_SD_CMD_s1 | ~cpu_0_data_master_write | (1 & cpu_0_data_master_write))) & 1 & (cpu_0_data_master_qualified_request_SD_DAT_s1 | ~cpu_0_data_master_requests_SD_DAT_s1) & ((~cpu_0_data_master_qualified_request_SD_DAT_s1 | ~cpu_0_data_master_read | (1 & 1 & cpu_0_data_master_read))) & ((~cpu_0_data_master_qualified_request_SD_DAT_s1 | ~cpu_0_data_master_write | (1 & cpu_0_data_master_write))) & 1 & ((~cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0 | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & 1 & (cpu_0_data_master_read | cpu_0_data_master_write)))) & ((~cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0 | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & 1 & (cpu_0_data_master_read | cpu_0_data_master_write)))) & 1;

  //cascaded wait assignment, which is an e_assign
  assign cpu_0_data_master_run = r_0 & r_1 & r_2;

  //r_1 master_run cascaded wait assignment, which is an e_assign
  assign r_1 = (cpu_0_data_master_qualified_request_button_pio_s1 | ~cpu_0_data_master_requests_button_pio_s1) & ((~cpu_0_data_master_qualified_request_button_pio_s1 | ~cpu_0_data_master_read | (1 & 1 & cpu_0_data_master_read))) & ((~cpu_0_data_master_qualified_request_button_pio_s1 | ~cpu_0_data_master_write | (1 & cpu_0_data_master_write))) & 1 & (cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module | ~cpu_0_data_master_requests_cpu_0_jtag_debug_module) & (cpu_0_data_master_granted_cpu_0_jtag_debug_module | ~cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module) & ((~cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module | ~cpu_0_data_master_read | (1 & 1 & cpu_0_data_master_read))) & ((~cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module | ~cpu_0_data_master_write | (1 & cpu_0_data_master_write))) & 1 & (cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave | ~cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave) & ((~cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & ~jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa & (cpu_0_data_master_read | cpu_0_data_master_write)))) & ((~cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & ~jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa & (cpu_0_data_master_read | cpu_0_data_master_write)))) & 1 & (cpu_0_data_master_qualified_request_ps2_avalon_slave_0 | ~cpu_0_data_master_requests_ps2_avalon_slave_0) & ((~cpu_0_data_master_qualified_request_ps2_avalon_slave_0 | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & ~ps2_avalon_slave_0_waitrequest_from_sa & (cpu_0_data_master_read | cpu_0_data_master_write)))) & ((~cpu_0_data_master_qualified_request_ps2_avalon_slave_0 | ~(cpu_0_data_master_read | cpu_0_data_master_write) | (1 & ~ps2_avalon_slave_0_waitrequest_from_sa & (cpu_0_data_master_read | cpu_0_data_master_write)))) & 1 & (cpu_0_data_master_qualified_request_sdram_s1 | (cpu_0_data_master_read_data_valid_sdram_s1 & cpu_0_data_master_dbs_address[1]) | (cpu_0_data_master_write & !cpu_0_data_master_byteenable_sdram_s1 & cpu_0_data_master_dbs_address[1]) | ~cpu_0_data_master_requests_sdram_s1) & (cpu_0_data_master_granted_sdram_s1 | ~cpu_0_data_master_qualified_request_sdram_s1) & ((~cpu_0_data_master_qualified_request_sdram_s1 | ~cpu_0_data_master_read | (cpu_0_data_master_read_data_valid_sdram_s1 & (cpu_0_data_master_dbs_address[1]) & cpu_0_data_master_read)));

  //r_2 master_run cascaded wait assignment, which is an e_assign
  assign r_2 = ((~cpu_0_data_master_qualified_request_sdram_s1 | ~cpu_0_data_master_write | (1 & ~sdram_s1_waitrequest_from_sa & (cpu_0_data_master_dbs_address[1]) & cpu_0_data_master_write))) & 1 & (cpu_0_data_master_qualified_request_sram_0_avalon_slave_0 | (cpu_0_data_master_write & !cpu_0_data_master_byteenable_sram_0_avalon_slave_0 & cpu_0_data_master_dbs_address[1]) | ~cpu_0_data_master_requests_sram_0_avalon_slave_0) & (cpu_0_data_master_granted_sram_0_avalon_slave_0 | ~cpu_0_data_master_qualified_request_sram_0_avalon_slave_0) & ((~cpu_0_data_master_qualified_request_sram_0_avalon_slave_0 | ~cpu_0_data_master_read | (1 & 1 & (cpu_0_data_master_dbs_address[1]) & cpu_0_data_master_read))) & ((~cpu_0_data_master_qualified_request_sram_0_avalon_slave_0 | ~cpu_0_data_master_write | (1 & ~d1_sram_0_avalon_slave_0_end_xfer & (cpu_0_data_master_dbs_address[1]) & cpu_0_data_master_write))) & 1 & (cpu_0_data_master_qualified_request_vga_avalon_slave_0 | ~cpu_0_data_master_requests_vga_avalon_slave_0) & ((~cpu_0_data_master_qualified_request_vga_avalon_slave_0 | ~cpu_0_data_master_read | (1 & 1 & cpu_0_data_master_read))) & ((~cpu_0_data_master_qualified_request_vga_avalon_slave_0 | ~cpu_0_data_master_write | (1 & cpu_0_data_master_write)));

  //optimize select-logic by passing only those address bits which matter.
  assign cpu_0_data_master_address_to_slave = cpu_0_data_master_address[23 : 0];

  //unpredictable registered wait state incoming data, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          registered_cpu_0_data_master_readdata <= 0;
      else if (1)
          registered_cpu_0_data_master_readdata <= p1_registered_cpu_0_data_master_readdata;
    end


  //registered readdata mux, which is an e_mux
  assign p1_registered_cpu_0_data_master_readdata = ({32 {~cpu_0_data_master_requests_Audio_0_avalon_slave_0}} | Audio_0_avalon_slave_0_readdata_from_sa) &
    ({32 {~cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave}} | jtag_uart_0_avalon_jtag_slave_readdata_from_sa) &
    ({32 {~cpu_0_data_master_requests_ps2_avalon_slave_0}} | ps2_avalon_slave_0_readdata_from_sa) &
    ({32 {~cpu_0_data_master_requests_sdram_s1}} | {sdram_s1_readdata_from_sa[15 : 0],
    dbs_16_reg_segment_0});

  //cpu_0/data_master readdata mux, which is an e_mux
  assign cpu_0_data_master_readdata = ({32 {~cpu_0_data_master_requests_Audio_0_avalon_slave_0}} | registered_cpu_0_data_master_readdata) &
    ({32 {~cpu_0_data_master_requests_SD_CMD_s1}} | SD_CMD_s1_readdata_from_sa) &
    ({32 {~cpu_0_data_master_requests_SD_DAT_s1}} | SD_DAT_s1_readdata_from_sa) &
    ({32 {~cpu_0_data_master_requests_button_pio_s1}} | button_pio_s1_readdata_from_sa) &
    ({32 {~cpu_0_data_master_requests_cpu_0_jtag_debug_module}} | cpu_0_jtag_debug_module_readdata_from_sa) &
    ({32 {~cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave}} | registered_cpu_0_data_master_readdata) &
    ({32 {~cpu_0_data_master_requests_ps2_avalon_slave_0}} | registered_cpu_0_data_master_readdata) &
    ({32 {~cpu_0_data_master_requests_sdram_s1}} | registered_cpu_0_data_master_readdata) &
    ({32 {~cpu_0_data_master_requests_sram_0_avalon_slave_0}} | {sram_0_avalon_slave_0_readdata_from_sa[15 : 0],
    dbs_16_reg_segment_0});

  //actual waitrequest port, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_data_master_waitrequest <= ~0;
      else if (1)
          cpu_0_data_master_waitrequest <= ~((~(cpu_0_data_master_read | cpu_0_data_master_write))? 0: (cpu_0_data_master_run & cpu_0_data_master_waitrequest));
    end


  //irq assign, which is an e_assign
  assign cpu_0_data_master_irq = {1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    button_pio_s1_irq_from_sa,
    jtag_uart_0_avalon_jtag_slave_irq_from_sa};

  //no_byte_enables_and_last_term, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_data_master_no_byte_enables_and_last_term <= 0;
      else if (1)
          cpu_0_data_master_no_byte_enables_and_last_term <= last_dbs_term_and_run;
    end


  //compute the last dbs term, which is an e_mux
  assign last_dbs_term_and_run = (cpu_0_data_master_requests_sdram_s1)? (((cpu_0_data_master_dbs_address == 2'b10) & cpu_0_data_master_write & !cpu_0_data_master_byteenable_sdram_s1)) :
    (((cpu_0_data_master_dbs_address == 2'b10) & cpu_0_data_master_write & !cpu_0_data_master_byteenable_sram_0_avalon_slave_0));

  //pre dbs count enable, which is an e_mux
  assign pre_dbs_count_enable = (((~cpu_0_data_master_no_byte_enables_and_last_term) & cpu_0_data_master_requests_sdram_s1 & cpu_0_data_master_write & !cpu_0_data_master_byteenable_sdram_s1)) |
    cpu_0_data_master_read_data_valid_sdram_s1 |
    (cpu_0_data_master_granted_sdram_s1 & cpu_0_data_master_write & 1 & 1 & ~sdram_s1_waitrequest_from_sa) |
    (((~cpu_0_data_master_no_byte_enables_and_last_term) & cpu_0_data_master_requests_sram_0_avalon_slave_0 & cpu_0_data_master_write & !cpu_0_data_master_byteenable_sram_0_avalon_slave_0)) |
    (cpu_0_data_master_granted_sram_0_avalon_slave_0 & cpu_0_data_master_read & 1 & 1 & ~d1_sram_0_avalon_slave_0_end_xfer) |
    ((cpu_0_data_master_granted_sram_0_avalon_slave_0 & cpu_0_data_master_write & 1 & 1 & ({sram_0_avalon_slave_0_wait_counter_eq_0 & ~d1_sram_0_avalon_slave_0_end_xfer})));

  //input to dbs-16 stored 0, which is an e_mux
  assign p1_dbs_16_reg_segment_0 = (cpu_0_data_master_requests_sdram_s1)? sdram_s1_readdata_from_sa :
    sram_0_avalon_slave_0_readdata_from_sa;

  //dbs register for dbs-16 segment 0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          dbs_16_reg_segment_0 <= 0;
      else if (dbs_count_enable & ((cpu_0_data_master_dbs_address[1]) == 0))
          dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
    end


  //mux write dbs 1, which is an e_mux
  assign cpu_0_data_master_dbs_write_16 = (cpu_0_data_master_dbs_address[1])? cpu_0_data_master_writedata[31 : 16] :
    (~(cpu_0_data_master_dbs_address[1]))? cpu_0_data_master_writedata[15 : 0] :
    (cpu_0_data_master_dbs_address[1])? cpu_0_data_master_writedata[31 : 16] :
    cpu_0_data_master_writedata[15 : 0];

  //dbs count increment, which is an e_mux
  assign cpu_0_data_master_dbs_increment = (cpu_0_data_master_requests_sdram_s1)? 2 :
    (cpu_0_data_master_requests_sram_0_avalon_slave_0)? 2 :
    0;

  //dbs counter overflow, which is an e_assign
  assign dbs_counter_overflow = cpu_0_data_master_dbs_address[1] & !(next_dbs_address[1]);

  //next master address, which is an e_assign
  assign next_dbs_address = cpu_0_data_master_dbs_address + cpu_0_data_master_dbs_increment;

  //dbs count enable, which is an e_mux
  assign dbs_count_enable = pre_dbs_count_enable &
    (~(cpu_0_data_master_requests_sdram_s1 & ~cpu_0_data_master_waitrequest));

  //dbs counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_data_master_dbs_address <= 0;
      else if (dbs_count_enable)
          cpu_0_data_master_dbs_address <= next_dbs_address;
    end



endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_0_instruction_master_arbitrator (
                                             // inputs:
                                              clk,
                                              cpu_0_instruction_master_address,
                                              cpu_0_instruction_master_granted_cpu_0_jtag_debug_module,
                                              cpu_0_instruction_master_granted_sram_0_avalon_slave_0,
                                              cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module,
                                              cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0,
                                              cpu_0_instruction_master_read,
                                              cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module,
                                              cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0,
                                              cpu_0_instruction_master_requests_cpu_0_jtag_debug_module,
                                              cpu_0_instruction_master_requests_sram_0_avalon_slave_0,
                                              cpu_0_jtag_debug_module_readdata_from_sa,
                                              d1_cpu_0_jtag_debug_module_end_xfer,
                                              d1_sram_0_avalon_slave_0_end_xfer,
                                              reset_n,
                                              sram_0_avalon_slave_0_readdata_from_sa,
                                              sram_0_avalon_slave_0_wait_counter_eq_0,

                                             // outputs:
                                              cpu_0_instruction_master_address_to_slave,
                                              cpu_0_instruction_master_dbs_address,
                                              cpu_0_instruction_master_latency_counter,
                                              cpu_0_instruction_master_readdata,
                                              cpu_0_instruction_master_readdatavalid,
                                              cpu_0_instruction_master_waitrequest
                                           )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [ 23: 0] cpu_0_instruction_master_address_to_slave;
  output  [  1: 0] cpu_0_instruction_master_dbs_address;
  output           cpu_0_instruction_master_latency_counter;
  output  [ 31: 0] cpu_0_instruction_master_readdata;
  output           cpu_0_instruction_master_readdatavalid;
  output           cpu_0_instruction_master_waitrequest;
  input            clk;
  input   [ 23: 0] cpu_0_instruction_master_address;
  input            cpu_0_instruction_master_granted_cpu_0_jtag_debug_module;
  input            cpu_0_instruction_master_granted_sram_0_avalon_slave_0;
  input            cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module;
  input            cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0;
  input            cpu_0_instruction_master_read;
  input            cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module;
  input            cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0;
  input            cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  input            cpu_0_instruction_master_requests_sram_0_avalon_slave_0;
  input   [ 31: 0] cpu_0_jtag_debug_module_readdata_from_sa;
  input            d1_cpu_0_jtag_debug_module_end_xfer;
  input            d1_sram_0_avalon_slave_0_end_xfer;
  input            reset_n;
  input   [ 15: 0] sram_0_avalon_slave_0_readdata_from_sa;
  input            sram_0_avalon_slave_0_wait_counter_eq_0;

  reg              active_and_waiting_last_time;
  reg     [ 23: 0] cpu_0_instruction_master_address_last_time;
  wire    [ 23: 0] cpu_0_instruction_master_address_to_slave;
  reg     [  1: 0] cpu_0_instruction_master_dbs_address;
  wire    [  1: 0] cpu_0_instruction_master_dbs_increment;
  wire             cpu_0_instruction_master_is_granted_some_slave;
  reg              cpu_0_instruction_master_latency_counter;
  reg              cpu_0_instruction_master_read_but_no_slave_selected;
  reg              cpu_0_instruction_master_read_last_time;
  wire    [ 31: 0] cpu_0_instruction_master_readdata;
  wire             cpu_0_instruction_master_readdatavalid;
  wire             cpu_0_instruction_master_run;
  wire             cpu_0_instruction_master_waitrequest;
  reg     [ 15: 0] dbs_16_reg_segment_0;
  wire             dbs_count_enable;
  wire             dbs_counter_overflow;
  wire             latency_load_value;
  wire    [  1: 0] next_dbs_address;
  wire             p1_cpu_0_instruction_master_latency_counter;
  wire    [ 15: 0] p1_dbs_16_reg_segment_0;
  wire             pre_dbs_count_enable;
  wire             pre_flush_cpu_0_instruction_master_readdatavalid;
  wire             r_1;
  wire             r_2;
  //r_1 master_run cascaded wait assignment, which is an e_assign
  assign r_1 = 1 & (cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module | ~cpu_0_instruction_master_requests_cpu_0_jtag_debug_module) & (cpu_0_instruction_master_granted_cpu_0_jtag_debug_module | ~cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module) & ((~cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module | ~cpu_0_instruction_master_read | (1 & ~d1_cpu_0_jtag_debug_module_end_xfer & cpu_0_instruction_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign cpu_0_instruction_master_run = r_1 & r_2;

  //r_2 master_run cascaded wait assignment, which is an e_assign
  assign r_2 = 1 & (cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0 | ~cpu_0_instruction_master_requests_sram_0_avalon_slave_0) & (cpu_0_instruction_master_granted_sram_0_avalon_slave_0 | ~cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0) & ((~cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0 | ~cpu_0_instruction_master_read | (1 & ~d1_sram_0_avalon_slave_0_end_xfer & (cpu_0_instruction_master_dbs_address[1]) & cpu_0_instruction_master_read)));

  //optimize select-logic by passing only those address bits which matter.
  assign cpu_0_instruction_master_address_to_slave = {3'b100,
    cpu_0_instruction_master_address[20 : 0]};

  //cpu_0_instruction_master_read_but_no_slave_selected assignment, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_instruction_master_read_but_no_slave_selected <= 0;
      else if (1)
          cpu_0_instruction_master_read_but_no_slave_selected <= cpu_0_instruction_master_read & cpu_0_instruction_master_run & ~cpu_0_instruction_master_is_granted_some_slave;
    end


  //some slave is getting selected, which is an e_mux
  assign cpu_0_instruction_master_is_granted_some_slave = cpu_0_instruction_master_granted_cpu_0_jtag_debug_module |
    cpu_0_instruction_master_granted_sram_0_avalon_slave_0;

  //latent slave read data valids which may be flushed, which is an e_mux
  assign pre_flush_cpu_0_instruction_master_readdatavalid = 0;

  //latent slave read data valid which is not flushed, which is an e_mux
  assign cpu_0_instruction_master_readdatavalid = cpu_0_instruction_master_read_but_no_slave_selected |
    pre_flush_cpu_0_instruction_master_readdatavalid |
    cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module |
    cpu_0_instruction_master_read_but_no_slave_selected |
    pre_flush_cpu_0_instruction_master_readdatavalid |
    (cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0 & dbs_counter_overflow);

  //cpu_0/instruction_master readdata mux, which is an e_mux
  assign cpu_0_instruction_master_readdata = ({32 {~(cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module & cpu_0_instruction_master_read)}} | cpu_0_jtag_debug_module_readdata_from_sa) &
    ({32 {~(cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0 & cpu_0_instruction_master_read)}} | {sram_0_avalon_slave_0_readdata_from_sa[15 : 0],
    dbs_16_reg_segment_0});

  //actual waitrequest port, which is an e_assign
  assign cpu_0_instruction_master_waitrequest = ~cpu_0_instruction_master_run;

  //latent max counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_instruction_master_latency_counter <= 0;
      else if (1)
          cpu_0_instruction_master_latency_counter <= p1_cpu_0_instruction_master_latency_counter;
    end


  //latency counter load mux, which is an e_mux
  assign p1_cpu_0_instruction_master_latency_counter = ((cpu_0_instruction_master_run & cpu_0_instruction_master_read))? latency_load_value :
    (cpu_0_instruction_master_latency_counter)? cpu_0_instruction_master_latency_counter - 1 :
    0;

  //read latency load values, which is an e_mux
  assign latency_load_value = 0;

  //input to dbs-16 stored 0, which is an e_mux
  assign p1_dbs_16_reg_segment_0 = sram_0_avalon_slave_0_readdata_from_sa;

  //dbs register for dbs-16 segment 0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          dbs_16_reg_segment_0 <= 0;
      else if (dbs_count_enable & ((cpu_0_instruction_master_dbs_address[1]) == 0))
          dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
    end


  //dbs count increment, which is an e_mux
  assign cpu_0_instruction_master_dbs_increment = (cpu_0_instruction_master_requests_sram_0_avalon_slave_0)? 2 :
    0;

  //dbs counter overflow, which is an e_assign
  assign dbs_counter_overflow = cpu_0_instruction_master_dbs_address[1] & !(next_dbs_address[1]);

  //next master address, which is an e_assign
  assign next_dbs_address = cpu_0_instruction_master_dbs_address + cpu_0_instruction_master_dbs_increment;

  //dbs count enable, which is an e_mux
  assign dbs_count_enable = pre_dbs_count_enable;

  //dbs counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_instruction_master_dbs_address <= 0;
      else if (dbs_count_enable)
          cpu_0_instruction_master_dbs_address <= next_dbs_address;
    end


  //pre dbs count enable, which is an e_mux
  assign pre_dbs_count_enable = cpu_0_instruction_master_granted_sram_0_avalon_slave_0 & cpu_0_instruction_master_read & 1 & 1 & ~d1_sram_0_avalon_slave_0_end_xfer;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //cpu_0_instruction_master_address check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_instruction_master_address_last_time <= 0;
      else if (1)
          cpu_0_instruction_master_address_last_time <= cpu_0_instruction_master_address;
    end


  //cpu_0/instruction_master waited last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          active_and_waiting_last_time <= 0;
      else if (1)
          active_and_waiting_last_time <= cpu_0_instruction_master_waitrequest & (cpu_0_instruction_master_read);
    end


  //cpu_0_instruction_master_address matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or cpu_0_instruction_master_address or cpu_0_instruction_master_address_last_time)
    begin
      if (active_and_waiting_last_time & (cpu_0_instruction_master_address != cpu_0_instruction_master_address_last_time))
        begin
          $write("%0d ns: cpu_0_instruction_master_address did not heed wait!!!", $time);
          $stop;
        end
    end


  //cpu_0_instruction_master_read check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_0_instruction_master_read_last_time <= 0;
      else if (1)
          cpu_0_instruction_master_read_last_time <= cpu_0_instruction_master_read;
    end


  //cpu_0_instruction_master_read matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or cpu_0_instruction_master_read or cpu_0_instruction_master_read_last_time)
    begin
      if (active_and_waiting_last_time & (cpu_0_instruction_master_read != cpu_0_instruction_master_read_last_time))
        begin
          $write("%0d ns: cpu_0_instruction_master_read did not heed wait!!!", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module jtag_uart_0_avalon_jtag_slave_arbitrator (
                                                  // inputs:
                                                   clk,
                                                   cpu_0_data_master_address_to_slave,
                                                   cpu_0_data_master_read,
                                                   cpu_0_data_master_waitrequest,
                                                   cpu_0_data_master_write,
                                                   cpu_0_data_master_writedata,
                                                   jtag_uart_0_avalon_jtag_slave_dataavailable,
                                                   jtag_uart_0_avalon_jtag_slave_irq,
                                                   jtag_uart_0_avalon_jtag_slave_readdata,
                                                   jtag_uart_0_avalon_jtag_slave_readyfordata,
                                                   jtag_uart_0_avalon_jtag_slave_waitrequest,
                                                   reset_n,

                                                  // outputs:
                                                   cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave,
                                                   cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave,
                                                   cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave,
                                                   cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave,
                                                   d1_jtag_uart_0_avalon_jtag_slave_end_xfer,
                                                   jtag_uart_0_avalon_jtag_slave_address,
                                                   jtag_uart_0_avalon_jtag_slave_chipselect,
                                                   jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa,
                                                   jtag_uart_0_avalon_jtag_slave_irq_from_sa,
                                                   jtag_uart_0_avalon_jtag_slave_read_n,
                                                   jtag_uart_0_avalon_jtag_slave_readdata_from_sa,
                                                   jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa,
                                                   jtag_uart_0_avalon_jtag_slave_reset_n,
                                                   jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa,
                                                   jtag_uart_0_avalon_jtag_slave_write_n,
                                                   jtag_uart_0_avalon_jtag_slave_writedata
                                                )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave;
  output           cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave;
  output           cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave;
  output           cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave;
  output           d1_jtag_uart_0_avalon_jtag_slave_end_xfer;
  output           jtag_uart_0_avalon_jtag_slave_address;
  output           jtag_uart_0_avalon_jtag_slave_chipselect;
  output           jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa;
  output           jtag_uart_0_avalon_jtag_slave_irq_from_sa;
  output           jtag_uart_0_avalon_jtag_slave_read_n;
  output  [ 31: 0] jtag_uart_0_avalon_jtag_slave_readdata_from_sa;
  output           jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa;
  output           jtag_uart_0_avalon_jtag_slave_reset_n;
  output           jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;
  output           jtag_uart_0_avalon_jtag_slave_write_n;
  output  [ 31: 0] jtag_uart_0_avalon_jtag_slave_writedata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            jtag_uart_0_avalon_jtag_slave_dataavailable;
  input            jtag_uart_0_avalon_jtag_slave_irq;
  input   [ 31: 0] jtag_uart_0_avalon_jtag_slave_readdata;
  input            jtag_uart_0_avalon_jtag_slave_readyfordata;
  input            jtag_uart_0_avalon_jtag_slave_waitrequest;
  input            reset_n;

  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_saved_grant_jtag_uart_0_avalon_jtag_slave;
  reg              d1_jtag_uart_0_avalon_jtag_slave_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             jtag_uart_0_avalon_jtag_slave_address;
  wire             jtag_uart_0_avalon_jtag_slave_allgrants;
  wire             jtag_uart_0_avalon_jtag_slave_allow_new_arb_cycle;
  wire             jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant;
  wire             jtag_uart_0_avalon_jtag_slave_any_continuerequest;
  wire             jtag_uart_0_avalon_jtag_slave_arb_counter_enable;
  reg     [  1: 0] jtag_uart_0_avalon_jtag_slave_arb_share_counter;
  wire    [  1: 0] jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value;
  wire    [  1: 0] jtag_uart_0_avalon_jtag_slave_arb_share_set_values;
  wire             jtag_uart_0_avalon_jtag_slave_beginbursttransfer_internal;
  wire             jtag_uart_0_avalon_jtag_slave_begins_xfer;
  wire             jtag_uart_0_avalon_jtag_slave_chipselect;
  wire             jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_end_xfer;
  wire             jtag_uart_0_avalon_jtag_slave_firsttransfer;
  wire             jtag_uart_0_avalon_jtag_slave_grant_vector;
  wire             jtag_uart_0_avalon_jtag_slave_in_a_read_cycle;
  wire             jtag_uart_0_avalon_jtag_slave_in_a_write_cycle;
  wire             jtag_uart_0_avalon_jtag_slave_irq_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_master_qreq_vector;
  wire             jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests;
  wire             jtag_uart_0_avalon_jtag_slave_read_n;
  wire    [ 31: 0] jtag_uart_0_avalon_jtag_slave_readdata_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa;
  reg              jtag_uart_0_avalon_jtag_slave_reg_firsttransfer;
  wire             jtag_uart_0_avalon_jtag_slave_reset_n;
  reg              jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable;
  wire             jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2;
  wire             jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer;
  wire             jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_waits_for_read;
  wire             jtag_uart_0_avalon_jtag_slave_waits_for_write;
  wire             jtag_uart_0_avalon_jtag_slave_write_n;
  wire    [ 31: 0] jtag_uart_0_avalon_jtag_slave_writedata;
  wire    [ 23: 0] shifted_address_to_jtag_uart_0_avalon_jtag_slave_from_cpu_0_data_master;
  wire             wait_for_jtag_uart_0_avalon_jtag_slave_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~jtag_uart_0_avalon_jtag_slave_end_xfer;
    end


  assign jtag_uart_0_avalon_jtag_slave_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave));
  //assign jtag_uart_0_avalon_jtag_slave_readdata_from_sa = jtag_uart_0_avalon_jtag_slave_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_readdata_from_sa = jtag_uart_0_avalon_jtag_slave_readdata;

  assign cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave = ({cpu_0_data_master_address_to_slave[23 : 3] , 3'b0} == 24'h901040) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //assign jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa = jtag_uart_0_avalon_jtag_slave_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa = jtag_uart_0_avalon_jtag_slave_dataavailable;

  //assign jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa = jtag_uart_0_avalon_jtag_slave_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa = jtag_uart_0_avalon_jtag_slave_readyfordata;

  //assign jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa = jtag_uart_0_avalon_jtag_slave_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa = jtag_uart_0_avalon_jtag_slave_waitrequest;

  //jtag_uart_0_avalon_jtag_slave_arb_share_counter set values, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_arb_share_set_values = 1;

  //jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests mux, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests = cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave;

  //jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant mux, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant = 0;

  //jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value assignment, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value = jtag_uart_0_avalon_jtag_slave_firsttransfer ? (jtag_uart_0_avalon_jtag_slave_arb_share_set_values - 1) : |jtag_uart_0_avalon_jtag_slave_arb_share_counter ? (jtag_uart_0_avalon_jtag_slave_arb_share_counter - 1) : 0;

  //jtag_uart_0_avalon_jtag_slave_allgrants all slave grants, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_allgrants = |jtag_uart_0_avalon_jtag_slave_grant_vector;

  //jtag_uart_0_avalon_jtag_slave_end_xfer assignment, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_end_xfer = ~(jtag_uart_0_avalon_jtag_slave_waits_for_read | jtag_uart_0_avalon_jtag_slave_waits_for_write);

  //end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave = jtag_uart_0_avalon_jtag_slave_end_xfer & (~jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //jtag_uart_0_avalon_jtag_slave_arb_share_counter arbitration counter enable, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_arb_counter_enable = (end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave & jtag_uart_0_avalon_jtag_slave_allgrants) | (end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave & ~jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests);

  //jtag_uart_0_avalon_jtag_slave_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          jtag_uart_0_avalon_jtag_slave_arb_share_counter <= 0;
      else if (jtag_uart_0_avalon_jtag_slave_arb_counter_enable)
          jtag_uart_0_avalon_jtag_slave_arb_share_counter <= jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value;
    end


  //jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable <= 0;
      else if ((|jtag_uart_0_avalon_jtag_slave_master_qreq_vector & end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave) | (end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave & ~jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests))
          jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable <= |jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value;
    end


  //cpu_0/data_master jtag_uart_0/avalon_jtag_slave arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2 = |jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value;

  //cpu_0/data_master jtag_uart_0/avalon_jtag_slave arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //jtag_uart_0_avalon_jtag_slave_any_continuerequest at least one master continues requesting, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave = cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave & ~((cpu_0_data_master_read & (~cpu_0_data_master_waitrequest)) | ((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //jtag_uart_0_avalon_jtag_slave_writedata mux, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave = cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave;

  //cpu_0/data_master saved-grant jtag_uart_0/avalon_jtag_slave, which is an e_assign
  assign cpu_0_data_master_saved_grant_jtag_uart_0_avalon_jtag_slave = cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave;

  //allow new arb cycle for jtag_uart_0/avalon_jtag_slave, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign jtag_uart_0_avalon_jtag_slave_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign jtag_uart_0_avalon_jtag_slave_master_qreq_vector = 1;

  //jtag_uart_0_avalon_jtag_slave_reset_n assignment, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_reset_n = reset_n;

  assign jtag_uart_0_avalon_jtag_slave_chipselect = cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave;
  //jtag_uart_0_avalon_jtag_slave_firsttransfer first transaction, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_firsttransfer = jtag_uart_0_avalon_jtag_slave_begins_xfer ? jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer : jtag_uart_0_avalon_jtag_slave_reg_firsttransfer;

  //jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer first transaction, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer = ~(jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable & jtag_uart_0_avalon_jtag_slave_any_continuerequest);

  //jtag_uart_0_avalon_jtag_slave_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          jtag_uart_0_avalon_jtag_slave_reg_firsttransfer <= 1'b1;
      else if (jtag_uart_0_avalon_jtag_slave_begins_xfer)
          jtag_uart_0_avalon_jtag_slave_reg_firsttransfer <= jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer;
    end


  //jtag_uart_0_avalon_jtag_slave_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_beginbursttransfer_internal = jtag_uart_0_avalon_jtag_slave_begins_xfer;

  //~jtag_uart_0_avalon_jtag_slave_read_n assignment, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_read_n = ~(cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave & cpu_0_data_master_read);

  //~jtag_uart_0_avalon_jtag_slave_write_n assignment, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_write_n = ~(cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave & cpu_0_data_master_write);

  assign shifted_address_to_jtag_uart_0_avalon_jtag_slave_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //jtag_uart_0_avalon_jtag_slave_address mux, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_address = shifted_address_to_jtag_uart_0_avalon_jtag_slave_from_cpu_0_data_master >> 2;

  //d1_jtag_uart_0_avalon_jtag_slave_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_jtag_uart_0_avalon_jtag_slave_end_xfer <= 1;
      else if (1)
          d1_jtag_uart_0_avalon_jtag_slave_end_xfer <= jtag_uart_0_avalon_jtag_slave_end_xfer;
    end


  //jtag_uart_0_avalon_jtag_slave_waits_for_read in a cycle, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_waits_for_read = jtag_uart_0_avalon_jtag_slave_in_a_read_cycle & jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;

  //jtag_uart_0_avalon_jtag_slave_in_a_read_cycle assignment, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_in_a_read_cycle = cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = jtag_uart_0_avalon_jtag_slave_in_a_read_cycle;

  //jtag_uart_0_avalon_jtag_slave_waits_for_write in a cycle, which is an e_mux
  assign jtag_uart_0_avalon_jtag_slave_waits_for_write = jtag_uart_0_avalon_jtag_slave_in_a_write_cycle & jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;

  //jtag_uart_0_avalon_jtag_slave_in_a_write_cycle assignment, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_in_a_write_cycle = cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = jtag_uart_0_avalon_jtag_slave_in_a_write_cycle;

  assign wait_for_jtag_uart_0_avalon_jtag_slave_counter = 0;
  //assign jtag_uart_0_avalon_jtag_slave_irq_from_sa = jtag_uart_0_avalon_jtag_slave_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_0_avalon_jtag_slave_irq_from_sa = jtag_uart_0_avalon_jtag_slave_irq;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //jtag_uart_0/avalon_jtag_slave enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module ps2_avalon_slave_0_arbitrator (
                                       // inputs:
                                        clk,
                                        cpu_0_data_master_address_to_slave,
                                        cpu_0_data_master_byteenable,
                                        cpu_0_data_master_read,
                                        cpu_0_data_master_waitrequest,
                                        cpu_0_data_master_write,
                                        cpu_0_data_master_writedata,
                                        ps2_avalon_slave_0_readdata,
                                        ps2_avalon_slave_0_waitrequest,
                                        reset_n,

                                       // outputs:
                                        cpu_0_data_master_granted_ps2_avalon_slave_0,
                                        cpu_0_data_master_qualified_request_ps2_avalon_slave_0,
                                        cpu_0_data_master_read_data_valid_ps2_avalon_slave_0,
                                        cpu_0_data_master_requests_ps2_avalon_slave_0,
                                        d1_ps2_avalon_slave_0_end_xfer,
                                        ps2_avalon_slave_0_address,
                                        ps2_avalon_slave_0_byteenable,
                                        ps2_avalon_slave_0_chipselect,
                                        ps2_avalon_slave_0_read,
                                        ps2_avalon_slave_0_readdata_from_sa,
                                        ps2_avalon_slave_0_reset,
                                        ps2_avalon_slave_0_waitrequest_from_sa,
                                        ps2_avalon_slave_0_write,
                                        ps2_avalon_slave_0_writedata
                                     )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           cpu_0_data_master_granted_ps2_avalon_slave_0;
  output           cpu_0_data_master_qualified_request_ps2_avalon_slave_0;
  output           cpu_0_data_master_read_data_valid_ps2_avalon_slave_0;
  output           cpu_0_data_master_requests_ps2_avalon_slave_0;
  output           d1_ps2_avalon_slave_0_end_xfer;
  output           ps2_avalon_slave_0_address;
  output  [  3: 0] ps2_avalon_slave_0_byteenable;
  output           ps2_avalon_slave_0_chipselect;
  output           ps2_avalon_slave_0_read;
  output  [ 31: 0] ps2_avalon_slave_0_readdata_from_sa;
  output           ps2_avalon_slave_0_reset;
  output           ps2_avalon_slave_0_waitrequest_from_sa;
  output           ps2_avalon_slave_0_write;
  output  [ 31: 0] ps2_avalon_slave_0_writedata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input   [  3: 0] cpu_0_data_master_byteenable;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input   [ 31: 0] ps2_avalon_slave_0_readdata;
  input            ps2_avalon_slave_0_waitrequest;
  input            reset_n;

  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_ps2_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_ps2_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_ps2_avalon_slave_0;
  wire             cpu_0_data_master_requests_ps2_avalon_slave_0;
  wire             cpu_0_data_master_saved_grant_ps2_avalon_slave_0;
  reg              d1_ps2_avalon_slave_0_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_ps2_avalon_slave_0;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             ps2_avalon_slave_0_address;
  wire             ps2_avalon_slave_0_allgrants;
  wire             ps2_avalon_slave_0_allow_new_arb_cycle;
  wire             ps2_avalon_slave_0_any_bursting_master_saved_grant;
  wire             ps2_avalon_slave_0_any_continuerequest;
  wire             ps2_avalon_slave_0_arb_counter_enable;
  reg     [  1: 0] ps2_avalon_slave_0_arb_share_counter;
  wire    [  1: 0] ps2_avalon_slave_0_arb_share_counter_next_value;
  wire    [  1: 0] ps2_avalon_slave_0_arb_share_set_values;
  wire             ps2_avalon_slave_0_beginbursttransfer_internal;
  wire             ps2_avalon_slave_0_begins_xfer;
  wire    [  3: 0] ps2_avalon_slave_0_byteenable;
  wire             ps2_avalon_slave_0_chipselect;
  wire             ps2_avalon_slave_0_end_xfer;
  wire             ps2_avalon_slave_0_firsttransfer;
  wire             ps2_avalon_slave_0_grant_vector;
  wire             ps2_avalon_slave_0_in_a_read_cycle;
  wire             ps2_avalon_slave_0_in_a_write_cycle;
  wire             ps2_avalon_slave_0_master_qreq_vector;
  wire             ps2_avalon_slave_0_non_bursting_master_requests;
  wire             ps2_avalon_slave_0_read;
  wire    [ 31: 0] ps2_avalon_slave_0_readdata_from_sa;
  reg              ps2_avalon_slave_0_reg_firsttransfer;
  wire             ps2_avalon_slave_0_reset;
  reg              ps2_avalon_slave_0_slavearbiterlockenable;
  wire             ps2_avalon_slave_0_slavearbiterlockenable2;
  wire             ps2_avalon_slave_0_unreg_firsttransfer;
  wire             ps2_avalon_slave_0_waitrequest_from_sa;
  wire             ps2_avalon_slave_0_waits_for_read;
  wire             ps2_avalon_slave_0_waits_for_write;
  wire             ps2_avalon_slave_0_write;
  wire    [ 31: 0] ps2_avalon_slave_0_writedata;
  wire    [ 23: 0] shifted_address_to_ps2_avalon_slave_0_from_cpu_0_data_master;
  wire             wait_for_ps2_avalon_slave_0_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~ps2_avalon_slave_0_end_xfer;
    end


  assign ps2_avalon_slave_0_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_ps2_avalon_slave_0));
  //assign ps2_avalon_slave_0_readdata_from_sa = ps2_avalon_slave_0_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign ps2_avalon_slave_0_readdata_from_sa = ps2_avalon_slave_0_readdata;

  assign cpu_0_data_master_requests_ps2_avalon_slave_0 = ({cpu_0_data_master_address_to_slave[23 : 3] , 3'b0} == 24'h901048) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //assign ps2_avalon_slave_0_waitrequest_from_sa = ps2_avalon_slave_0_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign ps2_avalon_slave_0_waitrequest_from_sa = ps2_avalon_slave_0_waitrequest;

  //ps2_avalon_slave_0_arb_share_counter set values, which is an e_mux
  assign ps2_avalon_slave_0_arb_share_set_values = 1;

  //ps2_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  assign ps2_avalon_slave_0_non_bursting_master_requests = cpu_0_data_master_requests_ps2_avalon_slave_0;

  //ps2_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  assign ps2_avalon_slave_0_any_bursting_master_saved_grant = 0;

  //ps2_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  assign ps2_avalon_slave_0_arb_share_counter_next_value = ps2_avalon_slave_0_firsttransfer ? (ps2_avalon_slave_0_arb_share_set_values - 1) : |ps2_avalon_slave_0_arb_share_counter ? (ps2_avalon_slave_0_arb_share_counter - 1) : 0;

  //ps2_avalon_slave_0_allgrants all slave grants, which is an e_mux
  assign ps2_avalon_slave_0_allgrants = |ps2_avalon_slave_0_grant_vector;

  //ps2_avalon_slave_0_end_xfer assignment, which is an e_assign
  assign ps2_avalon_slave_0_end_xfer = ~(ps2_avalon_slave_0_waits_for_read | ps2_avalon_slave_0_waits_for_write);

  //end_xfer_arb_share_counter_term_ps2_avalon_slave_0 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_ps2_avalon_slave_0 = ps2_avalon_slave_0_end_xfer & (~ps2_avalon_slave_0_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //ps2_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  assign ps2_avalon_slave_0_arb_counter_enable = (end_xfer_arb_share_counter_term_ps2_avalon_slave_0 & ps2_avalon_slave_0_allgrants) | (end_xfer_arb_share_counter_term_ps2_avalon_slave_0 & ~ps2_avalon_slave_0_non_bursting_master_requests);

  //ps2_avalon_slave_0_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          ps2_avalon_slave_0_arb_share_counter <= 0;
      else if (ps2_avalon_slave_0_arb_counter_enable)
          ps2_avalon_slave_0_arb_share_counter <= ps2_avalon_slave_0_arb_share_counter_next_value;
    end


  //ps2_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          ps2_avalon_slave_0_slavearbiterlockenable <= 0;
      else if ((|ps2_avalon_slave_0_master_qreq_vector & end_xfer_arb_share_counter_term_ps2_avalon_slave_0) | (end_xfer_arb_share_counter_term_ps2_avalon_slave_0 & ~ps2_avalon_slave_0_non_bursting_master_requests))
          ps2_avalon_slave_0_slavearbiterlockenable <= |ps2_avalon_slave_0_arb_share_counter_next_value;
    end


  //cpu_0/data_master ps2/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = ps2_avalon_slave_0_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //ps2_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign ps2_avalon_slave_0_slavearbiterlockenable2 = |ps2_avalon_slave_0_arb_share_counter_next_value;

  //cpu_0/data_master ps2/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = ps2_avalon_slave_0_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //ps2_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_assign
  assign ps2_avalon_slave_0_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_ps2_avalon_slave_0 = cpu_0_data_master_requests_ps2_avalon_slave_0 & ~((cpu_0_data_master_read & (~cpu_0_data_master_waitrequest)) | ((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //ps2_avalon_slave_0_writedata mux, which is an e_mux
  assign ps2_avalon_slave_0_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_ps2_avalon_slave_0 = cpu_0_data_master_qualified_request_ps2_avalon_slave_0;

  //cpu_0/data_master saved-grant ps2/avalon_slave_0, which is an e_assign
  assign cpu_0_data_master_saved_grant_ps2_avalon_slave_0 = cpu_0_data_master_requests_ps2_avalon_slave_0;

  //allow new arb cycle for ps2/avalon_slave_0, which is an e_assign
  assign ps2_avalon_slave_0_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign ps2_avalon_slave_0_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign ps2_avalon_slave_0_master_qreq_vector = 1;

  //~ps2_avalon_slave_0_reset assignment, which is an e_assign
  assign ps2_avalon_slave_0_reset = ~reset_n;

  assign ps2_avalon_slave_0_chipselect = cpu_0_data_master_granted_ps2_avalon_slave_0;
  //ps2_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  assign ps2_avalon_slave_0_firsttransfer = ps2_avalon_slave_0_begins_xfer ? ps2_avalon_slave_0_unreg_firsttransfer : ps2_avalon_slave_0_reg_firsttransfer;

  //ps2_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  assign ps2_avalon_slave_0_unreg_firsttransfer = ~(ps2_avalon_slave_0_slavearbiterlockenable & ps2_avalon_slave_0_any_continuerequest);

  //ps2_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          ps2_avalon_slave_0_reg_firsttransfer <= 1'b1;
      else if (ps2_avalon_slave_0_begins_xfer)
          ps2_avalon_slave_0_reg_firsttransfer <= ps2_avalon_slave_0_unreg_firsttransfer;
    end


  //ps2_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign ps2_avalon_slave_0_beginbursttransfer_internal = ps2_avalon_slave_0_begins_xfer;

  //ps2_avalon_slave_0_read assignment, which is an e_mux
  assign ps2_avalon_slave_0_read = cpu_0_data_master_granted_ps2_avalon_slave_0 & cpu_0_data_master_read;

  //ps2_avalon_slave_0_write assignment, which is an e_mux
  assign ps2_avalon_slave_0_write = cpu_0_data_master_granted_ps2_avalon_slave_0 & cpu_0_data_master_write;

  assign shifted_address_to_ps2_avalon_slave_0_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //ps2_avalon_slave_0_address mux, which is an e_mux
  assign ps2_avalon_slave_0_address = shifted_address_to_ps2_avalon_slave_0_from_cpu_0_data_master >> 2;

  //d1_ps2_avalon_slave_0_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_ps2_avalon_slave_0_end_xfer <= 1;
      else if (1)
          d1_ps2_avalon_slave_0_end_xfer <= ps2_avalon_slave_0_end_xfer;
    end


  //ps2_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  assign ps2_avalon_slave_0_waits_for_read = ps2_avalon_slave_0_in_a_read_cycle & ps2_avalon_slave_0_waitrequest_from_sa;

  //ps2_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  assign ps2_avalon_slave_0_in_a_read_cycle = cpu_0_data_master_granted_ps2_avalon_slave_0 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = ps2_avalon_slave_0_in_a_read_cycle;

  //ps2_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  assign ps2_avalon_slave_0_waits_for_write = ps2_avalon_slave_0_in_a_write_cycle & ps2_avalon_slave_0_waitrequest_from_sa;

  //ps2_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  assign ps2_avalon_slave_0_in_a_write_cycle = cpu_0_data_master_granted_ps2_avalon_slave_0 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = ps2_avalon_slave_0_in_a_write_cycle;

  assign wait_for_ps2_avalon_slave_0_counter = 0;
  //ps2_avalon_slave_0_byteenable byte enable port mux, which is an e_mux
  assign ps2_avalon_slave_0_byteenable = (cpu_0_data_master_granted_ps2_avalon_slave_0)? cpu_0_data_master_byteenable :
    -1;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //ps2/avalon_slave_0 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module (
                                                           // inputs:
                                                            clear_fifo,
                                                            clk,
                                                            data_in,
                                                            read,
                                                            reset_n,
                                                            sync_reset,
                                                            write,

                                                           // outputs:
                                                            data_out,
                                                            empty,
                                                            fifo_contains_ones_n,
                                                            full
                                                         )
;

  output           data_out;
  output           empty;
  output           fifo_contains_ones_n;
  output           full;
  input            clear_fifo;
  input            clk;
  input            data_in;
  input            read;
  input            reset_n;
  input            sync_reset;
  input            write;

  wire             data_out;
  wire             empty;
  reg              fifo_contains_ones_n;
  wire             full;
  reg              full_0;
  reg              full_1;
  reg              full_2;
  reg              full_3;
  reg              full_4;
  reg              full_5;
  reg              full_6;
  wire             full_7;
  reg     [  3: 0] how_many_ones;
  wire    [  3: 0] one_count_minus_one;
  wire    [  3: 0] one_count_plus_one;
  wire             p0_full_0;
  wire             p0_stage_0;
  wire             p1_full_1;
  wire             p1_stage_1;
  wire             p2_full_2;
  wire             p2_stage_2;
  wire             p3_full_3;
  wire             p3_stage_3;
  wire             p4_full_4;
  wire             p4_stage_4;
  wire             p5_full_5;
  wire             p5_stage_5;
  wire             p6_full_6;
  wire             p6_stage_6;
  reg              stage_0;
  reg              stage_1;
  reg              stage_2;
  reg              stage_3;
  reg              stage_4;
  reg              stage_5;
  reg              stage_6;
  wire    [  3: 0] updated_one_count;
  assign data_out = stage_0;
  assign full = full_6;
  assign empty = !full_0;
  assign full_7 = 0;
  //data_6, which is an e_mux
  assign p6_stage_6 = ((full_7 & ~clear_fifo) == 0)? data_in :
    data_in;

  //data_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_6 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_6))
          if (sync_reset & full_6 & !((full_7 == 0) & read & write))
              stage_6 <= 0;
          else 
            stage_6 <= p6_stage_6;
    end


  //control_6, which is an e_mux
  assign p6_full_6 = ((read & !write) == 0)? full_5 :
    0;

  //control_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_6 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_6 <= 0;
          else 
            full_6 <= p6_full_6;
    end


  //data_5, which is an e_mux
  assign p5_stage_5 = ((full_6 & ~clear_fifo) == 0)? data_in :
    stage_6;

  //data_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_5 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_5))
          if (sync_reset & full_5 & !((full_6 == 0) & read & write))
              stage_5 <= 0;
          else 
            stage_5 <= p5_stage_5;
    end


  //control_5, which is an e_mux
  assign p5_full_5 = ((read & !write) == 0)? full_4 :
    full_6;

  //control_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_5 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_5 <= 0;
          else 
            full_5 <= p5_full_5;
    end


  //data_4, which is an e_mux
  assign p4_stage_4 = ((full_5 & ~clear_fifo) == 0)? data_in :
    stage_5;

  //data_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_4 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_4))
          if (sync_reset & full_4 & !((full_5 == 0) & read & write))
              stage_4 <= 0;
          else 
            stage_4 <= p4_stage_4;
    end


  //control_4, which is an e_mux
  assign p4_full_4 = ((read & !write) == 0)? full_3 :
    full_5;

  //control_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_4 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_4 <= 0;
          else 
            full_4 <= p4_full_4;
    end


  //data_3, which is an e_mux
  assign p3_stage_3 = ((full_4 & ~clear_fifo) == 0)? data_in :
    stage_4;

  //data_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_3 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_3))
          if (sync_reset & full_3 & !((full_4 == 0) & read & write))
              stage_3 <= 0;
          else 
            stage_3 <= p3_stage_3;
    end


  //control_3, which is an e_mux
  assign p3_full_3 = ((read & !write) == 0)? full_2 :
    full_4;

  //control_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_3 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_3 <= 0;
          else 
            full_3 <= p3_full_3;
    end


  //data_2, which is an e_mux
  assign p2_stage_2 = ((full_3 & ~clear_fifo) == 0)? data_in :
    stage_3;

  //data_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_2 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_2))
          if (sync_reset & full_2 & !((full_3 == 0) & read & write))
              stage_2 <= 0;
          else 
            stage_2 <= p2_stage_2;
    end


  //control_2, which is an e_mux
  assign p2_full_2 = ((read & !write) == 0)? full_1 :
    full_3;

  //control_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_2 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_2 <= 0;
          else 
            full_2 <= p2_full_2;
    end


  //data_1, which is an e_mux
  assign p1_stage_1 = ((full_2 & ~clear_fifo) == 0)? data_in :
    stage_2;

  //data_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_1 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_1))
          if (sync_reset & full_1 & !((full_2 == 0) & read & write))
              stage_1 <= 0;
          else 
            stage_1 <= p1_stage_1;
    end


  //control_1, which is an e_mux
  assign p1_full_1 = ((read & !write) == 0)? full_0 :
    full_2;

  //control_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_1 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_1 <= 0;
          else 
            full_1 <= p1_full_1;
    end


  //data_0, which is an e_mux
  assign p0_stage_0 = ((full_1 & ~clear_fifo) == 0)? data_in :
    stage_1;

  //data_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_0 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_0))
          if (sync_reset & full_0 & !((full_1 == 0) & read & write))
              stage_0 <= 0;
          else 
            stage_0 <= p0_stage_0;
    end


  //control_0, which is an e_mux
  assign p0_full_0 = ((read & !write) == 0)? 1 :
    full_1;

  //control_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_0 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo & ~write)
              full_0 <= 0;
          else 
            full_0 <= p0_full_0;
    end


  assign one_count_plus_one = how_many_ones + 1;
  assign one_count_minus_one = how_many_ones - 1;
  //updated_one_count, which is an e_mux
  assign updated_one_count = ((((clear_fifo | sync_reset) & !write)))? 0 :
    ((((clear_fifo | sync_reset) & write)))? |data_in :
    ((read & (|data_in) & write & (|stage_0)))? how_many_ones :
    ((write & (|data_in)))? one_count_plus_one :
    ((read & (|stage_0)))? one_count_minus_one :
    how_many_ones;

  //counts how many ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          how_many_ones <= 0;
      else if (clear_fifo | sync_reset | read | write)
          how_many_ones <= updated_one_count;
    end


  //this fifo contains ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          fifo_contains_ones_n <= 1;
      else if (clear_fifo | sync_reset | read | write)
          fifo_contains_ones_n <= ~(|updated_one_count);
    end



endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module rdv_fifo_for_vga_read_master_to_sdram_s1_module (
                                                         // inputs:
                                                          clear_fifo,
                                                          clk,
                                                          data_in,
                                                          read,
                                                          reset_n,
                                                          sync_reset,
                                                          write,

                                                         // outputs:
                                                          data_out,
                                                          empty,
                                                          fifo_contains_ones_n,
                                                          full
                                                       )
;

  output           data_out;
  output           empty;
  output           fifo_contains_ones_n;
  output           full;
  input            clear_fifo;
  input            clk;
  input            data_in;
  input            read;
  input            reset_n;
  input            sync_reset;
  input            write;

  wire             data_out;
  wire             empty;
  reg              fifo_contains_ones_n;
  wire             full;
  reg              full_0;
  reg              full_1;
  reg              full_2;
  reg              full_3;
  reg              full_4;
  reg              full_5;
  reg              full_6;
  wire             full_7;
  reg     [  3: 0] how_many_ones;
  wire    [  3: 0] one_count_minus_one;
  wire    [  3: 0] one_count_plus_one;
  wire             p0_full_0;
  wire             p0_stage_0;
  wire             p1_full_1;
  wire             p1_stage_1;
  wire             p2_full_2;
  wire             p2_stage_2;
  wire             p3_full_3;
  wire             p3_stage_3;
  wire             p4_full_4;
  wire             p4_stage_4;
  wire             p5_full_5;
  wire             p5_stage_5;
  wire             p6_full_6;
  wire             p6_stage_6;
  reg              stage_0;
  reg              stage_1;
  reg              stage_2;
  reg              stage_3;
  reg              stage_4;
  reg              stage_5;
  reg              stage_6;
  wire    [  3: 0] updated_one_count;
  assign data_out = stage_0;
  assign full = full_6;
  assign empty = !full_0;
  assign full_7 = 0;
  //data_6, which is an e_mux
  assign p6_stage_6 = ((full_7 & ~clear_fifo) == 0)? data_in :
    data_in;

  //data_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_6 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_6))
          if (sync_reset & full_6 & !((full_7 == 0) & read & write))
              stage_6 <= 0;
          else 
            stage_6 <= p6_stage_6;
    end


  //control_6, which is an e_mux
  assign p6_full_6 = ((read & !write) == 0)? full_5 :
    0;

  //control_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_6 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_6 <= 0;
          else 
            full_6 <= p6_full_6;
    end


  //data_5, which is an e_mux
  assign p5_stage_5 = ((full_6 & ~clear_fifo) == 0)? data_in :
    stage_6;

  //data_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_5 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_5))
          if (sync_reset & full_5 & !((full_6 == 0) & read & write))
              stage_5 <= 0;
          else 
            stage_5 <= p5_stage_5;
    end


  //control_5, which is an e_mux
  assign p5_full_5 = ((read & !write) == 0)? full_4 :
    full_6;

  //control_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_5 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_5 <= 0;
          else 
            full_5 <= p5_full_5;
    end


  //data_4, which is an e_mux
  assign p4_stage_4 = ((full_5 & ~clear_fifo) == 0)? data_in :
    stage_5;

  //data_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_4 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_4))
          if (sync_reset & full_4 & !((full_5 == 0) & read & write))
              stage_4 <= 0;
          else 
            stage_4 <= p4_stage_4;
    end


  //control_4, which is an e_mux
  assign p4_full_4 = ((read & !write) == 0)? full_3 :
    full_5;

  //control_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_4 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_4 <= 0;
          else 
            full_4 <= p4_full_4;
    end


  //data_3, which is an e_mux
  assign p3_stage_3 = ((full_4 & ~clear_fifo) == 0)? data_in :
    stage_4;

  //data_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_3 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_3))
          if (sync_reset & full_3 & !((full_4 == 0) & read & write))
              stage_3 <= 0;
          else 
            stage_3 <= p3_stage_3;
    end


  //control_3, which is an e_mux
  assign p3_full_3 = ((read & !write) == 0)? full_2 :
    full_4;

  //control_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_3 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_3 <= 0;
          else 
            full_3 <= p3_full_3;
    end


  //data_2, which is an e_mux
  assign p2_stage_2 = ((full_3 & ~clear_fifo) == 0)? data_in :
    stage_3;

  //data_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_2 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_2))
          if (sync_reset & full_2 & !((full_3 == 0) & read & write))
              stage_2 <= 0;
          else 
            stage_2 <= p2_stage_2;
    end


  //control_2, which is an e_mux
  assign p2_full_2 = ((read & !write) == 0)? full_1 :
    full_3;

  //control_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_2 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_2 <= 0;
          else 
            full_2 <= p2_full_2;
    end


  //data_1, which is an e_mux
  assign p1_stage_1 = ((full_2 & ~clear_fifo) == 0)? data_in :
    stage_2;

  //data_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_1 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_1))
          if (sync_reset & full_1 & !((full_2 == 0) & read & write))
              stage_1 <= 0;
          else 
            stage_1 <= p1_stage_1;
    end


  //control_1, which is an e_mux
  assign p1_full_1 = ((read & !write) == 0)? full_0 :
    full_2;

  //control_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_1 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_1 <= 0;
          else 
            full_1 <= p1_full_1;
    end


  //data_0, which is an e_mux
  assign p0_stage_0 = ((full_1 & ~clear_fifo) == 0)? data_in :
    stage_1;

  //data_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_0 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_0))
          if (sync_reset & full_0 & !((full_1 == 0) & read & write))
              stage_0 <= 0;
          else 
            stage_0 <= p0_stage_0;
    end


  //control_0, which is an e_mux
  assign p0_full_0 = ((read & !write) == 0)? 1 :
    full_1;

  //control_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_0 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo & ~write)
              full_0 <= 0;
          else 
            full_0 <= p0_full_0;
    end


  assign one_count_plus_one = how_many_ones + 1;
  assign one_count_minus_one = how_many_ones - 1;
  //updated_one_count, which is an e_mux
  assign updated_one_count = ((((clear_fifo | sync_reset) & !write)))? 0 :
    ((((clear_fifo | sync_reset) & write)))? |data_in :
    ((read & (|data_in) & write & (|stage_0)))? how_many_ones :
    ((write & (|data_in)))? one_count_plus_one :
    ((read & (|stage_0)))? one_count_minus_one :
    how_many_ones;

  //counts how many ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          how_many_ones <= 0;
      else if (clear_fifo | sync_reset | read | write)
          how_many_ones <= updated_one_count;
    end


  //this fifo contains ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          fifo_contains_ones_n <= 1;
      else if (clear_fifo | sync_reset | read | write)
          fifo_contains_ones_n <= ~(|updated_one_count);
    end



endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module sdram_s1_arbitrator (
                             // inputs:
                              clk,
                              cpu_0_data_master_address_to_slave,
                              cpu_0_data_master_byteenable,
                              cpu_0_data_master_dbs_address,
                              cpu_0_data_master_dbs_write_16,
                              cpu_0_data_master_no_byte_enables_and_last_term,
                              cpu_0_data_master_read,
                              cpu_0_data_master_waitrequest,
                              cpu_0_data_master_write,
                              reset_n,
                              sdram_s1_readdata,
                              sdram_s1_readdatavalid,
                              sdram_s1_waitrequest,
                              vga_read_master_address_to_slave,
                              vga_read_master_dbs_address,
                              vga_read_master_read,

                             // outputs:
                              cpu_0_data_master_byteenable_sdram_s1,
                              cpu_0_data_master_granted_sdram_s1,
                              cpu_0_data_master_qualified_request_sdram_s1,
                              cpu_0_data_master_read_data_valid_sdram_s1,
                              cpu_0_data_master_read_data_valid_sdram_s1_shift_register,
                              cpu_0_data_master_requests_sdram_s1,
                              d1_sdram_s1_end_xfer,
                              sdram_s1_address,
                              sdram_s1_byteenable_n,
                              sdram_s1_chipselect,
                              sdram_s1_read_n,
                              sdram_s1_readdata_from_sa,
                              sdram_s1_reset_n,
                              sdram_s1_waitrequest_from_sa,
                              sdram_s1_write_n,
                              sdram_s1_writedata,
                              vga_read_master_granted_sdram_s1,
                              vga_read_master_qualified_request_sdram_s1,
                              vga_read_master_read_data_valid_sdram_s1,
                              vga_read_master_read_data_valid_sdram_s1_shift_register,
                              vga_read_master_requests_sdram_s1
                           )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [  1: 0] cpu_0_data_master_byteenable_sdram_s1;
  output           cpu_0_data_master_granted_sdram_s1;
  output           cpu_0_data_master_qualified_request_sdram_s1;
  output           cpu_0_data_master_read_data_valid_sdram_s1;
  output           cpu_0_data_master_read_data_valid_sdram_s1_shift_register;
  output           cpu_0_data_master_requests_sdram_s1;
  output           d1_sdram_s1_end_xfer;
  output  [ 21: 0] sdram_s1_address;
  output  [  1: 0] sdram_s1_byteenable_n;
  output           sdram_s1_chipselect;
  output           sdram_s1_read_n;
  output  [ 15: 0] sdram_s1_readdata_from_sa;
  output           sdram_s1_reset_n;
  output           sdram_s1_waitrequest_from_sa;
  output           sdram_s1_write_n;
  output  [ 15: 0] sdram_s1_writedata;
  output           vga_read_master_granted_sdram_s1;
  output           vga_read_master_qualified_request_sdram_s1;
  output           vga_read_master_read_data_valid_sdram_s1;
  output           vga_read_master_read_data_valid_sdram_s1_shift_register;
  output           vga_read_master_requests_sdram_s1;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input   [  3: 0] cpu_0_data_master_byteenable;
  input   [  1: 0] cpu_0_data_master_dbs_address;
  input   [ 15: 0] cpu_0_data_master_dbs_write_16;
  input            cpu_0_data_master_no_byte_enables_and_last_term;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input            reset_n;
  input   [ 15: 0] sdram_s1_readdata;
  input            sdram_s1_readdatavalid;
  input            sdram_s1_waitrequest;
  input   [ 31: 0] vga_read_master_address_to_slave;
  input   [  1: 0] vga_read_master_dbs_address;
  input            vga_read_master_read;

  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire    [  1: 0] cpu_0_data_master_byteenable_sdram_s1;
  wire    [  1: 0] cpu_0_data_master_byteenable_sdram_s1_segment_0;
  wire    [  1: 0] cpu_0_data_master_byteenable_sdram_s1_segment_1;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_sdram_s1;
  wire             cpu_0_data_master_qualified_request_sdram_s1;
  wire             cpu_0_data_master_rdv_fifo_empty_sdram_s1;
  wire             cpu_0_data_master_rdv_fifo_output_from_sdram_s1;
  wire             cpu_0_data_master_read_data_valid_sdram_s1;
  wire             cpu_0_data_master_read_data_valid_sdram_s1_shift_register;
  wire             cpu_0_data_master_requests_sdram_s1;
  wire             cpu_0_data_master_saved_grant_sdram_s1;
  reg              d1_reasons_to_wait;
  reg              d1_sdram_s1_end_xfer;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_sdram_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  reg              last_cycle_cpu_0_data_master_granted_slave_sdram_s1;
  reg              last_cycle_vga_read_master_granted_slave_sdram_s1;
  wire    [ 21: 0] sdram_s1_address;
  wire             sdram_s1_allgrants;
  wire             sdram_s1_allow_new_arb_cycle;
  wire             sdram_s1_any_bursting_master_saved_grant;
  wire             sdram_s1_any_continuerequest;
  reg     [  1: 0] sdram_s1_arb_addend;
  wire             sdram_s1_arb_counter_enable;
  reg     [  1: 0] sdram_s1_arb_share_counter;
  wire    [  1: 0] sdram_s1_arb_share_counter_next_value;
  wire    [  1: 0] sdram_s1_arb_share_set_values;
  wire    [  1: 0] sdram_s1_arb_winner;
  wire             sdram_s1_arbitration_holdoff_internal;
  wire             sdram_s1_beginbursttransfer_internal;
  wire             sdram_s1_begins_xfer;
  wire    [  1: 0] sdram_s1_byteenable_n;
  wire             sdram_s1_chipselect;
  wire    [  3: 0] sdram_s1_chosen_master_double_vector;
  wire    [  1: 0] sdram_s1_chosen_master_rot_left;
  wire             sdram_s1_end_xfer;
  wire             sdram_s1_firsttransfer;
  wire    [  1: 0] sdram_s1_grant_vector;
  wire             sdram_s1_in_a_read_cycle;
  wire             sdram_s1_in_a_write_cycle;
  wire    [  1: 0] sdram_s1_master_qreq_vector;
  wire             sdram_s1_move_on_to_next_transaction;
  wire             sdram_s1_non_bursting_master_requests;
  wire             sdram_s1_read_n;
  wire    [ 15: 0] sdram_s1_readdata_from_sa;
  wire             sdram_s1_readdatavalid_from_sa;
  reg              sdram_s1_reg_firsttransfer;
  wire             sdram_s1_reset_n;
  reg     [  1: 0] sdram_s1_saved_chosen_master_vector;
  reg              sdram_s1_slavearbiterlockenable;
  wire             sdram_s1_slavearbiterlockenable2;
  wire             sdram_s1_unreg_firsttransfer;
  wire             sdram_s1_waitrequest_from_sa;
  wire             sdram_s1_waits_for_read;
  wire             sdram_s1_waits_for_write;
  wire             sdram_s1_write_n;
  wire    [ 15: 0] sdram_s1_writedata;
  wire    [ 23: 0] shifted_address_to_sdram_s1_from_cpu_0_data_master;
  wire    [ 31: 0] shifted_address_to_sdram_s1_from_vga_read_master;
  wire             vga_read_master_arbiterlock;
  wire             vga_read_master_arbiterlock2;
  wire             vga_read_master_continuerequest;
  wire             vga_read_master_granted_sdram_s1;
  wire             vga_read_master_qualified_request_sdram_s1;
  wire             vga_read_master_rdv_fifo_empty_sdram_s1;
  wire             vga_read_master_rdv_fifo_output_from_sdram_s1;
  wire             vga_read_master_read_data_valid_sdram_s1;
  wire             vga_read_master_read_data_valid_sdram_s1_shift_register;
  wire             vga_read_master_requests_sdram_s1;
  wire             vga_read_master_saved_grant_sdram_s1;
  wire             wait_for_sdram_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~sdram_s1_end_xfer;
    end


  assign sdram_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_sdram_s1 | vga_read_master_qualified_request_sdram_s1));
  //assign sdram_s1_readdata_from_sa = sdram_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sdram_s1_readdata_from_sa = sdram_s1_readdata;

  assign cpu_0_data_master_requests_sdram_s1 = ({cpu_0_data_master_address_to_slave[23] , 23'b0} == 24'h0) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //assign sdram_s1_waitrequest_from_sa = sdram_s1_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sdram_s1_waitrequest_from_sa = sdram_s1_waitrequest;

  //assign sdram_s1_readdatavalid_from_sa = sdram_s1_readdatavalid so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sdram_s1_readdatavalid_from_sa = sdram_s1_readdatavalid;

  //sdram_s1_arb_share_counter set values, which is an e_mux
  assign sdram_s1_arb_share_set_values = (cpu_0_data_master_granted_sdram_s1)? 2 :
    (vga_read_master_granted_sdram_s1)? 2 :
    (cpu_0_data_master_granted_sdram_s1)? 2 :
    (vga_read_master_granted_sdram_s1)? 2 :
    1;

  //sdram_s1_non_bursting_master_requests mux, which is an e_mux
  assign sdram_s1_non_bursting_master_requests = cpu_0_data_master_requests_sdram_s1 |
    vga_read_master_requests_sdram_s1 |
    cpu_0_data_master_requests_sdram_s1 |
    vga_read_master_requests_sdram_s1;

  //sdram_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign sdram_s1_any_bursting_master_saved_grant = 0;

  //sdram_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign sdram_s1_arb_share_counter_next_value = sdram_s1_firsttransfer ? (sdram_s1_arb_share_set_values - 1) : |sdram_s1_arb_share_counter ? (sdram_s1_arb_share_counter - 1) : 0;

  //sdram_s1_allgrants all slave grants, which is an e_mux
  assign sdram_s1_allgrants = |sdram_s1_grant_vector |
    |sdram_s1_grant_vector |
    |sdram_s1_grant_vector |
    |sdram_s1_grant_vector;

  //sdram_s1_end_xfer assignment, which is an e_assign
  assign sdram_s1_end_xfer = ~(sdram_s1_waits_for_read | sdram_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_sdram_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_sdram_s1 = sdram_s1_end_xfer & (~sdram_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //sdram_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign sdram_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_sdram_s1 & sdram_s1_allgrants) | (end_xfer_arb_share_counter_term_sdram_s1 & ~sdram_s1_non_bursting_master_requests);

  //sdram_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_arb_share_counter <= 0;
      else if (sdram_s1_arb_counter_enable)
          sdram_s1_arb_share_counter <= sdram_s1_arb_share_counter_next_value;
    end


  //sdram_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_slavearbiterlockenable <= 0;
      else if ((|sdram_s1_master_qreq_vector & end_xfer_arb_share_counter_term_sdram_s1) | (end_xfer_arb_share_counter_term_sdram_s1 & ~sdram_s1_non_bursting_master_requests))
          sdram_s1_slavearbiterlockenable <= |sdram_s1_arb_share_counter_next_value;
    end


  //cpu_0/data_master sdram/s1 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = sdram_s1_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //sdram_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign sdram_s1_slavearbiterlockenable2 = |sdram_s1_arb_share_counter_next_value;

  //cpu_0/data_master sdram/s1 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = sdram_s1_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //vga/read_master sdram/s1 arbiterlock, which is an e_assign
  assign vga_read_master_arbiterlock = sdram_s1_slavearbiterlockenable & vga_read_master_continuerequest;

  //vga/read_master sdram/s1 arbiterlock2, which is an e_assign
  assign vga_read_master_arbiterlock2 = sdram_s1_slavearbiterlockenable2 & vga_read_master_continuerequest;

  //vga/read_master granted sdram/s1 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_vga_read_master_granted_slave_sdram_s1 <= 0;
      else if (1)
          last_cycle_vga_read_master_granted_slave_sdram_s1 <= vga_read_master_saved_grant_sdram_s1 ? 1 : (sdram_s1_arbitration_holdoff_internal | ~vga_read_master_requests_sdram_s1) ? 0 : last_cycle_vga_read_master_granted_slave_sdram_s1;
    end


  //vga_read_master_continuerequest continued request, which is an e_mux
  assign vga_read_master_continuerequest = last_cycle_vga_read_master_granted_slave_sdram_s1 & vga_read_master_requests_sdram_s1;

  //sdram_s1_any_continuerequest at least one master continues requesting, which is an e_mux
  assign sdram_s1_any_continuerequest = vga_read_master_continuerequest |
    cpu_0_data_master_continuerequest;

  assign cpu_0_data_master_qualified_request_sdram_s1 = cpu_0_data_master_requests_sdram_s1 & ~((cpu_0_data_master_read & (~cpu_0_data_master_waitrequest | (|cpu_0_data_master_read_data_valid_sdram_s1_shift_register))) | ((~cpu_0_data_master_waitrequest | cpu_0_data_master_no_byte_enables_and_last_term | !cpu_0_data_master_byteenable_sdram_s1) & cpu_0_data_master_write) | vga_read_master_arbiterlock);
  //unique name for sdram_s1_move_on_to_next_transaction, which is an e_assign
  assign sdram_s1_move_on_to_next_transaction = sdram_s1_readdatavalid_from_sa;

  //rdv_fifo_for_cpu_0_data_master_to_sdram_s1, which is an e_fifo_with_registered_outputs
  rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module rdv_fifo_for_cpu_0_data_master_to_sdram_s1
    (
      .clear_fifo           (1'b0),
      .clk                  (clk),
      .data_in              (cpu_0_data_master_granted_sdram_s1),
      .data_out             (cpu_0_data_master_rdv_fifo_output_from_sdram_s1),
      .empty                (),
      .fifo_contains_ones_n (cpu_0_data_master_rdv_fifo_empty_sdram_s1),
      .full                 (),
      .read                 (sdram_s1_move_on_to_next_transaction),
      .reset_n              (reset_n),
      .sync_reset           (1'b0),
      .write                (in_a_read_cycle & ~sdram_s1_waits_for_read)
    );

  assign cpu_0_data_master_read_data_valid_sdram_s1_shift_register = ~cpu_0_data_master_rdv_fifo_empty_sdram_s1;
  //local readdatavalid cpu_0_data_master_read_data_valid_sdram_s1, which is an e_mux
  assign cpu_0_data_master_read_data_valid_sdram_s1 = (sdram_s1_readdatavalid_from_sa & cpu_0_data_master_rdv_fifo_output_from_sdram_s1) & ~ cpu_0_data_master_rdv_fifo_empty_sdram_s1;

  //sdram_s1_writedata mux, which is an e_mux
  assign sdram_s1_writedata = cpu_0_data_master_dbs_write_16;

  assign vga_read_master_requests_sdram_s1 = (({vga_read_master_address_to_slave[31 : 23] , 23'b0} == 32'h0) & (vga_read_master_read)) & vga_read_master_read;
  //cpu_0/data_master granted sdram/s1 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_0_data_master_granted_slave_sdram_s1 <= 0;
      else if (1)
          last_cycle_cpu_0_data_master_granted_slave_sdram_s1 <= cpu_0_data_master_saved_grant_sdram_s1 ? 1 : (sdram_s1_arbitration_holdoff_internal | ~cpu_0_data_master_requests_sdram_s1) ? 0 : last_cycle_cpu_0_data_master_granted_slave_sdram_s1;
    end


  //cpu_0_data_master_continuerequest continued request, which is an e_mux
  assign cpu_0_data_master_continuerequest = last_cycle_cpu_0_data_master_granted_slave_sdram_s1 & cpu_0_data_master_requests_sdram_s1;

  assign vga_read_master_qualified_request_sdram_s1 = vga_read_master_requests_sdram_s1 & ~((vga_read_master_read & ((|vga_read_master_read_data_valid_sdram_s1_shift_register))) | cpu_0_data_master_arbiterlock);
  //rdv_fifo_for_vga_read_master_to_sdram_s1, which is an e_fifo_with_registered_outputs
  rdv_fifo_for_vga_read_master_to_sdram_s1_module rdv_fifo_for_vga_read_master_to_sdram_s1
    (
      .clear_fifo           (1'b0),
      .clk                  (clk),
      .data_in              (vga_read_master_granted_sdram_s1),
      .data_out             (vga_read_master_rdv_fifo_output_from_sdram_s1),
      .empty                (),
      .fifo_contains_ones_n (vga_read_master_rdv_fifo_empty_sdram_s1),
      .full                 (),
      .read                 (sdram_s1_move_on_to_next_transaction),
      .reset_n              (reset_n),
      .sync_reset           (1'b0),
      .write                (in_a_read_cycle & ~sdram_s1_waits_for_read)
    );

  assign vga_read_master_read_data_valid_sdram_s1_shift_register = ~vga_read_master_rdv_fifo_empty_sdram_s1;
  //local readdatavalid vga_read_master_read_data_valid_sdram_s1, which is an e_mux
  assign vga_read_master_read_data_valid_sdram_s1 = (sdram_s1_readdatavalid_from_sa & vga_read_master_rdv_fifo_output_from_sdram_s1) & ~ vga_read_master_rdv_fifo_empty_sdram_s1;

  //allow new arb cycle for sdram/s1, which is an e_assign
  assign sdram_s1_allow_new_arb_cycle = ~cpu_0_data_master_arbiterlock & ~vga_read_master_arbiterlock;

  //vga/read_master assignment into master qualified-requests vector for sdram/s1, which is an e_assign
  assign sdram_s1_master_qreq_vector[0] = vga_read_master_qualified_request_sdram_s1;

  //vga/read_master grant sdram/s1, which is an e_assign
  assign vga_read_master_granted_sdram_s1 = sdram_s1_grant_vector[0];

  //vga/read_master saved-grant sdram/s1, which is an e_assign
  assign vga_read_master_saved_grant_sdram_s1 = sdram_s1_arb_winner[0] && vga_read_master_requests_sdram_s1;

  //cpu_0/data_master assignment into master qualified-requests vector for sdram/s1, which is an e_assign
  assign sdram_s1_master_qreq_vector[1] = cpu_0_data_master_qualified_request_sdram_s1;

  //cpu_0/data_master grant sdram/s1, which is an e_assign
  assign cpu_0_data_master_granted_sdram_s1 = sdram_s1_grant_vector[1];

  //cpu_0/data_master saved-grant sdram/s1, which is an e_assign
  assign cpu_0_data_master_saved_grant_sdram_s1 = sdram_s1_arb_winner[1] && cpu_0_data_master_requests_sdram_s1;

  //sdram/s1 chosen-master double-vector, which is an e_assign
  assign sdram_s1_chosen_master_double_vector = {sdram_s1_master_qreq_vector, sdram_s1_master_qreq_vector} & ({~sdram_s1_master_qreq_vector, ~sdram_s1_master_qreq_vector} + sdram_s1_arb_addend);

  //stable onehot encoding of arb winner
  assign sdram_s1_arb_winner = (sdram_s1_allow_new_arb_cycle & | sdram_s1_grant_vector) ? sdram_s1_grant_vector : sdram_s1_saved_chosen_master_vector;

  //saved sdram_s1_grant_vector, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_saved_chosen_master_vector <= 0;
      else if (sdram_s1_allow_new_arb_cycle)
          sdram_s1_saved_chosen_master_vector <= |sdram_s1_grant_vector ? sdram_s1_grant_vector : sdram_s1_saved_chosen_master_vector;
    end


  //onehot encoding of chosen master
  assign sdram_s1_grant_vector = {(sdram_s1_chosen_master_double_vector[1] | sdram_s1_chosen_master_double_vector[3]),
    (sdram_s1_chosen_master_double_vector[0] | sdram_s1_chosen_master_double_vector[2])};

  //sdram/s1 chosen master rotated left, which is an e_assign
  assign sdram_s1_chosen_master_rot_left = (sdram_s1_arb_winner << 1) ? (sdram_s1_arb_winner << 1) : 1;

  //sdram/s1's addend for next-master-grant
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_arb_addend <= 1;
      else if (|sdram_s1_grant_vector)
          sdram_s1_arb_addend <= sdram_s1_end_xfer? sdram_s1_chosen_master_rot_left : sdram_s1_grant_vector;
    end


  //sdram_s1_reset_n assignment, which is an e_assign
  assign sdram_s1_reset_n = reset_n;

  assign sdram_s1_chipselect = cpu_0_data_master_granted_sdram_s1 | vga_read_master_granted_sdram_s1;
  //sdram_s1_firsttransfer first transaction, which is an e_assign
  assign sdram_s1_firsttransfer = sdram_s1_begins_xfer ? sdram_s1_unreg_firsttransfer : sdram_s1_reg_firsttransfer;

  //sdram_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign sdram_s1_unreg_firsttransfer = ~(sdram_s1_slavearbiterlockenable & sdram_s1_any_continuerequest);

  //sdram_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_reg_firsttransfer <= 1'b1;
      else if (sdram_s1_begins_xfer)
          sdram_s1_reg_firsttransfer <= sdram_s1_unreg_firsttransfer;
    end


  //sdram_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign sdram_s1_beginbursttransfer_internal = sdram_s1_begins_xfer;

  //sdram_s1_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  assign sdram_s1_arbitration_holdoff_internal = sdram_s1_begins_xfer & sdram_s1_firsttransfer;

  //~sdram_s1_read_n assignment, which is an e_mux
  assign sdram_s1_read_n = ~((cpu_0_data_master_granted_sdram_s1 & cpu_0_data_master_read) | (vga_read_master_granted_sdram_s1 & vga_read_master_read));

  //~sdram_s1_write_n assignment, which is an e_mux
  assign sdram_s1_write_n = ~(cpu_0_data_master_granted_sdram_s1 & cpu_0_data_master_write);

  assign shifted_address_to_sdram_s1_from_cpu_0_data_master = {cpu_0_data_master_address_to_slave >> 2,
    cpu_0_data_master_dbs_address[1],
    {1 {1'b0}}};

  //sdram_s1_address mux, which is an e_mux
  assign sdram_s1_address = (cpu_0_data_master_granted_sdram_s1)? (shifted_address_to_sdram_s1_from_cpu_0_data_master >> 1) :
    (shifted_address_to_sdram_s1_from_vga_read_master >> 1);

  assign shifted_address_to_sdram_s1_from_vga_read_master = {vga_read_master_address_to_slave >> 2,
    vga_read_master_dbs_address[1],
    {1 {1'b0}}};

  //d1_sdram_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_sdram_s1_end_xfer <= 1;
      else if (1)
          d1_sdram_s1_end_xfer <= sdram_s1_end_xfer;
    end


  //sdram_s1_waits_for_read in a cycle, which is an e_mux
  assign sdram_s1_waits_for_read = sdram_s1_in_a_read_cycle & sdram_s1_waitrequest_from_sa;

  //sdram_s1_in_a_read_cycle assignment, which is an e_assign
  assign sdram_s1_in_a_read_cycle = (cpu_0_data_master_granted_sdram_s1 & cpu_0_data_master_read) | (vga_read_master_granted_sdram_s1 & vga_read_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = sdram_s1_in_a_read_cycle;

  //sdram_s1_waits_for_write in a cycle, which is an e_mux
  assign sdram_s1_waits_for_write = sdram_s1_in_a_write_cycle & sdram_s1_waitrequest_from_sa;

  //sdram_s1_in_a_write_cycle assignment, which is an e_assign
  assign sdram_s1_in_a_write_cycle = cpu_0_data_master_granted_sdram_s1 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = sdram_s1_in_a_write_cycle;

  assign wait_for_sdram_s1_counter = 0;
  //~sdram_s1_byteenable_n byte enable port mux, which is an e_mux
  assign sdram_s1_byteenable_n = ~((cpu_0_data_master_granted_sdram_s1)? cpu_0_data_master_byteenable_sdram_s1 :
    -1);

  assign {cpu_0_data_master_byteenable_sdram_s1_segment_1,
cpu_0_data_master_byteenable_sdram_s1_segment_0} = cpu_0_data_master_byteenable;
  assign cpu_0_data_master_byteenable_sdram_s1 = ((cpu_0_data_master_dbs_address[1] == 0))? cpu_0_data_master_byteenable_sdram_s1_segment_0 :
    cpu_0_data_master_byteenable_sdram_s1_segment_1;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //sdram/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end


  //grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_0_data_master_granted_sdram_s1 + vga_read_master_granted_sdram_s1 > 1)
        begin
          $write("%0d ns: > 1 of grant signals are active simultaneously", $time);
          $stop;
        end
    end


  //saved_grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_0_data_master_saved_grant_sdram_s1 + vga_read_master_saved_grant_sdram_s1 > 1)
        begin
          $write("%0d ns: > 1 of saved_grant signals are active simultaneously", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module sram_0_avalon_slave_0_arbitrator (
                                          // inputs:
                                           clk,
                                           cpu_0_data_master_address_to_slave,
                                           cpu_0_data_master_byteenable,
                                           cpu_0_data_master_dbs_address,
                                           cpu_0_data_master_dbs_write_16,
                                           cpu_0_data_master_no_byte_enables_and_last_term,
                                           cpu_0_data_master_read,
                                           cpu_0_data_master_write,
                                           cpu_0_instruction_master_address_to_slave,
                                           cpu_0_instruction_master_dbs_address,
                                           cpu_0_instruction_master_latency_counter,
                                           cpu_0_instruction_master_read,
                                           reset_n,
                                           sram_0_avalon_slave_0_readdata,

                                          // outputs:
                                           cpu_0_data_master_byteenable_sram_0_avalon_slave_0,
                                           cpu_0_data_master_granted_sram_0_avalon_slave_0,
                                           cpu_0_data_master_qualified_request_sram_0_avalon_slave_0,
                                           cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0,
                                           cpu_0_data_master_requests_sram_0_avalon_slave_0,
                                           cpu_0_instruction_master_granted_sram_0_avalon_slave_0,
                                           cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0,
                                           cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0,
                                           cpu_0_instruction_master_requests_sram_0_avalon_slave_0,
                                           d1_sram_0_avalon_slave_0_end_xfer,
                                           sram_0_avalon_slave_0_address,
                                           sram_0_avalon_slave_0_byteenable_n,
                                           sram_0_avalon_slave_0_chipselect_n,
                                           sram_0_avalon_slave_0_read_n,
                                           sram_0_avalon_slave_0_readdata_from_sa,
                                           sram_0_avalon_slave_0_wait_counter_eq_0,
                                           sram_0_avalon_slave_0_write_n,
                                           sram_0_avalon_slave_0_writedata
                                        )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [  1: 0] cpu_0_data_master_byteenable_sram_0_avalon_slave_0;
  output           cpu_0_data_master_granted_sram_0_avalon_slave_0;
  output           cpu_0_data_master_qualified_request_sram_0_avalon_slave_0;
  output           cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0;
  output           cpu_0_data_master_requests_sram_0_avalon_slave_0;
  output           cpu_0_instruction_master_granted_sram_0_avalon_slave_0;
  output           cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0;
  output           cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0;
  output           cpu_0_instruction_master_requests_sram_0_avalon_slave_0;
  output           d1_sram_0_avalon_slave_0_end_xfer;
  output  [ 17: 0] sram_0_avalon_slave_0_address;
  output  [  1: 0] sram_0_avalon_slave_0_byteenable_n;
  output           sram_0_avalon_slave_0_chipselect_n;
  output           sram_0_avalon_slave_0_read_n;
  output  [ 15: 0] sram_0_avalon_slave_0_readdata_from_sa;
  output           sram_0_avalon_slave_0_wait_counter_eq_0;
  output           sram_0_avalon_slave_0_write_n;
  output  [ 15: 0] sram_0_avalon_slave_0_writedata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input   [  3: 0] cpu_0_data_master_byteenable;
  input   [  1: 0] cpu_0_data_master_dbs_address;
  input   [ 15: 0] cpu_0_data_master_dbs_write_16;
  input            cpu_0_data_master_no_byte_enables_and_last_term;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_write;
  input   [ 23: 0] cpu_0_instruction_master_address_to_slave;
  input   [  1: 0] cpu_0_instruction_master_dbs_address;
  input            cpu_0_instruction_master_latency_counter;
  input            cpu_0_instruction_master_read;
  input            reset_n;
  input   [ 15: 0] sram_0_avalon_slave_0_readdata;

  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire    [  1: 0] cpu_0_data_master_byteenable_sram_0_avalon_slave_0;
  wire    [  1: 0] cpu_0_data_master_byteenable_sram_0_avalon_slave_0_segment_0;
  wire    [  1: 0] cpu_0_data_master_byteenable_sram_0_avalon_slave_0_segment_1;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_requests_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_saved_grant_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_arbiterlock;
  wire             cpu_0_instruction_master_arbiterlock2;
  wire             cpu_0_instruction_master_continuerequest;
  wire             cpu_0_instruction_master_granted_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_requests_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_saved_grant_sram_0_avalon_slave_0;
  reg              d1_reasons_to_wait;
  reg              d1_sram_0_avalon_slave_0_end_xfer;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_sram_0_avalon_slave_0;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  reg              last_cycle_cpu_0_data_master_granted_slave_sram_0_avalon_slave_0;
  reg              last_cycle_cpu_0_instruction_master_granted_slave_sram_0_avalon_slave_0;
  wire    [ 23: 0] shifted_address_to_sram_0_avalon_slave_0_from_cpu_0_data_master;
  wire    [ 23: 0] shifted_address_to_sram_0_avalon_slave_0_from_cpu_0_instruction_master;
  wire    [ 17: 0] sram_0_avalon_slave_0_address;
  wire             sram_0_avalon_slave_0_allgrants;
  wire             sram_0_avalon_slave_0_allow_new_arb_cycle;
  wire             sram_0_avalon_slave_0_any_bursting_master_saved_grant;
  wire             sram_0_avalon_slave_0_any_continuerequest;
  reg     [  1: 0] sram_0_avalon_slave_0_arb_addend;
  wire             sram_0_avalon_slave_0_arb_counter_enable;
  reg     [  1: 0] sram_0_avalon_slave_0_arb_share_counter;
  wire    [  1: 0] sram_0_avalon_slave_0_arb_share_counter_next_value;
  wire    [  1: 0] sram_0_avalon_slave_0_arb_share_set_values;
  wire    [  1: 0] sram_0_avalon_slave_0_arb_winner;
  wire             sram_0_avalon_slave_0_arbitration_holdoff_internal;
  wire             sram_0_avalon_slave_0_beginbursttransfer_internal;
  wire             sram_0_avalon_slave_0_begins_xfer;
  wire    [  1: 0] sram_0_avalon_slave_0_byteenable_n;
  wire             sram_0_avalon_slave_0_chipselect_n;
  wire    [  3: 0] sram_0_avalon_slave_0_chosen_master_double_vector;
  wire    [  1: 0] sram_0_avalon_slave_0_chosen_master_rot_left;
  wire             sram_0_avalon_slave_0_counter_load_value;
  wire             sram_0_avalon_slave_0_end_xfer;
  wire             sram_0_avalon_slave_0_firsttransfer;
  wire    [  1: 0] sram_0_avalon_slave_0_grant_vector;
  wire             sram_0_avalon_slave_0_in_a_read_cycle;
  wire             sram_0_avalon_slave_0_in_a_write_cycle;
  wire    [  1: 0] sram_0_avalon_slave_0_master_qreq_vector;
  wire             sram_0_avalon_slave_0_non_bursting_master_requests;
  wire             sram_0_avalon_slave_0_read_n;
  wire    [ 15: 0] sram_0_avalon_slave_0_readdata_from_sa;
  reg              sram_0_avalon_slave_0_reg_firsttransfer;
  reg     [  1: 0] sram_0_avalon_slave_0_saved_chosen_master_vector;
  reg              sram_0_avalon_slave_0_slavearbiterlockenable;
  wire             sram_0_avalon_slave_0_slavearbiterlockenable2;
  wire             sram_0_avalon_slave_0_unreg_firsttransfer;
  reg              sram_0_avalon_slave_0_wait_counter;
  wire             sram_0_avalon_slave_0_wait_counter_eq_0;
  wire             sram_0_avalon_slave_0_waits_for_read;
  wire             sram_0_avalon_slave_0_waits_for_write;
  wire             sram_0_avalon_slave_0_write_n;
  wire    [ 15: 0] sram_0_avalon_slave_0_writedata;
  wire             wait_for_sram_0_avalon_slave_0_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~sram_0_avalon_slave_0_end_xfer;
    end


  assign sram_0_avalon_slave_0_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_sram_0_avalon_slave_0 | cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0));
  //assign sram_0_avalon_slave_0_readdata_from_sa = sram_0_avalon_slave_0_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sram_0_avalon_slave_0_readdata_from_sa = sram_0_avalon_slave_0_readdata;

  assign cpu_0_data_master_requests_sram_0_avalon_slave_0 = ({cpu_0_data_master_address_to_slave[23 : 19] , 19'b0} == 24'h880000) & (cpu_0_data_master_read | cpu_0_data_master_write);
  //sram_0_avalon_slave_0_arb_share_counter set values, which is an e_mux
  assign sram_0_avalon_slave_0_arb_share_set_values = (cpu_0_data_master_granted_sram_0_avalon_slave_0)? 2 :
    (cpu_0_instruction_master_granted_sram_0_avalon_slave_0)? 2 :
    (cpu_0_data_master_granted_sram_0_avalon_slave_0)? 2 :
    (cpu_0_instruction_master_granted_sram_0_avalon_slave_0)? 2 :
    1;

  //sram_0_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  assign sram_0_avalon_slave_0_non_bursting_master_requests = cpu_0_data_master_requests_sram_0_avalon_slave_0 |
    cpu_0_instruction_master_requests_sram_0_avalon_slave_0 |
    cpu_0_data_master_requests_sram_0_avalon_slave_0 |
    cpu_0_instruction_master_requests_sram_0_avalon_slave_0;

  //sram_0_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  assign sram_0_avalon_slave_0_any_bursting_master_saved_grant = 0;

  //sram_0_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  assign sram_0_avalon_slave_0_arb_share_counter_next_value = sram_0_avalon_slave_0_firsttransfer ? (sram_0_avalon_slave_0_arb_share_set_values - 1) : |sram_0_avalon_slave_0_arb_share_counter ? (sram_0_avalon_slave_0_arb_share_counter - 1) : 0;

  //sram_0_avalon_slave_0_allgrants all slave grants, which is an e_mux
  assign sram_0_avalon_slave_0_allgrants = |sram_0_avalon_slave_0_grant_vector |
    |sram_0_avalon_slave_0_grant_vector |
    |sram_0_avalon_slave_0_grant_vector |
    |sram_0_avalon_slave_0_grant_vector;

  //sram_0_avalon_slave_0_end_xfer assignment, which is an e_assign
  assign sram_0_avalon_slave_0_end_xfer = ~(sram_0_avalon_slave_0_waits_for_read | sram_0_avalon_slave_0_waits_for_write);

  //end_xfer_arb_share_counter_term_sram_0_avalon_slave_0 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_sram_0_avalon_slave_0 = sram_0_avalon_slave_0_end_xfer & (~sram_0_avalon_slave_0_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //sram_0_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  assign sram_0_avalon_slave_0_arb_counter_enable = (end_xfer_arb_share_counter_term_sram_0_avalon_slave_0 & sram_0_avalon_slave_0_allgrants) | (end_xfer_arb_share_counter_term_sram_0_avalon_slave_0 & ~sram_0_avalon_slave_0_non_bursting_master_requests);

  //sram_0_avalon_slave_0_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_0_avalon_slave_0_arb_share_counter <= 0;
      else if (sram_0_avalon_slave_0_arb_counter_enable)
          sram_0_avalon_slave_0_arb_share_counter <= sram_0_avalon_slave_0_arb_share_counter_next_value;
    end


  //sram_0_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_0_avalon_slave_0_slavearbiterlockenable <= 0;
      else if ((|sram_0_avalon_slave_0_master_qreq_vector & end_xfer_arb_share_counter_term_sram_0_avalon_slave_0) | (end_xfer_arb_share_counter_term_sram_0_avalon_slave_0 & ~sram_0_avalon_slave_0_non_bursting_master_requests))
          sram_0_avalon_slave_0_slavearbiterlockenable <= |sram_0_avalon_slave_0_arb_share_counter_next_value;
    end


  //cpu_0/data_master sram_0/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = sram_0_avalon_slave_0_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //sram_0_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign sram_0_avalon_slave_0_slavearbiterlockenable2 = |sram_0_avalon_slave_0_arb_share_counter_next_value;

  //cpu_0/data_master sram_0/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = sram_0_avalon_slave_0_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //cpu_0/instruction_master sram_0/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_0_instruction_master_arbiterlock = sram_0_avalon_slave_0_slavearbiterlockenable & cpu_0_instruction_master_continuerequest;

  //cpu_0/instruction_master sram_0/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_0_instruction_master_arbiterlock2 = sram_0_avalon_slave_0_slavearbiterlockenable2 & cpu_0_instruction_master_continuerequest;

  //cpu_0/instruction_master granted sram_0/avalon_slave_0 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_0_instruction_master_granted_slave_sram_0_avalon_slave_0 <= 0;
      else if (1)
          last_cycle_cpu_0_instruction_master_granted_slave_sram_0_avalon_slave_0 <= cpu_0_instruction_master_saved_grant_sram_0_avalon_slave_0 ? 1 : (sram_0_avalon_slave_0_arbitration_holdoff_internal | ~cpu_0_instruction_master_requests_sram_0_avalon_slave_0) ? 0 : last_cycle_cpu_0_instruction_master_granted_slave_sram_0_avalon_slave_0;
    end


  //cpu_0_instruction_master_continuerequest continued request, which is an e_mux
  assign cpu_0_instruction_master_continuerequest = last_cycle_cpu_0_instruction_master_granted_slave_sram_0_avalon_slave_0 & cpu_0_instruction_master_requests_sram_0_avalon_slave_0;

  //sram_0_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_mux
  assign sram_0_avalon_slave_0_any_continuerequest = cpu_0_instruction_master_continuerequest |
    cpu_0_data_master_continuerequest;

  assign cpu_0_data_master_qualified_request_sram_0_avalon_slave_0 = cpu_0_data_master_requests_sram_0_avalon_slave_0 & ~(((cpu_0_data_master_no_byte_enables_and_last_term | !cpu_0_data_master_byteenable_sram_0_avalon_slave_0) & cpu_0_data_master_write) | cpu_0_instruction_master_arbiterlock);
  //sram_0_avalon_slave_0_writedata mux, which is an e_mux
  assign sram_0_avalon_slave_0_writedata = cpu_0_data_master_dbs_write_16;

  assign cpu_0_instruction_master_requests_sram_0_avalon_slave_0 = (({cpu_0_instruction_master_address_to_slave[23 : 19] , 19'b0} == 24'h880000) & (cpu_0_instruction_master_read)) & cpu_0_instruction_master_read;
  //cpu_0/data_master granted sram_0/avalon_slave_0 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_0_data_master_granted_slave_sram_0_avalon_slave_0 <= 0;
      else if (1)
          last_cycle_cpu_0_data_master_granted_slave_sram_0_avalon_slave_0 <= cpu_0_data_master_saved_grant_sram_0_avalon_slave_0 ? 1 : (sram_0_avalon_slave_0_arbitration_holdoff_internal | ~cpu_0_data_master_requests_sram_0_avalon_slave_0) ? 0 : last_cycle_cpu_0_data_master_granted_slave_sram_0_avalon_slave_0;
    end


  //cpu_0_data_master_continuerequest continued request, which is an e_mux
  assign cpu_0_data_master_continuerequest = last_cycle_cpu_0_data_master_granted_slave_sram_0_avalon_slave_0 & cpu_0_data_master_requests_sram_0_avalon_slave_0;

  assign cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0 = cpu_0_instruction_master_requests_sram_0_avalon_slave_0 & ~((cpu_0_instruction_master_read & ((cpu_0_instruction_master_latency_counter != 0))) | cpu_0_data_master_arbiterlock);
  //local readdatavalid cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0, which is an e_mux
  assign cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0 = cpu_0_instruction_master_granted_sram_0_avalon_slave_0 & cpu_0_instruction_master_read & ~sram_0_avalon_slave_0_waits_for_read;

  //allow new arb cycle for sram_0/avalon_slave_0, which is an e_assign
  assign sram_0_avalon_slave_0_allow_new_arb_cycle = ~cpu_0_data_master_arbiterlock & ~cpu_0_instruction_master_arbiterlock;

  //cpu_0/instruction_master assignment into master qualified-requests vector for sram_0/avalon_slave_0, which is an e_assign
  assign sram_0_avalon_slave_0_master_qreq_vector[0] = cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0;

  //cpu_0/instruction_master grant sram_0/avalon_slave_0, which is an e_assign
  assign cpu_0_instruction_master_granted_sram_0_avalon_slave_0 = sram_0_avalon_slave_0_grant_vector[0];

  //cpu_0/instruction_master saved-grant sram_0/avalon_slave_0, which is an e_assign
  assign cpu_0_instruction_master_saved_grant_sram_0_avalon_slave_0 = sram_0_avalon_slave_0_arb_winner[0] && cpu_0_instruction_master_requests_sram_0_avalon_slave_0;

  //cpu_0/data_master assignment into master qualified-requests vector for sram_0/avalon_slave_0, which is an e_assign
  assign sram_0_avalon_slave_0_master_qreq_vector[1] = cpu_0_data_master_qualified_request_sram_0_avalon_slave_0;

  //cpu_0/data_master grant sram_0/avalon_slave_0, which is an e_assign
  assign cpu_0_data_master_granted_sram_0_avalon_slave_0 = sram_0_avalon_slave_0_grant_vector[1];

  //cpu_0/data_master saved-grant sram_0/avalon_slave_0, which is an e_assign
  assign cpu_0_data_master_saved_grant_sram_0_avalon_slave_0 = sram_0_avalon_slave_0_arb_winner[1] && cpu_0_data_master_requests_sram_0_avalon_slave_0;

  //sram_0/avalon_slave_0 chosen-master double-vector, which is an e_assign
  assign sram_0_avalon_slave_0_chosen_master_double_vector = {sram_0_avalon_slave_0_master_qreq_vector, sram_0_avalon_slave_0_master_qreq_vector} & ({~sram_0_avalon_slave_0_master_qreq_vector, ~sram_0_avalon_slave_0_master_qreq_vector} + sram_0_avalon_slave_0_arb_addend);

  //stable onehot encoding of arb winner
  assign sram_0_avalon_slave_0_arb_winner = (sram_0_avalon_slave_0_allow_new_arb_cycle & | sram_0_avalon_slave_0_grant_vector) ? sram_0_avalon_slave_0_grant_vector : sram_0_avalon_slave_0_saved_chosen_master_vector;

  //saved sram_0_avalon_slave_0_grant_vector, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_0_avalon_slave_0_saved_chosen_master_vector <= 0;
      else if (sram_0_avalon_slave_0_allow_new_arb_cycle)
          sram_0_avalon_slave_0_saved_chosen_master_vector <= |sram_0_avalon_slave_0_grant_vector ? sram_0_avalon_slave_0_grant_vector : sram_0_avalon_slave_0_saved_chosen_master_vector;
    end


  //onehot encoding of chosen master
  assign sram_0_avalon_slave_0_grant_vector = {(sram_0_avalon_slave_0_chosen_master_double_vector[1] | sram_0_avalon_slave_0_chosen_master_double_vector[3]),
    (sram_0_avalon_slave_0_chosen_master_double_vector[0] | sram_0_avalon_slave_0_chosen_master_double_vector[2])};

  //sram_0/avalon_slave_0 chosen master rotated left, which is an e_assign
  assign sram_0_avalon_slave_0_chosen_master_rot_left = (sram_0_avalon_slave_0_arb_winner << 1) ? (sram_0_avalon_slave_0_arb_winner << 1) : 1;

  //sram_0/avalon_slave_0's addend for next-master-grant
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_0_avalon_slave_0_arb_addend <= 1;
      else if (|sram_0_avalon_slave_0_grant_vector)
          sram_0_avalon_slave_0_arb_addend <= sram_0_avalon_slave_0_end_xfer? sram_0_avalon_slave_0_chosen_master_rot_left : sram_0_avalon_slave_0_grant_vector;
    end


  assign sram_0_avalon_slave_0_chipselect_n = ~(cpu_0_data_master_granted_sram_0_avalon_slave_0 | cpu_0_instruction_master_granted_sram_0_avalon_slave_0);
  //sram_0_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  assign sram_0_avalon_slave_0_firsttransfer = sram_0_avalon_slave_0_begins_xfer ? sram_0_avalon_slave_0_unreg_firsttransfer : sram_0_avalon_slave_0_reg_firsttransfer;

  //sram_0_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  assign sram_0_avalon_slave_0_unreg_firsttransfer = ~(sram_0_avalon_slave_0_slavearbiterlockenable & sram_0_avalon_slave_0_any_continuerequest);

  //sram_0_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_0_avalon_slave_0_reg_firsttransfer <= 1'b1;
      else if (sram_0_avalon_slave_0_begins_xfer)
          sram_0_avalon_slave_0_reg_firsttransfer <= sram_0_avalon_slave_0_unreg_firsttransfer;
    end


  //sram_0_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign sram_0_avalon_slave_0_beginbursttransfer_internal = sram_0_avalon_slave_0_begins_xfer;

  //sram_0_avalon_slave_0_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  assign sram_0_avalon_slave_0_arbitration_holdoff_internal = sram_0_avalon_slave_0_begins_xfer & sram_0_avalon_slave_0_firsttransfer;

  //~sram_0_avalon_slave_0_read_n assignment, which is an e_mux
  assign sram_0_avalon_slave_0_read_n = ~(((cpu_0_data_master_granted_sram_0_avalon_slave_0 & cpu_0_data_master_read) | (cpu_0_instruction_master_granted_sram_0_avalon_slave_0 & cpu_0_instruction_master_read))& ~sram_0_avalon_slave_0_begins_xfer);

  //~sram_0_avalon_slave_0_write_n assignment, which is an e_mux
  assign sram_0_avalon_slave_0_write_n = ~(((cpu_0_data_master_granted_sram_0_avalon_slave_0 & cpu_0_data_master_write)) & ~sram_0_avalon_slave_0_begins_xfer & (sram_0_avalon_slave_0_wait_counter >= 1));

  assign shifted_address_to_sram_0_avalon_slave_0_from_cpu_0_data_master = {cpu_0_data_master_address_to_slave >> 2,
    cpu_0_data_master_dbs_address[1],
    {1 {1'b0}}};

  //sram_0_avalon_slave_0_address mux, which is an e_mux
  assign sram_0_avalon_slave_0_address = (cpu_0_data_master_granted_sram_0_avalon_slave_0)? (shifted_address_to_sram_0_avalon_slave_0_from_cpu_0_data_master >> 1) :
    (shifted_address_to_sram_0_avalon_slave_0_from_cpu_0_instruction_master >> 1);

  assign shifted_address_to_sram_0_avalon_slave_0_from_cpu_0_instruction_master = {cpu_0_instruction_master_address_to_slave >> 2,
    cpu_0_instruction_master_dbs_address[1],
    {1 {1'b0}}};

  //d1_sram_0_avalon_slave_0_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_sram_0_avalon_slave_0_end_xfer <= 1;
      else if (1)
          d1_sram_0_avalon_slave_0_end_xfer <= sram_0_avalon_slave_0_end_xfer;
    end


  //sram_0_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  assign sram_0_avalon_slave_0_waits_for_read = sram_0_avalon_slave_0_in_a_read_cycle & sram_0_avalon_slave_0_begins_xfer;

  //sram_0_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  assign sram_0_avalon_slave_0_in_a_read_cycle = (cpu_0_data_master_granted_sram_0_avalon_slave_0 & cpu_0_data_master_read) | (cpu_0_instruction_master_granted_sram_0_avalon_slave_0 & cpu_0_instruction_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = sram_0_avalon_slave_0_in_a_read_cycle;

  //sram_0_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  assign sram_0_avalon_slave_0_waits_for_write = sram_0_avalon_slave_0_in_a_write_cycle & wait_for_sram_0_avalon_slave_0_counter;

  //sram_0_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  assign sram_0_avalon_slave_0_in_a_write_cycle = cpu_0_data_master_granted_sram_0_avalon_slave_0 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = sram_0_avalon_slave_0_in_a_write_cycle;

  assign sram_0_avalon_slave_0_wait_counter_eq_0 = sram_0_avalon_slave_0_wait_counter == 0;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_0_avalon_slave_0_wait_counter <= 0;
      else if (1)
          sram_0_avalon_slave_0_wait_counter <= sram_0_avalon_slave_0_counter_load_value;
    end


  assign sram_0_avalon_slave_0_counter_load_value = ((sram_0_avalon_slave_0_in_a_write_cycle & sram_0_avalon_slave_0_begins_xfer))? 1 :
    (~sram_0_avalon_slave_0_wait_counter_eq_0)? sram_0_avalon_slave_0_wait_counter - 1 :
    0;

  assign wait_for_sram_0_avalon_slave_0_counter = sram_0_avalon_slave_0_begins_xfer | ~sram_0_avalon_slave_0_wait_counter_eq_0;
  //~sram_0_avalon_slave_0_byteenable_n byte enable port mux, which is an e_mux
  assign sram_0_avalon_slave_0_byteenable_n = ~((cpu_0_data_master_granted_sram_0_avalon_slave_0)? cpu_0_data_master_byteenable_sram_0_avalon_slave_0 :
    -1);

  assign {cpu_0_data_master_byteenable_sram_0_avalon_slave_0_segment_1,
cpu_0_data_master_byteenable_sram_0_avalon_slave_0_segment_0} = cpu_0_data_master_byteenable;
  assign cpu_0_data_master_byteenable_sram_0_avalon_slave_0 = ((cpu_0_data_master_dbs_address[1] == 0))? cpu_0_data_master_byteenable_sram_0_avalon_slave_0_segment_0 :
    cpu_0_data_master_byteenable_sram_0_avalon_slave_0_segment_1;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //sram_0/avalon_slave_0 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end


  //grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_0_data_master_granted_sram_0_avalon_slave_0 + cpu_0_instruction_master_granted_sram_0_avalon_slave_0 > 1)
        begin
          $write("%0d ns: > 1 of grant signals are active simultaneously", $time);
          $stop;
        end
    end


  //saved_grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_0_data_master_saved_grant_sram_0_avalon_slave_0 + cpu_0_instruction_master_saved_grant_sram_0_avalon_slave_0 > 1)
        begin
          $write("%0d ns: > 1 of saved_grant signals are active simultaneously", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module vga_avalon_slave_0_arbitrator (
                                       // inputs:
                                        clk,
                                        cpu_0_data_master_address_to_slave,
                                        cpu_0_data_master_read,
                                        cpu_0_data_master_waitrequest,
                                        cpu_0_data_master_write,
                                        cpu_0_data_master_writedata,
                                        reset_n,

                                       // outputs:
                                        cpu_0_data_master_granted_vga_avalon_slave_0,
                                        cpu_0_data_master_qualified_request_vga_avalon_slave_0,
                                        cpu_0_data_master_read_data_valid_vga_avalon_slave_0,
                                        cpu_0_data_master_requests_vga_avalon_slave_0,
                                        d1_vga_avalon_slave_0_end_xfer,
                                        vga_avalon_slave_0_address,
                                        vga_avalon_slave_0_chipselect,
                                        vga_avalon_slave_0_reset,
                                        vga_avalon_slave_0_write,
                                        vga_avalon_slave_0_writedata
                                     )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           cpu_0_data_master_granted_vga_avalon_slave_0;
  output           cpu_0_data_master_qualified_request_vga_avalon_slave_0;
  output           cpu_0_data_master_read_data_valid_vga_avalon_slave_0;
  output           cpu_0_data_master_requests_vga_avalon_slave_0;
  output           d1_vga_avalon_slave_0_end_xfer;
  output           vga_avalon_slave_0_address;
  output           vga_avalon_slave_0_chipselect;
  output           vga_avalon_slave_0_reset;
  output           vga_avalon_slave_0_write;
  output  [ 31: 0] vga_avalon_slave_0_writedata;
  input            clk;
  input   [ 23: 0] cpu_0_data_master_address_to_slave;
  input            cpu_0_data_master_read;
  input            cpu_0_data_master_waitrequest;
  input            cpu_0_data_master_write;
  input   [ 31: 0] cpu_0_data_master_writedata;
  input            reset_n;

  wire             cpu_0_data_master_arbiterlock;
  wire             cpu_0_data_master_arbiterlock2;
  wire             cpu_0_data_master_continuerequest;
  wire             cpu_0_data_master_granted_vga_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_vga_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_vga_avalon_slave_0;
  wire             cpu_0_data_master_requests_vga_avalon_slave_0;
  wire             cpu_0_data_master_saved_grant_vga_avalon_slave_0;
  reg              d1_reasons_to_wait;
  reg              d1_vga_avalon_slave_0_end_xfer;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_vga_avalon_slave_0;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 23: 0] shifted_address_to_vga_avalon_slave_0_from_cpu_0_data_master;
  wire             vga_avalon_slave_0_address;
  wire             vga_avalon_slave_0_allgrants;
  wire             vga_avalon_slave_0_allow_new_arb_cycle;
  wire             vga_avalon_slave_0_any_bursting_master_saved_grant;
  wire             vga_avalon_slave_0_any_continuerequest;
  wire             vga_avalon_slave_0_arb_counter_enable;
  reg     [  1: 0] vga_avalon_slave_0_arb_share_counter;
  wire    [  1: 0] vga_avalon_slave_0_arb_share_counter_next_value;
  wire    [  1: 0] vga_avalon_slave_0_arb_share_set_values;
  wire             vga_avalon_slave_0_beginbursttransfer_internal;
  wire             vga_avalon_slave_0_begins_xfer;
  wire             vga_avalon_slave_0_chipselect;
  wire             vga_avalon_slave_0_end_xfer;
  wire             vga_avalon_slave_0_firsttransfer;
  wire             vga_avalon_slave_0_grant_vector;
  wire             vga_avalon_slave_0_in_a_read_cycle;
  wire             vga_avalon_slave_0_in_a_write_cycle;
  wire             vga_avalon_slave_0_master_qreq_vector;
  wire             vga_avalon_slave_0_non_bursting_master_requests;
  reg              vga_avalon_slave_0_reg_firsttransfer;
  wire             vga_avalon_slave_0_reset;
  reg              vga_avalon_slave_0_slavearbiterlockenable;
  wire             vga_avalon_slave_0_slavearbiterlockenable2;
  wire             vga_avalon_slave_0_unreg_firsttransfer;
  wire             vga_avalon_slave_0_waits_for_read;
  wire             vga_avalon_slave_0_waits_for_write;
  wire             vga_avalon_slave_0_write;
  wire    [ 31: 0] vga_avalon_slave_0_writedata;
  wire             wait_for_vga_avalon_slave_0_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~vga_avalon_slave_0_end_xfer;
    end


  assign vga_avalon_slave_0_begins_xfer = ~d1_reasons_to_wait & ((cpu_0_data_master_qualified_request_vga_avalon_slave_0));
  assign cpu_0_data_master_requests_vga_avalon_slave_0 = (({cpu_0_data_master_address_to_slave[23 : 3] , 3'b0} == 24'h901050) & (cpu_0_data_master_read | cpu_0_data_master_write)) & cpu_0_data_master_write;
  //vga_avalon_slave_0_arb_share_counter set values, which is an e_mux
  assign vga_avalon_slave_0_arb_share_set_values = 1;

  //vga_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  assign vga_avalon_slave_0_non_bursting_master_requests = cpu_0_data_master_requests_vga_avalon_slave_0;

  //vga_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  assign vga_avalon_slave_0_any_bursting_master_saved_grant = 0;

  //vga_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  assign vga_avalon_slave_0_arb_share_counter_next_value = vga_avalon_slave_0_firsttransfer ? (vga_avalon_slave_0_arb_share_set_values - 1) : |vga_avalon_slave_0_arb_share_counter ? (vga_avalon_slave_0_arb_share_counter - 1) : 0;

  //vga_avalon_slave_0_allgrants all slave grants, which is an e_mux
  assign vga_avalon_slave_0_allgrants = |vga_avalon_slave_0_grant_vector;

  //vga_avalon_slave_0_end_xfer assignment, which is an e_assign
  assign vga_avalon_slave_0_end_xfer = ~(vga_avalon_slave_0_waits_for_read | vga_avalon_slave_0_waits_for_write);

  //end_xfer_arb_share_counter_term_vga_avalon_slave_0 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_vga_avalon_slave_0 = vga_avalon_slave_0_end_xfer & (~vga_avalon_slave_0_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //vga_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  assign vga_avalon_slave_0_arb_counter_enable = (end_xfer_arb_share_counter_term_vga_avalon_slave_0 & vga_avalon_slave_0_allgrants) | (end_xfer_arb_share_counter_term_vga_avalon_slave_0 & ~vga_avalon_slave_0_non_bursting_master_requests);

  //vga_avalon_slave_0_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          vga_avalon_slave_0_arb_share_counter <= 0;
      else if (vga_avalon_slave_0_arb_counter_enable)
          vga_avalon_slave_0_arb_share_counter <= vga_avalon_slave_0_arb_share_counter_next_value;
    end


  //vga_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          vga_avalon_slave_0_slavearbiterlockenable <= 0;
      else if ((|vga_avalon_slave_0_master_qreq_vector & end_xfer_arb_share_counter_term_vga_avalon_slave_0) | (end_xfer_arb_share_counter_term_vga_avalon_slave_0 & ~vga_avalon_slave_0_non_bursting_master_requests))
          vga_avalon_slave_0_slavearbiterlockenable <= |vga_avalon_slave_0_arb_share_counter_next_value;
    end


  //cpu_0/data_master vga/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_0_data_master_arbiterlock = vga_avalon_slave_0_slavearbiterlockenable & cpu_0_data_master_continuerequest;

  //vga_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign vga_avalon_slave_0_slavearbiterlockenable2 = |vga_avalon_slave_0_arb_share_counter_next_value;

  //cpu_0/data_master vga/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_0_data_master_arbiterlock2 = vga_avalon_slave_0_slavearbiterlockenable2 & cpu_0_data_master_continuerequest;

  //vga_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_assign
  assign vga_avalon_slave_0_any_continuerequest = 1;

  //cpu_0_data_master_continuerequest continued request, which is an e_assign
  assign cpu_0_data_master_continuerequest = 1;

  assign cpu_0_data_master_qualified_request_vga_avalon_slave_0 = cpu_0_data_master_requests_vga_avalon_slave_0 & ~(((~cpu_0_data_master_waitrequest) & cpu_0_data_master_write));
  //vga_avalon_slave_0_writedata mux, which is an e_mux
  assign vga_avalon_slave_0_writedata = cpu_0_data_master_writedata;

  //master is always granted when requested
  assign cpu_0_data_master_granted_vga_avalon_slave_0 = cpu_0_data_master_qualified_request_vga_avalon_slave_0;

  //cpu_0/data_master saved-grant vga/avalon_slave_0, which is an e_assign
  assign cpu_0_data_master_saved_grant_vga_avalon_slave_0 = cpu_0_data_master_requests_vga_avalon_slave_0;

  //allow new arb cycle for vga/avalon_slave_0, which is an e_assign
  assign vga_avalon_slave_0_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign vga_avalon_slave_0_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign vga_avalon_slave_0_master_qreq_vector = 1;

  //~vga_avalon_slave_0_reset assignment, which is an e_assign
  assign vga_avalon_slave_0_reset = ~reset_n;

  assign vga_avalon_slave_0_chipselect = cpu_0_data_master_granted_vga_avalon_slave_0;
  //vga_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  assign vga_avalon_slave_0_firsttransfer = vga_avalon_slave_0_begins_xfer ? vga_avalon_slave_0_unreg_firsttransfer : vga_avalon_slave_0_reg_firsttransfer;

  //vga_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  assign vga_avalon_slave_0_unreg_firsttransfer = ~(vga_avalon_slave_0_slavearbiterlockenable & vga_avalon_slave_0_any_continuerequest);

  //vga_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          vga_avalon_slave_0_reg_firsttransfer <= 1'b1;
      else if (vga_avalon_slave_0_begins_xfer)
          vga_avalon_slave_0_reg_firsttransfer <= vga_avalon_slave_0_unreg_firsttransfer;
    end


  //vga_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign vga_avalon_slave_0_beginbursttransfer_internal = vga_avalon_slave_0_begins_xfer;

  //vga_avalon_slave_0_write assignment, which is an e_mux
  assign vga_avalon_slave_0_write = cpu_0_data_master_granted_vga_avalon_slave_0 & cpu_0_data_master_write;

  assign shifted_address_to_vga_avalon_slave_0_from_cpu_0_data_master = cpu_0_data_master_address_to_slave;
  //vga_avalon_slave_0_address mux, which is an e_mux
  assign vga_avalon_slave_0_address = shifted_address_to_vga_avalon_slave_0_from_cpu_0_data_master >> 2;

  //d1_vga_avalon_slave_0_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_vga_avalon_slave_0_end_xfer <= 1;
      else if (1)
          d1_vga_avalon_slave_0_end_xfer <= vga_avalon_slave_0_end_xfer;
    end


  //vga_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  assign vga_avalon_slave_0_waits_for_read = vga_avalon_slave_0_in_a_read_cycle & vga_avalon_slave_0_begins_xfer;

  //vga_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  assign vga_avalon_slave_0_in_a_read_cycle = cpu_0_data_master_granted_vga_avalon_slave_0 & cpu_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = vga_avalon_slave_0_in_a_read_cycle;

  //vga_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  assign vga_avalon_slave_0_waits_for_write = vga_avalon_slave_0_in_a_write_cycle & 0;

  //vga_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  assign vga_avalon_slave_0_in_a_write_cycle = cpu_0_data_master_granted_vga_avalon_slave_0 & cpu_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = vga_avalon_slave_0_in_a_write_cycle;

  assign wait_for_vga_avalon_slave_0_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //vga/avalon_slave_0 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else if (1)
          enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module vga_read_master_arbitrator (
                                    // inputs:
                                     clk,
                                     d1_sdram_s1_end_xfer,
                                     reset_n,
                                     sdram_s1_readdata_from_sa,
                                     sdram_s1_waitrequest_from_sa,
                                     vga_read_master_address,
                                     vga_read_master_granted_sdram_s1,
                                     vga_read_master_qualified_request_sdram_s1,
                                     vga_read_master_read,
                                     vga_read_master_read_data_valid_sdram_s1,
                                     vga_read_master_read_data_valid_sdram_s1_shift_register,
                                     vga_read_master_requests_sdram_s1,

                                    // outputs:
                                     vga_read_master_address_to_slave,
                                     vga_read_master_dbs_address,
                                     vga_read_master_readdata,
                                     vga_read_master_waitrequest
                                  )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [ 31: 0] vga_read_master_address_to_slave;
  output  [  1: 0] vga_read_master_dbs_address;
  output  [ 31: 0] vga_read_master_readdata;
  output           vga_read_master_waitrequest;
  input            clk;
  input            d1_sdram_s1_end_xfer;
  input            reset_n;
  input   [ 15: 0] sdram_s1_readdata_from_sa;
  input            sdram_s1_waitrequest_from_sa;
  input   [ 31: 0] vga_read_master_address;
  input            vga_read_master_granted_sdram_s1;
  input            vga_read_master_qualified_request_sdram_s1;
  input            vga_read_master_read;
  input            vga_read_master_read_data_valid_sdram_s1;
  input            vga_read_master_read_data_valid_sdram_s1_shift_register;
  input            vga_read_master_requests_sdram_s1;

  reg              active_and_waiting_last_time;
  reg     [ 15: 0] dbs_16_reg_segment_0;
  wire             dbs_count_enable;
  wire             dbs_counter_overflow;
  wire    [  1: 0] next_dbs_address;
  wire    [ 15: 0] p1_dbs_16_reg_segment_0;
  wire             pre_dbs_count_enable;
  wire             r_1;
  wire             r_2;
  reg     [ 31: 0] vga_read_master_address_last_time;
  wire    [ 31: 0] vga_read_master_address_to_slave;
  reg     [  1: 0] vga_read_master_dbs_address;
  wire    [  1: 0] vga_read_master_dbs_increment;
  reg              vga_read_master_read_last_time;
  wire    [ 31: 0] vga_read_master_readdata;
  wire             vga_read_master_run;
  wire             vga_read_master_waitrequest;
  //r_1 master_run cascaded wait assignment, which is an e_assign
  assign r_1 = 1 & (vga_read_master_qualified_request_sdram_s1 | (vga_read_master_read_data_valid_sdram_s1 & vga_read_master_dbs_address[1]) | ~vga_read_master_requests_sdram_s1) & (vga_read_master_granted_sdram_s1 | ~vga_read_master_qualified_request_sdram_s1);

  //cascaded wait assignment, which is an e_assign
  assign vga_read_master_run = r_1 & r_2;

  //r_2 master_run cascaded wait assignment, which is an e_assign
  assign r_2 = ~vga_read_master_qualified_request_sdram_s1 | ~vga_read_master_read | (vga_read_master_read_data_valid_sdram_s1 & (vga_read_master_dbs_address[1]) & vga_read_master_read);

  //optimize select-logic by passing only those address bits which matter.
  assign vga_read_master_address_to_slave = {9'b0,
    vga_read_master_address[22 : 0]};

  //input to dbs-16 stored 0, which is an e_mux
  assign p1_dbs_16_reg_segment_0 = sdram_s1_readdata_from_sa;

  //dbs register for dbs-16 segment 0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          dbs_16_reg_segment_0 <= 0;
      else if (dbs_count_enable & ((vga_read_master_dbs_address[1]) == 0))
          dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
    end


  //vga/read_master readdata mux, which is an e_mux
  assign vga_read_master_readdata = {sdram_s1_readdata_from_sa[15 : 0],
    dbs_16_reg_segment_0};

  //actual waitrequest port, which is an e_assign
  assign vga_read_master_waitrequest = ~vga_read_master_run;

  //dbs count increment, which is an e_mux
  assign vga_read_master_dbs_increment = (vga_read_master_requests_sdram_s1)? 2 :
    0;

  //dbs counter overflow, which is an e_assign
  assign dbs_counter_overflow = vga_read_master_dbs_address[1] & !(next_dbs_address[1]);

  //next master address, which is an e_assign
  assign next_dbs_address = vga_read_master_dbs_address + vga_read_master_dbs_increment;

  //dbs count enable, which is an e_mux
  assign dbs_count_enable = pre_dbs_count_enable;

  //dbs counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          vga_read_master_dbs_address <= 0;
      else if (dbs_count_enable)
          vga_read_master_dbs_address <= next_dbs_address;
    end


  //pre dbs count enable, which is an e_mux
  assign pre_dbs_count_enable = vga_read_master_read_data_valid_sdram_s1;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //vga_read_master_address check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          vga_read_master_address_last_time <= 0;
      else if (1)
          vga_read_master_address_last_time <= vga_read_master_address;
    end


  //vga/read_master waited last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          active_and_waiting_last_time <= 0;
      else if (1)
          active_and_waiting_last_time <= vga_read_master_waitrequest & (vga_read_master_read);
    end


  //vga_read_master_address matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or vga_read_master_address or vga_read_master_address_last_time)
    begin
      if (active_and_waiting_last_time & (vga_read_master_address != vga_read_master_address_last_time))
        begin
          $write("%0d ns: vga_read_master_address did not heed wait!!!", $time);
          $stop;
        end
    end


  //vga_read_master_read check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          vga_read_master_read_last_time <= 0;
      else if (1)
          vga_read_master_read_last_time <= vga_read_master_read;
    end


  //vga_read_master_read matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or vga_read_master_read or vga_read_master_read_last_time)
    begin
      if (active_and_waiting_last_time & (vga_read_master_read != vga_read_master_read_last_time))
        begin
          $write("%0d ns: vga_read_master_read did not heed wait!!!", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module system_0_reset_clk_domain_synch_module (
                                                // inputs:
                                                 clk,
                                                 data_in,
                                                 reset_n,

                                                // outputs:
                                                 data_out
                                              )
;

  output           data_out;
  input            clk;
  input            data_in;
  input            reset_n;

  reg              data_in_d1 /* synthesis ALTERA_ATTRIBUTE = "MAX_DELAY=\"100ns\" ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */;
  reg              data_out /* synthesis ALTERA_ATTRIBUTE = "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_in_d1 <= 0;
      else if (1)
          data_in_d1 <= data_in;
    end


  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_out <= 0;
      else if (1)
          data_out <= data_in_d1;
    end



endmodule



// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module system_0 (
                  // 1) global signals:
                   clk,
                   reset_n,

                  // the_Audio_0
                   iCLK_18_4_to_the_Audio_0,
                   oAUD_BCK_from_the_Audio_0,
                   oAUD_DATA_from_the_Audio_0,
                   oAUD_LRCK_from_the_Audio_0,
                   oAUD_XCK_from_the_Audio_0,

                  // the_SD_CLK
                   out_port_from_the_SD_CLK,

                  // the_SD_CMD
                   bidir_port_to_and_from_the_SD_CMD,

                  // the_SD_DAT
                   bidir_port_to_and_from_the_SD_DAT,

                  // the_SEG7_Display
                   oSEG0_from_the_SEG7_Display,
                   oSEG1_from_the_SEG7_Display,
                   oSEG2_from_the_SEG7_Display,
                   oSEG3_from_the_SEG7_Display,
                   oSEG4_from_the_SEG7_Display,
                   oSEG5_from_the_SEG7_Display,
                   oSEG6_from_the_SEG7_Display,
                   oSEG7_from_the_SEG7_Display,

                  // the_button_pio
                   in_port_to_the_button_pio,

                  // the_ps2
                   PS2_CLK_to_and_from_the_ps2,
                   PS2_DAT_to_and_from_the_ps2,

                  // the_sdram
                   zs_addr_from_the_sdram,
                   zs_ba_from_the_sdram,
                   zs_cas_n_from_the_sdram,
                   zs_cke_from_the_sdram,
                   zs_cs_n_from_the_sdram,
                   zs_dq_to_and_from_the_sdram,
                   zs_dqm_from_the_sdram,
                   zs_ras_n_from_the_sdram,
                   zs_we_n_from_the_sdram,

                  // the_sram_0
                   SRAM_ADDR_from_the_sram_0,
                   SRAM_CE_N_from_the_sram_0,
                   SRAM_DQ_to_and_from_the_sram_0,
                   SRAM_LB_N_from_the_sram_0,
                   SRAM_OE_N_from_the_sram_0,
                   SRAM_UB_N_from_the_sram_0,
                   SRAM_WE_N_from_the_sram_0,

                  // the_vga
                   VGA_BLANK_from_the_vga,
                   VGA_B_from_the_vga,
                   VGA_CLK_from_the_vga,
                   VGA_G_from_the_vga,
                   VGA_HS_from_the_vga,
                   VGA_R_from_the_vga,
                   VGA_SYNC_from_the_vga,
                   VGA_VS_from_the_vga
                )
;

  inout            PS2_CLK_to_and_from_the_ps2;
  inout            PS2_DAT_to_and_from_the_ps2;
  output  [ 17: 0] SRAM_ADDR_from_the_sram_0;
  output           SRAM_CE_N_from_the_sram_0;
  inout   [ 15: 0] SRAM_DQ_to_and_from_the_sram_0;
  output           SRAM_LB_N_from_the_sram_0;
  output           SRAM_OE_N_from_the_sram_0;
  output           SRAM_UB_N_from_the_sram_0;
  output           SRAM_WE_N_from_the_sram_0;
  output           VGA_BLANK_from_the_vga;
  output  [  9: 0] VGA_B_from_the_vga;
  output           VGA_CLK_from_the_vga;
  output  [  9: 0] VGA_G_from_the_vga;
  output           VGA_HS_from_the_vga;
  output  [  9: 0] VGA_R_from_the_vga;
  output           VGA_SYNC_from_the_vga;
  output           VGA_VS_from_the_vga;
  inout            bidir_port_to_and_from_the_SD_CMD;
  inout            bidir_port_to_and_from_the_SD_DAT;
  output           oAUD_BCK_from_the_Audio_0;
  output           oAUD_DATA_from_the_Audio_0;
  output           oAUD_LRCK_from_the_Audio_0;
  output           oAUD_XCK_from_the_Audio_0;
  output  [  6: 0] oSEG0_from_the_SEG7_Display;
  output  [  6: 0] oSEG1_from_the_SEG7_Display;
  output  [  6: 0] oSEG2_from_the_SEG7_Display;
  output  [  6: 0] oSEG3_from_the_SEG7_Display;
  output  [  6: 0] oSEG4_from_the_SEG7_Display;
  output  [  6: 0] oSEG5_from_the_SEG7_Display;
  output  [  6: 0] oSEG6_from_the_SEG7_Display;
  output  [  6: 0] oSEG7_from_the_SEG7_Display;
  output           out_port_from_the_SD_CLK;
  output  [ 11: 0] zs_addr_from_the_sdram;
  output  [  1: 0] zs_ba_from_the_sdram;
  output           zs_cas_n_from_the_sdram;
  output           zs_cke_from_the_sdram;
  output           zs_cs_n_from_the_sdram;
  inout   [ 15: 0] zs_dq_to_and_from_the_sdram;
  output  [  1: 0] zs_dqm_from_the_sdram;
  output           zs_ras_n_from_the_sdram;
  output           zs_we_n_from_the_sdram;
  input            clk;
  input            iCLK_18_4_to_the_Audio_0;
  input   [  3: 0] in_port_to_the_button_pio;
  input            reset_n;

  wire    [ 15: 0] Audio_0_avalon_slave_0_readdata;
  wire    [ 15: 0] Audio_0_avalon_slave_0_readdata_from_sa;
  wire             Audio_0_avalon_slave_0_reset_n;
  wire             Audio_0_avalon_slave_0_write;
  wire    [ 15: 0] Audio_0_avalon_slave_0_writedata;
  wire             PS2_CLK_to_and_from_the_ps2;
  wire             PS2_DAT_to_and_from_the_ps2;
  wire    [  1: 0] SD_CLK_s1_address;
  wire             SD_CLK_s1_chipselect;
  wire             SD_CLK_s1_reset_n;
  wire             SD_CLK_s1_write_n;
  wire             SD_CLK_s1_writedata;
  wire    [  1: 0] SD_CMD_s1_address;
  wire             SD_CMD_s1_chipselect;
  wire             SD_CMD_s1_readdata;
  wire             SD_CMD_s1_readdata_from_sa;
  wire             SD_CMD_s1_reset_n;
  wire             SD_CMD_s1_write_n;
  wire             SD_CMD_s1_writedata;
  wire    [  1: 0] SD_DAT_s1_address;
  wire             SD_DAT_s1_chipselect;
  wire             SD_DAT_s1_readdata;
  wire             SD_DAT_s1_readdata_from_sa;
  wire             SD_DAT_s1_reset_n;
  wire             SD_DAT_s1_write_n;
  wire             SD_DAT_s1_writedata;
  wire             SEG7_Display_avalon_slave_0_reset_n;
  wire             SEG7_Display_avalon_slave_0_write;
  wire    [ 31: 0] SEG7_Display_avalon_slave_0_writedata;
  wire    [ 17: 0] SRAM_ADDR_from_the_sram_0;
  wire             SRAM_CE_N_from_the_sram_0;
  wire    [ 15: 0] SRAM_DQ_to_and_from_the_sram_0;
  wire             SRAM_LB_N_from_the_sram_0;
  wire             SRAM_OE_N_from_the_sram_0;
  wire             SRAM_UB_N_from_the_sram_0;
  wire             SRAM_WE_N_from_the_sram_0;
  wire             VGA_BLANK_from_the_vga;
  wire    [  9: 0] VGA_B_from_the_vga;
  wire             VGA_CLK_from_the_vga;
  wire    [  9: 0] VGA_G_from_the_vga;
  wire             VGA_HS_from_the_vga;
  wire    [  9: 0] VGA_R_from_the_vga;
  wire             VGA_SYNC_from_the_vga;
  wire             VGA_VS_from_the_vga;
  wire             bidir_port_to_and_from_the_SD_CMD;
  wire             bidir_port_to_and_from_the_SD_DAT;
  wire    [  1: 0] button_pio_s1_address;
  wire             button_pio_s1_chipselect;
  wire             button_pio_s1_irq;
  wire             button_pio_s1_irq_from_sa;
  wire    [  3: 0] button_pio_s1_readdata;
  wire    [  3: 0] button_pio_s1_readdata_from_sa;
  wire             button_pio_s1_reset_n;
  wire             button_pio_s1_write_n;
  wire    [  3: 0] button_pio_s1_writedata;
  wire             clk_reset_n;
  wire    [ 23: 0] cpu_0_data_master_address;
  wire    [ 23: 0] cpu_0_data_master_address_to_slave;
  wire    [  3: 0] cpu_0_data_master_byteenable;
  wire    [  1: 0] cpu_0_data_master_byteenable_sdram_s1;
  wire    [  1: 0] cpu_0_data_master_byteenable_sram_0_avalon_slave_0;
  wire    [  1: 0] cpu_0_data_master_dbs_address;
  wire    [ 15: 0] cpu_0_data_master_dbs_write_16;
  wire             cpu_0_data_master_debugaccess;
  wire             cpu_0_data_master_granted_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_granted_SD_CLK_s1;
  wire             cpu_0_data_master_granted_SD_CMD_s1;
  wire             cpu_0_data_master_granted_SD_DAT_s1;
  wire             cpu_0_data_master_granted_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_granted_button_pio_s1;
  wire             cpu_0_data_master_granted_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_granted_ps2_avalon_slave_0;
  wire             cpu_0_data_master_granted_sdram_s1;
  wire             cpu_0_data_master_granted_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_granted_vga_avalon_slave_0;
  wire    [ 31: 0] cpu_0_data_master_irq;
  wire             cpu_0_data_master_no_byte_enables_and_last_term;
  wire             cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_SD_CLK_s1;
  wire             cpu_0_data_master_qualified_request_SD_CMD_s1;
  wire             cpu_0_data_master_qualified_request_SD_DAT_s1;
  wire             cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_button_pio_s1;
  wire             cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_qualified_request_ps2_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_sdram_s1;
  wire             cpu_0_data_master_qualified_request_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_qualified_request_vga_avalon_slave_0;
  wire             cpu_0_data_master_read;
  wire             cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_SD_CLK_s1;
  wire             cpu_0_data_master_read_data_valid_SD_CMD_s1;
  wire             cpu_0_data_master_read_data_valid_SD_DAT_s1;
  wire             cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_button_pio_s1;
  wire             cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_read_data_valid_ps2_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_sdram_s1;
  wire             cpu_0_data_master_read_data_valid_sdram_s1_shift_register;
  wire             cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_read_data_valid_vga_avalon_slave_0;
  wire    [ 31: 0] cpu_0_data_master_readdata;
  wire             cpu_0_data_master_requests_Audio_0_avalon_slave_0;
  wire             cpu_0_data_master_requests_SD_CLK_s1;
  wire             cpu_0_data_master_requests_SD_CMD_s1;
  wire             cpu_0_data_master_requests_SD_DAT_s1;
  wire             cpu_0_data_master_requests_SEG7_Display_avalon_slave_0;
  wire             cpu_0_data_master_requests_button_pio_s1;
  wire             cpu_0_data_master_requests_cpu_0_jtag_debug_module;
  wire             cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave;
  wire             cpu_0_data_master_requests_ps2_avalon_slave_0;
  wire             cpu_0_data_master_requests_sdram_s1;
  wire             cpu_0_data_master_requests_sram_0_avalon_slave_0;
  wire             cpu_0_data_master_requests_vga_avalon_slave_0;
  wire             cpu_0_data_master_waitrequest;
  wire             cpu_0_data_master_write;
  wire    [ 31: 0] cpu_0_data_master_writedata;
  wire    [ 23: 0] cpu_0_instruction_master_address;
  wire    [ 23: 0] cpu_0_instruction_master_address_to_slave;
  wire    [  1: 0] cpu_0_instruction_master_dbs_address;
  wire             cpu_0_instruction_master_granted_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_granted_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_latency_counter;
  wire             cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_read;
  wire             cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0;
  wire    [ 31: 0] cpu_0_instruction_master_readdata;
  wire             cpu_0_instruction_master_readdatavalid;
  wire             cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  wire             cpu_0_instruction_master_requests_sram_0_avalon_slave_0;
  wire             cpu_0_instruction_master_waitrequest;
  wire    [  8: 0] cpu_0_jtag_debug_module_address;
  wire             cpu_0_jtag_debug_module_begintransfer;
  wire    [  3: 0] cpu_0_jtag_debug_module_byteenable;
  wire             cpu_0_jtag_debug_module_chipselect;
  wire             cpu_0_jtag_debug_module_debugaccess;
  wire    [ 31: 0] cpu_0_jtag_debug_module_readdata;
  wire    [ 31: 0] cpu_0_jtag_debug_module_readdata_from_sa;
  wire             cpu_0_jtag_debug_module_reset;
  wire             cpu_0_jtag_debug_module_reset_n;
  wire             cpu_0_jtag_debug_module_resetrequest;
  wire             cpu_0_jtag_debug_module_resetrequest_from_sa;
  wire             cpu_0_jtag_debug_module_write;
  wire    [ 31: 0] cpu_0_jtag_debug_module_writedata;
  wire             d1_Audio_0_avalon_slave_0_end_xfer;
  wire             d1_SD_CLK_s1_end_xfer;
  wire             d1_SD_CMD_s1_end_xfer;
  wire             d1_SD_DAT_s1_end_xfer;
  wire             d1_SEG7_Display_avalon_slave_0_end_xfer;
  wire             d1_button_pio_s1_end_xfer;
  wire             d1_cpu_0_jtag_debug_module_end_xfer;
  wire             d1_jtag_uart_0_avalon_jtag_slave_end_xfer;
  wire             d1_ps2_avalon_slave_0_end_xfer;
  wire             d1_sdram_s1_end_xfer;
  wire             d1_sram_0_avalon_slave_0_end_xfer;
  wire             d1_vga_avalon_slave_0_end_xfer;
  wire             jtag_uart_0_avalon_jtag_slave_address;
  wire             jtag_uart_0_avalon_jtag_slave_chipselect;
  wire             jtag_uart_0_avalon_jtag_slave_dataavailable;
  wire             jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_irq;
  wire             jtag_uart_0_avalon_jtag_slave_irq_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_read_n;
  wire    [ 31: 0] jtag_uart_0_avalon_jtag_slave_readdata;
  wire    [ 31: 0] jtag_uart_0_avalon_jtag_slave_readdata_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_readyfordata;
  wire             jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_reset_n;
  wire             jtag_uart_0_avalon_jtag_slave_waitrequest;
  wire             jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_write_n;
  wire    [ 31: 0] jtag_uart_0_avalon_jtag_slave_writedata;
  wire             oAUD_BCK_from_the_Audio_0;
  wire             oAUD_DATA_from_the_Audio_0;
  wire             oAUD_LRCK_from_the_Audio_0;
  wire             oAUD_XCK_from_the_Audio_0;
  wire    [  6: 0] oSEG0_from_the_SEG7_Display;
  wire    [  6: 0] oSEG1_from_the_SEG7_Display;
  wire    [  6: 0] oSEG2_from_the_SEG7_Display;
  wire    [  6: 0] oSEG3_from_the_SEG7_Display;
  wire    [  6: 0] oSEG4_from_the_SEG7_Display;
  wire    [  6: 0] oSEG5_from_the_SEG7_Display;
  wire    [  6: 0] oSEG6_from_the_SEG7_Display;
  wire    [  6: 0] oSEG7_from_the_SEG7_Display;
  wire             out_port_from_the_SD_CLK;
  wire             ps2_avalon_slave_0_address;
  wire    [  3: 0] ps2_avalon_slave_0_byteenable;
  wire             ps2_avalon_slave_0_chipselect;
  wire             ps2_avalon_slave_0_irq;
  wire             ps2_avalon_slave_0_read;
  wire    [ 31: 0] ps2_avalon_slave_0_readdata;
  wire    [ 31: 0] ps2_avalon_slave_0_readdata_from_sa;
  wire             ps2_avalon_slave_0_reset;
  wire             ps2_avalon_slave_0_waitrequest;
  wire             ps2_avalon_slave_0_waitrequest_from_sa;
  wire             ps2_avalon_slave_0_write;
  wire    [ 31: 0] ps2_avalon_slave_0_writedata;
  wire             reset_n_sources;
  wire    [ 21: 0] sdram_s1_address;
  wire    [  1: 0] sdram_s1_byteenable_n;
  wire             sdram_s1_chipselect;
  wire             sdram_s1_read_n;
  wire    [ 15: 0] sdram_s1_readdata;
  wire    [ 15: 0] sdram_s1_readdata_from_sa;
  wire             sdram_s1_readdatavalid;
  wire             sdram_s1_reset_n;
  wire             sdram_s1_waitrequest;
  wire             sdram_s1_waitrequest_from_sa;
  wire             sdram_s1_write_n;
  wire    [ 15: 0] sdram_s1_writedata;
  wire    [ 17: 0] sram_0_avalon_slave_0_address;
  wire    [  1: 0] sram_0_avalon_slave_0_byteenable_n;
  wire             sram_0_avalon_slave_0_chipselect_n;
  wire             sram_0_avalon_slave_0_read_n;
  wire    [ 15: 0] sram_0_avalon_slave_0_readdata;
  wire    [ 15: 0] sram_0_avalon_slave_0_readdata_from_sa;
  wire             sram_0_avalon_slave_0_wait_counter_eq_0;
  wire             sram_0_avalon_slave_0_write_n;
  wire    [ 15: 0] sram_0_avalon_slave_0_writedata;
  wire             vga_avalon_slave_0_address;
  wire             vga_avalon_slave_0_chipselect;
  wire             vga_avalon_slave_0_reset;
  wire             vga_avalon_slave_0_write;
  wire    [ 31: 0] vga_avalon_slave_0_writedata;
  wire    [ 31: 0] vga_read_master_address;
  wire    [ 31: 0] vga_read_master_address_to_slave;
  wire    [  1: 0] vga_read_master_dbs_address;
  wire             vga_read_master_granted_sdram_s1;
  wire             vga_read_master_qualified_request_sdram_s1;
  wire             vga_read_master_read;
  wire             vga_read_master_read_data_valid_sdram_s1;
  wire             vga_read_master_read_data_valid_sdram_s1_shift_register;
  wire    [ 31: 0] vga_read_master_readdata;
  wire             vga_read_master_requests_sdram_s1;
  wire             vga_read_master_waitrequest;
  wire    [ 11: 0] zs_addr_from_the_sdram;
  wire    [  1: 0] zs_ba_from_the_sdram;
  wire             zs_cas_n_from_the_sdram;
  wire             zs_cke_from_the_sdram;
  wire             zs_cs_n_from_the_sdram;
  wire    [ 15: 0] zs_dq_to_and_from_the_sdram;
  wire    [  1: 0] zs_dqm_from_the_sdram;
  wire             zs_ras_n_from_the_sdram;
  wire             zs_we_n_from_the_sdram;
  Audio_0_avalon_slave_0_arbitrator the_Audio_0_avalon_slave_0
    (
      .Audio_0_avalon_slave_0_readdata                            (Audio_0_avalon_slave_0_readdata),
      .Audio_0_avalon_slave_0_readdata_from_sa                    (Audio_0_avalon_slave_0_readdata_from_sa),
      .Audio_0_avalon_slave_0_reset_n                             (Audio_0_avalon_slave_0_reset_n),
      .Audio_0_avalon_slave_0_write                               (Audio_0_avalon_slave_0_write),
      .Audio_0_avalon_slave_0_writedata                           (Audio_0_avalon_slave_0_writedata),
      .clk                                                        (clk),
      .cpu_0_data_master_address_to_slave                         (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_Audio_0_avalon_slave_0           (cpu_0_data_master_granted_Audio_0_avalon_slave_0),
      .cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0 (cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0),
      .cpu_0_data_master_read                                     (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0   (cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0),
      .cpu_0_data_master_requests_Audio_0_avalon_slave_0          (cpu_0_data_master_requests_Audio_0_avalon_slave_0),
      .cpu_0_data_master_waitrequest                              (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                                    (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                                (cpu_0_data_master_writedata),
      .d1_Audio_0_avalon_slave_0_end_xfer                         (d1_Audio_0_avalon_slave_0_end_xfer),
      .reset_n                                                    (clk_reset_n)
    );

  Audio_0 the_Audio_0
    (
      .iCLK_18_4 (iCLK_18_4_to_the_Audio_0),
      .iDATA     (Audio_0_avalon_slave_0_writedata),
      .iRST_N    (Audio_0_avalon_slave_0_reset_n),
      .iWR       (Audio_0_avalon_slave_0_write),
      .iWR_CLK   (clk),
      .oAUD_BCK  (oAUD_BCK_from_the_Audio_0),
      .oAUD_DATA (oAUD_DATA_from_the_Audio_0),
      .oAUD_LRCK (oAUD_LRCK_from_the_Audio_0),
      .oAUD_XCK  (oAUD_XCK_from_the_Audio_0),
      .oDATA     (Audio_0_avalon_slave_0_readdata)
    );

  SD_CLK_s1_arbitrator the_SD_CLK_s1
    (
      .SD_CLK_s1_address                             (SD_CLK_s1_address),
      .SD_CLK_s1_chipselect                          (SD_CLK_s1_chipselect),
      .SD_CLK_s1_reset_n                             (SD_CLK_s1_reset_n),
      .SD_CLK_s1_write_n                             (SD_CLK_s1_write_n),
      .SD_CLK_s1_writedata                           (SD_CLK_s1_writedata),
      .clk                                           (clk),
      .cpu_0_data_master_address_to_slave            (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_SD_CLK_s1           (cpu_0_data_master_granted_SD_CLK_s1),
      .cpu_0_data_master_qualified_request_SD_CLK_s1 (cpu_0_data_master_qualified_request_SD_CLK_s1),
      .cpu_0_data_master_read                        (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_SD_CLK_s1   (cpu_0_data_master_read_data_valid_SD_CLK_s1),
      .cpu_0_data_master_requests_SD_CLK_s1          (cpu_0_data_master_requests_SD_CLK_s1),
      .cpu_0_data_master_waitrequest                 (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                       (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                   (cpu_0_data_master_writedata),
      .d1_SD_CLK_s1_end_xfer                         (d1_SD_CLK_s1_end_xfer),
      .reset_n                                       (clk_reset_n)
    );

  SD_CLK the_SD_CLK
    (
      .address    (SD_CLK_s1_address),
      .chipselect (SD_CLK_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_SD_CLK),
      .reset_n    (SD_CLK_s1_reset_n),
      .write_n    (SD_CLK_s1_write_n),
      .writedata  (SD_CLK_s1_writedata)
    );

  SD_CMD_s1_arbitrator the_SD_CMD_s1
    (
      .SD_CMD_s1_address                             (SD_CMD_s1_address),
      .SD_CMD_s1_chipselect                          (SD_CMD_s1_chipselect),
      .SD_CMD_s1_readdata                            (SD_CMD_s1_readdata),
      .SD_CMD_s1_readdata_from_sa                    (SD_CMD_s1_readdata_from_sa),
      .SD_CMD_s1_reset_n                             (SD_CMD_s1_reset_n),
      .SD_CMD_s1_write_n                             (SD_CMD_s1_write_n),
      .SD_CMD_s1_writedata                           (SD_CMD_s1_writedata),
      .clk                                           (clk),
      .cpu_0_data_master_address_to_slave            (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_SD_CMD_s1           (cpu_0_data_master_granted_SD_CMD_s1),
      .cpu_0_data_master_qualified_request_SD_CMD_s1 (cpu_0_data_master_qualified_request_SD_CMD_s1),
      .cpu_0_data_master_read                        (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_SD_CMD_s1   (cpu_0_data_master_read_data_valid_SD_CMD_s1),
      .cpu_0_data_master_requests_SD_CMD_s1          (cpu_0_data_master_requests_SD_CMD_s1),
      .cpu_0_data_master_waitrequest                 (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                       (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                   (cpu_0_data_master_writedata),
      .d1_SD_CMD_s1_end_xfer                         (d1_SD_CMD_s1_end_xfer),
      .reset_n                                       (clk_reset_n)
    );

  SD_CMD the_SD_CMD
    (
      .address    (SD_CMD_s1_address),
      .bidir_port (bidir_port_to_and_from_the_SD_CMD),
      .chipselect (SD_CMD_s1_chipselect),
      .clk        (clk),
      .readdata   (SD_CMD_s1_readdata),
      .reset_n    (SD_CMD_s1_reset_n),
      .write_n    (SD_CMD_s1_write_n),
      .writedata  (SD_CMD_s1_writedata)
    );

  SD_DAT_s1_arbitrator the_SD_DAT_s1
    (
      .SD_DAT_s1_address                             (SD_DAT_s1_address),
      .SD_DAT_s1_chipselect                          (SD_DAT_s1_chipselect),
      .SD_DAT_s1_readdata                            (SD_DAT_s1_readdata),
      .SD_DAT_s1_readdata_from_sa                    (SD_DAT_s1_readdata_from_sa),
      .SD_DAT_s1_reset_n                             (SD_DAT_s1_reset_n),
      .SD_DAT_s1_write_n                             (SD_DAT_s1_write_n),
      .SD_DAT_s1_writedata                           (SD_DAT_s1_writedata),
      .clk                                           (clk),
      .cpu_0_data_master_address_to_slave            (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_SD_DAT_s1           (cpu_0_data_master_granted_SD_DAT_s1),
      .cpu_0_data_master_qualified_request_SD_DAT_s1 (cpu_0_data_master_qualified_request_SD_DAT_s1),
      .cpu_0_data_master_read                        (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_SD_DAT_s1   (cpu_0_data_master_read_data_valid_SD_DAT_s1),
      .cpu_0_data_master_requests_SD_DAT_s1          (cpu_0_data_master_requests_SD_DAT_s1),
      .cpu_0_data_master_waitrequest                 (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                       (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                   (cpu_0_data_master_writedata),
      .d1_SD_DAT_s1_end_xfer                         (d1_SD_DAT_s1_end_xfer),
      .reset_n                                       (clk_reset_n)
    );

  SD_DAT the_SD_DAT
    (
      .address    (SD_DAT_s1_address),
      .bidir_port (bidir_port_to_and_from_the_SD_DAT),
      .chipselect (SD_DAT_s1_chipselect),
      .clk        (clk),
      .readdata   (SD_DAT_s1_readdata),
      .reset_n    (SD_DAT_s1_reset_n),
      .write_n    (SD_DAT_s1_write_n),
      .writedata  (SD_DAT_s1_writedata)
    );

  SEG7_Display_avalon_slave_0_arbitrator the_SEG7_Display_avalon_slave_0
    (
      .SEG7_Display_avalon_slave_0_reset_n                             (SEG7_Display_avalon_slave_0_reset_n),
      .SEG7_Display_avalon_slave_0_write                               (SEG7_Display_avalon_slave_0_write),
      .SEG7_Display_avalon_slave_0_writedata                           (SEG7_Display_avalon_slave_0_writedata),
      .clk                                                             (clk),
      .cpu_0_data_master_address_to_slave                              (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_SEG7_Display_avalon_slave_0           (cpu_0_data_master_granted_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0 (cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_read                                          (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0   (cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_requests_SEG7_Display_avalon_slave_0          (cpu_0_data_master_requests_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_write                                         (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                                     (cpu_0_data_master_writedata),
      .d1_SEG7_Display_avalon_slave_0_end_xfer                         (d1_SEG7_Display_avalon_slave_0_end_xfer),
      .reset_n                                                         (clk_reset_n)
    );

  SEG7_Display the_SEG7_Display
    (
      .iCLK   (clk),
      .iDIG   (SEG7_Display_avalon_slave_0_writedata),
      .iRST_N (SEG7_Display_avalon_slave_0_reset_n),
      .iWR    (SEG7_Display_avalon_slave_0_write),
      .oSEG0  (oSEG0_from_the_SEG7_Display),
      .oSEG1  (oSEG1_from_the_SEG7_Display),
      .oSEG2  (oSEG2_from_the_SEG7_Display),
      .oSEG3  (oSEG3_from_the_SEG7_Display),
      .oSEG4  (oSEG4_from_the_SEG7_Display),
      .oSEG5  (oSEG5_from_the_SEG7_Display),
      .oSEG6  (oSEG6_from_the_SEG7_Display),
      .oSEG7  (oSEG7_from_the_SEG7_Display)
    );

  button_pio_s1_arbitrator the_button_pio_s1
    (
      .button_pio_s1_address                             (button_pio_s1_address),
      .button_pio_s1_chipselect                          (button_pio_s1_chipselect),
      .button_pio_s1_irq                                 (button_pio_s1_irq),
      .button_pio_s1_irq_from_sa                         (button_pio_s1_irq_from_sa),
      .button_pio_s1_readdata                            (button_pio_s1_readdata),
      .button_pio_s1_readdata_from_sa                    (button_pio_s1_readdata_from_sa),
      .button_pio_s1_reset_n                             (button_pio_s1_reset_n),
      .button_pio_s1_write_n                             (button_pio_s1_write_n),
      .button_pio_s1_writedata                           (button_pio_s1_writedata),
      .clk                                               (clk),
      .cpu_0_data_master_address_to_slave                (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_button_pio_s1           (cpu_0_data_master_granted_button_pio_s1),
      .cpu_0_data_master_qualified_request_button_pio_s1 (cpu_0_data_master_qualified_request_button_pio_s1),
      .cpu_0_data_master_read                            (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_button_pio_s1   (cpu_0_data_master_read_data_valid_button_pio_s1),
      .cpu_0_data_master_requests_button_pio_s1          (cpu_0_data_master_requests_button_pio_s1),
      .cpu_0_data_master_waitrequest                     (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                           (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                       (cpu_0_data_master_writedata),
      .d1_button_pio_s1_end_xfer                         (d1_button_pio_s1_end_xfer),
      .reset_n                                           (clk_reset_n)
    );

  button_pio the_button_pio
    (
      .address    (button_pio_s1_address),
      .chipselect (button_pio_s1_chipselect),
      .clk        (clk),
      .in_port    (in_port_to_the_button_pio),
      .irq        (button_pio_s1_irq),
      .readdata   (button_pio_s1_readdata),
      .reset_n    (button_pio_s1_reset_n),
      .write_n    (button_pio_s1_write_n),
      .writedata  (button_pio_s1_writedata)
    );

  cpu_0_jtag_debug_module_arbitrator the_cpu_0_jtag_debug_module
    (
      .clk                                                                (clk),
      .cpu_0_data_master_address_to_slave                                 (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_byteenable                                       (cpu_0_data_master_byteenable),
      .cpu_0_data_master_debugaccess                                      (cpu_0_data_master_debugaccess),
      .cpu_0_data_master_granted_cpu_0_jtag_debug_module                  (cpu_0_data_master_granted_cpu_0_jtag_debug_module),
      .cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module        (cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module),
      .cpu_0_data_master_read                                             (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module          (cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module),
      .cpu_0_data_master_requests_cpu_0_jtag_debug_module                 (cpu_0_data_master_requests_cpu_0_jtag_debug_module),
      .cpu_0_data_master_waitrequest                                      (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                                            (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                                        (cpu_0_data_master_writedata),
      .cpu_0_instruction_master_address_to_slave                          (cpu_0_instruction_master_address_to_slave),
      .cpu_0_instruction_master_granted_cpu_0_jtag_debug_module           (cpu_0_instruction_master_granted_cpu_0_jtag_debug_module),
      .cpu_0_instruction_master_latency_counter                           (cpu_0_instruction_master_latency_counter),
      .cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module (cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module),
      .cpu_0_instruction_master_read                                      (cpu_0_instruction_master_read),
      .cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module   (cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module),
      .cpu_0_instruction_master_requests_cpu_0_jtag_debug_module          (cpu_0_instruction_master_requests_cpu_0_jtag_debug_module),
      .cpu_0_jtag_debug_module_address                                    (cpu_0_jtag_debug_module_address),
      .cpu_0_jtag_debug_module_begintransfer                              (cpu_0_jtag_debug_module_begintransfer),
      .cpu_0_jtag_debug_module_byteenable                                 (cpu_0_jtag_debug_module_byteenable),
      .cpu_0_jtag_debug_module_chipselect                                 (cpu_0_jtag_debug_module_chipselect),
      .cpu_0_jtag_debug_module_debugaccess                                (cpu_0_jtag_debug_module_debugaccess),
      .cpu_0_jtag_debug_module_readdata                                   (cpu_0_jtag_debug_module_readdata),
      .cpu_0_jtag_debug_module_readdata_from_sa                           (cpu_0_jtag_debug_module_readdata_from_sa),
      .cpu_0_jtag_debug_module_reset                                      (cpu_0_jtag_debug_module_reset),
      .cpu_0_jtag_debug_module_reset_n                                    (cpu_0_jtag_debug_module_reset_n),
      .cpu_0_jtag_debug_module_resetrequest                               (cpu_0_jtag_debug_module_resetrequest),
      .cpu_0_jtag_debug_module_resetrequest_from_sa                       (cpu_0_jtag_debug_module_resetrequest_from_sa),
      .cpu_0_jtag_debug_module_write                                      (cpu_0_jtag_debug_module_write),
      .cpu_0_jtag_debug_module_writedata                                  (cpu_0_jtag_debug_module_writedata),
      .d1_cpu_0_jtag_debug_module_end_xfer                                (d1_cpu_0_jtag_debug_module_end_xfer),
      .reset_n                                                            (clk_reset_n)
    );

  cpu_0_data_master_arbitrator the_cpu_0_data_master
    (
      .Audio_0_avalon_slave_0_readdata_from_sa                           (Audio_0_avalon_slave_0_readdata_from_sa),
      .SD_CMD_s1_readdata_from_sa                                        (SD_CMD_s1_readdata_from_sa),
      .SD_DAT_s1_readdata_from_sa                                        (SD_DAT_s1_readdata_from_sa),
      .button_pio_s1_irq_from_sa                                         (button_pio_s1_irq_from_sa),
      .button_pio_s1_readdata_from_sa                                    (button_pio_s1_readdata_from_sa),
      .clk                                                               (clk),
      .cpu_0_data_master_address                                         (cpu_0_data_master_address),
      .cpu_0_data_master_address_to_slave                                (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_byteenable_sdram_s1                             (cpu_0_data_master_byteenable_sdram_s1),
      .cpu_0_data_master_byteenable_sram_0_avalon_slave_0                (cpu_0_data_master_byteenable_sram_0_avalon_slave_0),
      .cpu_0_data_master_dbs_address                                     (cpu_0_data_master_dbs_address),
      .cpu_0_data_master_dbs_write_16                                    (cpu_0_data_master_dbs_write_16),
      .cpu_0_data_master_debugaccess                                     (cpu_0_data_master_debugaccess),
      .cpu_0_data_master_granted_Audio_0_avalon_slave_0                  (cpu_0_data_master_granted_Audio_0_avalon_slave_0),
      .cpu_0_data_master_granted_SD_CLK_s1                               (cpu_0_data_master_granted_SD_CLK_s1),
      .cpu_0_data_master_granted_SD_CMD_s1                               (cpu_0_data_master_granted_SD_CMD_s1),
      .cpu_0_data_master_granted_SD_DAT_s1                               (cpu_0_data_master_granted_SD_DAT_s1),
      .cpu_0_data_master_granted_SEG7_Display_avalon_slave_0             (cpu_0_data_master_granted_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_granted_button_pio_s1                           (cpu_0_data_master_granted_button_pio_s1),
      .cpu_0_data_master_granted_cpu_0_jtag_debug_module                 (cpu_0_data_master_granted_cpu_0_jtag_debug_module),
      .cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave           (cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_granted_ps2_avalon_slave_0                      (cpu_0_data_master_granted_ps2_avalon_slave_0),
      .cpu_0_data_master_granted_sdram_s1                                (cpu_0_data_master_granted_sdram_s1),
      .cpu_0_data_master_granted_sram_0_avalon_slave_0                   (cpu_0_data_master_granted_sram_0_avalon_slave_0),
      .cpu_0_data_master_granted_vga_avalon_slave_0                      (cpu_0_data_master_granted_vga_avalon_slave_0),
      .cpu_0_data_master_irq                                             (cpu_0_data_master_irq),
      .cpu_0_data_master_no_byte_enables_and_last_term                   (cpu_0_data_master_no_byte_enables_and_last_term),
      .cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0        (cpu_0_data_master_qualified_request_Audio_0_avalon_slave_0),
      .cpu_0_data_master_qualified_request_SD_CLK_s1                     (cpu_0_data_master_qualified_request_SD_CLK_s1),
      .cpu_0_data_master_qualified_request_SD_CMD_s1                     (cpu_0_data_master_qualified_request_SD_CMD_s1),
      .cpu_0_data_master_qualified_request_SD_DAT_s1                     (cpu_0_data_master_qualified_request_SD_DAT_s1),
      .cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0   (cpu_0_data_master_qualified_request_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_qualified_request_button_pio_s1                 (cpu_0_data_master_qualified_request_button_pio_s1),
      .cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module       (cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module),
      .cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave (cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_qualified_request_ps2_avalon_slave_0            (cpu_0_data_master_qualified_request_ps2_avalon_slave_0),
      .cpu_0_data_master_qualified_request_sdram_s1                      (cpu_0_data_master_qualified_request_sdram_s1),
      .cpu_0_data_master_qualified_request_sram_0_avalon_slave_0         (cpu_0_data_master_qualified_request_sram_0_avalon_slave_0),
      .cpu_0_data_master_qualified_request_vga_avalon_slave_0            (cpu_0_data_master_qualified_request_vga_avalon_slave_0),
      .cpu_0_data_master_read                                            (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0          (cpu_0_data_master_read_data_valid_Audio_0_avalon_slave_0),
      .cpu_0_data_master_read_data_valid_SD_CLK_s1                       (cpu_0_data_master_read_data_valid_SD_CLK_s1),
      .cpu_0_data_master_read_data_valid_SD_CMD_s1                       (cpu_0_data_master_read_data_valid_SD_CMD_s1),
      .cpu_0_data_master_read_data_valid_SD_DAT_s1                       (cpu_0_data_master_read_data_valid_SD_DAT_s1),
      .cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0     (cpu_0_data_master_read_data_valid_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_read_data_valid_button_pio_s1                   (cpu_0_data_master_read_data_valid_button_pio_s1),
      .cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module         (cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module),
      .cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave   (cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_read_data_valid_ps2_avalon_slave_0              (cpu_0_data_master_read_data_valid_ps2_avalon_slave_0),
      .cpu_0_data_master_read_data_valid_sdram_s1                        (cpu_0_data_master_read_data_valid_sdram_s1),
      .cpu_0_data_master_read_data_valid_sdram_s1_shift_register         (cpu_0_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0           (cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0),
      .cpu_0_data_master_read_data_valid_vga_avalon_slave_0              (cpu_0_data_master_read_data_valid_vga_avalon_slave_0),
      .cpu_0_data_master_readdata                                        (cpu_0_data_master_readdata),
      .cpu_0_data_master_requests_Audio_0_avalon_slave_0                 (cpu_0_data_master_requests_Audio_0_avalon_slave_0),
      .cpu_0_data_master_requests_SD_CLK_s1                              (cpu_0_data_master_requests_SD_CLK_s1),
      .cpu_0_data_master_requests_SD_CMD_s1                              (cpu_0_data_master_requests_SD_CMD_s1),
      .cpu_0_data_master_requests_SD_DAT_s1                              (cpu_0_data_master_requests_SD_DAT_s1),
      .cpu_0_data_master_requests_SEG7_Display_avalon_slave_0            (cpu_0_data_master_requests_SEG7_Display_avalon_slave_0),
      .cpu_0_data_master_requests_button_pio_s1                          (cpu_0_data_master_requests_button_pio_s1),
      .cpu_0_data_master_requests_cpu_0_jtag_debug_module                (cpu_0_data_master_requests_cpu_0_jtag_debug_module),
      .cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave          (cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_requests_ps2_avalon_slave_0                     (cpu_0_data_master_requests_ps2_avalon_slave_0),
      .cpu_0_data_master_requests_sdram_s1                               (cpu_0_data_master_requests_sdram_s1),
      .cpu_0_data_master_requests_sram_0_avalon_slave_0                  (cpu_0_data_master_requests_sram_0_avalon_slave_0),
      .cpu_0_data_master_requests_vga_avalon_slave_0                     (cpu_0_data_master_requests_vga_avalon_slave_0),
      .cpu_0_data_master_waitrequest                                     (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                                           (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                                       (cpu_0_data_master_writedata),
      .cpu_0_jtag_debug_module_readdata_from_sa                          (cpu_0_jtag_debug_module_readdata_from_sa),
      .d1_Audio_0_avalon_slave_0_end_xfer                                (d1_Audio_0_avalon_slave_0_end_xfer),
      .d1_SD_CLK_s1_end_xfer                                             (d1_SD_CLK_s1_end_xfer),
      .d1_SD_CMD_s1_end_xfer                                             (d1_SD_CMD_s1_end_xfer),
      .d1_SD_DAT_s1_end_xfer                                             (d1_SD_DAT_s1_end_xfer),
      .d1_SEG7_Display_avalon_slave_0_end_xfer                           (d1_SEG7_Display_avalon_slave_0_end_xfer),
      .d1_button_pio_s1_end_xfer                                         (d1_button_pio_s1_end_xfer),
      .d1_cpu_0_jtag_debug_module_end_xfer                               (d1_cpu_0_jtag_debug_module_end_xfer),
      .d1_jtag_uart_0_avalon_jtag_slave_end_xfer                         (d1_jtag_uart_0_avalon_jtag_slave_end_xfer),
      .d1_ps2_avalon_slave_0_end_xfer                                    (d1_ps2_avalon_slave_0_end_xfer),
      .d1_sdram_s1_end_xfer                                              (d1_sdram_s1_end_xfer),
      .d1_sram_0_avalon_slave_0_end_xfer                                 (d1_sram_0_avalon_slave_0_end_xfer),
      .d1_vga_avalon_slave_0_end_xfer                                    (d1_vga_avalon_slave_0_end_xfer),
      .jtag_uart_0_avalon_jtag_slave_irq_from_sa                         (jtag_uart_0_avalon_jtag_slave_irq_from_sa),
      .jtag_uart_0_avalon_jtag_slave_readdata_from_sa                    (jtag_uart_0_avalon_jtag_slave_readdata_from_sa),
      .jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa                 (jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa),
      .ps2_avalon_slave_0_readdata_from_sa                               (ps2_avalon_slave_0_readdata_from_sa),
      .ps2_avalon_slave_0_waitrequest_from_sa                            (ps2_avalon_slave_0_waitrequest_from_sa),
      .reset_n                                                           (clk_reset_n),
      .sdram_s1_readdata_from_sa                                         (sdram_s1_readdata_from_sa),
      .sdram_s1_waitrequest_from_sa                                      (sdram_s1_waitrequest_from_sa),
      .sram_0_avalon_slave_0_readdata_from_sa                            (sram_0_avalon_slave_0_readdata_from_sa),
      .sram_0_avalon_slave_0_wait_counter_eq_0                           (sram_0_avalon_slave_0_wait_counter_eq_0)
    );

  cpu_0_instruction_master_arbitrator the_cpu_0_instruction_master
    (
      .clk                                                                (clk),
      .cpu_0_instruction_master_address                                   (cpu_0_instruction_master_address),
      .cpu_0_instruction_master_address_to_slave                          (cpu_0_instruction_master_address_to_slave),
      .cpu_0_instruction_master_dbs_address                               (cpu_0_instruction_master_dbs_address),
      .cpu_0_instruction_master_granted_cpu_0_jtag_debug_module           (cpu_0_instruction_master_granted_cpu_0_jtag_debug_module),
      .cpu_0_instruction_master_granted_sram_0_avalon_slave_0             (cpu_0_instruction_master_granted_sram_0_avalon_slave_0),
      .cpu_0_instruction_master_latency_counter                           (cpu_0_instruction_master_latency_counter),
      .cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module (cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module),
      .cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0   (cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0),
      .cpu_0_instruction_master_read                                      (cpu_0_instruction_master_read),
      .cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module   (cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module),
      .cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0     (cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0),
      .cpu_0_instruction_master_readdata                                  (cpu_0_instruction_master_readdata),
      .cpu_0_instruction_master_readdatavalid                             (cpu_0_instruction_master_readdatavalid),
      .cpu_0_instruction_master_requests_cpu_0_jtag_debug_module          (cpu_0_instruction_master_requests_cpu_0_jtag_debug_module),
      .cpu_0_instruction_master_requests_sram_0_avalon_slave_0            (cpu_0_instruction_master_requests_sram_0_avalon_slave_0),
      .cpu_0_instruction_master_waitrequest                               (cpu_0_instruction_master_waitrequest),
      .cpu_0_jtag_debug_module_readdata_from_sa                           (cpu_0_jtag_debug_module_readdata_from_sa),
      .d1_cpu_0_jtag_debug_module_end_xfer                                (d1_cpu_0_jtag_debug_module_end_xfer),
      .d1_sram_0_avalon_slave_0_end_xfer                                  (d1_sram_0_avalon_slave_0_end_xfer),
      .reset_n                                                            (clk_reset_n),
      .sram_0_avalon_slave_0_readdata_from_sa                             (sram_0_avalon_slave_0_readdata_from_sa),
      .sram_0_avalon_slave_0_wait_counter_eq_0                            (sram_0_avalon_slave_0_wait_counter_eq_0)
    );

  cpu_0 the_cpu_0
    (
      .clk                                   (clk),
      .d_address                             (cpu_0_data_master_address),
      .d_byteenable                          (cpu_0_data_master_byteenable),
      .d_irq                                 (cpu_0_data_master_irq),
      .d_read                                (cpu_0_data_master_read),
      .d_readdata                            (cpu_0_data_master_readdata),
      .d_waitrequest                         (cpu_0_data_master_waitrequest),
      .d_write                               (cpu_0_data_master_write),
      .d_writedata                           (cpu_0_data_master_writedata),
      .i_address                             (cpu_0_instruction_master_address),
      .i_read                                (cpu_0_instruction_master_read),
      .i_readdata                            (cpu_0_instruction_master_readdata),
      .i_readdatavalid                       (cpu_0_instruction_master_readdatavalid),
      .i_waitrequest                         (cpu_0_instruction_master_waitrequest),
      .jtag_debug_module_address             (cpu_0_jtag_debug_module_address),
      .jtag_debug_module_begintransfer       (cpu_0_jtag_debug_module_begintransfer),
      .jtag_debug_module_byteenable          (cpu_0_jtag_debug_module_byteenable),
      .jtag_debug_module_clk                 (clk),
      .jtag_debug_module_debugaccess         (cpu_0_jtag_debug_module_debugaccess),
      .jtag_debug_module_debugaccess_to_roms (cpu_0_data_master_debugaccess),
      .jtag_debug_module_readdata            (cpu_0_jtag_debug_module_readdata),
      .jtag_debug_module_reset               (cpu_0_jtag_debug_module_reset),
      .jtag_debug_module_resetrequest        (cpu_0_jtag_debug_module_resetrequest),
      .jtag_debug_module_select              (cpu_0_jtag_debug_module_chipselect),
      .jtag_debug_module_write               (cpu_0_jtag_debug_module_write),
      .jtag_debug_module_writedata           (cpu_0_jtag_debug_module_writedata),
      .reset_n                               (cpu_0_jtag_debug_module_reset_n)
    );

  jtag_uart_0_avalon_jtag_slave_arbitrator the_jtag_uart_0_avalon_jtag_slave
    (
      .clk                                                               (clk),
      .cpu_0_data_master_address_to_slave                                (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave           (cpu_0_data_master_granted_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave (cpu_0_data_master_qualified_request_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_read                                            (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave   (cpu_0_data_master_read_data_valid_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave          (cpu_0_data_master_requests_jtag_uart_0_avalon_jtag_slave),
      .cpu_0_data_master_waitrequest                                     (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                                           (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                                       (cpu_0_data_master_writedata),
      .d1_jtag_uart_0_avalon_jtag_slave_end_xfer                         (d1_jtag_uart_0_avalon_jtag_slave_end_xfer),
      .jtag_uart_0_avalon_jtag_slave_address                             (jtag_uart_0_avalon_jtag_slave_address),
      .jtag_uart_0_avalon_jtag_slave_chipselect                          (jtag_uart_0_avalon_jtag_slave_chipselect),
      .jtag_uart_0_avalon_jtag_slave_dataavailable                       (jtag_uart_0_avalon_jtag_slave_dataavailable),
      .jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa               (jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa),
      .jtag_uart_0_avalon_jtag_slave_irq                                 (jtag_uart_0_avalon_jtag_slave_irq),
      .jtag_uart_0_avalon_jtag_slave_irq_from_sa                         (jtag_uart_0_avalon_jtag_slave_irq_from_sa),
      .jtag_uart_0_avalon_jtag_slave_read_n                              (jtag_uart_0_avalon_jtag_slave_read_n),
      .jtag_uart_0_avalon_jtag_slave_readdata                            (jtag_uart_0_avalon_jtag_slave_readdata),
      .jtag_uart_0_avalon_jtag_slave_readdata_from_sa                    (jtag_uart_0_avalon_jtag_slave_readdata_from_sa),
      .jtag_uart_0_avalon_jtag_slave_readyfordata                        (jtag_uart_0_avalon_jtag_slave_readyfordata),
      .jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa                (jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa),
      .jtag_uart_0_avalon_jtag_slave_reset_n                             (jtag_uart_0_avalon_jtag_slave_reset_n),
      .jtag_uart_0_avalon_jtag_slave_waitrequest                         (jtag_uart_0_avalon_jtag_slave_waitrequest),
      .jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa                 (jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa),
      .jtag_uart_0_avalon_jtag_slave_write_n                             (jtag_uart_0_avalon_jtag_slave_write_n),
      .jtag_uart_0_avalon_jtag_slave_writedata                           (jtag_uart_0_avalon_jtag_slave_writedata),
      .reset_n                                                           (clk_reset_n)
    );

  jtag_uart_0 the_jtag_uart_0
    (
      .av_address     (jtag_uart_0_avalon_jtag_slave_address),
      .av_chipselect  (jtag_uart_0_avalon_jtag_slave_chipselect),
      .av_irq         (jtag_uart_0_avalon_jtag_slave_irq),
      .av_read_n      (jtag_uart_0_avalon_jtag_slave_read_n),
      .av_readdata    (jtag_uart_0_avalon_jtag_slave_readdata),
      .av_waitrequest (jtag_uart_0_avalon_jtag_slave_waitrequest),
      .av_write_n     (jtag_uart_0_avalon_jtag_slave_write_n),
      .av_writedata   (jtag_uart_0_avalon_jtag_slave_writedata),
      .clk            (clk),
      .dataavailable  (jtag_uart_0_avalon_jtag_slave_dataavailable),
      .readyfordata   (jtag_uart_0_avalon_jtag_slave_readyfordata),
      .rst_n          (jtag_uart_0_avalon_jtag_slave_reset_n)
    );

  ps2_avalon_slave_0_arbitrator the_ps2_avalon_slave_0
    (
      .clk                                                    (clk),
      .cpu_0_data_master_address_to_slave                     (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_byteenable                           (cpu_0_data_master_byteenable),
      .cpu_0_data_master_granted_ps2_avalon_slave_0           (cpu_0_data_master_granted_ps2_avalon_slave_0),
      .cpu_0_data_master_qualified_request_ps2_avalon_slave_0 (cpu_0_data_master_qualified_request_ps2_avalon_slave_0),
      .cpu_0_data_master_read                                 (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_ps2_avalon_slave_0   (cpu_0_data_master_read_data_valid_ps2_avalon_slave_0),
      .cpu_0_data_master_requests_ps2_avalon_slave_0          (cpu_0_data_master_requests_ps2_avalon_slave_0),
      .cpu_0_data_master_waitrequest                          (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                                (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                            (cpu_0_data_master_writedata),
      .d1_ps2_avalon_slave_0_end_xfer                         (d1_ps2_avalon_slave_0_end_xfer),
      .ps2_avalon_slave_0_address                             (ps2_avalon_slave_0_address),
      .ps2_avalon_slave_0_byteenable                          (ps2_avalon_slave_0_byteenable),
      .ps2_avalon_slave_0_chipselect                          (ps2_avalon_slave_0_chipselect),
      .ps2_avalon_slave_0_read                                (ps2_avalon_slave_0_read),
      .ps2_avalon_slave_0_readdata                            (ps2_avalon_slave_0_readdata),
      .ps2_avalon_slave_0_readdata_from_sa                    (ps2_avalon_slave_0_readdata_from_sa),
      .ps2_avalon_slave_0_reset                               (ps2_avalon_slave_0_reset),
      .ps2_avalon_slave_0_waitrequest                         (ps2_avalon_slave_0_waitrequest),
      .ps2_avalon_slave_0_waitrequest_from_sa                 (ps2_avalon_slave_0_waitrequest_from_sa),
      .ps2_avalon_slave_0_write                               (ps2_avalon_slave_0_write),
      .ps2_avalon_slave_0_writedata                           (ps2_avalon_slave_0_writedata),
      .reset_n                                                (clk_reset_n)
    );

  ps2 the_ps2
    (
      .PS2_CLK     (PS2_CLK_to_and_from_the_ps2),
      .PS2_DAT     (PS2_DAT_to_and_from_the_ps2),
      .address     (ps2_avalon_slave_0_address),
      .byteenable  (ps2_avalon_slave_0_byteenable),
      .chipselect  (ps2_avalon_slave_0_chipselect),
      .clk         (clk),
      .irq         (ps2_avalon_slave_0_irq),
      .read        (ps2_avalon_slave_0_read),
      .readdata    (ps2_avalon_slave_0_readdata),
      .reset       (ps2_avalon_slave_0_reset),
      .waitrequest (ps2_avalon_slave_0_waitrequest),
      .write       (ps2_avalon_slave_0_write),
      .writedata   (ps2_avalon_slave_0_writedata)
    );

  sdram_s1_arbitrator the_sdram_s1
    (
      .clk                                                       (clk),
      .cpu_0_data_master_address_to_slave                        (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_byteenable                              (cpu_0_data_master_byteenable),
      .cpu_0_data_master_byteenable_sdram_s1                     (cpu_0_data_master_byteenable_sdram_s1),
      .cpu_0_data_master_dbs_address                             (cpu_0_data_master_dbs_address),
      .cpu_0_data_master_dbs_write_16                            (cpu_0_data_master_dbs_write_16),
      .cpu_0_data_master_granted_sdram_s1                        (cpu_0_data_master_granted_sdram_s1),
      .cpu_0_data_master_no_byte_enables_and_last_term           (cpu_0_data_master_no_byte_enables_and_last_term),
      .cpu_0_data_master_qualified_request_sdram_s1              (cpu_0_data_master_qualified_request_sdram_s1),
      .cpu_0_data_master_read                                    (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_sdram_s1                (cpu_0_data_master_read_data_valid_sdram_s1),
      .cpu_0_data_master_read_data_valid_sdram_s1_shift_register (cpu_0_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_0_data_master_requests_sdram_s1                       (cpu_0_data_master_requests_sdram_s1),
      .cpu_0_data_master_waitrequest                             (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                                   (cpu_0_data_master_write),
      .d1_sdram_s1_end_xfer                                      (d1_sdram_s1_end_xfer),
      .reset_n                                                   (clk_reset_n),
      .sdram_s1_address                                          (sdram_s1_address),
      .sdram_s1_byteenable_n                                     (sdram_s1_byteenable_n),
      .sdram_s1_chipselect                                       (sdram_s1_chipselect),
      .sdram_s1_read_n                                           (sdram_s1_read_n),
      .sdram_s1_readdata                                         (sdram_s1_readdata),
      .sdram_s1_readdata_from_sa                                 (sdram_s1_readdata_from_sa),
      .sdram_s1_readdatavalid                                    (sdram_s1_readdatavalid),
      .sdram_s1_reset_n                                          (sdram_s1_reset_n),
      .sdram_s1_waitrequest                                      (sdram_s1_waitrequest),
      .sdram_s1_waitrequest_from_sa                              (sdram_s1_waitrequest_from_sa),
      .sdram_s1_write_n                                          (sdram_s1_write_n),
      .sdram_s1_writedata                                        (sdram_s1_writedata),
      .vga_read_master_address_to_slave                          (vga_read_master_address_to_slave),
      .vga_read_master_dbs_address                               (vga_read_master_dbs_address),
      .vga_read_master_granted_sdram_s1                          (vga_read_master_granted_sdram_s1),
      .vga_read_master_qualified_request_sdram_s1                (vga_read_master_qualified_request_sdram_s1),
      .vga_read_master_read                                      (vga_read_master_read),
      .vga_read_master_read_data_valid_sdram_s1                  (vga_read_master_read_data_valid_sdram_s1),
      .vga_read_master_read_data_valid_sdram_s1_shift_register   (vga_read_master_read_data_valid_sdram_s1_shift_register),
      .vga_read_master_requests_sdram_s1                         (vga_read_master_requests_sdram_s1)
    );

  sdram the_sdram
    (
      .az_addr        (sdram_s1_address),
      .az_be_n        (sdram_s1_byteenable_n),
      .az_cs          (sdram_s1_chipselect),
      .az_data        (sdram_s1_writedata),
      .az_rd_n        (sdram_s1_read_n),
      .az_wr_n        (sdram_s1_write_n),
      .clk            (clk),
      .reset_n        (sdram_s1_reset_n),
      .za_data        (sdram_s1_readdata),
      .za_valid       (sdram_s1_readdatavalid),
      .za_waitrequest (sdram_s1_waitrequest),
      .zs_addr        (zs_addr_from_the_sdram),
      .zs_ba          (zs_ba_from_the_sdram),
      .zs_cas_n       (zs_cas_n_from_the_sdram),
      .zs_cke         (zs_cke_from_the_sdram),
      .zs_cs_n        (zs_cs_n_from_the_sdram),
      .zs_dq          (zs_dq_to_and_from_the_sdram),
      .zs_dqm         (zs_dqm_from_the_sdram),
      .zs_ras_n       (zs_ras_n_from_the_sdram),
      .zs_we_n        (zs_we_n_from_the_sdram)
    );

  sram_0_avalon_slave_0_arbitrator the_sram_0_avalon_slave_0
    (
      .clk                                                              (clk),
      .cpu_0_data_master_address_to_slave                               (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_byteenable                                     (cpu_0_data_master_byteenable),
      .cpu_0_data_master_byteenable_sram_0_avalon_slave_0               (cpu_0_data_master_byteenable_sram_0_avalon_slave_0),
      .cpu_0_data_master_dbs_address                                    (cpu_0_data_master_dbs_address),
      .cpu_0_data_master_dbs_write_16                                   (cpu_0_data_master_dbs_write_16),
      .cpu_0_data_master_granted_sram_0_avalon_slave_0                  (cpu_0_data_master_granted_sram_0_avalon_slave_0),
      .cpu_0_data_master_no_byte_enables_and_last_term                  (cpu_0_data_master_no_byte_enables_and_last_term),
      .cpu_0_data_master_qualified_request_sram_0_avalon_slave_0        (cpu_0_data_master_qualified_request_sram_0_avalon_slave_0),
      .cpu_0_data_master_read                                           (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0          (cpu_0_data_master_read_data_valid_sram_0_avalon_slave_0),
      .cpu_0_data_master_requests_sram_0_avalon_slave_0                 (cpu_0_data_master_requests_sram_0_avalon_slave_0),
      .cpu_0_data_master_write                                          (cpu_0_data_master_write),
      .cpu_0_instruction_master_address_to_slave                        (cpu_0_instruction_master_address_to_slave),
      .cpu_0_instruction_master_dbs_address                             (cpu_0_instruction_master_dbs_address),
      .cpu_0_instruction_master_granted_sram_0_avalon_slave_0           (cpu_0_instruction_master_granted_sram_0_avalon_slave_0),
      .cpu_0_instruction_master_latency_counter                         (cpu_0_instruction_master_latency_counter),
      .cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0 (cpu_0_instruction_master_qualified_request_sram_0_avalon_slave_0),
      .cpu_0_instruction_master_read                                    (cpu_0_instruction_master_read),
      .cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0   (cpu_0_instruction_master_read_data_valid_sram_0_avalon_slave_0),
      .cpu_0_instruction_master_requests_sram_0_avalon_slave_0          (cpu_0_instruction_master_requests_sram_0_avalon_slave_0),
      .d1_sram_0_avalon_slave_0_end_xfer                                (d1_sram_0_avalon_slave_0_end_xfer),
      .reset_n                                                          (clk_reset_n),
      .sram_0_avalon_slave_0_address                                    (sram_0_avalon_slave_0_address),
      .sram_0_avalon_slave_0_byteenable_n                               (sram_0_avalon_slave_0_byteenable_n),
      .sram_0_avalon_slave_0_chipselect_n                               (sram_0_avalon_slave_0_chipselect_n),
      .sram_0_avalon_slave_0_read_n                                     (sram_0_avalon_slave_0_read_n),
      .sram_0_avalon_slave_0_readdata                                   (sram_0_avalon_slave_0_readdata),
      .sram_0_avalon_slave_0_readdata_from_sa                           (sram_0_avalon_slave_0_readdata_from_sa),
      .sram_0_avalon_slave_0_wait_counter_eq_0                          (sram_0_avalon_slave_0_wait_counter_eq_0),
      .sram_0_avalon_slave_0_write_n                                    (sram_0_avalon_slave_0_write_n),
      .sram_0_avalon_slave_0_writedata                                  (sram_0_avalon_slave_0_writedata)
    );

  sram_0 the_sram_0
    (
      .SRAM_ADDR (SRAM_ADDR_from_the_sram_0),
      .SRAM_CE_N (SRAM_CE_N_from_the_sram_0),
      .SRAM_DQ   (SRAM_DQ_to_and_from_the_sram_0),
      .SRAM_LB_N (SRAM_LB_N_from_the_sram_0),
      .SRAM_OE_N (SRAM_OE_N_from_the_sram_0),
      .SRAM_UB_N (SRAM_UB_N_from_the_sram_0),
      .SRAM_WE_N (SRAM_WE_N_from_the_sram_0),
      .iADDR     (sram_0_avalon_slave_0_address),
      .iBE_N     (sram_0_avalon_slave_0_byteenable_n),
      .iCE_N     (sram_0_avalon_slave_0_chipselect_n),
      .iCLK      (clk),
      .iDATA     (sram_0_avalon_slave_0_writedata),
      .iOE_N     (sram_0_avalon_slave_0_read_n),
      .iWE_N     (sram_0_avalon_slave_0_write_n),
      .oDATA     (sram_0_avalon_slave_0_readdata)
    );

  vga_avalon_slave_0_arbitrator the_vga_avalon_slave_0
    (
      .clk                                                    (clk),
      .cpu_0_data_master_address_to_slave                     (cpu_0_data_master_address_to_slave),
      .cpu_0_data_master_granted_vga_avalon_slave_0           (cpu_0_data_master_granted_vga_avalon_slave_0),
      .cpu_0_data_master_qualified_request_vga_avalon_slave_0 (cpu_0_data_master_qualified_request_vga_avalon_slave_0),
      .cpu_0_data_master_read                                 (cpu_0_data_master_read),
      .cpu_0_data_master_read_data_valid_vga_avalon_slave_0   (cpu_0_data_master_read_data_valid_vga_avalon_slave_0),
      .cpu_0_data_master_requests_vga_avalon_slave_0          (cpu_0_data_master_requests_vga_avalon_slave_0),
      .cpu_0_data_master_waitrequest                          (cpu_0_data_master_waitrequest),
      .cpu_0_data_master_write                                (cpu_0_data_master_write),
      .cpu_0_data_master_writedata                            (cpu_0_data_master_writedata),
      .d1_vga_avalon_slave_0_end_xfer                         (d1_vga_avalon_slave_0_end_xfer),
      .reset_n                                                (clk_reset_n),
      .vga_avalon_slave_0_address                             (vga_avalon_slave_0_address),
      .vga_avalon_slave_0_chipselect                          (vga_avalon_slave_0_chipselect),
      .vga_avalon_slave_0_reset                               (vga_avalon_slave_0_reset),
      .vga_avalon_slave_0_write                               (vga_avalon_slave_0_write),
      .vga_avalon_slave_0_writedata                           (vga_avalon_slave_0_writedata)
    );

  vga_read_master_arbitrator the_vga_read_master
    (
      .clk                                                     (clk),
      .d1_sdram_s1_end_xfer                                    (d1_sdram_s1_end_xfer),
      .reset_n                                                 (clk_reset_n),
      .sdram_s1_readdata_from_sa                               (sdram_s1_readdata_from_sa),
      .sdram_s1_waitrequest_from_sa                            (sdram_s1_waitrequest_from_sa),
      .vga_read_master_address                                 (vga_read_master_address),
      .vga_read_master_address_to_slave                        (vga_read_master_address_to_slave),
      .vga_read_master_dbs_address                             (vga_read_master_dbs_address),
      .vga_read_master_granted_sdram_s1                        (vga_read_master_granted_sdram_s1),
      .vga_read_master_qualified_request_sdram_s1              (vga_read_master_qualified_request_sdram_s1),
      .vga_read_master_read                                    (vga_read_master_read),
      .vga_read_master_read_data_valid_sdram_s1                (vga_read_master_read_data_valid_sdram_s1),
      .vga_read_master_read_data_valid_sdram_s1_shift_register (vga_read_master_read_data_valid_sdram_s1_shift_register),
      .vga_read_master_readdata                                (vga_read_master_readdata),
      .vga_read_master_requests_sdram_s1                       (vga_read_master_requests_sdram_s1),
      .vga_read_master_waitrequest                             (vga_read_master_waitrequest)
    );

  vga the_vga
    (
      .VGA_B                       (VGA_B_from_the_vga),
      .VGA_BLANK                   (VGA_BLANK_from_the_vga),
      .VGA_CLK                     (VGA_CLK_from_the_vga),
      .VGA_G                       (VGA_G_from_the_vga),
      .VGA_HS                      (VGA_HS_from_the_vga),
      .VGA_R                       (VGA_R_from_the_vga),
      .VGA_SYNC                    (VGA_SYNC_from_the_vga),
      .VGA_VS                      (VGA_VS_from_the_vga),
      .address                     (vga_avalon_slave_0_address),
      .avm_read_master_address     (vga_read_master_address),
      .avm_read_master_read        (vga_read_master_read),
      .avm_read_master_readdata    (vga_read_master_readdata),
      .avm_read_master_waitrequest (vga_read_master_waitrequest),
      .chipselect                  (vga_avalon_slave_0_chipselect),
      .clk                         (clk),
      .reset                       (vga_avalon_slave_0_reset),
      .write                       (vga_avalon_slave_0_write),
      .writedata                   (vga_avalon_slave_0_writedata)
    );

  //reset is asserted asynchronously and deasserted synchronously
  system_0_reset_clk_domain_synch_module system_0_reset_clk_domain_synch
    (
      .clk      (clk),
      .data_in  (1'b1),
      .data_out (clk_reset_n),
      .reset_n  (reset_n_sources)
    );

  //reset sources mux, which is an e_mux
  assign reset_n_sources = ~(~reset_n |
    0 |
    cpu_0_jtag_debug_module_resetrequest_from_sa |
    cpu_0_jtag_debug_module_resetrequest_from_sa);


endmodule


//synthesis translate_off



// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE

// AND HERE WILL BE PRESERVED </ALTERA_NOTE>


// If user logic components use Altsync_Ram with convert_hex2ver.dll,
// set USE_convert_hex2ver in the user comments section above

// `ifdef USE_convert_hex2ver
// `else
// `define NO_PLI 1
// `endif

`include "/opt/e4840/altera7.2/quartus/eda/sim_lib/altera_mf.v"
`include "/opt/e4840/altera7.2/quartus/eda/sim_lib/220model.v"
`include "/opt/e4840/altera7.2/quartus/eda/sim_lib/sgate.v"
`include "ps2.v"
`include "vga.v"
`include "SRAM_16Bit_512K.v"
`include "sram_0.v"
`include "SD_CMD.v"
`include "sdram.v"
`include "AUDIO_DAC_FIFO.v"
`include "FIFO_16_256.v"
`include "Audio_0.v"
`include "SEG7_LUT.v"
`include "SEG7_LUT_8.v"
`include "SEG7_Display.v"
`include "SD_DAT.v"
`include "cpu_0_test_bench.v"
`include "cpu_0_mult_cell.v"
`include "cpu_0_jtag_debug_module.v"
`include "cpu_0_jtag_debug_module_wrapper.v"
`include "cpu_0.v"
`include "button_pio.v"
`include "SD_CLK.v"
`include "jtag_uart_0.v"

`timescale 1ns / 1ps

module test_bench 
;


  wire             PS2_CLK_to_and_from_the_ps2;
  wire             PS2_DAT_to_and_from_the_ps2;
  wire    [ 17: 0] SRAM_ADDR_from_the_sram_0;
  wire             SRAM_CE_N_from_the_sram_0;
  wire    [ 15: 0] SRAM_DQ_to_and_from_the_sram_0;
  wire             SRAM_LB_N_from_the_sram_0;
  wire             SRAM_OE_N_from_the_sram_0;
  wire             SRAM_UB_N_from_the_sram_0;
  wire             SRAM_WE_N_from_the_sram_0;
  wire             VGA_BLANK_from_the_vga;
  wire    [  9: 0] VGA_B_from_the_vga;
  wire             VGA_CLK_from_the_vga;
  wire    [  9: 0] VGA_G_from_the_vga;
  wire             VGA_HS_from_the_vga;
  wire    [  9: 0] VGA_R_from_the_vga;
  wire             VGA_SYNC_from_the_vga;
  wire             VGA_VS_from_the_vga;
  wire             bidir_port_to_and_from_the_SD_CMD;
  wire             bidir_port_to_and_from_the_SD_DAT;
  reg              clk;
  wire             iCLK_18_4_to_the_Audio_0;
  wire    [  3: 0] in_port_to_the_button_pio;
  wire             jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa;
  wire             jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa;
  wire             oAUD_BCK_from_the_Audio_0;
  wire             oAUD_DATA_from_the_Audio_0;
  wire             oAUD_LRCK_from_the_Audio_0;
  wire             oAUD_XCK_from_the_Audio_0;
  wire    [  6: 0] oSEG0_from_the_SEG7_Display;
  wire    [  6: 0] oSEG1_from_the_SEG7_Display;
  wire    [  6: 0] oSEG2_from_the_SEG7_Display;
  wire    [  6: 0] oSEG3_from_the_SEG7_Display;
  wire    [  6: 0] oSEG4_from_the_SEG7_Display;
  wire    [  6: 0] oSEG5_from_the_SEG7_Display;
  wire    [  6: 0] oSEG6_from_the_SEG7_Display;
  wire    [  6: 0] oSEG7_from_the_SEG7_Display;
  wire             out_port_from_the_SD_CLK;
  wire             ps2_avalon_slave_0_irq;
  reg              reset_n;
  wire    [ 11: 0] zs_addr_from_the_sdram;
  wire    [  1: 0] zs_ba_from_the_sdram;
  wire             zs_cas_n_from_the_sdram;
  wire             zs_cke_from_the_sdram;
  wire             zs_cs_n_from_the_sdram;
  wire    [ 15: 0] zs_dq_to_and_from_the_sdram;
  wire    [  1: 0] zs_dqm_from_the_sdram;
  wire             zs_ras_n_from_the_sdram;
  wire             zs_we_n_from_the_sdram;


// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
//  add your signals and additional architecture here
// AND HERE WILL BE PRESERVED </ALTERA_NOTE>

  //Set us up the Dut
  system_0 DUT
    (
      .PS2_CLK_to_and_from_the_ps2       (PS2_CLK_to_and_from_the_ps2),
      .PS2_DAT_to_and_from_the_ps2       (PS2_DAT_to_and_from_the_ps2),
      .SRAM_ADDR_from_the_sram_0         (SRAM_ADDR_from_the_sram_0),
      .SRAM_CE_N_from_the_sram_0         (SRAM_CE_N_from_the_sram_0),
      .SRAM_DQ_to_and_from_the_sram_0    (SRAM_DQ_to_and_from_the_sram_0),
      .SRAM_LB_N_from_the_sram_0         (SRAM_LB_N_from_the_sram_0),
      .SRAM_OE_N_from_the_sram_0         (SRAM_OE_N_from_the_sram_0),
      .SRAM_UB_N_from_the_sram_0         (SRAM_UB_N_from_the_sram_0),
      .SRAM_WE_N_from_the_sram_0         (SRAM_WE_N_from_the_sram_0),
      .VGA_BLANK_from_the_vga            (VGA_BLANK_from_the_vga),
      .VGA_B_from_the_vga                (VGA_B_from_the_vga),
      .VGA_CLK_from_the_vga              (VGA_CLK_from_the_vga),
      .VGA_G_from_the_vga                (VGA_G_from_the_vga),
      .VGA_HS_from_the_vga               (VGA_HS_from_the_vga),
      .VGA_R_from_the_vga                (VGA_R_from_the_vga),
      .VGA_SYNC_from_the_vga             (VGA_SYNC_from_the_vga),
      .VGA_VS_from_the_vga               (VGA_VS_from_the_vga),
      .bidir_port_to_and_from_the_SD_CMD (bidir_port_to_and_from_the_SD_CMD),
      .bidir_port_to_and_from_the_SD_DAT (bidir_port_to_and_from_the_SD_DAT),
      .clk                               (clk),
      .iCLK_18_4_to_the_Audio_0          (iCLK_18_4_to_the_Audio_0),
      .in_port_to_the_button_pio         (in_port_to_the_button_pio),
      .oAUD_BCK_from_the_Audio_0         (oAUD_BCK_from_the_Audio_0),
      .oAUD_DATA_from_the_Audio_0        (oAUD_DATA_from_the_Audio_0),
      .oAUD_LRCK_from_the_Audio_0        (oAUD_LRCK_from_the_Audio_0),
      .oAUD_XCK_from_the_Audio_0         (oAUD_XCK_from_the_Audio_0),
      .oSEG0_from_the_SEG7_Display       (oSEG0_from_the_SEG7_Display),
      .oSEG1_from_the_SEG7_Display       (oSEG1_from_the_SEG7_Display),
      .oSEG2_from_the_SEG7_Display       (oSEG2_from_the_SEG7_Display),
      .oSEG3_from_the_SEG7_Display       (oSEG3_from_the_SEG7_Display),
      .oSEG4_from_the_SEG7_Display       (oSEG4_from_the_SEG7_Display),
      .oSEG5_from_the_SEG7_Display       (oSEG5_from_the_SEG7_Display),
      .oSEG6_from_the_SEG7_Display       (oSEG6_from_the_SEG7_Display),
      .oSEG7_from_the_SEG7_Display       (oSEG7_from_the_SEG7_Display),
      .out_port_from_the_SD_CLK          (out_port_from_the_SD_CLK),
      .reset_n                           (reset_n),
      .zs_addr_from_the_sdram            (zs_addr_from_the_sdram),
      .zs_ba_from_the_sdram              (zs_ba_from_the_sdram),
      .zs_cas_n_from_the_sdram           (zs_cas_n_from_the_sdram),
      .zs_cke_from_the_sdram             (zs_cke_from_the_sdram),
      .zs_cs_n_from_the_sdram            (zs_cs_n_from_the_sdram),
      .zs_dq_to_and_from_the_sdram       (zs_dq_to_and_from_the_sdram),
      .zs_dqm_from_the_sdram             (zs_dqm_from_the_sdram),
      .zs_ras_n_from_the_sdram           (zs_ras_n_from_the_sdram),
      .zs_we_n_from_the_sdram            (zs_we_n_from_the_sdram)
    );

  initial
    clk = 1'b0;
  always
    #10 clk <= ~clk;
  
  initial 
    begin
      reset_n <= 0;
      #200 reset_n <= 1;
    end

endmodule


//synthesis translate_on