#include <io.h>
#include <system.h>
#include <stdio.h>
#include "SD_Card.h"
#include "fatutil.h"
#include "ps2_mouse.h"
#include "alt_up_ps2_port.h"

#define IOWR_LED_DATA(base, offset, data) \
  IOWR_16DIRECT(base, (offset) * 2, data) 
#define IORD_LED_DATA(base, offset) \
  IORD_16DIRECT(base, (offset) * 2)
#define IOWR_LED_SPEED(base, data) \
  IOWR_16DIRECT(base + 32, 0, data)
  
#define HTOTAL       800
#define HSYNC        96
#define HBACK_PORCH  48
#define HACTIVE      640
#define HFRONT_PORCH 16
  
#define VTOTAL       525
#define VSYNC        2
#define VBACK_PORCH  33
#define VACTIVE      480
#define VFRONT_PORCH 10

#define LEFT_BOUND HSYNC + HBACK_PORCH
#define RIGHT_BOUND LEFT_BOUND + HACTIVE
#define TOP_BOUND VSYNC + VBACK_PORCH - 1
#define BOTTOM_BOUND TOP_BOUND + VACTIVE

#define X_OFFSET 0
#define Y_OFFSET 1
#define RADIUS 50



void play_next()
{
    // get the next file in sd card, assume audio file
    get_next_dir_entry();
    printf(get_cur_file_name());
    printf("\n");       
    
    int i = 0;
    int j = 0;
    BYTE Buffer[512]={0};
    UINT16 Tmp1=0;
    int file_blocks = 0;
    file_blocks = get_cur_file_size() / 512;  
    get_blocks_audio(get_cur_file_sector() + get_partition_start(), file_blocks, Buffer);
    
//    for (i=0; i<file_blocks; i++)
//    {      
//       get_blocks(get_cur_file_sector() + get_partition_start() + i, 1 ,Buffer);
//       while(j<512)
//       {
//            Tmp1=(Buffer[j+1]<<8)|Buffer[j];
//            j+=2;
//            if(!IORD(AUDIO_0_BASE,0))
//            {
//                IOWR(AUDIO_0_BASE,0,Tmp1);
//            }
//        }
//        j=0;
//    }   
}

int main()
{

  int status;
  unsigned int curX=400, curY=273, movX=0, movY=0;    
  unsigned char byte0, byte1, byte2, signX, signY;

  printf("Initizlizing SD card \n");
  long int root_dir_start;
  while(SD_card_init())
  usleep(5000);
  usleep(500000);
  

  /* first initialize everything */
  printf("Initizlizing FAT system \n");
  root_dir_start = init_FAT_system();  
  
  printf("Root directory start is : %d", root_dir_start);
  printf("\n");    
  if (root_dir_start != 0)  {
    /* have a valid starting sector - get the first directory entry */
    get_first_dir_entry(root_dir_start);
    printf(get_cur_file_name());
    printf("\n");      
    get_blocks_32(get_cur_file_sector() + get_partition_start(), 1200, SDRAM_BASE);  
   
    // load up the rest of the animation frames
    get_next_dir_entry();
    printf(get_cur_file_name());
    printf("\n");     
    get_blocks_32(get_cur_file_sector() + get_partition_start(), 1200, 0x0096000);
    
    get_next_dir_entry();
    printf(get_cur_file_name());
    printf("\n");   
    get_blocks_32(get_cur_file_sector() + get_partition_start(), 1200, 0x012C000);    
  }
 
  
    // initialize the mouse
    clear_FIFO();
    switch (get_mode()) {
        case PS2_KEYBOARD:
            //printf("Keyboard detected on PS/2 port\n");
            break;
        case PS2_MOUSE:
            //printf("Yes! Mouse detected on PS/2 port\n");
            break;
        default:
            //printf("Error: Unrecognized or no device on PS/2 port\n");
    return 0;
    }
    
    //Enable Remote Mode
    status = write_data_byte_with_ack(0xF0, DEFAULT_PS2_TIMEOUT_VAL); 
    if (status != PS2_SUCCESS)  printf("Fail to set Remote Mode!\n");
    
  while(1)
  {

    //send command to read data from mouse
    status = write_data_byte_with_ack(0xEB, DEFAULT_PS2_TIMEOUT_VAL); 
    //printf("Start Working.\n");

    while(0xFA == (0xFF & IORD_ALT_UP_PS2_PORT_DATA(ALT_UP_PS2_BASE)));
    usleep(3000);
    byte0=IORD_ALT_UP_PS2_PORT_DATA(ALT_UP_PS2_BASE);
    //printf("byte0= %x\n", byte0);
    usleep(2000);
    byte1=IORD_ALT_UP_PS2_PORT_DATA(ALT_UP_PS2_BASE);
    //printf("byte1= %x\n", byte1);
    usleep(2000);
    byte2=IORD_ALT_UP_PS2_PORT_DATA(ALT_UP_PS2_BASE);
    //printf("byte2= %x\n", byte2);
    //msleep(1);
    
    signX= (byte0 >>4) & 0x01 ;
    signY= (byte0 >>5) & 0x01 ; 
    
    if (byte0 & 0x01 == 1) 
    {
        play_next();
    }
       
    if (signX == 1) {
        movX = (255 - byte1) ;      // X: go left
        if ( movX > 40 ) movX = 40;
        curX = curX - movX;        
        }
    else {
        movX = byte1 ;              // X: go right
        if ( movX > 40 ) movX = 40;
        curX = curX + movX;
        }  
    if (signY == 1) {
        movY = (255 - byte2) ;      // Y: go down
        if ( movY > 40 ) movY = 40;
        curY = curY + movY ;
    }
    else {
        movY = byte2 ;              // Y: go up
        if ( movY > 40 ) movY = 40;
        curY = curY - movY;
        //if ( curY > 480) curY = 480;
    }
  
    int vector = (curY << 16) | (curX & 0xFFFF);  
    IOWR_32DIRECT(VGA_BASE, 0, vector);
  }
  return 0;
}


