library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


entity sprite_rom is
	port (
		Clk : in std_logic;
		--spriteAddress : in unsigned(3 downto 0);
		spriteAddress0 :in integer :=0;
		spriteAddress1 :in integer :=0;
		spriteAddress2 :in integer :=0;
		spriteAddress3 :in integer :=0;
		spriteAddress4 :in integer :=0;
		spriteAddress5 :in integer :=0;
		spriteAddress6 :in integer :=0;
		spriteAddress7 :in integer :=0;
		up_wing :in std_logic :='0';
		
		duck0 : out unsigned( 3 downto 0);
		duck1 : out unsigned( 3 downto 0);
		duck2 : out unsigned( 3 downto 0);
		duck3 : out unsigned( 3 downto 0);
		duck4 : out unsigned( 3 downto 0);
		duck5 : out unsigned( 3 downto 0);
		duck6 : out unsigned( 3 downto 0);
		duck7 : out unsigned( 3 downto 0);
		
		addressNumber0 : in integer :=0;
		addressNumber1 : in integer :=0;
		addressNumber2 : in integer :=0;
		
		whichNumber : in integer;
		
		number0Pixel : out std_logic;
		number1Pixel : out std_logic;
		number2Pixel : out std_logic;
		
		fishPixel: out std_logic;
--		fishPixel1: out std_logic;
--		fishPixel2: out std_logic;
--		fishPixel3: out std_logic;
--		fishPixel4: out std_logic;
--		fishPixel5: out std_logic;
--		fishPixel6: out std_logic;
--		fishPixel7: out std_logic;
--		fishPixel8: out std_logic;
--		fishPixel9: out std_logic;
--		fishPixel10: out std_logic;
--		fishPixel11: out std_logic;
--		fishPixel12: out std_logic;
--		fishPixel13: out std_logic;
--		fishPixel14: out std_logic;
--		fishPixel15: out std_logic;
--
		fishAddress: in integer :=0
--		fishAddress1: in integer:=0;
--		fishAddress2: in integer:=0;
--		fishAddress3: in integer:=0;
--		fishAddress4: in integer:=0;
--		fishAddress5: in integer:=0;
--		fishAddress6: in integer:=0;
--		fishAddress7: in integer:=0;
--		fishAddress8: in integer:=0;
--		fishAddress9: in integer:=0;
--		fishAddress10: in integer:=0;
--		fishAddress11: in integer:=0;
--		fishAddress12: in integer:=0;
--		fishAddress13: in integer:=0;
--		fishAddress14: in integer:=0;
--		fishAddress15: in integer:=0

	);
end sprite_rom;

architecture imp of sprite_rom is

	signal digit0 : integer := 0;
	signal digit1 : integer := 0;
	signal digit2 : integer := 0;
	
	type sprite_rom_code_type is array (0 to 1599) of unsigned(3 downto 0);
	type score_rom_code_type is array (0 to 1599) of std_logic;
	type fish_rom_code_type is array (0 to 399) of std_logic;


constant BIRD_A : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0010","0001","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0011","0010","0010","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0100","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0010","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011");

constant BIRD_B : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0010","0001","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0011","0010","0010","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0100","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0010","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011");

constant BIRD_C : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0010","0001","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0011","0010","0010","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0100","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0010","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011");

constant BIRD_D : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0010","0010","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0010","0001","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0000","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0011","0011","0011","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0010","0001","0001","0001","0001","0001","0001","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0011","0010","0010","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0100","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0000","0000","0000","0000","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0001","0001","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0010","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011");

constant BIRD_A_up : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0010","0011","0011","0011","0011","0011");

constant BIRD_B_up : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0010","0011","0011","0011","0011","0011");

constant BIRD_C_up : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0010","0011","0011","0011","0011","0011");

constant BIRD_D_up : sprite_rom_code_type := 
("0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0100","0100","0100","0011","0011","0011","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0010","0010","0010","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0000","0000","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0001","0001","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0001","0001","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0001","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0010","0010","0010","0100","0100","0100","0100","0100","0100","0100","0100","0100","0100","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0100","0100","0100","0100","0100","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0010","0010","0001","0001","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0010","0010","0010","0010","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0001","0001","0001","0010","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0010","0010","0001","0001","0001","0010","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0001","0010","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0011","0001","0010","0011","0011","0011","0011","0011");


----("0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0010","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0010","0000","0000","0000","0000","0000","0000","0000","0000","0000");

--Numbers in black and white
constant number0 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0');
constant number1 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0');
constant number2 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0');
constant number3 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0');
constant number4 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0');
constant number5 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0');
constant number6 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0');
constant number7 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
constant number8 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0');
constant number9 : score_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
constant fish : fish_rom_code_type :=
('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','0','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','0','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
--('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
--constant fish_C : fish_rom_code_type :=
--('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
--constant fish_D : fish_rom_code_type :=
--('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
--constant fish_E : fish_rom_code_type :=
--('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
--constant fish_F : fish_rom_code_type :=
--('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
--constant fish_G : fish_rom_code_type :=
--('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');
--constant fish_H : fish_rom_code_type :=
--('0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0');

	begin
	process (whichNumber) begin
		digit0 <= whichNumber/100;
		digit1 <= (whichNumber mod 100)/10;
		digit2 <= whichNumber mod 10;
	
		end process;
	
	process (Clk)
		begin
		if rising_edge(Clk) then
			if up_wing = '1' then
				duck0 <= BIRD_A_up(spriteAddress0);
				duck1 <= BIRD_A(spriteAddress1);
				duck2 <= BIRD_B_up(spriteAddress2);
				duck3 <= BIRD_B(spriteAddress3);
				duck4 <= BIRD_C_up(spriteAddress4);
				duck5 <= BIRD_C(spriteAddress5);
				duck6 <= BIRD_D_up(spriteAddress6);
				duck7 <= BIRD_D(spriteAddress7);
			else
				duck0 <= BIRD_A(spriteAddress0);
				duck1 <= BIRD_A_up(spriteAddress1);
				duck2 <= BIRD_B(spriteAddress2);
				duck3 <= BIRD_B_up(spriteAddress3);
				duck4 <= BIRD_C(spriteAddress4);
				duck5 <= BIRD_C_up(spriteAddress5);
				duck6 <= BIRD_D(spriteAddress6);
				duck7 <= BIRD_D_up(spriteAddress7);
			end if;

		fishPixel <= fish(fishAddress);
----	fishPixel1 <= fish_A(fishAddress1);
----	fishPixel2 <= fish_B(fishAddress2);
----	fishPixel3 <= fish_B(fishAddress3);
----	fishPixel4 <= fish_C(fishAddress4);
----	fishPixel5 <= fish_C(fishAddress5);
----	fishPixel6 <= fish_D(fishAddress6);
----	fishPixel7 <= fish_D(fishAddress7);
----	fishPixel8 <= fish_E(fishAddress8);
----	fishPixel9 <= fish_E(fishAddress9);
----	fishPixel10 <= fish_F(fishAddress10);
----	fishPixel11 <= fish_F(fishAddress11);
----	fishPixel12 <= fish_G(fishAddress12);
----	fishPixel13 <= fish_G(fishAddress13);
----	fishPixel14 <= fish_H(fishAddress14);
----	fishPixel15 <= fish_H(fishAddress15);

			end if;
		end process;
	

	
	with digit0 select number0Pixel <= 
		number0(addressNumber0) when 0,
		number1(addressNumber0) when 1,
		number2(addressNumber0) when 2,
		number3(addressNumber0) when 3,
		number4(addressNumber0) when 4,
		number5(addressNumber0) when 5,
		number6(addressNumber0) when 6,
		number7(addressNumber0) when 7,
		number8(addressNumber0) when 8,
		number9(addressNumber0) when others;

	with digit1 select number1Pixel <= 
		number0(addressNumber1) when 0,
		number1(addressNumber1) when 1,
		number2(addressNumber1) when 2,
		number3(addressNumber1) when 3,
		number4(addressNumber1) when 4,
		number5(addressNumber1) when 5,
		number6(addressNumber1) when 6,
		number7(addressNumber1) when 7,
		number8(addressNumber1) when 8,
		number9(addressNumber1) when others;
		
	with digit2 select number2Pixel <= 
		number0(addressNumber2) when 0,
		number1(addressNumber2) when 1,
		number2(addressNumber2) when 2,
		number3(addressNumber2) when 3,
		number4(addressNumber2) when 4,
		number5(addressNumber2) when 5,
		number6(addressNumber2) when 6,
		number7(addressNumber2) when 7,
		number8(addressNumber2) when 8,
		number9(addressNumber2) when others;
		
						
	end imp;

