
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;


entity background_rom is
	port (
		Clk : in std_logic;	
		instructionAddress : in unsigned(15 downto 0);
		data : out unsigned(15 downto 0);
		arrayLength : out integer
	);
end background_rom;




architecture imp of background_rom is


	type background_rom_type is array (0 to 8129) of unsigned(15 downto 0);
	constant BACKGROUND : background_rom_type :=  -- (others => (others =>'0'));
--background instructions
-- Without merging of like colors:
("0000000000000000", "0010111110100000","0010111110100000","0010111110100000","0010111110100000","0010111110100000","0010111110100000","0010111110100000","0010010111101010","0010001001111111","0111000000000100","0010000000001000","0111000000000100","0010001001101011","0010000000000011","0111000000001001","0111000000001001","0010001001100111","0111000000000011","0111000000000101","0011000000000101","0111000000000101","0011000000000110","0111000000000011","0010001001100000","0010000000000011","0111000000000101","0111000000000101","0011000000000100","0011000000000100","0011000000001000","0111000000000010","0010001001011101","0111000000001001","0011000000000100","0011000000000101","0110000000000100","0011000000000110","1001000000000100","0011000000000010","0111000000000100","0010001001010110","0111000000000110","0111000000000101","0011000000000011","0110000000000011","1001000000000011","1001000000000010","0110000000000101","0110000000001000","1001000000000010","0011000000000011","0111000000000011","0010001001010100","0111000000000011","0011000000000101","0011000000001000","0110000000000100","1001000000000010","0110000000001111","1001000000000010","0011000000000100","0111000000000101","0010001001001111","0111000000000010","0011000000000011","0110000000000011","1001000000000011","0011000000000010","1001000000000010","0110000000011001","1001000000000010","0011000000000101","0111000000000011","0010001001001110","0111000000000010","0011000000000011","0110000000001001","0110000000011010","0110000000000100","1001000000000010","0011000000000010","0111000000000100","0010001001001011","0111000000000011","0011000000000011","0110000000101000","1001000000000010","0011000000000010","0111000000000010","0010001001001101","0111000000000010","0011000000000010","1001000000000010","0110000000101001","0011000000000011","0111000000000011","0010001001000111","0010000000000010","0111000000000011","0011000000000010","1001000000000010","0110000000101010","0011000000000011","0111000000000011","0010001001000110","0111000000000101","0011000000000011","1001000000000010","0110000000101010","1001000000000010","0011000000000010","0111000000000100","0010001001000010","0111000000000011","0001000000000100","1001000000000011","0110000000101101","1001000000000101","0111000000000010","0010001001000010","0111000000000011","0011000000000010","1001000000000011","0110000000110001","1001000000000100","0111000000000010","0010001000111111","0111000000000010","0001000000000011","1001000000000011","0110000000000011","0110000000110100","0001000000000100","0010001000111101","0111000000000100","1001000000000011","0110000000110110","1001000000000010","0001000000000010","0111000000000010","0010001000111101","0001000000000010","0011000000000011","0110000000111000","1001000000000010","0001000000000101","0010001000111011","0111000000000010","0001000000000111","0110000000110101","1001000000000010","0001000000000010","0111000000000100","0010001000111010","0111000000000010","0001000000000011","1001000000000011","0110000000110101","1001000000000011","0001000000000100","0010001000111101","0001000000000100","1001000000000010","0110000000110110","1001000000000010","0001000000000100","0111000000000011","0010001000111010","0111000000000010","0001000000000101","0110000000110101","1001000000000011","0001000000000110","0010001000111100","0001000000000100","0110000000110111","1001000000000110","0001000000000011","0111000000000011","0010001000110111","0001000000000100","1001000000000011","0110000000110111","1001000000000110","0001000000000011","0111000000000100","0010001000110110","0001000000000101","1001000000000100","0110000000111010","0001000000000100","0111000000000011","0010001000110110","0001000000001001","0110000000111100","0001000000000011","0111000000000011","0010001000110101","0111000000000010","0001000000000110","1001000000000010","0110000000111000","1001000000000011","0001000000000100","0111000000000100","0010001000110100","0111000000000010","0001000000000010","1001000000000110","0110000000110110","1001000000000010","0001000000000110","0111000000000010","0010001000110110","0111000000000011","0001000000000010","1001000000000010","0110000000111001","1001000000000010","0001000000000110","0111000000000010","0010001000110111","0001000000000010","1001000000000110","0110000000110101","1001000000000011","0001000000001000","0010001000110110","0111000000000010","0001000000000010","0011000000000010","1001000000000110","0110000000110011","1001000000000010","0001000000000110","0111000000000010","0010001000111000","0001000000000100","1001000000000011","1001000000000011","0110000000110100","1001000000000010","0001000000000110","0010001000111001","0001000000001011","1001000000000010","0110000000110010","0110000000000011","0001000000000101","0010001000111001","0001000000001001","1001000000000011","0110000000000010","1001000000000110","0110000000100110","1001000000001001","0001000000000100","0010001000111111","0001000000000011","1001000000000010","0110000000000100","1001000000000100","0110000000100111","1001000000000011","1001000000000011","1001000000000011","0001000000000100","0111000000000010","0010001000110110","0111000000000110","0001000000000011","1001000000000100","1001000000000101","1001000000000011","0110000000100110","1001000000001000","0001000000000110","0010001000111001","0010000000000010","0111000000000010","0001000000000111","1001000000000011","1001000000000011","0110000000011101","0110000000010000","0001000000001000","0111000000000010","0010001000111011","0001000000001000","1001000000000010","0001000000000010","1001000000000010","0110000000001001","0110000000010001","1001000000000010","0110000000000011","0110000000001101","0001000000001011","0010001000111100","0001000000001011","1001000000000010","0110000000001010","1001000000000010","0110000000001101","1001000000000101","0110000000001000","0110000000000101","0001000000000011","0111000000000101","0001000000000101","0010001000111011","0001000000001010","1001000000000100","0110000000000011","1001000000000100","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0110000000000110","1001000000000010","0001000000000010","1001000000000011","0110000000001011","1001000000000011","0111000000001000","0010001001000100","0001000000000111","1001000000000100","1001000000000100","0001000000000010","1001000000000101","1001000000000011","1001000000000010","0110000000000110","0001000000000101","1001000000000010","0110000000000100","1001000000000110","0001000000000100","0010000000000011","0010001001000011","0111000000000011","0001000000001001","1001000000000101","0001000000000100","1001000000000110","0001000000000010","1001000000000011","0110000000000010","1001000000000011","0001000000000101","1001000000000100","0110000000000010","1001000000000010","0001000000000010","1001000000000010","0001000000000011","0111000000000010","0010001001000111","0111000000000010","0001000000001100","0001000000000110","1001000000000100","0001000000000101","1001000000000011","1001000000000010","0001000000000111","1001000000000100","1001000000000100","0001000000000011","0001000000000101","0010001001000101","0111000000000010","0001000000010100","0011000000000010","0001000000001000","1001000000000010","0001000000001001","1001000000000111","0001000000001010","0010001001001000","0001000000010100","0001000000001011","0001000000000110","0001000000000101","1001000000000010","0001000000001011","0111000000000010","0010001001001010","0111000000000011","0001000000010001","0111000000000010","0001000000001010","0111000000000011","0001000000001001","0111000000001000","0010001001001011","0111000000000011","0001000000010001","0111000000000100","0001000000001011","0111000000000011","0001000000000110","0111000000000011","0010000000000110","0010001001001111","0001000000000101","0111000000000011","0111000000000010","0001000000000110","0111000000000110","0001000000000110","0111000000000010","0010000000000010","0111000000000100","0001000000000010","0111000000000010","0010001001011001","0001000000000110","0010000000000101","0001000000000110","0100000000000100","0001000000000111","0010000000001011","0010001001011110","0010000000000100","0111000000001000","0100000000000110","0000000000000011","0010000000001100","0010001001100111","0000000000000011","0100000000001000","0000000000000010","0010001001110100","0000000000000010","0100000000000100","0000000000000110","0010000000101001","0010001001001011","0000000000000100","0100000000000100","0000000000000100","0010000000100110","0111000000000110","0010000000000110","0111000000001000","0010001000111001","0000000000000111","0000000000000110","0010000000100011","0111000000000110","0111000000000100","0010000000000100","0111000000000100","0111000000001000","0010000000000011","0010001000110101","0000000000000101","0000000000000100","0000000000000010","0010000000011111","0111000000000111","0011000000000110","0111000000000110","0011000000000100","0111000000001001","0111000000000101","0010000000000011","0010001000101101","0000000000000101","0000000000000010","0101000000000101","0010000000011100","0111000000000100","0011000000000010","0111000000000011","0011000000000100","1001000000000010","0011000000000011","0111000000000010","0011000000000110","0011000000000111","0111000000000101","0111000000000100","0010001000101111","0000000000000101","0000000000000101","0000000000000010","0010000000011010","0111000000000011","0011000000001001","0110000000000101","0011000000000011","0011000000000010","1001000000000010","0110000000000100","0011000000000100","1001000000000010","0011000000000111","0111000000000100","0010001000101110","0000000000000011","0101000000000100","0000000000000011","0010000000011010","0111000000000100","1001000000000010","0110000000000010","1001000000000101","0110000000000110","1001000000000010","0110000000001111","0011000000000010","1001000000000011","0011000000000010","0111000000000101","0010001000110001","0101000000000100","0000000000000010","0010000000010111","0111000000000011","0011000000000100","0110000000000111","0110000000001010","0110000000010001","0110000000000011","0011000000000010","0111000000000100","0010001000101100","0000000000000101","0101000000000100","0010000000010110","0111000000000100","0011000000000110","0110000000101000","0111000000000100","0010001000110000","0101000000000100","0000000000000010","0010000000010100","0111000000000010","0011000000000110","1001000000000011","0110000000000111","0110000000011001","0110000000001011","0111000000000011","0010001000101001","0000000000000011","0101000000000110","0010000000010100","0111000000000010","0011000000000010","1001000000000011","1001000000000011","0110000000101101","0011000000000101","0010001000101001","0000000000000010","0101000000000100","0000000000000010","0010000000010011","0111000000000010","0011000000000011","0110000000000100","1001000000000010","0110000000101110","0111000000000100","0010001000101000","0101000000000011","0101000000000100","0010000000010101","0001000000000011","1001000000000010","0110000000010100","0110000000100000","0111000000000010","0010001000101100","0101000000000100","0000000000000010","0010000000010100","0011000000000110","0110000000110011","0111000000000011","0010001000100101","0000000000000101","0101000000000111","0010000000010001","0111000000000010","0001000000000010","1001000000000011","0110000000110111","0010001000100111","0000000000000100","0101000000000100","0000000000000010","0010000000010010","0001000000000010","1001000000000010","0110000000111000","0111000000000010","0010001000101001","0101000000000011","0101000000000011","0010000000010000","0111000000000010","0001000000000011","1001000000000010","0110000000000101","0110000000110101","0010001000011101","0000000000000100","0010000000000110","0000000000000010","0101000000000101","0000000000000010","0010000000001110","0111000000000100","1001000000000011","0110000000111010","0111000000000010","0010001000011100","0000000000000110","0000000000000111","0101000000000100","0000000000000010","0010000000001111","0001000000000010","0011000000000010","1001000000000100","0110000000111001","0010001000011110","0000000000001011","0101000000000101","0000000000000010","0010000000010100","1001000000000011","0110000000110110","0001000000000011","0010001000011110","0000000000000011","0000000000001001","0101000000000100","0000000000000010","0010000000001111","0001000000001000","0110000000110111","0111000000000010","0010001000011111","0000000000001011","0101000000000111","0010000000001111","0111000000000011","0001000000000011","1001000000000010","0110000000110110","0111000000000011","0010001000100111","0101000000000111","0000000000000100","0010000000001101","0111000000000010","0001000000000101","0110000000110110","0001000000000011","0010001000100110","0000000000000100","0101000000000110","0000000000000010","0010000000001110","0111000000000011","0001000000000010","1001000000000010","0110000000110100","1001000000000111","0010001000100111","0101000000001001","0010000000001101","0111000000000010","0001000000000010","1001000000000011","0110000000110110","0001000000000011","0010001000101000","0000000000000101","0101000000000101","0000000000000010","0010000000001100","0111000000000010","0001000000000010","1001000000000101","1001000000000101","0110000000101110","0001000000000100","0010001000101100","0101000000000101","0000000000000010","0010000000001100","0111000000000011","0011000000000010","1001000000000010","0110000000000010","1001000000000011","1001000000000100","0110000000101010","0001000000000101","0010001000101100","0000000000000011","0101000000001000","0010000000001010","0111000000000110","1001000000001000","0110000000101100","0001000000000100","0111000000000010","0010001000101011","0000000000000010","0101000000000101","0000000000000100","0010000000001011","0001000000000101","0001000000000100","1001000000000011","0110000000101011","1001000000000010","0001000000000101","0010001000101110","0000000000000010","0101000000000101","0000000000000011","0010000000001011","0001000000001011","1001000000000100","0110000000100111","1001000000000010","0001000000000011","0111000000000011","0010001000101101","0101000000000111","0000000000000010","0010000000001011","0111000000000010","0001000000000110","0011000000000011","1001000000000101","1001000000000011","0110000000100111","0001000000000100","0010001000101111","0101000000000111","0000000000000010","0010000000001101","0001000000000100","0111000000000010","0011000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000000101","0110000000011110","1001000000000011","0001000000000110","0010001000101011","0000000000000010","0101000000000111","0000000000000010","0010000000010101","0011000000000011","0001000000000100","1001000000000011","1001000000000100","1001000000000010","0110000000011001","1001000000000111","0001000000000100","0010001000101110","0000000000000010","0101000000000110","0000000000000010","0010000000010010","0001000000001001","1001000000000111","1001000000000010","0110000000001000","0110000000001001","0110000000001000","1001000000000011","0001000000000111","0111000000000010","0010001000101011","0000000000000100","0101000000001000","0010000000010011","0001000000000101","0001000000000101","0011000000000010","0001000000000011","1001000000000101","1001000000000100","0110000000000110","1001000000000100","0110000000000110","1001000000000111","0001000000000101","0010001000101111","0000000000000011","0101000000000101","0000000000000011","0010000000010000","0111000000000110","0111000000000010","0001000000001100","1001000000000101","1001000000000011","0110000000000011","1001000000001001","1001000000000100","0001000000000010","0011000000000010","0111000000000110","0010001000110010","0101000000001000","0010000000010010","0111000000000110","0001000000001011","1001000000000011","0001000000000011","1001000000001000","0001000000000011","1001000000000110","0001000000000101","0111000000000011","0010001000110101","0000000000000010","0101000000000101","0000000000000011","0010000000010100","0111000000000100","0001000000001000","0011000000000010","1001000000000100","0001000000000101","1001000000000011","0001000000000111","1001000000000011","0001000000001001","0010001000110100","0000000000000010","0101000000000111","0000000000000010","0010000000011010","0001000000001001","0001000000001000","0011000000000010","0001000000001010","0001000000000101","0111000000000010","0010001000111000","0000000000000011","0101000000000101","0000000000000011","0010000000011010","0000000000000010","0001000000010000","0001000000001010","0001000000000110","0010001000111000","0000000000000010","0101000000000110","0000000000000011","0010000000000101","0111000000000110","0010000000000010","0111000000000100","0010000000001010","0000000000000011","0001000000011110","0010001000111010","0000000000000010","0101000000001000","0010000000000010","0111000000000110","0111000000000111","0111000000000100","0010000000000110","0000000000000110","0001000000001001","0001000000001011","0111000000000010","0001000000000110","0010001000111010","0000000000000010","0101000000000111","0000000000000011","0111000000000010","0011000000000100","0011000000001010","0111000000001001","0000000000000011","0000000000000010","0111000000000010","0000000000000011","0000000000000100","0001000000001010","0111000000000111","0010001000111101","0000000000000011","0101000000001000","0011000000000011","1001000000000010","0110000000000011","1001000000000011","1001000000000010","0110000000000010","1001000000000100","0111000000000110","0000000000000111","0000000000001100","0001000000000101","0010000000000100","0111000000000011","0010001000111100","0000000000000010","0101000000000110","0000000000000011","0011000000000010","0110000000001110","1001000000000010","0011000000000011","1001000000000010","0011000000000100","0101000000000010","0000000000001010","0010000000001001","0010001001000111","0000000000000010","0101000000000101","1000000000000010","1001000000000100","0110000000010000","1001000000000011","1001000000000101","0101000000000010","0000000000001010","0010000000001000","0010001001000101","0000000000001011","0110000000010100","0110000000000100","1001000000000010","1000000000000110","0000000000000011","0010001001010111","1000000000001001","0110000000010111","0011000000000010","1000000000000011","1000000000000100","0010001001010100","0111000000000010","0011000000000011","1000000000000100","0110000000100000","0111000000000011","0010001001010101","0011000000000011","1001000000000100","1001000000000010","0110000000011001","1001000000000011","0110000000000011","0011000000000010","0111000000000010","0010001001010100","0011000000000011","0110000000000101","0110000000011100","0110000000000101","0011000000000010","0111000000000010","0010001001010011","0011000000000101","0110000000100110","0111000000000010","0010001000101010","0010000000100111","0111000000000110","0110000000100111","0111000000000010","0010001000100111","0111000000000101","0010000000000110","0111000000000101","0010000000011011","0011000000000101","0110000000101000","0010001000100100","0010000000000010","0111000000000100","0111000000000100","0010000000000100","0111000000000011","0011000000000011","0111000000000010","0010000000010110","0111000000000010","0011000000000011","1001000000000010","0110000000100100","1001000000000010","0011000000000011","0010001000011111","0111000000001000","0011000000000110","0111000000000110","0011000000000101","0111000000000111","0010000000010001","0111000000000010","0011000000000010","1001000000000010","0110000000000011","0110000000100101","0111000000000010","0010001000011101","0111000000000101","0011000000000010","0111000000000010","0011000000000100","1001000000000010","0011000000000011","0111000000000010","0011000000000100","0110000000000010","0011000000000010","0111000000000100","0011000000000011","0111000000000010","0010000000001111","0011000000000011","0110000000000011","0110000000100110","0011000000000010","0111000000000010","0010001000011100","0111000000000010","0011000000001001","0110000000000110","0011000000000110","0110000000000100","0011000000001001","0111000000000011","0010000000001100","0111000000000011","1001000000000011","0110000000101001","0111000000000011","0010001000011010","0111000000000010","0011000000000011","0110000000000010","1001000000000100","0110000000000110","1001000000000100","0110000000000110","1001000000000010","0011000000000011","0110000000000100","0011000000000010","0111000000000010","0010000000001110","0011000000000010","1001000000000100","0110000000100111","0011000000000011","0010001000010101","0111000000000110","0011000000000010","1001000000000010","0110000000000110","0110000000010101","0110000000000110","0111000000000011","0010000000001101","0001000000000100","1001000000000010","0110000000100111","0011000000000010","0111000000000010","0010001000010100","0111000000000011","0011000000000100","1001000000000010","0110000000011111","1001000000000010","0011000000000010","0111000000000010","0010000000001100","0111000000000100","1001000000000011","0110000000100101","1001000000000010","0011000000000010","0111000000000010","0010001000010011","0111000000000010","0011000000000111","0110000000100001","1001000000000100","0111000000000010","0010000000001100","0111000000000010","0011000000000111","0110000000100010","1001000000000100","0111000000000010","0010001000010100","0011000000000110","0110000000100100","1001000000000100","0111000000000011","0010000000001100","0011000000000110","1001000000000101","0110000000001011","1001000000000010","0110000000001100","1001000000000101","0011000000000011","0111000000000010","0010001000010101","0011000000000010","1001000000000010","0110000000100111","1001000000000010","0001000000000010","0111000000000010","0010000000001111","1001000000000110","0110000000000101","0110000000000110","1001000000000101","0110000000001001","1001000000000011","1001000000000100","0001000000000010","0111000000000010","0010001000010111","0011000000000011","0110000000101000","0011000000000010","0001000000000100","0010000000001100","1001000000000100","0001000000000101","0110000000000010","1001000000000110","0110000000000011","0001000000000010","1001000000000010","0110000000000101","1001000000000101","1001000000000100","0011000000000011","0111000000000010","0010001000010111","0001000000000100","0110000000100110","1001000000000011","0001000000000110","0010000000001001","0001000000001001","1001000000001011","1001000000000010","0001000000000010","1001000000000011","0110000000000110","1001000000000111","0001000000000010","0111000000000010","0010001000010101","0111000000000101","1001000000000010","0110000000101000","0001000000000100","0111000000000011","0010000000001011","0001000000001100","0001000000000100","1001000000000100","0001000000000010","1001000000001000","0001000000000010","1001000000000010","0011000000000010","0001000000000010","0111000000000011","0010001000010110","0111000000000010","0001000000000011","1001000000000010","0110000000101000","1001000000000110","0111000000000011","0010000000001001","0001000000000100","0001000000010101","1001000000000011","0001000000001001","0111000000000011","0010001000011000","0001000000000010","1001000000000010","0110000000101010","1001000000000100","0001000000000010","0111000000000010","0010000000001111","0001000000010011","0011000000000010","1001000000000010","0001000000001000","0111000000000011","0010001000010110","0111000000000011","0011000000000010","1001000000000010","0110000000101011","1001000000000011","0001000000000011","0111000000000011","0010000000001100","0000000000000010","0001000000011010","0001000000000110","0010000000100011","0010000111110100","0111000000000010","0001000000000100","0110000000101101","1001000000000011","0001000000000100","0010000000001010","0000000000001011","0001000000000110","0000000000000110","0001000000000101","0111000000000111","0010000000011111","0111000000000101","0010000000000110","0111000000000101","0010000111110001","1001000000000010","0110000000101010","1001000000000010","0001000000000110","0010000000001010","0000000000000111","0000000000001001","0000000000000010","0101000000000011","0000000000000101","0111000000000010","0010000000000100","0010000000100001","0111000000001001","0111000000001000","0010000111101100","0001000000000110","0110000000101011","0001000000000110","0010000000001010","0000000000000011","0101000000000011","0101000000000011","0000000000000110","0000000000000011","0101000000000101","0000000000000100","0010000000011111","0111000000000100","0010000000000010","0111000000000010","0011000000000101","0111000000000101","0011000000000101","0111000000000010","0010000111101011","0111000000000010","0001000000000100","1001000000000010","0110000000101001","1001000000000010","0001000000000110","0010000000001010","0000000000000010","0101000000000100","0101000000000100","0100000000000101","0000000000000010","0101000000000100","0000000000000011","0010000000011000","0010000000001001","0111000000000111","0011000000000010","1001000000000011","0011000000000100","0011000000000011","1001000000000011","0011000000000010","0111000000000010","0010000111101010","0111000000000101","1001000000000010","0110000000101011","1001000000000010","0001000000000011","0010000000001011","0000000000000011","0101000000000110","0000000000000011","0100000000000011","0000000000000010","0101000000001000","0010000000011000","0111000000000010","0010000000000011","0111000000000100","0011000000001000","0110000000000101","0011000000001001","0011000000000010","0111000000000100","0010000111101000","0111000000000011","0001000000000100","0110000000101011","1001000000000010","0001000000000011","0111000000000010","0010000000001010","0000000000000010","0101000000001000","0100000000000100","0000000000000010","0101000000000101","0000000000000010","0010000000010110","0111000000001010","0011000000000011","1001000000000011","0011000000000010","1001000000000010","0110000000000111","1001000000001000","0011000000000011","0111000000000101","0010000111100100","0111000000000100","1001000000000100","0110000000000011","0110000000101000","1001000000000010","0001000000000100","0010000000001010","0000000000000011","0101000000001010","0100000000000010","0000000000000010","0101000000000101","0000000000000010","0010000000010100","0111000000000011","0011000000001001","1001000000000010","0110000000000110","0110000000001001","0110000000001000","0011000000000110","0111000000000011","0010000111100011","0111000000000010","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0110000000100100","1001000000000101","0001000000000101","0010000000001010","0000000000000010","0101000000001000","0100000000000111","0101000000000100","0000000000000011","0010000000010010","0111000000000010","0011000000000010","1001000000001000","1001000000000011","0110000000000011","0110000000000011","0110000000001111","1001000000000010","0110000000000010","1001000000000010","0011000000000100","0111000000000011","0010000000000011","0010000111100010","1001000000000111","1001000000000011","0110000000100000","1001000000000100","1001000000000011","0001000000000101","0010000000001011","0101000000000110","0000000000001001","0101000000000110","0010000000010011","0111000000000011","0011000000000010","0110000000000110","0110000000000011","0110000000011001","0110000000000110","0011000000000011","0111000000000011","0010000111100001","0001000000000011","1001000000000111","1001000000000010","0110000000100001","1001000000000110","0001000000000110","0010000000001010","0000000000000010","0101000000001010","0000000000000011","0101000000000111","0000000000000010","0010000000010001","0111000000000011","0011000000000011","0110000000001011","0110000000010111","0110000000000111","0011000000000011","0111000000000011","0010000111011101","0111000000000010","0001000000001001","1001000000000011","0110000000011101","0110000000000100","1001000000000101","0001000000000101","0010000000001101","0101000000000110","0000000000000110","0101000000000100","0101000000000010","0000000000000011","0010000000010001","0111000000000100","0011000000000011","0110000000101011","0011000000000010","0111000000000011","0010000111100000","0001000000000111","1001000000001001","0110000000010111","1001000000000010","0110000000000101","1001000000000011","0001000000000110","0010000000001011","0000000000000010","0101000000001010","0000000000000011","0101000000000110","0000000000000011","0010000000010000","0111000000000011","0011000000000010","1001000000000010","0110000000101001","1001000000000010","0011000000000011","0111000000000100","0010000111011111","0001000000000110","1001000000000010","0110000000000010","1001000000000100","0110000000010110","1001000000000100","0110000000000100","1001000000000010","0001000000000011","0111000000000011","0010000000001100","0000000000000010","0101000000000101","0000000000000111","0101000000000011","0101000000000010","0000000000000010","0010000000010001","0111000000000011","0011000000000101","0110000000101001","1001000000000011","0011000000000011","0111000000000100","0010000111100011","0011000000000011","1001000000000100","0001000000000010","1001000000000010","0110000000000101","0110000000001000","1001000000000100","0110000000000011","1001000000000011","1001000000001000","0001000000000101","0010000000001101","0000000000000010","0101000000001100","0101000000000100","0101000000000010","0000000000000010","0010000000001111","0111000000000010","0001000000000100","1001000000000100","0110000000101001","1001000000000111","0111000000000101","0010000111011100","0111000000000110","0011000000000101","0001000000000010","1001000000000010","0110000000000010","1001000000000101","0110000000000101","1001000000000101","0110000000000100","1001000000001001","0001000000000101","0010000000001111","0101000000001100","0101000000000101","0000000000000010","0010000000010011","1001000000000101","0110000000110001","0011000000000011","0111000000000011","0010000111011110","0111000000000011","0001000000001010","1001000000000110","1001000000000010","0110000000000101","1001000000000100","1001000000000101","1001000000000011","0001000000001100","0010000000001101","0000000000000011","0101000000001011","0101000000000111","0010000000001111","0111000000000011","1001000000000110","0110000000101110","0110000000000010","1001000000000100","0111000000000100","0010000111011101","0111000000000010","0001000000000101","0001000000001001","0001000000000010","1001000000000011","0110000000000101","0001000000000011","1001000000000011","0110000000000011","1001000000000010","0001000000001010","0010000000001110","0000000000000010","0101000000001001","0101000000000111","0000000000000011","0010000000010000","0111000000000100","0110000000000011","0110000000110010","1001000000000100","0111000000000010","0010000111101000","0001000000001010","1001000000000011","1001000000000011","0001000000000110","1001000000000101","0001000000001100","0010000000010000","0101000000001010","0101000000001000","0010000000010001","0011000000000011","0110000000000101","0110000000110011","0001000000000010","0111000000000011","0010000111100000","0010000000000101","0111000000000010","0001000000001011","1001000000000010","0001000000001001","1001000000000010","0011000000000010","0001000000001010","0010000000001110","0000000000000101","0101000000010001","0010000000001110","0111000000000101","0110000000110111","1001000000000011","0111000000000010","0010000111101001","0001000000011110","0001000000000101","0010000000010001","0000000000000010","0101000000001111","0000000000000010","0010000000001110","0111000000000010","0001000000000100","0110000000111001","0001000000000010","0111000000000100","0010000111100111","0001000000011001","0111000000000011","0001000000000110","0010000000010011","0101000000001101","0000000000000011","0010000000001101","0111000000000010","0001000000000100","1001000000000010","0110000000110110","1001000000000010","0001000000000111","0010000111101010","0111000000000101","0001000000001000","0111000000000100","0001000000000111","0000000000000110","0010000000010010","0000000000000010","0101000000010000","0010000000001111","0001000000000010","1001000000000011","0110000000111000","0001000000000110","0111000000000100","0010000111101001","0111000000000011","0001000000001001","0111000000000110","0001000000000011","0000000000000111","0010000000010100","0101000000001110","0000000000000100","0010000000001100","0111000000000010","0001000000000010","1001000000000010","0110000000110111","1001000000000011","0001000000000110","0111000000000010","0010000111110000","0001000000000111","0100000000000011","0111000000000110","0000000000000110","0010000000010101","0101000000010000","0010000000001110","0001000000000110","0110000000111000","1001000000000101","0001000000000011","0111000000000010","0010000111110001","0000000000000111","0000000000000011","0100000000000011","0000000000000110","0010000000010011","0000000000000100","0101000000001100","0000000000000100","0010000000001001","0010000000000100","0001000000000011","1001000000000101","0110000000111000","1001000000000101","0001000000000010","0111000000000010","0010000111101111","0111000000000011","0000000000000101","0000000000000100","0111000000000010","0000000000000011","0000000000000100","0010000000011000","0101000000001011","0000000000000010","0010000000001111","0001000000001000","0110000000111000","1001000000000100","0001000000000011","0111000000000010","0010000111110001","0000000000000011","0000000000000101","0100000000000010","0000000000000010","0101000000000011","0000000000000010","0010000000010100","0000000000000010","0101000000010000","0010000000001111","0001000000000110","1001000000000011","0110000000110111","1001000000000100","0001000000000011","0010000111110111","0000000000001001","0101000000000100","0000000000000010","0010000000010010","0000000000000101","0101000000001010","0000000000000010","0010000000010000","0111000000000010","0001000000000100","1001000000000010","0110000000111000","1001000000000011","0001000000000110","0010000111110110","0000000000000101","0101000000000110","0000000000000101","0010000000010001","0101000000001110","0010000000010001","0111000000000011","0001000000000011","1001000000000010","0110000000001000","0110000000110011","0001000000000101","0010001000000000","0101000000000110","0010000000010010","0000000000000010","0101000000000011","0101000000000111","0101000000000100","0010000000010001","0111000000000100","1001000000000100","0110000000110110","1001000000000011","0001000000001001","0010000111111000","0000000000001001","0000000000000011","0010000000010001","0000000000000010","0101000000001110","0010000000010001","0001000000000100","1001000000000100","0110000000110101","1001000000000011","0001000000000110","0010001000000001","0000000000000010","0101000000000100","0000000000000011","0010000000001111","0000000000000010","0101000000001101","0010000000010100","0011000000000011","1001000000000101","0110000000110100","1001000000000010","0001000000000110","0010001000000000","0000000000000111","0000000000000010","0010000000010001","0101000000001100","0000000000000010","0010000000010010","0001000000000110","0001000000000010","1001000000000011","0110000000110001","0110000000000010","1001000000000011","0001000000000011","0010001000000110","0101000000000101","0000000000000010","0010000000001110","0000000000000010","0101000000001100","0000000000000010","0010000000010001","0001000000001001","1001000000000010","0110000000000101","0110000000101010","1001000000000011","0110000000000100","0001000000000101","0010001000000001","0000000000000110","0000000000000010","0010000000000011","0010000000001101","0000000000000010","0101000000001011","0000000000000010","0010000000010001","0001000000000100","0011000000000010","0001000000000010","1001000000000010","0110000000000011","0110000000000010","1001000000000011","0110000000100111","1001000000000111","1001000000000011","0001000000000100","0010001000000011","0000000000000011","0101000000000111","0010000000001100","0000000000000010","0101000000001101","0010000000010011","0111000000000100","0001000000000010","1001000000000011","0110000000000010","1001000000000101","0110000000101000","1001000000000011","1001000000000101","0001000000000110","0010001000000010","0000000000000101","0000000000000101","0010000000001100","0000000000000010","0101000000001110","0010000000010100","0001000000000100","1001000000000010","0110000000000010","1001000000000011","1001000000000100","0110000000100111","1001000000000110","0001000000000110","0111000000000010","0010001000000100","0000000000000010","0101000000000101","0000000000000010","0010000000001011","0000000000000100","0101000000001011","0010000000010101","0001000000000101","1001000000000100","0001000000000100","0110000000011101","0110000000001101","1001000000000011","0001000000001001","0111000000000010","0010001000000001","0000000000000110","0101000000000111","0010000000001001","0000000000000011","0101000000000011","0101000000000111","0000000000000010","0010000000010101","0001000000001000","0001000000000011","1001000000000011","0110000000000111","1001000000000100","0110000000000101","0110000000001001","1001000000000100","0110000000001110","0001000000001010","0010001000001001","0101000000000111","0010000000001001","0000000000000100","0101000000001011","0010000000010110","0001000000001110","0110000000000101","1001000000000010","0001000000000100","0110000000000110","0110000000000110","1001000000000010","0001000000000100","0110000000001100","1001000000000010","0001000000000010","0111000000000110","0111000000000010","0010001000000100","0000000000000011","0101000000000100","0000000000000011","0010000000000011","0010000000000111","0000000000000101","0101000000001000","0000000000000010","0010000000011000","0001000000001010","1001000000000010","0110000000000011","1001000000000111","0110000000000100","1001000000000100","0110000000000100","1001000000000011","0001000000000100","1001000000000010","0110000000000101","1001000000000101","0011000000000010","0001000000000010","0111000000000011","0010001000001100","0000000000000010","0101000000000110","0010000000001000","0000000000000101","0101000000001011","0010000000010111","0111000000000100","0001000000001001","1001000000000011","1001000000000010","0001000000000101","1001000000000011","1001000000000100","1001000000000011","0110000000000010","1001000000000011","0001000000000101","1001000000000010","0110000000000100","1001000000000100","1001000000000010","0001000000000100","0111000000000010","0010001000010110","0010000000000110","0000000000000100","0101000000001010","0000000000000010","0010000000011100","0001000000001101","0001000000000100","1001000000000101","0001000000000111","1001000000000100","0001000000000101","1001000000000011","0110000000000011","1001000000000010","0001000000000100","0001000000000100","0010001000010001","0101000000000101","0000000000000010","0010000000000101","0000000000000101","0101000000001100","0010000000011001","0111000000000010","0001000000010010","0011000000000010","1001000000000010","0001000000000111","1001000000000011","0001000000001001","1001000000000100","1001000000000010","0001000000001010","0010001000001100","0000000000001011","0010000000000010","0000000000000101","0101000000001100","0000000000000010","0010000000011100","0001000000010011","0001000000001001","0011000000000010","0001000000000111","0001000000000100","1001000000000011","0001000000001100","0010001000001110","0000000000000010","0101000000010000","0101000000001011","0000000000000010","0010000000011101","0111000000000011","0001000000010010","0111000000000010","0001000000001010","0111000000000010","0001000000001011","0111000000000100","0000000000000010","0010001000010011","0101000000000100","0000000000001000","0101000000000011","0101000000001110","0010000000011001","0010000000000100","0111000000000100","0001000000001111","0111000000000100","0001000000001000","0111000000000101","0001000000001000","0010000000000101","0111000000000010","0010001000010000","0000000000000100","0101000000001001","0101000000000011","0101000000000011","0101000000001011","0000000000000010","0010000000011011","0010000000000101","0001000000000111","0001000000001010","0111000000000011","0001000000001010","0010000000000011","0111000000000010","0001000000000110","0010001000011010","0101000000000111","0101000000000100","0101000000000011","0101000000001101","0000000000000010","0010000000100001","0000000000000011","0000000000001100","0010000000000110","0001000000000110","0010000000001011","0010001000011011","0000000000000010","0101000000001110","0101000000001101","0000000000000010","0010000000011100","0000000000001010","0000000000000111","0111000000000011","0010000000001011","0010000000001100","0010001000011101","0101000000011001","0000000000000011","0010000000011001","0000000000001000","0101000000000100","0000000000000010","0010000000000111","0010000000001010","0010000000001100","0111000000000010","0010001000011100","0000000000000100","0101000000011000","0000000000000010","0010000000011010","0000000000000010","0101000000000100","0000000000001000","0010000000010000","0010001000101001","0000000000000011","0101000000011010","0000000000000010","0010000000011000","0000000000000100","0101000000000100","0000000000000100","0010001001000010","0101000000011010","0010000000010111","0000000000000011","0101000000000101","0000000000000111","0010001001000000","0101000000011000","0000000000000010","0010000000010100","0000000000000100","0101000000000011","0101000000000010","0000000000000011","0010001001000100","0000000000000010","0101000000011000","0000000000000010","0010000000010101","0000000000000011","0101000000000111","0000000000000011","0010001001000010","0000000000000011","0101000000011001","0010000000010011","0000000000000010","0101000000000111","0000000000000010","0010001001001001","0101000000010111","0000000000000010","0010000000010111","0101000000001001","0000000000000100","0010001001000000","0000000000000011","0101000000010111","0000000000000010","0010000000010000","0000000000000011","0101000000000011","0101000000001001","0000000000000100","0010001001000101","0101000000011000","0010000000010010","0000000000000010","0101000000000110","0101000000001000","0000000000000100","0010001000111111","0000000000000011","0101000000010101","0000000000000010","0010000000001111","0000000000000011","0101000000001100","0000000000000011","0000000000000111","0010001001000010","0101000000010111","0010000000001101","0010000000000010","0000000000000100","0101000000001011","0000000000001010","0010001001000010","0101000000000100","0101000000010000","0000000000000010","0010000000001110","0101000000000100","0101000000000111","0000000000000100","0010000000000011","0010000000000100","0010001001000100","0000000000000100","0101000000010100","0010000000001100","0000000000000100","0101000000001010","0000000000000100","0010000000000011","0010000000000111","0010001001000010","0101000000000101","0101000000010001","0010000000001010","0000000000000100","0101000000001001","0000000000000010","0010001001010000","0000000000000011","0101000000000011","0101000000010010","0010000000001001","0000000000000100","0101000000001001","0000000000000100","0010001001001111","0000000000000011","0101000000010101","0010000000000101","0000000000000011","0101000000001011","0000000000000010","0010001001010100","0000000000000011","0101000000010010","0000000000000110","0010000000000010","0000000000000100","0101000000001100","0010001001010010","0000000000000010","0101000000010100","0000000000001000","0101000000001011","0000000000000010","0010001001010110","0000000000000011","0101000000011100","0101000000001011","0000000000000011","0010001001010100","0101000000010111","0101000000000100","0101000000001111","0010001001010110","0000000000000010","0101000000100100","0000000000000011","0010001001010110","0000000000000010","0101000000100011","0000000000000010","0010001001011010","0000000000000100","0101000000100011","0010001001011001","0000000000000011","0101000000000011","0101000000011101","0000000000000010","0010000110011010","0111000000000010","0010000011000000","0000000000000101","0101000000011110","0000000000000011","0010000110010110","0111000000000111","0010000000000100","0111000000000010","0010000010110111","0000000000000101","0101000000011011","0000000000000011","0010000110010111","0111000000000011","0011000000000100","0111000000000100","0111000000000110","0010000010110110","0000000000000011","0101000000011101","0000000000000011","0010000110010011","0010000000000011","0111000000000010","0011000000000100","0011000000000011","0111000000000100","0011000000000010","0111000000000010","0010000000000101","0111000000000010","0010000010110010","0101000000011010","0000000000000100","0010000110010010","0111000000000111","0011000000000010","1001000000000010","0110000000000011","0011000000000011","0011000000000111","0010000000000011","0111000000000100","0010000010101110","0000000000000100","0101000000011101","0010000110001111","0010000000000011","0111000000000110","0011000000000011","0110000000000110","1001000000000010","0110000000000100","0011000000000011","0111000000001001","0010000010101011","0000000000000010","0101000000011011","0000000000000100","0010000110010001","0111000000000011","0011000000000101","0110000000010000","0011000000001010","0010000010101101","0000000000000011","0101000000011010","0000000000000010","0010000110010000","0111000000000101","1001000000000100","0110000000010010","1001000000000011","1001000000000011","0011000000000110","0010000010101011","0101000000011101","0010000110010001","0001000000000100","1001000000000010","0110000000000011","0110000000011011","0111000000000010","0010000010101011","0000000000000010","0101000000011101","0010000110010000","0001000000000010","1001000000000011","0110000000011110","0011000000000011","0111000000000010","0010000010101100","0101000000010110","0000000000000011","0010000110010001","0001000000000100","1001000000000011","0110000000011111","0011000000000011","0010000010101010","0000000000000010","0101000000011011","0010000110010001","0001000000000010","0011000000000010","1001000000000100","0110000000011111","0111000000000011","0010000010100111","0000000000000010","0101000000011000","0000000000000010","0010000110010000","0111000000000010","0001000000000111","1001000000000010","0110000000011110","0011000000000011","0010000010101001","0000000000000010","0101000000011011","0010000110010000","0001000000000111","1001000000000011","0110000000011110","0111000000000010","0010000010101000","0000000000000010","0101000000011000","0000000000000010","0010000110010000","0001000000001010","0110000000011110","0011000000000010","0111000000000010","0010000010101001","0000000000000011","0101000000010111","0000000000000010","0010000110010001","0001000000000101","1001000000000010","0110000000100000","0011000000000010","0111000000000010","0010000010100111","0000000000000111","0101000000010001","0000000000000100","0010000110001101","0111000000000010","0001000000001001","0110000000100001","0011000000000011","0111000000000011","0010000010100110","0000000000000011","0101000000000011","0101000000010101","0010000110001111","0001000000000110","1001000000000010","0110000000100011","0011000000000100","0111000000000100","0010000010100010","0000000000000110","0101000000010001","0000000000000100","0010000110001111","0001000000000111","1001000000000010","0110000000101000","0111000000000010","0010000010100100","0000000000000101","0101000000010101","0010000110010001","0001000000000101","1001000000000010","0110000000100111","0011000000000010","0111000000000010","0010000010100011","0000000000000010","0101000000000011","0101000000010000","0000000000000101","0010000110010000","0001000000000110","1001000000000011","0110000000100110","0011000000000010","0010000010100101","0000000000000011","0101000000010101","0010000110010011","0001000000001001","0110000000100101","0011000000000011","0010000010100011","0000000000000010","0101000000010101","0010000110010011","0001000000001010","1001000000000011","0110000000100100","0111000000000010","0010000010100100","0000000000000010","0101000000010110","0010000110010010","0001000000001010","1001000000000010","0110000000100100","0111000000000010","0010000010100011","0000000000000010","0101000000010011","0000000000000010","0010000110010001","0001000000001100","1001000000000011","0110000000100010","0011000000000011","0010000010100110","0101000000010101","0000000000000010","0010000110010000","0001000000001100","1001000000000010","0110000000100010","0011000000000011","0010000010100111","0101000000010010","0000000000000010","0010000110001111","0111000000000010","0001000000001100","1001000000000011","0110000000100010","0011000000000011","0010000010100101","0000000000000010","0101000000010110","0010000110010000","0001000000001110","0110000000100010","0011000000000011","0010000010100100","0000000000000100","0101000000000011","0101000000001110","0000000000000010","0010000110010011","0001000000001100","1001000000000011","0110000000100000","0011000000000010","0111000000000010","0010000010100100","0000000000000110","0101000000010000","0000000000000010","0010000110001111","0001000000000111","1001000000000101","0001000000000111","0110000000100000","0111000000000100","0010000010100011","0101000000010011","0000000000000010","0010000110001111","0001000000001000","1001000000001011","1001000000000010","0110000000011111","0011000000000011","0111000000000010","0010000010100010","0000000000000011","0101000000000011","0101000000010010","0010000110001110","0001000000000110","1001000000000110","1001000000001001","0110000000011111","0011000000000011","0111000000000100","0010000010011110","0000000000000011","0101000000010010","0000000000000010","0010000110001010","0111000000000011","0001000000000111","1001000000000011","0110000000000110","1001000000000110","1001000000000010","0110000000100000","1001000000000010","0011000000000011","0010000010100000","0000000000000110","0101000000010010","0010000110001000","0111000000000110","0001000000000100","1001000000000011","0110000000000100","0110000000000101","1001000000000100","0110000000100011","0011000000000010","0111000000000010","0010000010011111","0000000000000010","0101000000010010","0000000000000010","0010000110000111","0111000000000010","0001000000000100","0001000000001000","1001000000000010","0110000000000101","0110000000001001","0110000000100001","1001000000000011","0111000000000010","0010000010011111","0000000000000101","0101000000010001","0000000000000010","0010000110000110","0001000000001110","1001000000000011","0110000000101101","1001000000000011","0111000000000011","0010000010011110","0000000000000011","0101000000010001","0000000000000010","0010000110000111","0001000000010000","1001000000000011","0110000000101101","0011000000000010","0111000000000010","0010000010011111","0000000000000011","0101000000010100","0010000110000111","0001000000010000","1001000000000011","0110000000101100","0011000000000010","0111000000000010","0010000010011110","0000000000000011","0101000000000011","0101000000001111","0000000000000100","0010000110000100","0001000000000101","1001000000000101","0001000000001001","1001000000000010","0110000000101011","1001000000000010","0011000000000011","0010000010011111","0000000000000010","0101000000010101","0010000110000101","0001000000000110","1001000000000101","0001000000001000","1001000000000010","0110000000101110","0111000000000011","0010000010011101","0000000000000011","0101000000010010","0000000000000100","0010000110000010","0001000000001001","1001000000000101","0001000000000101","1001000000000100","0110000000101000","0110000000000101","0011000000000011","0010000010011111","0000000000000010","0101000000010101","0010000110000101","0001000000001000","1001000000000100","0001000000000100","1001000000000011","0110000000000111","0110000000100000","1001000000000101","0110000000000011","0011000000000011","0010000010011110","0000000000000010","0101000000010011","0000000000000100","0010000110000011","0001000000001111","1001000000000100","0110000000000100","1001000000000101","0110000000011110","1001000000000101","0110000000000010","1001000000000011","0111000000000010","0010000010011111","0000000000000010","0101000000010101","0010000110000100","0001000000001101","0001000000000010","1001000000000011","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000011010","0110000000000111","1001000000000010","0110000000000010","1001000000000010","0011000000000011","0010000010100000","0101000000010011","0000000000000100","0010000110000010","0001000000001110","1001000000000011","0110000000000110","1001000000000010","0001000000000010","1001000000000011","0110000000011000","1001000000000100","1001000000000101","0110000000000011","1001000000000011","0111000000000010","0010000010100010","0101000000010100","0010000110000100","0001000000001100","1001000000000100","0110000000000110","1001000000000010","0001000000000100","1001000000000010","0110000000010111","1001000000000010","0001000000000111","0110000000000101","0011000000000010","0111000000000010","0010000010011101","0000000000000011","0101000000010010","0000000000000011","0010000110000101","0001000000001010","1001000000000100","0110000000001000","1001000000000010","0001000000000011","1001000000000010","0110000000010110","1001000000001000","0110000000001001","0111000000000010","0010000010100000","0101000000010101","0010000110000100","0001000000001101","1001000000000011","0110000000000110","1001000000000110","1001000000000010","0110000000010110","1001000000000101","0110000000000101","0110000000000111","0111000000000010","0010000010011111","0101000000010011","0000000000000100","0010000110000001","0001000000001111","1001000000000111","1001000000000101","1001000000000100","0110000000011001","1001000000000011","0110000000001011","0111000000000010","0010000010011110","0000000000000010","0101000000010110","0010000110000010","0000000000000010","0001000000010000","1001000000000011","1001000000000100","1001000000000101","0110000000011000","1001000000000100","1001000000000010","0110000000000110","1001000000000100","0111000000000010","0010000010011100","0000000000000101","0101000000010110","0010000110000010","0001000000010011","1001000000000011","0001000000000010","1001000000000010","0110000000010100","1001000000000101","1001000000000011","0001000000000100","0110000000000111","0011000000000011","0111000000000010","0010000010011110","0000000000000101","0101000000010100","0010000110000100","0001000000010111","1001000000000010","0110000000010100","1001000000001001","0001000000000010","1001000000000011","0110000000000100","1001000000000010","0001000000000010","0111000000000010","0010000010011100","0000000000000111","0101000000010010","0000000000000011","0010000110000010","0001000000011000","1001000000000010","0110000000010100","1001000000000011","1001000000000011","0001000000000100","1001000000000010","0110000000000110","1001000000000100","0111000000000010","0010000010100011","0101000000010100","0000000000000010","0010000110000010","0001000000010101","1001000000000100","0110000000010101","1001000000000011","0001000000000101","1001000000000011","0110000000000011","0110000000000011","1001000000000011","0001000000000101","0010000010011010","0000000000000110","0101000000010100","0000000000000100","0010000110000000","0001000000010111","1001000000000010","0110000000001010","0110000000010001","0001000000000010","1001000000000100","0110000000000010","1001000000000010","0110000000000010","1001000000000101","0111000000000010","0010000010011100","0000000000000011","0101000000000100","0101000000001010","0101000000001011","0010000110000010","0001000000011000","1001000000000011","1001000000000101","0110000000010000","1001000000000111","0110000000000101","1001000000000101","0001000000000101","0010000001110001","0111000000000100","0010000000100111","0000000000000010","0101000000000011","0101000000000011","0101000000001000","0101000000001001","0000000000000011","0010000010011001","0010000010100001","0111000000000011","0010000001000011","0001000000011001","1001000000000100","1001000000000011","1001000000000100","0110000000000110","0110000000001001","1001000000000011","0110000000000101","1001000000000010","0001000000000101","0001000000000110","0010000001110010","0111000000000011","0010000000100111","0000000000000011","0101000000000011","0101000000001001","1000000000000011","0101000000001011","0010000001000101","0010000001010001","0111000000000100","0010000001001110","0010000001010000","0111000000000100","0010000000110001","0010000000010100","0001000000011011","0001000000000101","0011000000000011","0110000000000011","1001000000000011","0110000000001001","1001000000000100","1001000000000100","0001000000001011","0111000000000010","0010000000001101","0010000001100010","0111000000000110","0010000000101000","0101000000000110","0101000000000101","1000000000000101","0101000000001011","0010000001110100","0010000000100001","0111000000000101","0010000010011101","0111000000000101","0010000001000100","0001000000100010","1001000000000110","0001000000000011","0110000000000100","1001000000000011","0001000000000010","1001000000000110","0001000000001101","0010000000001100","0010000000011010","0010000001001010","0111000000000011","0111000000000011","0010000000100110","0000000000000100","0101000000000010","0000000000000111","1000000000000100","1000000000000011","0101000000000111","0000000000000010","0010000000111000","0010000000001100","0111000000000010","0010000000011100","0010000000110011","0111000000000111","0010000001001001","0111000000000110","0010000000010111","0010000000111010","0010000001000011","0001000000100100","0011000000000011","0001000000000100","1001000000000010","0110000000000011","1001000000000010","0001000000000100","0011000000000100","0001000000001101","0111000000000010","0010000000001110","0010000000011000","0010000000101010","0010000000011110","0111000000000011","0011000000000010","0111000000000010","0010000000101001","0000000000000100","0000000000000100","1000000000000011","0011000000000101","0101000000000111","0000000000000010","0010000000100100","0010000000001110","0010000000010001","0111000000000010","0010000000110011","0010000000011110","0111000000000011","0111000000000011","0010000001000111","0111000000000111","0010000000010111","0010000000110101","0111000000000101","0111000000000011","0010000000111000","0010000000001000","0111000000000100","0001000000101001","1001000000000011","1001000000000010","0001000000011001","0010000000001100","0010000000010110","0111000000000100","0010000000101000","0111000000000101","0010000000011011","0111000000000101","0111000000000010","0010000000100110","0000000000000100","0000000000000011","0000000000000100","1000000000000111","0000000000000011","0101000000000110","0000000000000010","0010000000011110","0010000000000100","0111000000001000","0111000000000100","0010000000000111","0010000000001101","0111000000000100","0010000000011011","0010000000010100","0111000000000110","0010000000011001","0111000000000100","0111000000000011","0010000001000000","0010000000000111","0111000000001000","0010000000001110","0010000000000111","0111000000000011","0010000000010110","0111000000000100","0010000000001111","0010000000001010","0111000000000100","0011000000000010","0111000000000010","0010000000111010","0010000000001000","0001000000100110","0001000000000110","1001000000000101","0001000000001001","0001000000001011","0001000000000101","0010000000001010","0111000000000100","0010000000010001","0111000000000110","0010000000011010","0010000000001110","0011000000000100","0111000000000010","0010000000001101","0111000000000010","0010000000001010","0111000000000011","0111000000000011","0010000000101000","0000000000000101","0000000000000011","0000000000000010","1000000000000100","1001000000000010","0001000000000111","1000000000000011","0000000000000010","0111000000000101","0010000000001111","0010000000000011","0010000000000011","0111000000000110","0111000000000101","0111000000010000","0010000000001000","0111000000001001","0111000000000010","0010000000001101","0010000000001100","0010000000000110","0010000000000011","0010000000001010","0111000000000011","0011000000000010","0111000000000011","0010000000011000","0111000000000010","0011000000000011","0111000000000010","0010000000110100","0111000000000011","0010000000001010","0111000000000111","0011000000000100","0111000000000100","0010000000001100","0010000000001101","0010000000001001","0010000000001011","0111000000000100","0111000000000010","0010000000001001","0111000000000100","0010000000001010","0111000000000100","0111000000000101","0010000000100110","0111000000000100","0111000000000110","0111000000001010","0010000000000111","0001000000100100","0011000000000011","0001000000000111","1001000000000011","0001000000001000","0011000000000010","0001000000010000","0010000000001100","0111000000000100","0010000000001110","0111000000000010","0011000000000011","0111000000000010","0010000000010001","0010000000001001","0010000000001011","0010000000000100","0011000000000101","0111000000000010","0010000000001010","0111000000000100","0010000000001010","0011000000000011","0111000000000011","0010000000101001","0000000000001000","1000000000000110","0001000000001001","1000000000000100","0111000000000101","0010000000000011","0010000000000110","0111000000001000","0111000000001000","0111000000000100","0011000000000100","0111000000000100","0001000000000010","0111000000001011","0111000000000100","0111000000001000","0011000000000010","0111000000000011","0010000000001011","0111000000000101","0010000000000101","0111000000000100","0010000000000101","0010000000000100","0111000000000010","0010000000001000","0111000000000011","0011000000000101","0010000000001101","0010000000001001","0111000000000011","0011000000000010","0111000000000010","0010000000011101","0010000000011010","0111000000000010","0010000000001011","0111000000000100","0011000000000100","0011000000000100","0111000000000010","0010000000001010","0111000000000100","0010000000000111","0111000000000100","0010000000001011","0010000000001000","0111000000000010","0011000000000101","0010000000001000","0111000000000101","0010000000001100","0011000000000010","0111000000000010","0010000000101000","0111000000000010","0011000000000100","0111000000000101","0001000000000010","0111000000001011","0111000000000011","0001000000100101","0011000000000010","0001000000010010","0011000000000011","0001000000001011","0001000000000011","0111000000000010","0010000000001011","0001000000000101","0010000000000111","0111000000000100","0111000000000100","0011000000000011","0111000000000010","0010000000001110","0111000000000100","0010000000000111","0111000000000011","0010000000001010","0010000000000100","0011000000000100","0111000000000010","0010000000000111","0111000000001000","0010000000000111","0111000000000010","0011000000000100","0010000000011010","0111000000000011","0010000000001100","0000000000000100","0001000000000111","0110000000000100","0001000000000100","0001000000000011","0011000000001000","0111000000001011","0111000000000011","0011000000000010","0111000000000100","0111000000000101","0011000000000010","0111000000000011","0011000000000011","0011000000000110","0001000000000110","0111000000000101","0111000000000100","0001000000000100","0111000000000100","0011000000000100","0111000000000011","0010000000001011","0111000000000101","0111000000000010","0010000000000110","0001000000000100","0010000000001010","0010000000000110","0111000000000100","0011000000000110","0010000000001000","0111000000001001","0010000000000101","0111000000000100","0111000000000100","0010000000011001","0111000000000100","0010000000001010","0010000000001001","0010000000000010","0111000000000010","0001000000000100","0010000000000110","0111000000000010","0001000000000101","0011000000000111","0111000000000111","0010000000000101","0111000000000101","0111000000000011","0010000000000011","0111000000000010","0001000000000011","0111000000000010","0010000000001000","0111000000000110","0111000000000011","0111000000000011","0011000000000110","0010000000000111","0111000000000010","0011000000000011","0111000000000010","0010000000001000","0111000000000010","0011000000000010","0111000000000011","0010000000011010","0111000000000101","0010000000001000","0111000000000101","0011000000000011","0111000000000010","0001000000000110","0111000000001011","0001000000100011","0011000000000100","0011000000000010","0001000000010001","0011000000000101","0001000000001011","0100000000001000","0010000000000100","0111000000000111","0010000000000100","0111000000000101","0111000000000100","0011000000000101","0111000000000010","0010000000000110","0010000000001010","0111000000000011","0010000000001010","0010000000000101","0001000000000100","0010000000000010","0111000000000010","0011000000000101","0111000000000010","0010000000000110","0111000000000101","0111000000000100","0010000000001000","0011000000000100","0010000000000111","0010000000010000","0010000000000011","0111000000000100","0111000000000101","0010000000000100","0111000000000010","0001000000000010","0000000000000011","0001000000000111","0110000000000100","0001000000000101","0110000000000100","1000000000000100","0011000000000011","0001000000000100","0111000000000111","0011000000000100","0111000000000010","0001000000000010","0111000000000101","0011000000000111","1001000000000011","0011000000000010","0001000000001001","0111000000000010","0001000000000011","0111000000000010","0001000000001000","0011000000000101","0111000000001000","0111000000000010","0010000000001001","0111000000000011","0010000000000010","0111000000000010","0001000000000100","0010000000000011","0111000000000011","0001000000000011","0111000000000101","0111000000000111","0011000000000101","0111000000000010","0010000000000101","0111000000001011","0010000000000100","0111000000000011","0011000000000011","0111000000000010","0010000000011000","0111000000001000","0010000000000101","0111000000001010","0111000000000110","0001000000000010","0111000000000011","0010000000000010","0111000000001011","0011000000001010","0111000000000011","0010000000001000","0001000000000011","0111000000000011","0010000000000100","0001000000000010","0111000000000101","0010000000000100","0001000000000010","0111000000000011","0111000000001001","0011000000000110","0010000000000110","0111000000000010","0011000000000011","0111000000000100","0010000000000101","0111000000000010","0011000000000100","0111000000000010","0010000000001000","0010000000001011","0111000000000010","0010000000000100","0111000000000100","0111000000000100","0010000000000100","0111000000001000","0011000000000010","0001000000000110","0011000000000011","0111000000000101","0111000000000011","0001000000101000","0111000000000010","0001000000010001","0011000000000110","0001000000001011","0111000000001001","0010000000000111","0111000000001010","0001000000000011","0111000000000011","0011000000000101","0111000000000111","0111000000000100","0010000000000101","0001000000000100","0111000000000010","0010000000000111","0111000000000101","0010000000000010","0001000000000100","0010000000000010","0111000000000011","0011000000000100","0111000000000010","0010000000000101","0111000000000010","0011000000000101","0111000000000100","0010000000000101","0111000000000100","0011000000000011","0010000000000101","0111000000000010","0010000000001010","0111000000000100","0010000000000100","0111000000000010","0011000000000110","0010000000000100","0111000000000110","0001000000000111","0110000000000101","0001000000000010","1001000000000100","0110000000000011","1000000000000100","0011000000000011","0001000000000101","0011000000000111","0011000000000101","0001000000000100","0011000000001010","1001000000000010","0110000000000011","0011000000000010","0001000000000011","0011000000000101","0001000000001101","0011000000000110","0111000000001011","0010000000000110","0001000000000011","0111000000000010","0010000000000010","0111000000000011","0001000000000100","0010000000000111","0001000000000010","0111000000001100","0011000000000011","0011000000000011","0010000000000101","0111000000000011","0011000000000100","0011000000000010","0111000000000011","0010000000000011","0111000000000011","0011000000000100","0111000000000110","0010000000001100","0111000000000111","0111000000000011","0011000000000100","0111000000000010","0010000000000011","0111000000001010","0001000000000011","0111000000000101","0001000000000011","0111000000000011","0111000000000010","0001000000000111","0011000000000110","0011000000000110","0001000000000011","0111000000000010","0010000000001000","0001000000000100","0111000000000101","0001000000000100","0010000000000010","0111000000000011","0001000000000100","0111000000001000","0111000000000011","0011000000000111","0010000000000111","0011000000000100","0111000000000110","0010000000000010","0111000000000011","0011000000000101","0111000000000011","0010000000001110","0111000000000101","0010000000000100","0111000000000010","0011000000000100","0111000000000010","0010000000000011","0111000000000011","0011000000000010","1001000000000010","0110000000000011","0011000000000010","0001000000000011","0011000000000101","0001000000000100","0111000000000010","0001000000000011","0001000000010100","0001000000001000","0001000000000111","0011000000000100","0001000000001110","0001000000001000","0011000000000011","0111000000000010","0001000000000110","0111000000000101","0111000000000011","0001000000000100","0010000000000100","0111000000000010","0001000000000010","0111000000001101","0011000000000111","0111000000000011","0111000000001000","0010000000001100","0010000000000110","0111000000000110","0001000000000101","0010000000000011","0111000000000010","0011000000000011","0011000000000010","0111000000000011","0010000000000011","0111000000000010","0011000000000111","0111000000000101","0111000000000011","0011000000000110","0111000000000111","0010000000001010","0111000000000101","0010000000000010","0111000000000011","0011000000000101","0111000000000010","0010000000000011","0111000000000011","0001000000001011","0110000000000110","1001000000000010","0110000000000011","0110000000000011","1000000000000110","0001000000000101","0011000000000101","0001000000000010","1001000000000010","0011000000000101","0001000000000011","0011000000000110","0001000000000010","1001000000000011","0110000000000011","1001000000000110","0011000000000100","0001000000001011","0111000000000010","0011000000001001","0001000000000100","0111000000000100","0010000000001010","0001000000000010","0010000000000100","0001000000000110","0111000000000101","0001000000000011","0111000000000100","0011000000000011","0111000000000100","0011000000000100","0011000000000011","0010000000000100","0111000000000010","0011000000000110","0011000000000011","0111000000000100","0111000000000010","0011000000000111","0111000000000110","0010000000001011","0111000000000101","0100000000000010","0111000000000011","0011000000000100","0111000000000010","0010000000000010","0111000000000011","0011000000000111","0001000000000101","0111000000001000","0111000000000111","0001000000000101","0011000000000111","0001000000000100","0011000000000011","0111000000000010","0010000000001001","0001000000001010","0111000000000111","0001000000000011","0111000000000101","0011000000000011","0111000000000101","0011000000000101","0111000000000010","0010000000000011","0111000000000100","0011000000000010","0111000000000101","0111000000000011","0111000000000010","0011000000000111","0111000000000110","0010000000001011","0111000000000100","0010000000000100","0111000000000010","0011000000000101","0111000000000010","0010000000000010","0111000000000010","0011000000000011","0110000000001000","0011000000000011","0011000000000100","0001000000000111","0001000000010110","0001000000000110","1001000000000010","0001000000000101","0011000000000111","0001000000001100","0111000000000010","0001000000001000","0011000000000100","0001000000000111","0111000000001011","0111000000000011","0010000000000100","0001000000000010","0111000000000101","0001000000000101","0111000000000010","0011000000000011","0011000000000011","0111000000000111","0111000000000100","0010000000001000","0001000000000110","0010000000000100","0001000000000010","0111000000001000","0001000000000100","0100000000000011","0011000000000011","0011000000000011","0111000000000011","0111000000000011","0011000000000110","0011000000000101","0111000000000011","0011000000000100","0110000000000011","0011000000000110","0111000000000010","0010000000000010","0111000000000010","0010000000000111","0011000000000010","0111000000000010","0010000000000100","0011000000000111","0010000000000100","0011000000000011","1001000000000011","0001000000000110","0110000000000110","0001000000000100","0110000000000011","1000000000000111","1001000000000100","0001000000000010","1001000000000100","0011000000000010","0001000000000011","1001000000000010","0011000000000101","0001000000000010","0011000000000111","0011000000000010","0110000000000101","1001000000000110","0011000000000100","0001000000000100","0001000000000100","0111000000000100","0011000000000100","0011000000000100","0001000000000101","0011000000000100","0010000000001000","0001000000001000","0111000000000111","0111000000000100","0001000000000011","0111000000000010","0001000000000101","0111000000000100","0111000000000101","0011000000000010","0111000000000100","0111000000000011","0011000000000101","0011000000000101","0111000000000100","0011000000000010","1001000000000011","0011000000001000","0111000000000010","0010000000001001","0111000000000110","0100000000000100","0011000000000010","1001000000000011","0111000000000011","0111000000000100","0011000000000011","0001000000001011","0001000000000101","0111000000000100","0001000000000110","0011000000000010","0110000000000010","0011000000000110","0001000000000011","0011000000000100","0111000000000010","0010000000000111","0001000000000100","0111000000000011","0100000000000110","0111000000000101","0001000000000100","0111000000000011","0001000000000011","0011000000000010","0111000000000100","0011000000000110","0111000000001011","0111000000000010","0011000000000100","0111000000000011","0011000000000110","0011000000001001","0010000000001001","0111000000000011","0111000000000011","0010000000000011","0111000000000010","0011000000000011","0011000000000011","0111000000000101","0011000000000010","0110000000000111","1001000000000101","0011000000000100","0001000000000110","0001000000010100","0011000000000011","0001000000000110","1001000000000011","0001000000000111","0011000000000011","0001000000001101","0111000000000010","0001000000000111","1001000000000010","0011000000000100","0001000000000101","0011000000000011","0111000000000010","0001000000000011","0001000000000010","0111000000000111","0001000000000110","0111000000000010","0001000000000100","0111000000000011","0011000000000100","0011000000000110","0001000000000011","0011000000000010","0111000000000011","0010000000001100","0111000000000111","0001000000000011","0111000000000100","0001000000000101","0010000000000010","0111000000000110","0011000000000011","0111000000000100","0011000000001111","0011000000000101","0110000000000011","0001000000000010","0011000000000101","0111000000000100","0010000000000101","0111000000000010","0011000000000100","0010000000000011","0111000000000010","0011000000000011","0011000000000100","0010000000000011","0011000000000110","0001000000000100","1001000000000011","0110000000000111","1001000000000010","0110000000001100","1001000000000101","1001000000000010","0110000000000011","0001000000000100","0110000000000010","0011000000000100","0001000000000010","0011000000000110","0001000000000010","1001000000000010","0110000000001010","0011000000000100","0001000000000010","0011000000000010","0001000000000101","0111000000000010","0011000000000100","0011000000000110","0001000000000011","0011000000000101","0010000000000111","0100000000000010","0001000000000111","0111000000000011","0001000000000100","0011000000000010","0111000000000010","0001000000000100","0111000000000010","0001000000000010","0011000000000011","0111000000000100","0011000000000011","0110000000000011","0011000000000010","0111000000000110","0011000000001100","0011000000000011","0110000000000101","0001000000000011","0011000000000101","0111000000000010","0010000000000011","0010000000000100","0111000000000010","0011000000000010","0111000000000010","0100000000000100","0011000000000010","1001000000000010","0011000000000010","0111000000000110","0011000000000110","0001000000000111","0111000000000100","0001000000000111","0001000000000100","0011000000000010","1001000000000011","0011000000000110","0001000000000011","0011000000000101","0010000000000100","0010000000000110","0001000000000011","0111000000000101","0111000000000010","0001000000000100","0111000000000100","0001000000000101","0001000000000010","0011000000000100","0111000000000011","0011000000000011","1001000000000010","0011000000000010","0111000000000100","0011000000000110","0111000000000010","0011000000001011","1001000000000100","0001000000000010","0011000000000110","0010000000001000","0111000000000011","0011000000000011","0010000000000011","0111000000000010","0011000000000100","0011000000000010","0111000000000100","0011000000000100","0110000000001011","0011000000000100","0001000000000010","0011000000000010","0001000000010111","0001000000000111","1001000000000100","0001000000000101","0011000000000101","0001000000001011","0011000000000100","0001000000001001","0011000000000101","0001000000000011","0011000000001010","0001000000000011","0111000000000111","0001000000000100","0100000000000011","0001000000000100","0111000000000110","0011000000000100","0001000000000100","0011000000000100","0111000000000010","0010000000000110","0111000000000010","0001000000000110","0111000000000010","0100000000000100","0001000000000100","0111000000000110","0111000000000110","1001000000000101","0011000000000100","0011000000000100","1001000000000010","0011000000000011","1001000000000010","0011000000000111","0110000000000100","1001000000000100","1001000000000010","0011000000000011","0111000000000100","0010000000000101","0111000000000010","0011000000000011","0111000000000010","0010000000000010","0111000000000011","1001000000000011","0011000000000010","0111000000000110","0110000000000011","1001000000000011","0001000000000011","0110000000000111","0001000000000100","0110000000001010","0110000000000011","1001000000000011","1001000000000110","0001000000000010","1001000000000100","0011000000000100","0001000000000010","1001000000000011","0011000000000100","1001000000000011","0110000000001010","0011000000000101","1001000000000011","0001000000000101","0111000000000010","0011000000000101","0011000000000100","0001000000000110","0011000000000011","0010000000001101","0111000000001010","0011000000000101","0001000000000100","0001000000000011","0011000000000011","0111000000000101","1001000000000010","0110000000000100","0011000000000110","0110000000000010","0011000000000011","1001000000000100","0011000000000110","0110000000001001","1001000000000010","0011000000000011","0111000000000100","0010000000000101","0111000000000100","0111000000000010","0100000000000010","0111000000000101","1001000000000010","0011000000000010","0111000000000100","0011000000001000","0111000000000010","0011000000000110","0001000000000110","0001000000001010","1001000000000011","0011000000000010","0111000000000010","0001000000000101","0011000000000011","0111000000000010","0010000000001000","0001000000000110","0111000000000100","0001000000000100","0011000000000111","0001000000000111","0011000000000010","0111000000000011","0011000000000011","0110000000000011","0011000000000110","0110000000000010","1001000000000010","0011000000000101","1001000000000010","0011000000000100","1001000000000010","0110000000000011","1001000000000010","0001000000000010","1001000000000011","0011000000000010","0111000000000110","0010000000000011","0111000000000010","0011000000000011","0111000000000010","0010000000000100","0011000000000100","0011000000000011","0111000000000011","0011000000000011","0110000000001100","0011000000000100","0001000000000010","0011000000000101","0001000000010001","0111000000000100","0001000000000101","1001000000000101","0001000000000010","1001000000000101","0011000000000011","0001000000000100","0001000000000110","0011000000000101","0001000000000111","1001000000000011","0011000000000100","0001000000000100","1001000000000010","0011000000000011","0111000000000011","0001000000000010","0111000000000110","0001000000000111","0111000000000011","0001000000000101","0011000000000010","0110000000000011","0011000000000100","0001000000000110","0011000000000010","0111000000000011","0010000000000101","0111000000000110","0001000000000101","0001000000000101","0011000000000101","0001000000000100","0111000000000011","0001000000000011","0110000000000101","0011000000000110","0110000000000100","1001000000000101","1001000000000100","1001000000000011","0110000000000011","1001000000000010","0001000000000010","1001000000000100","0011000000000010","0111000000000101","0010000000000010","0111000000000010","0011000000000100","0111000000000101","0011000000000100","0110000000000100","0111000000000101","0110000000000100","1001000000000011","0001000000000011","0110000000001000","1001000000001100","1001000000000011","1001000000000011","1001000000000010","0110000000000011","1001000000000100","0110000000000011","0011000000000100","0001000000000100","0110000000000010","1001000000000010","0001000000000010","1001000000000010","0110000000001010","0011000000000100","0001000000000100","0001000000000110","0011000000000100","0110000000000010","0011000000000010","0111000000000010","0001000000000100","1001000000000100","0111000000000010","0010000000000100","0111000000000100","0001000000001001","0001000000000101","0011000000000100","0111000000000010","0001000000000111","0011000000000101","0001000000000010","1001000000000010","0110000000000101","0011000000000101","0110000000000101","1001000000000010","0110000000000100","0001000000000100","0110000000000100","1001000000000101","1001000000000100","0011000000000010","0111000000000101","0010000000000010","0111000000000010","0011000000000100","0111000000000011","0111000000000010","0011000000000011","0110000000000011","0011000000000100","0111000000000010","0011000000001001","0011000000000011","0011000000000011","0001000000000111","0001000000000101","0011000000000100","0110000000000010","0011000000000100","0001000000000110","0011000000001001","0111000000000101","0001000000000110","0111000000000010","0001000000000101","0011000000001000","0001000000000100","1001000000000010","0011000000000011","0001000000000011","1001000000000010","0110000000000100","0011000000000011","1001000000000010","0110000000000100","0011000000000100","0110000000000100","0001000000000011","1001000000000010","0110000000000011","1001000000000100","1001000000000010","0110000000000010","0011000000000010","0111000000000101","0010000000000011","0111000000000010","0011000000000100","0111000000000101","0011000000000011","0110000000000011","0011000000000011","0011000000000011","1001000000000010","0110000000001011","0011000000000100","0001000000000010","0011000000000100","0111000000000010","0001000000010000","0011000000000010","0111000000000011","0001000000000011","1001000000000100","1001000000000010","0001000000000100","1001000000001001","1001000000000010","0001000000000101","0011000000000101","0001000000000010","0011000000000111","1001000000000011","0011000000000011","0001000000000011","0110000000000011","0011000000000111","0011000000000101","0111000000000011","0001000000000100","0111000000000100","0001000000000100","0011000000000010","1001000000000011","1001000000000010","0011000000000011","0001000000000100","1001000000000010","0011000000000011","0111000000000101","0111000000000100","0001000000000101","0001000000000010","0111000000000011","0001000000000100","0011000000000101","0111000000000010","0001000000000111","1001000000000010","0110000000001000","1001000000000010","0110000000000101","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0001000000000010","1001000000000100","0011000000000100","0111000000000100","0111000000000011","0011000000000110","0111000000000110","0110000000000100","0011000000000010","0111000000000011","1001000000000010","0110000000000101","0001000000000010","1001000000000010","0110000000001010","0110000000000101","0001000000000101","0110000000000100","1001000000000100","0110000000000011","1001000000000010","0110000000000101","0011000000000100","0001000000000010","1001000000000010","0110000000000100","0110000000001101","0011000000000100","0001000000000010","1001000000000011","0001000000000110","1001000000000011","0110000000000010","0011000000000101","0001000000000011","1001000000000101","0111000000001011","0001000000001000","0001000000000101","0011000000000011","0011000000000011","0111000000000010","0001000000000010","1001000000000110","0001000000000100","1001000000000010","0110000000000110","0011000000001000","0110000000001001","1001000000000011","0110000000000101","0001000000000010","1001000000000010","0110000000000011","0011000000000100","0111000000000111","0011000000000111","0011000000000011","1001000000000100","0110000000000010","0011000000000011","0011000000000111","0001000000000011","0011000000001001","0001000000000101","0001000000000110","1001000000000010","0110000000000100","0011000000000100","0001000000000010","1001000000000100","0011000000000101","0111000000000011","0111000000000011","0001000000001000","0001000000001000","0011000000000101","0111000000000010","0001000000000011","1001000000000101","0001000000000100","1001000000000010","0110000000000100","1001000000000011","1001000000000011","0110000000000110","0110000000000101","0001000000000010","1001000000000010","0110000000000011","0110000000000011","0001000000000010","1001000000000100","0011000000000101","0111000000000100","0111000000000010","0011000000000110","0111000000000100","0011000000000010","0110000000000100","0011000000000110","0110000000001101","0011000000000100","0001000000000010","0011000000000101","0001000000000111","0001000000001110","0001000000000101","0110000000000010","1001000000000011","0001000000000010","1001000000000010","0110000000000111","1001000000000011","0001000000000110","0011000000000101","0001000000000110","1001000000000011","1001000000000011","1001000000000101","1001000000000100","0011000000000100","0001000000000100","0011000000000110","0001000000001000","0001000000000101","0011000000000010","0110000000000100","0011000000000100","0001000000000011","1001000000000100","0011000000000011","0111000000001100","0001000000000100","0001000000001000","0011000000000110","0001000000000101","0011000000000011","0110000000000100","1001000000000100","1001000000000010","0110000000001010","1001000000000100","0110000000000101","1001000000000100","1001000000000101","0011000000000101","0111000000000101","0011000000000011","0011000000000100","0011000000000011","0011000000000010","0110000000000101","0011000000000101","0110000000000101","1001000000000010","0001000000000010","1001000000000010","0110000000001100","1001000000000010","0001000000000100","1001000000000010","0110000000001100","0110000000000101","0011000000001000","0110000000000101","0110000000001101","0011000000000101","1001000000000011","0001000000000111","0110000000000101","0011000000000100","0001000000000010","1001000000000010","0110000000000011","0001000000000010","0111000000000011","0011000000000111","0001000000000110","0011000000000010","0001000000000101","1001000000000100","0011000000000100","0001000000000010","1001000000000110","0001000000000110","0110000000000101","1001000000000101","0110000000000110","0110000000000101","0001000000000010","1001000000000010","0110000000000100","1001000000000110","0110000000000010","1001000000000010","0011000000000101","0111000000000011","0011000000000011","1001000000000011","0011000000000110","1001000000000010","0110000000000101","0011000000001001","0001000000000101","0011000000000100","0001000000001111","0110000000000101","0011000000000011","0001000000000010","1001000000000110","0001000000000011","0011000000000011","0011000000000100","0001000000000011","0001000000000100","0011000000000011","0001000000000101","1001000000000011","0011000000000101","0001000000000010","1001000000000011","1001000000000011","0001000000000100","1001000000000010","0110000000000100","1001000000000010","0001000000000011","0110000000000111","0110000000000101","0001000000000010","1001000000000010","0110000000000100","1001000000000100","1001000000000010","0110000000000011","0011000000000110","0111000000000100","0011000000000100","1001000000000101","0001000000000011","0110000000000101","0011000000000101","0110000000001100","0110000000000010","0011000000000101","0011000000000111","0001000000000011","0011000000000101","0001000000001010","0001000000000101","1001000000000010","0110000000000010","1001000000000010","0001000000000010","1001000000000010","0110000000000011","0001000000000010","1001000000000010","0110000000000010","1001000000000010","0001000000000100","0011000000000110","0001000000000101","1001000000000100","0011000000000100","1001000000000010","0001000000000011","0110000000000011","0011000000000111","0011000000001010","0001000000000011","0111000000000011","0001000000000110","0110000000000101","0011000000000011","0001000000000010","1001000000000010","0110000000000101","0011000000000110","0011000000000011","0001000000000111","0011000000000010","0001000000000101","0011000000000100","0011000000000101","0001000000000101","1001000000000010","0110000000000110","0001000000000010","1001000000000010","0110000000000101","0110000000000101","1001000000000101","0110000000000011","1001000000000100","1001000000000010","0110000000000010","1001000000000010","0011000000001100","0110000000000100","0011000000000011","0001000000000011","0110000000000111","1001000000000011","0110000000000100","0110000000000010","0001000000000010","1001000000000010","0110000000001110","0001000000000100","1001000000000010","0110000000010011","0011000000000100","1001000000000010","0110000000010011","0011000000000100","1001000000000100","0001000000000110","0110000000000111","0011000000000010","0001000000000100","0110000000000011","1001000000000011","0011000000001001","0001000000000111","1001000000000011","0001000000000100","1001000000000100","0011000000000100","0001000000000010","1001000000000010","0110000000000010","1001000000000011","0001000000000010","1001000000000011","0110000000000110","0001000000000010","1001000000000010","0110000000001011","1001000000000100","0110000000000011","1001000000000100","1001000000000011","0110000000000100","0011000000001000","0011000000000100","0110000000000011","0011000000000100","1001000000000010","0110000000000100","0110000000000101","1001000000000010","0011000000000100","0001000000000011","0011000000001000","0001000000000101","0001000000000111","0110000000000110","0011000000000011","0001000000000010","1001000000000110","0001000000000010","0011000000001000","0001000000001011","0001000000000100","0011000000000010","1001000000000010","0011000000000100","0001000000000011","0110000000000011","1001000000000011","0001000000000010","1001000000000011","0110000000000100","1001000000000011","1001000000000011","0110000000001010","1001000000001000","1001000000000100","1001000000000110","0011000000000011","0011000000000101","0111000000000010","0011000000000010","0110000000000100","0011000000000100","1001000000000011","0110000000001010","0110000000001000","0110000000000100","1001000000000010","0011000000000011","1001000000000010","0011000000000101","0001000000000100","0011000000000100","0001000000001000","0011000000000100","0001000000000011","1001000000001000","1001000000000100","1001000000000100","1001000000000100","1001000000000010","0001000000000111","0011000000000100","0001000000000100","1001000000000100","1001000000000010","0110000000000101","1001000000000101","0011000000000100","0001000000000011","0011000000001000","0001000000000101","0001000000001000","0110000000000110","0011000000000011","0001000000000010","1001000000000011","1001000000000011","0001000000000010","0011000000001011","0001000000000101","0011000000000010","0001000000000101","1001000000000011","0011000000000100","0001000000001001","0110000000000011","1001000000000101","0110000000001110","0110000000000100","1001000000000100","1001000000000011","0110000000000101","1001000000000100","0011000000000111","0110000000001001","1001000000000010","0110000000000101","1001000000000011","0110000000001001","1001000000000011","0110000000001111","1001000000000100","0110000000010110","1001000000000011","0110000000010010","1001000000000010","0001000000000011","1001000000000100","0001000000001000","0110000000000100","1001000000000011","0001000000000011","1001000000000010","0110000000000011","0001000000000010","0011000000001000","0001000000001010","1001000000000011","0001000000000100","1001000000000100","0011000000000010","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0001000000000010","1001000000000011","0110000000000111","1001000000000011","0110000000001010","1001000000000010","0110000000000011","0110000000000010","1001000000000011","1001000000000011","0110000000000101","1001000000000100","0011000000000101","0011000000000011","0110000000000100","1001000000000010","0001000000000011","0110000000001000","0110000000000111","0001000000000100","0011000000001001","0001000000001010","0110000000000110","1001000000000010","0001000000000101","0110000000000010","1001000000000111","0011000000000101","0001000000000011","0001000000000110","1001000000000011","0001000000000110","1001000000000011","0011000000000101","0110000000000100","1001000000000011","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000001101","0110000000000100","1001000000000100","1001000000000011","0110000000000101","1001000000000100","0011000000000101","1001000000000101","0110000000000011","0001000000000100","0110000000001001","0110000000001110","1001000000000101","1001000000000011","0011000000000011","0001000000000101","0011000000000101","0001000000000101","0011000000000101","0001000000000011","1001000000000011","0110000000000011","1001000000000010","0001000000000011","0110000000000100","0001000000000010","1001000000000101","0001000000000101","1001000000000010","0110000000000011","0011000000000011","0001000000000100","1001000000000010","0001000000000011","0110000000000100","0001000000000010","1001000000000010","0110000000000011","0011000000000010","0111000000000010","0001000000000100","1001000000000010","0011000000000100","0111000000000010","0001000000000011","0001000000001010","0110000000000011","1001000000000010","0001000000000100","1001000000000011","1001000000000110","0011000000000110","0001000000001010","1001000000000011","0001000000000101","1001000000000010","0011000000000101","1001000000000011","1001000000000011","0110000000000101","1001000000000111","0110000000001111","1001000000000011","1001000000000010","0110000000001000","1001000000000011","1001000000000011","0001000000000010","1001000000000100","0110000000000100","0001000000000101","0110000000010001","1001000000000010","0110000000001100","1001000000000010","0001000000000010","1001000000000011","0110000000010100","0110000000000101","0110000000010101","0001000000000011","0110000000000100","0001000000000100","1001000000000011","0110000000000100","1001000000000010","0001000000000011","1001000000000011","0110000000000010","1001000000000010","0001000000000010","1001000000000010","0110000000000010","0011000000000100","0001000000000011","0001000000000111","1001000000000011","0001000000000100","1001000000000100","0011000000000010","0001000000000010","1001000000000010","0110000000000111","1001000000000011","0110000000000100","1001000000000110","0110000000010011","0001000000000100","0110000000000111","1001000000001000","1001000000000110","1001000000000100","1001000000000011","0110000000001110","0001000000000101","1001000000000011","0011000000000100","0001000000000101","0001000000000101","0110000000000101","1001000000000011","0001000000000011","1001000000000011","0110000000000101","1001000000000101","0011000000000101","0001000000001000","1001000000000011","0001000000001000","0011000000000011","0001000000000010","1001000000000010","0110000000000011","1001000000000100","1001000000000011","0110000000000100","1001000000000100","0110000000010011","1001000000000010","0001000000000100","0110000000000101","0110000000000100","1001000000000100","0001000000000010","1001000000000010","0110000000000100","1001000000000100","1001000000000010","0110000000000110","0110000000010100","1001000000000100","0110000000000010","0011000000000011","0001000000000100","0011000000000110","0001000000000100","0011000000000111","1001000000000011","0110000000000100","1001000000000100","1001000000000010","0110000000000010","1001000000000011","1001000000000010","0110000000000011","1001000000000010","0001000000000011","1001000000000101","0011000000000011","0001000000000011","1001000000001000","0110000000000010","1001000000001000","0011000000000010","0001000000001001","0011000000000110","0001000000000111","1001000000000010","0110000000000100","1001000000000011","0001000000000101","0110000000000010","1001000000000010","0001000000000101","0011000000000100","0111000000000010","0001000000001001","1001000000000011","0001000000001000","0011000000000010","0001000000000010","1001000000000010","0001000000000011","0110000000001010","0110000000001000","0110000000001010","1001000000000010","0001000000000011","0110000000001001","1001000000000100","1001000000000011","1001000000000010","0110000000001001","1001000000000010","0110000000010011","0110000000001111","0001000000000011","0110000000101111","0001000000000010","1001000000000100","1001000000000010","0001000000000110","0110000000001001","1001000000000011","0110000000000011","1001000000000011","1001000000000010","0110000000000010","0011000000000010","0001000000001010","0001000000000011","1001000000000010","0001000000000110","0110000000000010","1001000000000100","1001000000000010","0110000000000110","0001000000000011","0110000000000111","1001000000000011","0110000000010100","0001000000000010","1001000000000010","0110000000001000","1001000000000110","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0001000000000011","0110000000001101","0011000000000010","0001000000000111","1001000000000010","0011000000000101","0001000000001001","0110000000000101","1001000000000011","0001000000000010","1001000000000010","0110000000000101","0001000000000011","1001000000000011","0011000000000010","0001000000000111","1001000000000011","0001000000000010","1001000000000011","0001000000001101","0110000000000101","1001000000000010","0001000000000010","1001000000000010","0110000000000111","1001000000000010","0110000000000110","0110000000001100","1001000000000010","0001000000000011","0110000000001001","1001000000000101","0001000000000010","1001000000000010","0110000000000101","1001000000000010","0001000000000010","1001000000000100","0110000000010100","1001000000000011","1001000000000011","0110000000000100","0011000000000011","0001000000000011","0011000000000101","0001000000000110","1001000000000100","0001000000000010","1001000000000100","0110000000000101","1001000000000010","0110000000000101","0001000000000010","1001000000000110","1001000000000010","0001000000000010","1001000000000010","0110000000000100","0011000000000010","0001000000000011","1001000000000100","0110000000000101","1001000000000100","0110000000000100","1001000000000011","0001000000000111","1001000000000100","0111000000000010","0001000000000011","0001000000000111","1001000000000010","0110000000000100","1001000000000010","0001000000000101","0110000000000011","1001000000000110","0011000000000100","0001000000000111","1001000000000011","0001000000000010","1001000000000011","0001000000000100","1001000000000100","0011000000000011","1001000000000101","0110000000001101","1001000000000100","0110000000001011","1001000000000011","1001000000000011","0110000000001100","1001000000000100","0110000000000101","1001000000000100","1001000000000100","0110000000011110","1001000000000111","0110000000011011","0110000000010001","1001000000000011","1001000000000010","0110000000000100","0001000000000101","0110000000001000","0001000000000010","1001000000000010","0110000000000110","0001000000000010","1001000000000011","0011000000000011","0001000000000110","1001000000000100","0001000000000010","1001000000000100","0001000000000011","1001000000000010","0110000000000101","1001000000000010","0110000000000111","1001000000000011","0110000000001110","1001000000000011","0110000000001110","1001000000000011","0110000000001100","1001000000000101","0110000000000101","1001000000000111","0110000000001010","1001000000000101","0001000000000101","1001000000000010","0011000000000100","0001000000001000","1001000000000010","0110000000000111","0001000000000010","1001000000000011","0110000000000011","1001000000000011","1001000000000101","0011000000000010","0001000000000110","1001000000000011","0001000000000010","1001000000000100","0001000000000110","1001000000001000","0110000000000100","1001000000000101","0110000000001110","1001000000000100","0110000000001010","1001000000000011","1001000000000010","0110000000001110","1001000000000100","0110000000000101","1001000000000011","1001000000000100","0110000000011001","0110000000000111","0011000000000011","0001000000000011","0011000000000101","0001000000000110","1001000000000100","0001000000000010","0110000000001110","1001000000000100","0110000000001001","1001000000000010","0110000000000010","1001000000000010","0011000000000010","0001000000000011","1001000000000010","0110000000010010","0001000000001001","0110000000000010","0011000000000011","0001000000001000","1001000000000010","0110000000000101","1001000000000011","1001000000000011","0110000000000011","1001000000000010","0001000000000011","1001000000000010","0011000000000100","0001000000000110","1001000000000011","0001000000000010","1001000000000100","0001000000000011","1001000000000011","0110000000000010","1001000000000100","1001000000000100","0110000000001010","0110000000000011","1001000000000101","0110000000001100","0001000000000011","0110000000001111","1001000000000010","0110000000001000","1001000000000100","1001000000000010","0110000000011111","1001000000000011","0110000000101111","1001000000000100","0110000000000011","1001000000000010","0001000000000010","1001000000000011","0110000000000110","1001000000000011","1001000000000100","0110000000000100","0001000000000111","0001000000000110","1001000000000111","1001000000000011","1001000000000011","0001000000000011","0110000000000101","0110000000001000","1001000000000100","0110000000001100","0110000000000010","1001000000000101","0110000000001001","1001000000000010","0001000000000011","0110000000001110","1001000000000100","0110000000000110","1001000000001000","0110000000001001","1001000000000010","0011000000000010","0001000000000100","1001000000000100","0011000000000010","0111000000000010","0001000000000101","1001000000000011","0110000000000110","1001000000000100","1001000000000010","0110000000000110","0001000000000011","1001000000000100","0001000000000101","1001000000000111","1001000000000100","1001000000000010","0001000000000011","1001000000000010","0110000000000010","1001000000000101","0110000000001001","0110000000010000","1001000000000010","0110000000001010","1001000000000010","0001000000000011","0110000000001101","1001000000000101","0110000000000110","1001000000000100","1001000000000011","0110000000010111","1001000000000010","0110000000000110","0011000000000011","0001000000000011","0011000000000110","0001000000000100","0110000000000010","1001000000000100","1001000000000010","0110000000001111","1001000000000010","0110000000001011","0110000000000110","0001000000000010","1001000000000010","0110000000010010","0011000000000011","0001000000000101","1001000000000110","0111000000000011","0001000000000100","1001000000000100","0110000000000110","0001000000000100","0110000000001110","0001000000000110","1001000000000110","1001000000000100","1001000000000010","0001000000000011","0110000000000110","0110000000010100","0001000000000100","0110000000001001","1001000000000011","1001000000000011","0110000000010111","1001000000000011","0001000000000010","1001000000000010","0110000000100000","0110000000110000","0110000000000011","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000001001","0001000000000010","1001000000000010","0110000000000101","1001000000000111","0011000000000010","0001000000001000","1001000000000010","0001000000000010","1001000000000010","0110000000000010","1001000000000011","1001000000000010","0110000000010110","0110000000001000","1001000000000010","0001000000000011","0110000000000011","0110000000000111","1001000000000011","1001000000000011","0110000000000110","0110000000000101","0110000000001100","0110000000000011","0001000000000010","1001000000000010","0110000000001010","0011000000000100","0001000000000110","0110000000000010","0011000000000011","0111000000000010","0001000000000100","1001000000000101","0110000000000110","0001000000000011","0110000000000110","1001000000000100","0110000000000010","1001000000000011","0001000000000100","1001000000000011","1001000000000010","0001000000000010","1001000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000100000","0001000000000011","0110000000001010","1001000000000011","1001000000000010","0110000000011001","1001000000000010","0001000000000010","1001000000000010","0110000000010110","0110000000001010","0011000000000010","0001000000000101","0011000000000010","1001000000000110","0110000000000010","1001000000000011","1001000000000011","0110000000001101","0110000000001001","0110000000000100","0110000000000110","1001000000000100","1001000000000011","0110000000010001","0011000000000100","0001000000000100","1001000000000101","0011000000000100","0001000000000100","1001000000000010","0110000000000111","1001000000000011","1001000000000010","0110000000000100","1001000000000110","0110000000000010","1001000000000011","0001000000000011","1001000000000110","0001000000000010","1001000000000111","1001000000000011","0110000000000100","0110000000010011","1001000000000011","1001000000000010","0110000000001100","0001000000000011","0110000000001011","0110000000010000","0001000000000011","0110000000100010","0110000000111000","0001000000000010","1001000000000010","0110000000000111","1001000000000100","1001000000000010","0110000000000101","1001000000000100","0110000000000011","1001000000000010","0001000000000010","1001000000000101","1001000000000011","0001000000000010","1001000000000101","0001000000000010","1001000000000010","0110000000011110","1001000000000100","1001000000000010","0110000000000111","0110000000000100","0001000000000010","1001000000000010","0110000000011000","1001000000000100","1001000000000010","0110000000000011","0110000000001000","0011000000000011","0001000000000100","1001000000000011","0110000000000010","0011000000000011","0001000000001000","0110000000000110","1001000000000100","1001000000000010","0110000000000101","1001000000000100","0110000000000010","1001000000000010","0001000000000011","1001000000000110","1001000000000010","0001000000000010","1001000000000010","0110000000000010","1001000000000011","1001000000000010","0110000000011110","1001000000000101","0110000000001010","1001000000000010","0001000000000011","0110000000001100","0110000000001101","1001000000000101","0110000000100001","0011000000000100","0001000000000011","1001000000000011","1001000000000101","0110000000000011","1001000000000101","0110000000100001","1001000000000100","0110000000010100","0011000000000010","0001000000000111","0110000000000010","0011000000000100","0001000000000101","1001000000000100","0110000000000110","0001000000000011","1001000000000010","0110000000000100","1001000000000101","0110000000000010","1001000000000010","0001000000000101","0110000000000100","1001000000000011","1001000000000011","1001000000000011","0001000000000011","0110000000010101","0110000000000100","0001000000000010","1001000000000011","0110000000001001","1001000000000110","0110000000000111","1001000000000100","0110000000001101","1001000000000100","1001000000000010","0110000000100010","0110000000101111","0110000000001000","0001000000000010","1001000000000010","0110000000000110","0110000000000100","1001000000000011","0110000000001000","0110000000000100","1001000000000011","1001000000000011","0110000000000011","1001000000000110","0110000000000101","0001000000000011","0110000000011110","1001000000000010","0001000000000011","0110000000000100","0110000000000111","1001000000000100","0110000000001001","1001000000000011","0110000000001101","1001000000000101","0110000000001100","0011000000000100","0001000000000101","0110000000000011","0011000000000100","0001000000000100","1001000000000010","0110000000000011","0110000000000101","1001000000000011","0110000000001110","1001000000000010","0001000000000011","0110000000000011","1001000000000101","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000011111","0001000000000010","1001000000000010","0110000000001010","1001000000000011","1001000000000010","0110000000000101","0110000000000100","1001000000000010","0110000000000011","0110000000001011","1001000000000011","1001000000000011","0110000000010001","1001000000000101","0110000000001011","0011000000000011","0001000000000010","1001000000000010","0110000000000011","0110000000000011","0110000000000100","1001000000000100","0110000000100100","0110000000010111","0011000000000010","0001000000000100","1001000000000010","0110000000000011","0011000000000100","0001000000000100","1001000000000010","0110000000000111","1001000000000011","1001000000000010","0110000000001000","0110000000000100","1001000000001010","1001000000000011","1001000000000011","0110000000000010","1001000000000010","0001000000000010","1001000000000010","0110000000000100","0110000000010001","0110000000000010","1001000000000010","0001000000000011","0110000000001011","1001000000000100","0110000000001000","1001000000000101","0110000000001110","1001000000000011","0110000000011111","1001000000000101","0110000000101011","1001000000000100","0110000000000111","0001000000000011","0110000000001001","1001000000000100","0110000000001101","1001000000000010","0001000000000110","1001000000000100","1001000000000011","0110000000000011","1001000000000011","1001000000000010","0110000000011110","1001000000000100","1001000000000010","0110000000001010","1001000000000100","0110000000001100","0110000000010000","1001000000000011","0110000000001100","0011000000000100","0001000000000010","1001000000000011","0110000000000011","0011000000000010","0001000000000110","0110000000001010","1001000000000011","0110000000001101","1001000000000010","0001000000000110","1001000000000011","1001000000000011","0110000000000101","0001000000000010","1001000000000011","0110000000011101","1001000000000010","0001000000000011","0110000000000100","1001000000000010","0110000000000110","1001000000000010","0110000000001001","1001000000000100","0110000000001111","1001000000000010","0110000000010100","1001000000000101","0110000000001101","0001000000000011","1001000000000010","0110000000001001","1001000000000100","0110000000111011","0011000000000011","0001000000000100","0110000000000100","0011000000000101","0001000000000011","1001000000000010","0110000000001001","1001000000000010","0110000000001110","1001000000000010","0001000000000011","0110000000000011","1001000000000100","1001000000000011","0110000000000010","1001000000000101","0110000000010110","1001000000000100","1001000000000101","0110000000001100","0110000000001000","1001000000000010","0001000000000010","1001000000000010","0110000000001111","0110000000100000","1001000000000100","1001000000000010","0110000000101011","1001000000000011","1001000000000010","0110000000000110","0001000000000010","1001000000000010","0110000000001011","0110000000001110","1001000000000011","1001000000000010","0110000000000010","1001000000000010","0001000000000010","1001000000000011","0110000000000101","0001000000000100","0110000000011101","1001000000000100","1001000000000010","0110000000000100","0110000000001011","0110000000001000","1001000000000010","0001000000000010","0110000000010000","0110000000001111","0011000000000101","0001000000000011","0110000000000011","0011000000000100","0001000000000100","1001000000000010","0110000000001011","0110000000001110","1001000000000110","0110000000000100","1001000000000100","0110000000000011","1001000000000010","0001000000000010","1001000000000010","0110000000011110","1001000000000011","1001000000000010","0110000000001011","0110000000001101","0001000000000010","1001000000000010","0110000000100011","1001000000000010","0001000000000011","0110000000010000","1001000000000010","0110000000000101","0110000000000011","1001000000000110","0110000000111011","0011000000000110","1001000000000010","0110000000000011","0011000000000100","0001000000000101","0110000000001100","0110000000001100","1001000000000111","0110000000000010","1001000000000011","1001000000000011","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000010101","1001000000000100","1001000000000011","0110000000010111","1001000000000011","1001000000000010","0110000000101110","1001000000000110","0110000000101011","1001000000000101","0110000000000110","1001000000000010","0001000000000010","0110000000011011","1001000000000100","0110000000000100","1001000000000100","0110000000001000","1001000000000010","0110000000011100","1001000000000101","1001000000000010","0110000000011001","0001000000000010","0110000000100010","0011000000000100","1001000000000010","0110000000000101","0111000000000010","0001000000000100","0110000000011010","1001000000000100","0110000000000100","1001000000000100","0110000000000111","0001000000000110","0110000000011010","1001000000000100","1001000000000011","0110000000000110","0110000000010001","1001000000000011","1001000000000010","0110000000100011","1001000000000011","1001000000000011","0110000000001101","0001000000000011","1001000000000101","0110000000000111","1001000000000011","0110000000111100","0011000000000011","0001000000000010","1001000000000010","0110000000000100","0011000000000011","0001000000000100","1001000000000010","0110000000011001","1001000000000101","0110000000000011","1001000000000101","0110000000000100","1001000000000101","0110000000010111","0001000000000010","1001000000000011","0110000000010111","1001000000000010","0001000000000010","1001000000000010","0110000000101101","1001000000000010","0001000000000010","1001000000000010","0110000000000011","0110000000110000","0110000000000101","0001000000000010","1001000000000010","0110000000011101","0110000000001111","0001000000000010","1001000000000010","0110000000011101","0001000000000010","1001000000000010","0110000000011001","1001000000000010","0001000000000010","0110000000100001","0011000000000011","0001000000000011","0110000000000101","0011000000000100","0001000000000010","1001000000000010","0110000000011101","0110000000000111","0110000000000110","1001000000000010","0001000000000010","1001000000000011","0110000000011010","1001000000000010","0001000000000010","1001000000000011","0110000000000101","0110000000010100","0001000000000010","1001000000000011","0110000000100001","1001000000000011","0001000000000010","1001000000000010","0110000000001101","0001000000000010","1001000000000101","1001000000000010","0110000000000010","1001000000000011","1001000000000101","0110000000111010","0011000000000100","0001000000000010","1001000000000010","0110000000000101","0011000000000100","0001000000000010","1001000000000010","0110000000100100","0110000000000100","0110000000000010","1001000000000010","0001000000000011","0110000000010101","1001000000000100","1001000000000010","0110000000011010","0001000000000010","1001000000000010","0110000000101111","0001000000000010","1001000000000011","0110000000000110","0110000000100111","0001000000000100","0110000000000101","1001000000000101","0110000000100000","0110000000001101","0001000000000011","0110000000011111","1001000000000011","0110000000011010","0001000000000011","0110000000011111","0011000000000100","0001000000000101","0110000000000100","0011000000000011","0001000000000010","1001000000000010","0110000000100001","0110000000001011","0001000000000010","1001000000000010","0110000000011011","1001000000000010","0001000000000010","1001000000000010","0110000000001001","0110000000001010","0110000000000110","1001000000000011","1001000000000010","0110000000100010","1001000000000011","0001000000000010","1001000000000010","0110000000001110","0001000000000010","1001000000000100","1001000000000010","0110000000000100","0001000000000010","1001000000000010","0110000000001000","0110000000110101","0011000000000011","0001000000000100","0110000000000101","0011000000000110","1001000000000011","0110000000101001","1001000000000101","0110000000010011","0110000000000010","1001000000000010","0001000000000011","0110000000001101","0110000000001110","0001000000000010","1001000000000010","0110000000101111","0001000000000011","0110000000001000","0110000000100110","1001000000000011","1001000000000010","0110000000000110","0001000000000010","1001000000000010","0110000000101110","1001000000000010","0110000000011011","1001000000000010","0001000000000010","1001000000000011","0110000000000101","1001000000000010","0110000000010001","1001000000000011","1001000000000010","0110000000011111","0011000000000101","1001000000000011","0110000000000101","0011000000000101","1001000000000010","0110000000101010","1001000000000100","1001000000000010","0110000000011011","1001000000000010","0001000000000011","0110000000011011","0001000000000010","1001000000000100","0110000000100010","0001000000000010","1001000000000011","0110000000001110","1001000000000100","0001000000000010","1001000000000011","1001000000000011","0001000000000010","1001000000000010","0110000000001001","0110000000110100","0011000000000101","1001000000000010","0110000000000110","0011000000000011","0001000000000010","1001000000000010","0110000000101101","1001000000000011","0110000000010100","1001000000000101","0110000000000111","1001000000000011","0110000000010000","1001000000000011","1001000000000010","0110000000101111","0001000000000010","1001000000000100","0110000000000101","1001000000000010","0110000000100011","1001000000000010","0001000000000100","0110000000000110","0001000000000100","0110000000101101","1001000000000011","0110000000011101","0001000000000011","1001000000000010","0110000000000101","1001000000000011","0110000000010000","1001000000000010","0001000000000010","1001000000000010","0110000000100001","0011000000000110","0110000000000110","0011000000000100","0110000000101100","1001000000000100","0110000000011101","0001000000000011","1001000000000100","0110000000000011","1001000000000100","0110000000010000","1001000000000011","0011000000000010","0110000000100101","0001000000000010","1001000000000010","0110000000001101","1001000000000011","1001000000000101","0110000000000100","1001000000000011","1001000000000010","0110000000000110","1001000000000100","0110000000110100","0011000000000011","0011000000000011","0110000000001000","0011000000000011","1001000000000010","0110000000101010","1001000000000101","0110000000010100","1001000000000011","0001000000000011","0110000000000110","1001000000000011","1001000000000010","0110000000010000","0001000000000010","1001000000000011","0110000000101100","1001000000000010","0001000000000010","1001000000000010","0110000000000100","1001000000000011","1001000000000011","0110000000100011","1001000000000011","1001000000000011","0110000000000100","1001000000000011","1001000000000010","0110000000001101","0110000000100010","0110000000011101","1001000000000011","1001000000000100","0110000000000011","1001000000000011","1001000000000010","0110000000001111","1001000000000010","0001000000000010","0110000000000011","0110000000100101","0110000000001001","1001000000000011","0110000000101100","1001000000000010","0110000000011101","1001000000000010","0001000000000011","0110000000000101","1001000000000100","1001000000000010","0110000000010000","0001000000000011","0110000000000011","0110000000100001","1001000000000010","0001000000000010","1001000000000010","0110000000001101","1001000000000011","0001000000000010","1001000000000100","0110000000000010","1001000000000010","0001000000000011","0110000000001010","0110000000110111","0011000000000010","0110000000001001","1001000000000010","0001000000000011","0110000000001010","0110000000100010","1001000000000011","0110000000010110","1001000000000101","0110000000000101","1001000000000100","1001000000000010","0110000000010010","1001000000000100","0110000000101101","0001000000000011","0110000000000111","0001000000000010","1001000000000010","0110000000100011","1001000000000011","1001000000000100","0110000000000011","1001000000000100","0110000000001010","1001000000000011","0110000001000001","0001000000000101","0110000000000100","1001000000000011","1001000000000010","0110000000010000","1001000000000011","1001000000000011","0110000000100001","0011000000000100","0110000000001001","1001000000000010","0110000000001001","1001000000000100","0110000000111111","1001000000000010","0001000000000100","0110000000000110","0001000000000010","1001000000000010","0110000000001110","0110000000000010","1001000000000011","1001000000000011","0110000000100001","1001000000000111","0110000000001101","1001000000000100","1001000000000010","0110000000000100","1001000000000100","1001000000000010","0110000000000101","1001000000000101","0110000000110111","0011000000000011","0110000000001000","1001000000000101","0110000000001000","1001000000000011","0110000000111001","1001000000000010","0001000000000011","0110000000000111","0001000000000010","1001000000000010","0110000000010001","1001000000000011","1001000000000010","0110000000101011","1001000000000010","0001000000000010","1001000000000010","0110000000000110","0001000000000010","1001000000000010","0110000000100101","1001000000000011","1001000000000011","0110000000000100","0110000000001101","1001000000000011","0110000000111111","1001000000000011","1001000000000010","0110000000000011","0110000000000011","0001000000000010","1001000000000010","0110000000010000","1001000000000111","0110000000011110","0110000000000100","0110000000000011","0110000000000111","1001000000000010","0110000000001001","1001000000000100","1001000000000010","0110000001000000","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000001111","1001000000000101","1001000000000100","0110000000100000","1001000000000100","1001000000000011","0110000000001100","1001000000000010","0001000000000010","1001000000000010","0110000000000100","1001000000000010","0001000000000011","0110000000000111","0001000000000010","1001000000000010","0110000001000001","0110000000000010","1001000000000010","0110000000001101","0110000000100100","0110000000011000","1001000000000011","0110000000000101","1001000000000011","1001000000000010","0110000000010001","1001000000000010","0001000000000011","0110000000101100","1001000000000011","1001000000000010","0110000000000100","1001000000000010","0001000000000010","1001000000000010","0110000000100101","1001000000000010","0001000000000010","1001000000000010","0110000000010000","0001000000000011","0110000001000000","1001000000000011","1001000000000011","0110000000000100","1001000000000011","1001000000000011","0110000000010010","0001000000000010","1001000000000010","0110000000100000","0110000000000011","0110000000010100","1001000000000010","0001000000000101","0110000000111101","1001000000000010","0001000000000011","0110000000000111","0001000000000100","0110000000010001","1001000000000101","0110000000100101","0001000000000010","1001000000000010","0110000000001110","0001000000000010","1001000000000010","0110000000000101","1001000000000100","0110000000000110","1001000000000110","0110000001001101","1001000000000011","1001000000000010","0110000000111100","0110000000000110","1001000000000010","0001000000000010","1001000000000010","0110000000010100","1001000000000010","0110000000101110","0110000000000111","1001000000000010","0001000000000010","1001000000000010","0110000000100101","1001000000000010","0001000000000011","0110000000010000","1001000000000011","1001000000000010","0110000001000001","1001000000000010","0110000000000111","0001000000000010","1001000000000010","0110000000010011","0001000000000010","1001000000000010","0110000000101101","0110000000001010","1001000000000010","0001000000000011","0110000001000100","0110000000000111","0001000000000010","1001000000000010","0110000000010001","1001000000000010","0001000000000101","0110000000100010","1001000000000011","1001000000000010","0110000000001100","1001000000000011","1001000000000011","0110000000001001","0110000000000111","0001000000000010","1001000000000010","0110000001001111","0001000000000010","1001000000000010","0110000001000011","1001000000000011","1001000000000010","0110000000010000","1001000000000011","0001000000000011","0110000000101111","0110000000000110","1001000000000010","0001000000000010","1001000000000010","0110000000100101","1001000000000010","0001000000000010","1001000000000010","0110000000001110","1001000000000010","0001000000000100","0110000001001010","0001000000000010","1001000000000010","0110000000010011","0001000000000100","0110000000110111","1001000000000100","1001000000000010","0110000001001010","0001000000000010","1001000000000011","0110000000001111","1001000000000110","0110000000100011","1001000000000011","0001000000000011","0110000000001111","1001000000000011","0110000000010000","0001000000000010","1001000000000010","0110000001001111","0001000000000010","1001000000000010","0110000001000010","1001000000000010","0001000000000010","1001000000000010","0110000000010001","1001000000000011","1001000000000011","0110000000110100","1001000000000010","0001000000000010","1001000000000010","0110000000100101","1001000000000010","0001000000000010","1001000000000010","0110000000010000","0001000000000010","1001000000000010","0110000001001000","1001000000000011","0001000000000010","0110000000010100","0001000000000010","1001000000000010","0110000000111001","0001000000000010","1001000000000010","0110000001001010","0001000000000010","1001000000000010","0110000000010001","1001000000000011","1001000000000011","0110000000100101","1001000000000011","0110000000001100","1001000000000101","0110000000001001","0110000000001000","0001000000000010","1001000000000010","0110000001001110","1001000000000010","0001000000000010","0110000001000100","1001000000000011","1001000000000010","0110000000010001","1001000000000010","0001000000000011","0110000000110101","1001000000000010","0001000000000010","1001000000000010","0110000000100111","0001000000000010","1001000000000010","0110000000001111","1001000000000011","1001000000000010","0110000001001000","1001000000000100","1001000000000010","0110000000010011","0001000000000100","0110000000110111","1001000000000010","0001000000000010","1001000000000010","0110000001001010","0001000000000010","1001000000000010","0110000000000011","0110000000001110","1001000000000010","0001000000000101","0110000000100011","0001000000000100","0110000000100001","1001000000000011","1001000000000010","0110000001001110","1001000000000011","1001000000000010","0110000001000010","1001000000000010","0001000000000010","1001000000000010","0110000000010001","1001000000000011","1001000000000010","0110000000110101","1001000000000010","0001000000000010","1001000000000010","0110000000100101","1001000000000010","0001000000000100","0110000000000101","0110000000000110","0110000000000101","0001000000000010","1001000000000010","0110000001001010","0001000000000010","1001000000000010","0110000000010011","0001000000000010","1001000000000010","0110000000111000","1001000000000110","0110000001001001","0001000000000010","1001000000000010","0110000000010000","1001000000000100","1001000000000010","0110000000100100","1001000000000011","1001000000000010","0110000000001111","0110000000010011","0001000000000010","1001000000000010","0110000001001111","0001000000000010","1001000000000010","0110000001000110","1001000000000010","0110000000010001","1001000000000010","0001000000000011","0110000000100111","0110000000001110","1001000000000010","0001000000000011","0110000000101000","0001000000000010","1001000000000010","0110000000001010","0110000000000101","1001000000000100","1001000000000010","0110000000100011","0110000000100110","0001000000000010","1001000000000010","0110000000010101","1001000000000010","0110000000110001","1001000000000010","0110000000000100","1001000000000100","1001000000000010","0110000001001010","0001000000000010","1001000000000010","0110000000010001","1001000000000010","0001000000000011","0110000000100011","1001000000000100","1001000000000010","0110000000100100","1001000000000010","0110000001001110","1001000000000011","1001000000000010","0110000001000010","1001000000000101","0110000000010011","1001000000000100","0110000000100001","1001000000000100","0110000000010001","1001000000000101","0110000000100110","1001000000000100","0110000000001000","1001000000000101","0110000000000011","1001000000000110","0110000000100000","1001000000000101","0110000000100010","1001000000000110","0110000000010011","1001000000000010","0110000000110100","1001000000000010","0110000000000100","1001000000000100","1001000000000011","0110000000100000","1001000000000011","0110000000100100","1001000000000101","0110000000010010","1001000000000011","0110000000000011","0110000000100010","1001000000000101","0110000000100001","1001000000000100","0110000000010100","0110000000111011","1001000000000011","1001000000000010","0110000001000101","1001000000000010","0110000000010100","1001000000000010","0110000000100101","1001000000000010","0110000000010001","1001000000000010","0110000000101001","1001000000000100","0110000000000111","1001000000000011","1001000000000010","0110000000000100","1001000000000101","0110000000100000","1001000000000100","0110000000100101","1001000000000011","0110000001001000","1001000000000011","1001000000000010","0110000000000011","1001000000000110","0110000000100000","1001000000000100","0110000000100101","1001000000000011","0110000000111101","1001000000000010","0110000000100011","1001000000000011","0110000000010000","1001000000000011","1001000000000010","0110000000111101","0110000010000001","1001000000000011","1001000000000010","0110000001000111","1001000000000010","0001000000000011","0110000000000011","1001000000000011","0001000000000011","0110000000011111","1001000000000010","0001000000000010","1001000000000010","0110000001101110","1001000000000100","1001000000000010","0110000000000110","0001000000000010","1001000000000010","0110000000011110","1001000000000010","0001000000000011","0110000010011110","0001000000000010","1001000000000010","0110000000111101","0110000010000001","1001000000000010","0001000000000011","0110000000001000","0110000000110101","0110000000001110","1001000000000010","0110000000000100","1001000000000010","0001000000000010","0110000000100000","1001000000000101","0110000001110000","0001000000000010","1001000000000100","0110000000000011","1001000000000101","0110000000011110","1001000000000100","1001000000000011","0110000010011100","0001000000000100","0110000010111110","1001000000000011","1001000000000010","0110000001000111","1001000000000011","1001000000000011","0110000000000011","1001000000000100","1001000000000010","0110000000011110","1001000000000010","0001000000000010","1001000000000010","0110000001101110","1001000000000100","1001000000000011","0110000000000101","0001000000000010","1001000000000010","0110000000011101","1001000000000011","0001000000000011","0110000010011110","0001000000000010","1001000000000010","0110000010111110","1001000000000010","0001000000000011","0110000001001000","1001000000000100","1001000000000011","0110000000000010","1001000000000010","0001000000000011","0110000000100000","0001000000000101","0110000001101110","1001000000000101","1001000000000011","0110000000000011","0001000000000100","0110000000011110","1001000000000111","0110000010011100","0001000000000100","0110000010111110","1001000000000011","1001000000000011","0110000000000101","0110000001000010","1001000000000100","1001000000000100","1001000000000100","1001000000000010","0110000000011110","1001000000000011","1001000000000011","0110000001110001","1001000000000011","1001000000000010","0110000000000011","1001000000000011","1001000000000010","0110000000100000","0001000000000011","0110000010011110","0001000000000010","1001000000000010","0110000010111110","1001000000000010","0001000000000011","0110000001001011","0001000000000010","1001000000000010","0110000000000010","1001000000000010","0001000000000011","0110000000100000","0001000000000101","0110000001110000","1001000000000010","0001000000000010","1001000000000010","0110000000000011","0001000000000010","1001000000000010","0110000000011110","1001000000000100","1001000000000010","0110000010011101","0001000000000010","1001000000000010","0110000010111110","1001000000000011","1001000000000100","0110000001000111","1001000000000100","1001000000000011","1001000000000100","1001000000000011","0110000000011110","1001000000000011","1001000000000010","0110000001110001","1001000000000011","1001000000000010","0110000000000011","1001000000000010","0001000000000011","0110000000011110","1001000000000011","1001000000000101","0110000010011010","1001000000000011","1001000000000011","0110000010111110","1001000000000110","0110000001000111","1001000000000100","1001000000000010","0110000000000010","1001000000000010","0001000000000011","0110000000100000","1001000000000110","0110000001101111","1001000000000010","0001000000000011","0110000000000100","0001000000000010","1001000000000010","0110000000011111","1001000000000100","1001000000000010","0110000010011110","1001000000000100","0110000010111110","1001000000000010","0001000000000010","1001000000000010","0110000001001000","0001000000000010","1001000000000010","0110000000000101","1001000000000010","0110000000100000","1001000000000010","0001000000000010","1001000000000010","0110000001101111","1001000000000011","1001000000000010","0110000000000011","1001000000000011","1001000000000010","0110000000100000","1001000000000100","1001000000000010","0110000010011100","1001000000000011","1001000000000011","0110000010111101","1001000000000101","0110000001000111","1001000000000010","0001000000000010","1001000000000010","0110000000000011","1001000000000100","0110000000100001","1001000000000100","1001000000000010","0110000001101101","1001000000000101","1001000000000010","0110000000000011","1001000000000011","0110000000100001","1001000000000101","0110000010011111","0001000000000011","0110000010111110","1001000000000010","0001000000000010","1001000000000010","0110000001000110","1001000000000011","0001000000000100","0110000000000100","0110000000100100","0001000000000010","1001000000000010","0110000001110000","0001000000000010","1001000000000010","0110000000000111","0110000000100011","0001000000000010","1001000000000010","0110000010011100","1001000000000011","1001000000000011","0110000010111111","0001000000000010","1001000000000010","0110000001000110","1001000000000100","1001000000000010","0110000000000110","0110000000100011","0001000000000010","1001000000000011","0110000001110000","0001000000000010","1001000000000010","0110000000101000","1001000000000011","1001000000000010","0110000010011100","1001000000000010","0001000000000011","0110000010111101","1001000000000101","1001000000000010","0110000001001000","0001000000000010","1001000000000010","0110000000100111","1001000000000011","0001000000000011","0110000001101111","1001000000000011","1001000000000010","0110000000101010","0001000000000010","1001000000000010","0110000010011100","1001000000000011","1001000000000011","0110000010111101","1001000000000010","0001000000000010","1001000000000010","0110000001001000","0001000000000010","1001000000000010","0110000000101000","1001000000000011","1001000000000010","0110000001101110","1001000000000011","0001000000000010","1001000000000010","0110000000101000","1001000000000010","0001000000000011","0110000010011110","0001000000000011","0110000011000000","0001000000000011","0110000001000111","1001000000000100","1001000000000010","0110000000100111","1001000000000010","0001000000000010","1001000000000011","0110000001101110","1001000000000011","1001000000000010","0110000000101010","0001000000000011","0110000010011101","1001000000000011","1001000000000011","0110000010111111","1001000000000100","0110000001000111","1001000000000100","0110000000101101","0110000001110000","1001000000000101","0110000000101010","1001000000000100","0110000010011101","1001000000000100","0110000010111111","1001000000000011","0110000001001101","0110000000101101","0110000001110001","1001000000000100","0110000000101001","1001000000000100","0110000010011111","1001000000000010","0110000011000011","0110000001110111","0110001100100100","0110011010101100","0110010000010110","0110000001001000","0110000010011111","1001000000000100","0110000011011100","1001000000000010","0110000010110111","0110000001000111","1001000000000010","0110000001000001","0110000000011111","0110000000110000","0110000000010010","0110000001111101","0110000000010100","0110000000010101","0110000000110111","1001000000000100","0110000001100101","0110000000010101","0110000000000110","0110000000010101","0110000000011101","1001000000000010","0110000000111110","0110000000000011","0110000000000110","0001000000000100","0110000001000000","0110000000010001","1001000000000010","0110000000011001","0110000000010011","1001000000000100","0110000000001101","0110000000001100","0001000000000011","1001000000000010","0110000000010001","0110000000010111","0110000000010110","0110000001000000","0110000000010100","0110000000010000","0110000000000011","1001000000000100","0110000000001110","0110000000000100","1001000000000011","1001000000000011","0110000000001100","0110000000010001","0110000001000000","0110000000010110","0110000000010001","1001000000000010","0110000000010111","0110000000001111","0110000000001011","0110000000001110","0110000000001010","0001000000000101","0110000001000010","0110000000000110","1001000000000010","0110000000111011","1001000000000011","1001000000000011","0110000000010011","0110000000010100","0011000000000101","0110000000001000","1001000000010000","0110000000000111","1001000000000110","0110000000001110","1001000000000010","0110000001000000","0110000000111000","1001000000000100","0110000000010000","1001000000000111","0110000000010111","0110000000001000","1001000000000110","0110000000000110","1001000000000100","0110000000000111","1001000000000011","1001000000000010","0110000000001000","1001000000000011","0001000000000111","0110000000111110","0110000000010011","0110000000000011","0110000000001101","1001000000000101","0110000000001111","1001000000000101","0011000000000110","0110000000001011","1001000000001011","0110000000001001","1001000000000100","0110000000000110","0110000000001011","0110000000101101","0110000000001111","1001000000000100","0110000000000110","0001000000000010","0011000000000011","0110000000011011","0110000000011110","0110000000000111","0110000000010000","0001000000000010","0011000000000011","1001000000001010","0110000000000011","1001000000000111","0001000000000101","1001000000000110","1001000000001001","0001000000001000","0110000000001011","0011000000001000","0110000000000011","0001000000000011","0011000000000011","0110000000001000","0110000000111010","0110000000001001","0110000000001100","0110000000010011","0110000000010101","0110000000010001","0011000000000100","1001000000001010","1001000000000011","0001000000000100","0001000000000100","0011000000000100","0110000000000100","1001000000000101","0011000000000010","1001000000000011","0001000000000110","0110000000001001","0001000000000011","0011000000000101","0110000000001101","0110000000010001","0110000000000101","0110000000000101","0110000000010011","0110000000010011","0110000000001101","1001000000001101","0110000000001001","0001000000000100","1001000000000010","0110000000000111","0110000000001000","0001000000000011","0001000000000100","0011000000000110","0110000000000010","1001000000001100","0001000000000011","1001000000000010","0110000000000110","1001000000000010","0001000000000011","1001000000000010","0110000000001000","0011000000000010","0001000000000100","1001000000000010","0110000000011010","0110000000010000","0110000000000011","0110000000010101","0110000000001000","0110000000010010","0110000000001011","0110000000001100","1001000000000100","0110000000010000","0001000000000011","1001000000000010","0110000000011110","0011000000000011","0001000000000010","0000000000000110","0001000000000111","0011000000000100","0000000000000100","0011000000000011","0000000000001010","0110000000000011","1001000000000011","0001000000000100","0011000000001000","0011000000000010","0000000000000111","0110000000001100","1001000000000011","1001000000000010","0110000000000110","0110000000010001","1001000000000100","0110000000010001","0001000000000100","0110000000001010","1001000000000011","0110000000000101","0011000000000100","0110000000010001","0110000000001011","1001000000000010","0011000000001010","0110000000001110","0001000000000011","0011000000000101","0011000000001011","0000000000010100","0001000000000010","0011000000000011","0000000000000110","0011000000000011","0110000000010110","0000000000000011","0011000000000011","0110000000001110","1001000000001101","0110000000000011","0110000000001011","1001000000000100","0110000000001011","1001000000000101","0001000000000010","1001000000000010","0110000000001100","1001000000000011","0001000000000111","0011000000000100","1001000000000011","0110000000001100","0011000000001010","0011000000000100","0000000000001001","0011000000000011","0011000000000111","0001000000000111","0000000000001001","0110000000000110","0001000000000101","0011000000001001","0000000000000100","0011000000000101","0110000000001101","1001000000000010","0110000000001011","0110000000001110","1001000000000011","0110000000001011","0011000000000101","0001000000000110","0110000000000010","0000000000001000","0110000000000101","0110000000010100","1001000000000010","0110000000000101","1001000000000101","1001000000001000","0110000000000101","0110000000000010","1001000000000010","0001000000000010","0000000000001000","0110000000001001","0110000000000101","0000000000000110","0000000000001011","0000000000010001","0000000000001001","0000000000001000","1000000000001000","0001000000000010","0000000000001010","0000000000000011","0000000000000100","0001000000000110","0110000000001101","1000000000000100","1001000000000010","0001000000000011","0110000000001010","0110000000000011","0110000000000100","0001000000000011","1001000000000100","0110000000000101","0110000000000100","0000000000000111","1001000000000010","0110000000010010","0001000000001011","0110000000000100","0110000000001000","0110000000001001","0001000000000010","0000000000000111","1001000000000010","0110000000001001","1001000000000100","0000000000000100","0000000000000011","0000000000001011","0000000000010000","0000000000010110","0110000000000011","0001000000000010","0000000000001011","0000000000001010","0110000000001011","0110000000000111","1001000000011110","0110000000000101","0110000000000011","0001000000000010","0000000000000101","1000000000000011","0110000000000111","0110000000000101","0001000000000010","0000000000000101","0000000000001010","0110000000000101","0000000000000100","0000000000000111","0000000000000011","0000000000000100","0000000000001110","0000000000011100","0000000000001000","0000000000000011","0000000000001100","0110000000001100","0001000000000011","0011000000000101","0001000000000111","0110000000000011","0110000000001111","0110000000000110","0110000000000100","0001000000000010","0000000000001010","0000000000000101","0011000000000011","0011000000000011","0011000000000011","0011000000000011","0011000000000110","0011000000000101","0000000000001000","1001000000000010","0011000000000110","0011000000000111","0011000000000101","0011000000000011","0011000000000010","1000000000000010","0000000000001010","0011000000000111","0011000000000101","0000000000110100","0001000000000010","0011000000000011","0011000000000011","0000000000010111","0011000000000111","0011000000000011","0011000000000011","0001000000000011","0011000000000010","1000000000000011","0000000000000101","0011000000000100","0011000000000010","1001000000000100","0011000000000011","0011000000000111","0011000000000011","0011000000000011","0011000000000100","0000000000001011","0011000000000011","0011000000000100","0001000000000011","0011000000000100","0000000000000101","0011000000000100","0011000000000100","0011000000001100","0011000000000101","0011000000000100","1000000000000010","0000000000001000","0011000000001001","0011000000000101","0000000000111000","0011000000000101","0000000000010111","1001000000000010","0011000000000011","0011000000010000","0000000000000100","0011000000000011","0011000000000011","0011000000000100","0011000000000101","0001000000000101","0011000000000011","0011000000000011","0011000000000011","1000000000000010","0000000000000111","0011000000000011","0011000000001001","0011000000000011","0000000000001101","0011000000000011","0011000000000100","0000000000110110","0011000000001000","0000000000010100","0011000000000101","0011000000000100","0011000000001001","0011000000000100","0000000000000101","0011000000000100","0011000000000011","0011000000000100","0011000000000111","0011000000000011","0011000000000011","0011000000000110","0000000000001001","0011000000000011","0000000000010001","1000000000001001","0000000000001000","0001000000001100","0000000000000101","0000000000001000","0000000000001011","0000000000001110","0000000000011001","0000000000000011","0000000000011110","0000000000000011","0000000000010000","0000000000010011","0000000000000111","0000000000010100","0000000000001111","0000000000001001","0000000000001010","1000000000000111","0000000000001000","0001000000000100","0001000000000101","0001000000000100","0000000000001111","0000000000010100","0000000000011100","0000000000000101","0000000000001001","0000000000001100","1000000000001001","0000000000010000","0000000000010000","0001000000001001","0000000000010110","0000000000001110","0000000000010101","0000000000001110","1000000000001001","0000000000101111","1000000000000110","0000000000000111","0000000000010001","0000000000001001","0001000000001101","0000000000000011","0000000000010110","0000000000001111","0000000000000111","0000000000000110","0000000000010101","0000000000101100","1000000000000110","0000000000010001","1000000000110010","0000000000001001","1000000000010001","0000000000010010","0000000000101100","1000000000000101","0000000000000011","0000000000001010","0000000000101010","1000000000000110","0000000000010001","1000000000011100","1000000000010100","1000000000000110","0000000000001000","1000000000000011","1000000000001011","0000000000010100","0000000000101011","1000000000000100","0000000000010011","1000000000000101","1000000000000110","0000000000001001","1000000000000011","1000000000011001","1000000000010111","0000000000001010","1000000000001100","1000000000000011","0000000000010100","0000000000101011","1000000000000101","0000000000001001","0000000000001111","1000000000001001","0000000000000011","0000000000000011","0000000000000011","0000000000000011","0000000000001100","0000000000001100","1000000000001011","0000000000000100","1000000000001001","1000000000000011","1000000000010101","0000000000000011","1000000000100001","1000000000000011","1000000000010001","0000000000000011","0000000000001001","1000000000001000","0000000000000101","0000000000000110","0000000000001010","0000000000000011","0000000000001100","1000000000000101","1000000000000100","0000000000000111","1000000000000111","1000000000001011","0000000000000011","0000000000001111","0000000000001011","1000000000000011","1000000000000110","0000000000000100","0000000000001110","1000000000010111","1000000000011100","0000000000000100","1000000000010100","0000000000000101","0000000000000011","0000000000000111","1000000000000110","0000000000000011","0000000000000101","0000000000000100","0000000000010100","0000000000000110","1000000000001000","0000000000000011","0000000000000011","0000000000001011","1000000000010010","1000000000000111","1000000000000100","1000000000010001","1000000000100011","1000000000000011","1000000000001000","1000000000000110","0000000000001111","1000000000000110","0000000000001001","0000000000000011","0000000000001011","0000000000000011","0000000000000011","0000000000000011","0000000000000111","1000000000001001","1000000000001000","1000000000010111","1000000000000110","1000000000000100","0000000000000110","1000000000011111","1000000000011100","1000000000000110","0101000000000011","1000000000010111","1000000000000101","1000000000010100","1000000000001110","1000000000001010","1000000000010001","0000000000000101","1000000000000110","1000000000011001","1000000000010001","1000000000000100","1000000000000100","0000000000000100","1000000000001010","1000000000111011","1000000000111000","1000000000000111","1000000000000101","1000000000001011","1000000000001000","0000000000000111","1000000000010110","1000000000001111","1000000000101100","1000000000001000","1000000001001100","1000000000001010","0000000000000110","1000000000001000","1000000000001111","1000000000001110","1000000000000011","1000000000100001","1000000000000011","1000000000111011","1000000000000110","1000000000111001","1000000000010100","1000000000001000","1000000000001100","1000000000001000","1000000000000011","1000000000110000","1000000000111010","1000000000001001","1000000000110001","1000000000010110","1000000000000110","1000000000010001","1000000000000100","1000000000000111","1000000000001111","1000000000000011","1000000000111010","1000000000110010","1000000000011010","1000000000000111","1000000000000011","1000000000001010","1000000000000011","1000000000001000","1000000000000011","1000000000110110","1000000000111011","1000000000000011","1000000000001011","1000000000110100","1000000000000111","1000000000101010","1000000000101111","1000000001000100","1000000000000101","1000000010000001","1000000001101100","1000000000011010","1000000000001010","1000000010001101","1000000100010111","1000000000110110","1000000001000110","1000000001000000","1000000000001001","1000000010100000","1000000011011011","1000000010111000","1000000010001101","1000000000000011","1000000001011110","1000000001000000","1000000010011011","0000000000000100","1000000000111110","1000000001110010","1000000000000101","1000000000111111","1000000000000111","1000000001000010","0101000000000010","1000000000000111","1000000001010110","0000000000000101","1000000000111101","0101000000000100","1000000000000011","1000000010010111","0101000000000100","1000000001000000","1000000001110111","1000000000111111","1000000001000110","0000000000000110","1000000001011010","0101000000000101","1000000001000010","1000000010010011","1000000000000101","0000000000000011","0000000000000010","1000000000000011","1000000001000000","1000000001101110","0000000000000100","1000000000000100","1000000001000000","1000000001000110","1000000000000101","1000000000000101","1000000001010011","1000000001000011","1000000000000100","0000000000000010","1000000010011001","1000000000111111","1000000000000110","1000000001110011","1000000000111101","1000000000000101","1000000000000011","1000000001001000","1000000010011110","1000000000000110","1000000010011000","1000000000111111","1000000000000110","1000000010101110","1000000000000011","1000000000000100","1000000001000111","1000000000000011","1000000010100001","1000000011011111","1000000010110101","1000000000000110","1000001001111011","1000000001000011","1000101000000100","1000101011011111","1000000110011010","1000001001111001","1000000000001101","1000000000000100","1000000011000011","1000000000010101","1000000000000110","1000000001001101","1000000100101111","1000000000100000","1000000000000011","1000000000101000","1000000010011110","0000000000000100","1000000000010011","1000000000101001","1000000000010010","0000000000000010","1000000000010100","1000000001111010","1000000000010100","1000000010100000","1000000000000011","1000000000010101","1000000000000111","0101000000000100","1000000000100110","0000000000000010","1000000010100010","1000000000010110","1000000000100111","1000000000010110","1000000000001111","0000000000000100","1000000001111010","1000000000010010","1000000010100011","1000000000001110","1000000000000101","1000000000010011","1000000000100011","0000000000000010","1000000010100000","0000000000000010","1000000000010001","1000000000000110","1000000000011101","1000000000000111","0000000000000100","1000000000010000","1000000000000100","1000000000010010","1000000000010111","1000000001011110","0000000000000110","1000000000010100","1000000010100000","1000000000010110","1000000000001001","1000000000000101","1000000000011101","1000000000001011","1000000010100001","1000000000010100","0101000000000010","1000000000011111","1000000000000100","0000000000000010","1000000000000101","1000000000010010","1000000000010010","1000000000010111","1000000001100011","1000000000001010","1000000000001100","1000000010011111","1000000000010111","1000000000001101","1000000000100110","1000000010011110","0000000000001010","1000000000000011","1000000000001111","1000000000100111","1000000000010101","1000000000001100","0000000000000110","1000000000010101","1000000001101001","1000000000001011","1000000000000101","1000000010100000","1000000000010110","1000000000001001","1000000000000011","1000000000100110","1000000010011111","0000000000000010","1000000000000111","1000000000110001","0000000000000010","0101000000000011","1000000000000011","1000000000000010","0000000000000100","1000000000011011","0000000000000110","1000000001110101","0000000000000100","1000000000000111","1000000000000111","1000000000001001","1000000010011110","1000000000000011","1000000000000101","1000000000001100","1000000000110100","0000000000000100","1000000010100111","1000000000110010","0000000000000100","1000000000000110","1000000000100100","1000000001110110","1000000000000101","1000000000000011","1000000010101111","1000000000000011","1000000000000101","1000000000111110","1000000011011111","1000000000101111","1000000001110111","1000000000000110","1000000010101010","1000000001001101","1000000010100001","1000000000000011","1000000000111110","1000000000100101","1000000001111000","1000000010111010","1000000000000100","1000001010010000","1000111110100000","1000111110100000","1000111110100000","1000111110100000","1000111110100000","1000111110100000","1000111110100000","1000111110100000","1000111110100000","1000111110100000","1000111101001111");

begin

   arrayLength <= background_rom_type'length;

	data <= BACKGROUND(TO_INTEGER(instructionAddress));


end imp;