library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    test_mode : in std_logic;       --    Audio CODEC controller test mode
    audio_request : out std_logic;  --    Audio controller request new data
    data : in unsigned(15 downto 0);
    write : in std_logic;
    chipselect : in std_logic;
    writedata : in unsigned(15 downto 0);
  
    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  de2_wm8731_audio;

architecture rtl of de2_wm8731_audio is     
    
    type rom_type is array(639 downto 0) of unsigned(15 downto 0);
    constant ROM1 : rom_type :=
	(
  "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111111011111111",
 "1111011011111111",
 "1111011111111111",
 "0001101100000000",
 "0001010100000000",
 "0000001000000000",
 "0010101000000000",
 "0010010000000000",
 "0011110000000000",
 "1110000011111111",
 "1101100111111111",
 "0000110100000000",
 "0101001000000000",
 "0011111100000000",
 "1101110111111111",
 "1011101011111111",
 "1001010011111111",
 "1101011111111111",
 "0000111100000000",
 "0110000100000000",
 "0110000000000000",
 "0100011000000000",
 "0001110100000000",
 "1101100111111111",
 "1001101111111111",
 "1100011011111111",
 "1101110111111111",
 "0000011100000000",
 "0001101100000000",
 "0000011100000000",
 "1111101111111111",
 "0001110100000000",
 "1111110111111111",
 "0000011100000000",
 "0000101100000000",
 "0001001100000000",
 "1111001111111111",
 "0000101100000000",
 "0010100100000000",
 "0000010000000000",
 "1110011011111111",
 "0010010100000000",
 "1110011111111111",
 "1101011011111111",
 "0000110000000000",
 "1100100111111111",
 "1110001011111111",
 "0010010000000000",
 "0010100100000000",
 "1111001111111111",
 "0000011100000000",
 "1110101111111111",
 "1111011011111111",
 "0000010000000000",
 "0011000100000000",
 "0010110100000000",
 "0001100000000000",
 "1100001111111111",
 "0000101000000000",
 "1110101011111111",
 "1101100011111111",
 "1011101011111111",
 "1101101011111111",
 "1111000111111111",
 "0001101000000000",
 "0100011000000000",
 "0010001100000000",
 "1111000111111111",
 "1110001011111111",
 "1111001011111111",
 "0001101100000000",
 "0001110000000000",
 "1111010111111111",
 "0000100100000000",
 "1110101111111111",
 "1100011111111111",
 "0000110000000000",
 "0000011100000000",
 "0010001000000000",
 "0001010100000000",
 "0010010100000000",
 "1111110111111111",
 "0001001100000000",
 "1111001011111111",
 "0000100100000000",
 "0000011100000000",
 "1111100011111111",
 "1111100111111111",
 "1101110111111111",
 "1100111011111111",
 "1011101011111111",
 "0000000100000000",
 "0000101000000000",
 "0100100100000000",
 "0011100000000000",
 "1111000011111111",
 "0000001100000000",
 "1101110011111111",
 "1011000011111111",
 "1100010111111111",
 "1101101011111111",
 "1111000011111111",
 "0000111100000000",
 "0010101000000000",
 "0001111100000000",
 "0001001000000000",
 "0000011000000000",
 "1101011111111111",
 "1111001111111111",
 "1111010111111111",
 "0001111000000000",
 "0001100100000000",
 "0001100100000000",
 "1111110111111111",
 "0001111100000000",
 "1101110111111111",
 "1101101111111111",
 "1111100011111111",
 "1101100011111111",
 "0001011100000000",
 "0010110100000000",
 "1111011111111111",
 "1110110111111111",
 "1111100111111111",
 "1110011011111111",
 "1110011011111111",
 "1110101111111111",
 "0001100100000000",
 "0001011000000000",
 "0010111100000000",
 "0000110000000000",
 "0001101000000000",
 "1110001011111111",
 "1101100111111111",
 "1110000111111111",
 "1110010111111111",
 "0000101000000000",
 "1110000011111111",
 "0001101100000000",
 "1101100011111111",
 "1101001111111111",
 "1111011011111111",
 "0001011100000000",
 "0100111100000000",
 "0010110000000000",
 "0010010000000000",
 "1101001011111111",
 "1101100111111111",
 "1101101011111111",
 "1101101011111111",
 "1110000111111111",
 "1101101011111111",
 "1100101111111111",
 "1111011011111111",
 "0000111000000000",
 "0001001100000000",
 "0011110100000000",
 "0100111000000000",
 "1110101111111111",
 "1110000111111111",
 "1011100011111111",
 "1101010111111111",
 "1100111111111111",
 "0001011100000000",
 "0001011000000000",
 "0001101100000000",
 "0010011100000000",
 "1111111011111111",
 "0000111000000000",
 "1101110011111111",
 "0000000000000000",
 "1111010111111111",
 "1110010011111111",
 "0001010100000000",
 "0001011100000000",
 "0001010100000000",
 "0001000100000000",
 "0000000100000000",
 "1101100111111111",
 "1111000011111111",
 "1110010111111111",
 "0001100000000000",
 "0010101100000000",
 "0010001100000000",
 "1110111011111111",
 "1110000111111111",
 "1110100111111111",
 "1111101111111111",
 "0000010100000000",
 "0000010000000000",
 "1110000011111111",
 "1101010011111111",
 "1100010011111111",
 "1101011111111111",
 "0010100000000000",
 "0100101000000000",
 "0101001100000000",
 "0010000100000000",
 "1110010011111111",
 "1101000011111111",
 "1011011111111111",
 "1110010011111111",
 "0000000100000000",
 "0001000100000000",
 "0100000000000000",
 "1111111011111111",
 "1101110111111111",
 "1110100011111111",
 "1111000111111111",
 "1111111011111111",
 "1111101011111111",
 "0010100000000000",
 "0010010100000000",
 "0001111000000000",
 "0010100000000000",
 "0000010000000000",
 "1100100111111111",
 "1110111111111111",
 "1100100011111111",
 "1111011011111111",
 "0000001100000000",
 "0001101100000000",
 "0000010000000000",
 "0010000000000000",
 "1111010111111111",
 "1111110111111111",
 "1101101111111111",
 "1110111111111111",
 "0000100000000000",
 "1111010011111111",
 "1101011011111111",
 "0000001100000000",
 "0000000000000000",
 "1111011011111111",
 "1101010011111111",
 "1101100111111111",
 "0000000000000000",
 "0010100100000000",
 "0010110100000000",
 "0100000000000000",
 "0001111100000000",
 "0000001000000000",
 "1110000011111111",
 "1010001011111111",
 "1011100111111111",
 "1110010011111111",
 "0011010000000000",
 "0001100100000000",
 "0010000100000000",
 "0010011100000000",
 "0000111100000000",
 "1101011011111111",
 "1101101011111111",
 "1100110111111111",
 "1111100011111111",
 "0001000100000000",
 "0000010000000000",
 "0001010000000000",
 "0000110100000000",
 "0000001000000000",
 "0000100000000000",
 "0000010100000000",
 "1111101111111111",
 "1110111011111111",
 "1110010011111111",
 "1101011011111111",
 "0000001100000000",
 "1111000111111111",
 "0010000000000000",
 "0001110100000000",
 "0001000000000000",
 "0001101100000000",
 "0001100100000000",
 "1111011111111111",
 "1110001011111111",
 "1111011111111111",
 "1111011111111111",
 "0000101100000000",
 "1110010011111111",
 "1101011111111111",
 "1101111111111111",
 "0000011100000000",
 "0011110100000000",
 "0011111000000000",
 "0001110100000000",
 "1110001111111111",
 "1101110011111111",
 "1100010011111111",
 "1100001011111111",
 "1111010111111111",
 "0001110000000000",
 "0000110100000000",
 "0010000000000000",
 "0001111000000000",
 "0000101000000000",
 "1111000011111111",
 "1110011011111111",
 "1101001111111111",
 "1110000111111111",
 "0001010000000000",
 "0011100000000000",
 "0011100000000000",
 "0010001000000000",
 "0000110000000000",
 "0010010000000000",
 "0001000100000000",
 "1101010011111111",
 "1011110011111111",
 "1010110011111111",
 "1011001111111111",
 "1110100111111111",
 "0001111000000000",
 "0011111000000000",
 "0100100100000000",
 "0100001100000000",
 "0001011000000000",
 "1110110011111111",
 "1101010111111111",
 "1100001011111111",
 "1111000111111111",
 "0000001100000000",
 "0000110000000000",
 "0010100100000000",
 "0011010100000000",
 "0001000000000000",
 "0000001000000000",
 "0000111100000000",
 "1101101011111111",
 "1101000011111111",
 "1101101011111111",
 "1110001011111111",
 "1110110011111111",
 "0010110000000000",
 "0011111100000000",
 "0001011100000000",
 "0000110000000000",
 "1111000111111111",
 "1111000111111111",
 "1101110011111111",
 "1111000111111111",
 "1110110011111111",
 "1111100111111111",
 "1111001011111111",
 "0001000000000000",
 "1111001011111111",
 "0001010000000000",
 "0001110100000000",
 "0000111000000000",
 "0010010100000000",
 "0001000000000000",
 "0000101000000000",
 "1110101111111111",
 "1110001011111111",
 "1110100011111111",
 "1111001011111111",
 "1110001111111111",
 "1111100111111111",
 "1111110011111111",
 "0000001100000000",
 "0010101100000000",
 "0001001100000000",
 "1111110111111111",
 "1111011111111111",
 "1111001011111111",
 "1101110011111111",
 "1111101111111111",
 "0010000000000000",
 "0011100000000000",
 "0010000100000000",
 "1111011011111111",
 "1101000011111111",
 "1101110111111111",
 "1101101011111111",
 "1111110111111111",
 "0001100100000000",
 "0001011000000000",
 "1111111011111111",
 "1111110011111111",
 "0000010000000000",
 "1111000111111111",
 "0000000100000000",
 "1111111011111111",
 "0001100100000000",
 "0001101100000000",
 "0000101000000000",
 "0010010000000000",
 "0000110000000000",
 "1110110011111111",
 "1111010011111111",
 "1101111011111111",
 "1111001111111111",
 "0000001000000000",
 "0000111100000000",
 "0001100000000000",
 "0000010100000000",
 "1111110011111111",
 "0000010000000000",
 "0000001100000000",
 "0001100100000000",
 "0000110000000000",
 "0000010000000000",
 "1110100011111111",
 "1110101011111111",
 "1111001011111111",
 "0000010000000000",
 "0001011000000000",
 "0010100000000000",
 "0000100000000000",
 "1111100011111111",
 "1110111011111111",
 "1100110011111111",
 "1111000011111111",
 "0001001100000000",
 "0010011100000000",
 "0011001000000000",
 "0000011100000000",
 "1111100111111111",
 "1111011111111111",
 "0000101000000000",
 "1111101111111111",
 "1111111011111111",
 "1101100111111111",
 "1101100011111111",
 "1101000011111111",
 "1111001011111111",
 "0010011100000000",
 "0100001000000000",
 "0100000100000000",
 "0001110000000000",
 "1111000111111111",
 "1101010111111111",
 "1100001011111111",
 "1101010011111111",
 "1111101111111111",
 "0011001000000000",
 "0011010000000000",
 "0010001000000000",
 "1111111011111111",
 "1110101011111111",
 "1100101111111111",
 "1101001111111111",
 "1110001111111111",
 "0000011100000000",
 "0010011100000000",
 "0011000000000000",
 "0001011100000000",
 "0001100000000000",
 "1111111011111111",
 "1111110111111111",
 "1111001111111111",
 "1110101111111111",
 "1111100011111111",
 "1111100111111111",
 "0000111100000000",
 "1111110111111111",
 "1111011111111111",
 "1110110111111111",
 "1110011111111111",
 "1111100011111111",
 "0001111000000000",
 "0000110100000000",
 "0001011000000000",
 "0000110100000000",
 "1111110011111111",
 "1101111011111111",
 "1101010011111111",
 "1110111111111111",
 "1111110111111111",
 "0001000000000000",
 "0001101000000000",
 "0010000100000000",
 "0001011000000000",
 "1110110111111111",
 "1101001011111111",
 "1101011011111111",
 "1110011111111111",
 "0000100000000000",
 "0010000000000000",
 "0001110000000000",
 "0000111100000000",
 "1111110111111111",
 "1111110011111111",
 "1110110111111111",
 "0000111100000000",
 "0000110000000000",
 "0000010000000000",
 "1111100011111111",
 "1110100011111111",
 "1110111011111111",
 "1111010111111111",
 "1111101111111111",
 "0000010000000000",
 "0000011000000000",
 "0001110000000000",
 "0001001000000000",
 "0001111100000000",
 "0000011000000000",
 "1110110111111111",
 "1110011111111111",
 "1110111011111111",
 "1110111011111111",
 "0000011000000000",
 "0000111000000000",
 "1111100011111111",
 "0000010100000000",
 "1111100111111111",
 "1101110111111111",
 "1101111011111111",
 "1110111111111111",
 "0001111100000000",
 "0010111000000000",
 "0010110000000000",
 "0010100100000000",
 "0001011000000000",
 "1101110111111111",
 "1101010011111111",
 "1101011011111111",
 "1110010111111111",
 "1111010011111111",
 "1111110111111111",
 "0000001000000000",
 "0000111000000000",
 "0000111000000000",
 "0000000000000000",
 "0001110100000000",
 "0000110000000000",
 "0001001100000000",
 "0000100100000000",
 "1111000011111111",
 "1110110011111111",
 "1110010011111111",
 "0000100000000000",
 "1111011111111111",
 "0000100000000000",
 "0001000100000000",
 "1111101011111111",
 "1111110011111111",
 "1111011011111111",
 "1111111011111111",
 "1111110011111111",
 "1111101111111111",
 "0000001100000000",
 "0000000100000000",
 "0001000000000000",
 "0000000000000000",
 "0000100000000000",
 "0000101100000000",
 "1111110111111111",
 "1111001111111111",
 "1111100011111111",
 "0000000000000000",
 "0001101000000000",
 "0000110100000000",
 "0000011100000000",
 "1111000111111111",
 "1101110011111111",
 "1110100111111111",
 "1111110111111111",
 "0000101100000000",
 "0001011000000000",
 "0000110100000000",
 "0000000100000000",
 "0000001100000000",
 "1111110011111111",
 "0000011000000000",
 "1111101111111111",
 "1111110111111111",
 "1111011011111111",
 "1111011011111111",
 "1111001111111111",
 "1111110111111111",
 "0000111100000000",
 "0000111100000000",
 "0000011000000000",
 "0000001000000000",
 "0000110000000000",
 "1111110011111111",
 "1111110011111111",
 "0000001100000000",
 "1111110111111111",
 "1111110111111111",
 "1111110011111111",
 "1111110011111111",
 "1111001011111111",
 "1110011111111111",
 "0000010000000000",
"0000100100000000",
 "0001000100000000",
 "0001011000000000",
 "0000111100000000",
 "0000000100000000",
 "1111100011111111",
 "1111101011111111",
 "1111111011111111",
 "1111000011111111",
 "1111101111111111",
 "1110110011111111",
 "1111011111111111",
 "1111101111111111",
 "0000000100000000",
 "0000100000000000",
 "0000000100000000",
 "0000010100000000",
 "0000111000000000",
 "0001001000000000",
 "0000101000000000",
 "0000110000000000",
 "1111010011111111",
 "1111010011111111",
 "1111110011111111",
 "1110111011111111",
 "1111101011111111",
 "1111000011111111",
 "1111101011111111",
 "1111101011111111",
 "1111110111111111",
 "0000001100000000",
 "0000110100000000",
 "0000011100000000",
 "0000011000000000",
 "1111011111111111",
 "1111101111111111",
 "0000000000000000",
 "1111111011111111",
 "0000000100000000",
 "0000011000000000",
 "1111101111111111",
 "1111100111111111",
 "1111011011111111",
 "1111011011111111",
 "1111111011111111"
	);
	type rom_type2 is array(47 downto 0) of unsigned(15 downto 0);
    constant ROM2 : rom_type2 :=
(
    X"0000",
    X"10b4",
    X"2120",
    X"30fb",
    X"3fff",
    X"4deb",
    X"5a81",
    X"658b",
    X"6ed9",
    X"7640",
    X"7ba2",
    X"7ee6",
    X"7fff",
    X"7ee6",
    X"7ba2",
    X"7640",
    X"6ed9",
    X"658b",
    X"5a81",
    X"4deb",
    X"3fff",
    X"30fb",
    X"2120",
    X"10b4",
    X"0000",
    X"ef4b",
    X"dee0",
    X"cf05",
    X"c001",
    X"b215",
    X"a57e",
    X"9a74",
    X"9127",
    X"89bf",
    X"845d",
    X"8119",
    X"8000",
    X"8119",
    X"845d",
    X"89bf",
    X"9127",
    X"9a74",
    X"a57e",
    X"b215",
    X"c000",
    X"cf05",
    X"dee0",
    X"ef4b"
);
	
    signal key : unsigned(19 downto 0):=x"00001";
    signal reset : std_logic;
    signal music : std_logic:='0';
--    signal cnt : unsigned(14 downto 0):="000000000000000";
    signal cnt : unsigned(13 downto 0):="00000000000000";
    
    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck  : std_logic;
    
    signal lrck_divider : unsigned(19 downto 0); 
    signal bclk_divider : unsigned(15 downto 0);
    
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal clr_bclk : std_logic;
    signal lrck_lat : std_logic;
    
    signal shift_out : unsigned(15 downto 0);

    signal sin_out     : unsigned(15 downto 0);
    signal sin_counter : unsigned(9 downto 0):="0000000000";    

begin
  
    -- LRCK divider 
    -- Audio chip main clock is 18.432MHz / Sample rate 48KHz
    -- Divider is 18.432 MHz / 48KHz = 192 (X"C0")
    -- Left justify mode set by I2C controller
  
--variable stop : std_logic := '1';

  process(clk)
 begin
     if rising_edge(clk) then
		if chipselect = '1' then
			if write = '1' then
                
				key <= writedata & "0000";
				    
--				if key = x"003e0" or key = x"00380" or key = x"00310" or key = x"002e0" or key = x"00290" or key = x"00250" or key = x"00210" then
--                    music <= '1';
--                else
--                    music <= '0';
--                end if;
			
			else
		        key <= x"00001";
			end if;
		
		end if;
	  end if;
  end process;
  
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then 
        lrck_divider <= (others => '0');
      elsif lrck_divider = key-1  then        -- "C0" minus 1
	--  elsif lrck_divider = 191  then
        lrck_divider <= X"00000";
      else 
        lrck_divider <= lrck_divider + 1;
      end if;
    end if;   
  end process;

  process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then 
        bclk_divider <= (others => '0');
      elsif bclk_divider = key(19 downto 4)-1 or set_lrck = '1'  then
  --    elsif bclk_divider = 11 or set_lrck = '1'  then  
        bclk_divider <= X"0000";
      else 
        bclk_divider <= bclk_divider + 1;
      end if;
    end if;
  end process;

  set_lrck <= '1' when lrck_divider = key-1 else '0';
  --set_lrck <= '1' when lrck_divider = 191 else '0';
--  stop <= '0' when key = x"00300" else '1';
    
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        lrck <= '0';
      elsif set_lrck = '1' then 
        lrck <= not lrck;
      end if;
    end if;
  end process;
    
  -- BCLK divider
  set_bclk <= '1' when bclk_divider(11 downto 0) = ('0' & key(19 downto 5))-1 else '0';
  clr_bclk <= '1' when bclk_divider(11 downto 0) = key(19 downto 4)-1 else '0';

--  set_bclk <= '1' when bclk_divider(11 downto 0) = 5 else '0';
--  clr_bclk <= '1' when bclk_divider(11 downto 0) = 11 else '0';
  
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        bclk <= '0';
      elsif set_lrck = '1' or clr_bclk = '1' then
        bclk <= '0';
      elsif set_bclk = '1' then 
        bclk <= '1';
      end if;
    end if;
  end process;

  -- Audio data shift output
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        shift_out <= (others => '0');
      elsif set_lrck = '1' then
        if test_mode = '1' then 
          shift_out <= sin_out;
        else 
          shift_out <= data;
        end if;
      elsif clr_bclk = '1' then 
        shift_out <= shift_out (14 downto 0) & '0';
      end if;
    end if;   
  end process;

    -- Audio outputs
    
    AUD_ADCLRCK  <= lrck;          
    AUD_DACLRCK  <= lrck;
  
    AUD_DACDAT   <= shift_out(15);
    
    AUD_BCLK     <= bclk;          

    -- Self test with Sin wave
    
    process(clk)      
    begin
      if rising_edge(clk) then
        if reset_n = '0' then 
            sin_counter <= (others => '0');
        elsif lrck_lat = '1' and lrck = '0'  then 
	    if key = x"00610" then 
          if cnt = "11111001111111" then 
             cnt <= "11111001111111";
          else 
            if cnt mod 25 = 0 then
                 if sin_counter = "1001111111" then
					sin_counter <= "0000000000";
				 else
                    sin_counter <= sin_counter + 1;
                 end if;
            end if;
            cnt <= cnt + 1;
          end if;
        else
          if key = x"00c20" then
            cnt <= "00000000000000";
            sin_counter <= "0000000000";
--          elsif key = x"003e0" or key = x"00380" or key = x"00310" or key = x"002e0" or key = x"00290" or key = x"00250" or key = x"00210" then
--          elsif music = '1' then
          else
            if cnt = "11111001111111" then
               cnt <= "11111001111111";
            else
               cnt <= cnt +1;
            end if;
          end if;
        end if;
        end if;
      end if;
    end process;



    process(clk)
    begin
      if rising_edge(clk) then
        lrck_lat <= lrck;
      end if;
    end process;

    process (clk) 
    begin
      if rising_edge(clk) then 
        if lrck_lat = '1' and lrck = '0' then
          audio_request <= '1';
        else 
          audio_request <= '0';
        end if;
      end if;
    end process;

  process (clk)
  variable temp : unsigned(29 downto 0);
  begin
if cnt = "11111001111111" then
   sin_out <=x"0000";
else
 
 if key = x"00610" then
  if cnt mod 25 = 0  then
    sin_out <= ROM1(to_integer(sin_counter))(15 downto 0);
  else
    temp := (((ROM1(to_integer(sin_counter+1)) - ROM1(to_integer(sin_counter))))*(cnt mod 25)/25);
    sin_out <= temp(15 downto 0)+ ROM1(to_integer(sin_counter));
  end if;
-- if key = x"003e0" or key = x"00380" or key = x"00310" or key = x"002e0" or key = x"00290" or key = x"00250" or key = x"00210" then
-- if music = '1' then
 else
  sin_out <= ROM2(to_integer(cnt mod 48))(15 downto 0);
 end if;
end if;
  end process;

--  with sin_counter select sin_out <=
--    X"0000" when "000000",
--    X"10b4" when "000001",
--    X"2120" when "000010",
--    X"30fb" when "000011",
--    X"3fff" when "000100",
--    X"4deb" when "000101",
--    X"5a81" when "000110",
--    X"658b" when "000111",
--    X"6ed9" when "001000",
--    X"7640" when "001001",
--    X"7ba2" when "001010",
--    X"7ee6" when "001011",
--    X"7fff" when "001100",
--    X"7ee6" when "001101",
--    X"7ba2" when "001110",
--    X"7640" when "001111",
--    X"6ed9" when "010000",
--    X"658b" when "010001",
--    X"5a81" when "010010",
--    X"4deb" when "010011",
--    X"3fff" when "010100",
--    X"30fb" when "010101",
--    X"2120" when "010110",
--    X"10b4" when "010111",
--    X"0000" when "011000",
--    X"ef4b" when "011001",
--    X"dee0" when "011010",
--    X"cf05" when "011011",
--    X"c001" when "011100",
--    X"b215" when "011101",
--    X"a57e" when "011110",
--    X"9a74" when "011111",
--    X"9127" when "100000",
--    X"89bf" when "100001",
--    X"845d" when "100010",
--    X"8119" when "100011",
--    X"8000" when "100100",
--    X"8119" when "100101",
--    X"845d" when "100110",
--    X"89bf" when "100111",
--    X"9127" when "101000",
--    X"9a74" when "101001",
--    X"a57e" when "101010",
--    X"b215" when "101011",
--    X"c000" when "101100",
--    X"cf05" when "101101",
--    X"dee0" when "101110",
--    X"ef4b" when "101111",
--    X"0000" when others;      

end architecture;


