-------------------------------------------------------------------------------
--
-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_vga_raster1 is
  
  port (
    reset : in std_logic;
    clk   : in std_logic;                    
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(7 downto 0);
    readdata   : out unsigned(15 downto 0);
    writedata  : in  unsigned(15 downto 0);

    VGA_CLK,                         -- Clock -- Should be 25.125 MHz
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out unsigned(9 downto 0) -- Blue[9:0]
    );

end de2_vga_raster1;

architecture rtl of de2_vga_raster1 is
  
  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;
  -- Signals for the video controller
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;

  signal vga_hblank, vga_hsync,
    vga_vblank, vga_vsync : std_logic;  -- Sync. signals

  signal clk_counter : std_logic := '0'; 

  -------------------------------player coordinates pos state------------------------------------ 
 
  signal player1_x : unsigned (9 downto 0) := "0000110000";   -- the x_pos of the player1
  signal player1_y : unsigned (9 downto 0) := "0000110000";   -- the y_pos of the player1
  signal player1_pos  : unsigned (1 downto 0) := "10"; 		  -- face down
  signal player1_s : unsigned (2 downto 0) := "000";   		  -- the state of the player1

  -----------------------------------------------------------------------------------------------
  signal player2_x : unsigned (9 downto 0) := "1000110000";   -- the x_pos of the player2
  signal player2_y : unsigned (9 downto 0) := "0110110000";   -- the y_pos of the player2
  signal player2_pos  : unsigned (1 downto 0) := "10"; 		  -- face down
  signal player2_s : unsigned (2 downto 0) := "000";   		  -- the state of the player2
  -----------------------------------------------------------------------------------------------
  signal player3_x : unsigned (9 downto 0) := "1000110000";   -- the x_pos of the player3
  signal player3_y : unsigned (9 downto 0) := "0000110000";   -- the y_pos of the player3
  signal player3_pos  : unsigned (1 downto 0) := "10"; 		  -- face down
  signal player3_s : unsigned (2 downto 0) := "000";   		  -- the state of the player3
  -----------------------------------------------------------------------------------------------
  signal player4_x : unsigned (9 downto 0) := "0000110000";   -- the x_pos of the player4
  signal player4_y : unsigned (9 downto 0) := "0110110000";   -- the y_pos of the player4
  signal player4_pos  : unsigned (1 downto 0) := "10"; 		  -- face down
  signal player4_s : unsigned (2 downto 0) := "000";   		  -- the state of the player4
  --------------------------------title--------------------------------------------------
  signal title_x : unsigned (9 downto 0)   := "0100110000";   -- the x_pos of the title
  signal title_y : unsigned (9 downto 0)   := "0110000000";   -- the y_pos of the title
  --------------------------------pointer--------------------------------------------------
  signal pointer_x : unsigned (9 downto 0) := "0011101000";   -- the x_pos of the title
  signal pointer_y : unsigned (9 downto 0) := "0110000000";   -- the y_pos of the title
  --------------------------------logo--------------------------------------------------
  signal logo_x : unsigned (9 downto 0)    := "0100110000";   -- the x_pos of the logo
  signal logo_y : unsigned (9 downto 0)    := "0011000000";   -- the y_pos of the logo
  -------------------------------Game Settings------------------------------------------
  ----gamestage "0000" preparing   "0001" playing "0010" gameover-----------------------
  signal gamestage : unsigned (3 downto 0) := "0000";
  -----------playing status------------- 
  signal playing : unsigned (3 downto 0) := "0001";
  ----timer for the game units = 0.01s--------------------------------------------------
  signal timer : unsigned(15 downto 0) := (others => '0');



  type array_type_32x32 is array (31 downto 0) of unsigned (31 downto 0);
  signal sprite_background0  : array_type_32x32;
  signal sprite_background1  : array_type_32x32;
  signal sprite_concrete0    : array_type_32x32;
  signal sprite_concrete1    : array_type_32x32;
  signal sprite_concrete2    : array_type_32x32;
  signal sprite_bomber0      : array_type_32x32;
  signal sprite_bomber1      : array_type_32x32;
  signal sprite_bomber2      : array_type_32x32;
  signal sprite_bomber3      : array_type_32x32;
  signal sprite_fire0        : array_type_32x32;
  signal sprite_fire1        : array_type_32x32;
  signal sprite_fire2        : array_type_32x32;
  signal sprite_fireM0		 : array_type_32x32;
  signal sprite_fireM1		 : array_type_32x32;
  signal sprite_fireM2		 : array_type_32x32;
  signal sprite_brick0       : array_type_32x32;
  signal sprite_brick1       : array_type_32x32;
  signal sprite_brick2       : array_type_32x32;
  signal sprite_powerup0     : array_type_32x32;
  signal sprite_powerup1     : array_type_32x32;
  signal sprite_powerup2     : array_type_32x32;
  signal sprite_bombup0      : array_type_32x32;
  signal sprite_bombup1      : array_type_32x32;
  signal sprite_bombup2      : array_type_32x32;
  signal sprite_bombup3      : array_type_32x32;
  signal sprite_speedup0     : array_type_32x32;
  signal sprite_speedup1     : array_type_32x32;
  signal sprite_speedup2     : array_type_32x32;
  signal sprite_speedup3     : array_type_32x32;
  signal sprite_bomberman0   : array_type_32x32;
  signal sprite_bomberman1   : array_type_32x32;
  signal sprite_bomberman2   : array_type_32x32;
  signal sprite_bomberman3   : array_type_32x32;
  signal sprite_bomberman4   : array_type_32x32;
  signal sprite_bombermanB0  : array_type_32x32;
  signal sprite_bombermanB1  : array_type_32x32;
  signal sprite_bombermanB2  : array_type_32x32;
  signal sprite_bombermanB3  : array_type_32x32;
  signal sprite_bombermanB4  : array_type_32x32;
  signal sprite_bombermanL0  : array_type_32x32;
  signal sprite_bombermanL1  : array_type_32x32;
  signal sprite_bombermanL2  : array_type_32x32;
  signal sprite_bombermanL3  : array_type_32x32;
  signal sprite_bombermanL4  : array_type_32x32;
-----------------------------Control Array---------------------------------
  type array_type_15x120 is array (14 downto 0, 119 downto 0) of std_logic;
--------------------------beginning title----------------------------------
  type array_type_16x16 is array (15 downto 0) of unsigned (15 downto 0);  
  type array_type_48x128 is array (47 downto 0) of unsigned (127 downto 0);
  type array_type_200x200 is array (199 downto 0) of unsigned (199 downto 0);
signal sprite_bombermanlogo0  : array_type_200x200;
signal sprite_bombermanlogo1  : array_type_200x200;
signal sprite_bombermanlogo2  : array_type_200x200;
signal sprite_bombermanlogo3  : array_type_200x200;

 -------------------------------------------------------------------------- 
   signal control_array: array_type_15x120 := 
  ("111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000",
   "111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000",
   "111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000",
   "111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000",
   "111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000",
   "111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000",
   "111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000",
   "111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000",
   "111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000",
   "111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000",
   "111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000",
   "111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000",
   "111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000111111000000",
   "111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000",
   "111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000"
  );

   ---2 or 4 players----
   signal title: array_type_48x128 := 
   ("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",	     		
	"00011111111110000001111111111000001111000000000000011111111110000111100000011110001111111111111000011111111110000000111111111000",
	"00011111111110000011111111111100001111000000000000111111111111000111100000011110011111111111111000111111111111000011111111111100",
	"01111000000111100111111001111110001111000000000001111110011111100011100000011100011110000000000001111110011111100111111111111110",
	"01111000000111100111110000111110001111000000000001111100001111100011100000011100011110000000000001111110011111100111111111111110",
	"00000000011111100111110000111110001111000000000001111100001111100001111001111000011110000000000001111100001111100111100000000000",
	"00000000011111100111111001111110001111000000000001111110011111100001111001111000011110000000000001111100001111000111100000000000",
	"00000111111110000111111111111100001111000000000001111111111111100000111111110000011111111111111001111110011110000111111111111000",
	"00000111111110000111111111111000001111000000000001111111111111100000011111100000011111111111111001111111111100000011111111111100",
	"00011111111000000111100000000000001111000000000001111000001111100000001111000000011110000000000001111111111110000001111111111110",
	"00011111111000000111100000000000001111000000000001111000000111100000001111000000011110000000000001111000001111000000000001111110",
	"01111110000000000111100000000000001111000000000001111000000111100000001111000000011110000000000001111000000111100000000001111110",
	"01111110000000000111100000000000001111111111110001111000000111100000001111000000011110000000000001111000000111100111111111111110",
	"01111111111111100111100000000000001111111111110001111000000111100000001111000000011111111111111001111000000111100011111111111100",
	"01111111111111100111100000000000001111111111110001111000000111100000001111000000001111111111111001111000000111100001111111111000",
	"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
	"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",	     		
	"00000111111110000001111111111000001111000000000000011111111110000111100000011110001111111111111000011111111110000000111111111000",
	"00001111111110000011111111111100001111000000000000111111111111000111100000011110011111111111111000111111111111000011111111111100",
	"00011000011110000111111001111110001111000000000001111110011111100011100000011100011110000000000001111110011111100111111111111110",
	"00011000011110000111110000111110001111000000000001111100001111100011100000011100011110000000000001111110011111100111111111111110",
	"00000000011110000111110000111110001111000000000001111100001111100001111001111000011110000000000001111100001111100111100000000000",
	"00000000011110000111111001111110001111000000000001111110011111100001111001111000011110000000000001111100001111000111100000000000",
	"00000001111000000111111111111100001111000000000001111111111111100000111111110000011111111111111001111110011110000111111111111000",
	"00000001111000000111111111111000001111000000000001111111111111100000011111100000011111111111111001111111111100000011111111111100",
	"00000000011111100111100000000000001111000000000001111000001111100000001111000000011110000000000001111111111110000001111111111110",
	"00000000011111100111100000000000001111000000000001111000000111100000001111000000011110000000000001111000001111000000000001111110",
	"01100000000111100111100000000000001111000000000001111000000111100000001111000000011110000000000001111000000111100000000001111110",
	"01100000000111100111100000000000001111111111110001111000000111100000001111000000011110000000000001111000000111100111111111111110",
	"00011111111110000111100000000000001111111111110001111000000111100000001111000000011111111111111001111000000111100011111111111100",
	"00011111111110000111100000000000001111111111110001111000000111100000001111000000001111111111111001111000000111100001111111111000",
	"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
	"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
	"00000001111110000001111111111000001111000000000000011111111110000111100000011110001111111111111000011111111110000000111111111000",
	"00000001111110000011111111111100001111000000000000111111111111000111100000011110011111111111111000111111111111000011111111111100",
	"00000111111110000111111001111110001111000000000001111110011111100011100000011100011110000000000001111110011111100111111111111110",
	"00000111111110000111110000111110001111000000000001111100001111100011100000011100011110000000000001111110011111100111111111111110",
	"00011110011110000111110000111110001111000000000001111100001111100001111001111000011110000000000001111100001111100111100000000000",
	"00011110011110000111111001111110001111000000000001111110011111100001111001111000011110000000000001111100001111000111100000000000",
	"00111000011110000111111111111100001111000000000001111111111111100000111111110000011111111111111001111110011110000111111111111000",
	"00111000011110000111111111111000001111000000000001111111111111100000011111100000011111111111111001111111111100000011111111111100",
	"01111111111111100111100000000000001111000000000001111000001111100000001111000000011110000000000001111111111110000001111111111110",
	"01111111111111100111100000000000001111000000000001111000000111100000001111000000011110000000000001111000001111000000000001111110",
	"00000000011110000111100000000000001111000000000001111000000111100000001111000000011110000000000001111000000111100000000001111110",
	"00000000011110000111100000000000001111111111110001111000000111100000001111000000011110000000000001111000000111100111111111111110",
	"00000000011110000111100000000000001111111111110001111000000111100000001111000000011111111111111001111000000111100011111111111100",
	"00000000011110000111100000000000001111111111110001111000000111100000001111000000001111111111111001111000000111100001111111111000",
	"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
   );

	signal pointer: array_type_16x16 := 
	( "0000000000000000",
	  "0001100000000000",
	  "0001110000000000",
	  "0001111100000000",
	  "0001111110000000",
	  "0001111111000000",
	  "0001111111100000",
	  "0001111111110000",
	  "0001111111110000",
	  "0001111111100000",
	  "0001111111000000",
	  "0001111110000000",
	  "0001111100000000",
	  "0001110000000000",
	  "0001100000000000",
	  "0000000000000000"	
	);
   


begin
----------------------------------bomberman logo--------------------------------------------------------------------
sprite_bombermanlogo0(0) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(1) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(2) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(3) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(4) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(5) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(6) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(7) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(8) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(9) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(10) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(11) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(12) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(13) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(14) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(15) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(16) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(17) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(18) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000010000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(19) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(20) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(21) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(22) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(23) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(24) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100010000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(25) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(26) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000100000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(27) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(28) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(29) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(30) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(31) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(32) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(33) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111110110000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(34) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111110000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(35) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110111111111111000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(36) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000111111111111110000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(37) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100001111111111111111000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(38) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100111111111111111111100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(39) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111101111111111111111111110000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(40) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(41) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(42) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(43) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111110111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(44) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(45) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100000001111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(46) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000000111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(47) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000011111110000000011111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(48) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(49) <= "00000000000000000000000000000000000000000000000000000000000000000000000000011111110000000011111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(50) <= "00000000000000000000000000000000000000000000000000000000000000000000000000111111000000000111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(51) <= "00000000000000000000000000000000000000000000000000000000000000000000000001111110000000011111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(52) <= "00000000000000000000000000000000000000000000000000000000000000000000000011111100000000111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(53) <= "00000000000000000000000000000000000000000000000000000000000000000000000111110000000001111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(54) <= "00000000000000000000000000000000000000000000000000000000000000000000001111100000000011111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(55) <= "00000000000000000000000000000000000000000000000000000000000000000000011111000000000111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(56) <= "00000000000000000000000000000000000000000000000000000000000000000000111110000000001111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(57) <= "00000000000000000000000000000000000000000000000000000000000000000001111100000000011111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(58) <= "00000000000000000000000000000000000000000000000000000000000000000011111110000001111100111111111111111110010001111000000000000000111111111111111111000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(59) <= "00000000000000000000000000000000000000000000000000000000000000011111111111110011111110000001111111100000000000011000000000000000001111000000001111111100000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(60) <= "00000000000000000000000000000000000000000000000000000000000001111000000001111111000000000000111111000000000000011000000000000000000111000000000000001110000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(61) <= "00000000000000000000000000000000000000000000000000000000000111000000000000001111000000000000111111000000000000011100000000000000000011100000000000000011111111000000000000000000000000000000000000000000";
sprite_bombermanlogo0(62) <= "00000000000000000000000000000000000000000001111111100000001100000000000000000011110000000000011110000000000000011100000000011100000001100000000000000001111011111100000000000000000000000000000000000000";
sprite_bombermanlogo0(63) <= "00000000000000000000000000000000000000011111111111111100111000000000000000000001111000000000000000000000000000001100000000111110000001100000000000000001100000001111100000000000000000000000000000000000";
sprite_bombermanlogo0(64) <= "00000000000000000000000000000000000011111100000000001111110000000000000000000000111000000000000000000000000000001100000000111110000001100000000000000001100000000000111100000000000000000000000000000000";
sprite_bombermanlogo0(65) <= "00000000000000000000000000000000001111000000000000000011100000000000000000000000011100000000000000000000000000001100000000111110000001100000000000000001100000000000000111000000000000000000000000000000";
sprite_bombermanlogo0(66) <= "00000000000000000000000000000001111000000000000000000001110000000000000000000000001110000000000000000000000000001100000000111110000001100000000000000001100000000000000001100000000000000000000000000000";
sprite_bombermanlogo0(67) <= "00000000000000000000000000000111100000000000000000000000110000000000000000000000000110000000000000000000000000001100000000011100000001100000111000000011000000000000000000110000000000000000000000000000";
sprite_bombermanlogo0(68) <= "00000000000000000000000000011110000000000000000000000000110000000000000000000000000111000000000000000000000000001100000000000000000011000000111111111110000000000000000000011000000000000000000000000000";
sprite_bombermanlogo0(69) <= "00000000000000000000000001111000000000000000000000000000111000000000000000000000000011000000000000000000000000001100000000000000000110000000000111111110000000000111100000001000000000000000000000000000";
sprite_bombermanlogo0(70) <= "00000000000000000000000011100000000000000000000000000000011000000000000000000000000011100000000000000000000000000100000000000000000110000000000000000111000000000111110000001100000000000000000000000000";
sprite_bombermanlogo0(71) <= "00000000000000000000001110000000000000000000000000000000011000000000000000111100000001100000000000000000000000000100000000000000001100000000000000000011000000001111110000001100000000000000000000000000";
sprite_bombermanlogo0(72) <= "00000000000000000000011000000000000000000011110000000000011000000000000001111110000001100000000000000000000000000100000000000000000110000000000000000001100000000111110000001100000000000000000000000000";
sprite_bombermanlogo0(73) <= "00000000000000000000110000000000000000000111111000000000011000000000000001111110000001100000000000000000000000000110000000000000000011000000000000000001100000000111100000001100000000000000000000000000";
sprite_bombermanlogo0(74) <= "00000000000000000000100000000000000000000111111000000000011000000000000001111110000000100000000000000000000000000110000000000000000001100000000000000011000000000000000000001100000000000000000000000000";
sprite_bombermanlogo0(75) <= "00000000000000000001100000000000000000000111111000000000011000000000000001111110000000100000000000000000000000000110000000001100000001100000111000000111000000000000000000011100000000000000000000000000";
sprite_bombermanlogo0(76) <= "00000000000000000001100000000000000000000111111000000000010000000000000000111100000000100000000000000000000000000110000000011110000000100000111111111110000000000000000000111100000000000000000000000000";
sprite_bombermanlogo0(77) <= "00000000000000000001100000000000000000000011110000000000010000000000000000000000000000100000000000000000000000000110000000011111000000110000000001111110000000000000000011111100000000000000000000000000";
sprite_bombermanlogo0(78) <= "00000000000000000000100000000000000000000000100000000000011000000000000000000000000000100000000000011000000000000110000000011111000000100000000000000110000000000000001111111100000000000000000000000000";
sprite_bombermanlogo0(79) <= "00000000000000000000110000000000000000000000000000000000011111000000000000000000000000100000000000111000000000000110000000011111000001100000000000000011000000000000001111111100000000000000000000000000";
sprite_bombermanlogo0(80) <= "00000000000000000000110000000000000000000000000000000000000111110000000000000000000001100111100000111000000000000110000000001110000001100000000000000011000000000000001111111000000000000000000000000000";
sprite_bombermanlogo0(81) <= "00000000000000000000010000000000000000000000000000000000000000111100000000000000000001100111110001111100000000000010000000000000000011000000000000000001000011000000001111110000000000000000000000000000";
sprite_bombermanlogo0(82) <= "00000000000000000000011000000000000000000000000000000000000000001110000000000000000001100111111111111100000000000010000000000000000011000000000000000001000011100000000111000000000000000000000000000000";
sprite_bombermanlogo0(83) <= "00000000000000000000001000000000000000000000000000000000000000000011000000000000000001000011111111111100000000000110000000000000000110000000000000000011000111100000000110000000000000000000000000000000";
sprite_bombermanlogo0(84) <= "00000000000000000000000100000000000000000000000000000000000000000001100000000000000011000011111111111100000000000110000000000000011110000000000000000011000111110000000111000000000000000000000000000000";
sprite_bombermanlogo0(85) <= "00000000000000000000000100000000000000000000000000000000000000000001100000000000000011000011111111111100000000001110000000111111111111110000000000000110000111110000000111000000000000000000000000000000";
sprite_bombermanlogo0(86) <= "00000000000000000000000110000000000000000000000000000000000000000000100000000000000110000011111111111111111111111111111111111111111111111111111111111110001111110000000111000000000000000000000000000000";
sprite_bombermanlogo0(87) <= "00000000000000000000000011000000000000000000000000000000000000000000110000000000000110000011111111111111111111111111111111111111111111111111111111111111111111110000000111000000000000000000000000000000";
sprite_bombermanlogo0(88) <= "00000000000000000000000001000000000000000000000000000000000000000000110000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111000000111100000000000000000000000000000";
sprite_bombermanlogo0(89) <= "00000000000000000000000001100000000000000000000000000111100000000000110000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111000000111100000000000000000000000000000";
sprite_bombermanlogo0(90) <= "00000000000000000000000000100000000000000000000000001111110000000000110000000000111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111100000000000000000000000000000";
sprite_bombermanlogo0(91) <= "00000000000000000000000000110000000000000000000000001111110000000000110000000001111111111111111111111111111111111111111111111111111111111111111111111111111100000011111111100000000000000000000000000000";
sprite_bombermanlogo0(92) <= "00000000000000000000000000010000000000000000000000001111110000000000110000000111111111111111111111111111111111111111111111111111111111111111111111111111111100000001111111110000000000000000000000000000";
sprite_bombermanlogo0(93) <= "00000000000000000000000000011000000000000000000000001111110000000000110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111110000111111111111110000000000000000000000";
sprite_bombermanlogo0(94) <= "00000000000000000000000000001000000000000000000000000111100000000000110011111111111111111111111111111110000111111111111100011111111111111111000000011111111111111000011111111111111000000000000000000000";
sprite_bombermanlogo0(95) <= "00000000000000000000000000000100000000000000000000000000000000000001111111111111111111111111111111111000000011111111100000001111111111111100000000011111111000011000000111000000011000000000000000000000";
sprite_bombermanlogo0(96) <= "00000000000000000000000000000100000000000000000000000000000000000001111111111111111111111111111111110000000011111111000000001111111111110000000000001111110000001100000110000000011000000000000000000000";
sprite_bombermanlogo0(97) <= "00000000000000000000000000000010000000000000000000000000000000000011111111111111111111111111111111000000000001111100000000001111111111000000000000001111100000000100000100000000011000000000000000000000";
sprite_bombermanlogo0(98) <= "00000000000000000000000000000011000000000000000000000000000000000111111111111111111111111111111110000000000000111000000000011111111110000000000000001111100000000110001100000000011110000000000000000000";
sprite_bombermanlogo0(99) <= "00000000000000000000000000000001000000000000000000000000000000000111111111111111111111111111111100000000000000000000000000011111111100000000000000001111000000000010001000000000111110000000000000000000";
sprite_bombermanlogo0(100) <= "00000000000000000000000000000001100000000000000000000000000000001111111111111111111111111111111000000000000000000000000000011111111000000111000000001110000000000011011000000000111110000000000000000000";
sprite_bombermanlogo0(101) <= "00000000000000000000000000000000100000000000000000000000000000011111111111111111111111111111110000000000000000000000000000011111100000001111100000011110000000000001110000000000111110000000000000000000";
sprite_bombermanlogo0(102) <= "00000000000000000000000000000000110000000000000000000000000001111111111111111111111111111111100000000000000000000000000000111111000000001111100000011100000000000001110000000001111100000000000000000000";
sprite_bombermanlogo0(103) <= "00000000000000000000000000000000010000000000000000000000000011111111111111111111111111111111000000000000000000000000000000111111000000001111100000011100000000000000000000000001111100000000000000000000";
sprite_bombermanlogo0(104) <= "00000000000000000000000000000000001000000000000000000000001111111111111111111111111111111110000000000000000000000000000001111110000000001111100000111000000000000000000000000011111100000000000000000000";
sprite_bombermanlogo0(105) <= "00000000000000000000000000000000001000000000000000000000011111111111111111111111111111111100000000000000000000000000000001111100000000000010000000111000000000000000000000000011111000000000000000000000";
sprite_bombermanlogo0(106) <= "00000000000000000000000000000000000100000000000000000001111111111111111111111111111111111000000000000000000000000000000001111000000000000000000000110000000000000000000000000111111000000000000000000000";
sprite_bombermanlogo0(107) <= "00000000000000000000000000000000000110000000000000000011111111111111111111111111111111110000000000000000000000000000000011110000000000000000000001110000000000000000000000000111110000000000000000000000";
sprite_bombermanlogo0(108) <= "00000000000000000000000000000000000010000000000000001111111111111111111111111111111111100000000000000000000000000000000011110000000000000000000001100000000000000000000000000111110000000000000000000000";
sprite_bombermanlogo0(109) <= "00000000000000000000000000000000000011000000000000111111111111111111111111111111111111000000000000000000000000000000000011100000000000000000000001100000000000000000000000001111110000000000000000000000";
sprite_bombermanlogo0(110) <= "00000000000000000000000000000000000001000000000001111111111111111111111111111111111111000000000001110000001110000000000011100000000011100000000011000000000011000000000000001111100000000000000000000000";
sprite_bombermanlogo0(111) <= "00000000000000000000000000000000000000100000001111111111110001111111111111111111111110000000000011110000011110000000000111000000000111100000000011000000000111100000000000011111100000000000000000000000";
sprite_bombermanlogo0(112) <= "00000000000000000000000000000000000000011001111111111111000001111111111111111111111100000000000111110000111110000000000110000000001111100000000110000000000111110000000000011111000000000000000000000000";
sprite_bombermanlogo0(113) <= "00000000000000000000000000000000000000001111111111111100000000111111111111111111111100000000001111110001111110000000001110000000001111100000000110000000001111111000000000111111000000000000000000000000";
sprite_bombermanlogo0(114) <= "00000000000000000000000000000000000000000111111111111000000000111111111111111111111000000000011111110011111110000000001110000000011111100000001110000000001111111000000001111110000000000000000000000000";
sprite_bombermanlogo0(115) <= "00000000000000000000000000000000000000000011111111000000000000011111111111111111111100000000111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000";
sprite_bombermanlogo0(116) <= "00000000000000000000000000000000000000000001111100000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111110000000000000000000000000";
sprite_bombermanlogo0(117) <= "00000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001111111111100000000000000000000000000";
sprite_bombermanlogo0(118) <= "00000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111111111000000000000000000000000000";
sprite_bombermanlogo0(119) <= "00000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111001111111110000000011111110000000000000000000000000000";
sprite_bombermanlogo0(120) <= "00000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(121) <= "00000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(122) <= "00000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(123) <= "00000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(124) <= "00000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(125) <= "00000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(126) <= "00000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(127) <= "00000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(128) <= "00000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(129) <= "00000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(130) <= "00000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(131) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(132) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(133) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(134) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(135) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(136) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(137) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(138) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(139) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(140) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(141) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(142) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(143) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(144) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(145) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(146) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(147) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(148) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(149) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(150) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(151) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(152) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(153) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(154) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(155) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(156) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(157) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(158) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(159) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(160) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(161) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(162) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(163) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000010000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(164) <= "00000000000000000000000000000000000011111000001000001000000000100000110000000010000000001000000000000000000000000011000000011000011000010000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(165) <= "00000000000000000000000000000000000100000000001000001000000000100000110000000000000000001000000000000000000000000011000000001000011000110000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(166) <= "00000000000000000000000000000000001100000000001000001000000000100000110001110010001110001111100000000000000000000011000000001000111000100011100010111000011110000000000000000000000000000000000000000000";
sprite_bombermanlogo0(167) <= "00000000000000000000000000000000001000000000001000001000000000100000110010000010011001001100110000000000000000000011000000001100101100100000010011001100100011000000000000000000000000000000000000000000";
sprite_bombermanlogo0(168) <= "00000000000000000000000000000000001000000000001111111000000000111111110011000010010001101000110000000000000000000011000000000100101100100000010011001100100011000000000000000000000000000000000000000000";
sprite_bombermanlogo0(169) <= "00000000000000000000000000000000001000000000001000001000000000100000110001110010011111101000110000000000000000000011000000000101100101100011110010001101100011000000000000000000000000000000000000000000";
sprite_bombermanlogo0(170) <= "00000000000000000000000000000000001100000000001000001000000000100000110000010010010000001000110000000000000000000011000000000111000111000110010010001101100011000000000000000000000000000000000000000000";
sprite_bombermanlogo0(171) <= "00000000000000000000000000000000000100000000001000001000000000100000110000010010010000001000110000000000000000000010000000000111000111000100010011001100100011000000000000000000000000000000000000000000";
sprite_bombermanlogo0(172) <= "00000000000000000000000000000000000011111011001000001001100000100000110011110010001111001000110000000000000000001110001000000011000011000111110011001100111111000000000000000000000000000000000000000000";
sprite_bombermanlogo0(173) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000";
sprite_bombermanlogo0(174) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000";
sprite_bombermanlogo0(175) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000";
sprite_bombermanlogo0(176) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(177) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(178) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(179) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(180) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(181) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(182) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(183) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(184) <= "00000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(185) <= "00000000000000000000000000000000011011000001100000111000000000011111001000000000000000000000000000000000000000111000001100000000110001100001100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(186) <= "00000000000000000000000000000000110000000001100000111000000000100000001000000000000000000000000000000000000000111000001100000000110001110001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(187) <= "00000000000000000000000000000000110000000001110000111000000001000000001111100011110011100111110001111100000000111100011100000000010001110001001111000111110001111100000000000000000000000000000000000000";
sprite_bombermanlogo0(188) <= "00000000000000000000000000000000011000000001010001011000000001000000001000100110010011000110010011001100000000110100010100000000010011010011000001100110010011001100000000000000000000000000000000000000";
sprite_bombermanlogo0(189) <= "00000000000000000000000000000000001110000001011001011000000001000000001000100100011010000100011011000100000000110110110100000000011010010010000001100100011011000100000000000000000000000000000000000000";
sprite_bombermanlogo0(190) <= "00000000000000000000000000000000000011000001001011011000000001000000001000100111110010000100011010000100000000110010100100000000011010011010001111100100011010000100000000000000000000000000000000000000";
sprite_bombermanlogo0(191) <= "00000000000000000000000000000000000011000001001110011000000001100000001000100100000010000100011010000100000000110011100100000000001110001110011001100100011010000100000000000000000000000000000000000000";
sprite_bombermanlogo0(192) <= "00000000000000000000000000000000000011011001000110011001000000110000001000100110000010000100011011001100000000110011000100010000001100001100011001100100011011001100000000000000000000000000000000000000";
sprite_bombermanlogo0(193) <= "00000000000000000000000000000000111110011001000100010001000000011111001000100011110010000100010001110100000000010001000100110000000100001100001111100100010001110100000000000000000000000000000000000000";
sprite_bombermanlogo0(194) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000";
sprite_bombermanlogo0(195) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000";
sprite_bombermanlogo0(196) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000";
sprite_bombermanlogo0(197) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(198) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo0(199) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";


sprite_bombermanlogo1(0) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(1) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(2) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(3) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(4) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(5) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(6) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000110000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(7) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100001110001110000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(8) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110001111001110000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(9) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001111111110001100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(10) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(11) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(12) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(13) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(14) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(15) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111001111111111111100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(16) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(17) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111010101111111111110000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(18) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111010001101111111100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(19) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111001001010011111100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(20) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111001001100111111110000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(21) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111001001000011111111000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(22) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111101010001111111111110000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(23) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111011110011111111111111000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(24) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000101111111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(25) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111110011011111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(26) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111011000011111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(27) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000011111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(28) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101111111110000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(29) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100011111000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(30) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100111000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(31) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100011011000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(32) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101011000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(33) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001001001000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(34) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000001000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(35) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001000000000000100000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(36) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100001000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(37) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000000100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(38) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000010000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(39) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(40) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(41) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(42) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(43) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000001000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(44) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000011000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(45) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(46) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000001000000001000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(47) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(48) <= "00000000000000000000000000000000000000000000000000000000000000000000000000001000000100000001000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(49) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(50) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(51) <= "00000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(52) <= "00000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(53) <= "00000000000000000000000000000000000000000000000000000000000000000000001000001000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(54) <= "00000000000000000000000000000000000000000000000000000000000000000000010000010000000100000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(55) <= "00000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(56) <= "00000000000000000000000000000000000000000000000000000000000000000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(57) <= "00000000000000000000000000000000000000000000000000000000000000000000000010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(58) <= "00000000000000000000000000000000000000000000000000000000000000000100000001000000000011000000000000000001101110000111111111111111000000000000000000110000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(59) <= "00000000000000000000000000000000000000000000000000000000000000100000000000001100000001111110000000011111111111100111111111111111110000111111110000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(60) <= "00000000000000000000000000000000000000000000000000000000000010000111111110000000111111111111000000111111111111100111111111111111111000111111111111110001000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(61) <= "00000000000000000000000000000000000000000000000000000000001000111111111111110000111111111111000000111111111111100011111111111111111100011111111111111100000000110000000000000000000000000000000000000000";
sprite_bombermanlogo1(62) <= "00000000000000000000000000000000000000000110000000011000010011111111111111111100001111111111100001111111111111100011111111100011111110011111111111111110000100000011000000000000000000000000000000000000";
sprite_bombermanlogo1(63) <= "00000000000000000000000000000000000001100000000000000011000111111111111111111110000111111111111111111111111111110011111111000001111110011111111111111010010000110000011000000000000000000000000000000000";
sprite_bombermanlogo1(64) <= "00000000000000000000000000000000000100000011111111110000001111111111111111111111000111111111111111111111111111110011111111000001111010010111111111111100010000000011000010000000000000000000000000000000";
sprite_bombermanlogo1(65) <= "00000000000000000000000000000000110000111111111111111100011111111111111111111111100011111111111111111111111111110011111111000001111110010101111110000010010110110000111000100000000000000000000000000000";
sprite_bombermanlogo1(66) <= "00000000000000000000000000000010000111111111111111111110001111111111111111111111110001111111111111111111111111110010101111000001001010010111111000000010010000010000000110010000000000000000000000000000";
sprite_bombermanlogo1(67) <= "00000000000000000000000000001000011111111111111111111111001111111111111111111111111001111111111111111111111111110011111111100010011110011111000111111100100000000000000000001000000000000000000000000000";
sprite_bombermanlogo1(68) <= "00000000000000000000000000100001111111111111111111111111001111111111111111111111111000111111111111111111111111010010111111011101110100100011000000000001000010000111100000000000000000000000000000000000";
sprite_bombermanlogo1(69) <= "00000000000000000000000010000111111111111111111111111111000111111111111111111111111100111111111111111111111111110010111111110001001001001110111000000001001000001000010000010100000000000000000000000000";
sprite_bombermanlogo1(70) <= "00000000000000000000000100011111111111111111111111111111100111111111111111111111111100001111111111111111111111111010111111111100001000011000000100111000100000001000000000010000000000000000000000000000";
sprite_bombermanlogo1(71) <= "00000000000000000000010001111111111111111111111111111111100111111111111111000011111110010011111111111111111111101010001111111100000010001001100000000100100000000000001000000000000000000000000000000000";
sprite_bombermanlogo1(72) <= "00000000000000000000100111111111111111111100001111111111100111111111111110000001111010010111111111111111111111101010001100000000001001000110001000000010000000001000000000000000000000000000000000000000";
sprite_bombermanlogo1(73) <= "00000000000000000000001111111111111111111000000111111111100111111111111010000001011110010101001111111110001111101000000110010000000100100000000000000010000000001000010000010010000000000000000000000000";
sprite_bombermanlogo1(74) <= "00000000000000000001011111111111111111111000000111111111100111111111011010000001011101010000110101100100011011001001001010000000000010010000100000000000100000000011100000010010000000000000000000000000";
sprite_bombermanlogo1(75) <= "00000000000000000000011111111111111111111000000111111111100111111111111010000001111001010011011010000101001011001001000010010011000010010001000111111000100000000000000000100010000000000000000000000000";
sprite_bombermanlogo1(76) <= "00000000000000000000011111111111111111111000000111111110101011011101111111000010110001010100000000000011000010000001000100100001000001010001000000000001000000000000000001000010000000000000000000000000";
sprite_bombermanlogo1(77) <= "00000000000000000000011111111111111111110100001111111110101001111101111101111101011101010000010010011000000000000001000000100000100001000001111110000000000000000000001100000010000000000000000000000000";
sprite_bombermanlogo1(78) <= "00000000000000000001011111111111111111111111011111111110100110001100111100000000111001010000000000100100000000000001000000100000100001010000000000001001000000000000010000000010000000000000000000000000";
sprite_bombermanlogo1(79) <= "00000000000000000000001110011111111111101111111101111110100000110000011001001110110001010111100001000100000000000001000000100000000000010000000000000100000000000000010000000000000000000000000000000000";
sprite_bombermanlogo1(80) <= "00000000000000000000001010111110111111111111001110111110111000001100001001000011010000010000010001000100000000000001000000010001000010010000000000000000100001000000010000000100000000000000000000000000";
sprite_bombermanlogo1(81) <= "00000000000000000000001010010011111111100001100000111111100111000010000000000000000000010000001010000000000000000101000000001100000000100000000000000010100000100000000000001000000000000000000000000000";
sprite_bombermanlogo1(82) <= "00000000000000000000000100011001110000000000000000000000010000010001000000000000100010000000000000000000000000000101000000000000000100100000000000000010100100010000001000100000000000000000000000000000";
sprite_bombermanlogo1(83) <= "00000000000000000000010100001001100000000000000010000000000000000100100000000000000010100100000000000000000000000001000000000000011001000000000000000000100000010000001001000000000000000000000000000000";
sprite_bombermanlogo1(84) <= "00000000000000000000001010000000000000000010000000000000000000100010000000000000000100100100000000000010000000001001000000000011100000000000000000000100001000000000001000000000000000000000000000000000";
sprite_bombermanlogo1(85) <= "00000000000000000000000011000000000000000000000000000000000000000010010000000000000100000100000000000010001111110001111111000000000000001111111111111001001000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(86) <= "00000000000000000000000001000000000000000000000000000000000000000001010000000000000001000100000000000000000000000000000000000000000000000000000000000001010000001000000000100000000000000000000000000000";
sprite_bombermanlogo1(87) <= "00000000000000000000000000000000000000000000000000000000000000000001000000000000001001111100000000000000000000000000000000000000000000000000000000000000000000001000000000100000000000000000000000000000";
sprite_bombermanlogo1(88) <= "00000000000000000000000010100000000000000000000000000111100000000001000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(89) <= "00000000000000000000000000000000000000000000000000001000010000000000001000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000100001000000000000000000000000000000000";
sprite_bombermanlogo1(90) <= "00000000000000000000000001010000000000000000000000010000001000000000001000000001000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000";
sprite_bombermanlogo1(91) <= "00000000000000000000000000001000000000000000000000010000001000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000010000000000000000000000000000";
sprite_bombermanlogo1(92) <= "00000000000000000000000000101000000000000000000000010000001000000001000000001000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000001110000000000000000000000000";
sprite_bombermanlogo1(93) <= "00000000000000000000000000000000000000000000000000010000000000000001000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000";
sprite_bombermanlogo1(94) <= "00000000000000000000000000010100000000000000000000001000010000000001001100000000000000000000000000000001111000000000000011100000000000000000111111100000000000000000100000000000000000000000000000000000";
sprite_bombermanlogo1(95) <= "00000000000000000000000000001010000000000000000000000111100000000000000000000000000000000000000000000111111100000000011111110000000000000011111111100000000111100100001000111111100000000000000000000000";
sprite_bombermanlogo1(96) <= "00000000000000000000000000000010000000000000000000000000000000000010000000000000000000000000000000001111111100000000111111110000000000001111111111110000001111110000000001111111100000000000000000000000";
sprite_bombermanlogo1(97) <= "00000000000000000000000000000101000000000000000000000000000000000100000000000000000000000000000000111111111010000011111111110000000000111111111111110000010111111010001011111111100100000000000000000000";
sprite_bombermanlogo1(98) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101000110111111100000000001111011111111110000011111001000000011111111100000000000000000000000";
sprite_bombermanlogo1(99) <= "00000000000000000000000000000010100000000000000000000000000000001000000000000000000000000000000011111111111111111100111111100000000010100111111111010000101111010101010101111100000001000000000000000000";
sprite_bombermanlogo1(100) <= "00000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000111111111101111110111111111100000000111111000111111110001100111110100100111111001000001000000000000000000";
sprite_bombermanlogo1(101) <= "00000000000000000000000000000001010000000000000000000000000000100000000000000000000000000000001111111111111101111011111111100000011110010000010111100001010111110110001011100001000000000000000000000000";
sprite_bombermanlogo1(102) <= "00000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000010101111111111011011111101111000000110011010000010110100010000110000010001001110010000010000000000000000000";
sprite_bombermanlogo1(103) <= "00000000000000000000000000000000001000000000000000000000000100000000000000000000000000000000111001111111110110001011111011000000100011110000010010100010100010000001110000000010000000000000000000000000";
sprite_bombermanlogo1(104) <= "00000000000000000000000000000000010100000000000000000000010000000000000000000000000000000001010100111001000110000110110010000001001000010000010000000100110010000000000000000000000000000000000000000000";
sprite_bombermanlogo1(105) <= "00000000000000000000000000000000000100000000000000000000100000000000000000000000000000000010001000000000000000000000000010000010001000101101100101000100010000000000000000000100000100000000000000000000";
sprite_bombermanlogo1(106) <= "00000000000000000000000000000000001010000000000000000010000000000000000000000000000000000100001000000000000000001100000010000101000000010110000001001000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(107) <= "00000000000000000000000000000000000000000000000000000100000000000000000000000000000000001000000010000101000000000000000000001000000000001000000010001000000000000000000000001000001000000000000000000000";
sprite_bombermanlogo1(108) <= "00000000000000000000000000000000000101000000000000010000000000000000000000000000000000010000000000000001000000000000000100001000000000000000000010010001000000000000000000001000001000000000000000000000";
sprite_bombermanlogo1(109) <= "00000000000000000000000000000000000000000000000001000000000000000000000000000000000000100000000001110000001110000000000100010000000011100000000010010001000011000000000000010000000000000000000000000000";
sprite_bombermanlogo1(110) <= "00000000000000000000000000000000000010100000000110000000000000000000000000000000000000000000000010001000010001000000000100000000000100000000000100101000000100100000000000010000010000000000000000000000";
sprite_bombermanlogo1(111) <= "00000000000000000000000000000000000001010000010000000000001010000000000000000000000001000000000100001000100001000000001000100000001000010000000100000000001000010000000000000000000000000000000000000000";
sprite_bombermanlogo1(112) <= "00000000000000000000000000000000000000100110000000000000100000000000000000000000000010000000001000001001000001000000001001000000010000010000000001000000001000001000000000100000100000000000000000000000";
sprite_bombermanlogo1(113) <= "00000000000000000000000000000000000000010000000000000010000001000000000000000000000000000000010000001010000001000000000001000000010000010000001001000000000000000000000001000000000000000000000000000000";
sprite_bombermanlogo1(114) <= "00000000000000000000000000000000000000001000000000000100000000000000000000000000000100000000100000001100000001000000010001000000100000010000110001011100110000000110111110000001000000000000000000000000";
sprite_bombermanlogo1(115) <= "00000000000000000000000000000000000000000100000000110000000000100000000000000000000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000";
sprite_bombermanlogo1(116) <= "00000000000000000000000000000000000000000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000";
sprite_bombermanlogo1(117) <= "00000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100010000000000010000000000000000000000000";
sprite_bombermanlogo1(118) <= "00000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000100000000000000000000000000";
sprite_bombermanlogo1(119) <= "00000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000100000001000000000000000000000000000";
sprite_bombermanlogo1(120) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(121) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(122) <= "00000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(123) <= "00000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(124) <= "00000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(125) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(126) <= "00000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(127) <= "00000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(128) <= "00000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(129) <= "00000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(130) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(131) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(132) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(133) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(134) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(135) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(136) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(137) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(138) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(139) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(140) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(141) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(142) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(143) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(144) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(145) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(146) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(147) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(148) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(149) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(150) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(151) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(152) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(153) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(154) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(155) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(156) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(157) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(158) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(159) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(160) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(161) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(162) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(163) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(164) <= "00000000000000000000000000000000000011111000000000000000000000000000110000000010000000000000000000000000000000000011000000011000001000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(165) <= "00000000000000000000000000000000000000000000000000001000000000000000100000000000000000000000000000000000000000000011000000000000001000110000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(166) <= "00000000000000000000000000000000001100000000000000001000000000000000100001110010001110000111100000000000000000000011000000000000110000100011100010111000011110000000000000000000000000000000000000000000";
sprite_bombermanlogo1(167) <= "00000000000000000000000000000000000000000000000000000000000000010000000000000000011000001100110000000000000000000011000000001100000100000000010010001100000001000000000000000000000000000000000000000000";
sprite_bombermanlogo1(168) <= "00000000000000000000000000000000000000000000000101010000000000010101000001000000000001000000110000000000000000000011000000000000101100100000000011001000000011000000000000000000000000000000000000000000";
sprite_bombermanlogo1(169) <= "00000000000000000000000000000000000000000000000000001000000000000000100000010000001110000000110000000000000000000011000000000001100001100011100010001101100011000000000000000000000000000000000000000000";
sprite_bombermanlogo1(170) <= "00000000000000000000000000000000001100000000000000001000000000000000100000000000000000000000110000000000000000000011000000000111000111000010000010001101100011000000000000000000000000000000000000000000";
sprite_bombermanlogo1(171) <= "00000000000000000000000000000000000000000000000000001000000000000000100000000000000000000000110000000000000000000000000000000101000101000000000010001000000001000000000000000000000000000000000000000000";
sprite_bombermanlogo1(172) <= "00000000000000000000000000000000000011111010000000000001000000000000100011110000001111000000110000000000000000001110000000000001000001000101100011001000101101000000000000000000000000000000000000000000";
sprite_bombermanlogo1(173) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000";
sprite_bombermanlogo1(174) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(175) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000";
sprite_bombermanlogo1(176) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(177) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(178) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(179) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(180) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(181) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(182) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(183) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(184) <= "00000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(185) <= "00000000000000000000000000000000011011000000000000101000000000010001001000000000000000000000000000000000000000101000001000000000010000000001100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(186) <= "00000000000000000000000000000000100000000000000000001000000000000000001000000000000000000000000000000000000000100000000000000000110001010000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(187) <= "00000000000000000000000000000000100000000000100000011000000000000000000110100011110001100011110001111000000000111100011000000000000001100000001111000011110001111000000000000000000000000000000000000000";
sprite_bombermanlogo1(188) <= "00000000000000000000000000000000001000000000000001011000000000000000000000000110010001000010000011001000000000110000000100000000000011000011000001100010000011001000000000000000000000000000000000000000";
sprite_bombermanlogo1(189) <= "00000000000000000000000000000000000010000000011000011000000000000000001000000000011000000000001000000000000000110000110100000000011010010010000001000000001001000000000000000000000000000000000000000000";
sprite_bombermanlogo1(190) <= "00000000000000000000000000000000000001000000000011011000000000000000001000000011110000000000001000000000000000110010100100000000011010011000001011100000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(191) <= "00000000000000000000000000000000000011000000001100011000000001100000001000000000000000000000001000000000000000110011100100000000000110000110010001000000001000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(192) <= "00000000000000000000000000000000000011011000000010011001000000010000001000000110000000000000001010001000000000110010000100010000001000000000011001000000001011001000000000000000000000000000000000000000";
sprite_bombermanlogo1(193) <= "00000000000000000000000000000000111110011001000100010000000000011111001000100011110010000100010001110000000000010001000100110000000000001100001111100100010001110000000000000000000000000000000000000000";
sprite_bombermanlogo1(194) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000";
sprite_bombermanlogo1(195) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000";
sprite_bombermanlogo1(196) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000";
sprite_bombermanlogo1(197) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(198) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo1(199) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";


sprite_bombermanlogo2(0) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(1) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(2) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(3) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(4) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000101000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(5) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001010000101000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(6) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000001001001001000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(7) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000001010001000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(8) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001010000110001000100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(9) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000110000000001110010000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(10) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(11) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(12) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(13) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(14) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000111100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(15) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010000000000000010000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(16) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(17) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000100010000000000001000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(18) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000100110000000000010000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(19) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000110110001100000010000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(20) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000110110011000000001000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(21) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000110110111000000000100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(22) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000010101110000000000001000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(23) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001100000000000000100000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(24) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000011000000000111111100000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(25) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000001100000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(26) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(27) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000011100000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(28) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111101000010000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(29) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011100000101111000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(30) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(31) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100100100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(32) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000010000100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(33) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000010100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(34) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000001100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(35) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(36) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000110000000000000001000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(37) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001100000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(38) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(39) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(40) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(41) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(42) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(43) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(44) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(45) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100100000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(46) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(47) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(48) <= "00000000000000000000000000000000000000000000000000000000000000000000000000010000000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(49) <= "00000000000000000000000000000000000000000000000000000000000000000000000000100000001000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(50) <= "00000000000000000000000000000000000000000000000000000000000000000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(51) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000001000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(52) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(53) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(54) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(55) <= "00000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(56) <= "00000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(57) <= "00000000000000000000000000000000000000000000000000000000000000000010000000000001000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(58) <= "00000000000000000000000000000000000000000000000000000000000000011000000000100010000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(59) <= "00000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(60) <= "00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000000000000000000000000000000000000";
sprite_bombermanlogo2(61) <= "00000000000000000000000000000000000000000001111111100000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000";
sprite_bombermanlogo2(62) <= "00000000000000000000000000000000000000011000000000000100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000";
sprite_bombermanlogo2(63) <= "00000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100001111000000000100000000000000000000000000000000";
sprite_bombermanlogo2(64) <= "00000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100001000000000000010001111111100000001000000000000000000000000000000";
sprite_bombermanlogo2(65) <= "00000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001010000001111100001001001111000000010000000000000000000000000000";
sprite_bombermanlogo2(66) <= "00000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000001010000000000110100001000000111111100001111101111111000001000000000000000000000000000";
sprite_bombermanlogo2(67) <= "00000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000011111111111111111000000000000000000000000000000";
sprite_bombermanlogo2(68) <= "00000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000100001000000100010001000011100000000000000111101111000011111100100000000000000000000000000";
sprite_bombermanlogo2(69) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000001110110000110001000000000000110111110000001111100000000000000000000000000000";
sprite_bombermanlogo2(70) <= "00000000000000000000001000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000001000000000011110001100111111011000000011111110000001111100010000000000000000000000000";
sprite_bombermanlogo2(71) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000010001110000000011110001110110011111111000011111110000000111110010000000000000000000000000";
sprite_bombermanlogo2(72) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000100001000000000000000000000010001110011111111110000111001110111111100011111110000001111110010000000000000000000000000";
sprite_bombermanlogo2(73) <= "00000000000000000001000000000000000000000000000000000000000000000000000100000000100000001010110000000001110000010001111001101111111000011111111111111100011111110000001111100000000000000000000000000000";
sprite_bombermanlogo2(74) <= "00000000000000000000000000000000000000000000000000000000000000000000100100000000100010001111001010011011100100110000110101111111111100001111011111111100011111111100011111100000000000000000000000000000";
sprite_bombermanlogo2(75) <= "00000000000000000010000000000000000000000000000000000000000000000000000100000000000110001100100101111010110100110000111101100000111100001110000000000000011111111111111111000001000000000000000000000000";
sprite_bombermanlogo2(76) <= "00000000000000000010000000000000000000000000000000000001000100100010000000000001001110001011111111111100111101111000111011000000111110001110000000000000111111111111111110000001000000000000000000000000";
sprite_bombermanlogo2(77) <= "00000000000000000000000000000000000000001000000000000001000110000010000010000010100010001111101101100111111111111000111111000000011110001110000000000001111111111111110000000000000000000000000000000000";
sprite_bombermanlogo2(78) <= "00000000000000000000000000000000000000000000000000000001000001110011000011111111000110001111111111000011111111111000111111000000011110001111111111110000111111111111100000000000000000000000000000000000";
sprite_bombermanlogo2(79) <= "00000000000000000001000001100000000000010000000010000001000000001111100110110001001110001000011110000011111111111000111111000000111110001111111111111000111111111111100000000010000000000000000000000000";
sprite_bombermanlogo2(80) <= "00000000000000000000000101000001000000000000110001000001000000000011110110111100101110001000001110000011111111111000111111100000111100001111111111111100011110111111100000000000000000000000000000000000";
sprite_bombermanlogo2(81) <= "00000000000000000000100101101100000000011110011111000000011000000001111111111111111110001000000100000011111111111000111111110011111100011111111111111100011100011111110000000100000000000000000000000000";
sprite_bombermanlogo2(82) <= "00000000000000000000000011100110001111111111111111111111101111100000111111111111011100011000000000000011111111111000111111111111111000011111111111111100011000001111110000011000000000000000000000000000";
sprite_bombermanlogo2(83) <= "00000000000000000000000011110110011111111111111101111111111111111000011111111111111100011000000000000011111111111000111111111111100000111111111111111100011000001111110000100000000000000000000000000000";
sprite_bombermanlogo2(84) <= "00000000000000000000000001111111111111111101111111111111111111011100011111111111111000011000000000000001111111110000111111111100000001111111111111111000110000001111110000100000000000000000000000000000";
sprite_bombermanlogo2(85) <= "00000000000000000000001000111111111111111111111111111111111111111100001111111111111000111000000000000001110000000000000000000000000000000000000000000000110000001111111000100000000000000000000000000000";
sprite_bombermanlogo2(86) <= "00000000000000000000000000111111111111111111111111111111111111111110001111111111111000111000000000000000000000000000000000000000000000000000000000000000100000000111111000000000000000000000000000000000";
sprite_bombermanlogo2(87) <= "00000000000000000000000100111111111111111111111111111111111111111110001111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000000000000000000000000000";
sprite_bombermanlogo2(88) <= "00000000000000000000000000011111111111111111111111111000011111111110001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000111111000010000000000000000000000000000";
sprite_bombermanlogo2(89) <= "00000000000000000000000010011111111111111111111111110000001111111111000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000010000000000000000000000000000";
sprite_bombermanlogo2(90) <= "00000000000000000000000000001111111111111111111111100000000111111111000111111110000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000010000000000000000000000000000";
sprite_bombermanlogo2(91) <= "00000000000000000000000001000111111111111111111111100000000111111111000111111100000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000";
sprite_bombermanlogo2(92) <= "00000000000000000000000000000111111111111111111111100000000111111110001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000001110000000000000000000000";
sprite_bombermanlogo2(93) <= "00000000000000000000000000100111111111111111111111100000001111111110001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001000000000000000000000000000000000000";
sprite_bombermanlogo2(94) <= "00000000000000000000000000000011111111111111111111110000001111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000100000000000000000000";
sprite_bombermanlogo2(95) <= "00000000000000000000000000000001111111111111111111111000011111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000100000000000000000000";
sprite_bombermanlogo2(96) <= "00000000000000000000000000001001111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001000000000000100000000000000000000";
sprite_bombermanlogo2(97) <= "00000000000000000000000000000000111111111111111111111111111111111000000000000000000000000000000000000000000100000000000000000000000000000000000000000000001000000000000000000000000010000000000000000000";
sprite_bombermanlogo2(98) <= "00000000000000000000000000000100111111111111111111111111111111111000000000000000000000000000000000000000000010000001000000000000000000000100000000000000000000110001010000000000000001000000000000000000";
sprite_bombermanlogo2(99) <= "00000000000000000000000000000000011111111111111111111111111111110000000000000000000000000000000000000000000000000011000000000000000001011000000000100000010000101000000010000011000000000000000000000000";
sprite_bombermanlogo2(100) <= "00000000000000000000000000000010011111111111111111111111111111100000000000000000000000000000000000000000010000001000000000000000000000000000000000000000011000001000000000000110000000000000000000000000";
sprite_bombermanlogo2(101) <= "00000000000000000000000000000000001111111111111111111111111111000000000000000000000000000000000000000000000010000100000000000000000001100000001000000000101000001000000100011110000001000000000000000000";
sprite_bombermanlogo2(102) <= "00000000000000000000000000000001001111111111111111111111111100000000000000000000000000000000001010000000000100100000010000000000001100100000001001000001111001111100000110001100000001000000000000000000";
sprite_bombermanlogo2(103) <= "00000000000000000000000000000000100111111111111111111111111000000000000000000000000000000000000110000000001001110100000100000000011100000000001101000001011101111110001111111100000010000000000000000000";
sprite_bombermanlogo2(104) <= "00000000000000000000000000000000000011111111111111111111100000000000000000000000000000000000101011000110111001111001001100000000110111100000001111000011001101111111111111111100000010000000000000000000";
sprite_bombermanlogo2(105) <= "00000000000000000000000000000000010011111111111111111111000000000000000000000000000000000001110111111111111111111111111100000001110111010000011010000011101111111111111111111000000000000000000000000000";
sprite_bombermanlogo2(106) <= "00000000000000000000000000000000000001111111111111111100000000000000000000000000000000000011110111111111111111110011111100000010111111101001111110000111111111111111111111111000000100000000000000000000";
sprite_bombermanlogo2(107) <= "00000000000000000000000000000000001001111111111111111000000000000000000000000000000000000111111101111010111111111111111100000111111111110111111100000111111111111111111111110000000000000000000000000000";
sprite_bombermanlogo2(108) <= "00000000000000000000000000000000000000111111111111100000000000000000000000000000000000001111111111111110111111111111111000000111111111111111111100001110111111111111111111110000000000000000000000000000";
sprite_bombermanlogo2(109) <= "00000000000000000000000000000000000100111111111110000000000000000000000000000000000000011111111110001111110001111111111000001111111100011111111100001110111100111111111111100000001000000000000000000000";
sprite_bombermanlogo2(110) <= "00000000000000000000000000000000000000011111111000000000000000000000000000000000000000111111111100000111100000111111111000011111111000011111111000010111111000011111111111100000000000000000000000000000";
sprite_bombermanlogo2(111) <= "00000000000000000000000000000000000000001111100000000000000100000000000000000000000000111111111000000111000000111111110000011111110000001111111000111111110000001111111111100000010000000000000000000000";
sprite_bombermanlogo2(112) <= "00000000000000000000000000000000000001000000000000000000010010000000000000000000000001111111110000000110000000111111110000111111100000001111111000111111110000000111111111000000000000000000000000000000";
sprite_bombermanlogo2(113) <= "00000000000000000000000000000000000000000000000000000001000000000000000000000000000011111111100000000100000000111111110000111111100000001111110000111111110000000111111110000000100000000000000000000000";
sprite_bombermanlogo2(114) <= "00000000000000000000000000000000000000000000000000000010000001000000000000000000000011111111000000000000000000111111100000111111000000001111000000100011000000000001000000000000000000000000000000000000";
sprite_bombermanlogo2(115) <= "00000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(116) <= "00000000000000000000000000000000000000000100000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000001000000000000000000000000";
sprite_bombermanlogo2(117) <= "00000000000000000000000000000000000000000001001100000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(118) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000010000000000000000000000000";
sprite_bombermanlogo2(119) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000001000000000000000000000000000000000000000000";
sprite_bombermanlogo2(120) <= "00000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000001001111111110000000001111110000000000000000000000000000";
sprite_bombermanlogo2(121) <= "00000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(122) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(123) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(124) <= "00000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(125) <= "00000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(126) <= "00000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(127) <= "00000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(128) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(129) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(130) <= "00000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(131) <= "00000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(132) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(133) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(134) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(135) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(136) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(137) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(138) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(139) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(140) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(141) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(142) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(143) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(144) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(145) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(146) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(147) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(148) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(149) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(150) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(151) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(152) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(153) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(154) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(155) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(156) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(157) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(158) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(159) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(160) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(161) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(162) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(163) <= "00000000000000000000000000000000000001110000000000000000000000000000000000000101000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(164) <= "00000000000000000000000000000000000100000000010100010100000000010000000000000101000000000100000000000000000000000000000000000000100000100000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(165) <= "00000000000000000000000000000000001010001000010100010100000000010000010000000000000000000100000000000000000000000000000000010100100000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(166) <= "00000000000000000000000000000000000000000000010100000100000000010000010010000101000001000000000000000000000000000000000000010100000100010100010001000000100001000000000000000000000000000000000000000000";
sprite_bombermanlogo2(167) <= "00000000000000000000000000000000010100000000010111110100000001001111010100010101000010100000000000000000000000000000000000000001010001010100100000000001010100000000000000000000000000000000000000000000";
sprite_bombermanlogo2(168) <= "00000000000000000000000000000000010100000000010010100100000000001010010100100101101000100100000000000000000000000000000000001001000001000000101000000001000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(169) <= "00000000000000000000000000000000010100000000010100000100000001010000010010000101100000100100000000000000000000000000000000001010001010000100001001000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(170) <= "00000000000000000000000000000000000000000000010100010100000000010000010000101101101000000100000000000000000000000000000000000000100000100000101001000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(171) <= "00000000000000000000000000000000001010001011010100010101100000010000010000101101001000000100000000000000000000000001001000000000000000001010101001000001010100000000000000000000000000000000000000000000";
sprite_bombermanlogo2(172) <= "00000000000000000000000000000000000100000000010100010100000000010000010100000101010000000100000000000000000000010000010100000100000100000000001000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(173) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000001000000000000000000000000000000000000000000";
sprite_bombermanlogo2(174) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000";
sprite_bombermanlogo2(175) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000010000000000000000000000000000000000000000000";
sprite_bombermanlogo2(176) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(177) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(178) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(179) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(180) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(181) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(182) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(183) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(184) <= "00000000000000000000000000000000001111000001100000011000000000001111010000000000000000000000000000000000000000111000001100000000100000100001100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(185) <= "00000000000000000000000000000000100100000010010000000000000000101110010000000000000000000000000000000000000000000000000010000001000001010000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(186) <= "00000000000000000000000000000000000000000010010000000000000001010000010000000000000000000000000000000000000000000100010010000000000000000010100000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(187) <= "00000000000000000000000000000000000000000010000001000000000010100000010000000000000000011000000000000010000000000000000010000000100010000010000000101000000000000010000000000000000000000000000000000000";
sprite_bombermanlogo2(188) <= "00000000000000000000000000000000100100000010101000100000000010100000010101010000001000001000001000000010000000001010101010000000101000101000000000001000001000000010000000000000000000000000000000000000";
sprite_bombermanlogo2(189) <= "00000000000000000000000000000000010000000010100010000000000010100000010000010010000001001010000001001010000000000010000010000000000001001001000010001010000000001010000000000000000000000000000000000000";
sprite_bombermanlogo2(190) <= "00000000000000000000000000000000000100000010110100000000000010100000010000011000001001001000000001001010000000000101010010000000000101000101000000001010001001001010000000000000000000000000000000000000";
sprite_bombermanlogo2(191) <= "00000000000000000000000000000000000000000010100001000000000000000000010000010010000001001010000001001010000000000000000010000000010000010000000000001010000001001010000000000000000000000000000000000000";
sprite_bombermanlogo2(192) <= "00000000000000000000000000000000100000000010101000000010000001000001010000010000010001001010000000000010000000000000100010100000000010000010000000001010000000000010000000000000000000000000000000000000";
sprite_bombermanlogo2(193) <= "00000000000000000000000000000000000000000010000010001010100000000000010000010000000001001000001000001010000000100010000010000000001010000010000000001000001000001010000000000000000000000000000000000000";
sprite_bombermanlogo2(194) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000";
sprite_bombermanlogo2(195) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000";
sprite_bombermanlogo2(196) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(197) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(198) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
sprite_bombermanlogo2(199) <= "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";


sprite_bombermanlogo3(0) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(1) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(2) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(3) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(4) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111000111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(5) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111000111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(6) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111110000110000111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(7) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001110000100000111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(8) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000100000000000111011111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(9) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000001111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(10) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000011111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(11) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000011111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(12) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(13) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(14) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000011111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(15) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000001111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(16) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000011111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(17) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(18) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000001111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(19) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000001111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(20) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(21) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000011111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(22) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(23) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000011111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(24) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000011111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(25) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(26) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(27) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(28) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(29) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000010000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(30) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000011111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(31) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000011111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(32) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000100011111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(33) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000100011111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(34) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000110011111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(35) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000001111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(36) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(37) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000011111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(38) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000010000000000000000000001111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(39) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(40) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(41) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(42) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(43) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(44) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(45) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000011000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(46) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111100000000000111110000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(47) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111000000000011111000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(48) <= "11111111111111111111111111111111111111111111111111111111111111111111111111100000000001111100000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(49) <= "11111111111111111111111111111111111111111111111111111111111111111111111111000000000111111000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(50) <= "11111111111111111111111111111111111111111111111111111111111111111111111110000000001111110000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(51) <= "11111111111111111111111111111111111111111111111111111111111111111111111100000000111111000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(52) <= "11111111111111111111111111111111111111111111111111111111111111111111111000000001111110000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(53) <= "11111111111111111111111111111111111111111111111111111111111111111111110000000111111100000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(54) <= "11111111111111111111111111111111111111111111111111111111111111111111100000001111111000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(55) <= "11111111111111111111111111111111111111111111111111111111111111111111000000011111110000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(56) <= "11111111111111111111111111111111111111111111111111111111111111111110000000111111100000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(57) <= "11111111111111111111111111111111111111111111111111111111111111111100000001111110000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(58) <= "11111111111111111111111111111111111111111111111111111111111111100000000000011100000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(59) <= "11111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(60) <= "11111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111";
sprite_bombermanlogo3(61) <= "11111111111111111111111111111111111111111110000000011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111";
sprite_bombermanlogo3(62) <= "11111111111111111111111111111111111111100000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111";
sprite_bombermanlogo3(63) <= "11111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111";
sprite_bombermanlogo3(64) <= "11111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111";
sprite_bombermanlogo3(65) <= "11111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111";
sprite_bombermanlogo3(66) <= "11111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111";
sprite_bombermanlogo3(67) <= "11111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111";
sprite_bombermanlogo3(68) <= "11111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111";
sprite_bombermanlogo3(69) <= "11111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111";
sprite_bombermanlogo3(70) <= "11111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(71) <= "11111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(72) <= "11111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(73) <= "11111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(74) <= "11111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(75) <= "11111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111";
sprite_bombermanlogo3(76) <= "11111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111";
sprite_bombermanlogo3(77) <= "11111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(78) <= "11111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(79) <= "11111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111";
sprite_bombermanlogo3(80) <= "11111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111";
sprite_bombermanlogo3(81) <= "11111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111";
sprite_bombermanlogo3(82) <= "11111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111";
sprite_bombermanlogo3(83) <= "11111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111";
sprite_bombermanlogo3(84) <= "11111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111";
sprite_bombermanlogo3(85) <= "11111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111";
sprite_bombermanlogo3(86) <= "11111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111";
sprite_bombermanlogo3(87) <= "11111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111";
sprite_bombermanlogo3(88) <= "11111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111";
sprite_bombermanlogo3(89) <= "11111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111";
sprite_bombermanlogo3(90) <= "11111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111";
sprite_bombermanlogo3(91) <= "11111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000001111111111111111111111111111";
sprite_bombermanlogo3(92) <= "11111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000001111111111111111111111";
sprite_bombermanlogo3(93) <= "11111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000111111111111111111111";
sprite_bombermanlogo3(94) <= "11111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000011111111111111111111";
sprite_bombermanlogo3(95) <= "11111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000011111111111111111111";
sprite_bombermanlogo3(96) <= "11111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000011111111111111111111";
sprite_bombermanlogo3(97) <= "11111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000001111111111111111111";
sprite_bombermanlogo3(98) <= "11111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000111111111111111111";
sprite_bombermanlogo3(99) <= "11111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000111111111111111111";
sprite_bombermanlogo3(100) <= "11111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111";
sprite_bombermanlogo3(101) <= "11111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111";
sprite_bombermanlogo3(102) <= "11111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111";
sprite_bombermanlogo3(103) <= "11111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111";
sprite_bombermanlogo3(104) <= "11111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111";
sprite_bombermanlogo3(105) <= "11111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111";
sprite_bombermanlogo3(106) <= "11111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111";
sprite_bombermanlogo3(107) <= "11111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111";
sprite_bombermanlogo3(108) <= "11111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111";
sprite_bombermanlogo3(109) <= "11111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111";
sprite_bombermanlogo3(110) <= "11111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111";
sprite_bombermanlogo3(111) <= "11111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111";
sprite_bombermanlogo3(112) <= "11111111111111111111111111111111111110000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111";
sprite_bombermanlogo3(113) <= "11111111111111111111111111111111111111100000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111";
sprite_bombermanlogo3(114) <= "11111111111111111111111111111111111111110000000000000001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111";
sprite_bombermanlogo3(115) <= "11111111111111111111111111111111111111111000000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111";
sprite_bombermanlogo3(116) <= "11111111111111111111111111111111111111111000000000011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111";
sprite_bombermanlogo3(117) <= "11111111111111111111111111111111111111111110000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000001111111111111111111111111";
sprite_bombermanlogo3(118) <= "11111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000001111111111111111111111111";
sprite_bombermanlogo3(119) <= "11111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000111111111111111111111111111";
sprite_bombermanlogo3(120) <= "11111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000001111111110000001111111111111111111111111111";
sprite_bombermanlogo3(121) <= "11111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(122) <= "11111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(123) <= "11111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(124) <= "11111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(125) <= "11111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(126) <= "11111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(127) <= "11111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(128) <= "11111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(129) <= "11111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(130) <= "11111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(131) <= "11111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(132) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(133) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(134) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(135) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(136) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(137) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(138) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(139) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(140) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(141) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(142) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(143) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(144) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(145) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(146) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(147) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(148) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(149) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(150) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(151) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(152) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(153) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(154) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(155) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(156) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(157) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(158) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(159) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(160) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(161) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(162) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(163) <= "11111111111111111111111111111111111110001111111111111111111111111111111111111000111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(164) <= "11111111111111111111111111111111111000000111100011100011111111001111001111111000111111110011111111111111111111111100111111100111000111001111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(165) <= "11111111111111111111111111111111110001110111100011100011111111001111001111111111111111110011111111111111111111111100111111100011000111001111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(166) <= "11111111111111111111111111111111110011111111100011110011111111001111001100001000110000110000011111111111111111111100111111100011000011001000001100000111000000111111111111111111111111111111111111111111";
sprite_bombermanlogo3(167) <= "11111111111111111111111111111111100011111111100000000011111110000000001001101000100100010011001111111111111111111100111111110010000010001011001100110010001000111111111111111111111111111111111111111111";
sprite_bombermanlogo3(168) <= "11111111111111111111111111111111100011111111100000000011111111000000001000011000000110010011001111111111111111111100111111110010010010011111000100110010011100111111111111111111111111111111111111111111";
sprite_bombermanlogo3(169) <= "11111111111111111111111111111111100011111111100011110011111110001111001100001000000000010011001111111111111111111100111111110000010000011000000100110010011100111111111111111111111111111111111111111111";
sprite_bombermanlogo3(170) <= "11111111111111111111111111111111110011111111100011100011111111001111001111000000000111110011001111111111111111111100111111111000011000011001000100110010011100111111111111111111111111111111111111111111";
sprite_bombermanlogo3(171) <= "11111111111111111111111111111111110001110100100011100010011111001111001111000000100111110011001111111111111111111100110111111000111000110001000100110010001000111111111111111111111111111111111111111111";
sprite_bombermanlogo3(172) <= "11111111111111111111111111111111111000000100100011100010011111001111001000001000100000110011001111111111111111100001100011111000111000111000000100110011000000111111111111111111111111111111111111111111";
sprite_bombermanlogo3(173) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111100111111111111111111111111111111111111111111";
sprite_bombermanlogo3(174) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111";
sprite_bombermanlogo3(175) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111111111111111111111111111111111111";
sprite_bombermanlogo3(176) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(177) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(178) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(179) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(180) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(181) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(182) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(183) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(184) <= "11111111111111111111111111111111110000111110011111100111111111110000100111111111111111111111111111111111111111000111110011111111011111011110011111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(185) <= "11111111111111111111111111111111000000111100001111000111111111000000100111111111111111111111111111111111111111000111110001111110001110001110011111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(186) <= "11111111111111111111111111111111001111111100001111000111111110001111100111111111111111111111111111111111111111000011100001111111001110001100011111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(187) <= "11111111111111111111111111111111001111111100001110000111111100011111100000011100001100000000001110000001111111000011100001111111001100001100110000010000001110000001111111111111111111111111111111111111";
sprite_bombermanlogo3(188) <= "11111111111111111111111111111111000011111100000110000111111100011111100010001001100100110001100100110001111111000001000001111111000100000100111110010001100100110001111111111111111111111111111111111111";
sprite_bombermanlogo3(189) <= "11111111111111111111111111111111100001111100000100100111111100011111100111001001100100110001100100110001111111001001001001111111100100100100111100010001100100110001111111111111111111111111111111111111";
sprite_bombermanlogo3(190) <= "11111111111111111111111111111111111000111100000000100111111100011111100111000000000100110011100100110001111111001000001001111111100000100000110000010001100100110001111111111111111111111111111111111111";
sprite_bombermanlogo3(191) <= "11111111111111111111111111111111111100111100010000100111111110011111100111001001111100110001100100110001111111001100011001111111100001100001100110010001100100110001111111111111111111111111111111111111";
sprite_bombermanlogo3(192) <= "11111111111111111111111111111111011100100100010001100100111110001110100111001001101100110001100100110001111111001100011001001111110001110001100110010001100100110001111111111111111111111111111111111111";
sprite_bombermanlogo3(193) <= "11111111111111111111111111111111000001100100111001100100011111100000100111001100001100110011100110000001111111001100111001001111110001110001110000010011100110000001111111111111111111111111111111111111";
sprite_bombermanlogo3(194) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111";
sprite_bombermanlogo3(195) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110011111111111111111111111111111111111111111111111111111101110011111111111111111111111111111111111111";
sprite_bombermanlogo3(196) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111111111111111111111111111111111111111111111111111100000111111111111111111111111111111111111111";
sprite_bombermanlogo3(197) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(198) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
sprite_bombermanlogo3(199) <= "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";




--bomberman0 outside--
sprite_bomberman0(0)  <= "00000000000000000000000000000000";
sprite_bomberman0(1)  <= "00000000000011111111100000000000";
sprite_bomberman0(2)  <= "00000000000100000000010000000000";
sprite_bomberman0(3)  <= "00000000011000000000001100000000";
sprite_bomberman0(4)  <= "00000000100000000000000010000000";
sprite_bomberman0(5)  <= "00000001000000000000000001000000";
sprite_bomberman0(6)  <= "00000010000000000000000000100000";
sprite_bomberman0(7)  <= "00000010000000000000000000100000";
sprite_bomberman0(8)  <= "00000010000000000000000000100000";
sprite_bomberman0(9)  <= "00000010000011000001100000100000";
sprite_bomberman0(10) <= "00000010000011000001100000100000";
sprite_bomberman0(11) <= "00000010000011000001100000100000";
sprite_bomberman0(12) <= "00000010000011000001100000100000";
sprite_bomberman0(13) <= "00000001000000000000000001000000";
sprite_bomberman0(14) <= "00000000100000000000000010000000";
sprite_bomberman0(15) <= "00000000010000000000000100000000";
sprite_bomberman0(16) <= "00000000010000000000000100000000";
sprite_bomberman0(17) <= "00000000100000000000000010000000";
sprite_bomberman0(18) <= "00000000100000000000000001000000";
sprite_bomberman0(19) <= "00000001000111100011110000100000";
sprite_bomberman0(20) <= "00000010000111100011110000100000";
sprite_bomberman0(21) <= "00000010000000000000000000100000";
sprite_bomberman0(22) <= "00000001000000000000000001000000";
sprite_bomberman0(23) <= "00000000111000000000001110000000";
sprite_bomberman0(24) <= "00000000000100000000010000000000";
sprite_bomberman0(25) <= "00000000111100000000011110000000";
sprite_bomberman0(26) <= "00000001111000011100001111000000";
sprite_bomberman0(27) <= "00000011100000011100000011100000";
sprite_bomberman0(28) <= "00000011100000011100000011100000";
sprite_bomberman0(29) <= "00000001111111111111111111000000";
sprite_bomberman0(30) <= "00000000011111111111111100000000";
sprite_bomberman0(31) <= "00000000000000000000000000000000";

--bomberman1 shoes and gloves--
sprite_bomberman1(0)  <= "00000000000000000000000000000000";
sprite_bomberman1(1)  <= "00000000000000000000000000000000";
sprite_bomberman1(2)  <= "00000000000000000000000000000000";
sprite_bomberman1(3)  <= "00000000000000000000000000000000";
sprite_bomberman1(4)  <= "00000000000000000000000000000000";
sprite_bomberman1(5)  <= "00000000000000000000000000000000";
sprite_bomberman1(6)  <= "00000000000000000000000000000000";
sprite_bomberman1(7)  <= "00000000000000000000000000000000";
sprite_bomberman1(8)  <= "00000000001111111111111000000000";
sprite_bomberman1(9)  <= "00000000010000000000000100000000";
sprite_bomberman1(10) <= "00000000010000000000000100000000";
sprite_bomberman1(11) <= "00000000010000000000000100000000";
sprite_bomberman1(12) <= "00000000010000000000000100000000";
sprite_bomberman1(13) <= "00000000001111111111111000000000";
sprite_bomberman1(14) <= "00000000000000000000000000000000";
sprite_bomberman1(15) <= "00000000000000000000000000000000";
sprite_bomberman1(16) <= "00000000000000000000000000000000";
sprite_bomberman1(17) <= "00000000000000000000000000000000";
sprite_bomberman1(18) <= "00000000000000000000000000000000";
sprite_bomberman1(19) <= "00000000000000011100000000000000";
sprite_bomberman1(20) <= "00000001111100011100011111000000";
sprite_bomberman1(21) <= "00000001111100000000011111000000";
sprite_bomberman1(22) <= "00000000111100000000011110000000";
sprite_bomberman1(23) <= "00000000000000000000000000000000";
sprite_bomberman1(24) <= "00000000000000000000000000000000";
sprite_bomberman1(25) <= "00000000000000000000000000000000";
sprite_bomberman1(26) <= "00000000000111100011110000000000";
sprite_bomberman1(27) <= "00000000011111100011111100000000";
sprite_bomberman1(28) <= "00000000011111100011111100000000";
sprite_bomberman1(29) <= "00000000000000000000000000000000";
sprite_bomberman1(30) <= "00000000000000000000000000000000";
sprite_bomberman1(31) <= "00000000000000000000000000000000";

--bomberman2 skin--
sprite_bomberman2(0)  <= "00000000000000000000000000000000";
sprite_bomberman2(1)  <= "00000000000000000000000000000000";
sprite_bomberman2(2)  <= "00000000000000000000000000000000";
sprite_bomberman2(3)  <= "00000000000000000000000000000000";
sprite_bomberman2(4)  <= "00000000000000000000000000000000";
sprite_bomberman2(5)  <= "00000000000000000000000000000000";
sprite_bomberman2(6)  <= "00000000000000000000000000000000";
sprite_bomberman2(7)  <= "00000000000000000000000000000000";
sprite_bomberman2(8)  <= "00000000000000000000000000000000";
sprite_bomberman2(9)  <= "00000000001100111110011000000000";
sprite_bomberman2(10) <= "00000000001100111110011000000000";
sprite_bomberman2(11) <= "00000000001100111110011000000000";
sprite_bomberman2(12) <= "00000000001100111110011000000000";
sprite_bomberman2(13) <= "00000000000000000000000000000000";
sprite_bomberman2(14) <= "00000000000000000000000000000000";
sprite_bomberman2(15) <= "00000000000000000000000000000000";
sprite_bomberman2(16) <= "00000000001100000000011000000000";
sprite_bomberman2(17) <= "00000000011100000000011100000000";
sprite_bomberman2(18) <= "00000000111000000000001110000000";
sprite_bomberman2(19) <= "00000000110000000000000110000000";
sprite_bomberman2(20) <= "00000000000000000000000000000000";
sprite_bomberman2(21) <= "00000000000000000000000000000000";
sprite_bomberman2(22) <= "00000000000000000000000000000000";
sprite_bomberman2(23) <= "00000000000011100011100000000000";
sprite_bomberman2(24) <= "00000000000011100011100000000000";
sprite_bomberman2(25) <= "00000000000011100011100000000000";
sprite_bomberman2(26) <= "00000000000000000000000000000000";
sprite_bomberman2(27) <= "00000000000000000000000000000000";
sprite_bomberman2(28) <= "00000000000000000000000000000000";
sprite_bomberman2(29) <= "00000000000000000000000000000000";
sprite_bomberman2(30) <= "00000000000000000000000000000000";
sprite_bomberman2(31) <= "00000000000000000000000000000000";

--bomberman3 helmet--
sprite_bomberman3(0)  <= "00000000000000000000000000000000";
sprite_bomberman3(1)  <= "00000000000000000000000000000000";
sprite_bomberman3(2)  <= "00000000000011111111100000000000";
sprite_bomberman3(3)  <= "00000000000111111111110000000000";
sprite_bomberman3(4)  <= "00000000011111111111111100000000";
sprite_bomberman3(5)  <= "00000000111111111111111110000000";
sprite_bomberman3(6)  <= "00000001111111111111111111000000";
sprite_bomberman3(7)  <= "00000001111111111111111111000000";
sprite_bomberman3(8)  <= "00000001110000000000000111000000";
sprite_bomberman3(9)  <= "00000001100100000000010011000000";
sprite_bomberman3(10) <= "00000001100100000000010011000000";
sprite_bomberman3(11) <= "00000001100100000000010011000000";
sprite_bomberman3(12) <= "00000001100100000000010011000000";
sprite_bomberman3(13) <= "00000000110000000000000110000000";
sprite_bomberman3(14) <= "00000000011111111111111100000000";
sprite_bomberman3(15) <= "00000000001111111111111000000000";
sprite_bomberman3(16) <= "00000000000000000000000000000000";
sprite_bomberman3(17) <= "00000000000000000000000000000000";
sprite_bomberman3(18) <= "00000000000000000000000000000000";
sprite_bomberman3(19) <= "00000000000000000000000000000000";
sprite_bomberman3(20) <= "00000000000000000000000000000000";
sprite_bomberman3(21) <= "00000000000000000000000000000000";
sprite_bomberman3(22) <= "00000000000000000000000000000000";
sprite_bomberman3(23) <= "00000000000000000000000000000000";
sprite_bomberman3(24) <= "00000000000000000000000000000000";
sprite_bomberman3(25) <= "00000000000000000000000000000000";
sprite_bomberman3(26) <= "00000000000000000000000000000000";
sprite_bomberman3(27) <= "00000000000000000000000000000000";
sprite_bomberman3(28) <= "00000000000000000000000000000000";
sprite_bomberman3(29) <= "00000000000000000000000000000000";
sprite_bomberman3(30) <= "00000000000000000000000000000000";
sprite_bomberman3(31) <= "00000000000000000000000000000000";

--bomberman1 body--
sprite_bomberman4(0)  <= "00000000000000000000000000000000";
sprite_bomberman4(1)  <= "00000000000000000000000000000000";
sprite_bomberman4(2)  <= "00000000000000000000000000000000";
sprite_bomberman4(3)  <= "00000000000000000000000000000000";
sprite_bomberman4(4)  <= "00000000000000000000000000000000";
sprite_bomberman4(5)  <= "00000000000000000000000000000000";
sprite_bomberman4(6)  <= "00000000000000000000000000000000";
sprite_bomberman4(7)  <= "00000000000000000000000000000000";
sprite_bomberman4(8)  <= "00000000000000000000000000000000";
sprite_bomberman4(9)  <= "00000000000000000000000000000000";
sprite_bomberman4(10) <= "00000000000000000000000000000000";
sprite_bomberman4(11) <= "00000000000000000000000000000000";
sprite_bomberman4(12) <= "00000000000000000000000000000000";
sprite_bomberman4(13) <= "00000000000000000000000000000000";
sprite_bomberman4(14) <= "00000000000000000000000000000000";
sprite_bomberman4(15) <= "00000000000000000000000000000000";
sprite_bomberman4(16) <= "00000000000011111111100000000000";
sprite_bomberman4(17) <= "00000000001111111111111000000000";
sprite_bomberman4(18) <= "00000000001111111111111000000000";
sprite_bomberman4(19) <= "00000000001111111111111000000000";
sprite_bomberman4(20) <= "00000000001111111111111000000000";
sprite_bomberman4(21) <= "00000000000111111111110000000000";
sprite_bomberman4(22) <= "00000000000001111111000000000000";
sprite_bomberman4(23) <= "00000000000001111111000000000000";
sprite_bomberman4(24) <= "00000000000000000000000000000000";
sprite_bomberman4(25) <= "00000000000000000000000000000000";
sprite_bomberman4(26) <= "00000000000000000000000000000000";
sprite_bomberman4(27) <= "00000000000000000000000000000000";
sprite_bomberman4(28) <= "00000000000000000000000000000000";
sprite_bomberman4(29) <= "00000000000000000000000000000000";
sprite_bomberman4(30) <= "00000000000000000000000000000000";
sprite_bomberman4(31) <= "00000000000000000000000000000000";


--bombermanB0 outside-- 
sprite_bombermanB0(0)  <= "00000000000000000000000000000000";
sprite_bombermanB0(1)  <= "00000000000011111111100000000000";
sprite_bombermanB0(2)  <= "00000000000100000000010000000000";
sprite_bombermanB0(3)  <= "00000000011000000000001100000000";
sprite_bombermanB0(4)  <= "00000000100000000000000010000000";
sprite_bombermanB0(5)  <= "00000001000000000000000001000000";
sprite_bombermanB0(6)  <= "00000010000000000000000000100000";
sprite_bombermanB0(7)  <= "00000010000000000000000000100000";
sprite_bombermanB0(8)  <= "00000010000000000000000000100000";
sprite_bombermanB0(9)  <= "00000010000000000000000000100000";
sprite_bombermanB0(10) <= "00000010000000000000000000100000";
sprite_bombermanB0(11) <= "00000010000000000000000000100000";
sprite_bombermanB0(12) <= "00000010000000000000000000100000";
sprite_bombermanB0(13) <= "00000001000000000000000001000000";
sprite_bombermanB0(14) <= "00000000100000000000000010000000";
sprite_bombermanB0(15) <= "00000000010000000000000100000000";
sprite_bombermanB0(16) <= "00000000010000000000000100000000";
sprite_bombermanB0(17) <= "00000000100000000000000010000000";
sprite_bombermanB0(18) <= "00000001000000000000000001000000";
sprite_bombermanB0(19) <= "00000001000111111111110000100000";
sprite_bombermanB0(20) <= "00000010000111111111110000100000";
sprite_bombermanB0(21) <= "00000010000000000000000000100000";
sprite_bombermanB0(22) <= "00000001000000000000000001000000";
sprite_bombermanB0(23) <= "00000000111100000000011110000000";
sprite_bombermanB0(24) <= "00000000000100000000010000000000";
sprite_bombermanB0(25) <= "00000000111100011100011110000000";
sprite_bombermanB0(26) <= "00000001111000011100001111000000";
sprite_bombermanB0(27) <= "00000011100000011100000011100000";
sprite_bombermanB0(28) <= "00000011100000011100000011100000";
sprite_bombermanB0(29) <= "00000001111111111111111111000000";
sprite_bombermanB0(30) <= "00000000011111111111111100000000";
sprite_bombermanB0(31) <= "00000000000000000000000000000000";

--bombermanB1 shoes and gloves--
sprite_bombermanB1(0)  <= "00000000000000000000000000000000";
sprite_bombermanB1(1)  <= "00000000000000000000000000000000";
sprite_bombermanB1(2)  <= "00000000000000011100000000000000";
sprite_bombermanB1(3)  <= "00000000000000111110000000000000";
sprite_bombermanB1(4)  <= "00000000000000111110000000000000";
sprite_bombermanB1(5)  <= "00000000000000011100000000000000";
sprite_bombermanB1(6)  <= "00000000000000000000000000000000";
sprite_bombermanB1(7)  <= "00000000000000000000000000000000";
sprite_bombermanB1(8)  <= "00000000000000000000000000000000";
sprite_bombermanB1(9)  <= "00000000000000000000000000000000";
sprite_bombermanB1(10) <= "00000000000000000000000000000000";
sprite_bombermanB1(11) <= "00000000000000000000000000000000";
sprite_bombermanB1(12) <= "00000000000000000000000000000000";
sprite_bombermanB1(13) <= "00000000000000000000000000000000";
sprite_bombermanB1(14) <= "00000000000000000000000000000000";
sprite_bombermanB1(15) <= "00000000000000000000000000000000";
sprite_bombermanB1(16) <= "00000000000000000000000000000000";
sprite_bombermanB1(17) <= "00000000000000000000000000000000";
sprite_bombermanB1(18) <= "00000000000000000000000000000000";
sprite_bombermanB1(19) <= "00000000000000000000000000000000";
sprite_bombermanB1(20) <= "00000001111100000000011111000000";
sprite_bombermanB1(21) <= "00000001111100000000011111000000";
sprite_bombermanB1(22) <= "00000000111100000000011110000000";
sprite_bombermanB1(23) <= "00000000000000000000000000000000";
sprite_bombermanB1(24) <= "00000000000000000000000000000000";
sprite_bombermanB1(25) <= "00000000000000000000000000000000";
sprite_bombermanB1(26) <= "00000000000111100011110000000000";
sprite_bombermanB1(27) <= "00000000011111100011111100000000";
sprite_bombermanB1(28) <= "00000000011111100011111100000000";
sprite_bombermanB1(29) <= "00000000000000000000000000000000";
sprite_bombermanB1(30) <= "00000000000000000000000000000000";
sprite_bombermanB1(31) <= "00000000000000000000000000000000";

--bombermanB2 skin--
sprite_bombermanB2(0)  <= "00000000000000000000000000000000";
sprite_bombermanB2(1)  <= "00000000000000000000000000000000";
sprite_bombermanB2(2)  <= "00000000000000000000000000000000";
sprite_bombermanB2(3)  <= "00000000000000000000000000000000";
sprite_bombermanB2(4)  <= "00000000000000000000000000000000";
sprite_bombermanB2(5)  <= "00000000000000000000000000000000";
sprite_bombermanB2(6)  <= "00000000000000000000000000000000";
sprite_bombermanB2(7)  <= "00000000000000000000000000000000";
sprite_bombermanB2(8)  <= "00000000000000000000000000000000";
sprite_bombermanB2(9)  <= "00000000000000000000000000000000";
sprite_bombermanB2(10) <= "00000000000000000000000000000000";
sprite_bombermanB2(11) <= "00000000000000000000000000000000";
sprite_bombermanB2(12) <= "00000000000000000000000000000000";
sprite_bombermanB2(13) <= "00000000000000000000000000000000";
sprite_bombermanB2(14) <= "00000000000000000000000000000000";
sprite_bombermanB2(15) <= "00000000000000000000000000000000";
sprite_bombermanB2(16) <= "00000000001100000000011000000000";
sprite_bombermanB2(17) <= "00000000011100000000011100000000";
sprite_bombermanB2(18) <= "00000000111000000000001110000000";
sprite_bombermanB2(19) <= "00000000110000000000000110000000";
sprite_bombermanB2(20) <= "00000000000000000000000000000000";
sprite_bombermanB2(21) <= "00000000000000000000000000000000";
sprite_bombermanB2(22) <= "00000000000000000000000000000000";
sprite_bombermanB2(23) <= "00000000000011100011100000000000";
sprite_bombermanB2(24) <= "00000000000011100011100000000000";
sprite_bombermanB2(25) <= "00000000000011100011100000000000";
sprite_bombermanB2(26) <= "00000000000000000000000000000000";
sprite_bombermanB2(27) <= "00000000000000000000000000000000";
sprite_bombermanB2(28) <= "00000000000000000000000000000000";
sprite_bombermanB2(29) <= "00000000000000000000000000000000";
sprite_bombermanB2(30) <= "00000000000000000000000000000000";
sprite_bombermanB2(31) <= "00000000000000000000000000000000";

--bombermanB3 helmet--
sprite_bombermanB3(0)  <= "00000000000000000000000000000000";
sprite_bombermanB3(1)  <= "00000000000000000000000000000000";
sprite_bombermanB3(2)  <= "00000000000011100011100000000000";
sprite_bombermanB3(3)  <= "00000000000111000001110000000000";
sprite_bombermanB3(4)  <= "00000000011111000001111100000000";
sprite_bombermanB3(5)  <= "00000000111111100011111110000000";
sprite_bombermanB3(6)  <= "00000001111111111111111111000000";
sprite_bombermanB3(7)  <= "00000001111111111111111111000000";
sprite_bombermanB3(8)  <= "00000001111111111111111111000000";
sprite_bombermanB3(9)  <= "00000001111111111111111111000000";
sprite_bombermanB3(10) <= "00000001111111111111111111000000";
sprite_bombermanB3(11) <= "00000001111111111111111111000000";
sprite_bombermanB3(12) <= "00000001111111111111111111000000";
sprite_bombermanB3(13) <= "00000000111111111111111110000000";
sprite_bombermanB3(14) <= "00000000011111111111111100000000";
sprite_bombermanB3(15) <= "00000000001111111111111000000000";
sprite_bombermanB3(16) <= "00000000000000000000000000000000";
sprite_bombermanB3(17) <= "00000000000000000000000000000000";
sprite_bombermanB3(18) <= "00000000000000000000000000000000";
sprite_bombermanB3(19) <= "00000000000000000000000000000000";
sprite_bombermanB3(20) <= "00000000000000000000000000000000";
sprite_bombermanB3(21) <= "00000000000000000000000000000000";
sprite_bombermanB3(22) <= "00000000000000000000000000000000";
sprite_bombermanB3(23) <= "00000000000000000000000000000000";
sprite_bombermanB3(24) <= "00000000000000000000000000000000";
sprite_bombermanB3(25) <= "00000000000000000000000000000000";
sprite_bombermanB3(26) <= "00000000000000000000000000000000";
sprite_bombermanB3(27) <= "00000000000000000000000000000000";
sprite_bombermanB3(28) <= "00000000000000000000000000000000";
sprite_bombermanB3(29) <= "00000000000000000000000000000000";
sprite_bombermanB3(30) <= "00000000000000000000000000000000";
sprite_bombermanB3(31) <= "00000000000000000000000000000000";

--bombermanB1 body--
sprite_bombermanB4(0)  <= "00000000000000000000000000000000";
sprite_bombermanB4(1)  <= "00000000000000000000000000000000";
sprite_bombermanB4(2)  <= "00000000000000000000000000000000";
sprite_bombermanB4(3)  <= "00000000000000000000000000000000";
sprite_bombermanB4(4)  <= "00000000000000000000000000000000";
sprite_bombermanB4(5)  <= "00000000000000000000000000000000";
sprite_bombermanB4(6)  <= "00000000000000000000000000000000";
sprite_bombermanB4(7)  <= "00000000000000000000000000000000";
sprite_bombermanB4(8)  <= "00000000000000000000000000000000";
sprite_bombermanB4(9)  <= "00000000000000000000000000000000";
sprite_bombermanB4(10) <= "00000000000000000000000000000000";
sprite_bombermanB4(11) <= "00000000000000000000000000000000";
sprite_bombermanB4(12) <= "00000000000000000000000000000000";
sprite_bombermanB4(13) <= "00000000000000000000000000000000";
sprite_bombermanB4(14) <= "00000000000000000000000000000000";
sprite_bombermanB4(15) <= "00000000000000000000000000000000";
sprite_bombermanB4(16) <= "00000000000011111111100000000000";
sprite_bombermanB4(17) <= "00000000001111111111111000000000";
sprite_bombermanB4(18) <= "00000000001111111111111000000000";
sprite_bombermanB4(19) <= "00000000001111111111111000000000";
sprite_bombermanB4(20) <= "00000000001111111111111000000000";
sprite_bombermanB4(21) <= "00000000000111111111110000000000";
sprite_bombermanB4(22) <= "00000000000001111111000000000000";
sprite_bombermanB4(23) <= "00000000000001111111000000000000";
sprite_bombermanB4(24) <= "00000000000000000000000000000000";
sprite_bombermanB4(25) <= "00000000000000000000000000000000";
sprite_bombermanB4(26) <= "00000000000000000000000000000000";
sprite_bombermanB4(27) <= "00000000000000000000000000000000";
sprite_bombermanB4(28) <= "00000000000000000000000000000000";
sprite_bombermanB4(29) <= "00000000000000000000000000000000";
sprite_bombermanB4(30) <= "00000000000000000000000000000000";
sprite_bombermanB4(31) <= "00000000000000000000000000000000";

--bombermanL1 outside--
sprite_bombermanL0(0)  <= "00000000000000000000000000000000";
sprite_bombermanL0(1)  <= "00000000000001111111100000000000";
sprite_bombermanL0(2)  <= "00000000001110000000011011110000";
sprite_bombermanL0(3)  <= "00000000110000000000000100001000";
sprite_bombermanL0(4)  <= "00000001000000000000000010001000";
sprite_bombermanL0(5)  <= "00000001000000000000000001000100";
sprite_bombermanL0(6)  <= "00000001000000000000000001001000";
sprite_bombermanL0(7)  <= "00000010000000000000000000110000";
sprite_bombermanL0(8)  <= "00000010001000000000000000100000";
sprite_bombermanL0(9)  <= "00000001001000000000000000100000";
sprite_bombermanL0(10) <= "00000001001000000000000000100000";
sprite_bombermanL0(11) <= "00000001001000000000000001000000";
sprite_bombermanL0(12) <= "00000001001000000000000001000000";
sprite_bombermanL0(13) <= "00000001000000000000000010000000";
sprite_bombermanL0(14) <= "00000000100000000000000100000000";
sprite_bombermanL0(15) <= "00000000010000000000111000000000";
sprite_bombermanL0(16) <= "00000000100000000000100000000000";
sprite_bombermanL0(17) <= "00000000100000000000100000000000";
sprite_bombermanL0(18) <= "00000000110000000110100000000000";
sprite_bombermanL0(19) <= "00000000110000000110100000000000";
sprite_bombermanL0(20) <= "00000000100000000000100000000000";
sprite_bombermanL0(21) <= "00000000100000000000100000000000";
sprite_bombermanL0(22) <= "00000000010000000001000000000000";
sprite_bombermanL0(23) <= "00000000001110000010000000000000";
sprite_bombermanL0(24) <= "00000000011000000001100000000000";
sprite_bombermanL0(25) <= "00000000110000000000111000000000";
sprite_bombermanL0(26) <= "00000001110000000000111110000000";
sprite_bombermanL0(27) <= "00000001111000000001111110000000";
sprite_bombermanL0(28) <= "00000000011111111111111000000000";
sprite_bombermanL0(29) <= "00000000001111111111100000000000";
sprite_bombermanL0(30) <= "00000000000000000000000000000000";
sprite_bombermanL0(31) <= "00000000000000000000000000000000";

--bombermanL1 shoes and gloves--
sprite_bombermanL1(0)  <= "00000000000000000000000000000000";
sprite_bombermanL1(1)  <= "00000000000000000000000000000000";
sprite_bombermanL1(2)  <= "00000000000000000000000000000000";
sprite_bombermanL1(3)  <= "00000000000000000000000001111000";
sprite_bombermanL1(4)  <= "00000000000000000000000001111000";
sprite_bombermanL1(5)  <= "00000000000000000000000000111100";
sprite_bombermanL1(6)  <= "00000000000000000000000000011000";
sprite_bombermanL1(7)  <= "00000000111110000000000000000000";
sprite_bombermanL1(8)  <= "00000000000001000000000000000000";
sprite_bombermanL1(9)  <= "00000000000000100000000000000000";
sprite_bombermanL1(10) <= "00000000000000010000000000000000";
sprite_bombermanL1(11) <= "00000000000000100000000000000000";
sprite_bombermanL1(12) <= "00000000000001000000000000000000";
sprite_bombermanL1(13) <= "00000000111110000000000000000000";
sprite_bombermanL1(14) <= "00000000000000000000000000000000";
sprite_bombermanL1(15) <= "00000000000000000000000000000000";
sprite_bombermanL1(16) <= "00000000000000000000000000000000";
sprite_bombermanL1(17) <= "00000000000000000000000000000000";
sprite_bombermanL1(18) <= "00000000001100000000000000000000";
sprite_bombermanL1(19) <= "00000000001100000000000000000000";
sprite_bombermanL1(20) <= "00000000000001111100000000000000";
sprite_bombermanL1(21) <= "00000000000011111110000000000000";
sprite_bombermanL1(22) <= "00000000000001111100000000000000";
sprite_bombermanL1(23) <= "00000000000000000000000000000000";
sprite_bombermanL1(24) <= "00000000000000000000000000000000";
sprite_bombermanL1(25) <= "00000000000011111110000000000000";
sprite_bombermanL1(26) <= "00000000000111111110000000000000";
sprite_bombermanL1(27) <= "00000000000111111100000000000000";
sprite_bombermanL1(28) <= "00000000000000000000000000000000";
sprite_bombermanL1(29) <= "00000000000000000000000000000000";
sprite_bombermanL1(30) <= "00000000000000000000000000000000";
sprite_bombermanL1(31) <= "00000000000000000000000000000000";

--bombermanL1 skin--
sprite_bombermanL2(0)  <= "00000000000000000000000000000000";
sprite_bombermanL2(1)  <= "00000000000000000000000000000000";
sprite_bombermanL2(2)  <= "00000000000000000000000000000000";
sprite_bombermanL2(3)  <= "00000000000000000000000000000000";
sprite_bombermanL2(4)  <= "00000000000000000000000000000000";
sprite_bombermanL2(5)  <= "00000000000000000000000000000000";
sprite_bombermanL2(6)  <= "00000000000000000000000000000000";
sprite_bombermanL2(7)  <= "00000000000000000000000000000000";
sprite_bombermanL2(8)  <= "00000000111110000000000000000000";
sprite_bombermanL2(9)  <= "00000001111111000000000000000000";
sprite_bombermanL2(10) <= "00000001111111100000000000000000";
sprite_bombermanL2(11) <= "00000001111111000000000000000000";
sprite_bombermanL2(12) <= "00000000111110000000000000000000";
sprite_bombermanL2(13) <= "00000000000000000000000000000000";
sprite_bombermanL2(14) <= "00000000000000000000000000000000";
sprite_bombermanL2(15) <= "00000000000000000000000000000000";
sprite_bombermanL2(16) <= "00000000000000000000000000000000";
sprite_bombermanL2(17) <= "00000000000000111000000000000000";
sprite_bombermanL2(18) <= "00000000000000111000000000000000";
sprite_bombermanL2(19) <= "00000000000000111000000000000000";
sprite_bombermanL2(20) <= "00000000000000000000000000000000";
sprite_bombermanL2(21) <= "00000000000000000000000000000000";
sprite_bombermanL2(22) <= "00000000000000000000000000000000";
sprite_bombermanL2(23) <= "00000000000000011100000000000000";
sprite_bombermanL2(24) <= "00000000000000011100000000000000";
sprite_bombermanL2(25) <= "00000000000000000000000000000000";
sprite_bombermanL2(26) <= "00000000000000000000000000000000";
sprite_bombermanL2(27) <= "00000000000000000000000000000000";
sprite_bombermanL2(28) <= "00000000000000000000000000000000";
sprite_bombermanL2(29) <= "00000000000000000000000000000000";
sprite_bombermanL2(30) <= "00000000000000000000000000000000";
sprite_bombermanL2(31) <= "00000000000000000000000000000000";

--bombermanL1 helmet--
sprite_bombermanL3(0)  <= "00000000000000000000000000000000";
sprite_bombermanL3(1)  <= "00000000000000000000000000000000";
sprite_bombermanL3(2)  <= "00000000000001111111100000000000";
sprite_bombermanL3(3)  <= "00000000001111111111110000000000";
sprite_bombermanL3(4)  <= "00000000111111111111111100000000";
sprite_bombermanL3(5)  <= "00000000111111111111111110000000";
sprite_bombermanL3(6)  <= "00000000111111111111111110000000";
sprite_bombermanL3(7)  <= "00000000000001111111111111000000";
sprite_bombermanL3(8)  <= "00000000000000111111111111000000";
sprite_bombermanL3(9)  <= "00000000000000001111111111000000";
sprite_bombermanL3(10) <= "00000000000000001111111111000000";
sprite_bombermanL3(11) <= "00000000000000011111111110000000";
sprite_bombermanL3(12) <= "00000000000000111111111110000000";
sprite_bombermanL3(13) <= "00000000000001111111111100000000";
sprite_bombermanL3(14) <= "00000000011111111111111000000000";
sprite_bombermanL3(15) <= "00000000001111111111000000000000";
sprite_bombermanL3(16) <= "00000000000000000000000000000000";
sprite_bombermanL3(17) <= "00000000000000000000000000000000";
sprite_bombermanL3(18) <= "00000000000000000000000000000000";
sprite_bombermanL3(19) <= "00000000000000000000000000000000";
sprite_bombermanL3(20) <= "00000000000000000000000000000000";
sprite_bombermanL3(21) <= "00000000000000000000000000000000";
sprite_bombermanL3(22) <= "00000000000000000000000000000000";
sprite_bombermanL3(23) <= "00000000000000000000000000000000";
sprite_bombermanL3(24) <= "00000000000000000000000000000000";
sprite_bombermanL3(25) <= "00000000000000000000000000000000";
sprite_bombermanL3(26) <= "00000000000000000000000000000000";
sprite_bombermanL3(27) <= "00000000000000000000000000000000";
sprite_bombermanL3(28) <= "00000000000000000000000000000000";
sprite_bombermanL3(29) <= "00000000000000000000000000000000";
sprite_bombermanL3(30) <= "00000000000000000000000000000000";
sprite_bombermanL3(31) <= "00000000000000000000000000000000";

--bombermanL1 body--
sprite_bombermanL4(0)  <= "00000000000000000000000000000000";
sprite_bombermanL4(1)  <= "00000000000000000000000000000000";
sprite_bombermanL4(2)  <= "00000000000000000000000000000000";
sprite_bombermanL4(3)  <= "00000000000000000000000000000000";
sprite_bombermanL4(4)  <= "00000000000000000000000000000000";
sprite_bombermanL4(5)  <= "00000000000000000000000000000000";
sprite_bombermanL4(6)  <= "00000000000000000000000000000000";
sprite_bombermanL4(7)  <= "00000000000000000000000000000000";
sprite_bombermanL4(8)  <= "00000000000000000000000000000000";
sprite_bombermanL4(9)  <= "00000000000000000000000000000000";
sprite_bombermanL4(10) <= "00000000000000000000000000000000";
sprite_bombermanL4(11) <= "00000000000000000000000000000000";
sprite_bombermanL4(12) <= "00000000000000000000000000000000";
sprite_bombermanL4(13) <= "00000000000000000000000000000000";
sprite_bombermanL4(14) <= "00000000000000000000000000000000";
sprite_bombermanL4(15) <= "00000000000000000000000000000000";
sprite_bombermanL4(16) <= "00000000011111111111000000000000";
sprite_bombermanL4(17) <= "00000000011111111111000000000000";
sprite_bombermanL4(18) <= "00000000001111111111000000000000";
sprite_bombermanL4(19) <= "00000000001111111111000000000000";
sprite_bombermanL4(20) <= "00000000111111111111000000000000";
sprite_bombermanL4(21) <= "00000000011111111111000000000000";
sprite_bombermanL4(22) <= "00000000001111111110000000000000";
sprite_bombermanL4(23) <= "00000000000000000000000000000000";
sprite_bombermanL4(24) <= "00000000000000000000000000000000";
sprite_bombermanL4(25) <= "00000000000000000000000000000000";
sprite_bombermanL4(26) <= "00000000000000000000000000000000";
sprite_bombermanL4(27) <= "00000000000000000000000000000000";
sprite_bombermanL4(28) <= "00000000000000000000000000000000";
sprite_bombermanL4(29) <= "00000000000000000000000000000000";
sprite_bombermanL4(30) <= "00000000000000000000000000000000";
sprite_bombermanL4(31) <= "00000000000000000000000000000000";

  --concrete code -- 111111
sprite_concrete0(0)  <= "00000000000000000000000000000000";
sprite_concrete0(1)  <= "00000000000000000000000000000000";
sprite_concrete0(2)  <= "00000000000000000000000000000000";
sprite_concrete0(3)  <= "00000000000000000000000000000000";
sprite_concrete0(4)  <= "00000000000000000000000000000000";
sprite_concrete0(5)  <= "00000000000000000000000000000000";
sprite_concrete0(6)  <= "00000000000000000000000000000000";
sprite_concrete0(7)  <= "00000000000000000000000000000000";
sprite_concrete0(8)  <= "00000000000000000000000000000000";
sprite_concrete0(9)  <= "00000000000000000000000000000000";
sprite_concrete0(10) <= "00000000000000000000000000000000";
sprite_concrete0(11) <= "00000000000000000000000000000000";
sprite_concrete0(12) <= "00000000000000000000000000000000";
sprite_concrete0(13) <= "00000000000000000000000000000000";
sprite_concrete0(14) <= "00000000000000000000000000000000";
sprite_concrete0(15) <= "00000000000000000000000000000000";
sprite_concrete0(16) <= "00000000000000000000000000000000";
sprite_concrete0(17) <= "00000000000000000000000000000000";
sprite_concrete0(18) <= "00000000000000000000000000000000";
sprite_concrete0(19) <= "00000000000000000000000000000000";
sprite_concrete0(20) <= "00000000000000000000000000000000";
sprite_concrete0(21) <= "00000000000000000000000000000000";
sprite_concrete0(22) <= "00000000000000000000000000000000";
sprite_concrete0(23) <= "11111111111111111111111111111110";
sprite_concrete0(24) <= "11111111111111111111111111111110";
sprite_concrete0(25) <= "11111111111111111111111111111110";
sprite_concrete0(26) <= "11111111111111111111111111111110";
sprite_concrete0(27) <= "11111111111111111111111111111110";
sprite_concrete0(28) <= "11111111111111111111111111111110";
sprite_concrete0(29) <= "11111111111111111111111111111110";
sprite_concrete0(30) <= "11111111111111111111111111111110";
sprite_concrete0(31) <= "11111111111111111111111111111110";


sprite_concrete1(0)  <= "11111111111111111111111111111111";
sprite_concrete1(1)  <= "11111111111111111111111111111111";
sprite_concrete1(2)  <= "11111111111111111111111111111111";
sprite_concrete1(3)  <= "11111111111111111111111111111111";
sprite_concrete1(4)  <= "11111111111111111111111111111111";
sprite_concrete1(5)  <= "11111111111111111111111111111111";
sprite_concrete1(6)  <= "11111111111111111111111111111111";
sprite_concrete1(7)  <= "11111111111111111111111111111111";
sprite_concrete1(8)  <= "11111111111111111111111111111111";
sprite_concrete1(9)  <= "11111111111111111111111111111111";
sprite_concrete1(10) <= "11111111111111111111111111111111";
sprite_concrete1(11) <= "11111111111111111111111111111111";
sprite_concrete1(12) <= "11111111111111111111111111111111";
sprite_concrete1(13) <= "11111111111111111111111111111111";
sprite_concrete1(14) <= "11111111111111111111111111111111";
sprite_concrete1(15) <= "11111111111111111111111111111111";
sprite_concrete1(16) <= "11111111111111111111111111111111";
sprite_concrete1(17) <= "11111111111111111111111111111111";
sprite_concrete1(18) <= "11111111111111111111111111111111";
sprite_concrete1(19) <= "11111111111111111111111111111111";
sprite_concrete1(20) <= "11111111111111111111111111111111";
sprite_concrete1(21) <= "11111111111111111111111111111111";
sprite_concrete1(22) <= "11111111111111111111111111111111";
sprite_concrete1(23) <= "11111111111111111111111111111111";
sprite_concrete1(24) <= "11111111111111111111111111111111";
sprite_concrete1(25) <= "11111111111111111111111111111111";
sprite_concrete1(26) <= "11111111111111111111111111111111";
sprite_concrete1(27) <= "11111111111111111111111111111111";
sprite_concrete1(28) <= "11111111111111111111111111111111";
sprite_concrete1(29) <= "11111111111111111111111111111111";
sprite_concrete1(30) <= "11111111111111111111111111111111";
sprite_concrete1(31) <= "11111111111111111111111111111111";


sprite_concrete2(0)  <= "11111111111111111111111111111111";
sprite_concrete2(1)  <= "10000000000000000000000000000001";
sprite_concrete2(2)  <= "10110000000000000000000000001101";
sprite_concrete2(3)  <= "10110000000000000000000000001101";
sprite_concrete2(4)  <= "10000000000000000000000000000001";
sprite_concrete2(5)  <= "10000111111111111111111111100001";
sprite_concrete2(6)  <= "10000100000000000000000000100001";
sprite_concrete2(7)  <= "10000101100000000000000110100001";
sprite_concrete2(8)  <= "10000101100000000000000110100001";
sprite_concrete2(9)  <= "10000100000000000000000000100001";
sprite_concrete2(10) <= "10000100000000000000000000100001";
sprite_concrete2(11) <= "10000100000000000000000000100001";
sprite_concrete2(12) <= "10000100000000000000000000100001";
sprite_concrete2(13) <= "10000100000000000000000000100001";
sprite_concrete2(14) <= "10000100000000000000000000100001";
sprite_concrete2(15) <= "10000101100000000000000110100001";
sprite_concrete2(16) <= "10000101100000000000000110100001";
sprite_concrete2(17) <= "10000100000000000000000000100001";
sprite_concrete2(18) <= "10000111111111111111111111100001";
sprite_concrete2(19) <= "10000000000000000000000000000001";
sprite_concrete2(20) <= "10110000000000000000000000001101";
sprite_concrete2(21) <= "10110000000000000000000000001101";
sprite_concrete2(22) <= "10000000000000000000000000000001";
sprite_concrete2(23) <= "11111111111111111111111111111110";
sprite_concrete2(24) <= "10000000000000000000000000000010";
sprite_concrete2(25) <= "10110000000000000000000000011010";
sprite_concrete2(26) <= "10000111111111111111111111000010";
sprite_concrete2(27) <= "10000100000000000000000001000010";
sprite_concrete2(28) <= "10000111111111111111111111000010";
sprite_concrete2(29) <= "10110000000000000000000000011010";
sprite_concrete2(30) <= "10000000000000000000000000000010";
sprite_concrete2(31) <= "11111111111111111111111111111111";

  --bomber code -- 000001
sprite_bomber0(0)  <= "11111111111111111111111111111111";
sprite_bomber0(1)  <= "10000000000000000000000000000001";
sprite_bomber0(2)  <= "10000000000000000000000000000001";
sprite_bomber0(3)  <= "10000000000000000000000000000001";
sprite_bomber0(4)  <= "10000000000111111111111000000001";
sprite_bomber0(5)  <= "10000000011111000111111000000001";
sprite_bomber0(6)  <= "10000000111111000111111000000001";
sprite_bomber0(7)  <= "10000001111111000111111000000001";
sprite_bomber0(8)  <= "10000011110001111111111111110001";
sprite_bomber0(9)  <= "10001111000011111111111111111001";
sprite_bomber0(10) <= "11111111000111111111111111111111";
sprite_bomber0(11) <= "10011111000111111111111111111101";
sprite_bomber0(12) <= "10011100000111111111111111111101";
sprite_bomber0(13) <= "10111100001111111111111111111111";
sprite_bomber0(14) <= "10111100111111111111111111111111";
sprite_bomber0(15) <= "10111100111111111111111111111111";
sprite_bomber0(16) <= "10111100111111111111111111111111";
sprite_bomber0(17) <= "10111110111111111111111111111111";
sprite_bomber0(18) <= "10111111111111111111111111111111";
sprite_bomber0(19) <= "10111111111111111111111111111111";
sprite_bomber0(20) <= "10111111111111111111111111111111";
sprite_bomber0(21) <= "11111111111111111111111111111111";
sprite_bomber0(22) <= "10111111111111111111111111111111";
sprite_bomber0(23) <= "10011111111111111111111111111111";
sprite_bomber0(24) <= "10001111111111111111111111111101";
sprite_bomber0(25) <= "10000111111111111111111111111001";
sprite_bomber0(26) <= "10000111111111111111111111110001";
sprite_bomber0(27) <= "10000011111111111111111111100001";
sprite_bomber0(28) <= "10000001111111111111111111000001";
sprite_bomber0(29) <= "10000000111111111111111100000001";
sprite_bomber0(30) <= "10000000011111111111111000000001";
sprite_bomber0(31) <= "11111111111111111111111111111111";


sprite_bomber1(0)  <= "11111111111111111111111111111111";
sprite_bomber1(1)  <= "11111111111111111111111111111111";
sprite_bomber1(2)  <= "11111111111111111111111111111111";
sprite_bomber1(3)  <= "11111111111111111111111111111111";
sprite_bomber1(4)  <= "11111111111000000000011111111111";
sprite_bomber1(5)  <= "11111111100000000000001111111111";
sprite_bomber1(6)  <= "11111111000000000000000000111111";
sprite_bomber1(7)  <= "11111111000000000000000000111111";
sprite_bomber1(8)  <= "11111100000000000000000000011111";
sprite_bomber1(9)  <= "11110000000000000000000000000111";
sprite_bomber1(10) <= "11110000000000000000000000000111";
sprite_bomber1(11) <= "11110000000000000000000000000111";
sprite_bomber1(12) <= "11110000000000000000000000000111";
sprite_bomber1(13) <= "11000000000000000000000000000001";
sprite_bomber1(14) <= "11000000000000000000000000000001";
sprite_bomber1(15) <= "11000000000000000000000000000001";
sprite_bomber1(16) <= "11000000000000000000000000000001";
sprite_bomber1(17) <= "11000000000000000000000000000001";
sprite_bomber1(18) <= "11000000000000000000000000000001";
sprite_bomber1(19) <= "11000000000000000000000000000001";
sprite_bomber1(20) <= "11000000000000000000000000000001";
sprite_bomber1(21) <= "11110000000000000000000000000011";
sprite_bomber1(22) <= "11110000000000000000000000000111";
sprite_bomber1(23) <= "11110000000000000000000000000111";
sprite_bomber1(24) <= "11110000000000000000000000000111";
sprite_bomber1(25) <= "11111100000000000000000000011111";
sprite_bomber1(26) <= "11111100000000000000000000011111";
sprite_bomber1(27) <= "11111100000000000000000000011111";
sprite_bomber1(28) <= "11111111000000000000000001111111";
sprite_bomber1(29) <= "11111111000000000000000011111111";
sprite_bomber1(30) <= "11111111111111111111111111111111";
sprite_bomber1(31) <= "11111111111111111111111111111111";


sprite_bomber2(0)  <= "00000000000000000000000000000000";
sprite_bomber2(1)  <= "00000000000000000000000000000000";
sprite_bomber2(2)  <= "00000000000000000000000011100000";
sprite_bomber2(3)  <= "00000000000000000000000011100000";
sprite_bomber2(4)  <= "00000000000000000000000111100000";
sprite_bomber2(5)  <= "00000000000000111000000111100000";
sprite_bomber2(6)  <= "00000000000000111000001111000000";
sprite_bomber2(7)  <= "00000000000000111000011110000000";
sprite_bomber2(8)  <= "00000000001110000000111100000000";
sprite_bomber2(9)  <= "00000000111100000001111000000000";
sprite_bomber2(10) <= "00000000111000000011100000000000";
sprite_bomber2(11) <= "00000000111000000000000000000000";
sprite_bomber2(12) <= "00000011111000000000000000000000";
sprite_bomber2(13) <= "00000011110000000000000000000000";
sprite_bomber2(14) <= "00000011000000000000000000000000";
sprite_bomber2(15) <= "00000011000000000000000000000000";
sprite_bomber2(16) <= "00000011000000000000000000000000";
sprite_bomber2(17) <= "00000001000000000000000000000000";
sprite_bomber2(18) <= "00000000000000000000000000000000";
sprite_bomber2(19) <= "00000000000000000000000000000000";
sprite_bomber2(20) <= "00000000000000000000000000000000";
sprite_bomber2(21) <= "00000000000000000000000000000000";
sprite_bomber2(22) <= "00000000000000000000000000000000";
sprite_bomber2(23) <= "00000000000000000000000000000000";
sprite_bomber2(24) <= "00000000000000000000000000000000";
sprite_bomber2(25) <= "00000000000000000000000000000000";
sprite_bomber2(26) <= "00000000000000000000000000000000";
sprite_bomber2(27) <= "00000000000000000000000000000000";
sprite_bomber2(28) <= "00000000000000000000000000000000";
sprite_bomber2(29) <= "00000000000000000000000000000000";
sprite_bomber2(30) <= "00000000000000000000000000000000";
sprite_bomber2(31) <= "00000000000000000000000000000000";

sprite_bomber3(0)  <= "00000000000000000000000011100000";
sprite_bomber3(1)  <= "00000000000000000000000111110000";
sprite_bomber3(2)  <= "00000000000000000000001111111000";
sprite_bomber3(3)  <= "00000000000000000000001111111000";
sprite_bomber3(4)  <= "00000000000000000000000111110000";
sprite_bomber3(5)  <= "00000000000000011000000011100000";
sprite_bomber3(6)  <= "00000000000000011110000000000000";
sprite_bomber3(7)  <= "00000000000000001100000000000000";
sprite_bomber3(8)  <= "00000000000000000000000000000000";
sprite_bomber3(9)  <= "00000000000000000000000000000000";
sprite_bomber3(10) <= "00000000000000000000000000000000";
sprite_bomber3(11) <= "00000000000000000000000000000000";
sprite_bomber3(12) <= "00000000000000000000000000000000";
sprite_bomber3(13) <= "00000000000000000000000000000000";
sprite_bomber3(14) <= "00000000000000000000000000000000";
sprite_bomber3(15) <= "00000000000000000000000000000000";
sprite_bomber3(16) <= "00000000000000000000000000000000";
sprite_bomber3(17) <= "00000000000000000000000000000000";
sprite_bomber3(18) <= "00000000000000000000000000000000";
sprite_bomber3(19) <= "00000000000000000000000000000000";
sprite_bomber3(20) <= "00000000000000000000000000000000";
sprite_bomber3(21) <= "00000000000000000000000000000000";
sprite_bomber3(22) <= "00000000000000000000000000000000";
sprite_bomber3(23) <= "00000000000000000000000000000000";
sprite_bomber3(24) <= "00000000000000000000000000000000";
sprite_bomber3(25) <= "00000000000000000000000000000000";
sprite_bomber3(26) <= "00000000000000000000000000000000";
sprite_bomber3(27) <= "00000000000000000000000000000000";
sprite_bomber3(28) <= "00000000000000000000000000000000";
sprite_bomber3(29) <= "00000000000000000000000000000000";
sprite_bomber3(30) <= "00000000000000000000000000000000";
sprite_bomber3(31) <= "00000000000000000000000000000000";


  --fire code -- 000010
sprite_fire0(0)  <= "00111100000000000000000000111100";
sprite_fire0(1)  <= "01111000000000000000000000011110";
sprite_fire0(2)  <= "11110000000000000000000000001111";
sprite_fire0(3)  <= "11100000000000000000000000000111";
sprite_fire0(4)  <= "11000000000000000000000000000011";
sprite_fire0(5)  <= "10000000000000000000000000000001";
sprite_fire0(6)  <= "00000000000000000000000000000000";
sprite_fire0(7)  <= "00000000000000000000000000000000";
sprite_fire0(8)  <= "00000000000000000000000000000000";
sprite_fire0(9)  <= "00000000000000000000000000000000";
sprite_fire0(10) <= "00000000000000000000000000000000";
sprite_fire0(11) <= "00000000000000000000000000000000";
sprite_fire0(12) <= "00000000000000000000000000000000";
sprite_fire0(13) <= "00000000000000000000000000000000";
sprite_fire0(14) <= "00000000000000000000000000000000";
sprite_fire0(15) <= "00000000000000000000000000000000";
sprite_fire0(16) <= "00000000000000000000000000000000";
sprite_fire0(17) <= "00000000000000000000000000000000";
sprite_fire0(18) <= "00000000000000000000000000000000";
sprite_fire0(19) <= "00000000000000000000000000000000";
sprite_fire0(20) <= "00000000000000000000000000000000";
sprite_fire0(21) <= "00000000000000000000000000000000";
sprite_fire0(22) <= "00000000000000000000000000000000";
sprite_fire0(23) <= "00000000000000000000000000000000";
sprite_fire0(24) <= "00000000000000000000000000000000";
sprite_fire0(25) <= "00000000000000000000000000000000";
sprite_fire0(26) <= "10000000000000000000000000000001";
sprite_fire0(27) <= "11000000000000000000000000000011";
sprite_fire0(28) <= "11100000000000000000000000000111";
sprite_fire0(29) <= "11110000000000000000000000001111";
sprite_fire0(30) <= "01111000000000000000000000011110";
sprite_fire0(31) <= "00111100000000000000000000111100";


sprite_fire1(0)  <= "11000011000000000000000011000011";
sprite_fire1(1)  <= "10000110000000000000000001100001";
sprite_fire1(2)  <= "00001100000000000000000000110000";
sprite_fire1(3)  <= "00011000000000000000000000011000";
sprite_fire1(4)  <= "00110000000000000000000000001100";
sprite_fire1(5)  <= "01100000000000000000000000000110";
sprite_fire1(6)  <= "11000000000000000000000000000011";
sprite_fire1(7)  <= "10000000000000000000000000000001";
sprite_fire1(8)  <= "00000000000000000000000000000000";
sprite_fire1(9)  <= "00000000000000000000000000000000";
sprite_fire1(10) <= "00000000000000000000000000000000";
sprite_fire1(11) <= "00000000000000000000000000000000";
sprite_fire1(12) <= "00000000000000000000000000000000";
sprite_fire1(13) <= "00000000000000000000000000000000";
sprite_fire1(14) <= "00000000000000000000000000000000";
sprite_fire1(15) <= "00000000000000000000000000000000";
sprite_fire1(16) <= "00000000000000000000000000000000";
sprite_fire1(17) <= "00000000000000000000000000000000";
sprite_fire1(18) <= "00000000000000000000000000000000";
sprite_fire1(19) <= "00000000000000000000000000000000";
sprite_fire1(20) <= "00000000000000000000000000000000";
sprite_fire1(21) <= "00000000000000000000000000000000";
sprite_fire1(22) <= "00000000000000000000000000000000";
sprite_fire1(23) <= "00000000000000000000000000000000";
sprite_fire1(24) <= "10000000000000000000000000000001";
sprite_fire1(25) <= "11000000000000000000000000000011";
sprite_fire1(26) <= "01100000000000000000000000000110";
sprite_fire1(27) <= "00110000000000000000000000001100";
sprite_fire1(28) <= "00011000000000000000000000011000";
sprite_fire1(29) <= "00001100000000000000000000110000";
sprite_fire1(30) <= "10000110000000000000000001100001";
sprite_fire1(31) <= "11000011000000000000000011000011";

--fire2 uses concrete 1 pattern

sprite_fireM0(0)  <= "11111111111111111111111111111111";
sprite_fireM0(1)  <= "11111111111111111111111111111111";
sprite_fireM0(2)  <= "00000000000000000000000000000000";
sprite_fireM0(3)  <= "00000000000000000000000000000000";
sprite_fireM0(4)  <= "00000000000000000000000000000000";
sprite_fireM0(5)  <= "00000000000000000000000000000000";
sprite_fireM0(6)  <= "00000000000000000000000000000000";
sprite_fireM0(7)  <= "00000000000000000000000000000000";
sprite_fireM0(8)  <= "00000000000000000000000000000000";
sprite_fireM0(9)  <= "00000000000000000000000000000000";
sprite_fireM0(10) <= "00000000000000000000000000000000";
sprite_fireM0(11) <= "00000000000000000000000000000000";
sprite_fireM0(12) <= "00000000000000000000000000000000";
sprite_fireM0(13) <= "00000000000000000000000000000000";
sprite_fireM0(14) <= "00000000000000000000000000000000";
sprite_fireM0(15) <= "00000000000000000000000000000000";
sprite_fireM0(16) <= "00000000000000000000000000000000";
sprite_fireM0(17) <= "00000000000000000000000000000000";
sprite_fireM0(18) <= "00000000000000000000000000000000";
sprite_fireM0(19) <= "00000000000000000000000000000000";
sprite_fireM0(20) <= "00000000000000000000000000000000";
sprite_fireM0(21) <= "00000000000000000000000000000000";
sprite_fireM0(22) <= "00000000000000000000000000000000";
sprite_fireM0(23) <= "00000000000000000000000000000000";
sprite_fireM0(24) <= "00000000000000000000000000000000";
sprite_fireM0(25) <= "00000000000000000000000000000000";
sprite_fireM0(26) <= "00000000000000000000000000000000";
sprite_fireM0(27) <= "00000000000000000000000000000000";
sprite_fireM0(28) <= "00000000000000000000000000000000";
sprite_fireM0(29) <= "00000000000000000000000000000000";
sprite_fireM0(30) <= "11111111111111111111111111111111";
sprite_fireM0(31) <= "11111111111111111111111111111111";


sprite_fireM1(0)  <= "00000000000000000000000000000000";
sprite_fireM1(1)  <= "00000000000000000000000000000000";
sprite_fireM1(2)  <= "11111111111111111111111111111111";
sprite_fireM1(3)  <= "11111111111111111111111111111111";
sprite_fireM1(4)  <= "11111111111111111111111111111111";
sprite_fireM1(5)  <= "11111111111111111111111111111111";
sprite_fireM1(6)  <= "00000000000000000000000000000000";
sprite_fireM1(7)  <= "00000000000000000000000000000000";
sprite_fireM1(8)  <= "00000000000000000000000000000000";
sprite_fireM1(9)  <= "00000000000000000000000000000000";
sprite_fireM1(10) <= "00000000000000000000000000000000";
sprite_fireM1(11) <= "00000000000000000000000000000000";
sprite_fireM1(12) <= "00000000000000000000000000000000";
sprite_fireM1(13) <= "00000000000000000000000000000000";
sprite_fireM1(14) <= "00000000000000000000000000000000";
sprite_fireM1(15) <= "00000000000000000000000000000000";
sprite_fireM1(16) <= "00000000000000000000000000000000";
sprite_fireM1(17) <= "00000000000000000000000000000000";
sprite_fireM1(18) <= "00000000000000000000000000000000";
sprite_fireM1(19) <= "00000000000000000000000000000000";
sprite_fireM1(20) <= "00000000000000000000000000000000";
sprite_fireM1(21) <= "00000000000000000000000000000000";
sprite_fireM1(22) <= "00000000000000000000000000000000";
sprite_fireM1(23) <= "00000000000000000000000000000000";
sprite_fireM1(24) <= "00000000000000000000000000000000";
sprite_fireM1(25) <= "00000000000000000000000000000000";
sprite_fireM1(26) <= "11111111111111111111111111111111";
sprite_fireM1(27) <= "11111111111111111111111111111111";
sprite_fireM1(28) <= "11111111111111111111111111111111";
sprite_fireM1(29) <= "11111111111111111111111111111111";
sprite_fireM1(30) <= "00000000000000000000000000000000";
sprite_fireM1(31) <= "00000000000000000000000000000000";

--fireM2 uses concrete 1 pattern

--brick code -- 000011
sprite_brick0(0)  <= "00000000000000000000000000000000";
sprite_brick0(1)  <= "00000000000000000000000000000000";
sprite_brick0(2)  <= "00000000000000000000000000000000";
sprite_brick0(3)  <= "00000000000000000000000000000000";
sprite_brick0(4)  <= "00000000000000000000000000000000";
sprite_brick0(5)  <= "00000000000000000000000000000000";
sprite_brick0(6)  <= "00000000000000000000000000000000";
sprite_brick0(7)  <= "00000000000000000000000000000000";
sprite_brick0(8)  <= "00000000000000000000000000000000";
sprite_brick0(9)  <= "00000000000000000000000000000000";
sprite_brick0(10) <= "00000000000000000000000000000000";
sprite_brick0(11) <= "00000000000000000000000000000000";
sprite_brick0(12) <= "00000000000000000000000000000000";
sprite_brick0(13) <= "00000000000000000000000000000000";
sprite_brick0(14) <= "00000000000000000000000000000000";
sprite_brick0(15) <= "00000000000000000000000000000000";
sprite_brick0(16) <= "00000000000000000000000000000000";
sprite_brick0(17) <= "00000000000000000000000000000000";
sprite_brick0(18) <= "00000000000000000000000000000000";
sprite_brick0(19) <= "00000000000000000000000000000000";
sprite_brick0(20) <= "00000000000000000000000000000000";
sprite_brick0(21) <= "00000000000000000000000000000000";
sprite_brick0(22) <= "00000000000000000000000000000000";
sprite_brick0(23) <= "11111111111111111111111111111110";
sprite_brick0(24) <= "11111111111111111111111111111110";
sprite_brick0(25) <= "11111111111111111111111111111110";
sprite_brick0(26) <= "11111111111111111111111111111110";
sprite_brick0(27) <= "11111111111111111111111111111110";
sprite_brick0(28) <= "11111111111111111111111111111110";
sprite_brick0(29) <= "11111111111111111111111111111110";
sprite_brick0(30) <= "11111111111111111111111111111110";
sprite_brick0(31) <= "11111111111111111111111111111110";

--brick1 uses concrete 1 pattern


sprite_brick2(0)  <= "11111111111111111111111111111111";
sprite_brick2(1)  <= "10000000000000000000000000000001";
sprite_brick2(2)  <= "10000000000000000000000000000001";
sprite_brick2(3)  <= "10000000000000000000000000000001";
sprite_brick2(4)  <= "10000000000000000000000000000001";
sprite_brick2(5)  <= "10000111111111111111111111100001";
sprite_brick2(6)  <= "10000100000000100010000000100001";
sprite_brick2(7)  <= "10000100000000010100000000100001";
sprite_brick2(8)  <= "10000110000000001000000000100001";
sprite_brick2(9)  <= "10000101000000000100000000100001";
sprite_brick2(10) <= "10000100100000000010000000100001";
sprite_brick2(11) <= "10000100010000000001000000100001";
sprite_brick2(12) <= "10000100001000000000100000100001";
sprite_brick2(13) <= "10000100000100000000010000100001";
sprite_brick2(14) <= "10000100001010000000001000100001";
sprite_brick2(15) <= "10000100010001000000000100100001";
sprite_brick2(16) <= "10000100100000100000000010100001";
sprite_brick2(17) <= "10000101000000010000000001100001";
sprite_brick2(18) <= "10000111111111111111111111100001";
sprite_brick2(19) <= "10000000000000000000000000000001";
sprite_brick2(20) <= "10000000000000000000000000000001";
sprite_brick2(21) <= "10000000000000000000000000000001";
sprite_brick2(22) <= "10000000000000000000000000000001";
sprite_brick2(23) <= "11111111111111111111111111111110";
sprite_brick2(24) <= "10000000001000000000010000000010";
sprite_brick2(25) <= "10000000001000000000010000000010";
sprite_brick2(26) <= "10000000001000000000010000000010";
sprite_brick2(27) <= "10000000001000000000010000000010";
sprite_brick2(28) <= "10000000001000000000010000000010";
sprite_brick2(29) <= "10000000001000000000010000000010";
sprite_brick2(30) <= "10000000001000000000010000000010";
sprite_brick2(31) <= "11111111111111111111111111111111";
  
  --background code -- 000000
--background0 uses concrete 1 pattern


sprite_background1(0)  <= "11111111111111111111111111111111";
sprite_background1(1)  <= "10000000000000000000000000000001";
sprite_background1(2)  <= "10000000000000000000000000000001";
sprite_background1(3)  <= "10000000000000000000000000000001";
sprite_background1(4)  <= "10000000000000000000000000000001";
sprite_background1(5)  <= "10000000000000000000000000000001";
sprite_background1(6)  <= "10000000000000000000000000000001";
sprite_background1(7)  <= "10000000000000000000000000000001";
sprite_background1(8)  <= "10000000000000000000000000000001";
sprite_background1(9)  <= "10000000000000000000000000000001";
sprite_background1(10) <= "11111111111111111111111111111111";
sprite_background1(11) <= "10000000000000000000000000000001";
sprite_background1(12) <= "10000000000000000000000000000001";
sprite_background1(13) <= "10000000000000000000000000000001";
sprite_background1(14) <= "10000000000000000000000000000001";
sprite_background1(15) <= "10000000000000000000000000000001";
sprite_background1(16) <= "10000000000000000000000000000001";
sprite_background1(17) <= "10000000000000000000000000000001";
sprite_background1(18) <= "10000000000000000000000000000001";
sprite_background1(19) <= "10000000000000000000000000000001";
sprite_background1(20) <= "10000000000000000000000000000001";
sprite_background1(21) <= "11111111111111111111111111111111";
sprite_background1(22) <= "10000000000000000000000000000001";
sprite_background1(23) <= "10000000000000000000000000000001";
sprite_background1(24) <= "10000000000000000000000000000001";
sprite_background1(25) <= "10000000000000000000000000000001";
sprite_background1(26) <= "10000000000000000000000000000001";
sprite_background1(27) <= "10000000000000000000000000000001";
sprite_background1(28) <= "10000000000000000000000000000001";
sprite_background1(29) <= "10000000000000000000000000000001";
sprite_background1(30) <= "10000000000000000000000000000001";
sprite_background1(31) <= "11111111111111111111111111111111";

   --powerup code -- 000100
sprite_powerup0(0)  <= "00000000000000000000000000000000";
sprite_powerup0(1)  <= "00000000000000000000000000000000";
sprite_powerup0(2)  <= "00000000000000000111111111111100";
sprite_powerup0(3)  <= "00000000000000011001110011001100";
sprite_powerup0(4)  <= "00000000000000110001100010001100";
sprite_powerup0(5)  <= "00000000000111100001000010001100";
sprite_powerup0(6)  <= "00000000001100000000000000001100";
sprite_powerup0(7)  <= "00000000111000000000000000001100";
sprite_powerup0(8)  <= "00000011100000000000000000001100";
sprite_powerup0(9)  <= "00000110000000000000000000001100";
sprite_powerup0(10) <= "00001100000000000000000000001100";
sprite_powerup0(11) <= "00011000000000000000000000001100";
sprite_powerup0(12) <= "00011000000000000000000000001100";
sprite_powerup0(13) <= "00011000000011000001100000001100";
sprite_powerup0(14) <= "00110000000011000001100000001100";
sprite_powerup0(15) <= "00110000000011000001100000001100";
sprite_powerup0(16) <= "00110000000011000001100000001100";
sprite_powerup0(17) <= "00110000000011000001100000001100";
sprite_powerup0(18) <= "00110000000011000001100000001100";
sprite_powerup0(19) <= "00110000000011000001100000001100";
sprite_powerup0(20) <= "00110000000000000000000000001100";
sprite_powerup0(21) <= "00110000000000000000000000001100";
sprite_powerup0(22) <= "00110000000111111111111000011000";
sprite_powerup0(23) <= "00001100000001111111100000110000";
sprite_powerup0(24) <= "00001100000001100001100001100000";
sprite_powerup0(25) <= "00001100000000110011000011000000";
sprite_powerup0(26) <= "00000110000000011110000110000000";
sprite_powerup0(27) <= "00000011000000000000001100000000";
sprite_powerup0(28) <= "00000001100000000000011000000000";
sprite_powerup0(29) <= "00000000011111111111110000000000";
sprite_powerup0(30) <= "00000000000000000000000000000000";
sprite_powerup0(31) <= "00000000000000000000000000000000";


sprite_powerup1(0)  <= "00000000000000000000000000000000";
sprite_powerup1(1)  <= "00000000000000000000000000000000";
sprite_powerup1(2)  <= "00111111111111111000000000000000";
sprite_powerup1(3)  <= "00111111111111100110001100110000";
sprite_powerup1(4)  <= "00111111111111001110001101110000";
sprite_powerup1(5)  <= "00111111111000011110011101110000";
sprite_powerup1(6)  <= "00111111110011111110111101110000";
sprite_powerup1(7)  <= "00111111000111111111111111110000";
sprite_powerup1(8)  <= "00111100011111111111111111110000";
sprite_powerup1(9)  <= "00111001111111111111111111110000";
sprite_powerup1(10) <= "00110011111111111111111111110000";
sprite_powerup1(11) <= "00100111111111111111111111110000";
sprite_powerup1(12) <= "00100111111111111111111111110000";
sprite_powerup1(13) <= "00100111111100111110011111110000";
sprite_powerup1(14) <= "00001111111100111110011111110000";
sprite_powerup1(15) <= "00001111111100111110011111110000";
sprite_powerup1(16) <= "00001111111100111110011111110000";
sprite_powerup1(17) <= "00001111111100111110011111110000";
sprite_powerup1(18) <= "00001111111100111110011111110000";
sprite_powerup1(19) <= "00001111111100111110011111110000";
sprite_powerup1(20) <= "00001111111111111111111111110000";
sprite_powerup1(21) <= "00001111111111111111111111110000";
sprite_powerup1(22) <= "00001111111000000000000111110000";
sprite_powerup1(23) <= "00110011111110000000011111100100";
sprite_powerup1(24) <= "00110011111110000000011111001100";
sprite_powerup1(25) <= "00110011111111000000111100111100";
sprite_powerup1(26) <= "00111100111111100001111001111100";
sprite_powerup1(27) <= "00111110011111111111110011111100";
sprite_powerup1(28) <= "00111111001111111111100111111100";
sprite_powerup1(29) <= "00111111100000000000001111111100";
sprite_powerup1(30) <= "00000000000000000000000000000000";
sprite_powerup1(31) <= "00000000000000000000000000000000";


sprite_powerup2(0)  <= "11111111111111111111111111111111";
sprite_powerup2(1)  <= "11111111111111111111111111111111";
sprite_powerup2(2)  <= "11000000000000000000000000000011";
sprite_powerup2(3)  <= "11000000000000000000000000000011";
sprite_powerup2(4)  <= "11000000000000000000000000000011";
sprite_powerup2(5)  <= "11000000000000000000000000000011";
sprite_powerup2(6)  <= "11000000000000000000000000000011";
sprite_powerup2(7)  <= "11000000000000000000000000000011";
sprite_powerup2(8)  <= "11000000000000000000000000000011";
sprite_powerup2(9)  <= "11000000000000000000000000000011";
sprite_powerup2(10) <= "11000000000000000000000000000011";
sprite_powerup2(11) <= "11000000000000000000000000000011";
sprite_powerup2(12) <= "11000000000000000000000000000011";
sprite_powerup2(13) <= "11000000000000000000000000000011";
sprite_powerup2(14) <= "11000000000000000000000000000011";
sprite_powerup2(15) <= "11000000000000000000000000000011";
sprite_powerup2(16) <= "11000000000000000000000000000011";
sprite_powerup2(17) <= "11000000000000000000000000000011";
sprite_powerup2(18) <= "11000000000000000000000000000011";
sprite_powerup2(19) <= "11000000000000000000000000000011";
sprite_powerup2(20) <= "11000000000000000000000000000011";
sprite_powerup2(21) <= "11000000000000000000000000000011";
sprite_powerup2(22) <= "11000000000000000000000000000011";
sprite_powerup2(23) <= "11000000000000000000000000000011";
sprite_powerup2(24) <= "11000000000000011110000000000011";
sprite_powerup2(25) <= "11000000000000001100000000000011";
sprite_powerup2(26) <= "11000000000000000000000000000011";
sprite_powerup2(27) <= "11000000000000000000000000000011";
sprite_powerup2(28) <= "11000000000000000000000000000011";
sprite_powerup2(29) <= "11000000000000000000000000000011";
sprite_powerup2(30) <= "11111111111111111111111111111111";
sprite_powerup2(31) <= "11111111111111111111111111111111";

  --bombup code -- 000101
sprite_bombup0(0)  <= "00000000000000000000000000000000";
sprite_bombup0(1)  <= "00000000000000000000000000000000";
sprite_bombup0(2)  <= "00000000000000000000000100001000";
sprite_bombup0(3)  <= "00000000000000000000000100011000";
sprite_bombup0(4)  <= "00000000011111111111100100011000";
sprite_bombup0(5)  <= "00000000111111000111111000011000";
sprite_bombup0(6)  <= "00000001111111000111111000011000";
sprite_bombup0(7)  <= "00000011111111000111111000011000";
sprite_bombup0(8)  <= "00000111110001111111111001111000";
sprite_bombup0(9)  <= "00001111000011111111111011111000";
sprite_bombup0(10) <= "00001111000111111111111111111100";
sprite_bombup0(11) <= "00011111000111111111111111111000";
sprite_bombup0(12) <= "00011100000111111111111111111100";
sprite_bombup0(13) <= "00111100001111111111111111111110";
sprite_bombup0(14) <= "00111100111111111111111111111110";
sprite_bombup0(15) <= "00111100111111111111111111111110";
sprite_bombup0(16) <= "00111100111111111111111111111110";
sprite_bombup0(17) <= "00111110111111111111111111111110";
sprite_bombup0(18) <= "00111111111111111111111111111110";
sprite_bombup0(19) <= "00111111111111111111111111111110";
sprite_bombup0(20) <= "00111111111111111111111111111110";
sprite_bombup0(21) <= "00011111111111111111111111111100";
sprite_bombup0(22) <= "00011111111111111111111111111000";
sprite_bombup0(23) <= "00001111111111111111111111111000";
sprite_bombup0(24) <= "00001111111111111111111111111000";
sprite_bombup0(25) <= "00000111111111111111111111100000";
sprite_bombup0(26) <= "00000011111111111111111111100000";
sprite_bombup0(27) <= "00000011111111111111111111100000";
sprite_bombup0(28) <= "00000001111111111111111110000000";
sprite_bombup0(29) <= "00000000111111111111111100000000";
sprite_bombup0(30) <= "00000000000000000000000000000000";
sprite_bombup0(31) <= "00001010000000000000000000000100";


sprite_bombup1(0)  <= "11111111111111111111111111111111";
sprite_bombup1(1)  <= "11111111111111111111111111111111";
sprite_bombup1(2)  <= "11111111111111111111111011110111";
sprite_bombup1(3)  <= "11111111111111111111111010000111";
sprite_bombup1(4)  <= "11111111111000000000011010000111";
sprite_bombup1(5)  <= "11111111100000111000000110000111";
sprite_bombup1(6)  <= "11111111000000101000000000100111";
sprite_bombup1(7)  <= "11111111000000101000000000100111";
sprite_bombup1(8)  <= "11111100001010000000000010011111";
sprite_bombup1(9)  <= "11110000111100000000000100000111";
sprite_bombup1(10) <= "11110000001000000000000000000111";
sprite_bombup1(11) <= "11110000001000000000000000000111";
sprite_bombup1(12) <= "11110010001000000000000000000111";
sprite_bombup1(13) <= "11000000000000000000000000000001";
sprite_bombup1(14) <= "11000000000000000000000000000001";
sprite_bombup1(15) <= "11000000000000000000000000000001";
sprite_bombup1(16) <= "11000000000000000000000000000001";
sprite_bombup1(17) <= "11000000000000000000000000000001";
sprite_bombup1(18) <= "11000000000000000000000000000001";
sprite_bombup1(19) <= "11000000000000000000000000000001";
sprite_bombup1(20) <= "11000000000000000000000000000001";
sprite_bombup1(21) <= "11110000000000000000000000000011";
sprite_bombup1(22) <= "11110000000000000000000000000111";
sprite_bombup1(23) <= "11110000000000000000000000000111";
sprite_bombup1(24) <= "11110000000000000000000000000111";
sprite_bombup1(25) <= "11111100000000000000000000011111";
sprite_bombup1(26) <= "11111100000000000000000000011111";
sprite_bombup1(27) <= "11111100000000000000000000011111";
sprite_bombup1(28) <= "11111111000000000000000001111111";
sprite_bombup1(29) <= "11111111000000000000000011111111";
sprite_bombup1(30) <= "11111111111111111111111111111111";
sprite_bombup1(31) <= "11110101111111111111111111111011";


sprite_bombup2(0)  <= "00000000000000000000000000000000";
sprite_bombup2(1)  <= "00000000000000000000000000000000";
sprite_bombup2(2)  <= "00000000000000000000000011110000";
sprite_bombup2(3)  <= "00000000000000000000000011100000";
sprite_bombup2(4)  <= "00000000000000000000011011100000";
sprite_bombup2(5)  <= "00000000000000111000000111100000";
sprite_bombup2(6)  <= "00000000000000111000000111000000";
sprite_bombup2(7)  <= "00000000000000111000000111000000";
sprite_bombup2(8)  <= "00000000001110000000000100010000";
sprite_bombup2(9)  <= "00000000111100000000000000000000";
sprite_bombup2(10) <= "00000000111000000000000000000000";
sprite_bombup2(11) <= "00000000111000000000000000000000";
sprite_bombup2(12) <= "00000011111000000000000000000000";
sprite_bombup2(13) <= "00000011110000000000000000000000";
sprite_bombup2(14) <= "00000011000000000000000000000000";
sprite_bombup2(15) <= "00000011000000000000000000000000";
sprite_bombup2(16) <= "00000011000000000000000000000000";
sprite_bombup2(17) <= "00000001000000000000000000000000";
sprite_bombup2(18) <= "00000000000000000000000000000000";
sprite_bombup2(19) <= "00000000000000000000000000000000";
sprite_bombup2(20) <= "00000000000000000000000000000000";
sprite_bombup2(21) <= "00000000000000000000000000000000";
sprite_bombup2(22) <= "00000000000000000000000000000000";
sprite_bombup2(23) <= "00000000000000000000000000000000";
sprite_bombup2(24) <= "00000000000000000000000000000000";
sprite_bombup2(25) <= "00000000000000000000000000000000";
sprite_bombup2(26) <= "00000000000000000000000000000000";
sprite_bombup2(27) <= "00000000000000000000000000000000";
sprite_bombup2(28) <= "00000000000000000000000000000000";
sprite_bombup2(29) <= "00000000000000000000000000000000";
sprite_bombup2(30) <= "00000000000000000000000000000000";
sprite_bombup2(31) <= "00000000000000000000000000000000";



sprite_bombup3(0)  <= "11111111111111111111111111111111";
sprite_bombup3(1)  <= "11111111111111111111111111111111";
sprite_bombup3(2)  <= "11000000000000000000000000000011";
sprite_bombup3(3)  <= "11000000000000000000000000000011";
sprite_bombup3(4)  <= "11000000000000000000000000000011";
sprite_bombup3(5)  <= "11000000000000000000000000000011";
sprite_bombup3(6)  <= "11000000000000000000000000000011";
sprite_bombup3(7)  <= "11000000000000000000000000000011";
sprite_bombup3(8)  <= "11000000000000000000000000000011";
sprite_bombup3(9)  <= "11000000000000000000000000000011";
sprite_bombup3(10) <= "11000000000000000000000000000011";
sprite_bombup3(11) <= "11000000000000000000000000000011";
sprite_bombup3(12) <= "11000000000000000000000000000011";
sprite_bombup3(13) <= "11000000000000000000000000000011";
sprite_bombup3(14) <= "11000000000000000000000000000011";
sprite_bombup3(15) <= "11000000000000000000000000000011";
sprite_bombup3(16) <= "11000000000000000000000000000011";
sprite_bombup3(17) <= "11000000000000000000000000000011";
sprite_bombup3(18) <= "11000000000000000000000000000011";
sprite_bombup3(19) <= "11000000000000000000000000000011";
sprite_bombup3(20) <= "11000000000000000000000000000011";
sprite_bombup3(21) <= "11000000000000000000000000000011";
sprite_bombup3(22) <= "11000000000000000000000000000011";
sprite_bombup3(23) <= "11000000000000000000000000000011";
sprite_bombup3(24) <= "11000000000000000000000000000011";
sprite_bombup3(25) <= "11000000000000000000000000000011";
sprite_bombup3(26) <= "11000000000000000000000000000011";
sprite_bombup3(27) <= "11000000000000000000000000000011";
sprite_bombup3(28) <= "11000000000000000000000000000011";
sprite_bombup3(29) <= "11000000000000000000000000000011";
sprite_bombup3(30) <= "11111111111111111111111111111111";
sprite_bombup3(31) <= "11111111111111111111111111111111";


  --speedup code -- 000110
sprite_speedup0(0)  <= "00000000000000000000000000000000";
sprite_speedup0(1)  <= "00000000000000000000000000000000";
sprite_speedup0(2)  <= "00000000000001111111111111000000";
sprite_speedup0(3)  <= "00000000000011111111111111100000";
sprite_speedup0(4)  <= "00000000000110000000000000110000";
sprite_speedup0(5)  <= "00000000000110000000000000110000";
sprite_speedup0(6)  <= "00000000000111111100000000110000";
sprite_speedup0(7)  <= "00000000000111111110000000110000";
sprite_speedup0(8)  <= "00000000000110000000000000110000";
sprite_speedup0(9)  <= "00000000000110000000000000110000";
sprite_speedup0(10) <= "00000000000111111100000000110000";
sprite_speedup0(11) <= "00000000000111111110000000110000";
sprite_speedup0(12) <= "00000000000110000000000000110000";
sprite_speedup0(13) <= "00000011111110000000000000110000";
sprite_speedup0(14) <= "00000110000000000000000000110000";
sprite_speedup0(15) <= "00001100000000000000000000110000";
sprite_speedup0(16) <= "00011000000000000000000000011100";
sprite_speedup0(17) <= "00110000000000000000000000001100";
sprite_speedup0(18) <= "00110000000000000000000000001100";
sprite_speedup0(19) <= "00110000000000000000000000001100";
sprite_speedup0(20) <= "00110000000000000000000000001100";
sprite_speedup0(21) <= "00110000000000000000000000001100";
sprite_speedup0(22) <= "00110000111110000000011111001100";
sprite_speedup0(23) <= "00110001100011000000110001101100";
sprite_speedup0(24) <= "00110111000001110011100000111000";
sprite_speedup0(25) <= "00001100011100011110001110001100";
sprite_speedup0(26) <= "00001100011100011110001110001100";
sprite_speedup0(27) <= "00000111000001110011100000111000";
sprite_speedup0(28) <= "00000001100011000000110001100000";
sprite_speedup0(29) <= "00000000111110000000011111000000";
sprite_speedup0(30) <= "00000000000000000000000000000000";
sprite_speedup0(31) <= "00000000000000000000000000000000";


sprite_speedup1(0)  <= "11111111111111111111111111111111";
sprite_speedup1(1)  <= "11111111111111111111111111111111";
sprite_speedup1(2)  <= "11111111111110000000000000111100";
sprite_speedup1(3)  <= "11111111111100000000000000011100";
sprite_speedup1(4)  <= "11111111111000000000000000001100";
sprite_speedup1(5)  <= "11111111111000000000000000001100";
sprite_speedup1(6)  <= "11111111111000000000000000001100";
sprite_speedup1(7)  <= "11111111111000000000000000001100";
sprite_speedup1(8)  <= "11111111111000000000000000001100";
sprite_speedup1(9)  <= "11111111111000000000000000001100";
sprite_speedup1(10) <= "11111111111000000000000000001100";
sprite_speedup1(11) <= "11111111111000000000000000001100";
sprite_speedup1(12) <= "11111100000000000000000000001100";
sprite_speedup1(13) <= "11110000000000000000000000001100";
sprite_speedup1(14) <= "11110000000000000000000000001100";
sprite_speedup1(15) <= "11100000000000000000000000001100";
sprite_speedup1(16) <= "11100000000000000000000000001100";
sprite_speedup1(17) <= "11000000000000000000000000000100";
sprite_speedup1(18) <= "11000000000000000000000000000000";
sprite_speedup1(19) <= "11000000000000000000000000000000";
sprite_speedup1(20) <= "11000000000000000000000000000000";
sprite_speedup1(21) <= "11000000000000000000000000000000";
sprite_speedup1(22) <= "11000000000000000000000000000000";
sprite_speedup1(23) <= "11000000000000000000000000000000";
sprite_speedup1(24) <= "11000000000000000000000000000100";
sprite_speedup1(25) <= "11110000000000000000000000000000";
sprite_speedup1(26) <= "11110000000000000000000000000000";
sprite_speedup1(27) <= "11111000000000001100000000000100";
sprite_speedup1(28) <= "11111110000000111111000000011111";
sprite_speedup1(29) <= "11111111000001111111100000111111";
sprite_speedup1(30) <= "00000000000000000000000000000000";
sprite_speedup1(31) <= "00000000000000000000000000000000";


sprite_speedup2(0)  <= "00000000000000000000000000000000";
sprite_speedup2(1)  <= "00000000000000000000000000000000";
sprite_speedup2(2)  <= "00000000000000000000000000000000";
sprite_speedup2(3)  <= "00000000000000000000000000000000";
sprite_speedup2(4)  <= "00000000000001111111111111000000";
sprite_speedup2(5)  <= "00000000000001111111111111000000";
sprite_speedup2(6)  <= "00000000000000000011111111000000";
sprite_speedup2(7)  <= "00000000000000000001111111000000";
sprite_speedup2(8)  <= "00000000000001111111111111000000";
sprite_speedup2(9)  <= "00000000000001111111111111000000";
sprite_speedup2(10) <= "00000000000000000011111111000000";
sprite_speedup2(11) <= "00000000000000000001111111000000";
sprite_speedup2(12) <= "00000000000001111111111111000000";
sprite_speedup2(13) <= "00000000000001111111111111000000";
sprite_speedup2(14) <= "00000001111111111111111111000000";
sprite_speedup2(15) <= "00000011111111111111111111100000";
sprite_speedup2(16) <= "00000111111111111111111111100000";
sprite_speedup2(17) <= "00001111111111111111111111110000";
sprite_speedup2(18) <= "00001111111111111111111111110000";
sprite_speedup2(19) <= "00001111111111111111111111110000";
sprite_speedup2(20) <= "00001111111111111111111111110000";
sprite_speedup2(21) <= "00001111111111111111111111110000";
sprite_speedup2(22) <= "00001111000001111111100000110000";
sprite_speedup2(23) <= "00001110011100111111001110000000";
sprite_speedup2(24) <= "00001000111110000000011111000000";
sprite_speedup2(25) <= "00000011100011100001110001110000";
sprite_speedup2(26) <= "00000011100011100001110001110000";
sprite_speedup2(27) <= "00000000111110000000011111000000";
sprite_speedup2(28) <= "00000000011100000000001110000000";
sprite_speedup2(29) <= "00000000000000000000000000000000";
sprite_speedup2(30) <= "00000000000000000000000000000000";
sprite_speedup2(31) <= "00000000000000000000000000000000";


sprite_speedup3(0)  <= "11111111111111111111111111111111";
sprite_speedup3(1)  <= "11111111111111111111111111111111";
sprite_speedup3(2)  <= "11000000000000000000000000000011";
sprite_speedup3(3)  <= "11000000000000000000000000000011";
sprite_speedup3(4)  <= "11000000000000000000000000000011";
sprite_speedup3(5)  <= "11000000000000000000000000000011";
sprite_speedup3(6)  <= "11000000000000000000000000000011";
sprite_speedup3(7)  <= "11000000000000000000000000000011";
sprite_speedup3(8)  <= "11000000000000000000000000000011";
sprite_speedup3(9)  <= "11000000000000000000000000000011";
sprite_speedup3(10) <= "11000000000000000000000000000011";
sprite_speedup3(11) <= "11000000000000000000000000000011";
sprite_speedup3(12) <= "11000000000000000000000000000011";
sprite_speedup3(13) <= "11000000000000000000000000000011";
sprite_speedup3(14) <= "11000000000000000000000000000011";
sprite_speedup3(15) <= "11000000000000000000000000000011";
sprite_speedup3(16) <= "11000000000000000000000000000011";
sprite_speedup3(17) <= "11000000000000000000000000000011";
sprite_speedup3(18) <= "11000000000000000000000000000011";
sprite_speedup3(19) <= "11000000000000000000000000000011";
sprite_speedup3(20) <= "11000000000000000000000000000011";
sprite_speedup3(21) <= "11000000000000000000000000000011";
sprite_speedup3(22) <= "11000000000000000000000000000011";
sprite_speedup3(23) <= "11000000000000000000000000000011";
sprite_speedup3(24) <= "11000000000000000000000000000011";
sprite_speedup3(25) <= "11000000000000000000000000000011";
sprite_speedup3(26) <= "11000000000000000000000000000011";
sprite_speedup3(27) <= "11000000000000000000000000000011";
sprite_speedup3(28) <= "11000000000000000000000000000011";
sprite_speedup3(29) <= "11000000000000000000000000000011";
sprite_speedup3(30) <= "11111111111111111111111111111111";
sprite_speedup3(31) <= "11111111111111111111111111111111";


  HCounter : process (clk_counter)
  begin
    if rising_edge(clk_counter) then      
      if reset = '1' then
        Hcount <= (others => '0');
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk_counter)
  begin
    if rising_edge(clk_counter) then      
      if reset = '1' then
        Vcount <= (others => '0');
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount <= (others => '0');
        else
          Vcount <= Vcount + 1;
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk_counter)
  begin
    if rising_edge(clk_counter) then     
      if reset = '1' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk_counter)
  begin
    if rising_edge(clk_counter) then
      if reset = '1' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk_counter)
  begin
    if rising_edge(clk_counter) then
      if reset = '1' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk_counter)
  begin
    if rising_edge(clk_counter) then    
      if reset = '1' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;
  
  Timergen : process(clk)
  variable counter : integer := 0;
  begin
    if rising_edge(clk) then
     if(gamestage = "0001") then 
      counter := counter + 1;          
      if counter >= 500000 then 
         counter := 0;    
         timer <= timer + 1;       
      end if;     
     else
         timer <= (others => '0');
      --   player1_pos <= "10";
      --   player2_pos <= "10";
     end if;
    end if;
  end process Timergen;

  -- Registered video signals going to the video DAC
  control: process (clk, reset)
  variable tilex : unsigned(6 downto 0);
  variable tiley : unsigned(4 downto 0);
  variable code  : unsigned(5 downto 0);
  variable player1_x_old : unsigned (9 downto 0);   -- the old x_pos of the player1
  variable player1_y_old : unsigned (9 downto 0);   -- the old y_pos of the player1
  variable player2_x_old : unsigned (9 downto 0);   -- the old x_pos of the player2
  variable player2_y_old : unsigned (9 downto 0);   -- the old y_pos of the player2
  variable player3_x_old : unsigned (9 downto 0);   -- the old x_pos of the player3
  variable player3_y_old : unsigned (9 downto 0);   -- the old y_pos of the player3
  variable player4_x_old : unsigned (9 downto 0);   -- the old x_pos of the player4
  variable player4_y_old : unsigned (9 downto 0);   -- the old y_pos of the player4

  begin
   if reset = '1' then

   elsif clk'event and clk = '1' then

    ----------address 0,1 11 for player1 x,y,states--------------------
    ----------address 2,3 12 for player2 x,y,states--------------------
    ----------address 4,5 13 for player3 x,y,states--------------------
    ----------address 6,7 14 for player4 x,y,states--------------------
    ----------address 9,10 for tile,time-------------------------------

    ---------------------write player1 position------------------------
    if (chipselect = '1' and write = '1' and address = "00000000") then
	 player1_x_old := player1_x(9 downto 0);
     player1_x <= writedata(9 downto 0);
		if (player1_x_old < writedata) then
		  player1_pos <= "11";
		elsif (player1_x_old > writedata) then
		  player1_pos <= "01";
		end if;
    end if;
    if (chipselect = '1' and write = '1' and address = "00000001") then
	  player1_y_old := player1_y(9 downto 0);
      player1_y <= writedata(9 downto 0);
		if (player1_y_old < writedata) then
		  player1_pos <= "10";
		elsif (player1_y_old > writedata) then
		  player1_pos <= "00";
		end if;
    end if;
    ---------------------write player2 position------------------------
    if (chipselect = '1' and write = '1' and address = "00000010") then
      player2_x_old := player2_x(9 downto 0);
	  player2_x <= writedata(9 downto 0);
		if (player2_x_old < writedata) then
		  player2_pos <= "11";
		elsif (player2_x_old > writedata) then
		  player2_pos <= "01";
		
		end if;
    end if;
    if (chipselect = '1' and write = '1' and address = "00000011") then
      player2_y_old := player2_y(9 downto 0);
	  player2_y <= writedata(9 downto 0);
		if (player2_y_old < writedata) then
		  player2_pos <= "10";
		elsif (player2_y_old > writedata) then
		  player2_pos <= "00";
		end if;
    end if;
    ---------------------write player3 position------------------------
    if (chipselect = '1' and write = '1' and address = "00000100") then
      player3_x_old := player3_x(9 downto 0);
	  player3_x <= writedata(9 downto 0);
		if (player3_x_old < writedata) then
		  player3_pos <= "11";
		elsif (player3_x_old > writedata) then
		  player3_pos <= "01";
		end if;
    end if;
    if (chipselect = '1' and write = '1' and address = "00000101") then
      player3_y_old := player3_y(9 downto 0);
	  player3_y <= writedata(9 downto 0);
		if (player3_y_old < writedata) then
		  player3_pos <= "10";
		elsif (player3_y_old > writedata) then
		  player3_pos <= "00";
		end if;
    end if;
    ---------------------write player4 position------------------------
    if (chipselect = '1' and write = '1' and address = "00000110") then
      player4_x_old := player4_x(9 downto 0);
	  player4_x <= writedata(9 downto 0);
		if (player4_x_old < writedata) then
		  player4_pos <= "11";
		elsif (player4_x_old > writedata) then
		  player4_pos <= "01";
		end if;
    end if;
    if (chipselect = '1' and write = '1' and address = "00000111") then
      player4_y_old := player4_y(9 downto 0);
	  player4_y <= writedata(9 downto 0);
		if (player4_y_old < writedata) then
		  player4_pos <= "10";
		elsif (player4_y_old > writedata) then
		  player4_pos <= "00";
		end if;
    end if;
    ---------------------set tiles' content---------------------------
    if (chipselect = '1' and write = '1' and address = "00001001") then      
     tilex(4 downto 0) := writedata(4 downto 0);
     tiley             := writedata(9 downto 5);--
     code(5 downto 0)  := writedata(15 downto 10);--
	 control_array(14-to_integer(unsigned(tiley)),119-to_integer(unsigned(((tilex sll 2) + tilex + tilex)+5))) <= code(0);
	 control_array(14-to_integer(unsigned(tiley)),119-to_integer(unsigned(((tilex sll 2) + tilex + tilex)+4))) <= code(1);
     control_array(14-to_integer(unsigned(tiley)),119-to_integer(unsigned(((tilex sll 2) + tilex + tilex)+3))) <= code(2);
     control_array(14-to_integer(unsigned(tiley)),119-to_integer(unsigned(((tilex sll 2) + tilex + tilex)+2))) <= code(3);
     control_array(14-to_integer(unsigned(tiley)),119-to_integer(unsigned(((tilex sll 2) + tilex + tilex)+1))) <= code(4);
     control_array(14-to_integer(unsigned(tiley)),119-to_integer(unsigned(((tilex sll 2) + tilex + tilex)+0))) <= code(5);
    end if;
    ---------------------set gamestage = 10   ------------------------
    if (chipselect = '1' and write = '1' and address = "00001010") then 
           gamestage <= writedata(3 downto 0);
    end if;
    ---------------------set player1 states address = 11--------------
    if (chipselect = '1' and write = '1' and address = "00001011") then 
           player1_s <= writedata(2 downto 0);
    end if;
    ---------------------set player2 states address = 12--------------
    if (chipselect = '1' and write = '1' and address = "00001100") then 
           player2_s <= writedata(2 downto 0);
    end if;
    ---------------------set player3 states address = 13--------------
    if (chipselect = '1' and write = '1' and address = "00001101") then 
           player3_s <= writedata(2 downto 0);
    end if;
    ---------------------set player4 states address = 14--------------
    if (chipselect = '1' and write = '1' and address = "00001110") then 
           player4_s <= writedata(2 downto 0);
    end if;
   
    if (chipselect = '1' and write = '1' and address = "00001111") then 
           pointer_y <= writedata(9 downto 0);
    end if;   
 
    ---------------------read current  time----------------------------
    if (chipselect = '1' and write = '1' and address = "00000000") then
       readdata(15 downto 0) <= timer(15 downto 0);
    end if;
    
     
  end if;
  end process control;


  VideoOut: process (clk_counter, reset)
  variable control_array_row    : unsigned (119 downto 0);
  variable sprite_background0_row : unsigned (31 downto 0);
  variable sprite_background1_row : unsigned (31 downto 0);
  variable sprite_concrete0_row : unsigned (31 downto 0);
  variable sprite_concrete1_row : unsigned (31 downto 0);
  variable sprite_concrete2_row : unsigned (31 downto 0);
  variable sprite_bomber0_row   : unsigned (31 downto 0);
  variable sprite_bomber1_row   : unsigned (31 downto 0);
  variable sprite_bomber2_row   : unsigned (31 downto 0);
  variable sprite_bomber3_row   : unsigned (31 downto 0);
  variable sprite_fire0_row     : unsigned (31 downto 0);
  variable sprite_fire1_row     : unsigned (31 downto 0);
  variable sprite_fire2_row 	: unsigned (31 downto 0);
  variable sprite_brick0_row    : unsigned (31 downto 0);
  variable sprite_brick1_row    : unsigned (31 downto 0);
  variable sprite_brick2_row    : unsigned (31 downto 0);
  variable sprite_powerup0_row  : unsigned (31 downto 0);
  variable sprite_powerup1_row  : unsigned (31 downto 0);
  variable sprite_powerup2_row  : unsigned (31 downto 0);
  variable sprite_bombup0_row   : unsigned (31 downto 0);
  variable sprite_bombup1_row   : unsigned (31 downto 0);
  variable sprite_bombup2_row   : unsigned (31 downto 0);
  variable sprite_bombup3_row   : unsigned (31 downto 0);
  variable sprite_bombup4_row   : unsigned (31 downto 0);
  variable sprite_speedup0_row  : unsigned (31 downto 0);
  variable sprite_speedup1_row  : unsigned (31 downto 0);
  variable sprite_speedup2_row  : unsigned (31 downto 0);
  variable sprite_speedup3_row  : unsigned (31 downto 0);
  variable sprite_bomberman0_row: unsigned (31 downto 0);
  variable sprite_bomberman1_row: unsigned (31 downto 0);
  variable sprite_bomberman2_row: unsigned (31 downto 0);
  variable sprite_bomberman3_row: unsigned (31 downto 0);
  variable sprite_bomberman4_row: unsigned (31 downto 0);

  variable sprite_bomberman20_row : unsigned (31 downto 0);
  variable sprite_bomberman21_row : unsigned (31 downto 0);
  variable sprite_bomberman22_row : unsigned (31 downto 0);
  variable sprite_bomberman23_row : unsigned (31 downto 0);
  variable sprite_bomberman24_row : unsigned (31 downto 0);

  variable sprite_bomberman30_row : unsigned (31 downto 0);
  variable sprite_bomberman31_row : unsigned (31 downto 0);
  variable sprite_bomberman32_row : unsigned (31 downto 0);
  variable sprite_bomberman33_row : unsigned (31 downto 0);
  variable sprite_bomberman34_row : unsigned (31 downto 0);


  variable sprite_bomberman40_row : unsigned (31 downto 0);
  variable sprite_bomberman41_row : unsigned (31 downto 0);
  variable sprite_bomberman42_row : unsigned (31 downto 0);
  variable sprite_bomberman43_row : unsigned (31 downto 0);
  variable sprite_bomberman44_row : unsigned (31 downto 0);
-------------------title_row logo_row pointer_low-----------------------------------------
  variable title_row    : unsigned (127 downto 0);
  variable pointer_row  : unsigned (15 downto 0);
  variable  sprite_bombermanlogo0_row : unsigned (199 downto 0);
  variable  sprite_bombermanlogo1_row : unsigned (199 downto 0);
  variable  sprite_bombermanlogo2_row : unsigned (199 downto 0);
  variable  sprite_bombermanlogo3_row : unsigned (199 downto 0);

---------------------------------------------------------------------
  variable control_array_V : unsigned (9 downto 0);
  variable control_array_H : unsigned (9 downto 0);
  variable player_array_V  : unsigned (9 downto 0);
  variable player_array_H  : unsigned (9 downto 0);
  variable sprite_array_V  : unsigned (9 downto 0);
  variable sprite_array_H  : unsigned (9 downto 0);

  variable sprite_player_V : unsigned (9 downto 0);
  variable sprite_player_H : unsigned (9 downto 0);

  variable sprite_player2_V: unsigned (9 downto 0);
  variable sprite_player2_H: unsigned (9 downto 0);

  variable sprite_player3_V: unsigned (9 downto 0);
  variable sprite_player3_H: unsigned (9 downto 0);

  variable sprite_player4_V: unsigned (9 downto 0);
  variable sprite_player4_H: unsigned (9 downto 0);

  variable ctrl_array_V: integer := to_integer(unsigned(14 - control_array_V));
  variable ctrl_array_H: integer := to_integer(unsigned(119 - ((control_array_H sll 2) + control_array_H + control_array_H)));

  variable temp_sprite_player_H  : unsigned (9 downto 0);
  variable temp_sprite_player2_H : unsigned (9 downto 0);
  variable temp_sprite_player3_H : unsigned (9 downto 0);
  variable temp_sprite_player4_H : unsigned (9 downto 0);
--------------------Sprite title V & H----------------------------
  variable sprite_title_V  : unsigned (9 downto 0);
  variable sprite_title_H  : unsigned (9 downto 0);
--------------------Sprite pointer V & H----------------------------
  variable sprite_pointer_V  : unsigned (9 downto 0);
  variable sprite_pointer_H  : unsigned (9 downto 0);
 --------------------Sprite logo V & H----------------------------
  variable sprite_bombermanlogo_V  : unsigned (9 downto 0);
  variable sprite_bombermanlogo_H  : unsigned (9 downto 0);

  variable titletempy : integer;
  variable titletempx : integer;
  variable logotempy : integer;
  variable logotempx : integer; 
  variable logoarray : integer; 
  variable player1tempx : integer; 
  variable player1tempy : integer;  
  variable player2tempx : integer; 
  variable player2tempy : integer;  
  variable player3tempx : integer; 
  variable player3tempy : integer;  
  variable player4tempx : integer; 
  variable player4tempy : integer;  
  begin
  
  if reset = '1' then
      VGA_R <= "0000000000";
      VGA_G <= "0000000000";
      VGA_B <= "0000000000";
  elsif clk_counter'event and clk_counter = '1' then  -- indicate rising edge
   control_array_V := (Vcount - (VSYNC + VBACK_PORCH)) srl 5;
   control_array_H := (Hcount - (HSYNC + HBACK_PORCH)) srl 5;

   player_array_V := (Vcount - (VSYNC + VBACK_PORCH));
   player_array_H := (Hcount - (HSYNC + HBACK_PORCH));
   sprite_array_V := (Vcount - (VSYNC + VBACK_PORCH)) AND "0000011111";
   sprite_array_H := (Hcount - (HSYNC + HBACK_PORCH)) AND "0000011111";
-------------------sprite title---------------------------------------------------------
   sprite_title_V  := (Vcount - (VSYNC + VBACK_PORCH) - title_y + 24) mod 48;-- doesn't work using AND "0000101111";
   sprite_title_H  := (Hcount - (HSYNC + HBACK_PORCH) - title_x + 64) AND "0001111111";
-------------------sprite pointer---------------------------------------------------------
   sprite_pointer_V  := (Vcount - (VSYNC + VBACK_PORCH) - pointer_y + 8) AND "0000001111";
   sprite_pointer_H  := (Hcount - (HSYNC + HBACK_PORCH) - pointer_x + 8) AND "0000001111";
-------------------sprite logo---------------------------------------------------------
   sprite_bombermanlogo_V  := (Vcount - (VSYNC + VBACK_PORCH) - logo_y + 100) mod 200;
   sprite_bombermanlogo_H  := (Hcount - (HSYNC + HBACK_PORCH) - logo_x + 100) mod 200;
-------------------player---------------------------------------------------------
   sprite_player_V  := (Vcount - (VSYNC + VBACK_PORCH) - player1_y+16) AND "0000011111";
   sprite_player_H  := (Hcount - (HSYNC + HBACK_PORCH) - player1_x+16) AND "0000011111";
   sprite_player2_V := (Vcount - (VSYNC + VBACK_PORCH) - player2_y+16) AND "0000011111";
   sprite_player2_H := (Hcount - (HSYNC + HBACK_PORCH) - player2_x+16) AND "0000011111"; 
   sprite_player3_V := (Vcount - (VSYNC + VBACK_PORCH) - player3_y+16) AND "0000011111";
   sprite_player3_H := (Hcount - (HSYNC + HBACK_PORCH) - player3_x+16) AND "0000011111"; 
   sprite_player4_V := (Vcount - (VSYNC + VBACK_PORCH) - player4_y+16) AND "0000011111";
   sprite_player4_H := (Hcount - (HSYNC + HBACK_PORCH) - player4_x+16) AND "0000011111"; 

---------------------------------------select pos for player1-------------------------------
  if(player1_pos = "10") then
    sprite_bomberman0_row := sprite_bomberman0(to_integer(unsigned(sprite_player_V)));
	sprite_bomberman1_row := sprite_bomberman1(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman2_row := sprite_bomberman2(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman3_row := sprite_bomberman3(to_integer(unsigned(sprite_player_V))); 
    sprite_bomberman4_row := sprite_bomberman4(to_integer(unsigned(sprite_player_V)));
	temp_sprite_player_H := 31 - sprite_player_H;
   elsif(player1_pos = "00") then
	sprite_bomberman0_row := sprite_bombermanB0(to_integer(unsigned(sprite_player_V)));
	sprite_bomberman1_row := sprite_bombermanB1(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman2_row := sprite_bombermanB2(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman3_row := sprite_bombermanB3(to_integer(unsigned(sprite_player_V))); 
    sprite_bomberman4_row := sprite_bombermanB4(to_integer(unsigned(sprite_player_V))); 
	temp_sprite_player_H := 31 - sprite_player_H;
   elsif(player1_pos = "01") then
	sprite_bomberman0_row := sprite_bombermanL0(to_integer(unsigned(sprite_player_V)));
	sprite_bomberman1_row := sprite_bombermanL1(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman2_row := sprite_bombermanL2(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman3_row := sprite_bombermanL3(to_integer(unsigned(sprite_player_V))); 
    sprite_bomberman4_row := sprite_bombermanL4(to_integer(unsigned(sprite_player_V))); 
	temp_sprite_player_H := 31 - sprite_player_H;
	elsif(player1_pos = "11") then
	sprite_bomberman0_row := sprite_bombermanL0(to_integer(unsigned(sprite_player_V)));
	sprite_bomberman1_row := sprite_bombermanL1(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman2_row := sprite_bombermanL2(to_integer(unsigned(sprite_player_V))); 
	sprite_bomberman3_row := sprite_bombermanL3(to_integer(unsigned(sprite_player_V))); 
    sprite_bomberman4_row := sprite_bombermanL4(to_integer(unsigned(sprite_player_V))); 
	temp_sprite_player_H := sprite_player_H;
   end if;
-------------------------------------select pos for player2-------------------------------
   if(player2_pos = "10") then
    sprite_bomberman20_row := sprite_bomberman0(to_integer(unsigned(sprite_player2_V)));
	sprite_bomberman21_row := sprite_bomberman1(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman22_row := sprite_bomberman2(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman23_row := sprite_bomberman3(to_integer(unsigned(sprite_player2_V))); 
    sprite_bomberman24_row := sprite_bomberman4(to_integer(unsigned(sprite_player2_V)));
	temp_sprite_player2_H := 31 - sprite_player2_H;
   elsif(player2_pos = "00") then
	sprite_bomberman20_row := sprite_bombermanB0(to_integer(unsigned(sprite_player2_V)));
	sprite_bomberman21_row := sprite_bombermanB1(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman22_row := sprite_bombermanB2(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman23_row := sprite_bombermanB3(to_integer(unsigned(sprite_player2_V))); 
    sprite_bomberman24_row := sprite_bombermanB4(to_integer(unsigned(sprite_player2_V))); 
	temp_sprite_player2_H := 31 - sprite_player2_H;
   elsif(player2_pos = "01") then
	sprite_bomberman20_row := sprite_bombermanL0(to_integer(unsigned(sprite_player2_V)));
	sprite_bomberman21_row := sprite_bombermanL1(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman22_row := sprite_bombermanL2(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman23_row := sprite_bombermanL3(to_integer(unsigned(sprite_player2_V))); 
    sprite_bomberman24_row := sprite_bombermanL4(to_integer(unsigned(sprite_player2_V))); 
	temp_sprite_player2_H := 31 - sprite_player2_H;
	elsif(player2_pos = "11") then
	sprite_bomberman20_row := sprite_bombermanL0(to_integer(unsigned(sprite_player2_V)));
	sprite_bomberman21_row := sprite_bombermanL1(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman22_row := sprite_bombermanL2(to_integer(unsigned(sprite_player2_V))); 
	sprite_bomberman23_row := sprite_bombermanL3(to_integer(unsigned(sprite_player2_V))); 
    sprite_bomberman24_row := sprite_bombermanL4(to_integer(unsigned(sprite_player2_V))); 
	temp_sprite_player2_H := sprite_player2_H;
   end if;
-------------------------------------select pos for player3-------------------------------
   if(player3_pos = "10") then
    sprite_bomberman30_row := sprite_bomberman0(to_integer(unsigned(sprite_player3_V)));
	sprite_bomberman31_row := sprite_bomberman1(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman32_row := sprite_bomberman2(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman33_row := sprite_bomberman3(to_integer(unsigned(sprite_player3_V))); 
    sprite_bomberman34_row := sprite_bomberman4(to_integer(unsigned(sprite_player3_V)));
	temp_sprite_player3_H := 31 - sprite_player3_H;
   elsif(player3_pos = "00") then
	sprite_bomberman30_row := sprite_bombermanB0(to_integer(unsigned(sprite_player3_V)));
	sprite_bomberman31_row := sprite_bombermanB1(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman32_row := sprite_bombermanB2(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman33_row := sprite_bombermanB3(to_integer(unsigned(sprite_player3_V))); 
    sprite_bomberman34_row := sprite_bombermanB4(to_integer(unsigned(sprite_player3_V))); 
	temp_sprite_player3_H := 31 - sprite_player3_H;
   elsif(player3_pos = "01") then
	sprite_bomberman30_row := sprite_bombermanL0(to_integer(unsigned(sprite_player3_V)));
	sprite_bomberman31_row := sprite_bombermanL1(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman32_row := sprite_bombermanL2(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman33_row := sprite_bombermanL3(to_integer(unsigned(sprite_player3_V))); 
    sprite_bomberman34_row := sprite_bombermanL4(to_integer(unsigned(sprite_player3_V))); 
	temp_sprite_player3_H := 31 - sprite_player3_H;
	elsif(player3_pos = "11") then
	sprite_bomberman30_row := sprite_bombermanL0(to_integer(unsigned(sprite_player3_V)));
	sprite_bomberman31_row := sprite_bombermanL1(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman32_row := sprite_bombermanL2(to_integer(unsigned(sprite_player3_V))); 
	sprite_bomberman33_row := sprite_bombermanL3(to_integer(unsigned(sprite_player3_V))); 
    sprite_bomberman34_row := sprite_bombermanL4(to_integer(unsigned(sprite_player3_V))); 
	temp_sprite_player3_H := sprite_player3_H;
   end if;
-------------------------------------select pos for player4-------------------------------
   if(player4_pos = "10") then
    sprite_bomberman40_row := sprite_bomberman0(to_integer(unsigned(sprite_player4_V)));
	sprite_bomberman41_row := sprite_bomberman1(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman42_row := sprite_bomberman2(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman43_row := sprite_bomberman3(to_integer(unsigned(sprite_player4_V))); 
    sprite_bomberman44_row := sprite_bomberman4(to_integer(unsigned(sprite_player4_V)));
	temp_sprite_player4_H := 31 - sprite_player4_H;
   elsif(player4_pos = "00") then
	sprite_bomberman40_row := sprite_bombermanB0(to_integer(unsigned(sprite_player4_V)));
	sprite_bomberman41_row := sprite_bombermanB1(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman42_row := sprite_bombermanB2(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman43_row := sprite_bombermanB3(to_integer(unsigned(sprite_player4_V))); 
    sprite_bomberman44_row := sprite_bombermanB4(to_integer(unsigned(sprite_player4_V))); 
	temp_sprite_player4_H := 31 - sprite_player4_H;
   elsif(player4_pos = "01") then
	sprite_bomberman40_row := sprite_bombermanL0(to_integer(unsigned(sprite_player4_V)));
	sprite_bomberman41_row := sprite_bombermanL1(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman42_row := sprite_bombermanL2(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman43_row := sprite_bombermanL3(to_integer(unsigned(sprite_player4_V))); 
    sprite_bomberman44_row := sprite_bombermanL4(to_integer(unsigned(sprite_player4_V))); 
	temp_sprite_player4_H := 31 - sprite_player4_H;
	elsif(player4_pos = "11") then
	sprite_bomberman40_row := sprite_bombermanL0(to_integer(unsigned(sprite_player4_V)));
	sprite_bomberman41_row := sprite_bombermanL1(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman42_row := sprite_bombermanL2(to_integer(unsigned(sprite_player4_V))); 
	sprite_bomberman43_row := sprite_bombermanL3(to_integer(unsigned(sprite_player4_V))); 
    sprite_bomberman44_row := sprite_bombermanL4(to_integer(unsigned(sprite_player4_V))); 
	temp_sprite_player4_H := sprite_player4_H;
   end if;

------------------------------------------title-----------------------------------------------------------------
title_row := title(to_integer(unsigned(47-sprite_title_V)));
pointer_row := pointer(to_integer(unsigned(15-sprite_pointer_V)));
titletempy := to_integer(player_array_V) - to_integer(title_y);
titletempx := to_integer(player_array_H) - to_integer(title_x);
logotempy := to_integer(player_array_V) - to_integer(logo_y);
logotempx := to_integer(player_array_H) - to_integer(logo_x);
logoarray := 199-to_integer(unsigned(sprite_bombermanlogo_H));
player1tempx := (to_integer(player_array_H) - to_integer(player1_x));
player1tempy := (to_integer(player_array_V) - to_integer(player1_y));
player2tempx := (to_integer(player_array_H) - to_integer(player2_x));
player2tempy := (to_integer(player_array_V) - to_integer(player2_y));
player3tempx := (to_integer(player_array_H) - to_integer(player3_x));
player3tempy := (to_integer(player_array_V) - to_integer(player3_y));
player4tempx := (to_integer(player_array_H) - to_integer(player4_x));
player4tempy := (to_integer(player_array_V) - to_integer(player4_y));
sprite_bombermanlogo0_row := sprite_bombermanlogo0(to_integer(unsigned(sprite_bombermanlogo_V)));
sprite_bombermanlogo1_row := sprite_bombermanlogo1(to_integer(unsigned(sprite_bombermanlogo_V)));
sprite_bombermanlogo2_row := sprite_bombermanlogo2(to_integer(unsigned(sprite_bombermanlogo_V)));
sprite_bombermanlogo3_row := sprite_bombermanlogo3(to_integer(unsigned(sprite_bombermanlogo_V)));
-----------------------------------player selecting------------------------------------------------------------
if (titletempy < 24 and titletempy > -24 and titletempx  < 64 and titletempx  > -64 and title_row(127-to_integer(unsigned(sprite_title_H))) = '1' and gamestage = "0000" and sprite_title_H < 128) then
	VGA_R <= "1111111111";
	VGA_G <= "1111111111";
	VGA_B <= "1111111111"; 
-----------------------------------pointer---------------------------------------------------------------------
elsif ((to_integer(player_array_V) - to_integer(pointer_y))< 8 and (to_integer(player_array_V) - to_integer(pointer_y)) > -8 and (to_integer(player_array_H) - to_integer(pointer_x)) < 8 and (to_integer(player_array_H) - to_integer(pointer_x)) > -8 and pointer_row(15-to_integer(unsigned(sprite_pointer_H))) = '1' and gamestage = "0000") then
	VGA_R <= "1111111111";
	VGA_G <= "1111111111";
	VGA_B <= "1111111111"; 
------------------------------------logo------------------------------------------------------------------------
elsif (logotempy < 100 and logotempy  > -100 and logotempx < 100 and logotempx > -100 and sprite_bombermanlogo0_row(logoarray) = '1' and gamestage = "0000") then
	VGA_R <= "0000000000";
	VGA_G <= "0000000000";
	VGA_B <= "0000000000"; 
elsif (logotempy < 100 and logotempy  > -100 and logotempx < 100 and logotempx > -100 and sprite_bombermanlogo1_row(logoarray) = '1' and gamestage = "0000") then
	VGA_R <= "1110000000";
	VGA_G <= "0000000000";
	VGA_B <= "0000000000"; 
elsif (logotempy < 100 and logotempy  > -100 and logotempx < 100 and logotempx > -100 and sprite_bombermanlogo2_row(logoarray) = '1' and gamestage = "0000") then
	VGA_R <= "1111111111";
	VGA_G <= "1111111111";
	VGA_B <= "0000000000"; 	
elsif (logotempy < 100 and logotempy  > -100 and logotempx < 100 and logotempx > -100 and sprite_bombermanlogo3_row(logoarray) = '1' and gamestage = "0000") then
	VGA_R <= "1111111111";
	VGA_G <= "1111111111";
	VGA_B <= "1111111111";	

---------------------------------player1-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
elsif (player1tempy < 16 and player1tempy  > -16 and player1tempx < 16 and player1tempx  > -16 and sprite_bomberman0_row(to_integer(temp_sprite_player_H)) = '1' and player1_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";
VGA_B <= "0000000000"; 
elsif (player1tempy < 16 and player1tempy > -16 and player1tempx < 16 and player1tempx > -16 and sprite_bomberman1_row(to_integer(temp_sprite_player_H)) = '1' and player1_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "0100010100";	
VGA_B <= "0100010110";

elsif (player1tempy < 16 and player1tempy > -16 and player1tempx < 16 and player1tempx > -16 and sprite_bomberman2_row(to_integer(temp_sprite_player_H)) = '1' and player1_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "1101111000";
VGA_B <= "1010110100";
 
elsif (player1tempy < 16 and player1tempy > -16 and player1tempx < 16 and player1tempx > -16 and sprite_bomberman3_row(to_integer(temp_sprite_player_H)) = '1' and player1_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "1111111111";
VGA_B <= "1111111111";

elsif (player1tempy < 16 and player1tempy > -16 and player1tempx < 16 and player1tempx > -16 and sprite_bomberman4_row(to_integer(temp_sprite_player_H)) = '1' and player1_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";	
VGA_B <= "1111000000";
---------------------------------player2-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
elsif (player2tempy  < 16 and player2tempy > -16 and player2tempx < 16 and player2tempx > -16 and sprite_bomberman20_row(to_integer(temp_sprite_player2_H)) = '1' and player2_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";
VGA_B <= "0000000000"; 
elsif (player2tempy < 16 and player2tempy > -16 and player2tempx < 16 and player2tempx > -16 and sprite_bomberman21_row(to_integer(temp_sprite_player2_H)) = '1' and player2_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "0100010100";	
VGA_B <= "0100010110";

elsif (player2tempy < 16 and player2tempy > -16 and player2tempx < 16 and player2tempx > -16 and sprite_bomberman22_row(to_integer(temp_sprite_player2_H)) = '1' and player2_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "1101111000";
VGA_B <= "1010110100";
 
elsif (player2tempy < 16 and player2tempy > -16 and player2tempx < 16 and player2tempx > -16 and sprite_bomberman23_row(to_integer(temp_sprite_player2_H)) = '1' and player2_s = "000" and gamestage = playing) then
VGA_R <= "0100000000";
VGA_G <= "0100000000";
VGA_B <= "0100000000";

elsif (player2tempy < 16 and player2tempy > -16 and player2tempx < 16 and player2tempx > -16 and sprite_bomberman24_row(to_integer(temp_sprite_player2_H)) = '1' and player2_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";	
VGA_B <= "1111000000";
---------------------------------player3-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
elsif (player3tempy < 16 and player3tempy > -16 and player3tempx < 16 and player3tempx > -16 and sprite_bomberman30_row(to_integer(temp_sprite_player3_H)) = '1' and player3_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";
VGA_B <= "0000000000"; 
elsif (player3tempy < 16 and player3tempy > -16 and player3tempx < 16 and player3tempx > -16 and sprite_bomberman31_row(to_integer(temp_sprite_player3_H)) = '1' and player3_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "0100010100";	
VGA_B <= "0100010110";

elsif (player3tempy < 16 and player3tempy > -16 and player3tempx < 16 and player3tempx > -16 and sprite_bomberman32_row(to_integer(temp_sprite_player3_H)) = '1' and player3_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "1101111000";
VGA_B <= "1010110100";
 
elsif (player3tempy < 16 and player3tempy > -16 and player3tempx < 16 and player3tempx > -16 and sprite_bomberman33_row(to_integer(temp_sprite_player3_H)) = '1' and player3_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "1111111111";
VGA_B <= "0000000000";

elsif (player3tempy < 16 and player3tempy > -16 and player3tempx < 16 and player3tempx > -16 and sprite_bomberman34_row(to_integer(temp_sprite_player3_H)) = '1' and player3_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";	
VGA_B <= "1111000000";
---------------------------------player4-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
elsif (player4tempy < 16 and player4tempy > -16 and player4tempx < 16 and player4tempx > -16 and sprite_bomberman40_row(to_integer(temp_sprite_player4_H)) = '1' and player4_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";
VGA_B <= "0000000000"; 
elsif (player4tempy < 16 and player4tempy > -16 and player4tempx < 16 and player4tempx > -16 and sprite_bomberman41_row(to_integer(temp_sprite_player4_H)) = '1' and player4_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "0100010100";	
VGA_B <= "0100010110";

elsif (player4tempy < 16 and player4tempy > -16 and player4tempx < 16 and player4tempx > -16 and sprite_bomberman42_row(to_integer(temp_sprite_player4_H)) = '1' and player4_s = "000" and gamestage = playing) then
VGA_R <= "1111111111";
VGA_G <= "1101111000";
VGA_B <= "1010110100";
 
elsif (player4tempy < 16 and player4tempy > -16 and player4tempx < 16 and player4tempx > -16 and sprite_bomberman43_row(to_integer(temp_sprite_player4_H)) = '1' and player4_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "1111111111";
VGA_B <= "1111111111";

elsif (player4tempy < 16 and player4tempy > -16 and player4tempx < 16 and player4tempx > -16 and sprite_bomberman44_row(to_integer(temp_sprite_player4_H)) = '1' and player4_s = "000" and gamestage = playing) then
VGA_R <= "0000000000";
VGA_G <= "0000000000";	
VGA_B <= "1111000000";
----------------------------------concrete---------------------------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '1' and control_array(ctrl_array_V,ctrl_array_H - 1) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '1' and control_array_V <= 14 and control_array_H  <= 19 and gamestage = playing) then
    sprite_concrete0_row := sprite_concrete0(to_integer(sprite_array_V));
    sprite_concrete1_row := sprite_concrete1(to_integer(sprite_array_V));
    sprite_concrete2_row := sprite_concrete2(to_integer(sprite_array_V));
     if (sprite_concrete1_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1011111000";
     VGA_G <= "1011111000";
     VGA_B <= "1011111000";
     end if; 
     if (sprite_concrete0_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0110100100";
     VGA_G <= "0110100100";
     VGA_B <= "0110100100";
     end if;
     if (sprite_concrete2_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";
    end if; 
------------------------------bomber-----------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '0' and control_array(ctrl_array_V,ctrl_array_H - 1) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '1' and control_array_V <= 14 and control_array_H <= 19 and gamestage = playing) then
    sprite_bomber0_row := sprite_bomber0(to_integer(sprite_array_V));
	sprite_bomber1_row := sprite_bomber1(to_integer(sprite_array_V));
	sprite_bomber2_row := sprite_bomber2(to_integer(sprite_array_V));
	sprite_bomber3_row := sprite_bomber3(to_integer(sprite_array_V));
    if (sprite_bomber1_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1011100000";
     VGA_G <= "1000011000";
     VGA_B <= "0000101100";    
    end if;
    if (sprite_bomber0_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";	
     VGA_B <= "0000000000";
    end if;
    if (sprite_bomber2_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1101001100";
     VGA_G <= "1101001100";
     VGA_B <= "1101001100";
    end if;
    if (sprite_bomber3_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";
    end if; 	
----------------------------fire--------------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '0' and control_array(ctrl_array_V,ctrl_array_H - 1) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '0' and control_array_V <= 14 and control_array_H <= 19 and gamestage = playing) then
	sprite_fire0_row := sprite_fire0(to_integer(unsigned(sprite_array_V)));
	sprite_fire1_row := sprite_fire1(to_integer(unsigned(sprite_array_V)));
	sprite_fire2_row := sprite_concrete1(to_integer(unsigned(sprite_array_V)));
    if (sprite_fire2_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "1111111111";
     VGA_B <= "0011111111";
    end if;	
    if (sprite_fire0_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1000000000";
     VGA_G <= "0000000000";	
     VGA_B <= "0000000000";
    end if;
    if (sprite_fire1_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "0010000000";	
     VGA_B <= "0000000000";    
    end if;

--------------------------brick-------------------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '0' and control_array(ctrl_array_V,ctrl_array_H - 1) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '1' and control_array_V <= 14 and control_array_H <= 19 and gamestage = playing) then
    sprite_brick0_row := sprite_brick0(to_integer(unsigned(sprite_array_V)));
	sprite_brick1_row := sprite_concrete1(to_integer(unsigned(sprite_array_V)));
	sprite_brick2_row := sprite_brick2(to_integer(unsigned(sprite_array_V)));
    if (sprite_brick1_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "1100000100";
     VGA_B <= "0010010100";
    end if;
    if (sprite_brick0_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1000101100";
     VGA_G <= "0110100100";
     VGA_B <= "0001010000";
    end if;
    if (sprite_brick2_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";
     end if;
------------------------powerup---------------------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '0' and control_array(ctrl_array_V,ctrl_array_H - 1) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '0' and control_array_V <= 14 and control_array_H <= 19 and gamestage = playing) then
	sprite_powerup0_row := sprite_powerup0(to_integer(unsigned(sprite_array_V)));
	sprite_powerup1_row := sprite_powerup1(to_integer(unsigned(sprite_array_V)));
	sprite_powerup2_row := sprite_powerup2(to_integer(unsigned(sprite_array_V)));
    if (sprite_powerup0_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";	
     VGA_B <= "0000000000";
    elsif (sprite_powerup1_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "1111111111";
     VGA_B <= "0000000000";
    else
     VGA_R <= "1111111111";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";
    end if; 	
-----------------------bombup-----------------------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '0' and control_array(ctrl_array_V,ctrl_array_H - 1) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '1' and control_array_V <= 14 and control_array_H <= 19 and gamestage = playing) then
	sprite_bombup0_row := sprite_bombup0(to_integer(unsigned(sprite_array_V)));
	sprite_bombup1_row := sprite_bombup1(to_integer(unsigned(sprite_array_V)));
	sprite_bombup2_row := sprite_bombup2(to_integer(unsigned(sprite_array_V)));
	sprite_bombup3_row := sprite_bombup3(to_integer(unsigned(sprite_array_V)));
    if (sprite_bombup0_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";	
     VGA_B <= "0000000000";
     end if;
     if (sprite_bombup1_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0110011000";
     VGA_G <= "1100110100";
     VGA_B <= "0000000000";
     end if;
     if (sprite_bombup2_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1101001100";
     VGA_G <= "1101001100";
     VGA_B <= "1101001100";
     end if;
     if (sprite_bombup3_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";
     end if; 	
--------------------speedup---------------------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '0' and control_array(ctrl_array_V,ctrl_array_H - 1) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '1' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '0' and control_array_V <= 14 and control_array_H <= 19 and gamestage = playing) then
    sprite_speedup0_row := sprite_speedup0(to_integer(unsigned(sprite_array_V)));
	sprite_speedup1_row := sprite_speedup1(to_integer(unsigned(sprite_array_V)));
	sprite_speedup2_row := sprite_speedup2(to_integer(unsigned(sprite_array_V)));
	sprite_speedup3_row := sprite_speedup3(to_integer(unsigned(sprite_array_V)));
    if (sprite_speedup1_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0110011000";
     VGA_G <= "1100110100";
     VGA_B <= "0000000000";
     end if; 
     if (sprite_speedup2_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "1111111111";
     VGA_B <= "1111111111";
     end if; 
     if (sprite_speedup3_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "1111111111";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";
     end if; 
     if (sprite_speedup0_row(to_integer(unsigned(31 - sprite_array_H))) = '1') then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";	
     VGA_B <= "0000000000";
     end if; 	
-----------------------------background--------------------------------------------------------
elsif (control_array(ctrl_array_V,ctrl_array_H - 0) = '0' and control_array(ctrl_array_V,ctrl_array_H - 1) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 2) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 3) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 4) = '0' and control_array(ctrl_array_V,ctrl_array_H  - 5) = '0' and control_array_V <= 14 and control_array_H < 19 and gamestage = playing) then
	sprite_background0_row := sprite_concrete1(to_integer(unsigned(sprite_array_V)));
	sprite_background1_row := sprite_background1(to_integer(unsigned(sprite_array_V)));
     if (sprite_background0_row(to_integer(unsigned(31 - sprite_array_H))) =  '1') then
     VGA_R <= "1011100000";
     VGA_G <= "1000011000";
     VGA_B <= "0000101100";
     end if;
     if (sprite_background1_row(to_integer(unsigned(31 - sprite_array_H))) =  '1') then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";
     end if;

--------------------------edge------------------------
elsif vga_hblank = '0' and vga_vblank ='0' then
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000"; 
else
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";
     VGA_B <= "0000000000";    
end if;
   
end if;

end process VideoOut;

  VGACLK_GEN: process(clk)
begin
  if rising_edge(clk) then
clk_counter <= not(clk_counter);
  end if;
end process VGACLK_GEN;

  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);
  VGA_CLK <= clk_counter;
end rtl;
