#ifndef TANK_H_
#define TANK_H_

unsigned int indexOfTank = 0;

unsigned int turnLeft(unsigned int tank)
{
    if ((DIR(tank))==UP)
        return setDir(LF,tank);
    else if ((DIR(tank))==DN)
        return setDir(RT,tank);
    else if ((DIR(tank))==LF)
        return setDir(DN,tank);
    else if ((DIR(tank))==RT)
        return setDir(UP,tank); 
}

unsigned int turnRight(unsigned int tank)
{
    if ((DIR(tank))==UP)
        return setDir(RT,tank);
    else if ((DIR(tank))==DN)
        return setDir(LF,tank);
    else if ((DIR(tank))==LF)
        return setDir(UP,tank);
    else if ((DIR(tank))==RT)
        return setDir(DN,tank); 
}

unsigned int turnAround(unsigned int tank)
{
    if ((DIR(tank))==UP)
        return setDir(DN,tank);
    else if ((DIR(tank))==DN)
        return setDir(UP,tank);
    else if ((DIR(tank))==LF)
        return setDir(RT,tank);
    else if ((DIR(tank))==RT)
        return setDir(LF,tank); 
}

void generateTank()
{
    //used to control the generating rate
    if (counterEnable&(1<<31))
        return;
    else if (generateTankCounter<500)
    {
        generateTankCounter++;
        counterEnable |= (1<<31);
        bulletCounterSet();
        return;
    }
    counterEnable |= (1<<31);
    bulletCounterSet();
    generateTankCounter=0;
    
    unsigned int tank = 0;
    unsigned int random = rand()%100;
    //unsigned int random = 20;
    if (random<30 && existTank(0,0)==-3)//generate the tank at the left born point
    {
        tank = setPos(0,0,tank);
        //printf("A tank is generated at left born point!\n");
    }
    else if (random<60 && existTank(432,0)==-3)//generate the tank at the right born point
    {
        tank = setPos(432,0,tank); 
        //printf("A tank is generated at right born point!\n");
    }
    else if (existTank(216,0)==-3)//generate the tank at the middle born point
    {
        tank = setPos(216,0,tank);
        //printf("A tank is generated at middle born point!\n");
    }
    else
        return;
        
    //let the tank face downward    
    tank = setDir(DN,tank);
    
    int i;
    for (i=0;i<MAXTANK;i++)//insert this tank into the list
    {
        if (tanks[i]==tankInit)//tanks[i] is empty
        {
            tanks[i]=tank;
            //printf("tankIndex=%d\n",i);
            numOfTank++;
            tankNum++;
            int randTemp = rand()%100;
            if (difficulty==1)
                randTemp = rand()%300;
            if (randTemp<40)
            {
                writeSprite(tank, BASIC_TANK, GREY, i);
                tankLevel[i]=BASIC_TANK;
            }
            else if (randTemp<80)
            {
                writeSprite(tank, POWER_TANK, GREY, i);
                tankLevel[i]=POWER_TANK;
            }
            else
            {
                writeSprite(tank, SUPER_TANK, GREY, i);
                tankLevel[i]=SUPER_TANK;
            }
            break;
        }
    }
}

int eatPowerup(unsigned int sprite)
{
    if(insideTank(powerup, X(sprite), Y(sprite)) || insideTank(powerup, (X(sprite))+35, Y(sprite)) 
    || insideTank(powerup, X(sprite), (Y(sprite))+35) || insideTank(powerup, (X(sprite))+35, (Y(sprite))+35))
        return 1;
    else
        return 0;
}

void powerUp(unsigned int sprite,unsigned int tankIndex)
{
    powerup = tankInit;
    writeSprite(powerup,POWERUP,GREY,14);
    int random = rand()%100;
    if (random<30)//change the base
    {
       if (sprite==player1)
       {
           scenario[12][5]=0xa2;
           scenario[11][5]=0x82;
           scenario[11][6]=0xc2;
           scenario[11][7]=0x42;
           scenario[12][7]=0x52;
       }
       else
       {
           scenario[12][5]=0x00;
           scenario[11][5]=0x00;
           scenario[11][6]=0x00;
           scenario[11][7]=0x00;
           scenario[12][7]=0x00;
       }
       writeScenario(12,5);
       writeScenario(12,5);
       writeScenario(11,5);
       writeScenario(11,5);
       writeScenario(11,6);
       writeScenario(11,6);
       writeScenario(11,7);
       writeScenario(11,7);
       writeScenario(12,7);
       writeScenario(12,7);
    }
    else if (random<60)//level up
    {
        if (sprite==player1)
        {
            if (player1Level==PLAYER1)
                player1Level = PLY1;
            else if (player1Level==PLY1)
                player1Level = PLY2;
        }
        else if(tankLevel[tankIndex]==BASIC_TANK)
        {
            tankLevel[tankIndex]=POWER_TANK;
        }
        else if(tankLevel[tankIndex]==POWER_TANK)
        {
            tankLevel[tankIndex]=SUPER_TANK;
        }
    }
    else//freeze the tank
    {
        if (sprite==player1)
        {
            tankStop=50000;
        }
        else
        {
            player1Stop=80;
        }
    }
}

void updatePlayer1()
{
    if (tankEnable&(1<<MAXTANK))
        return;
    tankEnable |= (1<<MAXTANK);  
    tankCounterSet();
    
    if (player1Stop>0)
    {
        player1Stop--;
        return;
    }
    
    switch(currentDir)
    {
        case LF: 
            player1 = setDir(LF,player1);
            if (canMoveLeft(player1))
            {
                player1 = decX(step,player1);
            }
            writeSprite(player1, player1Level, GREY,15);
            break;
        case UP:
            player1 = setDir(UP,player1);
            if (canMoveUp(player1))
            {
                player1 = decY(step,player1);
            }
            writeSprite(player1, player1Level, GREY,15);
            break;
        case RT:
            player1 = setDir(RT,player1);
            if (canMoveRight(player1))
            {
                player1 = incX(step,player1);
            }
            writeSprite(player1, player1Level, GREY,15);
            break;
        case DN:
            player1 = setDir(DN,player1);
            if (canMoveDown(player1))
            {
                player1 = incY(step,player1);
            }
            writeSprite(player1, player1Level, GREY,15);
            break;
    }
    if (fireFlag)
        fireBullet(player1,MAXBULLET-1);
    if (eatPowerup(player1))
        powerUp(player1,15);
}

void generatePowerup()
{
    if (counterEnable&(1<<29))
        return;
    else if (generatePowerupCounter<500)
    {
        generatePowerupCounter++;
        counterEnable |= (1<<29);
        bulletCounterSet();
        return;
    }
    counterEnable |= (1<<29);
    bulletCounterSet();
    generatePowerupCounter=0;
    
    powerup = setPos(rand()%400,rand()%400,powerup);
    powerup = setDir(DN, powerup);
    writeSprite(powerup,POWERUP,GREY,14);
}

//update all enemy tanks, change directions and fire bullets
//generate enemy tanks under proper condition
void updateTanks()
{        
    unsigned int i;
    if (numOfTank<MAXENEMY && tankNum<MAXTANK)
        generateTank();
        
    if (rand()%100<2 && powerup==tankInit)
        generatePowerup();
        
    if (tankStop>0)
    {
        tankStop--;
        return;
    }
        
    if (++musicCounter>5000)
    {
        playInit();
        musicCounter = 0;
    }
            
    for (i=0;i<MAXTANK;i++)//loop for each tank
    {
        if (tanks[i]!=tankInit)//tank[i] is not empty, then process it
        {
            if (tankEnable&(1<<i))
                continue;
            tankEnable |= (1<<i);  
            tankCounterSet();
            
            int mod = 100;
            int upFlag = canMoveUp(tanks[i]);
            int downFlag = canMoveDown(tanks[i]);
            int leftFlag = canMoveLeft(tanks[i]);
            int rightFlag = canMoveRight(tanks[i]);
            
            if (upFlag+downFlag+leftFlag+rightFlag>3)//there are four ways, decrease possibility of turning
                mod = 2000;
            int random = rand()%mod;
            if (upFlag+downFlag+leftFlag+rightFlag==1)//only one way, turn around
            {
                if ((DIR(tanks[i]))==UP && downFlag)
                    tanks[i]=turnAround(tanks[i]);
                if ((DIR(tanks[i]))==DN && upFlag)
                    tanks[i]=turnAround(tanks[i]);
                if ((DIR(tanks[i]))==LF && rightFlag)
                    tanks[i]=turnAround(tanks[i]);
                if ((DIR(tanks[i]))==RT && leftFlag)
                    tanks[i]=turnAround(tanks[i]);
            }
            else if (random<30)//turn left
            {
                int flag = 0;
                switch(DIR(tanks[i]))
                {
                    case LF:  flag = downFlag;     break;
                    case RT: flag = upFlag;         break;
                    case DN: flag = rightFlag;      break;
                    case UP: flag = leftFlag;        break;
                }
                if (flag)
                    tanks[i]=turnLeft(tanks[i]);
                else if (rand()%100<5)
                    tanks[i]=turnLeft(tanks[i]);
            }
            else if (random<60)//turn right
            {
                int flag = 0;
                switch(DIR(tanks[i]))
                {
                    case LF:  flag = upFlag;     break;
                    case RT: flag = downFlag; break;
                    case DN: flag = leftFlag;   break;
                    case UP: flag = rightFlag;  break;
                }
                if (flag)
                    tanks[i]=turnRight(tanks[i]);
                else if (rand()%100<5)
                    tanks[i]=turnRight(tanks[i]);
            }
            else if (random<80 && tankLevel[i]!=SUPER_TANK)
                fireBullet(tanks[i],i);
            if (tankLevel[i]==SUPER_TANK)
                fireBullet(tanks[i],i);
            switch (DIR(tanks[i]))
            {
                case LF:      //'a', move left
                    if (leftFlag)
                    {
                        tanks[i] = decX(step,tanks[i]);
                    }
                    break;
                case UP:      //'w', move up
                    if (upFlag)
                    {
                        tanks[i] = decY(step,tanks[i]);
                    }
                    break;
                case RT:      //'d', move right
                    if (rightFlag)
                    {
                        tanks[i] = incX(step,tanks[i]);
                    }
                    break;
                case DN:      //'s', move down
                    if (downFlag)
                    {
                        tanks[i] = incY(step,tanks[i]);
                    }
                    break;
            } 
            if (eatPowerup(tanks[i]))
                powerUp(tanks[i],i);
            //printf("tank[%d]=(%d,%d)\n",i,X(tanks[i]),Y(tanks[i]));
            writeSprite((unsigned int)tanks[i], tankLevel[i], GREY, i);
        }
    }
}

#endif /*TANK_H_*/
