#ifndef SCENARIO_H_
#define SCENARIO_H_

#include "global.h"

//                      Y   X
unsigned char scenario[13][13] = 
{
    // 0    1    2    3    4    5    6    7    8    9    10   11   12
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//0
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//1
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//2
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0xf2,0xf1,0x00,0xf1,0x00,0xf1,0x00},//3
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//4
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//5
    {0x00,0x00,0x00,0x00,0x00,0xf1,0x00,0xf1,0x00,0x00,0x00,0x00,0x00},//6
    {0xf2,0x00,0xf1,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0xf1,0x00,0xf2},//7
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//8
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//9
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//10
    {0x00,0xf1,0x00,0xf1,0x00,0x81,0xc1,0x41,0x00,0xf1,0x00,0xf1,0x00},//11
    {0x00,0x00,0x00,0x00,0x00,0xa1,0xf6,0x51,0x00,0x00,0x00,0x00,0x00} //12
};

//                      Y   X
unsigned char level1[13][13] = 
{
    // 0    1    2    3    4    5    6    7    8    9    10   11   12
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//0
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//1
    {0x00,0x00,0xf3,0x00,0xf3,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x00},//2
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0xf2,0xf1,0x00,0xf1,0x00,0xf1,0x00},//3
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//4
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//5
    {0xc1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc1},//6
    {0xf2,0x00,0xf1,0xf1,0x00,0xf1,0xf4,0xf1,0x00,0xf1,0xf1,0x00,0xf2},//7
    {0x00,0xf3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0x00},//8
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0xf2,0xf1,0x00,0xf1,0x00,0xf1,0x00},//9
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//10
    {0x00,0xf1,0x00,0xf1,0x00,0x81,0xc1,0x41,0x00,0xf1,0x00,0xf1,0x00},//11
    {0x00,0x00,0x00,0x00,0x00,0xa1,0xf6,0x51,0x00,0x00,0x00,0x00,0x00} //12
};

//                      Y   X
unsigned char level2[13][13] = 
{
    // 0    1    2    3    4    5    6    7    8    9    10   11   12
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//0
    {0x00,0xf2,0xf2,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0xf2,0xf2,0x00},//1
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//2
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0xf2,0xf1,0x00,0xf1,0x00,0xf1,0x00},//3
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//4
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//5
    {0x00,0x00,0xf4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0x00,0x00},//6
    {0xf4,0x00,0xf4,0xf4,0xf3,0xf3,0xf3,0xf3,0xf3,0xf4,0xf4,0x00,0xf4},//7
    {0x00,0x00,0xf4,0x00,0xf3,0xf3,0xf3,0xf3,0xf3,0x00,0xf4,0x00,0x00},//8
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0xf2,0xf1,0x00,0xf1,0x00,0xf1,0x00},//9
    {0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00,0xf1,0x00},//10
    {0x00,0xf1,0x00,0xf1,0x00,0x81,0xc1,0x41,0x00,0xf1,0x00,0xf1,0x00},//11
    {0x00,0x00,0x00,0x00,0x00,0xa1,0xf6,0x51,0x00,0x00,0x00,0x00,0x00} //12
};

//                      Y   X
unsigned char level3[13][13] = 
{
    // 0    1    2    3    4    5    6    7    8    9    10   11   12
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//0
    {0x00,0xf3,0xf3,0xf3,0x00,0x00,0x00,0xf1,0x00,0xf2,0x00,0xf1,0x00},//1
    {0x00,0xf3,0xf3,0xf3,0xf3,0x00,0x00,0xf1,0x00,0xf2,0x00,0xf1,0x00},//2
    {0x00,0xf3,0xf3,0xf3,0xf3,0x00,0xf2,0xf1,0x00,0xf2,0x00,0xf1,0x00},//3
    {0x00,0xf3,0xf3,0xf3,0xf3,0x00,0xf2,0xf1,0x00,0xf2,0x00,0xf1,0x00},//4
    {0x00,0x00,0xf3,0xf3,0x00,0x00,0x00,0x00,0x00,0xf2,0x00,0x00,0x00},//5
    {0xf2,0x00,0x00,0x00,0x00,0xf3,0x00,0xf3,0x00,0x00,0x00,0x00,0x00},//6
    {0xf2,0x00,0xf1,0xf2,0x00,0xf3,0xf2,0xf3,0xf3,0xf3,0xf1,0x00,0xf2},//7
    {0x00,0x00,0x00,0xf2,0x00,0x00,0xf2,0xf3,0xf3,0xf3,0xf3,0x00,0x00},//8
    {0x00,0xf2,0x00,0xf2,0x00,0xf3,0x00,0xf3,0xf3,0xf3,0xf3,0x00,0x00},//9
    {0x00,0xf2,0x00,0xf2,0x00,0xf3,0x00,0xf3,0xf3,0xf3,0xf3,0x00,0x00},//10
    {0x00,0xf2,0x00,0xf2,0x00,0x81,0xc1,0x41,0x00,0xf3,0xf3,0x00,0x00},//11
    {0x00,0x00,0x00,0x00,0x00,0xa1,0xf6,0x51,0x00,0x00,0x00,0x00,0x00} //12
};

//                      Y   X
unsigned char gameOver[13][13] = 
{
    // 0    1    2    3    4    5    6    7    8    9    10   11   12
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//0
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//1
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//2
    {0xc3,0xc3,0x00,0xc3,0x00,0x43,0x00,0x43,0xc3,0xc3,0x00,0x00,0x00},//3
    {0x53,0x00,0xa3,0xc3,0x53,0x73,0x73,0x53,0xd3,0xc3,0x00,0x00,0x00},//4
    {0xd3,0xe3,0xa3,0x00,0x53,0x53,0x00,0x53,0xd3,0xc3,0x00,0x00,0x00},//5
    {0x00,0x00,0x83,0xc3,0x43,0x43,0x00,0x43,0xc3,0xc3,0x83,0xc3,0x43},//6
    {0x00,0x00,0xa3,0x00,0x53,0xd3,0x83,0x53,0xd3,0xc3,0xa3,0xc3,0x53},//7
    {0x00,0x00,0xa3,0xc3,0x53,0x23,0x63,0x00,0xd3,0xc3,0xa3,0x23,0x43},//8
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//9
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//10
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//11
    {0x00,0x00,0x00,0x00,0x00,0x00,0xf6,0x00,0x00,0x00,0x00,0x00,0x00} //12
};

void playSoundFire()
{
    AUDIO = FIRE;
}

void playInit()
{
    AUDIO = 0x00000f00;
}

void playSoundExplosion()
{
    AUDIO = EXPLOSION;
}

void playStartMusic()
{
    AUDIO = INIT;
    usleep(100);
    AUDIO = START;
}

void playSoundStop()
{
    AUDIO = 0x00000000;
}

void writeScenario(unsigned int y, unsigned int x)
{
    IOWR_32DIRECT(VGA_BASE,0,(scenario[y][x] + (y<<8) + (x<<12) + (1<<31)));
    usleep(VGA_DELAY);
}

void writeSprite(unsigned int sprite, unsigned int type, unsigned int color, unsigned int index)
{
    IOWR_32DIRECT(VGA_BASE,0,(color + (type<<2) + (sprite<<6) + (index<<26) + (0<<31)));
}

void scenario_init()
{
    unsigned int i,j;
    for (i=0;i<MAXEXPLO;i++)
    {
        writeSprite((unsigned int)tankInit, SMALLEXPLO, GREY, i);
        writeSprite((unsigned int)tankInit, SMALLEXPLO, GREY, i);
    }
    VGA = 0xffffffff;
    if (level==1)
    {
        player1Level = PLAYER1;
        for (i=640; i>180; i--)
        {
            VGA = 0x00fff000 + i;
            usleep(5000);
        }
        while (1)
        {
            if (KEYPRESSED)
            {
                if (KEY==0x24)
                {
                    difficulty=0;
                    VGA = 0x0f0ffff0 + difficulty;
                    VGA = 0x0f0ffff0 + difficulty;
                }
                else if (KEY==0x21)
                {
                    difficulty=1;
                    VGA = 0x0f0ffff0 + difficulty;
                    VGA = 0x0f0ffff0 + difficulty;
                }
                else if (KEY==0x5a)
                {
                    break;
                }
            }
        };
        
        if (difficulty == 0)       
            MAXENEMY = 6;
        else if (difficulty == 1)
            MAXENEMY = 12;
        numOfEnemy = MAXENEMY;
        VGA = 0x00ffffff;
    }
    playStartMusic();
    VGA = 0x0fffffff + (level<<28);
    for (i=0;i<numOfEnemy;i++)
        numOfEnemyTemp += (1<<(19-i));
    VGA = 0xff000000 + numOfEnemyTemp;
    usleep(VGA_DELAY);
    if (level==1)
    {
        for (i=0; i<13; i++)
            for (j=0; j<13; j++)
                scenario[i][j]=level1[i][j];
    }
    else if (level==2)
    {
        for (i=0; i<13; i++)
            for (j=0; j<13; j++)
                scenario[i][j]=level2[i][j];
    }
    else if (level==3)
    {
        for (i=0; i<13; i++)
            for (j=0; j<13; j++)
                scenario[i][j]=level3[i][j];
    }
    for (i=0; i<13; i++)
        for (j=0; j<13; j++)
        {
            writeScenario(i,j);
            writeScenario(i,j);
        }
    VGA = 0x00000000;
    usleep(VGA_DELAY);
    tankCounterSet();
    bulletCounterSet();
}

void setPlayer1Life(unsigned int life)
{
    VGA = (0xfffff0) + ((life)<<24);
}

//initialize the player1
void player1_init()
{
    player1 = setPos(144,432,player1);
    player1 = setDir(UP,player1);
    setPlayer1Life(player1Life);
    currentDir=STOP;
    fireFlag=0;
    writeSprite(player1,player1Level,GREY,15);
    usleep(5000);
    writeSprite(player1,player1Level,GREY,15);
}

void gameover()
{
    int i,j;
    for (i=0; i<13; i++)
        for (j=0; j<13; j++)
        {
            scenario[i][j]=gameOver[i][j];
            writeScenario(i,j);
            writeScenario(i,j);
        }
    usleep(3000000);
    system_init();
    level = 1;
    scenario_init();
    player1_init();
}

void gameWin()
{
    if(++level<=3)
    {
        system_init();
        scenario_init();
        player1_init();
    }
    else
    {
        level=1;
        system_init();
        scenario_init();
        player1_init();
    }
}

//set the position of the sprite
unsigned int setPos(unsigned int x, unsigned int y, unsigned int sprite)
{
    return (x<<11) + (y<<2) + (sprite&0x3);
}

//increase the X position of the sprite
unsigned int incX(unsigned int x, unsigned int sprite)
{
    return setPos((X(sprite))+x,Y(sprite),sprite);
}

//increase the Y position of the sprite
unsigned int incY(unsigned int y, unsigned int sprite)
{
    return setPos(X(sprite),(Y(sprite))+y,sprite);
}

//decrease the X position of the sprite
unsigned int decX(unsigned int x, unsigned int sprite)
{
    return setPos((X(sprite))-x,Y(sprite),sprite);
}

//decrease the Y position of the sprite
unsigned int decY(unsigned int y, unsigned int sprite)
{
    return setPos(X(sprite),(Y(sprite))-y,sprite);
}

//set the direction of the sprite
unsigned int setDir(unsigned int dir, unsigned int sprite)
{
    return dir + (sprite&0xffffc);
}

//tank can not move over these types
unsigned int notPenetrable(unsigned int type)
{
    if (type==BRICK || type==STEEL || type==WATER || type==BASE)
        return 1;
    else
        return 0;
}

//test whether this position is occupied by an obstacle or other tanks
unsigned int occupied(unsigned int x, unsigned int y)
{
    unsigned int X_SQR = x/36;
    unsigned int Y_SQR = y/36;
    
    if (x<=(X_SQR*36+18) && y<=(Y_SQR*36+18))
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x1 && notPenetrable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
    else if (y<=(Y_SQR*36+18))
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x2 && notPenetrable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
    else if (x<=(X_SQR*36+18))
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x4 && notPenetrable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
    else
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x8 && notPenetrable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
} 

unsigned int isTankHere(unsigned int x, unsigned int y)
{
    int i;
    for (i=0;i<MAXTANK;i++)
        if (tanks[i]!=-1)
            if (x>=(X(tanks[i])) && x<=(X(tanks[i]))+35 && y>=(Y(tanks[i])) && y<=(Y(tanks[i]))+35)
                return 1;
    if (x>=(X(player1)) && x<=(X(player1))+35 && y>=(Y(player1)) && y<=(Y(player1))+35)
                return 1;
//    if (x>=(X(player2)) && x<=(X(player2))+35 && y>=(Y(player2)) && y<=(Y(player2))+35)
//                return 1;
    return 0;
}

//check whether the sprite can move left
unsigned int canMoveLeft(unsigned int sprite)
{
    unsigned int flag = 1;
    if ((X(sprite))<step)
        flag = 0;
    if (occupied((X(sprite))-step,(Y(sprite))+2))
        flag = 0;
    else if (occupied((X(sprite))-step,(Y(sprite))+18))
        flag = 0;
    else if (occupied((X(sprite))-step,(Y(sprite))+33))
        flag = 0;
    else if (isTankHere((X(sprite))-step,Y(sprite)))
        flag = 0;
    else if (isTankHere((X(sprite))-step,(Y(sprite))+35))
        flag = 0;
    return flag;   
}

//check whether the sprite can move right
unsigned int canMoveRight(unsigned int sprite)
{
    unsigned int flag = 1;
    if ((X(sprite))+35+step>468)
        flag = 0;
    if (occupied((X(sprite))+35+step,(Y(sprite))+2))
        flag = 0;
    else if (occupied((X(sprite))+35+step,(Y(sprite))+18))
        flag = 0;
    else if (occupied((X(sprite))+35+step,(Y(sprite))+33))
        flag = 0;
    else if (isTankHere((X(sprite))+35+step,Y(sprite)))
        flag = 0;
    else if (isTankHere((X(sprite))+35+step,(Y(sprite))+35))
        flag = 0;
    return flag;   
}

//check whether the sprite can move up
unsigned int canMoveUp(unsigned int sprite)
{
    unsigned int flag = 1;
    if ((Y(sprite))<step)
        flag = 0;
    if (occupied((X(sprite))+2,(Y(sprite))-step))
        flag = 0;
    else if (occupied((X(sprite))+18,(Y(sprite))-step))
        flag = 0;
    else if (occupied((X(sprite))+33,(Y(sprite))-step))
        flag = 0;
    else if (isTankHere(X(sprite),(Y(sprite))-step))
        flag = 0;
    else if (isTankHere((X(sprite))+35,(Y(sprite))-step))
        flag = 0;
    return flag;   
}

//check whether the sprite can move down
unsigned int canMoveDown(unsigned int sprite)
{
    unsigned int flag = 1;
    if ((Y(sprite))+35+step>468)
        flag = 0;
    if (occupied((X(sprite))+2,(Y(sprite))+35+step))
        flag = 0;
    else if (occupied((X(sprite))+18,(Y(sprite))+35+step))
        flag = 0;
    else if (occupied((X(sprite))+33,(Y(sprite))+35+step))
        flag = 0;
    else if (isTankHere(X(sprite),(Y(sprite))+35+step))
        flag = 0;
    else if (isTankHere((X(sprite))+35,(Y(sprite))+35+step))
        flag = 0;
    return flag;   
}

//the sprite fires the bullet
void fireBullet(unsigned int sprite, unsigned int spriteIndex)
{    
    if (spriteIndex==MAXBULLET-1)
    {
        if (fireCounter<10)
            return;
        counterEnable |= (1<<30);
        bulletCounterSet();
        fireCounter=0;
    }
                  
    if (bullets[spriteIndex]!=bulletInit)
        return;
    unsigned int bullet = bulletInit;
    if ((DIR(sprite))==UP && (Y(sprite))>8)
    {
        bullet = setPos((X(sprite))+15,(Y(sprite))-8,bullet);
        bullet = setDir(UP,bullet);    
    }
    else if ((DIR(sprite))==DN && (Y(sprite))+35+8<468)
    {
        bullet = setPos((X(sprite))+15,(Y(sprite))+35+8,bullet);
        bullet = setDir(DN,bullet);    
    }
    else if ((DIR(sprite))==LF && (X(sprite))>8)
    {
        bullet = setPos((X(sprite))-8,(Y(sprite))+15,bullet);
        bullet = setDir(LF,bullet);    
    }
    else if ((DIR(sprite))==RT && (X(sprite))+35+8<468)
    {
        bullet = setPos((X(sprite))+35+8,(Y(sprite))+15,bullet);
        bullet = setDir(RT,bullet);    
    }
    if (bullet!=bulletInit)//bullet is not empty
    {
        bullets[spriteIndex]=bullet;
        writeSprite((unsigned int)bullet, BULLET, GREY,spriteIndex+MAXTANK);
        counterEnable |= (1<<spriteIndex);
        bulletCounterSet();  
    }
    if (spriteIndex==MAXBULLET-1)
    {
        playSoundFire();
        playSoundStop();
    }
}

//update the position of the player1 and fire the bullet if space key is pressed
void updateKeyboard()
{    
    switch (KEY)
    {
        case 0x1c:      //'a', move left
            if (breakFlag)
            {
                breakFlag=0;
                currentDir=STOP;
            }
            else
                currentDir=LF;
            break;
        case 0x1d:      //'w', move up
            if (breakFlag)
            {
                breakFlag=0;
                currentDir=STOP;
            }
            else
                currentDir=UP;
            break;
        case 0x23:      //'d', move right
            if (breakFlag)
            {
                breakFlag=0;
                currentDir=STOP;
            }
            else
                currentDir=RT;
            break;
        case 0x1b:      //'s', move down
            if (breakFlag)
            {
                breakFlag=0;
                currentDir=STOP;
            }
            else
                currentDir=DN;
            break;
        case 0x29:      //"space", fire a bullet
            if (breakFlag)
            {
                breakFlag = 0;
                fireFlag = 0;
            }
            else
                fireFlag = 1;
            break;
        case 0xf0:      //break code, setup a flag
            breakFlag = 1;
            break;
        case 0x21:      //pause the game
            tankStop=50000;
            player1Stop=80;
            break;
    }
}

void updateExplosion()
{
    int i;
    for (i=0;i<MAXEXPLO;i++)
    {
        if (explosion[i]==BIGEXPLO && exploFlag[i]==1)
        {
            writeSprite((unsigned int)(exploPos[i]+(9<<11)+(9<<2)), SMALLEXPLO, GREY, i);//small explosion
            exploFlag[i]=2;
        }
        else if (explosion[i]==BIGEXPLO && exploFlag[i]==2)
        {
            if (counterEnable&(1<<(MAXBULLET+i)))
                continue;
            counterEnable |= (1<<(MAXBULLET+i));  
            bulletCounterSet(); 
            if (exploCounter[i]++>15)
            {
                writeSprite((unsigned int)exploPos[i], BIGEXPLO, GREY, i);//big explosion
                exploFlag[i]=3;
                exploCounter[i]=0;
            }
        }
        else if (explosion[i]==BIGEXPLO && exploFlag[i]==3)
        {
            if (counterEnable&(1<<(MAXBULLET+i)))
                continue;
            counterEnable |= (1<<(MAXBULLET+i));  
            bulletCounterSet(); 
            if (exploCounter[i]++>20)
            {
                writeSprite((unsigned int)tankInit, SMALLEXPLO, GREY, i);
                explosion[i]=0;
                exploFlag[i]=0;
                exploCounter[i]=0;
            }
        }
        else if (explosion[i]==SMALLEXPLO && exploFlag[i]==1)
        {
            writeSprite((unsigned int)(exploPos[i]-(6<<11)-(6<<2)), SMALLEXPLO, GREY, i);//small explosion
            exploFlag[i]=2;
        }
        else if (explosion[i]==SMALLEXPLO && exploFlag[i]==2)
        {
            if (counterEnable&(1<<(MAXBULLET+i)))
                continue;
            counterEnable |= (1<<(MAXBULLET+i));  
            bulletCounterSet(); 
            if (exploCounter[i]++>20)
            {
                writeSprite((unsigned int)tankInit, SMALLEXPLO, GREY, i);
                explosion[i]=0;
                exploFlag[i]=0;
                exploCounter[i]=0;
            }
        }
    }
}

#endif /*SCENARIO_H_*/
