#ifndef GLOBAL_H_
#define GLOBAL_H_

#define VGA (*(volatile unsigned long int*) VGA_BASE)
#define AUDIO (*(volatile unsigned long int*) AUDIO_BASE)
#define KEYPRESSED IORD_8DIRECT(PS2_BASE,0)
#define KEY IORD_8DIRECT(PS2_BASE,4)
#define UPDATE_FREQ 400000
#define XOFFSET 86
#define YOFFSET 6

#define FIRE 0x1
#define EXPLOSION 0x2
#define INIT 0x00000100
#define START 0x00000110
#define VGA_DELAY 6000

#define step 4
#define bulletStep 2
#define UP 0
#define DN 1
#define LF 3
#define RT 2
#define STOP -1
#define DIR(x) (x)&0x3
#define X(x) ((x)&0xff800)>>11
#define Y(x) ((x)&0x007fc)>>2

#define BRICK 1
#define STEEL 2
#define TREE  3
#define WATER 4
#define ICE   5
#define BASE  6
#define BULLET 7
#define SMALLEXPLO 8
#define BIGEXPLO 9

#define PLAYER1 1
#define PLAYER2 2
#define BASIC_TANK 3
#define POWERUP 4
#define POWER_TANK 5
#define SUPER_TANK 6
#define PLY1 10
#define PLY2 11

#define GREY 1

#define BLOCKS(x) ((x)&0xf0)>>4
#define TYPES(x) (x)&0xf

#define MAXBULLET (MAXTANK+2)
#define MAXTANK 4
//#define MAXENEMY 6
unsigned int MAXENEMY = 6;
#define MAXEXPLO 8

#define tankInit 0xfffff
#define bulletInit 0xff7fb

unsigned int player1 = 0;

unsigned int player1Level = PLAYER1;

unsigned int difficulty = 1;
unsigned int stop = 0;

int bullets[MAXBULLET];
int tanks[MAXTANK];
int tankLevel[MAXTANK];
int explosion[MAXEXPLO];
int exploFlag[MAXEXPLO];
int exploPos[MAXEXPLO];
int exploCounter[MAXEXPLO];

int level = 1;
int player1Life = 3;
int numOfEnemy = 0;
int numOfEnemyTemp = 0;
int currentDir = STOP;
int fireFlag = 0;
int breakFlag = 0;

unsigned int numOfTank = 0;
unsigned int tankNum = 0;

unsigned int powerup = tankInit;

unsigned int counterEnable = 0;

unsigned int tankEnable = 0;

unsigned int musicCounter = 0;

unsigned int player1Stop = 0;

unsigned int tankStop = 0;

unsigned int keyCounter = 0;

unsigned int setPos(unsigned int x, unsigned int y, unsigned int sprite);

unsigned int setDir(unsigned int dir, unsigned int sprite);

unsigned int generateTankCounter = 0;
unsigned int generatePowerupCounter = 0;
unsigned int fireCounter = 0;

void tankCounterSet()
{
    IOWR_32DIRECT(TANK_COUNTER_BASE,0,tankEnable);
}

void tankCounterCheck()
{
    tankEnable = IORD_32DIRECT(TANK_COUNTER_BASE,0);
}

void bulletCounterSet()
{
    IOWR_32DIRECT(BULLET_COUNTER_BASE,0,counterEnable);
}

void bulletCounterCheck()
{
    counterEnable = IORD_32DIRECT(BULLET_COUNTER_BASE,0);
}

void system_init()
{
    int i;
    for (i=0;i<MAXTANK;i++)
        tanks[i]=tankInit;
    for (i=0;i<MAXBULLET;i++)
        bullets[i]=bulletInit;
    for (i=0;i<MAXEXPLO;i++)
        explosion[i]=0;
    for (i=0;i<MAXEXPLO;i++)
        exploFlag[i]=0;
    for (i=0;i<MAXEXPLO;i++)
        exploCounter[i]=0;
    player1Life = 3;
    generateTankCounter = 0;
    generatePowerupCounter = 0;
    fireCounter = 0;
    numOfEnemy = MAXENEMY;
    numOfEnemyTemp = 0;
    numOfTank = 0;
    tankNum = 0;
    keyCounter = 0;
    currentDir = STOP;
    breakFlag = 0;
    fireFlag = 0;
    player1Stop = 0;
    tankStop = 0;
    counterEnable = 0;
    tankEnable = 0;
    musicCounter = 0;
    //player1Level = PLAYER1;
    powerup = tankInit;
    tankCounterSet();
    bulletCounterSet();
}

#endif /*GLOBAL_H_*/
