#ifndef BULLET_H_
#define BULLET_H_

#include "global.h"

unsigned int hitable(unsigned int type)//bullet can not fly over
{
    if (type==BRICK || type==STEEL || type==BASE)
        return 1;
    else
        return 0;
}

//check whether a coordinate is inside a tank or not
unsigned int insideTank(unsigned tank, unsigned int x, unsigned int y)
{
    if (x>=(X(tank)) && x<=(X(tank))+35 && y>=(Y(tank)) && y<=(Y(tank))+35)
        return 1;
    else
        return 0;
}

//return the index of the tank hit by the bullet, -1=player1, -2=player2
unsigned int hitTank(unsigned int bullet)
{
    if (insideTank(player1,X(bullet),Y(bullet)))
        return -1;
    int i;
    for (i=0;i<MAXTANK;i++)
        if (insideTank(tanks[i],X(bullet),Y(bullet)))
            return i;
    return -3;
}

//return the index of the tank hit by the bullet, -1=player1, -2=player2
unsigned int existTank(unsigned int x, unsigned int y)
{
    if (insideTank(player1,x,y) || insideTank(player1,x+35,y) || insideTank(player1,x,y+35) || insideTank(player1,x+35,y+35))
        return -1;
    int i;
    for (i=0;i<MAXTANK;i++)
        if (insideTank(tanks[i],x,y) || insideTank(tanks[i],x+35,y) || insideTank(tanks[i],x,y+35) || insideTank(tanks[i],x+35,y+35))
            return i;
    return -3;
}

//update the tank and bullet list, when the bullet hit the tank
void tankBomb(unsigned int x, unsigned int y, unsigned int tankIndex, unsigned int bulletIndex)
{
    bullets[bulletIndex]=bulletInit;//remove this bullet

    if (tankIndex==-1)//player1 was hit
    {
        if (player1Level==PLAYER1)
        {
            explosion[MAXEXPLO-1]=BIGEXPLO;
            exploFlag[MAXEXPLO-1]=1;
            exploPos[MAXEXPLO-1]=setPos(X(player1),Y(player1),exploPos[MAXEXPLO-1]);
            player1Life--;
            setPlayer1Life(player1Life);
            if (player1Life<=0)
                gameover();
            player1_init();
        }
        else if (player1Level==PLY1)
        {
            player1Level=PLAYER1;
            writeSprite(player1, player1Level, GREY,15);
        }
        else if (player1Level==PLY2)
        {
            player1Level=PLY1;
            writeSprite(player1, player1Level, GREY,15);
        }
    }
    else if (bulletIndex==(MAXBULLET-1))//enemy was hit
    {
        if (tankLevel[tankIndex]==SUPER_TANK)
        {
            playSoundExplosion();
            //usleep(10000);
            playSoundStop();
            tankLevel[tankIndex]=POWER_TANK;
            writeSprite(tanks[tankIndex], POWER_TANK, GREY, tankIndex);
            explosion[tankIndex]=SMALLEXPLO;
            exploFlag[tankIndex]=1;
            exploPos[tankIndex]=setPos(x,y,exploPos[tankIndex]);
        }
        else if (tankLevel[tankIndex]==POWER_TANK)
        {
            playSoundExplosion();
            //usleep(10000);
            playSoundStop();
            tankLevel[tankIndex]=BASIC_TANK;
            writeSprite(tanks[tankIndex], BASIC_TANK, GREY, tankIndex);
            explosion[tankIndex]=SMALLEXPLO;
            exploFlag[tankIndex]=1;
            exploPos[tankIndex]=setPos(x,y,exploPos[tankIndex]);
        }
        else
        {
            playSoundExplosion();
            //usleep(10000);
            playSoundStop();
            tanks[tankIndex]=tankInit;//remove this tank
            tankNum = tankNum-1;
            numOfEnemy--;
            numOfEnemyTemp = (numOfEnemyTemp<<1)&0xfffff;
            VGA = 0xff000000 + numOfEnemyTemp;
            writeSprite((unsigned int)tankInit, BASIC_TANK, GREY, tankIndex);
            explosion[tankIndex]=BIGEXPLO;
            exploFlag[tankIndex]=1;
            exploPos[tankIndex]=setPos(x,y,exploPos[tankIndex]);
            if (numOfEnemy<=0)
                gameWin();
        }
    }
}

unsigned int canDestroy(unsigned int X_SQR, unsigned int Y_SQR, unsigned int bulletIndex)
{
    if (bulletIndex==(MAXBULLET-1))
    {
        if (player1Level==PLY1 || player1Level==PLY2)
        {
            if ((TYPES(scenario[Y_SQR][X_SQR]))==BRICK || (TYPES(scenario[Y_SQR][X_SQR]))==STEEL)
                return 1;
            else
                return 0;
        }
        else
        {
            if ((TYPES(scenario[Y_SQR][X_SQR]))==BRICK)
                return 1;
            else
                return 0;
        }
    }
    else
    {
        if (tankLevel[bulletIndex]==POWER_TANK || tankLevel[bulletIndex]==SUPER_TANK)
        {
            if ((TYPES(scenario[Y_SQR][X_SQR]))==BRICK || (TYPES(scenario[Y_SQR][X_SQR]))==STEEL)
                return 1;
            else
                return 0;
        }
        else
        {
            if ((TYPES(scenario[Y_SQR][X_SQR]))==BRICK)
                return 1;
            else
                return 0;
        }
    }
}

unsigned int canBeHit(unsigned int x, unsigned int y)
{
    unsigned int X_SQR = x/36;
    unsigned int Y_SQR = y/36;
    
    if (x<=(X_SQR*36+18) && y<=(Y_SQR*36+18))
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x1 && hitable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
    else if (y<=(Y_SQR*36+18))
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x2 && hitable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
    else if (x<=(X_SQR*36+18))
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x4 && hitable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
    else
        if (BLOCKS(scenario[Y_SQR][X_SQR])&0x8 && hitable(TYPES(scenario[Y_SQR][X_SQR])))
            return 1;
        else
            return 0;
} 

unsigned int bulletHit(unsigned int bullet, unsigned int dir)
{
    unsigned int flag = 0;
    if (dir==UP)
    {
        if (canBeHit(X(bullet),(Y(bullet))))
            flag = 1;
        else if (canBeHit((X(bullet))+5,(Y(bullet))))
            flag = 1;
    }
    else if (dir==DN)
    {
        if (canBeHit(X(bullet),(Y(bullet))))
            flag = 1;
        else if (canBeHit((X(bullet))+5,(Y(bullet))))
            flag = 1;
    }
    else if (dir==RT)
    {
        if (canBeHit((X(bullet)),Y(bullet)))
            flag = 1;
        else if (canBeHit((X(bullet)),(Y(bullet))+5))
            flag = 1;
    }
    else if (dir==LF)
    {
        if (canBeHit((X(bullet)),Y(bullet)))
            flag = 1;
        else if (canBeHit((X(bullet)),(Y(bullet))+5))
            flag = 1;
    }
    return flag;  
}

void updateScenario(unsigned int x, unsigned int y, unsigned int dir)
{    
    unsigned int SQR_X=x/36;
    unsigned int SQR_Y=y/36;
    if (dir==UP)
    {
        if (x<=(SQR_X*36+9))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x4)//hit the blocks 2 
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xbf;
            else//hit the blocks 0
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xef;
        }
        else if (x>=(SQR_X*36+27))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x8)//hit the blocks 3
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x7f;
            else//hit the blocks 1
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xdf;
        }
        else
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0xc)//hit the blocks 2,3
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x3f;
            else//hit the blocks 0,1
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xcf;
        }
    }
    else if (dir==DN)
    {
        if (x<=(SQR_X*36+9))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x1)//hit the blocks 0 
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xef;
            else//hit the blocks 2
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xbf;
        }
        else if (x>=(SQR_X*36+27))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x2)//hit the blocks 1
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xdf;
            else//hit the blocks 3
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x7f;
        }
        else
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x3)//hit the blocks 0,1 
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xcf;
            else//hit the blocks 2,3
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x3f;
        }
    }
    else if (dir==LF)
    {
        if (y<=(SQR_Y*36+9))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x2)//hit the blocks 1
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xdf;
            else//hit the blocks 0
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xef;
        }
        else if (y>=(SQR_Y*36+27))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x8)//hit the blocks 3
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x7f;
            else//hit the blocks 2
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xbf;
        }
        else
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0xa)//hit the blocks 1,3 
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x5f;
            else//hit the blocks 0,1
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xaf;
        }
    }
    else if (dir==RT)
    {
        if (y<=(SQR_Y*36+9))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x1)//hit the blocks 0
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xef;
            else//hit the blocks 1
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xdf;
        }
        else if (y>=(SQR_Y*36+27))
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x4)//hit the blocks 2
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xbf;
            else//hit the blocks 3
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x7f;
        }
        else
        {
            if (BLOCKS(scenario[SQR_Y][SQR_X])&0x5)//hit the blocks 0,2 
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0xaf;
            else//hit the blocks 0,1
                scenario[SQR_Y][SQR_X] = scenario[SQR_Y][SQR_X]&0x5f;
        }
    }
    writeScenario(SQR_Y,SQR_X);
    writeScenario(SQR_Y,SQR_X);
}

void smallExplosion(unsigned int x, unsigned int y)
{
    int i;
    for (i=0;i<MAXEXPLO;i++)
    {
        if (!explosion[i])
        {
            explosion[i]=SMALLEXPLO;
            exploFlag[i]=1;
            exploPos[i]=setPos(x,y,exploPos[i]);
            break;
        }
    }
}

unsigned int dif(unsigned int x1, unsigned int x2)
{
    if (x1>x2)
        return x1-x2;
    else
        return x2-x1;
}

int bulletMeet(unsigned int bullet, unsigned int bulletIndex)
{
    int i;
    for (i=0;i<MAXBULLET;i++)
    {
        if (dif(X(bullet),X(bullets[i]))<6 && dif(Y(bullet),Y(bullets[i]))<6 && bulletIndex!=i)
        {
            bullets[bulletIndex] = bulletInit;
            bullets[i] = bulletInit;
            writeSprite(bulletInit, BULLET, GREY, i+MAXTANK);
            writeSprite(bulletInit, BULLET, GREY, bulletIndex+MAXTANK);
            return 1;
            break;
        }
    }
    return 0;
}

//update the bullets
void updateBullets()
{        
    if (!(counterEnable&(1<<30)))
    {
        fireCounter++;
        counterEnable |= (1<<30);
        bulletCounterSet();
    }
    int i;
    for (i=0; i<MAXBULLET; i++)//loop for each bullet
    {
        if (bullets[i]!=bulletInit)//bullet exists
        {
            //update the bullet at the defined rate
            if (counterEnable&(1<<i))
                continue;
            counterEnable |= (1<<i);  
            bulletCounterSet();  
            
            if (bulletMeet(bullets[i],i))
                continue;
            
            //printf("bullets[%d]=(%d,%d,%d)\n",i,X(bullets[i]),Y(bullets[i]),DIR(bullets[i]));
            if ((DIR(bullets[i]))==UP)//bullet is moving up
            {
                //update the position of the bullet
                if ((Y(bullets[i]))>bulletStep)//not hit boundary
                    bullets[i]=decY(bulletStep,bullets[i]);
                else//hit the boundary
                    bullets[i]=bulletInit;
                    
                //check whether the bullet hits a tank or obstacle
                int tankIndex=hitTank(bullets[i]);
                if (tankIndex!=-3)//hit the tank
                    tankBomb(X(tanks[tankIndex]),Y(tanks[tankIndex]),tankIndex,i);
                else if (bulletHit(bullets[i],UP))//hit the obstacle
                {
                    smallExplosion(X(bullets[i]),(Y(bullets[i]))-9);
                    if (canDestroy((X(bullets[i]))/36,(Y(bullets[i]))/36,i))
                        updateScenario((X(bullets[i])),(Y(bullets[i])),UP);
                    else if (canDestroy(((X(bullets[i]))+5)/36,(Y(bullets[i]))/36,i))
                        updateScenario((X(bullets[i]))+5,(Y(bullets[i])),UP);
                    bullets[i]=bulletInit;
                }
            }
            else if ((DIR(bullets[i]))==DN)//bullet is moving down
            {
                //update the position of the bullet
                if ((Y(bullets[i]))+bulletStep<468)//not hit boundary
                    bullets[i]=incY(bulletStep,bullets[i]);
                else//hit the boundary
                    bullets[i]=bulletInit;
                    
                //hit the base    
                if ((X(bullets[i]))>=6*36 && (X(bullets[i]))<=7*36 && (Y(bullets[i]))>=12*36 && (Y(bullets[i]))<=13*36)
                {
                    gameover();
                    return;
                }
                    
                //check whether the bullet hits a tank or obstacle
                int tankIndex=hitTank(bullets[i]);
                if (tankIndex!=-3)//hit the tank
                    tankBomb(X(tanks[tankIndex]),Y(tanks[tankIndex]),tankIndex,i);
                else if (bulletHit(bullets[i],DN))//hit the obstacle
                {
                    smallExplosion(X(bullets[i]),(Y(bullets[i]))+9);
                    if (canDestroy((X(bullets[i]))/36,(Y(bullets[i]))/36,i))
                        updateScenario((X(bullets[i])),(Y(bullets[i])),DN);
                    else if (canDestroy(((X(bullets[i]))+5)/36,(Y(bullets[i]))/36,i))
                        updateScenario((X(bullets[i]))+5,(Y(bullets[i])),DN);
                    bullets[i]=bulletInit;
                }
            }
            else if ((DIR(bullets[i]))==LF)//bullet is moving left
            {
                //update the position of the bullet
                if ((X(bullets[i]))>bulletStep)//not hit boundary
                    bullets[i]=decX(bulletStep,bullets[i]);
                else//hit the boundary
                    bullets[i]=bulletInit;
                    
                //hit the base    
                if ((X(bullets[i]))>=6*36 && (X(bullets[i]))<=7*36 && (Y(bullets[i]))>=12*36 && (Y(bullets[i]))<=13*36)
                {
                    gameover();
                    return;
                }
                    
                //check whether the bullet hits a tank or obstacle
                int tankIndex=hitTank(bullets[i]);
                if (tankIndex!=-3)//hit the tank
                    tankBomb(X(tanks[tankIndex]),Y(tanks[tankIndex]),tankIndex,i);
                else if (bulletHit(bullets[i],LF))//hit the obstacle
                {
                    smallExplosion((X(bullets[i]))-9,Y(bullets[i]));
                    if (canDestroy((X(bullets[i]))/36,(Y(bullets[i]))/36,i))
                        updateScenario((X(bullets[i])),(Y(bullets[i])),LF);
                    else if (canDestroy((X(bullets[i]))/36,((Y(bullets[i]))+5)/36,i))
                        updateScenario((X(bullets[i])),(Y(bullets[i]))+5,LF);
                    bullets[i]=bulletInit;
                }
            }
            else if ((DIR(bullets[i]))==RT)//bullet is moving left
            {
                //update the position of the bullet
                if ((X(bullets[i]))+bulletStep<468)//not hit boundary
                   bullets[i]=incX(bulletStep,bullets[i]);
                else//hit the boundary
                    bullets[i]=bulletInit;
                    
                //hit the base    
                if ((X(bullets[i]))>=6*36 && (X(bullets[i]))<=7*36 && (Y(bullets[i]))>=12*36 && (Y(bullets[i]))<=13*36)
                {
                    gameover();
                    return;
                }
                    
                //check whether the bullet hits a tank or obstacle
                int tankIndex=hitTank(bullets[i]);
                if (tankIndex!=-3)//hit the tank
                    tankBomb(X(tanks[tankIndex]),Y(tanks[tankIndex]),tankIndex,i);
                else if (bulletHit(bullets[i],RT))//hit the obstacle
                {
                    smallExplosion((X(bullets[i]))+9,Y(bullets[i]));
                    if (canDestroy((X(bullets[i]))/36,(Y(bullets[i]))/36,i))
                        updateScenario((X(bullets[i])),(Y(bullets[i])),RT);
                    else if (canDestroy((X(bullets[i]))/36,((Y(bullets[i]))+5)/36,i))
                        updateScenario((X(bullets[i])),(Y(bullets[i]))+5,RT);
                    bullets[i]=bulletInit;
                }
            }
            //printf("bullet[%d]=(%d,%d)\n",i,X(bullets[i]),Y(bullets[i]));
            writeSprite((unsigned int)bullets[i], BULLET, GREY, i+MAXTANK);
        }
    }
}

#endif /*BULLET_H_*/
