-------------------------------------------------------------------------------
-- Display a tank on the VGA screen
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity vga_driver is
  
port (
    reset : in std_logic;
    clk   : in std_logic;                    -- Should be 25.125 MHz
	clk50   : in std_logic;
	command : in unsigned(31 downto 0);
		
	VGA_CLK,                         -- Clock
	VGA_HS,                          -- H_SYNC
	VGA_VS,                          -- V_SYNC
	VGA_BLANK,                       -- BLANK
	VGA_SYNC : out std_logic;        -- SYNC
	VGA_R,                           -- Red[9:0]
	VGA_G,                           -- Green[9:0]
	VGA_B : out unsigned(9 downto 0) -- Blue[9:0]
);

end vga_driver;

architecture rtl of vga_driver is
  
  -- Video parameters  
constant HTOTAL       : integer := 800;
constant HSYNC        : integer := 96;
constant HBACK_PORCH  : integer := 48;
constant HACTIVE      : integer := 640;
constant HFRONT_PORCH : integer := 16;
  
constant VTOTAL       : integer := 525;
constant VSYNC        : integer := 2;
constant VBACK_PORCH  : integer := 33;
constant VACTIVE      : integer := 480;
constant VFRONT_PORCH : integer := 10;

constant HOFFSET : integer := 16;
constant VOFFSET : integer := 6;

constant TOTLE_BLOCKS : integer := 169;
constant BLOCKS_WIDTH : integer := 13;
constant SQUAR_PIXELS : integer := 18;
constant TOTAL_PIXELS : integer := 468;
constant SPIRITE_PIXELS : integer := 1295;
constant BULLET_HOFFSET : integer := 6;
constant BULLET_VOFFSET : integer := 12;
constant BLOCK_PIXELS : integer := 36;

constant PHOENIX_X : integer := 6;
constant PHOENIX_Y : integer := 12;
-------------------------------------------diff
constant OFFSET : integer := 120;
constant DIFF_Y : integer := 290;
constant DIFF_LENGTH :integer := 40;
constant DIFF_DEPTH : integer := 10;
signal   diff_exist  :std_logic:= '0'; 
signal   diff_address:unsigned (8 DOWNTO 0);
signal   diff_rgb    :STD_LOGIC_VECTOR (0 DOWNTO 0);
-------------------------------------------diff
-------------------------------------------normal
constant NORMAL_Y : integer := 270;
constant NORMAL_LENGTH : integer := 30;
constant NORMAL_DEPTH : integer := 10;
signal   normal_exist  :std_logic:= '0'; 
signal   normal_address:unsigned (8 DOWNTO 0);
signal   normal_rgb    :STD_LOGIC_VECTOR (0 DOWNTO 0);
-------------------------------------------normal

-------------------------------------------choose
constant CHOOSE_X       : integer := 100;
signal   choose1_exist  : std_logic:= '0';
signal   choose2_exist  : std_logic:= '0';  
signal   choose1_address: unsigned (6 DOWNTO 0);
signal   choose2_address: unsigned (6 DOWNTO 0);
signal   choose_address : unsigned (6 DOWNTO 0);
signal   choose_diff 	: STD_LOGIC_VECTOR (0 DOWNTO 0);
signal   choose_rgb	    :STD_LOGIC_VECTOR (1 DOWNTO 0);
-------------------------------------------choose

-------------------------------------------start
constant START_Y : integer := 120;
constant START_LENGTH : integer := 280;
constant START_DEPTH : integer := 120;
signal   start_x	 : STD_LOGIC_VECTOR (9 DOWNTO 0);
signal   start_exist  :std_logic:= '0'; 
signal   start_address:unsigned (15 DOWNTO 0);
signal   start_rgb    :STD_LOGIC_VECTOR (1 DOWNTO 0);
signal   start_end  :std_logic:= '0'; 
-------------------------------------------start

---------------------------------------------end
--constant END_Y : integer := 180;
--constant END_LENGTH : integer := 300;
--constant END_DEPTH : integer := 160;
--signal   end_x	 : STD_LOGIC_VECTOR (9 DOWNTO 0);
--signal   end_exist  :std_logic:= '0'; 
--signal   end_address:unsigned (15 DOWNTO 0);
--signal   end_rgb    :STD_LOGIC_VECTOR (1 DOWNTO 0);
--signal   over_end  :std_logic:= '0'; 
---------------------------------------------end

-------------------------------------------stage
constant STAGE_X : integer := 210;
constant STAGE_Y : integer := 220;
constant STAGE_LENGTH : integer := 144;
constant STAGE_NUMX : integer := 354;
constant STAGE_NUMY : integer := 220;
signal stage_exist  :std_logic:= '0'; 
signal stagenum_exist  :std_logic:= '0'; 
-------------------------------------------stage

-------------------------------------------UI LEVEL 50*10
constant LEVEL_X : integer := 504;
constant LEVEL_Y : integer := 46;
constant LEVEL_LENGTH : integer := 48;
constant LEVEL_DEPTH  : integer := 10;
signal level_exist    :std_logic:= '0'; 
signal level_rgb     	: STD_LOGIC_VECTOR (1 DOWNTO 0);
signal level_address    : unsigned (8 DOWNTO 0);
--------------------------------------------UI LEVEL

--------------------------------------------UI NUM 10*10
constant LEVEL_NUMX : integer := 544;
constant LEVEL_NUMY : integer := 66;

constant LIFE_NUMX1 : integer := 540;
constant LIFE_NUMY1 : integer := 276;

constant LIFE_NUMX2 : integer := 540;
constant LIFE_NUMY2 : integer := 296;

signal levelnum_exist  :std_logic:= '0';

signal lifenum1_exist   :std_logic:= '0';
signal lifenum2_exist   :std_logic:= '0';

signal levelnum_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);

signal lifenum1_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal lifenum2_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);

--signal num_rgb     : STD_LOGIC_VECTOR (1 DOWNTO 0);
signal num0_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal num1_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal num2_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal num3_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal num4_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal num5_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal num_address     : unsigned (6 DOWNTO 0);
signal levelnum_address: unsigned (6 DOWNTO 0);

signal lifenum1_address : unsigned (6 DOWNTO 0);
signal lifenum2_address : unsigned (6 DOWNTO 0);
signal lifenum_address  : unsigned (6 DOWNTO 0);

--------------------------------------------UI NUM

--------------------------------------------UI LIFE
constant LIFE_X : integer := 504;
constant LIFE_Y : integer := 256;
constant LIFE_LENGTH : integer := 56;
constant LIFE_DEPTH : integer := 10;
signal life_exist  :std_logic:= '0'; 
signal life_rgb     	: STD_LOGIC_VECTOR (1 DOWNTO 0);
signal life_address     : unsigned (9 DOWNTO 0);

constant PLAYER1_X : integer := 520;
constant PLAYER1_Y : integer := 276;
constant PLAYER2_Y : integer := 296;

signal player_exist   : STD_LOGIC_VECTOR(1 DOWNTO 0) :="00";

signal playernum_y 	  : unsigned (9 DOWNTO 0);
signal signal_address  : unsigned (6 DOWNTO 0);
signal signal1_address : unsigned (6 DOWNTO 0);
signal signal2_address : unsigned (6 DOWNTO 0);
--------------------------------------------UI LIFE

--------------------------------------------UI ENEMY
type enemy_type is array(19 downto 0) of integer;
constant ENEMY_NUMX : enemy_type := (520,540,560,580,520,540,560,580,520,540,560,580,520,540,560,580,520,540,560,580);
constant ENEMY_NUMY : enemy_type := (136,136,136,136,156,156,156,156,176,176,176,176,196,196,196,196,216,216,216,216);
constant ENEMY_NUMDEPTH : integer := 10;
signal enemy_numexist  :STD_LOGIC_VECTOR(19 DOWNTO 0):= (others=>'0');
signal enemy_shown  :STD_LOGIC_VECTOR(19 DOWNTO 0):= (others=>'0');
signal enemynum_x 		: unsigned (9 DOWNTO 0);
signal enemynum_y 		: unsigned (9 DOWNTO 0);
signal enemynum_address : unsigned (6 DOWNTO 0);
signal enemynum_rgb     	: STD_LOGIC_VECTOR (1 DOWNTO 0);

constant ENEMY_LENGTH : integer := 48;
constant ENEMY_DEPTH : integer := 10;
constant ENEMY_X : integer := 504;
constant ENEMY_Y : integer := 116;
signal enemy_exist  :std_logic:= '0'; 
signal enemy_address    : unsigned (8 DOWNTO 0);
signal enemy_rgb     	: STD_LOGIC_VECTOR (1 DOWNTO 0);


--signal enemy_sel    		:STD_LOGIC_VECTOR( downto 0); 
--------------------------------------------UI ENEMY

--Signals for the video controller
type register_type is array(15 downto 0) of unsigned(25 downto 0);
signal RAM : register_type;
type register_type2 is array(7 downto 0) of unsigned(25 downto 0);
signal expRAM : register_type2;

type block_type is array(31 downto 0) of unsigned(5 downto 0);
signal Hpixel : block_type;  -- Horizontal position (36-6)
signal Vpixel : block_type;  -- Vorizontal position (36-12)
signal Hpixel2 : unsigned(5 downto 0);
signal Vpixel2 : unsigned(5 downto 0);

signal Hpixelexp : block_type;  -- Horizontal position (36-6)
signal Vpixelexp : block_type;  -- Vorizontal position (36-12)
signal Hpixel2exp : unsigned(5 downto 0);
signal Vpixel2exp : unsigned(5 downto 0);

signal select_reg : STD_LOGIC_VECTOR(31 DOWNTO 0);
signal select_exp : STD_LOGIC_VECTOR(31 DOWNTO 0);

signal cover : STD_LOGIC_VECTOR(31 DOWNTO 0);
signal expcover : STD_LOGIC_VECTOR(31 DOWNTO 0);

signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
signal EndOfLine, EndOfField : std_logic;
signal vga_hblank, vga_hsync, vga_vblank, vga_vsync : std_logic;  -- Sync. signals

signal background   :std_logic;

signal HBlockCount :unsigned(5 downto 0);
signal VBlockCount :unsigned(5 downto 0);
signal EndOfFourBlockLine, EndOfFourBlockField : std_logic;

signal HPixelCount :unsigned(8 downto 0);
signal VPixelCount :unsigned(8 downto 0);
signal EndOfBlockLine, EndOfBlockField : std_logic;

signal HSubPixelCount :unsigned(4 downto 0);
signal VSubPixelCount :unsigned(4 downto 0);
signal EndOfSubBlockLine, EndOfSubBlockField : std_logic;

signal BlockExist  :std_logic;

signal Scenario_type : unsigned(3 downto 0);

signal vposition  : unsigned(7 downto 0);
signal position   : unsigned(7 downto 0);

signal tank : std_logic;  -- tank area
signal tank_address :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal Scenario_counter 	: unsigned(7 downto 0);
signal pixel_hcounter	: unsigned(5 downto 0);
signal pixel_vcounter	: unsigned(5 downto 0);
signal block_hcounter	: unsigned(4 downto 0);
signal block_vcounter	: unsigned(4 downto 0);
signal tank_counter 	: unsigned(7 downto 0);
signal tank_rgb     	: STD_LOGIC_VECTOR (23 DOWNTO 0);
signal hcenter 			: unsigned(9 downto 0);  -- Horizontal position (0-800)
signal vcenter 			: unsigned(9 downto 0);  -- Vertical position (0-524)

signal Brick_address  :STD_LOGIC_VECTOR (8 DOWNTO 0);
signal Wall_address   :STD_LOGIC_VECTOR (8 DOWNTO 0);
signal Trees_address  :STD_LOGIC_VECTOR (8 DOWNTO 0);
signal Water_address  :STD_LOGIC_VECTOR (8 DOWNTO 0);
signal Ice_address    :STD_LOGIC_VECTOR (8 DOWNTO 0);

signal Scenario_rgb     : STD_LOGIC_VECTOR (23 DOWNTO 0);
signal Brick_rgb     	: STD_LOGIC_VECTOR (23 DOWNTO 0);
signal Wall_rgb     	: STD_LOGIC_VECTOR (23 DOWNTO 0);
signal Trees_rgb     	: STD_LOGIC_VECTOR (23 DOWNTO 0);
signal Water_rgb     	: STD_LOGIC_VECTOR (23 DOWNTO 0);
signal Ice_rgb       	: STD_LOGIC_VECTOR (23 DOWNTO 0);

signal player1_address   :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal player2_address   :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal tank1_address     :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal fasttank_address  :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal armortank_address :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal powertank_address :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal bullet_address    :STD_LOGIC_VECTOR (5 DOWNTO 0);
signal smallburst_address:STD_LOGIC_VECTOR (8 DOWNTO 0);
signal bigburst_address  :STD_LOGIC_VECTOR (10 DOWNTO 0);

signal spirites_rgb     : STD_LOGIC_VECTOR (23 DOWNTO 0);
signal player1_rgb      : STD_LOGIC_VECTOR (23 DOWNTO 0);
--signal player2_rgb     	: STD_LOGIC_VECTOR (23 DOWNTO 0);
signal tank1_rgb     	: STD_LOGIC_VECTOR (23 DOWNTO 0);
signal fasttank_rgb     : STD_LOGIC_VECTOR (1 DOWNTO 0);
signal powertank_rgb    : STD_LOGIC_VECTOR (23 DOWNTO 0);
signal armortank_rgb    : STD_LOGIC_VECTOR (23 DOWNTO 0);
signal bullet_rgb       : STD_LOGIC_VECTOR (23 DOWNTO 0);
signal smallburst_rgb   : STD_LOGIC_VECTOR (23 DOWNTO 0);
signal bigburst_rgb     : STD_LOGIC_VECTOR (23 DOWNTO 0);
signal explsion_rgb     : STD_LOGIC_VECTOR (23 DOWNTO 0);

---------------------------------------------------------------
signal stage_rgb     	 : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal stage_address     : unsigned (12 DOWNTO 0);
signal stagenum_rgb      : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal stagenum1_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal stagenum2_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal stagenum3_rgb     : STD_LOGIC_VECTOR (0 DOWNTO 0);
signal stagenum_address     : unsigned (10 DOWNTO 0);
-------------------------------------------------------------

signal scenario_drawen  : STD_LOGIC := '0';

signal PhoenixExist  :     std_logic;  -- Phoenix
signal Phoenix_address    :STD_LOGIC_VECTOR (10 DOWNTO 0);
signal phoenix_rgb    	  :STD_LOGIC_VECTOR (0 DOWNTO 0);

signal Scenario_address : STD_LOGIC_VECTOR (8 DOWNTO 0);
signal commandUpdate    : std_logic;  
signal temp_command     : STD_LOGIC_VECTOR(31 downto 0);
signal Scenario_command : STD_LOGIC_VECTOR(7 downto 0);
signal scenario_data    : STD_LOGIC_VECTOR(7 downto 0);
signal scenario_wren    : STD_LOGIC ;
signal Command_address  : STD_LOGIC_VECTOR(7 downto 0);
signal delete_bullet    : STD_LOGIC_VECTOR(31 downto 0);
--signal pre_command      : STD_LOGIC_VECTOR(31 downto 0);

signal num_sel    		:STD_LOGIC_VECTOR(1 downto 0);
signal life_sel1    		:STD_LOGIC_VECTOR(2 downto 0);
signal life_sel2    		:STD_LOGIC_VECTOR(2 downto 0);


signal spirites_data    :STD_LOGIC_VECTOR(30 downto 0);
signal explosion_data   :STD_LOGIC_VECTOR(30 downto 0);
							
signal explosion_command:unsigned(25 downto 0);
signal spirites_command :unsigned(25 downto 0);
signal spirites_address :unsigned (10 DOWNTO 0);
signal spirites_dir     :unsigned(1 downto 0);
signal spirites_col     :unsigned(1 downto 0);
signal spirites_type    :unsigned(3 downto 0);
signal spirites_tempdata:STD_LOGIC_VECTOR(25 downto 0);
signal explosion_address :unsigned (10 DOWNTO 0);

signal pixel : unsigned(10 downto 0);  -- Horizontal position (36-6)

component level IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
	);
end component level;

component life IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (9 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
	);
end component life;

component enemy IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
	);
end component enemy;

component enemynum IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
	);
end component enemynum;

component choose IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
	);
end component choose;

component num0 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component num0;

component num1 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component num1;

component num2 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component num2;

component num3 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component num3;

component num4 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component num4;

component num5 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component num5;

component smallburst IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component smallburst;

component bigburst IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component bigburst;

component bullet IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (5 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q			: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component bullet;

component player1 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component player1;

--component player2 IS  
--	PORT
--	(
--		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
--		clock		: IN STD_LOGIC ;
--		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
--	);
--end component player2;

component armorTank IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component armorTank;

component powerTank IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component powerTank;

component fastTank IS    --stands for power
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q			: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
	);
end component fastTank;

component tank1 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component tank1;

component phoenix IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component phoenix;

component brick IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component brick;

component water IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component water;

component wall IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component wall;

component trees IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
	);
end component trees;

--component ice IS  
--	PORT
--	(
--		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
--		clock		: IN STD_LOGIC ;
--		q		: OUT STD_LOGIC_VECTOR (23 DOWNTO 0)
--	);
--end component ice;

component Scenario IS
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (7 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		data		: IN STD_LOGIC_VECTOR (7 DOWNTO 0);
		wren		: IN STD_LOGIC ;
		q		    : OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
	); 
END component Scenario;

component register_26 is 
port (clock : in std_logic;
	  D     : in unsigned(25 downto 0);
	  Q     : out unsigned(25 downto 0);
	  enable : in std_logic;
	  rst   : in std_logic);
END component register_26;

component start IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (15 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
	);
end component start;

component easy IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component easy;

component crazy IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (8 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component crazy;

--component over IS  
--	PORT
--	(
--		address		: IN STD_LOGIC_VECTOR (15 DOWNTO 0);
--		clock		: IN STD_LOGIC ;
--		q		: OUT STD_LOGIC_VECTOR (1 DOWNTO 0)
--	);
--end component over;

component stage IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (12 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component stage;

component stage_num1 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component stage_num1;

component stage_num2 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component stage_num2;

component stage_num3 IS  
	PORT
	(
		address		: IN STD_LOGIC_VECTOR (10 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
	);
end component stage_num3;

begin

the_num0 : num0
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(num_address),
		q => num0_rgb);
		
the_num1 : num1
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(num_address),
		q => num1_rgb);

the_num2 : num2
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(num_address),
		q => num2_rgb);

the_num3 : num3
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(num_address),
		q => num3_rgb);

the_num4 : num4
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(num_address),
		q => num4_rgb);

the_num5 : num5
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(num_address),
		q => num5_rgb);

the_level : level
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(level_address),
		q => level_rgb);
		
the_life : life
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(life_address),
		q => life_rgb);
		
the_enemy : enemy
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(enemy_address),
		q => enemy_rgb);
		
the_enemynum : enemynum
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(signal_address),
		q => enemynum_rgb);
		
the_choose : choose
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(choose_address),
		q => choose_rgb);

the_stage_num1 : stage_num1
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(stagenum_address),
		q => stagenum1_rgb);
		
the_stage_num2 : stage_num2
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(stagenum_address),
		q => stagenum2_rgb);
		
the_stage_num3 : stage_num3
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(stagenum_address),
		q => stagenum3_rgb);

the_start : start
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(start_address),
		q => start_rgb);
		
the_easy : easy
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(normal_address),
		q => normal_rgb);
		
the_crazy : crazy
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(diff_address),
		q => diff_rgb);

--the_over : over
--    port map(
--		clock => clk50,
--		address => STD_LOGIC_VECTOR(end_address),
--		q => end_rgb);
		
the_stage : stage
    port map(
		clock => clk50,
		address => STD_LOGIC_VECTOR(stage_address),
		q => stage_rgb);

the_Scenario :Scenario
	port map(
	clock => clk50,
	data  => scenario_data,
	wren  => scenario_wren,
	address => command_address,
	q => Scenario_command );

the_bullet : bullet
    port map(
		clock => clk50,
		address => bullet_address,
		q => bullet_rgb);
		
the_smallburst : smallburst
    port map(
		clock => clk50,
		address => smallburst_address,
		q => smallburst_rgb);

the_bigburst : bigburst
    port map(
		clock => clk50,
		address => bigburst_address,
		q => bigburst_rgb);
			
the_tank1 : tank1
    port map(
		clock => clk50,
		address => tank1_address,
		q => tank1_rgb);
		
the_player1 : player1
    port map(
		clock => clk50,
		address => player1_address,
		q => player1_rgb);
		
--the_player2 : player2
--    port map(
--		clock => clk50,
--		address => player2_address,
--		q => player2_rgb);
		
the_powerTank : powerTank
    port map(
		clock => clk50,
		address => powertank_address,
		q => powertank_rgb);

the_fastTank : fastTank
    port map(
		clock => clk50,
		address => fasttank_address,
		q => fasttank_rgb);
		
the_armorTank : armorTank
    port map(
		clock => clk50,
		address => armortank_address,
		q => armortank_rgb);
		
the_phoenix : phoenix
    port map(
		clock => clk50,
		address => phoenix_address,
		q => phoenix_rgb);

the_brick : brick
	port map(
		clock => clk50,
		address => Brick_address,
		q => Brick_rgb);

the_wall : wall
	port map(
		clock => clk50,
		address => Wall_address,
		q => Wall_rgb);
				
the_water : water
	port map(
		clock => clk50,
		address => Water_address,
		q => Water_rgb);
		
--the_ice : ice
--	port map(
--		clock => clk50,
--		address => Ice_address,
--		q => Ice_rgb);
				
the_trees : trees
	port map(
		clock => clk50,
		address => trees_address,
		q => trees_rgb);

-- Horizontal and vertical counters
HCounter : process (clk)
begin
if rising_edge(clk) then      
	if reset = '1' then
		Hcount <= (others => '0');
	elsif EndOfLine = '1' then
		Hcount <= (others => '0');
	else
		Hcount <= Hcount + 1;
	end if;      
end if;
end process HCounter;

EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
VCounter: process (clk)
begin
if rising_edge(clk) then      
	if reset = '1' then
		Vcount <= (others => '0');
	elsif EndOfLine = '1' then
		if EndOfField = '1' then
			Vcount <= (others => '0');
		else
			Vcount <= Vcount + 1;
		end if;
	end if;
end if;
end process VCounter;

EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

-- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

HSyncGen : process (clk)
begin
if rising_edge(clk) then     
	if reset = '1' or EndOfLine = '1' then
		vga_hsync <= '1';
	elsif Hcount = HSYNC - 1 then
		vga_hsync <= '0';
	end if;
end if;
end process HSyncGen;
  
HBlankGen : process (clk)
begin
if rising_edge(clk) then
	if reset = '1' then
		vga_hblank <= '1';
	elsif Hcount = HSYNC + HBACK_PORCH then
		vga_hblank <= '0';
	elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
		vga_hblank <= '1';
	end if;      
end if;
end process HBlankGen;

VSyncGen : process (clk)
begin
if rising_edge(clk) then
	if reset = '1' then
		vga_vsync <= '1';
	elsif EndOfLine ='1' then
		if EndOfField = '1' then
			vga_vsync <= '1';
		elsif Vcount = VSYNC - 1 then
			vga_vsync <= '0';
		end if;
	end if;      
end if;
end process VSyncGen;

VBlankGen : process (clk)
begin
if rising_edge(clk) then    
	if reset = '1' then
		vga_vblank <= '1';
	elsif EndOfLine = '1' then
		if Vcount = VSYNC + VBACK_PORCH - 1 then
			vga_vblank <= '0';
		elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
			vga_vblank <= '1';
		end if;
	end if;
end if;
end process VBlankGen;
	
tempCommand : process (clk50)
begin
if rising_edge(clk50) then    
	if reset = '1' then
	temp_command <= (others => '0');
	else
	temp_command <= std_logic_vector(command(31 downto 0));
	end if;
end if;
end process tempCommand;

scenario_wren <= '1' when (temp_command(31) = '1') and (commandUpdate = '1') and (temp_command(23 downto 4) /= X"FFFFF") and (temp_command(31 downto 20) /= X"FF0") else
				 '0';

with scenario_wren select Command_address <= 
	std_logic_vector(unsigned("0000"&(temp_command(15 downto 12))) + (unsigned("0000"&(temp_command(11 downto 8))) sll 3) + (unsigned("0000"&(temp_command(11 downto 8))) sll 2) + unsigned("0000"&(temp_command(11 downto 8)))) when '1',
	std_logic_vector(position + (vposition sll 3) + (vposition sll 2) + (vposition)) when others;

with temp_command(31) select scenario_data <= 
		temp_command(7 downto 0) when '1',
		(others => '0') when others;
		

spirites_data <= temp_command(30 downto 0) when (temp_command(31) = '0') 
										   and (temp_command /= 0) 
										   and (temp_command(5 downto 2) /= "1000") 
										   and (temp_command(5 downto 2) /= "1001") else
										   (others => '0');		
		
explosion_data <= temp_command(30 downto 0) when (temp_command(31) = '0') 
										    and ((temp_command(5 downto 2) = "1000") 
										    or  (temp_command(5 downto 2)  = "1001")) else
										    (others => '0');
										    
--start_x <= temp_command(9 downto 0) when (temp_command(31 downto 12) = X"0FFFF" and temp_command(11 downto 10) = "00")
--													else "0000000000";
										   		
cordUpdate : process (clk50)
begin
if rising_edge(clk50) then    
	if reset = '1' then
		scenario_drawen <= '0';
	elsif  (temp_command = X"FFFFFFFF") then 
		scenario_drawen <= '0';
	elsif  (temp_command(31 downto 12) = X"00FFF" and temp_command(11 downto 10) = "00") then
		start_x <= temp_command(9 downto 0);
		start_end <='0';
	elsif  (temp_command = X"00FFFFFF") then
		start_end <= '1';
	elsif  (temp_command(31 downto 4) = X"0F0FFFF")  then
		choose_diff <= temp_command(0 downto 0);
--	elsif  (temp_command = X"0F0FFFFF") then
--		over_end <= '1';
	elsif  (temp_command(27 downto 0) = X"FFFFFFF") then
		num_sel <= temp_command(29 downto 28);
	elsif  (temp_command(23 downto 0) = X"FFFFF0") then
		life_sel1<= temp_command(26 downto 24);
		life_sel2<= temp_command(30 downto 28);
	elsif  (temp_command(31 downto 20) = X"FF0") then 
		enemy_shown <= temp_command(19 downto 0);
	elsif  (temp_command = X"00000000") then 
		scenario_drawen <= '1';
	end if;
end if;
end process cordUpdate;
commandUpdate <= '1' when vga_hsync='1' and vga_vsync='1' else '0';

--------------------------------------------------------------------------------------
 background <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= HOFFSET) and 
						((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (HOFFSET + TOTAL_PIXELS)) and 
						((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= VOFFSET) and
						((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (VACTIVE - VOFFSET))) else '0';
 
 start_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= start_x) and 
						 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (start_x + START_LENGTH)) and 
						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= START_Y) and
						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (START_Y + START_DEPTH)) and 
						  (start_end = '0')) else '0';
	
 diff_exist <= '1'	when (((to_integer(Hcount)-HBACK_PORCH-HSYNC-OFFSET) >= start_x) and 
						 ((to_integer(Hcount)-HBACK_PORCH-HSYNC-OFFSET) < (start_x + DIFF_LENGTH)) and 
						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= DIFF_Y) and
						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (DIFF_Y + DIFF_DEPTH))and 
						  (start_end = '0')) else '0';
						 
 normal_exist <= '1'when (((to_integer(Hcount)-HBACK_PORCH-HSYNC-OFFSET) >= start_x) and 
						 ((to_integer(Hcount)-HBACK_PORCH-HSYNC-OFFSET) < (start_x + NORMAL_LENGTH)) and 
						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= NORMAL_Y) and
						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (NORMAL_Y + NORMAL_DEPTH))and 
						 (start_end = '0')) else '0';
						 
 choose1_exist <= '1'when (((to_integer(Hcount)-HBACK_PORCH-HSYNC-CHOOSE_X ) >= start_x) and 
						  ((to_integer(Hcount)-HBACK_PORCH-HSYNC-CHOOSE_X ) < (start_x + 10)) and 
						  ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= NORMAL_Y) and
						  ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (NORMAL_Y + 10))and 
						  (start_end = '0') and choose_diff = "0") else '0';
						 
 choose2_exist <= '1'when (((to_integer(Hcount)-HBACK_PORCH-HSYNC-CHOOSE_X ) >= start_x) and 
						  ((to_integer(Hcount)-HBACK_PORCH-HSYNC-CHOOSE_X ) < (start_x + 10)) and 
						  ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= DIFF_Y) and
						  ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (DIFF_Y + 10))and 
						  (start_end = '0') and choose_diff = "1") else '0';
--index_exist  <= '1' when 
						 				  
-- end_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= end_x) and 
--						 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (end_x + END_LENGTH)) and 
--						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= END_Y) and
--						 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (END_Y + END_DEPTH)) and 
--						  (over_end = '0')) else '0';						  
 
 stage_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= STAGE_X) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (STAGE_X + STAGE_LENGTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= STAGE_Y) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (STAGE_Y + BLOCK_PIXELS)) and (start_end = '1' )) else '0';

 stagenum_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= STAGE_NUMX) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (STAGE_NUMX + BLOCK_PIXELS)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= STAGE_NUMY) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (STAGE_NUMY + BLOCK_PIXELS))) else '0';
 ----------------------------------------------------------------------------------------new
 level_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= LEVEL_X) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (LEVEL_X + LEVEL_LENGTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= LEVEL_Y) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (LEVEL_Y + LEVEL_DEPTH))) else '0';
 
 levelnum_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= LEVEL_NUMX) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (LEVEL_NUMX + LEVEL_DEPTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= LEVEL_NUMY) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (LEVEL_NUMY + LEVEL_DEPTH))) else '0';
 
  life_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= LIFE_X) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (LIFE_X + LIFE_LENGTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= LIFE_Y) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (LIFE_Y + LIFE_DEPTH))) else '0';
 
  lifenum1_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= LIFE_NUMX1) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (LIFE_NUMX1 + LIFE_DEPTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= LIFE_NUMY1) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (LIFE_NUMY1 + LIFE_DEPTH))) else '0';
 
  lifenum2_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= LIFE_NUMX2) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (LIFE_NUMX2 + LIFE_DEPTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= LIFE_NUMY2) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (LIFE_NUMY2 + LIFE_DEPTH))) else '0';

  enemy_exist <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= ENEMY_X) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (ENEMY_X + ENEMY_LENGTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= ENEMY_Y) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (ENEMY_Y + ENEMY_DEPTH))) else '0';

  generate_enemy:
	for i in 0 to 19 generate  
  enemy_numexist(i) <= '1' when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= ENEMY_NUMX(i)) and 
 ((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (ENEMY_NUMX(i) + ENEMY_NUMDEPTH)) and 
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= ENEMY_NUMY(i)) and
 ((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (ENEMY_NUMY(i) + ENEMY_NUMDEPTH)) and enemy_shown(i) = '1') else '0';
 end generate;
 
 
  player_exist <= "01" when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= PLAYER1_X) and 
						((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (PLAYER1_X + ENEMY_DEPTH)) and 
						((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= PLAYER1_Y) and
						((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (PLAYER1_Y + ENEMY_DEPTH))) else 
				  "10" when (((to_integer(Hcount)-HBACK_PORCH-HSYNC) >= PLAYER1_X) and 
						((to_integer(Hcount)-HBACK_PORCH-HSYNC) < (PLAYER1_X + ENEMY_DEPTH)) and 
						((to_integer(Vcount)-VBACK_PORCH-VSYNC) >= PLAYER2_Y) and
						((to_integer(Vcount)-VBACK_PORCH-VSYNC) < (PLAYER2_Y + ENEMY_DEPTH))) else "00";
  
 
 ----------------------------------------------------------------------------------------------new
  PhoenixExist <='1' when (position = PHOENIX_X) and (vposition = PHOENIX_Y) else '0';
 ------------------------------------------------------------------------------------------------
 
HPixelCounter : process (clk)
begin
	if rising_edge(clk) then
		if reset = '1' then
		 HPixelCount <= (others => '0');
		elsif vga_hblank = '0' and vga_vblank ='0' and background = '1' then
		if EndOfBlockLine = '1' then
			HPixelCount <= (others => '0');
		else 
			HPixelCount <= HPixelCount + 1;
		end if;
		else 
			HPixelCount <= (others => '0');
	  end if;
	end if;
end process HPixelCounter;
EndOfBlockLine <= '1' when HPixelCount = TOTAL_PIXELS - 1 else '0';

VPixelCounter : process (clk)
begin
	if rising_edge(clk) then
	  if reset = '1' then
		  VPixelCount <= (others => '0');
	 elsif vga_hblank = '0' and vga_vblank ='0' and background = '1' then
	    if EndOfBlockLine = '1' then
		  if EndOfBlockField = '1' then
			VPixelCount <= (others => '0');
		else
			VPixelCount <= VPixelCount + 1;
		end if;
	  end if;
	 end if;
end if;
end process VPixelCounter;
EndOfBlockField <= '1' when VPixelCount = TOTAL_PIXELS - 1 else '0';

HSubPixelCounter : process (clk)
begin
	if rising_edge(clk) then
	  if reset = '1' then
		HSubPixelCount <= (others => '0');
	  elsif vga_hblank = '0' and vga_vblank ='0' and background = '1' then
		 if EndOfSubBlockLine = '1' then
			HSubPixelCount <= (others => '0');
		 else
			HSubPixelCount <= HSubPixelCount + 1;
		 end if;
	  else
		HSubPixelCount <= (others => '0');
	  end if;
	end if;
end process HSubPixelCounter;
EndOfSubBlockLine <= '1' when HSubPixelCount = SQUAR_PIXELS - 1 else '0';

VSubPixelCounter : process (clk)
begin
	if rising_edge(clk) then
	  if reset = '1' then
		VSubPixelCount <= (others => '0');
	elsif vga_hblank = '0' and vga_vblank ='0' and background = '1' then
	  if EndOfBlockLine = '1' then
		if EndOfSubBlockField = '1' then
			VSubPixelCount <= (others => '0');
		else
			VSubPixelCount <= VSubPixelCount + 1;
		end if;
	  end if;
	end if;
end if;
end process VSubPixelCounter;
EndOfSubBlockField <= '1' when VSubPixelCount = SQUAR_PIXELS - 1 else '0';

HBlockCounter : process (clk)
begin
	if rising_edge(clk) then
	  if reset = '1' then
		HBlockCount <= (others => '0');
	  elsif background = '1' then
		if EndOfFourBlockLine = '1' then
		HBlockCount <= (others => '0');
		else
		HBlockCount <= HBlockCount + 1;
		end if;
		else
		HBlockCount <= (others => '0');
	end if;
end if;
end process HBlockCounter;
EndOfFourBlockLine <= '1' when HBlockCount = BLOCK_PIXELS - 1 else '0';

VBlockCounter : process (clk)
begin
	if rising_edge(clk) then
	  if reset = '1' then
		VBlockCount <= (others => '0');	
	elsif background = '1' then
	 if EndOfBlockLine = '1' then
		if EndOfFourBlockField = '1' then
			VBlockCount <= (others => '0');
		else
			VBlockCount <= VBlockCount + 1;
		end if;
	end if;
end if;
end if;
end process VBlockCounter;
EndOfFourBlockField <= '1' when VBlockCount = BLOCK_PIXELS - 1 else '0';

positionCounter : process (clk)
begin
	if rising_edge(clk) then
		if reset = '1' then
			position <= (others => '0');
		elsif background = '1' then
		 if EndOfBlockField = '1' then
			position <= (others => '0');
		 elsif EndOfFourBlockLine = '1' then
			position <= position + 1 ;
		 end if;
		else
		position <= (others => '0');
	  end if;
	end if;
end process positionCounter;

VpositionCounter : process (clk)
begin
	if rising_edge(clk) then
		if reset = '1' then
			vposition <= (others => '0');
		elsif background = '1' then
		 if EndOfBlockField = '1' then
			vposition <= (others => '0');
		 elsif EndOfFourBlockField = '1' and EndOfBlockLine = '1' then
			vposition <= vposition + 1 ;
		 end if;
	  end if;
	end if;
end process VpositionCounter;
		 
start_address <= to_unsigned(((to_integer(Hcount) - HBACK_PORCH - HSYNC - to_integer(unsigned(start_x))) + START_LENGTH*(to_integer(Vcount) -VBACK_PORCH-VSYNC-START_Y)),16);

normal_address <= to_unsigned(((to_integer(Hcount) - HBACK_PORCH - HSYNC - OFFSET - to_integer(unsigned(start_x))) + NORMAL_LENGTH*(to_integer(Vcount) -VBACK_PORCH-VSYNC-NORMAL_Y)),9);

diff_address <= to_unsigned(((to_integer(Hcount) - HBACK_PORCH - HSYNC - OFFSET - to_integer(unsigned(start_x))) + DIFF_LENGTH*(to_integer(Vcount) -VBACK_PORCH-VSYNC-DIFF_Y)),9);

choose1_address<= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - CHOOSE_X - to_integer(unsigned(start_x)) ) +   ENEMY_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-NORMAL_Y))),7);

choose2_address<= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - CHOOSE_X - to_integer(unsigned(start_x)) ) +   ENEMY_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-DIFF_Y))),7);

with choose_diff(0 downto 0) select choose_address <= choose1_address when "0",
													  choose2_address when "1",
													  (others => '0') when others;
												 
--end_address <= to_unsigned(((to_integer(Hcount) - HBACK_PORCH - HSYNC - to_integer(unsigned(end_x))) + END_LENGTH*(to_integer(Vcount) -VBACK_PORCH-VSYNC-START_Y)),16);
		
Phoenix_address <= std_logic_vector("10100001111" - (("00000"&HBlockCount) + (("00000"&VBlockCount) sll 5) + (("00000"&VBlockCount) sll 2)));

stage_address   <= to_unsigned((5183 - ((to_integer(Hcount) - HBACK_PORCH - HSYNC - STAGE_X ) + STAGE_LENGTH*(to_integer(Vcount) -VBACK_PORCH-VSYNC-STAGE_Y))),13);

stagenum_address<= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - STAGE_NUMX ) +  BLOCK_PIXELS*(to_integer(Vcount)-VBACK_PORCH-VSYNC-STAGE_NUMY))),11);

level_address<= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - LEVEL_X ) +  LEVEL_LENGTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-LEVEL_Y))),9);

enemy_address<= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - ENEMY_X ) +  ENEMY_LENGTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-ENEMY_Y))),9);

with enemy_numexist(19 downto 0) select enemynum_x <= to_unsigned(ENEMY_NUMX(0),10) when X"00001",
													  to_unsigned(ENEMY_NUMX(1),10) when X"00002",
													  to_unsigned(ENEMY_NUMX(2),10) when X"00004",
													  to_unsigned(ENEMY_NUMX(3),10) when X"00008",
													  to_unsigned(ENEMY_NUMX(4),10) when X"00010",
													  to_unsigned(ENEMY_NUMX(5),10) when X"00020",
													  to_unsigned(ENEMY_NUMX(6),10) when X"00040",
													  to_unsigned(ENEMY_NUMX(7),10) when X"00080",
													  to_unsigned(ENEMY_NUMX(8),10) when X"00100",
													  to_unsigned(ENEMY_NUMX(9),10) when X"00200",
													  to_unsigned(ENEMY_NUMX(10),10) when X"00400",
													  to_unsigned(ENEMY_NUMX(11),10) when X"00800",
													  to_unsigned(ENEMY_NUMX(12),10)  when X"01000",
													  to_unsigned(ENEMY_NUMX(13),10) when X"02000",
													  to_unsigned(ENEMY_NUMX(14),10) when X"04000",
													  to_unsigned(ENEMY_NUMX(15),10) when X"08000",
													  to_unsigned(ENEMY_NUMX(16),10) when X"10000",
													  to_unsigned(ENEMY_NUMX(17),10) when X"20000",
													  to_unsigned(ENEMY_NUMX(18),10) when X"40000",
													  to_unsigned(ENEMY_NUMX(19),10) when X"80000",
	   												  (others => '0') when others;

with enemy_numexist(19 downto 0) select enemynum_y <= to_unsigned(ENEMY_NUMY(0),10) when X"00001",
													  to_unsigned(ENEMY_NUMY(1),10) when X"00002",
													  to_unsigned(ENEMY_NUMY(2),10) when X"00004",
													  to_unsigned(ENEMY_NUMY(3),10) when X"00008",
													  to_unsigned(ENEMY_NUMY(4),10) when X"00010",
													  to_unsigned(ENEMY_NUMY(5),10) when X"00020",
													  to_unsigned(ENEMY_NUMY(6),10) when X"00040",
													  to_unsigned(ENEMY_NUMY(7),10) when X"00080",
													  to_unsigned(ENEMY_NUMY(8),10) when X"00100",
													  to_unsigned(ENEMY_NUMY(9),10) when X"00200",
													  to_unsigned(ENEMY_NUMY(10),10) when X"00400",
													  to_unsigned(ENEMY_NUMY(11),10) when X"00800",
													  to_unsigned(ENEMY_NUMY(12),10) when X"01000",
													  to_unsigned(ENEMY_NUMY(13),10) when X"02000",
													  to_unsigned(ENEMY_NUMY(14),10) when X"04000",
													  to_unsigned(ENEMY_NUMY(15),10) when X"08000",
													  to_unsigned(ENEMY_NUMY(16),10) when X"10000",
													  to_unsigned(ENEMY_NUMY(17),10) when X"20000",
													  to_unsigned(ENEMY_NUMY(18),10) when X"40000",
													  to_unsigned(ENEMY_NUMY(19),10) when X"80000",
	   												  (others => '0') when others;
	   												  	   												 
with player_exist select signal_address <= signal1_address when "01",
										   signal2_address when "10",
										   enemynum_address when others;
										 
enemynum_address<= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - to_integer(enemynum_x)) +  ENEMY_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-to_integer(enemynum_y)))),7);

signal1_address <= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - PLAYER1_X) +  ENEMY_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-PLAYER1_Y))),7);

signal2_address <= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - PLAYER1_X) +  ENEMY_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-PLAYER2_Y))),7);

levelnum_address  <= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - LEVEL_NUMX ) +  LEVEL_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-LEVEL_NUMY))),7);

life_address<= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - LIFE_X ) +  LIFE_LENGTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-LIFE_Y))),10);

lifenum1_address  <= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - LIFE_NUMX1 ) +  LIFE_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-LIFE_NUMY1))),7);

lifenum2_address  <= to_unsigned((((to_integer(Hcount) - HBACK_PORCH - HSYNC - LIFE_NUMX2 ) +  LIFE_DEPTH*(to_integer(Vcount)-VBACK_PORCH-VSYNC-LIFE_NUMY2))),7);
	 
with num_sel(1 downto 0) select stagenum_rgb <= stagenum1_rgb when "01",
												stagenum2_rgb when "10",
												stagenum3_rgb when "11",
												(others => '0') when others;

with num_sel(1 downto 0) select levelnum_rgb <= num1_rgb when "01",
												num2_rgb when "10",
												num3_rgb when "11",
											    (others => '0') when others;
											    
with life_sel1(2 downto 0) select lifenum1_rgb <= num0_rgb when "000",
												  num1_rgb when "001",
												  num2_rgb when "010",
												  num3_rgb when "011",
												  num4_rgb when "100",
												  num5_rgb when "101",
											     (others => '0') when others;

with life_sel2(2 downto 0) select lifenum2_rgb <= num0_rgb when "000",
												  num1_rgb when "001",
												  num2_rgb when "010",
												  num3_rgb when "011",
												  num4_rgb when "100",
												  num5_rgb when "101",
											     (others => '0') when others;
											    

with levelnum_exist select num_address <=  levelnum_address when '1',
										   lifenum_address when others;

with lifenum1_exist select lifenum_address <= lifenum1_address when '1',
											  lifenum2_address when others;
								
--------------------------------------------------------------------------------------------scenario
with Scenario_command(3 downto 0) select Scenario_rgb <=
	Brick_rgb when	"0001",
	Wall_rgb  when	"0010",
	Trees_rgb when	"0011",
	Water_rgb when	"0100",
	Ice_rgb   when	"0101",
	(others => '0') when others;
	
	BlockExist <= '1' when   
				 (((HBlockCount >= "000000") and (HBlockCount <"010010") and (VBlockCount >= "000000")  and (VBlockCount<"010010") and (Scenario_command(4) = '1')) 
			   or ((HBlockCount >= "010010") and (HBlockCount <"100100") and (VBlockCount >= "000000")  and (VBlockCount<"010010") and (Scenario_command(5) = '1'))
			   or ((HBlockCount >= "000000") and (HBlockCount <"010010") and (VBlockCount >= "010010")  and (VBlockCount<"100100") and (Scenario_command(6) = '1'))
			   or ((HBlockCount >= "010010") and (HBlockCount <"100100") and (VBlockCount >= "010010")  and (VBlockCount<"100100") and (Scenario_command(7) = '1')))
			   else '0';
			   
	Scenario_address <= std_logic_vector((("0000"&HSubPixelCount) + (("0000"&VSubPixelCount) sll 4) + (("0000"&VSubPixelCount) sll 1)));
	Brick_address <= Scenario_address;
	Wall_address  <= Scenario_address;
	Trees_address <= Scenario_address;
	Water_address <= Scenario_address;
	Ice_address   <= Scenario_address;
	
--------------------------------------------------------------explosion
explosion_select: select_exp <= 
	X"ffffffff" when scenario_drawen = '0' else
	X"00000000" when explosion_data = 0 else
	X"00000001" when explosion_data(30 downto 26) = "00000" else
	X"00000002" when explosion_data(30 downto 26) = "00001" else
	X"00000004" when explosion_data(30 downto 26) = "00010" else
	X"00000008" when explosion_data(30 downto 26) = "00011" else
	X"00000010" when explosion_data(30 downto 26) = "00100" else
	X"00000020" when explosion_data(30 downto 26) = "00101" else
	X"00000040" when explosion_data(30 downto 26) = "00110" else
	X"00000080" when explosion_data(30 downto 26) = "00111" else
--	X"00000100" when explosion_data(30 downto 26) = "01000" else
--	X"00000200" when explosion_data(30 downto 26) = "01001" else
--	X"00000400" when explosion_data(30 downto 26) = "01010" else
--	X"00000800" when explosion_data(30 downto 26) = "01011" else
--	X"00001000" when explosion_data(30 downto 26) = "01100" else
--	X"00002000" when explosion_data(30 downto 26) = "01101" else
--	X"00004000" when explosion_data(30 downto 26) = "01110" else
--	X"00008000" when explosion_data(30 downto 26) = "01111" else
--	X"00010000" when explosion_data(30 downto 26) = "10000" else
--	X"00020000" when explosion_data(30 downto 26) = "10001" else
--	X"00040000" when explosion_data(30 downto 26) = "10010" else
--	X"00080000" when explosion_data(30 downto 26) = "10011" else
--	X"00100000" when explosion_data(30 downto 26) = "10100" else
--	X"00200000" when explosion_data(30 downto 26) = "10101" else
--	X"00400000" when explosion_data(30 downto 26) = "10110" else
--	X"00800000" when explosion_data(30 downto 26) = "10111" else
--	X"01000000" when explosion_data(30 downto 26) = "11000" else
--	X"02000000" when explosion_data(30 downto 26) = "11001" else
--	X"04000000" when explosion_data(30 downto 26) = "11010" else
--	X"08000000" when explosion_data(30 downto 26) = "11011" else
--	X"10000000" when explosion_data(30 downto 26) = "11100" else
--	X"20000000" when explosion_data(30 downto 26) = "11101" else
--	X"40000000" when explosion_data(30 downto 26) = "11110" else
--	X"80000000" when explosion_data(30 downto 26) = "11111" else
	X"00000000";


generate_labe3:
	for i in 0 to 7 generate 
		stage3 : register_26 port map (clk50,unsigned (explosion_data(25 downto 0)),expRAM(i),select_exp(i),scenario_drawen);
	end generate;
	
generate_label4:
	for i in 0 to 7 generate

	Hexpselect: Hpixelexp(i) <= 
	"010010" when (expRAM(i)(5 downto 2) = "1000") else
	"100100" ;
	
	Vexpselect: Vpixelexp(i) <= 
	"010010" when (expRAM(i)(5 downto 2) = "1000") else
	"100100" ;
	
	stage4: expcover(i) <= '1' when ((expRAM(i) > 0) and ((to_integer(Hcount)-HBACK_PORCH-HSYNC - HOFFSET ) >= to_integer((expRAM(i)(25 downto 17)))) and 
								    ((to_integer(Hcount)-HBACK_PORCH-HSYNC - HOFFSET ) < ( to_integer(Hpixelexp(i)) + (to_integer(expRAM(i)(25 downto 17))))) and 
								    ((to_integer(Vcount)-VBACK_PORCH-VSYNC - VOFFSET ) >= to_integer((expRAM(i)(16 downto 8)))) and
							        ((to_integer(Vcount)-VBACK_PORCH-VSYNC - VOFFSET ) < ( to_integer(Vpixelexp(i)) + (to_integer(expRAM(i)(16 downto 8)))))) else '0';
	end generate;
		
	explosion_coder: explosion_command <= 	
	 expRAM(0)   when  expcover(31 downto 0) =  X"00000001" else
	 expRAM(1)   when  expcover(31 downto 0) =  X"00000002" else
	 expRAM(2)   when  expcover(31 downto 0) =  X"00000004" else
	 expRAM(3)   when  expcover(31 downto 0) =  X"00000008" else
	 expRAM(4)   when  expcover(31 downto 0) =  X"00000010" else
	 expRAM(5)   when  expcover(31 downto 0) =  X"00000020" else
	 expRAM(6)   when  expcover(31 downto 0) =  X"00000040" else
	 expRAM(7)   when  expcover(31 downto 0) =  X"00000080" else
--	 expRAM(8)   when  expcover(31 downto 0) =  X"00000100" else
--	 expRAM(9)   when  expcover(31 downto 0) =  X"00000200" else
--	 expRAM(10)  when  expcover(31 downto 0) =  X"00000400" else
--	 expRAM(11)  when  expcover(31 downto 0) =  X"00000800" else
--	 expRAM(12)  when  expcover(31 downto 0) =  X"00001000" else
--	 expRAM(13)  when  expcover(31 downto 0) =  X"00002000" else
--	 expRAM(14)  when  expcover(31 downto 0) =  X"00004000" else
--	 expRAM(15)  when  expcover(31 downto 0) =  X"00008000" else
--	 expRAM(16)  when  expcover(31 downto 0) =  X"00010000" else
--	 expRAM(17)  when  expcover(31 downto 0) =  X"00020000" else
--	 expRAM(18)  when  expcover(31 downto 0) =  X"00040000" else
--	 expRAM(19)  when  expcover(31 downto 0) =  X"00080000" else
--	 expRAM(20)  when  expcover(31 downto 0) =  X"00100000" else
--	 expRAM(21)  when  expcover(31 downto 0) =  X"00200000" else
--	 expRAM(22)  when  expcover(31 downto 0) =  X"00400000" else
--	 expRAM(23)  when  expcover(31 downto 0) =  X"00800000" else
--	 expRAM(24)  when  expcover(31 downto 0) =  X"01000000" else
--	 expRAM(25)  when  expcover(31 downto 0) =  X"02000000" else
--	 expRAM(26)  when  expcover(31 downto 0) =  X"04000000" else
--	 expRAM(27)  when  expcover(31 downto 0) =  X"08000000" else
--	 expRAM(28)  when  expcover(31 downto 0) =  X"10000000" else
--	 expRAM(29)  when  expcover(31 downto 0) =  X"20000000" else
--	 expRAM(30)  when  expcover(31 downto 0) =  X"40000000" else
--	 expRAM(31)  when  expcover(31 downto 0) =  X"80000000" else
	 (others=>'0');
	
	
	with explosion_command(5 downto 2) select explsion_rgb <=
	smallburst_rgb  when "1000",
	bigburst_rgb    when "1001",
	(others => '0') when others;
	
	Hexpselect: Hpixel2exp <= 
	"010010" when (explosion_command(5 downto 2) = "1000") else
	"100100" ;
	
	explosion_address <=to_unsigned(((to_integer(Hcount) - HBACK_PORCH - HSYNC - HOFFSET - to_integer(explosion_command(25 downto 17))) + to_integer(Hpixel2exp)*(to_integer(Vcount)- VOFFSET -VBACK_PORCH-VSYNC-to_integer(explosion_command(16 downto 8)))),11);
	smallburst_address<= std_logic_vector(explosion_address(8 DOWNTO 0));
	bigburst_address  <= std_logic_vector(explosion_address);

--------------------------------------------------------------explosion

-----------------------------------------------------------------------------------spirite
spirites_select: select_reg <= 
	X"ffffffff" when scenario_drawen = '0' else
	X"00000000" when spirites_data = 0 else
	X"00000001" when spirites_data(30 downto 26) = "00000" else
	X"00000002" when spirites_data(30 downto 26) = "00001" else
	X"00000004" when spirites_data(30 downto 26) = "00010" else
	X"00000008" when spirites_data(30 downto 26) = "00011" else
	X"00000010" when spirites_data(30 downto 26) = "00100" else
	X"00000020" when spirites_data(30 downto 26) = "00101" else
	X"00000040" when spirites_data(30 downto 26) = "00110" else
	X"00000080" when spirites_data(30 downto 26) = "00111" else
	X"00000100" when spirites_data(30 downto 26) = "01000" else
	X"00000200" when spirites_data(30 downto 26) = "01001" else
	X"00000400" when spirites_data(30 downto 26) = "01010" else
	X"00000800" when spirites_data(30 downto 26) = "01011" else
	X"00001000" when spirites_data(30 downto 26) = "01100" else
	X"00002000" when spirites_data(30 downto 26) = "01101" else
	X"00004000" when spirites_data(30 downto 26) = "01110" else
	X"00008000" when spirites_data(30 downto 26) = "01111" else
--	X"00010000" when spirites_data(30 downto 26) = "10000" else
--	X"00020000" when spirites_data(30 downto 26) = "10001" else
--	X"00040000" when spirites_data(30 downto 26) = "10010" else
--	X"00080000" when spirites_data(30 downto 26) = "10011" else
--	X"00100000" when spirites_data(30 downto 26) = "10100" else
--	X"00200000" when spirites_data(30 downto 26) = "10101" else
--	X"00400000" when spirites_data(30 downto 26) = "10110" else
--	X"00800000" when spirites_data(30 downto 26) = "10111" else
--	X"01000000" when spirites_data(30 downto 26) = "11000" else
--	X"02000000" when spirites_data(30 downto 26) = "11001" else
--	X"04000000" when spirites_data(30 downto 26) = "11010" else
--	X"08000000" when spirites_data(30 downto 26) = "11011" else
--	X"10000000" when spirites_data(30 downto 26) = "11100" else
--	X"20000000" when spirites_data(30 downto 26) = "11101" else
--	X"40000000" when spirites_data(30 downto 26) = "11110" else
--	X"80000000" when spirites_data(30 downto 26) = "11111" else
	X"00000000";

generate_label:
	for i in 0 to 15 generate 
		stage1 : register_26 port map (clk50,unsigned (spirites_data(25 downto 0)),RAM(i),select_reg(i),scenario_drawen);
	end generate;
	

generate_label2:
	for i in 0 to 15 generate
	
	Hselect: Hpixel(i) <= 
	"000110" when (RAM(i)(5 downto 2) = "0111") else
	"100100" ;
	
	Vselect: Vpixel(i) <= 
	"000110" when (RAM(i)(5 downto 2) = "0111") else
	"100100" ;
	
	delete_bullet(i) <= '1' when (RAM(i)(5 downto 2) = "0111") and (RAM(i)(25 downto 17) = "000000000") and ((RAM(i)(16 downto 8) = "000000000")) else
						'0';
	
	stage2: cover(i) <= '1' when ((RAM(i) > 0) and (delete_bullet(i) = '0') and 
							     ((to_integer(Hcount)-HBACK_PORCH-HSYNC - HOFFSET ) >= to_integer((RAM(i)(25 downto 17)))) and 
								 ((to_integer(Hcount)-HBACK_PORCH-HSYNC - HOFFSET ) < ( to_integer(Hpixel(i)) + (to_integer(RAM(i)(25 downto 17))))) and 
								 ((to_integer(Vcount)-VBACK_PORCH-VSYNC - VOFFSET ) >= to_integer((RAM(i)(16 downto 8)))) and
							     ((to_integer(Vcount)-VBACK_PORCH-VSYNC - VOFFSET ) < ( to_integer(Vpixel(i)) + (to_integer(RAM(i)(16 downto 8)))))) else '0';
	end generate;

		 			
spirites_coder: spirites_command <= 	
	 RAM(0)   when  cover(31 downto 0) =  X"00000001" else
	 RAM(1)   when  cover(31 downto 0) =  X"00000002" else
	 RAM(2)   when  cover(31 downto 0) =  X"00000004" else
	 RAM(3)   when  cover(31 downto 0) =  X"00000008" else
	 RAM(4)   when  cover(31 downto 0) =  X"00000010" else
	 RAM(5)   when  cover(31 downto 0) =  X"00000020" else
	 RAM(6)   when  cover(31 downto 0) =  X"00000040" else
	 RAM(7)   when  cover(31 downto 0) =  X"00000080" else
	 RAM(8)   when  cover(31 downto 0) =  X"00000100" else
	 RAM(9)   when  cover(31 downto 0) =  X"00000200" else
	 RAM(10)  when  cover(31 downto 0) =  X"00000400" else
	 RAM(11)  when  cover(31 downto 0) =  X"00000800" else
	 RAM(12)  when  cover(31 downto 0) =  X"00001000" else
	 RAM(13)  when  cover(31 downto 0) =  X"00002000" else
	 RAM(14)  when  cover(31 downto 0) =  X"00004000" else
	 RAM(15)  when  cover(31 downto 0) =  X"00008000" else
--	 RAM(16)  when  cover(31 downto 0) =  X"00010000" else
--	 RAM(17)  when  cover(31 downto 0) =  X"00020000" else
--	 RAM(18)  when  cover(31 downto 0) =  X"00040000" else
--	 RAM(19)  when  cover(31 downto 0) =  X"00080000" else
--	 RAM(20)  when  cover(31 downto 0) =  X"00100000" else
--	 RAM(21)  when  cover(31 downto 0) =  X"00200000" else
--	 RAM(22)  when  cover(31 downto 0) =  X"00400000" else
--	 RAM(23)  when  cover(31 downto 0) =  X"00800000" else
--	 RAM(24)  when  cover(31 downto 0) =  X"01000000" else
--	 RAM(25)  when  cover(31 downto 0) =  X"02000000" else
--	 RAM(26)  when  cover(31 downto 0) =  X"04000000" else
--	 RAM(27)  when  cover(31 downto 0) =  X"08000000" else
--	 RAM(28)  when  cover(31 downto 0) =  X"10000000" else
--	 RAM(29)  when  cover(31 downto 0) =  X"20000000" else
--	 RAM(30)  when  cover(31 downto 0) =  X"40000000" else
--	 RAM(31)  when  cover(31 downto 0) =  X"80000000" else
	 (others=>'0');

spirites_dir     <= spirites_command(7 downto 6);
spirites_type    <= spirites_command(5 downto 2);
spirites_col     <= spirites_command(1 downto 0);

Area_select:  pixel <= 
	"00000100011" when (spirites_type = "0111") else
	"10100001111" ;
	
Hselect: Hpixel2 <= 
	"000110" when (spirites_type = "0111") else
	"100100" ;
	
Vselect: Vpixel2 <= 
	"000110" when (spirites_type = "0111") else
	"100100" ;

with spirites_dir select spirites_address <=
	to_unsigned(((to_integer(Hcount) - HBACK_PORCH - HSYNC - HOFFSET - to_integer(spirites_command(25 downto 17))) + to_integer(Hpixel2)*(to_integer(Vcount)- VOFFSET -VBACK_PORCH-VSYNC-to_integer(spirites_command(16 downto 8)))),11) when  "01",
	to_unsigned((to_integer(pixel) - (to_integer(Hcount) - HBACK_PORCH - HSYNC - HOFFSET- to_integer(spirites_command(25 downto 17))) - to_integer(Hpixel2)*(to_integer(Vcount)-VBACK_PORCH-VSYNC - VOFFSET-to_integer(spirites_command(16 downto 8)))),11) 	when  "00",
    to_unsigned(((to_integer(Hcount) - HBACK_PORCH - HSYNC - HOFFSET - to_integer(spirites_command(25 downto 17)))*to_integer(Vpixel2) + (to_integer(Vcount)-VBACK_PORCH-VSYNC- VOFFSET - to_integer(spirites_command(16 downto 8)))),11) when  "10",
    to_unsigned((to_integer(pixel) - (to_integer(Hcount) - HOFFSET - HBACK_PORCH - HSYNC - to_integer(spirites_command(25 downto 17)))*to_integer(Vpixel2) - (to_integer(Vcount)-VBACK_PORCH -VOFFSET- VSYNC-to_integer(spirites_command(16 downto 8)))),11)  when  "11",
    (others => '0') when others;

with spirites_type select spirites_rgb <=
	player1_rgb   when "0001",
	player1_rgb   when "0010",
	tank1_rgb     when "0011",
--	fasttank_rgb  when "0100",
	powertank_rgb when "0101",
	armortank_rgb when "0110",
	bullet_rgb    when "0111",
	powertank_rgb when "1010",
	armortank_rgb when "1011",	
	(others => '0') when others;
	
	player1_address   <= std_logic_vector(spirites_address);
	tank1_address     <= std_logic_vector(spirites_address);
	fasttank_address  <= std_logic_vector(spirites_address);
	powertank_address <= std_logic_vector(spirites_address);
	armortank_address <= std_logic_vector(spirites_address);
	bullet_address    <= std_logic_vector(spirites_address(5 downto 0));

-- Registered video signals going to the video DAC
VideoOut: process (clk, reset)
begin
	if reset = '1' then
		VGA_R <= "0000000000";
		VGA_G <= "0000000000";
		VGA_B <= "0000000000";
	elsif clk'event and clk = '1' then	  
	-------------------------------------------------------------------------stage	   
		if scenario_drawen = '0' then	
			if start_end ='0' then 
				if start_exist = '1' then
					 if start_rgb = "00" then
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000"; 
					elsif start_rgb = "01" then
						VGA_R <= "0111101100";
						VGA_G <= "0111110100";
						VGA_B <= "0111101100"; 
					elsif start_rgb = "10" then
						VGA_R <= "1100011000";
						VGA_G <= "0111000100";
						VGA_B <= "0000000000"; 
					elsif start_rgb = "11" then
						VGA_R <= "1010010100";
						VGA_G <= "0011000000";
						VGA_B <= "0000000000"; 
					end if;
				elsif normal_exist = '1' then
					 if normal_rgb = "1" then
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000";
					else
						VGA_R <= "1000010100";
						VGA_G <= "1000010100";
						VGA_B <= "1000010100"; 
					end if;
				elsif diff_exist = '1' then
					 if diff_rgb = "1" then
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000";
					else
						VGA_R <= "1000010100";
						VGA_G <= "1000010100";
						VGA_B <= "1000010100"; 
					end if;
				
				elsif choose1_exist = '1' then
				if choose_rgb = "01" then
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000"; 
				elsif choose_rgb = "10" then 
					VGA_R <= "1111111111";
					VGA_G <= "1111111111";
					VGA_B <= "1111111111"; 
				else
					VGA_R <= "1110010100";
					VGA_G <= "1101011000";
					VGA_B <= "0111011000"; 
				end if;
				
				elsif choose2_exist = '1' then
				if choose_rgb = "01" then
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000"; 
				elsif choose_rgb = "10" then 
					VGA_R <= "1111111111";
					VGA_G <= "1111111111";
					VGA_B <= "1111111111"; 
				else
					VGA_R <= "1110010100";
					VGA_G <= "1101011000";
					VGA_B <= "0111011000"; 
				end if;	
									
				elsif vga_hblank = '0' and vga_vblank ='0' then
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000"; 
				else 
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000";  
				end if;
				
--			elsif over_end ='0' then 
--			 	if end_exist = '1' then
--					 if end_rgb = "00" then
--						VGA_R <= "0000000000";
--						VGA_G <= "0000000000";
--						VGA_B <= "0000000000"; 
--					elsif end_rgb = "01" then
--						VGA_R <= "1111111111";
--						VGA_G <= "1111111111";
--						VGA_B <= "1111111111"; 
--					elsif end_rgb = "10" then
--						VGA_R <= "1010110100";
--						VGA_G <= "1010111000";
--						VGA_B <= "1010110100";  
--					end if;
--				elsif vga_hblank = '0' and vga_vblank ='0' then
--						VGA_R <= "0000000000";
--						VGA_G <= "0000000000";
--						VGA_B <= "0000000000"; 
--				else 
--						VGA_R <= "0000000000";
--						VGA_G <= "0000000000";
--						VGA_B <= "0000000000";  
--				end if;
				
			 elsif (to_integer(Vcount)-VBACK_PORCH-VSYNC) >= VOFFSET and (to_integer(Vcount)-VBACK_PORCH-VSYNC) <= VACTIVE - VOFFSET and
				(to_integer(Hcount) - HBACK_PORCH - HSYNC)>= 0  and (to_integer(Hcount) - HBACK_PORCH - HSYNC)<= HACTIVE then				
				if stage_exist = '1' then
					 if stage_rgb = 1 then
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000"; 
					else 
						VGA_R <= "1000010100";
						VGA_G <= "1000010100";
						VGA_B <= "1000010100"; 
					end if;	
				elsif stagenum_exist = '1' then
					if stagenum_rgb = 1 then
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000"; 
					else 
						VGA_R <= "1000010100";
						VGA_G <= "1000010100";
						VGA_B <= "1000010100"; 
					end if;	
				else 
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100";
				end if;	 
			 elsif vga_hblank = '0' and vga_vblank ='0' then
			 	VGA_R <= "0000000000";
				VGA_G <= "0000000000";
				VGA_B <= "0000000000"; 
			 else 
			 	VGA_R <= "0000000000";
				VGA_G <= "0000000000";
				VGA_B <= "0000000000";  
			 end if;
-------------------------------------------------------------------------scenario	   			   
		   elsif background = '1' then			   		  
		   if expcover > 0 and (explsion_rgb /= X"000000") then
		   VGA_R <= unsigned((explsion_rgb(7 downto 0))&"00");
		   VGA_G <= unsigned((explsion_rgb(15 downto 8))&"00");
		   VGA_B <= unsigned((explsion_rgb(23 downto 16))&"00");
		   elsif BlockExist = '1' and PhoenixExist = '0' and cover = 0 then							
			VGA_R <= unsigned((Scenario_rgb(7 downto 0))&"00");
			VGA_G <= unsigned((Scenario_rgb(15 downto 8))&"00");
			VGA_B <= unsigned((Scenario_rgb(23 downto 16))&"00");	
		   elsif PhoenixExist  = '1' and cover = 0 then
			  if phoenix_rgb = 1 then
			   	VGA_R <= "0000000000";
				VGA_G <= "0000000000";
				VGA_B <= "0000000000";
			  else 
			    VGA_R <= "1000010100";
				VGA_G <= "1000010100";
				VGA_B <= "1000010100"; 
			   end if;	
----------------------------------------------------------------------------------------------ice and tree
			elsif cover >0 and Scenario_command(3 downto 0) = "0011" and BlockExist = '1' and Scenario_rgb(15 downto 8) /= 0 then
				VGA_R <= unsigned((Scenario_rgb(7 downto 0))&"00");
				VGA_G <= unsigned((Scenario_rgb(15 downto 8))&"00");
				VGA_B <= unsigned((Scenario_rgb(23 downto 16))&"00");
			elsif cover >0 and Scenario_command(3 downto 0) = "0101" and BlockExist = '1' and spirites_rgb(15 downto 8) = 0 then
		   		VGA_R <= unsigned((Scenario_rgb(7 downto 0))&"00");
				VGA_G <= unsigned((Scenario_rgb(15 downto 8))&"00");
				VGA_B <= unsigned((Scenario_rgb(23 downto 16))&"00");
----------------------------------------------------------------------------------------------spirite				
			elsif cover > 0 then			
				if spirites_type = "0010" then
					if spirites_rgb(7 downto 0) >100 then
					VGA_R <= unsigned((spirites_rgb(7 downto 0)-100)&"00");
					else
					VGA_R <= unsigned((spirites_rgb(7 downto 0))&"00");
					end if;
					VGA_G <= unsigned((spirites_rgb(15 downto 8))&"00");
					VGA_B <= unsigned((spirites_rgb(23 downto 16))&"00");
				elsif spirites_type = "0100" then
					if fasttank_rgb = "00" then
						VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000"; 
					elsif fasttank_rgb = "01" then 
						VGA_R <= "1111111111";
						VGA_G <= "1111111111";
						VGA_B <= "1111111111"; 
					elsif fasttank_rgb = "10" then
						VGA_R <= "1101000000";
						VGA_G <= "1101000100";
						VGA_B <= "1101000000"; 
					else
						VGA_R <= "0011000100";
						VGA_G <= "0101000100";
						VGA_B <= "1000010000"; 						
					end if;
				elsif spirites_type = "1010" then---------------------------need modifications
					if ((spirites_rgb(7 downto 0) = X"24") and spirites_rgb(15 downto 8) =X"44" and spirites_rgb(23 downto 16) = X"74") then
					VGA_R <= "0110110000";
					VGA_G <= "0110110000";
					VGA_B <= "0000000000";					
					elsif ((spirites_rgb(7 downto 0) = X"9a") and spirites_rgb(15 downto 8) =X"9a" and spirites_rgb(23 downto 16) = X"9a") then
					VGA_R <= "1110001100";
					VGA_G <= "0111110000";
					VGA_B <= "0000000000";
					elsif ((spirites_rgb(7 downto 0) = X"FF") and spirites_rgb(15 downto 8) =X"FF" and spirites_rgb(23 downto 16) = X"FF") then
					VGA_R <= "1111100000";
					VGA_G <= "1110100000";
					VGA_B <= "1000100100";
					else	
					VGA_R <= unsigned((spirites_rgb(7 downto 0))&"00");
					VGA_G <= unsigned((spirites_rgb(15 downto 8))&"00");
					VGA_B <= unsigned((spirites_rgb(23 downto 16))&"00");
					end if;
				elsif spirites_type = "1011" then---------------------------need modifications
					
					if ((spirites_rgb(7 downto 0) = X"24") and spirites_rgb(15 downto 8) =X"44" and spirites_rgb(23 downto 16) = X"74") then
					VGA_R <= "0110110000";
					VGA_G <= "0110110000";
					VGA_B <= "0000000000";					
					elsif ((spirites_rgb(7 downto 0) = X"9a") and spirites_rgb(15 downto 8) =X"9a" and spirites_rgb(23 downto 16) = X"9a") then
					VGA_R <= "1110001100";
					VGA_G <= "0111110000";
					VGA_B <= "0000000000";
					elsif ((spirites_rgb(7 downto 0) = X"FF") and spirites_rgb(15 downto 8) =X"FF" and spirites_rgb(23 downto 16) = X"FF") then
					VGA_R <= "1111100000";
					VGA_G <= "1110100000";
					VGA_B <= "1000100100";
					elsif ((spirites_rgb(7 downto 0) = X"3B") and spirites_rgb(15 downto 8) =X"3B" and spirites_rgb(23 downto 16) = X"3B") then
					VGA_R <= "1010101000";
					VGA_G <= "0101111100";
					VGA_B <= "0000010000";
					else
					VGA_R <= unsigned((spirites_rgb(7 downto 0))&"00");
					VGA_G <= unsigned((spirites_rgb(15 downto 8))&"00");
					VGA_B <= unsigned((spirites_rgb(23 downto 16))&"00");
					end if;					
				else
				VGA_R <= unsigned((spirites_rgb(7 downto 0))&"00");
				VGA_G <= unsigned((spirites_rgb(15 downto 8))&"00");
				VGA_B <= unsigned((spirites_rgb(23 downto 16))&"00");
				end if;
		    else
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";  
		   end if;
--------------------------------------------------------------------------------------------------UI
		 elsif level_exist = '1' then
		 	if level_rgb = "01" then
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100"; 
			elsif level_rgb = "10" then 
					VGA_R <= "1010010100";
					VGA_G <= "0011000000";
					VGA_B <= "0000000000"; 
			else
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000";  
				end if;
		 elsif levelnum_exist = '1' then
			   if levelnum_rgb = 0 then
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000"; 
			   elsif levelnum_rgb = 1 then 
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100";
			   end if;
			   
		 elsif enemy_exist = '1' then
		 	if enemy_rgb = "01" then
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100"; 
				elsif enemy_rgb = "10" then 
					VGA_R <= "1010010100";
					VGA_G <= "0011000000";
					VGA_B <= "0000000000"; 
				else
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000";  
				end if;
				
		  elsif enemy_numexist >0 then 
			if enemynum_rgb = "01" then
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100"; 
				elsif enemynum_rgb = "10" then 
					VGA_R <= "1010010100";
					VGA_G <= "0011000000";
					VGA_B <= "0000000000"; 
				else
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000";  
				end if;
		
			elsif life_exist = '1' then
		 	if life_rgb = "01" then
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100"; 
				elsif life_rgb = "10" then 
					VGA_R <= "1010010100";
					VGA_G <= "0011000000";
					VGA_B <= "0000000000"; 
				else
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000";  
				end if;
			elsif  lifenum1_exist = '1' then 
			   if lifenum1_rgb = 0 then
					VGA_R <= "0000000000";
					VGA_G <= "0000000000";
					VGA_B <= "0000000000"; 
			   elsif lifenum1_rgb = 1 then 
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100";
			   end if;	
			
--			elsif  lifenum2_exist = '1' then 
--			   if lifenum2_rgb = 0 then
--					VGA_R <= "0000000000";
--					VGA_G <= "0000000000";
--					VGA_B <= "0000000000"; 
--			   elsif lifenum2_rgb = 1 then 
--					VGA_R <= "1000010100";
--					VGA_G <= "1000010100";
--					VGA_B <= "1000010100";
--			   end if;	
			   
		   elsif player_exist ="01" then 			
			if enemynum_rgb = "01" then
					VGA_R <= "1000010100";
					VGA_G <= "1000010100";
					VGA_B <= "1000010100"; 
				elsif enemynum_rgb = "10" then 
					VGA_R <= "1111111111";
					VGA_G <= "1111111111";
					VGA_B <= "1111111111"; 
				else
					VGA_R <= "1110010100";
					VGA_G <= "1101011000";
					VGA_B <= "0111011000"; 
				end if;	
			
--			elsif player_exist ="10" then 			
--			if enemynum_rgb = "01" then
--					VGA_R <= "1100011000";
--					VGA_G <= "0111000100";
--					VGA_B <= "0000000000"; 
--				elsif enemynum_rgb = "10" then 
--					VGA_R <= "1010010100";
--					VGA_G <= "0011000000";
--					VGA_B <= "0000000000"; 
--				else
--					VGA_R <= "0000000000";
--					VGA_G <= "0000000000";
--					VGA_B <= "0000000000";  
--				end if;				
--------------------------------------------------------------------------------------------------UI				
		elsif vga_hblank = '0' and vga_vblank ='0' then
			VGA_R <= "1000010100";
			VGA_G <= "1000010100";
			VGA_B <= "1000010100"; 
		else 
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000";  
		end if;							
end if;
end process VideoOut;

VGA_CLK <= clk;
VGA_HS <= not vga_hsync;
VGA_VS <= not vga_vsync;
VGA_SYNC <= '0';
VGA_BLANK <= not (vga_hsync or vga_vsync);


end rtl;
