library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_vga_bus is
  
  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    writedata  : in  unsigned(31 downto 0);

    command    : out unsigned(31 downto 0)
    );
  
end de2_vga_bus;

architecture rtl of de2_vga_bus is

begin
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then       
        command <= (others=>'0');
      else
        if chipselect = '1' then
		  if write = '1' then
			command <= writedata;
          end if;
        end if;
      end if;
    end if;
  end process;

end rtl;
