library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity bulletCounter is

port (
    clk        : in std_logic;
    reset      : in std_logic;
	read       : in std_logic;
	write      : in std_logic;
    chipselect : in std_logic;
	writedata  : in  unsigned(31 downto 0);
    readdata   : out unsigned(31 downto 0)
    );  
end bulletCounter;

architecture rtl of bulletCounter is

  	constant MAX : integer := 400000;
  	signal counterEnable : unsigned(31 downto 0);
  	type counterType is array(31 downto 0) of unsigned(31 downto 0);
	signal countValue : counterType;

begin

  process (clk)
  begin
    if rising_edge(clk) then
		if reset = '1' then       
        	counterEnable <= (others=>'0');
        	countValue <= (others => X"00000000");
      	else
			if chipselect = '1' then
		  		if write = '1' then
					counterEnable <= writedata;
          		elsif read = '1' then
					readdata <= counterEnable;
				end if;
        	end if;
			for i in 0 to 31 loop
				if (countValue(i)=MAX) then
					counterEnable(i) <= '0';
					countValue(i) <= (others => '0');
				elsif (counterEnable(i)='1') then
					countValue(i) <= countValue(i) + 1;
				end if;
     		end loop;
		end if;    
    end if;  
  end process;

end rtl;
