library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity audio_driver is 
port(
	clock_50 : in std_logic;
	clock_18 : in std_logic;
	cpu_cmd : in std_logic_vector(31 downto 0);


	-- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock

);
end audio_driver;


architecture behavior of audio_driver is

signal disable : std_logic; -- when '1' disable audio module
signal reset_n : std_logic; -- when '0' reset audio module
signal sin_sel : std_logic; -- when "0001", play "fire", when "0010", play "explosion"
signal play_finish1 : std_logic;-- exp
signal play_finish2 : std_logic;-- fire
signal reset_sm : std_logic; -- when '1' reset state machine
signal reset_exp : std_logic := '1';
signal reset_fire : std_logic := '1';
signal tune : unsigned(11 downto 0);
signal counter : unsigned(31 downto 0);
signal enable_ct : std_logic;

component de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    clk_50 : in std_logic;
    disable : in std_logic;
    sin_sel : in std_logic; -- select which sound will be played
    play_finish1 : out std_logic;-- exp
    play_finish2 : out std_logic;-- fire
    reset_exp : in std_logic; -- when '1' reset
    reset_fire : in std_logic; --when '1' reset
    tune : in unsigned(11 downto 0);
  
    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  component;

signal audio_request : std_logic;

type state is (s0, s1, s2, s3);
signal pr_state : state;

begin

reset_sm <= cpu_cmd(28);



process(clock_50, enable_ct)
begin
	if rising_edge(clock_50) then
		if enable_ct = '1' then
			if counter = x"FFFFFFFF" then
				counter <= x"00000000";
			else
				counter <= counter + 1;
			end if;
		else
			counter <= x"00000000";
		end if;			
	end if;
end process;

process(clock_50,reset_sm, cpu_cmd,pr_state)
begin
	if rising_edge(clock_50) then
		if cpu_cmd = x"00000100" then --play welcome music
			pr_state<=s1;			
		elsif cpu_cmd = x"00000f00" then -- play sound: fire, exp, move
			pr_state<=s2;
		elsif pr_state = s1 and cpu_cmd = x"00000110" then
			pr_state <= s3;
		else
			if pr_state = s1 then
				pr_state<=s1;
			elsif pr_state = s2 then
				pr_state<=s2;
			elsif pr_state = s3 then
				pr_state<=s3;
			else
				pr_state<=s0; -- waiting for the cpu cmd;
			end if; 
		end if;
	end if;
end process;



process(clock_50,reset_sm, play_finish1, play_finish2, reset_fire, reset_exp, cpu_cmd,pr_state)
begin
	if rising_edge(clock_50) then
		if pr_state = s1 then
			enable_ct <= '0';
			reset_n <= '0';
			disable <= '1';
			sin_sel <= '1';
		
		elsif pr_state = s3 then
			enable_ct <= '1';
			reset_n <= '1';
			sin_sel <= '1';
			if counter = x"00000000" then
				disable <= '0';
				tune <= x"169";			
			elsif counter = x"007270e0" then
				tune <= x"141";
			elsif counter = x"00e4e1c0" then
				tune <= x"12f";
			elsif counter = x"015752a0" then
				tune <= x"169";
			elsif counter = x"01c9c380" then
				tune <= x"141";
			elsif counter = x"023c3460" then
				tune <= x"12f";
			elsif counter = x"02aea540" then
				disable <= '1';
			elsif counter = x"02d4cae0" then
				disable <= '0';	
				tune <= x"12f";			
			elsif counter = x"03473bc0" then
				tune <= x"10e";
			elsif counter = x"03b9aca0" then
				tune <= x"0ff";
			elsif counter = x"042c1d80" then
				tune <= x"12f";
			elsif counter = x"049e8e60" then
				tune <= x"10e";
			elsif counter = x"0510ff40" then
				tune <= x"0ff";
			elsif counter = x"05837020" then
				tune <= x"10e";
			elsif counter = x"05f5e100" then
				tune <= x"0ff";
			elsif counter = x"066851e0" then
				tune <= x"0f1";
			elsif counter = x"06dac2c0" then
				tune <= x"10e";
			elsif counter = x"074d33a0" then
				tune <= x"0ff";
			elsif counter = x"07bfa480" then
				tune <= x"0f1";
			elsif counter = x"08321560" then
				disable <= '1';
			elsif counter = x"08583b00" then
				disable <= '0';
				tune <= x"0f1";
			elsif counter = x"08caabe0" then
				tune <= x"0D6";
			elsif counter = x"093d1cc0" then
				tune <= x"0bf";
			elsif counter = x"09af8da0" then
				tune <= x"0f1";
			elsif counter = x"0a21fe80" then
				tune <= x"0d6";
			elsif counter = x"0a946f60" then
				tune <=x"0bf";
			elsif counter = x"0b06e040" then
				disable <= '1';
			elsif counter = x"0b162280" then
				disable <= '0';
				tune <= x"0bf";
			elsif counter = x"0b889360" then
				disable <= '1';
			elsif counter = x"0c6d7520" then
				disable <= '0';
				tune <= x"0bf";
			elsif counter = x"0cb9c060" then
				disable <= '1';
			elsif counter = x"0cdfe600" then
				disable <= '0';
				tune <= x"0bf";
			elsif counter = x"0d2c3140" then
				disable <= '1';
			elsif counter = x"0d5256e0" then
				disable <= '0';
				tune <= x"0bf";
			elsif counter = x"0d9ea220" then
				disable <='1';
			elsif counter = x"0dc4c7c0" then
				disable <= '0';
				tune <= x"0bf";
			elsif counter = x"0e111300" then
				disable <= '1';
			end if;
		elsif pr_state = s2 then
			tune <= x"0C0";
			disable <='0';
			reset_n <='1';
			enable_ct <= '0';
			sin_sel <='0';
			if play_finish2 = '1' then
				reset_fire<='1';
			elsif play_finish1 = '1' then
				reset_exp<='1';
			else
				if cpu_cmd = x"00000001" then-- fire
					reset_fire<='0';			
				elsif cpu_cmd = x"00000002" then-- exp
					reset_exp <= '0';
				end if;
			end if;
		

		else
			disable <= '1';
			reset_n <= '0';
			tune<=X"0C0";
			reset_exp <='1';
			reset_fire <='1';
			enable_ct <='0';
			sin_sel <='0';
		end if;
	end if;
end process;





--port map to the wm8731 module
audio: de2_wm8731_audio port map(

    clk => clock_18,
    reset_n => reset_n,
    clk_50 =>clock_50,
    disable => disable,
    sin_sel => sin_sel,
    play_finish1 => play_finish1,--exp
    play_finish2 => play_finish2,--fire
    reset_exp => reset_exp,
    reset_fire => reset_fire,
    tune =>tune,
  
    -- Audio interface signals
    AUD_ADCLRCK  => AUD_ADCLRCK,
    AUD_ADCDAT => AUD_ADCDAT,
    AUD_DACLRCK => AUD_DACLRCK,
    AUD_DACDAT =>  AUD_DACDAT,  
    AUD_BCLK => AUD_BCLK    

);

end architecture;