library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity dct is
port(
avs_dct_clk         : in std_logic;
    --avs_dct_reset_n     : in std_logic;
    avs_dct_read        : in std_logic;
    avs_dct_write       : in std_logic;
    avs_dct_chipselect  : in std_logic;
    avs_dct_address     : in unsigned(4 downto 0);
    avs_dct_readdata    : out std_logic_vector(31 downto 0);
    avs_dct_writedata   : in std_logic_vector(31 downto 0);

    data_dct_out        : out std_logic_vector(31 downto 0);
    over		        : out std_logic;

avs_reg_read        : in std_logic;
avs_reg_chipselect  : in std_logic;
avs_reg_readdata    : out std_logic_vector(31 downto 0);
avs_reg_write       : in std_logic;
avs_reg_writedata   : in STD_LOGIC_VECTOR (31 DOWNTO 0)
);
end dct;

architecture rtl of dct is

component ram_2_port
PORT
(
address_a	: IN STD_LOGIC_VECTOR (4 DOWNTO 0);
address_b	: IN STD_LOGIC_VECTOR (4 DOWNTO 0);
clock		: IN STD_LOGIC ;
data_a		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
data_b		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
wren_a		: IN STD_LOGIC;
wren_b		: IN STD_LOGIC;
q_a			: OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
q_b			: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
);
end component;

component add
PORT
(
clock		: IN STD_LOGIC ;
dataa		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
datab		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
result		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
);
end component;

component sub
PORT
(
clock		: IN STD_LOGIC ;
dataa		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
datab		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
result		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
);
end component;




component mul
PORT
(
clock		: IN STD_LOGIC ;
dataa		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
datab		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
result		: OUT STD_LOGIC_VECTOR (63 DOWNTO 0)
);
end component;

component delay_add
PORT
(
clock		: IN STD_LOGIC ;
dataa		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
result		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
);
end component;


--component shift_reg
--	PORT
--	(
--		clock		: IN STD_LOGIC ;
--		shiftin		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
--		shiftout		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
--		taps		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
--	);
--end component;


component cos_tab
PORT
(
address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
clock		: IN STD_LOGIC ;
q		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
);
end component;


component add_1
PORT
(
address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
clock		: IN STD_LOGIC ;
q		: OUT STD_LOGIC_VECTOR (4 DOWNTO 0)
);
end component;


component add_2
PORT
(
address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
clock		: IN STD_LOGIC ;
q		: OUT STD_LOGIC_VECTOR (4 DOWNTO 0)
);
end component;

component one_zero
PORT
(
address		: IN STD_LOGIC_VECTOR (6 DOWNTO 0);
clock		: IN STD_LOGIC ;
q		: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
);
end component;

signal stop_global_count:  std_logic:='0';
signal stop_count_c		:  std_logic:='0';
signal stop_count_g		:  std_logic:='0';
signal stop_count_w		:  std_logic:='0';
signal stop_count_r		:  std_logic:='0';
signal strt1_inv0		:  STD_LOGIC_vector(0 downto 0);
signal clock_sig   		:  STD_LOGIC;
signal start       		:  STD_LOGIC:='0';
signal over_sig   		:  STD_LOGIC:='0';
signal switch      		:  std_logic;
signal global_counter   :  unsigned(6 downto 0);
signal r_counter     	:  unsigned(6 downto 0);
signal g_counter     	:  unsigned(2 downto 0);
signal w_counter     	:  unsigned(6 downto 0);
signal c_counter     	:  unsigned(6 downto 0);
signal counter          :  unsigned(4 downto 0);
signal out_counter      :  unsigned(4 downto 0);
signal proc_in_counter  :  unsigned(4 downto 0);
signal switch_counter   :  unsigned(1 downto 0);  	
signal address_a_0		:  unsigned(4 DOWNTO 0);
signal address_b_0		:  unsigned (4 DOWNTO 0);
signal data_a_0			:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal data_b_0			:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal wren_a_0			:  STD_LOGIC;
signal wren_b_0			:  STD_LOGIC;
signal q_a_0			:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal q_b_0			:  STD_LOGIC_VECTOR (31 DOWNTO 0);

signal address_a_1		:  unsigned (4 DOWNTO 0);
signal address_b_1		:  unsigned (4 DOWNTO 0);
signal data_a_1			:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal data_b_1			:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal wren_a_1			:  STD_LOGIC ;
signal wren_b_1			:  STD_LOGIC;
signal q_a_1			:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal q_b_1			:  STD_LOGIC_VECTOR (31 DOWNTO 0);

signal data_a_add		:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal data_b_add		:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal result_add		:  STD_LOGIC_VECTOR (31 DOWNTO 0);

signal data_a_sub		:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal data_b_sub		:  STD_LOGIC_VECTOR (31 DOWNTO 0);
signal result_sub		:  STD_LOGIC_VECTOR (31 DOWNTO 0);

signal data_a_mul		: STD_LOGIC_VECTOR (31 DOWNTO 0);
signal data_b_mul		: STD_LOGIC_VECTOR (31 DOWNTO 0);
signal result_mul		: STD_LOGIC_VECTOR (63 DOWNTO 0);

signal data_a_delay		: STD_LOGIC_VECTOR (31 DOWNTO 0);
signal result_a_delay	: STD_LOGIC_VECTOR (31 DOWNTO 0);
--taps_sreg		: STD_LOGIC_VECTOR (31 DOWNTO 0);

signal address_costab	: unsigned (6 DOWNTO 0);
signal q_costab     	: STD_LOGIC_VECTOR (31 DOWNTO 0);

signal address_add_1	: unsigned (6 DOWNTO 0);
signal q_add_1		    : STD_LOGIC_VECTOR (4 DOWNTO 0);

signal address_add_2	: unsigned (6 DOWNTO 0);
signal q_add_2		    : STD_LOGIC_VECTOR (4 DOWNTO 0);

signal address_add_1_o	: unsigned (6 DOWNTO 0);
signal q_add_1_o		: STD_LOGIC_VECTOR (4 DOWNTO 0);

signal address_add_2_o	: unsigned (6 DOWNTO 0);
signal q_add_2_o		: STD_LOGIC_VECTOR (4 DOWNTO 0);

signal address_one_zero	: UNSIGNED(6 DOWNTO 0);
SIGNAL q_ONE_ZERO		: STD_LOGIC_VECTOR (0 DOWNTO 0);

signal reg				: STD_LOGIC_VECTOR (31 DOWNTO 0):=x"00000000";
begin 



ram_2_port_inst0 : ram_2_port PORT MAP (
address_a=> STD_LOGIC_VECTOR(address_a_0),
address_b=> STD_LOGIC_VECTOR(address_b_0),
clock	 => clock_sig,
data_a	 => data_a_0,
data_b	 => data_b_0,
wren_a	 => wren_a_0,
wren_b	 => wren_b_0,
q_a	  	 => q_a_0,
q_b	 	 => q_b_0
);

ram_2_port_inst1 : ram_2_port PORT MAP (
address_a=> STD_LOGIC_VECTOR(address_a_1),
address_b=> STD_LOGIC_VECTOR(address_b_1),
clock	 => clock_sig,
data_a	 => data_a_1,
data_b	 => data_b_1,
wren_a	 => wren_a_1,
wren_b	 => wren_b_1,
q_a	 	 => q_a_1,
q_b	 	 => q_b_1
);


add_inst : add PORT MAP (
clock	 => clock_sig,
dataa	 => data_a_add,
datab	 => data_b_add,
result	 => result_add
);

sub_inst : sub PORT MAP (
clock	 => clock_sig,
dataa	 => data_a_sub,
datab	 => data_b_sub,
result	 => result_sub
);



mul_inst : mul PORT MAP (
clock	 => clock_sig,
dataa	 => data_a_mul,
datab	 => data_b_mul,
result	 => result_mul
);

--shift_reg_inst : shift_reg PORT MAP (
--		clock	 => clock_sig,
--		shiftin	 => shiftin_sreg,
--		shiftout => shiftout_sreg,
--		taps	 => taps_sreg
--	);

delay_add_inst : delay_add PORT MAP (
clock	 => clock_sig,
dataa	 => data_a_delay,
result	 => result_a_delay
);


cos_tab_inst : cos_tab PORT MAP (
address	 => STD_LOGIC_VECTOR(address_costab),
clock	 => clock_sig,
q	     => (q_costab)
);


add_1_inst : add_1 PORT MAP (
address	 => STD_LOGIC_VECTOR(address_add_1),
clock	 => clock_sig,
q	 => (q_add_1)
);

add_2_inst : add_2 PORT MAP (
address	 => STD_LOGIC_VECTOR(address_add_2),
clock	 => clock_sig,
q	 => (q_add_2)
);

add_1_inst_o : add_1 PORT MAP (
address	 => STD_LOGIC_VECTOR(address_add_1_o),
clock	 => clock_sig,
q	 => (q_add_1_o)
);

add_2_inst_o : add_2 PORT MAP (
address	 => STD_LOGIC_VECTOR(address_add_2_o),
clock	 => clock_sig,
q	 => (q_add_2_o)
);

one_zero_inst : one_zero PORT MAP (
address	 => STD_LOGIC_VECTOR(address_one_zero),
clock	 => clock_sig,
q	 => q_one_zero
);

clock_sig <= avs_dct_clk;
process(avs_dct_clk)
begin
if rising_edge(avs_dct_clk) then 


    if(avs_reg_chipselect ='1')  then
      if avs_reg_read ='1' then 
		avs_reg_readdata <= reg;
	  elsif avs_reg_write ='1' then 
        reg<=avs_reg_writedata;
      end if;
    end if;

  if start = '0' then
	if(avs_dct_chipselect = '1') then 
       if(avs_dct_write = '1') then
			if counter < "11111" then 
				counter <= counter + 1;
				address_a_0 <= counter;
			    wren_a_0 <='1';
			    data_a_0 <= avs_dct_writedata;
			else 
			    counter <= counter + 1;
				address_a_0 <= counter;
			    wren_a_0 <='1';
			    data_a_0 <= avs_dct_writedata;
				--wren_a_0 <='0';
				start <= '1';
				switch <= '0';
				reg <= x"00000000";
			end if;
			
			
			
       elsif(avs_dct_read = '1') then
			 if proc_in_counter < "11111" then 
				proc_in_counter <= proc_in_counter + 1;
				address_a_1 <= proc_in_counter;
			    wren_a_1 <='0';
			    avs_dct_readdata <= q_a_1;
			else 
			    proc_in_counter <= proc_in_counter + 1;
				address_a_1 <= proc_in_counter;
			    wren_a_1 <='0';
			    avs_dct_readdata <= q_a_1;
				--wren_a_1 <='1';
				reg <= x"00000000";
				--start <= '1';
			end if;

     end if;
   end if;
  end if;

if(start = '1') then
  if(switch = '0') then
	address_a_0<=unsigned(q_add_1);
	address_b_0<=unsigned(q_add_2);

	wren_a_0<='0';
	wren_b_0<='0';

--add
	data_a_add<=q_a_0;
	data_b_add<=q_b_0;
        
	strt1_inv0 <= q_one_zero(0 downto 0);

--sub
	if(strt1_inv0(0) = '1') then

		data_a_sub<=q_a_0;
		data_b_sub<=q_b_0; -- if (1-2)	
	else 
		data_a_sub<=q_b_0;
		data_b_sub<=q_a_0; -- if (2-1)	
	end if;

--mul
	data_a_mul<=result_sub;
	data_b_mul<=q_costab;

--shift_reg
	data_a_delay<=result_add;

--storage

	address_a_1<=unsigned(q_add_1_o);
	address_b_1<=unsigned(q_add_2_o);

	wren_a_1<='1';
	wren_b_1<='1';

	data_a_1<=result_a_delay;
	data_b_1<=result_mul(46 downto 15);

  else 
 
	address_a_1<=unsigned(q_add_1_o);
	address_b_1<=unsigned(q_add_2_o);

	wren_a_1<='0';
	wren_b_1<='0';

--add
	data_a_add<=q_a_1;
	data_b_add<=q_b_1;
        
--sub
	if(strt1_inv0(0) = '1') then

		data_a_sub<=q_a_1;
		data_b_sub<=q_b_1; -- if (1-2)	
	else 
		data_a_sub<=q_b_1;
		data_b_sub<=q_a_1; -- if (2-1)	
	end if;

--mul
	data_a_mul<=result_sub;
	data_b_mul<=q_costab;

--shift_reg
	data_a_delay<=result_add;

--storage
	address_a_0<=unsigned(q_add_1);
	address_b_0<=unsigned(q_add_2);

	wren_a_0<='1';
	wren_b_0<='1';

	data_a_0<=result_a_delay;
	data_b_0<=result_mul(46 downto 15);
  end if;	
--end if;

   
  --if start = '1' then 

      if g_counter = "100" then   
        g_counter <= "000";
        reg <= x"00000001";
        over_sig <= '1';
        start <= '0';
       else 
         over_sig <= '0';
         reg <= x"00000000"; 
      end if;
     
     if(stop_global_count = '0') then   
      if(global_counter = "1010001") then 
         global_counter <= "0000000";
         stop_global_count <= '1';
      else
         global_counter <= global_counter + 1;
      end if;
     end if;

	  if switch = '1' then
        address_add_1_o<=r_counter;
        address_add_2_o<=r_counter;
		address_one_zero <=r_counter;
	  elsif switch = '0' then
       address_add_1<=r_counter;
       address_add_2<=r_counter;
	   address_one_zero <=r_counter;
     end if; 

   if(stop_count_w = '0') then  
	if(global_counter > "0000001" and w_counter < "1001111") then
        w_counter <= w_counter + 1;
        if switch = '0' then
           address_add_1_o<=w_counter;
           address_add_2_o<=w_counter;
       elsif switch = '1' then
          address_add_1<=w_counter;
		  address_add_2<=w_counter;
	   end if;
     end if;
	end if;

  if(stop_count_c = '0') then
	if(global_counter > "0000000" and c_counter < "1001111") then
       c_counter <= c_counter + 1; 
       address_costab <= c_counter;
       
	end if;
  end if;

	if c_counter = "1001111" then 
       c_counter <= "0000000";
	   stop_count_c <= '1';
	end if;
    
	if w_counter = "1001111" then 
       --w_counter <="0000000";
       stop_count_w <= '1'; 
       if switch_counter < "11" then
          switch_counter <= switch_counter + 1;
        elsif switch_counter = "11" then
           
			case g_counter is
				when "000" => switch <= '1';
				when "001" => switch <= '0';
				when "010" => switch <= '1';
				when "011" => switch <= '0';
				when others => switch <= '0';
				end case;
		   switch_counter <= "00";
           g_counter <= g_counter + 1;
		   stop_count_c <= '0';
           stop_global_count <= '0';
           stop_count_r <= '0';
           stop_count_c <= '0';
           stop_count_w <= '0';
           w_counter <= "0000000";
        end if; 
     end if;
    
    
   if stop_count_r = '0' then  
    if(r_counter = "1001111") then 
        r_counter <= "0000000";
        stop_count_r <= '1';
     else 
        r_counter <= r_counter + 1; 
     end if;
    end if;

  end if;	--start
--end if;
end if;
end process;
end architecture;
