--megafunction wizard: %Altera SOPC Builder%
--GENERATION: STANDARD
--VERSION: WM1.0


--Legal Notice: (C)2007 Altera Corporation. All rights reserved.  Your
--use of Altera Corporation's design tools, logic functions and other
--software and tools, and its AMPP partner logic functions, and any
--output files any of the foregoing (including device programming or
--simulation files), and any associated documentation or information are
--expressly subject to the terms and conditions of the Altera Program
--License Subscription Agreement or other applicable license agreement,
--including, without limitation, that your use is for the sole purpose
--of programming logic devices manufactured by Altera and sold by Altera
--or its authorized distributors.  Please refer to the applicable
--agreement for further details.


-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity DM9000A_avalonS_arbitrator is 
        port (
              -- inputs:
                 signal DM9000A_avalonS_irq : IN STD_LOGIC;
                 signal DM9000A_avalonS_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clk : IN STD_LOGIC;
                 signal clock_1_out_address_to_slave : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal clock_1_out_nativeaddress : IN STD_LOGIC;
                 signal clock_1_out_read : IN STD_LOGIC;
                 signal clock_1_out_write : IN STD_LOGIC;
                 signal clock_1_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal DM9000A_avalonS_address : OUT STD_LOGIC;
                 signal DM9000A_avalonS_chipselect_n : OUT STD_LOGIC;
                 signal DM9000A_avalonS_irq_from_sa : OUT STD_LOGIC;
                 signal DM9000A_avalonS_read_n : OUT STD_LOGIC;
                 signal DM9000A_avalonS_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal DM9000A_avalonS_reset_n : OUT STD_LOGIC;
                 signal DM9000A_avalonS_wait_counter_eq_0 : OUT STD_LOGIC;
                 signal DM9000A_avalonS_write_n : OUT STD_LOGIC;
                 signal DM9000A_avalonS_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_1_out_granted_DM9000A_avalonS : OUT STD_LOGIC;
                 signal clock_1_out_qualified_request_DM9000A_avalonS : OUT STD_LOGIC;
                 signal clock_1_out_read_data_valid_DM9000A_avalonS : OUT STD_LOGIC;
                 signal clock_1_out_requests_DM9000A_avalonS : OUT STD_LOGIC;
                 signal d1_DM9000A_avalonS_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of DM9000A_avalonS_arbitrator : entity is FALSE;
end entity DM9000A_avalonS_arbitrator;


architecture europa of DM9000A_avalonS_arbitrator is
                signal DM9000A_avalonS_allgrants :  STD_LOGIC;
                signal DM9000A_avalonS_allow_new_arb_cycle :  STD_LOGIC;
                signal DM9000A_avalonS_any_bursting_master_saved_grant :  STD_LOGIC;
                signal DM9000A_avalonS_any_continuerequest :  STD_LOGIC;
                signal DM9000A_avalonS_arb_counter_enable :  STD_LOGIC;
                signal DM9000A_avalonS_arb_share_counter :  STD_LOGIC;
                signal DM9000A_avalonS_arb_share_counter_next_value :  STD_LOGIC;
                signal DM9000A_avalonS_arb_share_set_values :  STD_LOGIC;
                signal DM9000A_avalonS_beginbursttransfer_internal :  STD_LOGIC;
                signal DM9000A_avalonS_begins_xfer :  STD_LOGIC;
                signal DM9000A_avalonS_counter_load_value :  STD_LOGIC;
                signal DM9000A_avalonS_end_xfer :  STD_LOGIC;
                signal DM9000A_avalonS_firsttransfer :  STD_LOGIC;
                signal DM9000A_avalonS_grant_vector :  STD_LOGIC;
                signal DM9000A_avalonS_in_a_read_cycle :  STD_LOGIC;
                signal DM9000A_avalonS_in_a_write_cycle :  STD_LOGIC;
                signal DM9000A_avalonS_master_qreq_vector :  STD_LOGIC;
                signal DM9000A_avalonS_non_bursting_master_requests :  STD_LOGIC;
                signal DM9000A_avalonS_reg_firsttransfer :  STD_LOGIC;
                signal DM9000A_avalonS_slavearbiterlockenable :  STD_LOGIC;
                signal DM9000A_avalonS_slavearbiterlockenable2 :  STD_LOGIC;
                signal DM9000A_avalonS_unreg_firsttransfer :  STD_LOGIC;
                signal DM9000A_avalonS_wait_counter :  STD_LOGIC;
                signal DM9000A_avalonS_waits_for_read :  STD_LOGIC;
                signal DM9000A_avalonS_waits_for_write :  STD_LOGIC;
                signal clock_1_out_arbiterlock :  STD_LOGIC;
                signal clock_1_out_arbiterlock2 :  STD_LOGIC;
                signal clock_1_out_continuerequest :  STD_LOGIC;
                signal clock_1_out_saved_grant_DM9000A_avalonS :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_DM9000A_avalonS :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_DM9000A_avalonS_wait_counter_eq_0 :  STD_LOGIC;
                signal internal_clock_1_out_granted_DM9000A_avalonS :  STD_LOGIC;
                signal internal_clock_1_out_qualified_request_DM9000A_avalonS :  STD_LOGIC;
                signal internal_clock_1_out_requests_DM9000A_avalonS :  STD_LOGIC;
                signal wait_for_DM9000A_avalonS_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT DM9000A_avalonS_end_xfer;
      end if;
    end if;

  end process;

  DM9000A_avalonS_begins_xfer <= NOT d1_reasons_to_wait AND (internal_clock_1_out_qualified_request_DM9000A_avalonS);
  --assign DM9000A_avalonS_readdata_from_sa = DM9000A_avalonS_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  DM9000A_avalonS_readdata_from_sa <= DM9000A_avalonS_readdata;
  internal_clock_1_out_requests_DM9000A_avalonS <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_1_out_read OR clock_1_out_write)))))));
  --DM9000A_avalonS_arb_share_counter set values, which is an e_mux
  DM9000A_avalonS_arb_share_set_values <= std_logic'('1');
  --DM9000A_avalonS_non_bursting_master_requests mux, which is an e_mux
  DM9000A_avalonS_non_bursting_master_requests <= internal_clock_1_out_requests_DM9000A_avalonS;
  --DM9000A_avalonS_any_bursting_master_saved_grant mux, which is an e_mux
  DM9000A_avalonS_any_bursting_master_saved_grant <= std_logic'('0');
  --DM9000A_avalonS_arb_share_counter_next_value assignment, which is an e_assign
  DM9000A_avalonS_arb_share_counter_next_value <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(DM9000A_avalonS_firsttransfer) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(DM9000A_avalonS_arb_share_set_values))) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(DM9000A_avalonS_arb_share_counter) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(DM9000A_avalonS_arb_share_counter))) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))));
  --DM9000A_avalonS_allgrants all slave grants, which is an e_mux
  DM9000A_avalonS_allgrants <= DM9000A_avalonS_grant_vector;
  --DM9000A_avalonS_end_xfer assignment, which is an e_assign
  DM9000A_avalonS_end_xfer <= NOT ((DM9000A_avalonS_waits_for_read OR DM9000A_avalonS_waits_for_write));
  --end_xfer_arb_share_counter_term_DM9000A_avalonS arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_DM9000A_avalonS <= DM9000A_avalonS_end_xfer AND (((NOT DM9000A_avalonS_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --DM9000A_avalonS_arb_share_counter arbitration counter enable, which is an e_assign
  DM9000A_avalonS_arb_counter_enable <= ((end_xfer_arb_share_counter_term_DM9000A_avalonS AND DM9000A_avalonS_allgrants)) OR ((end_xfer_arb_share_counter_term_DM9000A_avalonS AND NOT DM9000A_avalonS_non_bursting_master_requests));
  --DM9000A_avalonS_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      DM9000A_avalonS_arb_share_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(DM9000A_avalonS_arb_counter_enable) = '1' then 
        DM9000A_avalonS_arb_share_counter <= DM9000A_avalonS_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --DM9000A_avalonS_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      DM9000A_avalonS_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((DM9000A_avalonS_master_qreq_vector AND end_xfer_arb_share_counter_term_DM9000A_avalonS)) OR ((end_xfer_arb_share_counter_term_DM9000A_avalonS AND NOT DM9000A_avalonS_non_bursting_master_requests)))) = '1' then 
        DM9000A_avalonS_slavearbiterlockenable <= DM9000A_avalonS_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_1/out DM9000A/avalonS arbiterlock, which is an e_assign
  clock_1_out_arbiterlock <= DM9000A_avalonS_slavearbiterlockenable AND clock_1_out_continuerequest;
  --DM9000A_avalonS_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  DM9000A_avalonS_slavearbiterlockenable2 <= DM9000A_avalonS_arb_share_counter_next_value;
  --clock_1/out DM9000A/avalonS arbiterlock2, which is an e_assign
  clock_1_out_arbiterlock2 <= DM9000A_avalonS_slavearbiterlockenable2 AND clock_1_out_continuerequest;
  --DM9000A_avalonS_any_continuerequest at least one master continues requesting, which is an e_assign
  DM9000A_avalonS_any_continuerequest <= std_logic'('1');
  --clock_1_out_continuerequest continued request, which is an e_assign
  clock_1_out_continuerequest <= std_logic'('1');
  internal_clock_1_out_qualified_request_DM9000A_avalonS <= internal_clock_1_out_requests_DM9000A_avalonS;
  --DM9000A_avalonS_writedata mux, which is an e_mux
  DM9000A_avalonS_writedata <= clock_1_out_writedata;
  --master is always granted when requested
  internal_clock_1_out_granted_DM9000A_avalonS <= internal_clock_1_out_qualified_request_DM9000A_avalonS;
  --clock_1/out saved-grant DM9000A/avalonS, which is an e_assign
  clock_1_out_saved_grant_DM9000A_avalonS <= internal_clock_1_out_requests_DM9000A_avalonS;
  --allow new arb cycle for DM9000A/avalonS, which is an e_assign
  DM9000A_avalonS_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  DM9000A_avalonS_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  DM9000A_avalonS_master_qreq_vector <= std_logic'('1');
  --DM9000A_avalonS_reset_n assignment, which is an e_assign
  DM9000A_avalonS_reset_n <= reset_n;
  DM9000A_avalonS_chipselect_n <= NOT internal_clock_1_out_granted_DM9000A_avalonS;
  --DM9000A_avalonS_firsttransfer first transaction, which is an e_assign
  DM9000A_avalonS_firsttransfer <= A_WE_StdLogic((std_logic'(DM9000A_avalonS_begins_xfer) = '1'), DM9000A_avalonS_unreg_firsttransfer, DM9000A_avalonS_reg_firsttransfer);
  --DM9000A_avalonS_unreg_firsttransfer first transaction, which is an e_assign
  DM9000A_avalonS_unreg_firsttransfer <= NOT ((DM9000A_avalonS_slavearbiterlockenable AND DM9000A_avalonS_any_continuerequest));
  --DM9000A_avalonS_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      DM9000A_avalonS_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(DM9000A_avalonS_begins_xfer) = '1' then 
        DM9000A_avalonS_reg_firsttransfer <= DM9000A_avalonS_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --DM9000A_avalonS_beginbursttransfer_internal begin burst transfer, which is an e_assign
  DM9000A_avalonS_beginbursttransfer_internal <= DM9000A_avalonS_begins_xfer;
  --~DM9000A_avalonS_read_n assignment, which is an e_mux
  DM9000A_avalonS_read_n <= NOT ((((internal_clock_1_out_granted_DM9000A_avalonS AND clock_1_out_read)) AND NOT DM9000A_avalonS_begins_xfer));
  --~DM9000A_avalonS_write_n assignment, which is an e_mux
  DM9000A_avalonS_write_n <= NOT (((((internal_clock_1_out_granted_DM9000A_avalonS AND clock_1_out_write)) AND NOT DM9000A_avalonS_begins_xfer) AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(DM9000A_avalonS_wait_counter)))>=std_logic_vector'("00000000000000000000000000000001"))))));
  --DM9000A_avalonS_address mux, which is an e_mux
  DM9000A_avalonS_address <= clock_1_out_nativeaddress;
  --d1_DM9000A_avalonS_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_DM9000A_avalonS_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_DM9000A_avalonS_end_xfer <= DM9000A_avalonS_end_xfer;
      end if;
    end if;

  end process;

  --DM9000A_avalonS_waits_for_read in a cycle, which is an e_mux
  DM9000A_avalonS_waits_for_read <= DM9000A_avalonS_in_a_read_cycle AND DM9000A_avalonS_begins_xfer;
  --DM9000A_avalonS_in_a_read_cycle assignment, which is an e_assign
  DM9000A_avalonS_in_a_read_cycle <= internal_clock_1_out_granted_DM9000A_avalonS AND clock_1_out_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= DM9000A_avalonS_in_a_read_cycle;
  --DM9000A_avalonS_waits_for_write in a cycle, which is an e_mux
  DM9000A_avalonS_waits_for_write <= DM9000A_avalonS_in_a_write_cycle AND wait_for_DM9000A_avalonS_counter;
  --DM9000A_avalonS_in_a_write_cycle assignment, which is an e_assign
  DM9000A_avalonS_in_a_write_cycle <= internal_clock_1_out_granted_DM9000A_avalonS AND clock_1_out_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= DM9000A_avalonS_in_a_write_cycle;
  internal_DM9000A_avalonS_wait_counter_eq_0 <= to_std_logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(DM9000A_avalonS_wait_counter))) = std_logic_vector'("00000000000000000000000000000000")));
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      DM9000A_avalonS_wait_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        DM9000A_avalonS_wait_counter <= DM9000A_avalonS_counter_load_value;
      end if;
    end if;

  end process;

  DM9000A_avalonS_counter_load_value <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(((DM9000A_avalonS_in_a_write_cycle AND DM9000A_avalonS_begins_xfer))) = '1'), std_logic_vector'("000000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'((NOT internal_DM9000A_avalonS_wait_counter_eq_0)) = '1'), ((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(DM9000A_avalonS_wait_counter))) - std_logic_vector'("000000000000000000000000000000001")), std_logic_vector'("000000000000000000000000000000000"))));
  wait_for_DM9000A_avalonS_counter <= DM9000A_avalonS_begins_xfer OR NOT internal_DM9000A_avalonS_wait_counter_eq_0;
  --assign DM9000A_avalonS_irq_from_sa = DM9000A_avalonS_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  DM9000A_avalonS_irq_from_sa <= DM9000A_avalonS_irq;
  --vhdl renameroo for output signals
  DM9000A_avalonS_wait_counter_eq_0 <= internal_DM9000A_avalonS_wait_counter_eq_0;
  --vhdl renameroo for output signals
  clock_1_out_granted_DM9000A_avalonS <= internal_clock_1_out_granted_DM9000A_avalonS;
  --vhdl renameroo for output signals
  clock_1_out_qualified_request_DM9000A_avalonS <= internal_clock_1_out_qualified_request_DM9000A_avalonS;
  --vhdl renameroo for output signals
  clock_1_out_requests_DM9000A_avalonS <= internal_clock_1_out_requests_DM9000A_avalonS;
--synthesis translate_off
    --DM9000A/avalonS enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity arbitrator_inst_avalon_slave_0_arbitrator is 
        port (
              -- inputs:
                 signal arbitrator_inst_avalon_slave_0_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal arbitrator_inst_avalon_slave_0_waitrequest : IN STD_LOGIC;
                 signal clk : IN STD_LOGIC;
                 signal clock_4_out_address_to_slave : IN STD_LOGIC_VECTOR (16 DOWNTO 0);
                 signal clock_4_out_read : IN STD_LOGIC;
                 signal clock_4_out_write : IN STD_LOGIC;
                 signal clock_4_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal arbitrator_inst_avalon_slave_0_address : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal arbitrator_inst_avalon_slave_0_chipselect : OUT STD_LOGIC;
                 signal arbitrator_inst_avalon_slave_0_read : OUT STD_LOGIC;
                 signal arbitrator_inst_avalon_slave_0_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal arbitrator_inst_avalon_slave_0_reset : OUT STD_LOGIC;
                 signal arbitrator_inst_avalon_slave_0_waitrequest_from_sa : OUT STD_LOGIC;
                 signal arbitrator_inst_avalon_slave_0_write : OUT STD_LOGIC;
                 signal arbitrator_inst_avalon_slave_0_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_4_out_granted_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal clock_4_out_requests_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal d1_arbitrator_inst_avalon_slave_0_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of arbitrator_inst_avalon_slave_0_arbitrator : entity is FALSE;
end entity arbitrator_inst_avalon_slave_0_arbitrator;


architecture europa of arbitrator_inst_avalon_slave_0_arbitrator is
                signal arbitrator_inst_avalon_slave_0_allgrants :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_allow_new_arb_cycle :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_any_bursting_master_saved_grant :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_any_continuerequest :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_arb_counter_enable :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_arb_share_counter :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_arb_share_counter_next_value :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_arb_share_set_values :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_beginbursttransfer_internal :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_begins_xfer :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_end_xfer :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_firsttransfer :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_grant_vector :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_in_a_read_cycle :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_in_a_write_cycle :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_master_qreq_vector :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_non_bursting_master_requests :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_reg_firsttransfer :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_slavearbiterlockenable :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_slavearbiterlockenable2 :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_unreg_firsttransfer :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_waits_for_read :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_waits_for_write :  STD_LOGIC;
                signal clock_4_out_arbiterlock :  STD_LOGIC;
                signal clock_4_out_arbiterlock2 :  STD_LOGIC;
                signal clock_4_out_continuerequest :  STD_LOGIC;
                signal clock_4_out_saved_grant_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_arbitrator_inst_avalon_slave_0_waitrequest_from_sa :  STD_LOGIC;
                signal internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal internal_clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal internal_clock_4_out_requests_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal shifted_address_to_arbitrator_inst_avalon_slave_0_from_clock_4_out :  STD_LOGIC_VECTOR (16 DOWNTO 0);
                signal wait_for_arbitrator_inst_avalon_slave_0_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT arbitrator_inst_avalon_slave_0_end_xfer;
      end if;
    end if;

  end process;

  arbitrator_inst_avalon_slave_0_begins_xfer <= NOT d1_reasons_to_wait AND (internal_clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0);
  --assign arbitrator_inst_avalon_slave_0_readdata_from_sa = arbitrator_inst_avalon_slave_0_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  arbitrator_inst_avalon_slave_0_readdata_from_sa <= arbitrator_inst_avalon_slave_0_readdata;
  internal_clock_4_out_requests_arbitrator_inst_avalon_slave_0 <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_4_out_read OR clock_4_out_write)))))));
  --assign arbitrator_inst_avalon_slave_0_waitrequest_from_sa = arbitrator_inst_avalon_slave_0_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_arbitrator_inst_avalon_slave_0_waitrequest_from_sa <= arbitrator_inst_avalon_slave_0_waitrequest;
  --arbitrator_inst_avalon_slave_0_arb_share_counter set values, which is an e_mux
  arbitrator_inst_avalon_slave_0_arb_share_set_values <= std_logic'('1');
  --arbitrator_inst_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  arbitrator_inst_avalon_slave_0_non_bursting_master_requests <= internal_clock_4_out_requests_arbitrator_inst_avalon_slave_0;
  --arbitrator_inst_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  arbitrator_inst_avalon_slave_0_any_bursting_master_saved_grant <= std_logic'('0');
  --arbitrator_inst_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  arbitrator_inst_avalon_slave_0_arb_share_counter_next_value <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(arbitrator_inst_avalon_slave_0_firsttransfer) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(arbitrator_inst_avalon_slave_0_arb_share_set_values))) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(arbitrator_inst_avalon_slave_0_arb_share_counter) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(arbitrator_inst_avalon_slave_0_arb_share_counter))) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))));
  --arbitrator_inst_avalon_slave_0_allgrants all slave grants, which is an e_mux
  arbitrator_inst_avalon_slave_0_allgrants <= arbitrator_inst_avalon_slave_0_grant_vector;
  --arbitrator_inst_avalon_slave_0_end_xfer assignment, which is an e_assign
  arbitrator_inst_avalon_slave_0_end_xfer <= NOT ((arbitrator_inst_avalon_slave_0_waits_for_read OR arbitrator_inst_avalon_slave_0_waits_for_write));
  --end_xfer_arb_share_counter_term_arbitrator_inst_avalon_slave_0 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_arbitrator_inst_avalon_slave_0 <= arbitrator_inst_avalon_slave_0_end_xfer AND (((NOT arbitrator_inst_avalon_slave_0_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --arbitrator_inst_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  arbitrator_inst_avalon_slave_0_arb_counter_enable <= ((end_xfer_arb_share_counter_term_arbitrator_inst_avalon_slave_0 AND arbitrator_inst_avalon_slave_0_allgrants)) OR ((end_xfer_arb_share_counter_term_arbitrator_inst_avalon_slave_0 AND NOT arbitrator_inst_avalon_slave_0_non_bursting_master_requests));
  --arbitrator_inst_avalon_slave_0_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      arbitrator_inst_avalon_slave_0_arb_share_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(arbitrator_inst_avalon_slave_0_arb_counter_enable) = '1' then 
        arbitrator_inst_avalon_slave_0_arb_share_counter <= arbitrator_inst_avalon_slave_0_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --arbitrator_inst_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      arbitrator_inst_avalon_slave_0_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((arbitrator_inst_avalon_slave_0_master_qreq_vector AND end_xfer_arb_share_counter_term_arbitrator_inst_avalon_slave_0)) OR ((end_xfer_arb_share_counter_term_arbitrator_inst_avalon_slave_0 AND NOT arbitrator_inst_avalon_slave_0_non_bursting_master_requests)))) = '1' then 
        arbitrator_inst_avalon_slave_0_slavearbiterlockenable <= arbitrator_inst_avalon_slave_0_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_4/out arbitrator_inst/avalon_slave_0 arbiterlock, which is an e_assign
  clock_4_out_arbiterlock <= arbitrator_inst_avalon_slave_0_slavearbiterlockenable AND clock_4_out_continuerequest;
  --arbitrator_inst_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  arbitrator_inst_avalon_slave_0_slavearbiterlockenable2 <= arbitrator_inst_avalon_slave_0_arb_share_counter_next_value;
  --clock_4/out arbitrator_inst/avalon_slave_0 arbiterlock2, which is an e_assign
  clock_4_out_arbiterlock2 <= arbitrator_inst_avalon_slave_0_slavearbiterlockenable2 AND clock_4_out_continuerequest;
  --arbitrator_inst_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_assign
  arbitrator_inst_avalon_slave_0_any_continuerequest <= std_logic'('1');
  --clock_4_out_continuerequest continued request, which is an e_assign
  clock_4_out_continuerequest <= std_logic'('1');
  internal_clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 <= internal_clock_4_out_requests_arbitrator_inst_avalon_slave_0;
  --arbitrator_inst_avalon_slave_0_writedata mux, which is an e_mux
  arbitrator_inst_avalon_slave_0_writedata <= clock_4_out_writedata;
  --master is always granted when requested
  internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0 <= internal_clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0;
  --clock_4/out saved-grant arbitrator_inst/avalon_slave_0, which is an e_assign
  clock_4_out_saved_grant_arbitrator_inst_avalon_slave_0 <= internal_clock_4_out_requests_arbitrator_inst_avalon_slave_0;
  --allow new arb cycle for arbitrator_inst/avalon_slave_0, which is an e_assign
  arbitrator_inst_avalon_slave_0_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  arbitrator_inst_avalon_slave_0_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  arbitrator_inst_avalon_slave_0_master_qreq_vector <= std_logic'('1');
  --~arbitrator_inst_avalon_slave_0_reset assignment, which is an e_assign
  arbitrator_inst_avalon_slave_0_reset <= NOT reset_n;
  arbitrator_inst_avalon_slave_0_chipselect <= internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0;
  --arbitrator_inst_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  arbitrator_inst_avalon_slave_0_firsttransfer <= A_WE_StdLogic((std_logic'(arbitrator_inst_avalon_slave_0_begins_xfer) = '1'), arbitrator_inst_avalon_slave_0_unreg_firsttransfer, arbitrator_inst_avalon_slave_0_reg_firsttransfer);
  --arbitrator_inst_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  arbitrator_inst_avalon_slave_0_unreg_firsttransfer <= NOT ((arbitrator_inst_avalon_slave_0_slavearbiterlockenable AND arbitrator_inst_avalon_slave_0_any_continuerequest));
  --arbitrator_inst_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      arbitrator_inst_avalon_slave_0_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(arbitrator_inst_avalon_slave_0_begins_xfer) = '1' then 
        arbitrator_inst_avalon_slave_0_reg_firsttransfer <= arbitrator_inst_avalon_slave_0_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --arbitrator_inst_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  arbitrator_inst_avalon_slave_0_beginbursttransfer_internal <= arbitrator_inst_avalon_slave_0_begins_xfer;
  --arbitrator_inst_avalon_slave_0_read assignment, which is an e_mux
  arbitrator_inst_avalon_slave_0_read <= internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0 AND clock_4_out_read;
  --arbitrator_inst_avalon_slave_0_write assignment, which is an e_mux
  arbitrator_inst_avalon_slave_0_write <= internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0 AND clock_4_out_write;
  shifted_address_to_arbitrator_inst_avalon_slave_0_from_clock_4_out <= clock_4_out_address_to_slave;
  --arbitrator_inst_avalon_slave_0_address mux, which is an e_mux
  arbitrator_inst_avalon_slave_0_address <= A_EXT (A_SRL(shifted_address_to_arbitrator_inst_avalon_slave_0_from_clock_4_out,std_logic_vector'("00000000000000000000000000000001")), 16);
  --d1_arbitrator_inst_avalon_slave_0_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_arbitrator_inst_avalon_slave_0_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_arbitrator_inst_avalon_slave_0_end_xfer <= arbitrator_inst_avalon_slave_0_end_xfer;
      end if;
    end if;

  end process;

  --arbitrator_inst_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  arbitrator_inst_avalon_slave_0_waits_for_read <= arbitrator_inst_avalon_slave_0_in_a_read_cycle AND internal_arbitrator_inst_avalon_slave_0_waitrequest_from_sa;
  --arbitrator_inst_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  arbitrator_inst_avalon_slave_0_in_a_read_cycle <= internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0 AND clock_4_out_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= arbitrator_inst_avalon_slave_0_in_a_read_cycle;
  --arbitrator_inst_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  arbitrator_inst_avalon_slave_0_waits_for_write <= arbitrator_inst_avalon_slave_0_in_a_write_cycle AND internal_arbitrator_inst_avalon_slave_0_waitrequest_from_sa;
  --arbitrator_inst_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  arbitrator_inst_avalon_slave_0_in_a_write_cycle <= internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0 AND clock_4_out_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= arbitrator_inst_avalon_slave_0_in_a_write_cycle;
  wait_for_arbitrator_inst_avalon_slave_0_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  arbitrator_inst_avalon_slave_0_waitrequest_from_sa <= internal_arbitrator_inst_avalon_slave_0_waitrequest_from_sa;
  --vhdl renameroo for output signals
  clock_4_out_granted_arbitrator_inst_avalon_slave_0 <= internal_clock_4_out_granted_arbitrator_inst_avalon_slave_0;
  --vhdl renameroo for output signals
  clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 <= internal_clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0;
  --vhdl renameroo for output signals
  clock_4_out_requests_arbitrator_inst_avalon_slave_0 <= internal_clock_4_out_requests_arbitrator_inst_avalon_slave_0;
--synthesis translate_off
    --arbitrator_inst/avalon_slave_0 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity clock_0_in_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_0_in_endofpacket : IN STD_LOGIC;
                 signal clock_0_in_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_0_in_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_0_in_address : OUT STD_LOGIC_VECTOR (2 DOWNTO 0);
                 signal clock_0_in_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal clock_0_in_endofpacket_from_sa : OUT STD_LOGIC;
                 signal clock_0_in_nativeaddress : OUT STD_LOGIC;
                 signal clock_0_in_read : OUT STD_LOGIC;
                 signal clock_0_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_0_in_reset_n : OUT STD_LOGIC;
                 signal clock_0_in_waitrequest_from_sa : OUT STD_LOGIC;
                 signal clock_0_in_write : OUT STD_LOGIC;
                 signal clock_0_in_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_data_master_granted_clock_0_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_0_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_0_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_0_in : OUT STD_LOGIC;
                 signal d1_clock_0_in_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_0_in_arbitrator : entity is FALSE;
end entity clock_0_in_arbitrator;


architecture europa of clock_0_in_arbitrator is
                signal clock_0_in_allgrants :  STD_LOGIC;
                signal clock_0_in_allow_new_arb_cycle :  STD_LOGIC;
                signal clock_0_in_any_bursting_master_saved_grant :  STD_LOGIC;
                signal clock_0_in_any_continuerequest :  STD_LOGIC;
                signal clock_0_in_arb_counter_enable :  STD_LOGIC;
                signal clock_0_in_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_0_in_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_0_in_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_0_in_beginbursttransfer_internal :  STD_LOGIC;
                signal clock_0_in_begins_xfer :  STD_LOGIC;
                signal clock_0_in_end_xfer :  STD_LOGIC;
                signal clock_0_in_firsttransfer :  STD_LOGIC;
                signal clock_0_in_grant_vector :  STD_LOGIC;
                signal clock_0_in_in_a_read_cycle :  STD_LOGIC;
                signal clock_0_in_in_a_write_cycle :  STD_LOGIC;
                signal clock_0_in_master_qreq_vector :  STD_LOGIC;
                signal clock_0_in_non_bursting_master_requests :  STD_LOGIC;
                signal clock_0_in_reg_firsttransfer :  STD_LOGIC;
                signal clock_0_in_slavearbiterlockenable :  STD_LOGIC;
                signal clock_0_in_slavearbiterlockenable2 :  STD_LOGIC;
                signal clock_0_in_unreg_firsttransfer :  STD_LOGIC;
                signal clock_0_in_waits_for_read :  STD_LOGIC;
                signal clock_0_in_waits_for_write :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_data_master_continuerequest :  STD_LOGIC;
                signal cpu_0_data_master_saved_grant_clock_0_in :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_clock_0_in :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_0_in_waitrequest_from_sa :  STD_LOGIC;
                signal internal_cpu_0_data_master_granted_clock_0_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_qualified_request_clock_0_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_requests_clock_0_in :  STD_LOGIC;
                signal shifted_address_to_clock_0_in_from_cpu_0_data_master :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal wait_for_clock_0_in_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT clock_0_in_end_xfer;
      end if;
    end if;

  end process;

  clock_0_in_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_0_data_master_qualified_request_clock_0_in);
  --assign clock_0_in_readdata_from_sa = clock_0_in_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_0_in_readdata_from_sa <= clock_0_in_readdata;
  internal_cpu_0_data_master_requests_clock_0_in <= to_std_logic(((Std_Logic_Vector'(cpu_0_data_master_address_to_slave(24 DOWNTO 3) & std_logic_vector'("000")) = std_logic_vector'("1000000000010001000000000")))) AND ((cpu_0_data_master_read OR cpu_0_data_master_write));
  --assign clock_0_in_waitrequest_from_sa = clock_0_in_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_clock_0_in_waitrequest_from_sa <= clock_0_in_waitrequest;
  --clock_0_in_arb_share_counter set values, which is an e_mux
  clock_0_in_arb_share_set_values <= std_logic_vector'("01");
  --clock_0_in_non_bursting_master_requests mux, which is an e_mux
  clock_0_in_non_bursting_master_requests <= internal_cpu_0_data_master_requests_clock_0_in;
  --clock_0_in_any_bursting_master_saved_grant mux, which is an e_mux
  clock_0_in_any_bursting_master_saved_grant <= std_logic'('0');
  --clock_0_in_arb_share_counter_next_value assignment, which is an e_assign
  clock_0_in_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(clock_0_in_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_0_in_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(clock_0_in_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_0_in_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --clock_0_in_allgrants all slave grants, which is an e_mux
  clock_0_in_allgrants <= clock_0_in_grant_vector;
  --clock_0_in_end_xfer assignment, which is an e_assign
  clock_0_in_end_xfer <= NOT ((clock_0_in_waits_for_read OR clock_0_in_waits_for_write));
  --end_xfer_arb_share_counter_term_clock_0_in arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_clock_0_in <= clock_0_in_end_xfer AND (((NOT clock_0_in_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --clock_0_in_arb_share_counter arbitration counter enable, which is an e_assign
  clock_0_in_arb_counter_enable <= ((end_xfer_arb_share_counter_term_clock_0_in AND clock_0_in_allgrants)) OR ((end_xfer_arb_share_counter_term_clock_0_in AND NOT clock_0_in_non_bursting_master_requests));
  --clock_0_in_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_0_in_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(clock_0_in_arb_counter_enable) = '1' then 
        clock_0_in_arb_share_counter <= clock_0_in_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_0_in_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_0_in_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clock_0_in_master_qreq_vector AND end_xfer_arb_share_counter_term_clock_0_in)) OR ((end_xfer_arb_share_counter_term_clock_0_in AND NOT clock_0_in_non_bursting_master_requests)))) = '1' then 
        clock_0_in_slavearbiterlockenable <= or_reduce(clock_0_in_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/data_master clock_0/in arbiterlock, which is an e_assign
  cpu_0_data_master_arbiterlock <= clock_0_in_slavearbiterlockenable AND cpu_0_data_master_continuerequest;
  --clock_0_in_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  clock_0_in_slavearbiterlockenable2 <= or_reduce(clock_0_in_arb_share_counter_next_value);
  --cpu_0/data_master clock_0/in arbiterlock2, which is an e_assign
  cpu_0_data_master_arbiterlock2 <= clock_0_in_slavearbiterlockenable2 AND cpu_0_data_master_continuerequest;
  --clock_0_in_any_continuerequest at least one master continues requesting, which is an e_assign
  clock_0_in_any_continuerequest <= std_logic'('1');
  --cpu_0_data_master_continuerequest continued request, which is an e_assign
  cpu_0_data_master_continuerequest <= std_logic'('1');
  internal_cpu_0_data_master_qualified_request_clock_0_in <= internal_cpu_0_data_master_requests_clock_0_in AND NOT ((((cpu_0_data_master_read AND (NOT cpu_0_data_master_waitrequest))) OR (((NOT cpu_0_data_master_waitrequest) AND cpu_0_data_master_write))));
  --clock_0_in_writedata mux, which is an e_mux
  clock_0_in_writedata <= cpu_0_data_master_writedata;
  --assign clock_0_in_endofpacket_from_sa = clock_0_in_endofpacket so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_0_in_endofpacket_from_sa <= clock_0_in_endofpacket;
  --master is always granted when requested
  internal_cpu_0_data_master_granted_clock_0_in <= internal_cpu_0_data_master_qualified_request_clock_0_in;
  --cpu_0/data_master saved-grant clock_0/in, which is an e_assign
  cpu_0_data_master_saved_grant_clock_0_in <= internal_cpu_0_data_master_requests_clock_0_in;
  --allow new arb cycle for clock_0/in, which is an e_assign
  clock_0_in_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  clock_0_in_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  clock_0_in_master_qreq_vector <= std_logic'('1');
  --clock_0_in_reset_n assignment, which is an e_assign
  clock_0_in_reset_n <= reset_n;
  --clock_0_in_firsttransfer first transaction, which is an e_assign
  clock_0_in_firsttransfer <= A_WE_StdLogic((std_logic'(clock_0_in_begins_xfer) = '1'), clock_0_in_unreg_firsttransfer, clock_0_in_reg_firsttransfer);
  --clock_0_in_unreg_firsttransfer first transaction, which is an e_assign
  clock_0_in_unreg_firsttransfer <= NOT ((clock_0_in_slavearbiterlockenable AND clock_0_in_any_continuerequest));
  --clock_0_in_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_0_in_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(clock_0_in_begins_xfer) = '1' then 
        clock_0_in_reg_firsttransfer <= clock_0_in_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --clock_0_in_beginbursttransfer_internal begin burst transfer, which is an e_assign
  clock_0_in_beginbursttransfer_internal <= clock_0_in_begins_xfer;
  --clock_0_in_read assignment, which is an e_mux
  clock_0_in_read <= internal_cpu_0_data_master_granted_clock_0_in AND cpu_0_data_master_read;
  --clock_0_in_write assignment, which is an e_mux
  clock_0_in_write <= internal_cpu_0_data_master_granted_clock_0_in AND cpu_0_data_master_write;
  shifted_address_to_clock_0_in_from_cpu_0_data_master <= cpu_0_data_master_address_to_slave;
  --clock_0_in_address mux, which is an e_mux
  clock_0_in_address <= A_EXT (A_SRL(shifted_address_to_clock_0_in_from_cpu_0_data_master,std_logic_vector'("00000000000000000000000000000010")), 3);
  --slaveid clock_0_in_nativeaddress nativeaddress mux, which is an e_mux
  clock_0_in_nativeaddress <= Vector_To_Std_Logic(A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")));
  --d1_clock_0_in_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_clock_0_in_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_clock_0_in_end_xfer <= clock_0_in_end_xfer;
      end if;
    end if;

  end process;

  --clock_0_in_waits_for_read in a cycle, which is an e_mux
  clock_0_in_waits_for_read <= clock_0_in_in_a_read_cycle AND internal_clock_0_in_waitrequest_from_sa;
  --clock_0_in_in_a_read_cycle assignment, which is an e_assign
  clock_0_in_in_a_read_cycle <= internal_cpu_0_data_master_granted_clock_0_in AND cpu_0_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= clock_0_in_in_a_read_cycle;
  --clock_0_in_waits_for_write in a cycle, which is an e_mux
  clock_0_in_waits_for_write <= clock_0_in_in_a_write_cycle AND internal_clock_0_in_waitrequest_from_sa;
  --clock_0_in_in_a_write_cycle assignment, which is an e_assign
  clock_0_in_in_a_write_cycle <= internal_cpu_0_data_master_granted_clock_0_in AND cpu_0_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= clock_0_in_in_a_write_cycle;
  wait_for_clock_0_in_counter <= std_logic'('0');
  --clock_0_in_byteenable byte enable port mux, which is an e_mux
  clock_0_in_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_clock_0_in)) = '1'), (std_logic_vector'("0000000000000000000000000000") & (cpu_0_data_master_byteenable)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 4);
  --vhdl renameroo for output signals
  clock_0_in_waitrequest_from_sa <= internal_clock_0_in_waitrequest_from_sa;
  --vhdl renameroo for output signals
  cpu_0_data_master_granted_clock_0_in <= internal_cpu_0_data_master_granted_clock_0_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_qualified_request_clock_0_in <= internal_cpu_0_data_master_qualified_request_clock_0_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_requests_clock_0_in <= internal_cpu_0_data_master_requests_clock_0_in;
--synthesis translate_off
    --clock_0/in enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity clock_0_out_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_0_out_address : IN STD_LOGIC_VECTOR (2 DOWNTO 0);
                 signal clock_0_out_granted_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                 signal clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                 signal clock_0_out_read : IN STD_LOGIC;
                 signal clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                 signal clock_0_out_requests_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                 signal clock_0_out_write : IN STD_LOGIC;
                 signal clock_0_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_jtag_uart_0_avalon_jtag_slave_end_xfer : IN STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_0_out_address_to_slave : OUT STD_LOGIC_VECTOR (2 DOWNTO 0);
                 signal clock_0_out_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_0_out_reset_n : OUT STD_LOGIC;
                 signal clock_0_out_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_0_out_arbitrator : entity is FALSE;
end entity clock_0_out_arbitrator;


architecture europa of clock_0_out_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal clock_0_out_address_last_time :  STD_LOGIC_VECTOR (2 DOWNTO 0);
                signal clock_0_out_read_last_time :  STD_LOGIC;
                signal clock_0_out_run :  STD_LOGIC;
                signal clock_0_out_write_last_time :  STD_LOGIC;
                signal clock_0_out_writedata_last_time :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal internal_clock_0_out_address_to_slave :  STD_LOGIC_VECTOR (2 DOWNTO 0);
                signal internal_clock_0_out_waitrequest :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;

begin

  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001") AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave OR NOT ((clock_0_out_read OR clock_0_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_0_out_read OR clock_0_out_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave OR NOT ((clock_0_out_read OR clock_0_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_0_out_read OR clock_0_out_write)))))))))));
  --cascaded wait assignment, which is an e_assign
  clock_0_out_run <= r_1;
  --optimize select-logic by passing only those address bits which matter.
  internal_clock_0_out_address_to_slave <= clock_0_out_address;
  --clock_0/out readdata mux, which is an e_mux
  clock_0_out_readdata <= jtag_uart_0_avalon_jtag_slave_readdata_from_sa;
  --actual waitrequest port, which is an e_assign
  internal_clock_0_out_waitrequest <= NOT clock_0_out_run;
  --clock_0_out_reset_n assignment, which is an e_assign
  clock_0_out_reset_n <= reset_n;
  --vhdl renameroo for output signals
  clock_0_out_address_to_slave <= internal_clock_0_out_address_to_slave;
  --vhdl renameroo for output signals
  clock_0_out_waitrequest <= internal_clock_0_out_waitrequest;
--synthesis translate_off
    --clock_0_out_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_0_out_address_last_time <= std_logic_vector'("000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_0_out_address_last_time <= clock_0_out_address;
        end if;
      end if;

    end process;

    --clock_0/out waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_clock_0_out_waitrequest AND ((clock_0_out_read OR clock_0_out_write));
        end if;
      end if;

    end process;

    --clock_0_out_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_0_out_address, clock_0_out_address_last_time)
    VARIABLE write_line : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((clock_0_out_address /= clock_0_out_address_last_time))))) = '1' then 
          write(write_line, now);
          write(write_line, string'(": "));
          write(write_line, string'("clock_0_out_address did not heed wait!!!"));
          write(output, write_line.all);
          deallocate (write_line);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_0_out_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_0_out_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_0_out_read_last_time <= clock_0_out_read;
        end if;
      end if;

    end process;

    --clock_0_out_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_0_out_read, clock_0_out_read_last_time)
    VARIABLE write_line1 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_0_out_read) /= std_logic'(clock_0_out_read_last_time)))))) = '1' then 
          write(write_line1, now);
          write(write_line1, string'(": "));
          write(write_line1, string'("clock_0_out_read did not heed wait!!!"));
          write(output, write_line1.all);
          deallocate (write_line1);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_0_out_write check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_0_out_write_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_0_out_write_last_time <= clock_0_out_write;
        end if;
      end if;

    end process;

    --clock_0_out_write matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_0_out_write, clock_0_out_write_last_time)
    VARIABLE write_line2 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_0_out_write) /= std_logic'(clock_0_out_write_last_time)))))) = '1' then 
          write(write_line2, now);
          write(write_line2, string'(": "));
          write(write_line2, string'("clock_0_out_write did not heed wait!!!"));
          write(output, write_line2.all);
          deallocate (write_line2);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_0_out_writedata check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_0_out_writedata_last_time <= std_logic_vector'("00000000000000000000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_0_out_writedata_last_time <= clock_0_out_writedata;
        end if;
      end if;

    end process;

    --clock_0_out_writedata matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_0_out_write, clock_0_out_writedata, clock_0_out_writedata_last_time)
    VARIABLE write_line3 : line;
    begin
        if std_logic'(((active_and_waiting_last_time AND to_std_logic(((clock_0_out_writedata /= clock_0_out_writedata_last_time)))) AND clock_0_out_write)) = '1' then 
          write(write_line3, now);
          write(write_line3, string'(": "));
          write(write_line3, string'("clock_0_out_writedata did not heed wait!!!"));
          write(output, write_line3.all);
          deallocate (write_line3);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity clock_1_in_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_1_in_endofpacket : IN STD_LOGIC;
                 signal clock_1_in_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_1_in_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_1_in_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal clock_1_in_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal clock_1_in_endofpacket_from_sa : OUT STD_LOGIC;
                 signal clock_1_in_nativeaddress : OUT STD_LOGIC;
                 signal clock_1_in_read : OUT STD_LOGIC;
                 signal clock_1_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_1_in_reset_n : OUT STD_LOGIC;
                 signal clock_1_in_waitrequest_from_sa : OUT STD_LOGIC;
                 signal clock_1_in_write : OUT STD_LOGIC;
                 signal clock_1_in_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_0_data_master_granted_clock_1_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_1_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_1_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_1_in : OUT STD_LOGIC;
                 signal d1_clock_1_in_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_1_in_arbitrator : entity is FALSE;
end entity clock_1_in_arbitrator;


architecture europa of clock_1_in_arbitrator is
                signal clock_1_in_allgrants :  STD_LOGIC;
                signal clock_1_in_allow_new_arb_cycle :  STD_LOGIC;
                signal clock_1_in_any_bursting_master_saved_grant :  STD_LOGIC;
                signal clock_1_in_any_continuerequest :  STD_LOGIC;
                signal clock_1_in_arb_counter_enable :  STD_LOGIC;
                signal clock_1_in_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_in_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_in_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_in_beginbursttransfer_internal :  STD_LOGIC;
                signal clock_1_in_begins_xfer :  STD_LOGIC;
                signal clock_1_in_end_xfer :  STD_LOGIC;
                signal clock_1_in_firsttransfer :  STD_LOGIC;
                signal clock_1_in_grant_vector :  STD_LOGIC;
                signal clock_1_in_in_a_read_cycle :  STD_LOGIC;
                signal clock_1_in_in_a_write_cycle :  STD_LOGIC;
                signal clock_1_in_master_qreq_vector :  STD_LOGIC;
                signal clock_1_in_non_bursting_master_requests :  STD_LOGIC;
                signal clock_1_in_reg_firsttransfer :  STD_LOGIC;
                signal clock_1_in_slavearbiterlockenable :  STD_LOGIC;
                signal clock_1_in_slavearbiterlockenable2 :  STD_LOGIC;
                signal clock_1_in_unreg_firsttransfer :  STD_LOGIC;
                signal clock_1_in_waits_for_read :  STD_LOGIC;
                signal clock_1_in_waits_for_write :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_data_master_continuerequest :  STD_LOGIC;
                signal cpu_0_data_master_saved_grant_clock_1_in :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_clock_1_in :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_1_in_waitrequest_from_sa :  STD_LOGIC;
                signal internal_cpu_0_data_master_granted_clock_1_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_qualified_request_clock_1_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_requests_clock_1_in :  STD_LOGIC;
                signal shifted_address_to_clock_1_in_from_cpu_0_data_master :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal wait_for_clock_1_in_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT clock_1_in_end_xfer;
      end if;
    end if;

  end process;

  clock_1_in_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_0_data_master_qualified_request_clock_1_in);
  --assign clock_1_in_readdata_from_sa = clock_1_in_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_1_in_readdata_from_sa <= clock_1_in_readdata;
  internal_cpu_0_data_master_requests_clock_1_in <= to_std_logic(((Std_Logic_Vector'(cpu_0_data_master_address_to_slave(24 DOWNTO 3) & std_logic_vector'("000")) = std_logic_vector'("1000000000010001000001000")))) AND ((cpu_0_data_master_read OR cpu_0_data_master_write));
  --assign clock_1_in_waitrequest_from_sa = clock_1_in_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_clock_1_in_waitrequest_from_sa <= clock_1_in_waitrequest;
  --clock_1_in_arb_share_counter set values, which is an e_mux
  clock_1_in_arb_share_set_values <= std_logic_vector'("01");
  --clock_1_in_non_bursting_master_requests mux, which is an e_mux
  clock_1_in_non_bursting_master_requests <= internal_cpu_0_data_master_requests_clock_1_in;
  --clock_1_in_any_bursting_master_saved_grant mux, which is an e_mux
  clock_1_in_any_bursting_master_saved_grant <= std_logic'('0');
  --clock_1_in_arb_share_counter_next_value assignment, which is an e_assign
  clock_1_in_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(clock_1_in_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_1_in_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(clock_1_in_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_1_in_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --clock_1_in_allgrants all slave grants, which is an e_mux
  clock_1_in_allgrants <= clock_1_in_grant_vector;
  --clock_1_in_end_xfer assignment, which is an e_assign
  clock_1_in_end_xfer <= NOT ((clock_1_in_waits_for_read OR clock_1_in_waits_for_write));
  --end_xfer_arb_share_counter_term_clock_1_in arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_clock_1_in <= clock_1_in_end_xfer AND (((NOT clock_1_in_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --clock_1_in_arb_share_counter arbitration counter enable, which is an e_assign
  clock_1_in_arb_counter_enable <= ((end_xfer_arb_share_counter_term_clock_1_in AND clock_1_in_allgrants)) OR ((end_xfer_arb_share_counter_term_clock_1_in AND NOT clock_1_in_non_bursting_master_requests));
  --clock_1_in_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_1_in_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(clock_1_in_arb_counter_enable) = '1' then 
        clock_1_in_arb_share_counter <= clock_1_in_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_1_in_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_1_in_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clock_1_in_master_qreq_vector AND end_xfer_arb_share_counter_term_clock_1_in)) OR ((end_xfer_arb_share_counter_term_clock_1_in AND NOT clock_1_in_non_bursting_master_requests)))) = '1' then 
        clock_1_in_slavearbiterlockenable <= or_reduce(clock_1_in_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/data_master clock_1/in arbiterlock, which is an e_assign
  cpu_0_data_master_arbiterlock <= clock_1_in_slavearbiterlockenable AND cpu_0_data_master_continuerequest;
  --clock_1_in_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  clock_1_in_slavearbiterlockenable2 <= or_reduce(clock_1_in_arb_share_counter_next_value);
  --cpu_0/data_master clock_1/in arbiterlock2, which is an e_assign
  cpu_0_data_master_arbiterlock2 <= clock_1_in_slavearbiterlockenable2 AND cpu_0_data_master_continuerequest;
  --clock_1_in_any_continuerequest at least one master continues requesting, which is an e_assign
  clock_1_in_any_continuerequest <= std_logic'('1');
  --cpu_0_data_master_continuerequest continued request, which is an e_assign
  cpu_0_data_master_continuerequest <= std_logic'('1');
  internal_cpu_0_data_master_qualified_request_clock_1_in <= internal_cpu_0_data_master_requests_clock_1_in AND NOT ((((cpu_0_data_master_read AND (NOT cpu_0_data_master_waitrequest))) OR (((NOT cpu_0_data_master_waitrequest) AND cpu_0_data_master_write))));
  --clock_1_in_writedata mux, which is an e_mux
  clock_1_in_writedata <= cpu_0_data_master_writedata (15 DOWNTO 0);
  --assign clock_1_in_endofpacket_from_sa = clock_1_in_endofpacket so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_1_in_endofpacket_from_sa <= clock_1_in_endofpacket;
  --master is always granted when requested
  internal_cpu_0_data_master_granted_clock_1_in <= internal_cpu_0_data_master_qualified_request_clock_1_in;
  --cpu_0/data_master saved-grant clock_1/in, which is an e_assign
  cpu_0_data_master_saved_grant_clock_1_in <= internal_cpu_0_data_master_requests_clock_1_in;
  --allow new arb cycle for clock_1/in, which is an e_assign
  clock_1_in_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  clock_1_in_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  clock_1_in_master_qreq_vector <= std_logic'('1');
  --clock_1_in_reset_n assignment, which is an e_assign
  clock_1_in_reset_n <= reset_n;
  --clock_1_in_firsttransfer first transaction, which is an e_assign
  clock_1_in_firsttransfer <= A_WE_StdLogic((std_logic'(clock_1_in_begins_xfer) = '1'), clock_1_in_unreg_firsttransfer, clock_1_in_reg_firsttransfer);
  --clock_1_in_unreg_firsttransfer first transaction, which is an e_assign
  clock_1_in_unreg_firsttransfer <= NOT ((clock_1_in_slavearbiterlockenable AND clock_1_in_any_continuerequest));
  --clock_1_in_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_1_in_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(clock_1_in_begins_xfer) = '1' then 
        clock_1_in_reg_firsttransfer <= clock_1_in_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --clock_1_in_beginbursttransfer_internal begin burst transfer, which is an e_assign
  clock_1_in_beginbursttransfer_internal <= clock_1_in_begins_xfer;
  --clock_1_in_read assignment, which is an e_mux
  clock_1_in_read <= internal_cpu_0_data_master_granted_clock_1_in AND cpu_0_data_master_read;
  --clock_1_in_write assignment, which is an e_mux
  clock_1_in_write <= internal_cpu_0_data_master_granted_clock_1_in AND cpu_0_data_master_write;
  shifted_address_to_clock_1_in_from_cpu_0_data_master <= cpu_0_data_master_address_to_slave;
  --clock_1_in_address mux, which is an e_mux
  clock_1_in_address <= A_EXT (A_SRL(shifted_address_to_clock_1_in_from_cpu_0_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --slaveid clock_1_in_nativeaddress nativeaddress mux, which is an e_mux
  clock_1_in_nativeaddress <= Vector_To_Std_Logic(A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")));
  --d1_clock_1_in_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_clock_1_in_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_clock_1_in_end_xfer <= clock_1_in_end_xfer;
      end if;
    end if;

  end process;

  --clock_1_in_waits_for_read in a cycle, which is an e_mux
  clock_1_in_waits_for_read <= clock_1_in_in_a_read_cycle AND internal_clock_1_in_waitrequest_from_sa;
  --clock_1_in_in_a_read_cycle assignment, which is an e_assign
  clock_1_in_in_a_read_cycle <= internal_cpu_0_data_master_granted_clock_1_in AND cpu_0_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= clock_1_in_in_a_read_cycle;
  --clock_1_in_waits_for_write in a cycle, which is an e_mux
  clock_1_in_waits_for_write <= clock_1_in_in_a_write_cycle AND internal_clock_1_in_waitrequest_from_sa;
  --clock_1_in_in_a_write_cycle assignment, which is an e_assign
  clock_1_in_in_a_write_cycle <= internal_cpu_0_data_master_granted_clock_1_in AND cpu_0_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= clock_1_in_in_a_write_cycle;
  wait_for_clock_1_in_counter <= std_logic'('0');
  --clock_1_in_byteenable byte enable port mux, which is an e_mux
  clock_1_in_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_clock_1_in)) = '1'), (std_logic_vector'("0000000000000000000000000000") & (cpu_0_data_master_byteenable)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 2);
  --vhdl renameroo for output signals
  clock_1_in_waitrequest_from_sa <= internal_clock_1_in_waitrequest_from_sa;
  --vhdl renameroo for output signals
  cpu_0_data_master_granted_clock_1_in <= internal_cpu_0_data_master_granted_clock_1_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_qualified_request_clock_1_in <= internal_cpu_0_data_master_qualified_request_clock_1_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_requests_clock_1_in <= internal_cpu_0_data_master_requests_clock_1_in;
--synthesis translate_off
    --clock_1/in enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity clock_1_out_arbitrator is 
        port (
              -- inputs:
                 signal DM9000A_avalonS_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal DM9000A_avalonS_wait_counter_eq_0 : IN STD_LOGIC;
                 signal clk : IN STD_LOGIC;
                 signal clock_1_out_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal clock_1_out_granted_DM9000A_avalonS : IN STD_LOGIC;
                 signal clock_1_out_qualified_request_DM9000A_avalonS : IN STD_LOGIC;
                 signal clock_1_out_read : IN STD_LOGIC;
                 signal clock_1_out_read_data_valid_DM9000A_avalonS : IN STD_LOGIC;
                 signal clock_1_out_requests_DM9000A_avalonS : IN STD_LOGIC;
                 signal clock_1_out_write : IN STD_LOGIC;
                 signal clock_1_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal d1_DM9000A_avalonS_end_xfer : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_1_out_address_to_slave : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal clock_1_out_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_1_out_reset_n : OUT STD_LOGIC;
                 signal clock_1_out_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_1_out_arbitrator : entity is FALSE;
end entity clock_1_out_arbitrator;


architecture europa of clock_1_out_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal clock_1_out_address_last_time :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_out_read_last_time :  STD_LOGIC;
                signal clock_1_out_run :  STD_LOGIC;
                signal clock_1_out_write_last_time :  STD_LOGIC;
                signal clock_1_out_writedata_last_time :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_clock_1_out_address_to_slave :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_clock_1_out_waitrequest :  STD_LOGIC;
                signal r_0 :  STD_LOGIC;

begin

  --r_0 master_run cascaded wait assignment, which is an e_assign
  r_0 <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001") AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_1_out_qualified_request_DM9000A_avalonS OR NOT clock_1_out_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_DM9000A_avalonS_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(clock_1_out_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_1_out_qualified_request_DM9000A_avalonS OR NOT clock_1_out_write)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((DM9000A_avalonS_wait_counter_eq_0 AND NOT d1_DM9000A_avalonS_end_xfer)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(clock_1_out_write)))))))));
  --cascaded wait assignment, which is an e_assign
  clock_1_out_run <= r_0;
  --optimize select-logic by passing only those address bits which matter.
  internal_clock_1_out_address_to_slave <= clock_1_out_address;
  --clock_1/out readdata mux, which is an e_mux
  clock_1_out_readdata <= DM9000A_avalonS_readdata_from_sa;
  --actual waitrequest port, which is an e_assign
  internal_clock_1_out_waitrequest <= NOT clock_1_out_run;
  --clock_1_out_reset_n assignment, which is an e_assign
  clock_1_out_reset_n <= reset_n;
  --vhdl renameroo for output signals
  clock_1_out_address_to_slave <= internal_clock_1_out_address_to_slave;
  --vhdl renameroo for output signals
  clock_1_out_waitrequest <= internal_clock_1_out_waitrequest;
--synthesis translate_off
    --clock_1_out_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_1_out_address_last_time <= std_logic_vector'("00");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_1_out_address_last_time <= clock_1_out_address;
        end if;
      end if;

    end process;

    --clock_1/out waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_clock_1_out_waitrequest AND ((clock_1_out_read OR clock_1_out_write));
        end if;
      end if;

    end process;

    --clock_1_out_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_1_out_address, clock_1_out_address_last_time)
    VARIABLE write_line4 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((clock_1_out_address /= clock_1_out_address_last_time))))) = '1' then 
          write(write_line4, now);
          write(write_line4, string'(": "));
          write(write_line4, string'("clock_1_out_address did not heed wait!!!"));
          write(output, write_line4.all);
          deallocate (write_line4);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_1_out_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_1_out_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_1_out_read_last_time <= clock_1_out_read;
        end if;
      end if;

    end process;

    --clock_1_out_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_1_out_read, clock_1_out_read_last_time)
    VARIABLE write_line5 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_1_out_read) /= std_logic'(clock_1_out_read_last_time)))))) = '1' then 
          write(write_line5, now);
          write(write_line5, string'(": "));
          write(write_line5, string'("clock_1_out_read did not heed wait!!!"));
          write(output, write_line5.all);
          deallocate (write_line5);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_1_out_write check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_1_out_write_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_1_out_write_last_time <= clock_1_out_write;
        end if;
      end if;

    end process;

    --clock_1_out_write matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_1_out_write, clock_1_out_write_last_time)
    VARIABLE write_line6 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_1_out_write) /= std_logic'(clock_1_out_write_last_time)))))) = '1' then 
          write(write_line6, now);
          write(write_line6, string'(": "));
          write(write_line6, string'("clock_1_out_write did not heed wait!!!"));
          write(output, write_line6.all);
          deallocate (write_line6);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_1_out_writedata check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_1_out_writedata_last_time <= std_logic_vector'("0000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_1_out_writedata_last_time <= clock_1_out_writedata;
        end if;
      end if;

    end process;

    --clock_1_out_writedata matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_1_out_write, clock_1_out_writedata, clock_1_out_writedata_last_time)
    VARIABLE write_line7 : line;
    begin
        if std_logic'(((active_and_waiting_last_time AND to_std_logic(((clock_1_out_writedata /= clock_1_out_writedata_last_time)))) AND clock_1_out_write)) = '1' then 
          write(write_line7, now);
          write(write_line7, string'(": "));
          write(write_line7, string'("clock_1_out_writedata did not heed wait!!!"));
          write(output, write_line7.all);
          deallocate (write_line7);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity clock_2_in_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_2_in_endofpacket : IN STD_LOGIC;
                 signal clock_2_in_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_2_in_waitrequest : IN STD_LOGIC;
                 signal cpu_0_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_instruction_master_latency_counter : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_2_in_address : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_2_in_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal clock_2_in_endofpacket_from_sa : OUT STD_LOGIC;
                 signal clock_2_in_nativeaddress : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal clock_2_in_read : OUT STD_LOGIC;
                 signal clock_2_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_2_in_reset_n : OUT STD_LOGIC;
                 signal clock_2_in_waitrequest_from_sa : OUT STD_LOGIC;
                 signal clock_2_in_write : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_granted_clock_2_in : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_qualified_request_clock_2_in : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_clock_2_in : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_requests_clock_2_in : OUT STD_LOGIC;
                 signal d1_clock_2_in_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_2_in_arbitrator : entity is FALSE;
end entity clock_2_in_arbitrator;


architecture europa of clock_2_in_arbitrator is
                signal clock_2_in_allgrants :  STD_LOGIC;
                signal clock_2_in_allow_new_arb_cycle :  STD_LOGIC;
                signal clock_2_in_any_bursting_master_saved_grant :  STD_LOGIC;
                signal clock_2_in_any_continuerequest :  STD_LOGIC;
                signal clock_2_in_arb_counter_enable :  STD_LOGIC;
                signal clock_2_in_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_2_in_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_2_in_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_2_in_beginbursttransfer_internal :  STD_LOGIC;
                signal clock_2_in_begins_xfer :  STD_LOGIC;
                signal clock_2_in_end_xfer :  STD_LOGIC;
                signal clock_2_in_firsttransfer :  STD_LOGIC;
                signal clock_2_in_grant_vector :  STD_LOGIC;
                signal clock_2_in_in_a_read_cycle :  STD_LOGIC;
                signal clock_2_in_in_a_write_cycle :  STD_LOGIC;
                signal clock_2_in_master_qreq_vector :  STD_LOGIC;
                signal clock_2_in_non_bursting_master_requests :  STD_LOGIC;
                signal clock_2_in_reg_firsttransfer :  STD_LOGIC;
                signal clock_2_in_slavearbiterlockenable :  STD_LOGIC;
                signal clock_2_in_slavearbiterlockenable2 :  STD_LOGIC;
                signal clock_2_in_unreg_firsttransfer :  STD_LOGIC;
                signal clock_2_in_waits_for_read :  STD_LOGIC;
                signal clock_2_in_waits_for_write :  STD_LOGIC;
                signal cpu_0_instruction_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_instruction_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_instruction_master_continuerequest :  STD_LOGIC;
                signal cpu_0_instruction_master_saved_grant_clock_2_in :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_clock_2_in :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_2_in_waitrequest_from_sa :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_granted_clock_2_in :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_qualified_request_clock_2_in :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_requests_clock_2_in :  STD_LOGIC;
                signal wait_for_clock_2_in_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT clock_2_in_end_xfer;
      end if;
    end if;

  end process;

  clock_2_in_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_0_instruction_master_qualified_request_clock_2_in);
  --assign clock_2_in_readdata_from_sa = clock_2_in_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_2_in_readdata_from_sa <= clock_2_in_readdata;
  internal_cpu_0_instruction_master_requests_clock_2_in <= ((to_std_logic(((Std_Logic_Vector'(cpu_0_instruction_master_address_to_slave(24 DOWNTO 11) & std_logic_vector'("00000000000")) = std_logic_vector'("1000000000001100000000000")))) AND (cpu_0_instruction_master_read))) AND cpu_0_instruction_master_read;
  --assign clock_2_in_waitrequest_from_sa = clock_2_in_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_clock_2_in_waitrequest_from_sa <= clock_2_in_waitrequest;
  --clock_2_in_arb_share_counter set values, which is an e_mux
  clock_2_in_arb_share_set_values <= std_logic_vector'("01");
  --clock_2_in_non_bursting_master_requests mux, which is an e_mux
  clock_2_in_non_bursting_master_requests <= internal_cpu_0_instruction_master_requests_clock_2_in;
  --clock_2_in_any_bursting_master_saved_grant mux, which is an e_mux
  clock_2_in_any_bursting_master_saved_grant <= std_logic'('0');
  --clock_2_in_arb_share_counter_next_value assignment, which is an e_assign
  clock_2_in_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(clock_2_in_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_2_in_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(clock_2_in_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_2_in_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --clock_2_in_allgrants all slave grants, which is an e_mux
  clock_2_in_allgrants <= clock_2_in_grant_vector;
  --clock_2_in_end_xfer assignment, which is an e_assign
  clock_2_in_end_xfer <= NOT ((clock_2_in_waits_for_read OR clock_2_in_waits_for_write));
  --end_xfer_arb_share_counter_term_clock_2_in arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_clock_2_in <= clock_2_in_end_xfer AND (((NOT clock_2_in_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --clock_2_in_arb_share_counter arbitration counter enable, which is an e_assign
  clock_2_in_arb_counter_enable <= ((end_xfer_arb_share_counter_term_clock_2_in AND clock_2_in_allgrants)) OR ((end_xfer_arb_share_counter_term_clock_2_in AND NOT clock_2_in_non_bursting_master_requests));
  --clock_2_in_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_2_in_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(clock_2_in_arb_counter_enable) = '1' then 
        clock_2_in_arb_share_counter <= clock_2_in_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_2_in_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_2_in_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clock_2_in_master_qreq_vector AND end_xfer_arb_share_counter_term_clock_2_in)) OR ((end_xfer_arb_share_counter_term_clock_2_in AND NOT clock_2_in_non_bursting_master_requests)))) = '1' then 
        clock_2_in_slavearbiterlockenable <= or_reduce(clock_2_in_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/instruction_master clock_2/in arbiterlock, which is an e_assign
  cpu_0_instruction_master_arbiterlock <= clock_2_in_slavearbiterlockenable AND cpu_0_instruction_master_continuerequest;
  --clock_2_in_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  clock_2_in_slavearbiterlockenable2 <= or_reduce(clock_2_in_arb_share_counter_next_value);
  --cpu_0/instruction_master clock_2/in arbiterlock2, which is an e_assign
  cpu_0_instruction_master_arbiterlock2 <= clock_2_in_slavearbiterlockenable2 AND cpu_0_instruction_master_continuerequest;
  --clock_2_in_any_continuerequest at least one master continues requesting, which is an e_assign
  clock_2_in_any_continuerequest <= std_logic'('1');
  --cpu_0_instruction_master_continuerequest continued request, which is an e_assign
  cpu_0_instruction_master_continuerequest <= std_logic'('1');
  internal_cpu_0_instruction_master_qualified_request_clock_2_in <= internal_cpu_0_instruction_master_requests_clock_2_in AND NOT ((cpu_0_instruction_master_read AND ((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000")))) OR (cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register)))));
  --local readdatavalid cpu_0_instruction_master_read_data_valid_clock_2_in, which is an e_mux
  cpu_0_instruction_master_read_data_valid_clock_2_in <= (internal_cpu_0_instruction_master_granted_clock_2_in AND cpu_0_instruction_master_read) AND NOT clock_2_in_waits_for_read;
  --assign clock_2_in_endofpacket_from_sa = clock_2_in_endofpacket so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_2_in_endofpacket_from_sa <= clock_2_in_endofpacket;
  --master is always granted when requested
  internal_cpu_0_instruction_master_granted_clock_2_in <= internal_cpu_0_instruction_master_qualified_request_clock_2_in;
  --cpu_0/instruction_master saved-grant clock_2/in, which is an e_assign
  cpu_0_instruction_master_saved_grant_clock_2_in <= internal_cpu_0_instruction_master_requests_clock_2_in;
  --allow new arb cycle for clock_2/in, which is an e_assign
  clock_2_in_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  clock_2_in_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  clock_2_in_master_qreq_vector <= std_logic'('1');
  --clock_2_in_reset_n assignment, which is an e_assign
  clock_2_in_reset_n <= reset_n;
  --clock_2_in_firsttransfer first transaction, which is an e_assign
  clock_2_in_firsttransfer <= A_WE_StdLogic((std_logic'(clock_2_in_begins_xfer) = '1'), clock_2_in_unreg_firsttransfer, clock_2_in_reg_firsttransfer);
  --clock_2_in_unreg_firsttransfer first transaction, which is an e_assign
  clock_2_in_unreg_firsttransfer <= NOT ((clock_2_in_slavearbiterlockenable AND clock_2_in_any_continuerequest));
  --clock_2_in_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_2_in_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(clock_2_in_begins_xfer) = '1' then 
        clock_2_in_reg_firsttransfer <= clock_2_in_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --clock_2_in_beginbursttransfer_internal begin burst transfer, which is an e_assign
  clock_2_in_beginbursttransfer_internal <= clock_2_in_begins_xfer;
  --clock_2_in_read assignment, which is an e_mux
  clock_2_in_read <= internal_cpu_0_instruction_master_granted_clock_2_in AND cpu_0_instruction_master_read;
  --clock_2_in_write assignment, which is an e_mux
  clock_2_in_write <= std_logic'('0');
  --clock_2_in_address mux, which is an e_mux
  clock_2_in_address <= cpu_0_instruction_master_address_to_slave (10 DOWNTO 0);
  --slaveid clock_2_in_nativeaddress nativeaddress mux, which is an e_mux
  clock_2_in_nativeaddress <= A_EXT (A_SRL(cpu_0_instruction_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")), 9);
  --d1_clock_2_in_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_clock_2_in_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_clock_2_in_end_xfer <= clock_2_in_end_xfer;
      end if;
    end if;

  end process;

  --clock_2_in_waits_for_read in a cycle, which is an e_mux
  clock_2_in_waits_for_read <= clock_2_in_in_a_read_cycle AND internal_clock_2_in_waitrequest_from_sa;
  --clock_2_in_in_a_read_cycle assignment, which is an e_assign
  clock_2_in_in_a_read_cycle <= internal_cpu_0_instruction_master_granted_clock_2_in AND cpu_0_instruction_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= clock_2_in_in_a_read_cycle;
  --clock_2_in_waits_for_write in a cycle, which is an e_mux
  clock_2_in_waits_for_write <= clock_2_in_in_a_write_cycle AND internal_clock_2_in_waitrequest_from_sa;
  --clock_2_in_in_a_write_cycle assignment, which is an e_assign
  clock_2_in_in_a_write_cycle <= std_logic'('0');
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= clock_2_in_in_a_write_cycle;
  wait_for_clock_2_in_counter <= std_logic'('0');
  --clock_2_in_byteenable byte enable port mux, which is an e_mux
  clock_2_in_byteenable <= A_EXT (-SIGNED(std_logic_vector'("00000000000000000000000000000001")), 4);
  --vhdl renameroo for output signals
  clock_2_in_waitrequest_from_sa <= internal_clock_2_in_waitrequest_from_sa;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_granted_clock_2_in <= internal_cpu_0_instruction_master_granted_clock_2_in;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_qualified_request_clock_2_in <= internal_cpu_0_instruction_master_qualified_request_clock_2_in;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_requests_clock_2_in <= internal_cpu_0_instruction_master_requests_clock_2_in;
--synthesis translate_off
    --clock_2/in enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity clock_2_out_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_2_out_address : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_2_out_granted_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_2_out_qualified_request_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_2_out_read : IN STD_LOGIC;
                 signal clock_2_out_read_data_valid_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_2_out_requests_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_2_out_write : IN STD_LOGIC;
                 signal clock_2_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_epcs_controller_epcs_control_port_end_xfer : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_endofpacket_from_sa : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_2_out_address_to_slave : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_2_out_endofpacket : OUT STD_LOGIC;
                 signal clock_2_out_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_2_out_reset_n : OUT STD_LOGIC;
                 signal clock_2_out_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_2_out_arbitrator : entity is FALSE;
end entity clock_2_out_arbitrator;


architecture europa of clock_2_out_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal clock_2_out_address_last_time :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_2_out_read_last_time :  STD_LOGIC;
                signal clock_2_out_run :  STD_LOGIC;
                signal clock_2_out_write_last_time :  STD_LOGIC;
                signal clock_2_out_writedata_last_time :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal internal_clock_2_out_address_to_slave :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal internal_clock_2_out_waitrequest :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;

begin

  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic(((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_2_out_qualified_request_epcs_controller_epcs_control_port OR NOT clock_2_out_requests_epcs_controller_epcs_control_port)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_2_out_granted_epcs_controller_epcs_control_port OR NOT clock_2_out_qualified_request_epcs_controller_epcs_control_port)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_2_out_qualified_request_epcs_controller_epcs_control_port OR NOT ((clock_2_out_read OR clock_2_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_epcs_controller_epcs_control_port_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_2_out_read OR clock_2_out_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_2_out_qualified_request_epcs_controller_epcs_control_port OR NOT ((clock_2_out_read OR clock_2_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_epcs_controller_epcs_control_port_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_2_out_read OR clock_2_out_write)))))))))));
  --cascaded wait assignment, which is an e_assign
  clock_2_out_run <= r_1;
  --optimize select-logic by passing only those address bits which matter.
  internal_clock_2_out_address_to_slave <= clock_2_out_address;
  --clock_2/out readdata mux, which is an e_mux
  clock_2_out_readdata <= epcs_controller_epcs_control_port_readdata_from_sa;
  --actual waitrequest port, which is an e_assign
  internal_clock_2_out_waitrequest <= NOT clock_2_out_run;
  --clock_2_out_reset_n assignment, which is an e_assign
  clock_2_out_reset_n <= reset_n;
  --mux clock_2_out_endofpacket, which is an e_mux
  clock_2_out_endofpacket <= epcs_controller_epcs_control_port_endofpacket_from_sa;
  --vhdl renameroo for output signals
  clock_2_out_address_to_slave <= internal_clock_2_out_address_to_slave;
  --vhdl renameroo for output signals
  clock_2_out_waitrequest <= internal_clock_2_out_waitrequest;
--synthesis translate_off
    --clock_2_out_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_2_out_address_last_time <= std_logic_vector'("00000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_2_out_address_last_time <= clock_2_out_address;
        end if;
      end if;

    end process;

    --clock_2/out waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_clock_2_out_waitrequest AND ((clock_2_out_read OR clock_2_out_write));
        end if;
      end if;

    end process;

    --clock_2_out_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_2_out_address, clock_2_out_address_last_time)
    VARIABLE write_line8 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((clock_2_out_address /= clock_2_out_address_last_time))))) = '1' then 
          write(write_line8, now);
          write(write_line8, string'(": "));
          write(write_line8, string'("clock_2_out_address did not heed wait!!!"));
          write(output, write_line8.all);
          deallocate (write_line8);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_2_out_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_2_out_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_2_out_read_last_time <= clock_2_out_read;
        end if;
      end if;

    end process;

    --clock_2_out_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_2_out_read, clock_2_out_read_last_time)
    VARIABLE write_line9 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_2_out_read) /= std_logic'(clock_2_out_read_last_time)))))) = '1' then 
          write(write_line9, now);
          write(write_line9, string'(": "));
          write(write_line9, string'("clock_2_out_read did not heed wait!!!"));
          write(output, write_line9.all);
          deallocate (write_line9);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_2_out_write check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_2_out_write_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_2_out_write_last_time <= clock_2_out_write;
        end if;
      end if;

    end process;

    --clock_2_out_write matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_2_out_write, clock_2_out_write_last_time)
    VARIABLE write_line10 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_2_out_write) /= std_logic'(clock_2_out_write_last_time)))))) = '1' then 
          write(write_line10, now);
          write(write_line10, string'(": "));
          write(write_line10, string'("clock_2_out_write did not heed wait!!!"));
          write(output, write_line10.all);
          deallocate (write_line10);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_2_out_writedata check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_2_out_writedata_last_time <= std_logic_vector'("00000000000000000000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_2_out_writedata_last_time <= clock_2_out_writedata;
        end if;
      end if;

    end process;

    --clock_2_out_writedata matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_2_out_write, clock_2_out_writedata, clock_2_out_writedata_last_time)
    VARIABLE write_line11 : line;
    begin
        if std_logic'(((active_and_waiting_last_time AND to_std_logic(((clock_2_out_writedata /= clock_2_out_writedata_last_time)))) AND clock_2_out_write)) = '1' then 
          write(write_line11, now);
          write(write_line11, string'(": "));
          write(write_line11, string'("clock_2_out_writedata did not heed wait!!!"));
          write(output, write_line11.all);
          deallocate (write_line11);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity clock_3_in_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_3_in_endofpacket : IN STD_LOGIC;
                 signal clock_3_in_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_3_in_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_3_in_address : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_3_in_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal clock_3_in_endofpacket_from_sa : OUT STD_LOGIC;
                 signal clock_3_in_nativeaddress : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal clock_3_in_read : OUT STD_LOGIC;
                 signal clock_3_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_3_in_reset_n : OUT STD_LOGIC;
                 signal clock_3_in_waitrequest_from_sa : OUT STD_LOGIC;
                 signal clock_3_in_write : OUT STD_LOGIC;
                 signal clock_3_in_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_data_master_granted_clock_3_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_3_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_3_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_3_in : OUT STD_LOGIC;
                 signal d1_clock_3_in_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_3_in_arbitrator : entity is FALSE;
end entity clock_3_in_arbitrator;


architecture europa of clock_3_in_arbitrator is
                signal clock_3_in_allgrants :  STD_LOGIC;
                signal clock_3_in_allow_new_arb_cycle :  STD_LOGIC;
                signal clock_3_in_any_bursting_master_saved_grant :  STD_LOGIC;
                signal clock_3_in_any_continuerequest :  STD_LOGIC;
                signal clock_3_in_arb_counter_enable :  STD_LOGIC;
                signal clock_3_in_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_3_in_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_3_in_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_3_in_beginbursttransfer_internal :  STD_LOGIC;
                signal clock_3_in_begins_xfer :  STD_LOGIC;
                signal clock_3_in_end_xfer :  STD_LOGIC;
                signal clock_3_in_firsttransfer :  STD_LOGIC;
                signal clock_3_in_grant_vector :  STD_LOGIC;
                signal clock_3_in_in_a_read_cycle :  STD_LOGIC;
                signal clock_3_in_in_a_write_cycle :  STD_LOGIC;
                signal clock_3_in_master_qreq_vector :  STD_LOGIC;
                signal clock_3_in_non_bursting_master_requests :  STD_LOGIC;
                signal clock_3_in_reg_firsttransfer :  STD_LOGIC;
                signal clock_3_in_slavearbiterlockenable :  STD_LOGIC;
                signal clock_3_in_slavearbiterlockenable2 :  STD_LOGIC;
                signal clock_3_in_unreg_firsttransfer :  STD_LOGIC;
                signal clock_3_in_waits_for_read :  STD_LOGIC;
                signal clock_3_in_waits_for_write :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_data_master_continuerequest :  STD_LOGIC;
                signal cpu_0_data_master_saved_grant_clock_3_in :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_clock_3_in :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_3_in_waitrequest_from_sa :  STD_LOGIC;
                signal internal_cpu_0_data_master_granted_clock_3_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_qualified_request_clock_3_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_requests_clock_3_in :  STD_LOGIC;
                signal wait_for_clock_3_in_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT clock_3_in_end_xfer;
      end if;
    end if;

  end process;

  clock_3_in_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_0_data_master_qualified_request_clock_3_in);
  --assign clock_3_in_readdata_from_sa = clock_3_in_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_3_in_readdata_from_sa <= clock_3_in_readdata;
  internal_cpu_0_data_master_requests_clock_3_in <= to_std_logic(((Std_Logic_Vector'(cpu_0_data_master_address_to_slave(24 DOWNTO 11) & std_logic_vector'("00000000000")) = std_logic_vector'("1000000000001100000000000")))) AND ((cpu_0_data_master_read OR cpu_0_data_master_write));
  --assign clock_3_in_waitrequest_from_sa = clock_3_in_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_clock_3_in_waitrequest_from_sa <= clock_3_in_waitrequest;
  --clock_3_in_arb_share_counter set values, which is an e_mux
  clock_3_in_arb_share_set_values <= std_logic_vector'("01");
  --clock_3_in_non_bursting_master_requests mux, which is an e_mux
  clock_3_in_non_bursting_master_requests <= internal_cpu_0_data_master_requests_clock_3_in;
  --clock_3_in_any_bursting_master_saved_grant mux, which is an e_mux
  clock_3_in_any_bursting_master_saved_grant <= std_logic'('0');
  --clock_3_in_arb_share_counter_next_value assignment, which is an e_assign
  clock_3_in_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(clock_3_in_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_3_in_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(clock_3_in_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_3_in_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --clock_3_in_allgrants all slave grants, which is an e_mux
  clock_3_in_allgrants <= clock_3_in_grant_vector;
  --clock_3_in_end_xfer assignment, which is an e_assign
  clock_3_in_end_xfer <= NOT ((clock_3_in_waits_for_read OR clock_3_in_waits_for_write));
  --end_xfer_arb_share_counter_term_clock_3_in arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_clock_3_in <= clock_3_in_end_xfer AND (((NOT clock_3_in_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --clock_3_in_arb_share_counter arbitration counter enable, which is an e_assign
  clock_3_in_arb_counter_enable <= ((end_xfer_arb_share_counter_term_clock_3_in AND clock_3_in_allgrants)) OR ((end_xfer_arb_share_counter_term_clock_3_in AND NOT clock_3_in_non_bursting_master_requests));
  --clock_3_in_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_3_in_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(clock_3_in_arb_counter_enable) = '1' then 
        clock_3_in_arb_share_counter <= clock_3_in_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_3_in_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_3_in_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clock_3_in_master_qreq_vector AND end_xfer_arb_share_counter_term_clock_3_in)) OR ((end_xfer_arb_share_counter_term_clock_3_in AND NOT clock_3_in_non_bursting_master_requests)))) = '1' then 
        clock_3_in_slavearbiterlockenable <= or_reduce(clock_3_in_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/data_master clock_3/in arbiterlock, which is an e_assign
  cpu_0_data_master_arbiterlock <= clock_3_in_slavearbiterlockenable AND cpu_0_data_master_continuerequest;
  --clock_3_in_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  clock_3_in_slavearbiterlockenable2 <= or_reduce(clock_3_in_arb_share_counter_next_value);
  --cpu_0/data_master clock_3/in arbiterlock2, which is an e_assign
  cpu_0_data_master_arbiterlock2 <= clock_3_in_slavearbiterlockenable2 AND cpu_0_data_master_continuerequest;
  --clock_3_in_any_continuerequest at least one master continues requesting, which is an e_assign
  clock_3_in_any_continuerequest <= std_logic'('1');
  --cpu_0_data_master_continuerequest continued request, which is an e_assign
  cpu_0_data_master_continuerequest <= std_logic'('1');
  internal_cpu_0_data_master_qualified_request_clock_3_in <= internal_cpu_0_data_master_requests_clock_3_in AND NOT ((((cpu_0_data_master_read AND (NOT cpu_0_data_master_waitrequest))) OR (((NOT cpu_0_data_master_waitrequest) AND cpu_0_data_master_write))));
  --clock_3_in_writedata mux, which is an e_mux
  clock_3_in_writedata <= cpu_0_data_master_writedata;
  --assign clock_3_in_endofpacket_from_sa = clock_3_in_endofpacket so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_3_in_endofpacket_from_sa <= clock_3_in_endofpacket;
  --master is always granted when requested
  internal_cpu_0_data_master_granted_clock_3_in <= internal_cpu_0_data_master_qualified_request_clock_3_in;
  --cpu_0/data_master saved-grant clock_3/in, which is an e_assign
  cpu_0_data_master_saved_grant_clock_3_in <= internal_cpu_0_data_master_requests_clock_3_in;
  --allow new arb cycle for clock_3/in, which is an e_assign
  clock_3_in_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  clock_3_in_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  clock_3_in_master_qreq_vector <= std_logic'('1');
  --clock_3_in_reset_n assignment, which is an e_assign
  clock_3_in_reset_n <= reset_n;
  --clock_3_in_firsttransfer first transaction, which is an e_assign
  clock_3_in_firsttransfer <= A_WE_StdLogic((std_logic'(clock_3_in_begins_xfer) = '1'), clock_3_in_unreg_firsttransfer, clock_3_in_reg_firsttransfer);
  --clock_3_in_unreg_firsttransfer first transaction, which is an e_assign
  clock_3_in_unreg_firsttransfer <= NOT ((clock_3_in_slavearbiterlockenable AND clock_3_in_any_continuerequest));
  --clock_3_in_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_3_in_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(clock_3_in_begins_xfer) = '1' then 
        clock_3_in_reg_firsttransfer <= clock_3_in_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --clock_3_in_beginbursttransfer_internal begin burst transfer, which is an e_assign
  clock_3_in_beginbursttransfer_internal <= clock_3_in_begins_xfer;
  --clock_3_in_read assignment, which is an e_mux
  clock_3_in_read <= internal_cpu_0_data_master_granted_clock_3_in AND cpu_0_data_master_read;
  --clock_3_in_write assignment, which is an e_mux
  clock_3_in_write <= internal_cpu_0_data_master_granted_clock_3_in AND cpu_0_data_master_write;
  --clock_3_in_address mux, which is an e_mux
  clock_3_in_address <= cpu_0_data_master_address_to_slave (10 DOWNTO 0);
  --slaveid clock_3_in_nativeaddress nativeaddress mux, which is an e_mux
  clock_3_in_nativeaddress <= A_EXT (A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")), 9);
  --d1_clock_3_in_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_clock_3_in_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_clock_3_in_end_xfer <= clock_3_in_end_xfer;
      end if;
    end if;

  end process;

  --clock_3_in_waits_for_read in a cycle, which is an e_mux
  clock_3_in_waits_for_read <= clock_3_in_in_a_read_cycle AND internal_clock_3_in_waitrequest_from_sa;
  --clock_3_in_in_a_read_cycle assignment, which is an e_assign
  clock_3_in_in_a_read_cycle <= internal_cpu_0_data_master_granted_clock_3_in AND cpu_0_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= clock_3_in_in_a_read_cycle;
  --clock_3_in_waits_for_write in a cycle, which is an e_mux
  clock_3_in_waits_for_write <= clock_3_in_in_a_write_cycle AND internal_clock_3_in_waitrequest_from_sa;
  --clock_3_in_in_a_write_cycle assignment, which is an e_assign
  clock_3_in_in_a_write_cycle <= internal_cpu_0_data_master_granted_clock_3_in AND cpu_0_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= clock_3_in_in_a_write_cycle;
  wait_for_clock_3_in_counter <= std_logic'('0');
  --clock_3_in_byteenable byte enable port mux, which is an e_mux
  clock_3_in_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_clock_3_in)) = '1'), (std_logic_vector'("0000000000000000000000000000") & (cpu_0_data_master_byteenable)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 4);
  --vhdl renameroo for output signals
  clock_3_in_waitrequest_from_sa <= internal_clock_3_in_waitrequest_from_sa;
  --vhdl renameroo for output signals
  cpu_0_data_master_granted_clock_3_in <= internal_cpu_0_data_master_granted_clock_3_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_qualified_request_clock_3_in <= internal_cpu_0_data_master_qualified_request_clock_3_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_requests_clock_3_in <= internal_cpu_0_data_master_requests_clock_3_in;
--synthesis translate_off
    --clock_3/in enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity clock_3_out_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_3_out_address : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_3_out_granted_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_3_out_qualified_request_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_3_out_read : IN STD_LOGIC;
                 signal clock_3_out_read_data_valid_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_3_out_requests_epcs_controller_epcs_control_port : IN STD_LOGIC;
                 signal clock_3_out_write : IN STD_LOGIC;
                 signal clock_3_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_epcs_controller_epcs_control_port_end_xfer : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_endofpacket_from_sa : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_3_out_address_to_slave : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_3_out_endofpacket : OUT STD_LOGIC;
                 signal clock_3_out_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_3_out_reset_n : OUT STD_LOGIC;
                 signal clock_3_out_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_3_out_arbitrator : entity is FALSE;
end entity clock_3_out_arbitrator;


architecture europa of clock_3_out_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal clock_3_out_address_last_time :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_3_out_read_last_time :  STD_LOGIC;
                signal clock_3_out_run :  STD_LOGIC;
                signal clock_3_out_write_last_time :  STD_LOGIC;
                signal clock_3_out_writedata_last_time :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal internal_clock_3_out_address_to_slave :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal internal_clock_3_out_waitrequest :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;

begin

  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic(((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_3_out_qualified_request_epcs_controller_epcs_control_port OR NOT clock_3_out_requests_epcs_controller_epcs_control_port)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_3_out_granted_epcs_controller_epcs_control_port OR NOT clock_3_out_qualified_request_epcs_controller_epcs_control_port)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_3_out_qualified_request_epcs_controller_epcs_control_port OR NOT ((clock_3_out_read OR clock_3_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_epcs_controller_epcs_control_port_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_3_out_read OR clock_3_out_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_3_out_qualified_request_epcs_controller_epcs_control_port OR NOT ((clock_3_out_read OR clock_3_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_epcs_controller_epcs_control_port_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_3_out_read OR clock_3_out_write)))))))))));
  --cascaded wait assignment, which is an e_assign
  clock_3_out_run <= r_1;
  --optimize select-logic by passing only those address bits which matter.
  internal_clock_3_out_address_to_slave <= clock_3_out_address;
  --clock_3/out readdata mux, which is an e_mux
  clock_3_out_readdata <= epcs_controller_epcs_control_port_readdata_from_sa;
  --actual waitrequest port, which is an e_assign
  internal_clock_3_out_waitrequest <= NOT clock_3_out_run;
  --clock_3_out_reset_n assignment, which is an e_assign
  clock_3_out_reset_n <= reset_n;
  --mux clock_3_out_endofpacket, which is an e_mux
  clock_3_out_endofpacket <= epcs_controller_epcs_control_port_endofpacket_from_sa;
  --vhdl renameroo for output signals
  clock_3_out_address_to_slave <= internal_clock_3_out_address_to_slave;
  --vhdl renameroo for output signals
  clock_3_out_waitrequest <= internal_clock_3_out_waitrequest;
--synthesis translate_off
    --clock_3_out_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_3_out_address_last_time <= std_logic_vector'("00000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_3_out_address_last_time <= clock_3_out_address;
        end if;
      end if;

    end process;

    --clock_3/out waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_clock_3_out_waitrequest AND ((clock_3_out_read OR clock_3_out_write));
        end if;
      end if;

    end process;

    --clock_3_out_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_3_out_address, clock_3_out_address_last_time)
    VARIABLE write_line12 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((clock_3_out_address /= clock_3_out_address_last_time))))) = '1' then 
          write(write_line12, now);
          write(write_line12, string'(": "));
          write(write_line12, string'("clock_3_out_address did not heed wait!!!"));
          write(output, write_line12.all);
          deallocate (write_line12);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_3_out_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_3_out_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_3_out_read_last_time <= clock_3_out_read;
        end if;
      end if;

    end process;

    --clock_3_out_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_3_out_read, clock_3_out_read_last_time)
    VARIABLE write_line13 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_3_out_read) /= std_logic'(clock_3_out_read_last_time)))))) = '1' then 
          write(write_line13, now);
          write(write_line13, string'(": "));
          write(write_line13, string'("clock_3_out_read did not heed wait!!!"));
          write(output, write_line13.all);
          deallocate (write_line13);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_3_out_write check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_3_out_write_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_3_out_write_last_time <= clock_3_out_write;
        end if;
      end if;

    end process;

    --clock_3_out_write matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_3_out_write, clock_3_out_write_last_time)
    VARIABLE write_line14 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_3_out_write) /= std_logic'(clock_3_out_write_last_time)))))) = '1' then 
          write(write_line14, now);
          write(write_line14, string'(": "));
          write(write_line14, string'("clock_3_out_write did not heed wait!!!"));
          write(output, write_line14.all);
          deallocate (write_line14);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_3_out_writedata check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_3_out_writedata_last_time <= std_logic_vector'("00000000000000000000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_3_out_writedata_last_time <= clock_3_out_writedata;
        end if;
      end if;

    end process;

    --clock_3_out_writedata matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_3_out_write, clock_3_out_writedata, clock_3_out_writedata_last_time)
    VARIABLE write_line15 : line;
    begin
        if std_logic'(((active_and_waiting_last_time AND to_std_logic(((clock_3_out_writedata /= clock_3_out_writedata_last_time)))) AND clock_3_out_write)) = '1' then 
          write(write_line15, now);
          write(write_line15, string'(": "));
          write(write_line15, string'("clock_3_out_writedata did not heed wait!!!"));
          write(output, write_line15.all);
          deallocate (write_line15);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity clock_4_in_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_4_in_endofpacket : IN STD_LOGIC;
                 signal clock_4_in_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_4_in_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_0_data_master_no_byte_enables_and_last_term : IN STD_LOGIC;
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_4_in_address : OUT STD_LOGIC_VECTOR (16 DOWNTO 0);
                 signal clock_4_in_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal clock_4_in_endofpacket_from_sa : OUT STD_LOGIC;
                 signal clock_4_in_nativeaddress : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_4_in_read : OUT STD_LOGIC;
                 signal clock_4_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_4_in_reset_n : OUT STD_LOGIC;
                 signal clock_4_in_waitrequest_from_sa : OUT STD_LOGIC;
                 signal clock_4_in_write : OUT STD_LOGIC;
                 signal clock_4_in_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_0_data_master_byteenable_clock_4_in : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_granted_clock_4_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_4_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_4_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_4_in : OUT STD_LOGIC;
                 signal d1_clock_4_in_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_4_in_arbitrator : entity is FALSE;
end entity clock_4_in_arbitrator;


architecture europa of clock_4_in_arbitrator is
                signal clock_4_in_allgrants :  STD_LOGIC;
                signal clock_4_in_allow_new_arb_cycle :  STD_LOGIC;
                signal clock_4_in_any_bursting_master_saved_grant :  STD_LOGIC;
                signal clock_4_in_any_continuerequest :  STD_LOGIC;
                signal clock_4_in_arb_counter_enable :  STD_LOGIC;
                signal clock_4_in_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_4_in_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_4_in_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_4_in_beginbursttransfer_internal :  STD_LOGIC;
                signal clock_4_in_begins_xfer :  STD_LOGIC;
                signal clock_4_in_end_xfer :  STD_LOGIC;
                signal clock_4_in_firsttransfer :  STD_LOGIC;
                signal clock_4_in_grant_vector :  STD_LOGIC;
                signal clock_4_in_in_a_read_cycle :  STD_LOGIC;
                signal clock_4_in_in_a_write_cycle :  STD_LOGIC;
                signal clock_4_in_master_qreq_vector :  STD_LOGIC;
                signal clock_4_in_non_bursting_master_requests :  STD_LOGIC;
                signal clock_4_in_reg_firsttransfer :  STD_LOGIC;
                signal clock_4_in_slavearbiterlockenable :  STD_LOGIC;
                signal clock_4_in_slavearbiterlockenable2 :  STD_LOGIC;
                signal clock_4_in_unreg_firsttransfer :  STD_LOGIC;
                signal clock_4_in_waits_for_read :  STD_LOGIC;
                signal clock_4_in_waits_for_write :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_data_master_byteenable_clock_4_in_segment_0 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_byteenable_clock_4_in_segment_1 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_continuerequest :  STD_LOGIC;
                signal cpu_0_data_master_saved_grant_clock_4_in :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_clock_4_in :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_4_in_waitrequest_from_sa :  STD_LOGIC;
                signal internal_cpu_0_data_master_byteenable_clock_4_in :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_0_data_master_granted_clock_4_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_qualified_request_clock_4_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_requests_clock_4_in :  STD_LOGIC;
                signal wait_for_clock_4_in_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT clock_4_in_end_xfer;
      end if;
    end if;

  end process;

  clock_4_in_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_0_data_master_qualified_request_clock_4_in);
  --assign clock_4_in_readdata_from_sa = clock_4_in_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_4_in_readdata_from_sa <= clock_4_in_readdata;
  internal_cpu_0_data_master_requests_clock_4_in <= to_std_logic(((Std_Logic_Vector'(cpu_0_data_master_address_to_slave(24 DOWNTO 17) & std_logic_vector'("00000000000000000")) = std_logic_vector'("0000000000000000000000000")))) AND ((cpu_0_data_master_read OR cpu_0_data_master_write));
  --assign clock_4_in_waitrequest_from_sa = clock_4_in_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_clock_4_in_waitrequest_from_sa <= clock_4_in_waitrequest;
  --clock_4_in_arb_share_counter set values, which is an e_mux
  clock_4_in_arb_share_set_values <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_clock_4_in)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000001")), 2);
  --clock_4_in_non_bursting_master_requests mux, which is an e_mux
  clock_4_in_non_bursting_master_requests <= internal_cpu_0_data_master_requests_clock_4_in;
  --clock_4_in_any_bursting_master_saved_grant mux, which is an e_mux
  clock_4_in_any_bursting_master_saved_grant <= std_logic'('0');
  --clock_4_in_arb_share_counter_next_value assignment, which is an e_assign
  clock_4_in_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(clock_4_in_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_4_in_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(clock_4_in_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_4_in_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --clock_4_in_allgrants all slave grants, which is an e_mux
  clock_4_in_allgrants <= clock_4_in_grant_vector;
  --clock_4_in_end_xfer assignment, which is an e_assign
  clock_4_in_end_xfer <= NOT ((clock_4_in_waits_for_read OR clock_4_in_waits_for_write));
  --end_xfer_arb_share_counter_term_clock_4_in arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_clock_4_in <= clock_4_in_end_xfer AND (((NOT clock_4_in_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --clock_4_in_arb_share_counter arbitration counter enable, which is an e_assign
  clock_4_in_arb_counter_enable <= ((end_xfer_arb_share_counter_term_clock_4_in AND clock_4_in_allgrants)) OR ((end_xfer_arb_share_counter_term_clock_4_in AND NOT clock_4_in_non_bursting_master_requests));
  --clock_4_in_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_4_in_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(clock_4_in_arb_counter_enable) = '1' then 
        clock_4_in_arb_share_counter <= clock_4_in_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_4_in_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_4_in_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clock_4_in_master_qreq_vector AND end_xfer_arb_share_counter_term_clock_4_in)) OR ((end_xfer_arb_share_counter_term_clock_4_in AND NOT clock_4_in_non_bursting_master_requests)))) = '1' then 
        clock_4_in_slavearbiterlockenable <= or_reduce(clock_4_in_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/data_master clock_4/in arbiterlock, which is an e_assign
  cpu_0_data_master_arbiterlock <= clock_4_in_slavearbiterlockenable AND cpu_0_data_master_continuerequest;
  --clock_4_in_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  clock_4_in_slavearbiterlockenable2 <= or_reduce(clock_4_in_arb_share_counter_next_value);
  --cpu_0/data_master clock_4/in arbiterlock2, which is an e_assign
  cpu_0_data_master_arbiterlock2 <= clock_4_in_slavearbiterlockenable2 AND cpu_0_data_master_continuerequest;
  --clock_4_in_any_continuerequest at least one master continues requesting, which is an e_assign
  clock_4_in_any_continuerequest <= std_logic'('1');
  --cpu_0_data_master_continuerequest continued request, which is an e_assign
  cpu_0_data_master_continuerequest <= std_logic'('1');
  internal_cpu_0_data_master_qualified_request_clock_4_in <= internal_cpu_0_data_master_requests_clock_4_in AND NOT ((((cpu_0_data_master_read AND (NOT cpu_0_data_master_waitrequest))) OR (((((NOT cpu_0_data_master_waitrequest OR cpu_0_data_master_no_byte_enables_and_last_term) OR NOT(or_reduce(internal_cpu_0_data_master_byteenable_clock_4_in)))) AND cpu_0_data_master_write))));
  --clock_4_in_writedata mux, which is an e_mux
  clock_4_in_writedata <= cpu_0_data_master_dbs_write_16;
  --assign clock_4_in_endofpacket_from_sa = clock_4_in_endofpacket so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_4_in_endofpacket_from_sa <= clock_4_in_endofpacket;
  --master is always granted when requested
  internal_cpu_0_data_master_granted_clock_4_in <= internal_cpu_0_data_master_qualified_request_clock_4_in;
  --cpu_0/data_master saved-grant clock_4/in, which is an e_assign
  cpu_0_data_master_saved_grant_clock_4_in <= internal_cpu_0_data_master_requests_clock_4_in;
  --allow new arb cycle for clock_4/in, which is an e_assign
  clock_4_in_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  clock_4_in_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  clock_4_in_master_qreq_vector <= std_logic'('1');
  --clock_4_in_reset_n assignment, which is an e_assign
  clock_4_in_reset_n <= reset_n;
  --clock_4_in_firsttransfer first transaction, which is an e_assign
  clock_4_in_firsttransfer <= A_WE_StdLogic((std_logic'(clock_4_in_begins_xfer) = '1'), clock_4_in_unreg_firsttransfer, clock_4_in_reg_firsttransfer);
  --clock_4_in_unreg_firsttransfer first transaction, which is an e_assign
  clock_4_in_unreg_firsttransfer <= NOT ((clock_4_in_slavearbiterlockenable AND clock_4_in_any_continuerequest));
  --clock_4_in_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_4_in_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(clock_4_in_begins_xfer) = '1' then 
        clock_4_in_reg_firsttransfer <= clock_4_in_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --clock_4_in_beginbursttransfer_internal begin burst transfer, which is an e_assign
  clock_4_in_beginbursttransfer_internal <= clock_4_in_begins_xfer;
  --clock_4_in_read assignment, which is an e_mux
  clock_4_in_read <= internal_cpu_0_data_master_granted_clock_4_in AND cpu_0_data_master_read;
  --clock_4_in_write assignment, which is an e_mux
  clock_4_in_write <= internal_cpu_0_data_master_granted_clock_4_in AND cpu_0_data_master_write;
  --clock_4_in_address mux, which is an e_mux
  clock_4_in_address <= A_EXT (Std_Logic_Vector'(A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")) & A_ToStdLogicVector(cpu_0_data_master_dbs_address(1)) & A_ToStdLogicVector(std_logic'('0'))), 17);
  --slaveid clock_4_in_nativeaddress nativeaddress mux, which is an e_mux
  clock_4_in_nativeaddress <= A_EXT (A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")), 16);
  --d1_clock_4_in_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_clock_4_in_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_clock_4_in_end_xfer <= clock_4_in_end_xfer;
      end if;
    end if;

  end process;

  --clock_4_in_waits_for_read in a cycle, which is an e_mux
  clock_4_in_waits_for_read <= clock_4_in_in_a_read_cycle AND internal_clock_4_in_waitrequest_from_sa;
  --clock_4_in_in_a_read_cycle assignment, which is an e_assign
  clock_4_in_in_a_read_cycle <= internal_cpu_0_data_master_granted_clock_4_in AND cpu_0_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= clock_4_in_in_a_read_cycle;
  --clock_4_in_waits_for_write in a cycle, which is an e_mux
  clock_4_in_waits_for_write <= clock_4_in_in_a_write_cycle AND internal_clock_4_in_waitrequest_from_sa;
  --clock_4_in_in_a_write_cycle assignment, which is an e_assign
  clock_4_in_in_a_write_cycle <= internal_cpu_0_data_master_granted_clock_4_in AND cpu_0_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= clock_4_in_in_a_write_cycle;
  wait_for_clock_4_in_counter <= std_logic'('0');
  --clock_4_in_byteenable byte enable port mux, which is an e_mux
  clock_4_in_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_clock_4_in)) = '1'), (std_logic_vector'("000000000000000000000000000000") & (internal_cpu_0_data_master_byteenable_clock_4_in)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 2);
  (cpu_0_data_master_byteenable_clock_4_in_segment_1(1), cpu_0_data_master_byteenable_clock_4_in_segment_1(0), cpu_0_data_master_byteenable_clock_4_in_segment_0(1), cpu_0_data_master_byteenable_clock_4_in_segment_0(0)) <= cpu_0_data_master_byteenable;
  internal_cpu_0_data_master_byteenable_clock_4_in <= A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_dbs_address(1)))) = std_logic_vector'("00000000000000000000000000000000"))), cpu_0_data_master_byteenable_clock_4_in_segment_0, cpu_0_data_master_byteenable_clock_4_in_segment_1);
  --vhdl renameroo for output signals
  clock_4_in_waitrequest_from_sa <= internal_clock_4_in_waitrequest_from_sa;
  --vhdl renameroo for output signals
  cpu_0_data_master_byteenable_clock_4_in <= internal_cpu_0_data_master_byteenable_clock_4_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_granted_clock_4_in <= internal_cpu_0_data_master_granted_clock_4_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_qualified_request_clock_4_in <= internal_cpu_0_data_master_qualified_request_clock_4_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_requests_clock_4_in <= internal_cpu_0_data_master_requests_clock_4_in;
--synthesis translate_off
    --clock_4/in enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity clock_4_out_arbitrator is 
        port (
              -- inputs:
                 signal arbitrator_inst_avalon_slave_0_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal arbitrator_inst_avalon_slave_0_waitrequest_from_sa : IN STD_LOGIC;
                 signal clk : IN STD_LOGIC;
                 signal clock_4_out_address : IN STD_LOGIC_VECTOR (16 DOWNTO 0);
                 signal clock_4_out_granted_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_4_out_read : IN STD_LOGIC;
                 signal clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_4_out_requests_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_4_out_write : IN STD_LOGIC;
                 signal clock_4_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal d1_arbitrator_inst_avalon_slave_0_end_xfer : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_4_out_address_to_slave : OUT STD_LOGIC_VECTOR (16 DOWNTO 0);
                 signal clock_4_out_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_4_out_reset_n : OUT STD_LOGIC;
                 signal clock_4_out_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_4_out_arbitrator : entity is FALSE;
end entity clock_4_out_arbitrator;


architecture europa of clock_4_out_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal clock_4_out_address_last_time :  STD_LOGIC_VECTOR (16 DOWNTO 0);
                signal clock_4_out_read_last_time :  STD_LOGIC;
                signal clock_4_out_run :  STD_LOGIC;
                signal clock_4_out_write_last_time :  STD_LOGIC;
                signal clock_4_out_writedata_last_time :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_clock_4_out_address_to_slave :  STD_LOGIC_VECTOR (16 DOWNTO 0);
                signal internal_clock_4_out_waitrequest :  STD_LOGIC;
                signal r_0 :  STD_LOGIC;

begin

  --r_0 master_run cascaded wait assignment, which is an e_assign
  r_0 <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001") AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 OR NOT ((clock_4_out_read OR clock_4_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT arbitrator_inst_avalon_slave_0_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_4_out_read OR clock_4_out_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 OR NOT ((clock_4_out_read OR clock_4_out_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT arbitrator_inst_avalon_slave_0_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_4_out_read OR clock_4_out_write)))))))))));
  --cascaded wait assignment, which is an e_assign
  clock_4_out_run <= r_0;
  --optimize select-logic by passing only those address bits which matter.
  internal_clock_4_out_address_to_slave <= clock_4_out_address;
  --clock_4/out readdata mux, which is an e_mux
  clock_4_out_readdata <= arbitrator_inst_avalon_slave_0_readdata_from_sa;
  --actual waitrequest port, which is an e_assign
  internal_clock_4_out_waitrequest <= NOT clock_4_out_run;
  --clock_4_out_reset_n assignment, which is an e_assign
  clock_4_out_reset_n <= reset_n;
  --vhdl renameroo for output signals
  clock_4_out_address_to_slave <= internal_clock_4_out_address_to_slave;
  --vhdl renameroo for output signals
  clock_4_out_waitrequest <= internal_clock_4_out_waitrequest;
--synthesis translate_off
    --clock_4_out_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_4_out_address_last_time <= std_logic_vector'("00000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_4_out_address_last_time <= clock_4_out_address;
        end if;
      end if;

    end process;

    --clock_4/out waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_clock_4_out_waitrequest AND ((clock_4_out_read OR clock_4_out_write));
        end if;
      end if;

    end process;

    --clock_4_out_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_4_out_address, clock_4_out_address_last_time)
    VARIABLE write_line16 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((clock_4_out_address /= clock_4_out_address_last_time))))) = '1' then 
          write(write_line16, now);
          write(write_line16, string'(": "));
          write(write_line16, string'("clock_4_out_address did not heed wait!!!"));
          write(output, write_line16.all);
          deallocate (write_line16);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_4_out_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_4_out_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_4_out_read_last_time <= clock_4_out_read;
        end if;
      end if;

    end process;

    --clock_4_out_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_4_out_read, clock_4_out_read_last_time)
    VARIABLE write_line17 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_4_out_read) /= std_logic'(clock_4_out_read_last_time)))))) = '1' then 
          write(write_line17, now);
          write(write_line17, string'(": "));
          write(write_line17, string'("clock_4_out_read did not heed wait!!!"));
          write(output, write_line17.all);
          deallocate (write_line17);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_4_out_write check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_4_out_write_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_4_out_write_last_time <= clock_4_out_write;
        end if;
      end if;

    end process;

    --clock_4_out_write matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_4_out_write, clock_4_out_write_last_time)
    VARIABLE write_line18 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_4_out_write) /= std_logic'(clock_4_out_write_last_time)))))) = '1' then 
          write(write_line18, now);
          write(write_line18, string'(": "));
          write(write_line18, string'("clock_4_out_write did not heed wait!!!"));
          write(output, write_line18.all);
          deallocate (write_line18);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_4_out_writedata check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_4_out_writedata_last_time <= std_logic_vector'("0000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_4_out_writedata_last_time <= clock_4_out_writedata;
        end if;
      end if;

    end process;

    --clock_4_out_writedata matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_4_out_write, clock_4_out_writedata, clock_4_out_writedata_last_time)
    VARIABLE write_line19 : line;
    begin
        if std_logic'(((active_and_waiting_last_time AND to_std_logic(((clock_4_out_writedata /= clock_4_out_writedata_last_time)))) AND clock_4_out_write)) = '1' then 
          write(write_line19, now);
          write(write_line19, string'(": "));
          write(write_line19, string'("clock_4_out_writedata did not heed wait!!!"));
          write(output, write_line19.all);
          deallocate (write_line19);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity clock_5_in_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_5_in_endofpacket : IN STD_LOGIC;
                 signal clock_5_in_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_5_in_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_0_data_master_no_byte_enables_and_last_term : IN STD_LOGIC;
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_5_in_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal clock_5_in_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal clock_5_in_endofpacket_from_sa : OUT STD_LOGIC;
                 signal clock_5_in_nativeaddress : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal clock_5_in_read : OUT STD_LOGIC;
                 signal clock_5_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_5_in_reset_n : OUT STD_LOGIC;
                 signal clock_5_in_waitrequest_from_sa : OUT STD_LOGIC;
                 signal clock_5_in_write : OUT STD_LOGIC;
                 signal clock_5_in_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_0_data_master_byteenable_clock_5_in : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_granted_clock_5_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_5_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_5_in : OUT STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_5_in : OUT STD_LOGIC;
                 signal d1_clock_5_in_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_5_in_arbitrator : entity is FALSE;
end entity clock_5_in_arbitrator;


architecture europa of clock_5_in_arbitrator is
                signal clock_5_in_allgrants :  STD_LOGIC;
                signal clock_5_in_allow_new_arb_cycle :  STD_LOGIC;
                signal clock_5_in_any_bursting_master_saved_grant :  STD_LOGIC;
                signal clock_5_in_any_continuerequest :  STD_LOGIC;
                signal clock_5_in_arb_counter_enable :  STD_LOGIC;
                signal clock_5_in_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_5_in_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_5_in_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_5_in_beginbursttransfer_internal :  STD_LOGIC;
                signal clock_5_in_begins_xfer :  STD_LOGIC;
                signal clock_5_in_end_xfer :  STD_LOGIC;
                signal clock_5_in_firsttransfer :  STD_LOGIC;
                signal clock_5_in_grant_vector :  STD_LOGIC;
                signal clock_5_in_in_a_read_cycle :  STD_LOGIC;
                signal clock_5_in_in_a_write_cycle :  STD_LOGIC;
                signal clock_5_in_master_qreq_vector :  STD_LOGIC;
                signal clock_5_in_non_bursting_master_requests :  STD_LOGIC;
                signal clock_5_in_reg_firsttransfer :  STD_LOGIC;
                signal clock_5_in_slavearbiterlockenable :  STD_LOGIC;
                signal clock_5_in_slavearbiterlockenable2 :  STD_LOGIC;
                signal clock_5_in_unreg_firsttransfer :  STD_LOGIC;
                signal clock_5_in_waits_for_read :  STD_LOGIC;
                signal clock_5_in_waits_for_write :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_data_master_byteenable_clock_5_in_segment_0 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_byteenable_clock_5_in_segment_1 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_continuerequest :  STD_LOGIC;
                signal cpu_0_data_master_saved_grant_clock_5_in :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_clock_5_in :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_5_in_waitrequest_from_sa :  STD_LOGIC;
                signal internal_cpu_0_data_master_byteenable_clock_5_in :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_0_data_master_granted_clock_5_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_qualified_request_clock_5_in :  STD_LOGIC;
                signal internal_cpu_0_data_master_requests_clock_5_in :  STD_LOGIC;
                signal wait_for_clock_5_in_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT clock_5_in_end_xfer;
      end if;
    end if;

  end process;

  clock_5_in_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_0_data_master_qualified_request_clock_5_in);
  --assign clock_5_in_readdata_from_sa = clock_5_in_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_5_in_readdata_from_sa <= clock_5_in_readdata;
  internal_cpu_0_data_master_requests_clock_5_in <= to_std_logic(((Std_Logic_Vector'(cpu_0_data_master_address_to_slave(24 DOWNTO 9) & std_logic_vector'("000000000")) = std_logic_vector'("0000000100000000000000000")))) AND ((cpu_0_data_master_read OR cpu_0_data_master_write));
  --assign clock_5_in_waitrequest_from_sa = clock_5_in_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_clock_5_in_waitrequest_from_sa <= clock_5_in_waitrequest;
  --clock_5_in_arb_share_counter set values, which is an e_mux
  clock_5_in_arb_share_set_values <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_clock_5_in)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000001")), 2);
  --clock_5_in_non_bursting_master_requests mux, which is an e_mux
  clock_5_in_non_bursting_master_requests <= internal_cpu_0_data_master_requests_clock_5_in;
  --clock_5_in_any_bursting_master_saved_grant mux, which is an e_mux
  clock_5_in_any_bursting_master_saved_grant <= std_logic'('0');
  --clock_5_in_arb_share_counter_next_value assignment, which is an e_assign
  clock_5_in_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(clock_5_in_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_5_in_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(clock_5_in_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (clock_5_in_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --clock_5_in_allgrants all slave grants, which is an e_mux
  clock_5_in_allgrants <= clock_5_in_grant_vector;
  --clock_5_in_end_xfer assignment, which is an e_assign
  clock_5_in_end_xfer <= NOT ((clock_5_in_waits_for_read OR clock_5_in_waits_for_write));
  --end_xfer_arb_share_counter_term_clock_5_in arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_clock_5_in <= clock_5_in_end_xfer AND (((NOT clock_5_in_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --clock_5_in_arb_share_counter arbitration counter enable, which is an e_assign
  clock_5_in_arb_counter_enable <= ((end_xfer_arb_share_counter_term_clock_5_in AND clock_5_in_allgrants)) OR ((end_xfer_arb_share_counter_term_clock_5_in AND NOT clock_5_in_non_bursting_master_requests));
  --clock_5_in_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_5_in_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(clock_5_in_arb_counter_enable) = '1' then 
        clock_5_in_arb_share_counter <= clock_5_in_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_5_in_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_5_in_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clock_5_in_master_qreq_vector AND end_xfer_arb_share_counter_term_clock_5_in)) OR ((end_xfer_arb_share_counter_term_clock_5_in AND NOT clock_5_in_non_bursting_master_requests)))) = '1' then 
        clock_5_in_slavearbiterlockenable <= or_reduce(clock_5_in_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/data_master clock_5/in arbiterlock, which is an e_assign
  cpu_0_data_master_arbiterlock <= clock_5_in_slavearbiterlockenable AND cpu_0_data_master_continuerequest;
  --clock_5_in_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  clock_5_in_slavearbiterlockenable2 <= or_reduce(clock_5_in_arb_share_counter_next_value);
  --cpu_0/data_master clock_5/in arbiterlock2, which is an e_assign
  cpu_0_data_master_arbiterlock2 <= clock_5_in_slavearbiterlockenable2 AND cpu_0_data_master_continuerequest;
  --clock_5_in_any_continuerequest at least one master continues requesting, which is an e_assign
  clock_5_in_any_continuerequest <= std_logic'('1');
  --cpu_0_data_master_continuerequest continued request, which is an e_assign
  cpu_0_data_master_continuerequest <= std_logic'('1');
  internal_cpu_0_data_master_qualified_request_clock_5_in <= internal_cpu_0_data_master_requests_clock_5_in AND NOT ((((cpu_0_data_master_read AND (NOT cpu_0_data_master_waitrequest))) OR (((((NOT cpu_0_data_master_waitrequest OR cpu_0_data_master_no_byte_enables_and_last_term) OR NOT(or_reduce(internal_cpu_0_data_master_byteenable_clock_5_in)))) AND cpu_0_data_master_write))));
  --clock_5_in_writedata mux, which is an e_mux
  clock_5_in_writedata <= cpu_0_data_master_dbs_write_16;
  --assign clock_5_in_endofpacket_from_sa = clock_5_in_endofpacket so that symbol knows where to group signals which may go to master only, which is an e_assign
  clock_5_in_endofpacket_from_sa <= clock_5_in_endofpacket;
  --master is always granted when requested
  internal_cpu_0_data_master_granted_clock_5_in <= internal_cpu_0_data_master_qualified_request_clock_5_in;
  --cpu_0/data_master saved-grant clock_5/in, which is an e_assign
  cpu_0_data_master_saved_grant_clock_5_in <= internal_cpu_0_data_master_requests_clock_5_in;
  --allow new arb cycle for clock_5/in, which is an e_assign
  clock_5_in_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  clock_5_in_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  clock_5_in_master_qreq_vector <= std_logic'('1');
  --clock_5_in_reset_n assignment, which is an e_assign
  clock_5_in_reset_n <= reset_n;
  --clock_5_in_firsttransfer first transaction, which is an e_assign
  clock_5_in_firsttransfer <= A_WE_StdLogic((std_logic'(clock_5_in_begins_xfer) = '1'), clock_5_in_unreg_firsttransfer, clock_5_in_reg_firsttransfer);
  --clock_5_in_unreg_firsttransfer first transaction, which is an e_assign
  clock_5_in_unreg_firsttransfer <= NOT ((clock_5_in_slavearbiterlockenable AND clock_5_in_any_continuerequest));
  --clock_5_in_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      clock_5_in_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(clock_5_in_begins_xfer) = '1' then 
        clock_5_in_reg_firsttransfer <= clock_5_in_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --clock_5_in_beginbursttransfer_internal begin burst transfer, which is an e_assign
  clock_5_in_beginbursttransfer_internal <= clock_5_in_begins_xfer;
  --clock_5_in_read assignment, which is an e_mux
  clock_5_in_read <= internal_cpu_0_data_master_granted_clock_5_in AND cpu_0_data_master_read;
  --clock_5_in_write assignment, which is an e_mux
  clock_5_in_write <= internal_cpu_0_data_master_granted_clock_5_in AND cpu_0_data_master_write;
  --clock_5_in_address mux, which is an e_mux
  clock_5_in_address <= A_EXT (Std_Logic_Vector'(A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")) & A_ToStdLogicVector(cpu_0_data_master_dbs_address(1)) & A_ToStdLogicVector(std_logic'('0'))), 9);
  --slaveid clock_5_in_nativeaddress nativeaddress mux, which is an e_mux
  clock_5_in_nativeaddress <= A_EXT (A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")), 8);
  --d1_clock_5_in_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_clock_5_in_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_clock_5_in_end_xfer <= clock_5_in_end_xfer;
      end if;
    end if;

  end process;

  --clock_5_in_waits_for_read in a cycle, which is an e_mux
  clock_5_in_waits_for_read <= clock_5_in_in_a_read_cycle AND internal_clock_5_in_waitrequest_from_sa;
  --clock_5_in_in_a_read_cycle assignment, which is an e_assign
  clock_5_in_in_a_read_cycle <= internal_cpu_0_data_master_granted_clock_5_in AND cpu_0_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= clock_5_in_in_a_read_cycle;
  --clock_5_in_waits_for_write in a cycle, which is an e_mux
  clock_5_in_waits_for_write <= clock_5_in_in_a_write_cycle AND internal_clock_5_in_waitrequest_from_sa;
  --clock_5_in_in_a_write_cycle assignment, which is an e_assign
  clock_5_in_in_a_write_cycle <= internal_cpu_0_data_master_granted_clock_5_in AND cpu_0_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= clock_5_in_in_a_write_cycle;
  wait_for_clock_5_in_counter <= std_logic'('0');
  --clock_5_in_byteenable byte enable port mux, which is an e_mux
  clock_5_in_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_clock_5_in)) = '1'), (std_logic_vector'("000000000000000000000000000000") & (internal_cpu_0_data_master_byteenable_clock_5_in)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 2);
  (cpu_0_data_master_byteenable_clock_5_in_segment_1(1), cpu_0_data_master_byteenable_clock_5_in_segment_1(0), cpu_0_data_master_byteenable_clock_5_in_segment_0(1), cpu_0_data_master_byteenable_clock_5_in_segment_0(0)) <= cpu_0_data_master_byteenable;
  internal_cpu_0_data_master_byteenable_clock_5_in <= A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_dbs_address(1)))) = std_logic_vector'("00000000000000000000000000000000"))), cpu_0_data_master_byteenable_clock_5_in_segment_0, cpu_0_data_master_byteenable_clock_5_in_segment_1);
  --vhdl renameroo for output signals
  clock_5_in_waitrequest_from_sa <= internal_clock_5_in_waitrequest_from_sa;
  --vhdl renameroo for output signals
  cpu_0_data_master_byteenable_clock_5_in <= internal_cpu_0_data_master_byteenable_clock_5_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_granted_clock_5_in <= internal_cpu_0_data_master_granted_clock_5_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_qualified_request_clock_5_in <= internal_cpu_0_data_master_qualified_request_clock_5_in;
  --vhdl renameroo for output signals
  cpu_0_data_master_requests_clock_5_in <= internal_cpu_0_data_master_requests_clock_5_in;
--synthesis translate_off
    --clock_5/in enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity clock_5_out_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_5_out_address : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal clock_5_out_granted_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_5_out_read : IN STD_LOGIC;
                 signal clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_5_out_requests_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                 signal clock_5_out_write : IN STD_LOGIC;
                 signal clock_5_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal d1_linebuffer_inst_avalon_slave_0_end_xfer : IN STD_LOGIC;
                 signal linebuffer_inst_avalon_slave_0_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_5_out_address_to_slave : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal clock_5_out_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_5_out_reset_n : OUT STD_LOGIC;
                 signal clock_5_out_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of clock_5_out_arbitrator : entity is FALSE;
end entity clock_5_out_arbitrator;


architecture europa of clock_5_out_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal clock_5_out_address_last_time :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_5_out_read_last_time :  STD_LOGIC;
                signal clock_5_out_run :  STD_LOGIC;
                signal clock_5_out_write_last_time :  STD_LOGIC;
                signal clock_5_out_writedata_last_time :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_clock_5_out_address_to_slave :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal internal_clock_5_out_waitrequest :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;

begin

  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001") AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 OR NOT clock_5_out_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_linebuffer_inst_avalon_slave_0_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(clock_5_out_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 OR NOT clock_5_out_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(clock_5_out_write)))))))));
  --cascaded wait assignment, which is an e_assign
  clock_5_out_run <= r_1;
  --optimize select-logic by passing only those address bits which matter.
  internal_clock_5_out_address_to_slave <= clock_5_out_address;
  --clock_5/out readdata mux, which is an e_mux
  clock_5_out_readdata <= linebuffer_inst_avalon_slave_0_readdata_from_sa;
  --actual waitrequest port, which is an e_assign
  internal_clock_5_out_waitrequest <= NOT clock_5_out_run;
  --clock_5_out_reset_n assignment, which is an e_assign
  clock_5_out_reset_n <= reset_n;
  --vhdl renameroo for output signals
  clock_5_out_address_to_slave <= internal_clock_5_out_address_to_slave;
  --vhdl renameroo for output signals
  clock_5_out_waitrequest <= internal_clock_5_out_waitrequest;
--synthesis translate_off
    --clock_5_out_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_5_out_address_last_time <= std_logic_vector'("000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_5_out_address_last_time <= clock_5_out_address;
        end if;
      end if;

    end process;

    --clock_5/out waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_clock_5_out_waitrequest AND ((clock_5_out_read OR clock_5_out_write));
        end if;
      end if;

    end process;

    --clock_5_out_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_5_out_address, clock_5_out_address_last_time)
    VARIABLE write_line20 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((clock_5_out_address /= clock_5_out_address_last_time))))) = '1' then 
          write(write_line20, now);
          write(write_line20, string'(": "));
          write(write_line20, string'("clock_5_out_address did not heed wait!!!"));
          write(output, write_line20.all);
          deallocate (write_line20);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_5_out_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_5_out_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_5_out_read_last_time <= clock_5_out_read;
        end if;
      end if;

    end process;

    --clock_5_out_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_5_out_read, clock_5_out_read_last_time)
    VARIABLE write_line21 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_5_out_read) /= std_logic'(clock_5_out_read_last_time)))))) = '1' then 
          write(write_line21, now);
          write(write_line21, string'(": "));
          write(write_line21, string'("clock_5_out_read did not heed wait!!!"));
          write(output, write_line21.all);
          deallocate (write_line21);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_5_out_write check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_5_out_write_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_5_out_write_last_time <= clock_5_out_write;
        end if;
      end if;

    end process;

    --clock_5_out_write matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_5_out_write, clock_5_out_write_last_time)
    VARIABLE write_line22 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(clock_5_out_write) /= std_logic'(clock_5_out_write_last_time)))))) = '1' then 
          write(write_line22, now);
          write(write_line22, string'(": "));
          write(write_line22, string'("clock_5_out_write did not heed wait!!!"));
          write(output, write_line22.all);
          deallocate (write_line22);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --clock_5_out_writedata check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        clock_5_out_writedata_last_time <= std_logic_vector'("0000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          clock_5_out_writedata_last_time <= clock_5_out_writedata;
        end if;
      end if;

    end process;

    --clock_5_out_writedata matches last port_name, which is an e_process
    process (active_and_waiting_last_time, clock_5_out_write, clock_5_out_writedata, clock_5_out_writedata_last_time)
    VARIABLE write_line23 : line;
    begin
        if std_logic'(((active_and_waiting_last_time AND to_std_logic(((clock_5_out_writedata /= clock_5_out_writedata_last_time)))) AND clock_5_out_write)) = '1' then 
          write(write_line23, now);
          write(write_line23, string'(": "));
          write(write_line23, string'("clock_5_out_writedata did not heed wait!!!"));
          write(output, write_line23.all);
          deallocate (write_line23);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity cpu_0_jtag_debug_module_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_data_master_debugaccess : IN STD_LOGIC;
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_instruction_master_latency_counter : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                 signal cpu_0_jtag_debug_module_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_jtag_debug_module_resetrequest : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_0_data_master_granted_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_data_master_requests_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_granted_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_requests_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal cpu_0_jtag_debug_module_begintransfer : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_jtag_debug_module_chipselect : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_debugaccess : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_jtag_debug_module_reset : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_reset_n : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_resetrequest_from_sa : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_write : OUT STD_LOGIC;
                 signal cpu_0_jtag_debug_module_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_cpu_0_jtag_debug_module_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of cpu_0_jtag_debug_module_arbitrator : entity is FALSE;
end entity cpu_0_jtag_debug_module_arbitrator;


architecture europa of cpu_0_jtag_debug_module_arbitrator is
                signal cpu_0_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_data_master_continuerequest :  STD_LOGIC;
                signal cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_instruction_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_instruction_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_instruction_master_continuerequest :  STD_LOGIC;
                signal cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_allgrants :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_allow_new_arb_cycle :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_any_bursting_master_saved_grant :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_any_continuerequest :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_arb_addend :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_arb_counter_enable :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_arb_winner :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_arbitration_holdoff_internal :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_beginbursttransfer_internal :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_begins_xfer :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_chosen_master_double_vector :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal cpu_0_jtag_debug_module_chosen_master_rot_left :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_end_xfer :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_firsttransfer :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_grant_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_in_a_read_cycle :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_in_a_write_cycle :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_master_qreq_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_non_bursting_master_requests :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_reg_firsttransfer :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_saved_chosen_master_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_jtag_debug_module_slavearbiterlockenable :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_slavearbiterlockenable2 :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_unreg_firsttransfer :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_waits_for_read :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_waits_for_write :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_granted_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_0_jtag_debug_module_reset_n :  STD_LOGIC;
                signal last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_data_master :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_instruction_master :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal wait_for_cpu_0_jtag_debug_module_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT cpu_0_jtag_debug_module_end_xfer;
      end if;
    end if;

  end process;

  cpu_0_jtag_debug_module_begins_xfer <= NOT d1_reasons_to_wait AND ((internal_cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module OR internal_cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module));
  --assign cpu_0_jtag_debug_module_readdata_from_sa = cpu_0_jtag_debug_module_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  cpu_0_jtag_debug_module_readdata_from_sa <= cpu_0_jtag_debug_module_readdata;
  internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module <= to_std_logic(((Std_Logic_Vector'(cpu_0_data_master_address_to_slave(24 DOWNTO 11) & std_logic_vector'("00000000000")) = std_logic_vector'("1000000000001000000000000")))) AND ((cpu_0_data_master_read OR cpu_0_data_master_write));
  --cpu_0_jtag_debug_module_arb_share_counter set values, which is an e_mux
  cpu_0_jtag_debug_module_arb_share_set_values <= std_logic_vector'("01");
  --cpu_0_jtag_debug_module_non_bursting_master_requests mux, which is an e_mux
  cpu_0_jtag_debug_module_non_bursting_master_requests <= ((internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module OR internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module) OR internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module) OR internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  --cpu_0_jtag_debug_module_any_bursting_master_saved_grant mux, which is an e_mux
  cpu_0_jtag_debug_module_any_bursting_master_saved_grant <= std_logic'('0');
  --cpu_0_jtag_debug_module_arb_share_counter_next_value assignment, which is an e_assign
  cpu_0_jtag_debug_module_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(cpu_0_jtag_debug_module_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (cpu_0_jtag_debug_module_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(cpu_0_jtag_debug_module_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (cpu_0_jtag_debug_module_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --cpu_0_jtag_debug_module_allgrants all slave grants, which is an e_mux
  cpu_0_jtag_debug_module_allgrants <= ((or_reduce(cpu_0_jtag_debug_module_grant_vector) OR or_reduce(cpu_0_jtag_debug_module_grant_vector)) OR or_reduce(cpu_0_jtag_debug_module_grant_vector)) OR or_reduce(cpu_0_jtag_debug_module_grant_vector);
  --cpu_0_jtag_debug_module_end_xfer assignment, which is an e_assign
  cpu_0_jtag_debug_module_end_xfer <= NOT ((cpu_0_jtag_debug_module_waits_for_read OR cpu_0_jtag_debug_module_waits_for_write));
  --end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module <= cpu_0_jtag_debug_module_end_xfer AND (((NOT cpu_0_jtag_debug_module_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --cpu_0_jtag_debug_module_arb_share_counter arbitration counter enable, which is an e_assign
  cpu_0_jtag_debug_module_arb_counter_enable <= ((end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module AND cpu_0_jtag_debug_module_allgrants)) OR ((end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module AND NOT cpu_0_jtag_debug_module_non_bursting_master_requests));
  --cpu_0_jtag_debug_module_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_0_jtag_debug_module_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(cpu_0_jtag_debug_module_arb_counter_enable) = '1' then 
        cpu_0_jtag_debug_module_arb_share_counter <= cpu_0_jtag_debug_module_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --cpu_0_jtag_debug_module_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_0_jtag_debug_module_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((or_reduce(cpu_0_jtag_debug_module_master_qreq_vector) AND end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module)) OR ((end_xfer_arb_share_counter_term_cpu_0_jtag_debug_module AND NOT cpu_0_jtag_debug_module_non_bursting_master_requests)))) = '1' then 
        cpu_0_jtag_debug_module_slavearbiterlockenable <= or_reduce(cpu_0_jtag_debug_module_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/data_master cpu_0/jtag_debug_module arbiterlock, which is an e_assign
  cpu_0_data_master_arbiterlock <= cpu_0_jtag_debug_module_slavearbiterlockenable AND cpu_0_data_master_continuerequest;
  --cpu_0_jtag_debug_module_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  cpu_0_jtag_debug_module_slavearbiterlockenable2 <= or_reduce(cpu_0_jtag_debug_module_arb_share_counter_next_value);
  --cpu_0/data_master cpu_0/jtag_debug_module arbiterlock2, which is an e_assign
  cpu_0_data_master_arbiterlock2 <= cpu_0_jtag_debug_module_slavearbiterlockenable2 AND cpu_0_data_master_continuerequest;
  --cpu_0/instruction_master cpu_0/jtag_debug_module arbiterlock, which is an e_assign
  cpu_0_instruction_master_arbiterlock <= cpu_0_jtag_debug_module_slavearbiterlockenable AND cpu_0_instruction_master_continuerequest;
  --cpu_0/instruction_master cpu_0/jtag_debug_module arbiterlock2, which is an e_assign
  cpu_0_instruction_master_arbiterlock2 <= cpu_0_jtag_debug_module_slavearbiterlockenable2 AND cpu_0_instruction_master_continuerequest;
  --cpu_0/instruction_master granted cpu_0/jtag_debug_module last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((cpu_0_jtag_debug_module_arbitration_holdoff_internal OR NOT internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module))))));
      end if;
    end if;

  end process;

  --cpu_0_instruction_master_continuerequest continued request, which is an e_mux
  cpu_0_instruction_master_continuerequest <= last_cycle_cpu_0_instruction_master_granted_slave_cpu_0_jtag_debug_module AND internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  --cpu_0_jtag_debug_module_any_continuerequest at least one master continues requesting, which is an e_mux
  cpu_0_jtag_debug_module_any_continuerequest <= cpu_0_instruction_master_continuerequest OR cpu_0_data_master_continuerequest;
  internal_cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module <= internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module AND NOT (((((NOT cpu_0_data_master_waitrequest) AND cpu_0_data_master_write)) OR cpu_0_instruction_master_arbiterlock));
  --cpu_0_jtag_debug_module_writedata mux, which is an e_mux
  cpu_0_jtag_debug_module_writedata <= cpu_0_data_master_writedata;
  --mux cpu_0_jtag_debug_module_debugaccess, which is an e_mux
  cpu_0_jtag_debug_module_debugaccess <= cpu_0_data_master_debugaccess;
  internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module <= ((to_std_logic(((Std_Logic_Vector'(cpu_0_instruction_master_address_to_slave(24 DOWNTO 11) & std_logic_vector'("00000000000")) = std_logic_vector'("1000000000001000000000000")))) AND (cpu_0_instruction_master_read))) AND cpu_0_instruction_master_read;
  --cpu_0/data_master granted cpu_0/jtag_debug_module last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((cpu_0_jtag_debug_module_arbitration_holdoff_internal OR NOT internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module))))));
      end if;
    end if;

  end process;

  --cpu_0_data_master_continuerequest continued request, which is an e_mux
  cpu_0_data_master_continuerequest <= last_cycle_cpu_0_data_master_granted_slave_cpu_0_jtag_debug_module AND internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module;
  internal_cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module <= internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module AND NOT ((((cpu_0_instruction_master_read AND ((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000")))) OR (cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register))))) OR cpu_0_data_master_arbiterlock));
  --local readdatavalid cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module, which is an e_mux
  cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module <= (internal_cpu_0_instruction_master_granted_cpu_0_jtag_debug_module AND cpu_0_instruction_master_read) AND NOT cpu_0_jtag_debug_module_waits_for_read;
  --allow new arb cycle for cpu_0/jtag_debug_module, which is an e_assign
  cpu_0_jtag_debug_module_allow_new_arb_cycle <= NOT cpu_0_data_master_arbiterlock AND NOT cpu_0_instruction_master_arbiterlock;
  --cpu_0/instruction_master assignment into master qualified-requests vector for cpu_0/jtag_debug_module, which is an e_assign
  cpu_0_jtag_debug_module_master_qreq_vector(0) <= internal_cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module;
  --cpu_0/instruction_master grant cpu_0/jtag_debug_module, which is an e_assign
  internal_cpu_0_instruction_master_granted_cpu_0_jtag_debug_module <= cpu_0_jtag_debug_module_grant_vector(0);
  --cpu_0/instruction_master saved-grant cpu_0/jtag_debug_module, which is an e_assign
  cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module <= cpu_0_jtag_debug_module_arb_winner(0) AND internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  --cpu_0/data_master assignment into master qualified-requests vector for cpu_0/jtag_debug_module, which is an e_assign
  cpu_0_jtag_debug_module_master_qreq_vector(1) <= internal_cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module;
  --cpu_0/data_master grant cpu_0/jtag_debug_module, which is an e_assign
  internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module <= cpu_0_jtag_debug_module_grant_vector(1);
  --cpu_0/data_master saved-grant cpu_0/jtag_debug_module, which is an e_assign
  cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module <= cpu_0_jtag_debug_module_arb_winner(1) AND internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module;
  --cpu_0/jtag_debug_module chosen-master double-vector, which is an e_assign
  cpu_0_jtag_debug_module_chosen_master_double_vector <= A_EXT (((std_logic_vector'("0") & ((cpu_0_jtag_debug_module_master_qreq_vector & cpu_0_jtag_debug_module_master_qreq_vector))) AND (((std_logic_vector'("0") & (Std_Logic_Vector'(NOT cpu_0_jtag_debug_module_master_qreq_vector & NOT cpu_0_jtag_debug_module_master_qreq_vector))) + (std_logic_vector'("000") & (cpu_0_jtag_debug_module_arb_addend))))), 4);
  --stable onehot encoding of arb winner
  cpu_0_jtag_debug_module_arb_winner <= A_WE_StdLogicVector((std_logic'(((cpu_0_jtag_debug_module_allow_new_arb_cycle AND or_reduce(cpu_0_jtag_debug_module_grant_vector)))) = '1'), cpu_0_jtag_debug_module_grant_vector, cpu_0_jtag_debug_module_saved_chosen_master_vector);
  --saved cpu_0_jtag_debug_module_grant_vector, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_0_jtag_debug_module_saved_chosen_master_vector <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(cpu_0_jtag_debug_module_allow_new_arb_cycle) = '1' then 
        cpu_0_jtag_debug_module_saved_chosen_master_vector <= A_WE_StdLogicVector((std_logic'(or_reduce(cpu_0_jtag_debug_module_grant_vector)) = '1'), cpu_0_jtag_debug_module_grant_vector, cpu_0_jtag_debug_module_saved_chosen_master_vector);
      end if;
    end if;

  end process;

  --onehot encoding of chosen master
  cpu_0_jtag_debug_module_grant_vector <= Std_Logic_Vector'(A_ToStdLogicVector(((cpu_0_jtag_debug_module_chosen_master_double_vector(1) OR cpu_0_jtag_debug_module_chosen_master_double_vector(3)))) & A_ToStdLogicVector(((cpu_0_jtag_debug_module_chosen_master_double_vector(0) OR cpu_0_jtag_debug_module_chosen_master_double_vector(2)))));
  --cpu_0/jtag_debug_module chosen master rotated left, which is an e_assign
  cpu_0_jtag_debug_module_chosen_master_rot_left <= A_EXT (A_WE_StdLogicVector((((A_SLL(cpu_0_jtag_debug_module_arb_winner,std_logic_vector'("00000000000000000000000000000001")))) /= std_logic_vector'("00")), (std_logic_vector'("000000000000000000000000000000") & ((A_SLL(cpu_0_jtag_debug_module_arb_winner,std_logic_vector'("00000000000000000000000000000001"))))), std_logic_vector'("00000000000000000000000000000001")), 2);
  --cpu_0/jtag_debug_module's addend for next-master-grant
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_0_jtag_debug_module_arb_addend <= std_logic_vector'("01");
    elsif clk'event and clk = '1' then
      if std_logic'(or_reduce(cpu_0_jtag_debug_module_grant_vector)) = '1' then 
        cpu_0_jtag_debug_module_arb_addend <= A_WE_StdLogicVector((std_logic'(cpu_0_jtag_debug_module_end_xfer) = '1'), cpu_0_jtag_debug_module_chosen_master_rot_left, cpu_0_jtag_debug_module_grant_vector);
      end if;
    end if;

  end process;

  cpu_0_jtag_debug_module_begintransfer <= cpu_0_jtag_debug_module_begins_xfer;
  --assign lhs ~cpu_0_jtag_debug_module_reset of type reset_n to cpu_0_jtag_debug_module_reset_n, which is an e_assign
  cpu_0_jtag_debug_module_reset <= NOT internal_cpu_0_jtag_debug_module_reset_n;
  --cpu_0_jtag_debug_module_reset_n assignment, which is an e_assign
  internal_cpu_0_jtag_debug_module_reset_n <= reset_n;
  --assign cpu_0_jtag_debug_module_resetrequest_from_sa = cpu_0_jtag_debug_module_resetrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  cpu_0_jtag_debug_module_resetrequest_from_sa <= cpu_0_jtag_debug_module_resetrequest;
  cpu_0_jtag_debug_module_chipselect <= internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module OR internal_cpu_0_instruction_master_granted_cpu_0_jtag_debug_module;
  --cpu_0_jtag_debug_module_firsttransfer first transaction, which is an e_assign
  cpu_0_jtag_debug_module_firsttransfer <= A_WE_StdLogic((std_logic'(cpu_0_jtag_debug_module_begins_xfer) = '1'), cpu_0_jtag_debug_module_unreg_firsttransfer, cpu_0_jtag_debug_module_reg_firsttransfer);
  --cpu_0_jtag_debug_module_unreg_firsttransfer first transaction, which is an e_assign
  cpu_0_jtag_debug_module_unreg_firsttransfer <= NOT ((cpu_0_jtag_debug_module_slavearbiterlockenable AND cpu_0_jtag_debug_module_any_continuerequest));
  --cpu_0_jtag_debug_module_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_0_jtag_debug_module_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(cpu_0_jtag_debug_module_begins_xfer) = '1' then 
        cpu_0_jtag_debug_module_reg_firsttransfer <= cpu_0_jtag_debug_module_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --cpu_0_jtag_debug_module_beginbursttransfer_internal begin burst transfer, which is an e_assign
  cpu_0_jtag_debug_module_beginbursttransfer_internal <= cpu_0_jtag_debug_module_begins_xfer;
  --cpu_0_jtag_debug_module_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  cpu_0_jtag_debug_module_arbitration_holdoff_internal <= cpu_0_jtag_debug_module_begins_xfer AND cpu_0_jtag_debug_module_firsttransfer;
  --cpu_0_jtag_debug_module_write assignment, which is an e_mux
  cpu_0_jtag_debug_module_write <= internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module AND cpu_0_data_master_write;
  shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_data_master <= cpu_0_data_master_address_to_slave;
  --cpu_0_jtag_debug_module_address mux, which is an e_mux
  cpu_0_jtag_debug_module_address <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module)) = '1'), (A_SRL(shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_data_master,std_logic_vector'("00000000000000000000000000000010"))), (A_SRL(shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_instruction_master,std_logic_vector'("00000000000000000000000000000010")))), 9);
  shifted_address_to_cpu_0_jtag_debug_module_from_cpu_0_instruction_master <= cpu_0_instruction_master_address_to_slave;
  --d1_cpu_0_jtag_debug_module_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_cpu_0_jtag_debug_module_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_cpu_0_jtag_debug_module_end_xfer <= cpu_0_jtag_debug_module_end_xfer;
      end if;
    end if;

  end process;

  --cpu_0_jtag_debug_module_waits_for_read in a cycle, which is an e_mux
  cpu_0_jtag_debug_module_waits_for_read <= cpu_0_jtag_debug_module_in_a_read_cycle AND cpu_0_jtag_debug_module_begins_xfer;
  --cpu_0_jtag_debug_module_in_a_read_cycle assignment, which is an e_assign
  cpu_0_jtag_debug_module_in_a_read_cycle <= ((internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module AND cpu_0_data_master_read)) OR ((internal_cpu_0_instruction_master_granted_cpu_0_jtag_debug_module AND cpu_0_instruction_master_read));
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= cpu_0_jtag_debug_module_in_a_read_cycle;
  --cpu_0_jtag_debug_module_waits_for_write in a cycle, which is an e_mux
  cpu_0_jtag_debug_module_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_jtag_debug_module_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --cpu_0_jtag_debug_module_in_a_write_cycle assignment, which is an e_assign
  cpu_0_jtag_debug_module_in_a_write_cycle <= internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module AND cpu_0_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= cpu_0_jtag_debug_module_in_a_write_cycle;
  wait_for_cpu_0_jtag_debug_module_counter <= std_logic'('0');
  --cpu_0_jtag_debug_module_byteenable byte enable port mux, which is an e_mux
  cpu_0_jtag_debug_module_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module)) = '1'), (std_logic_vector'("0000000000000000000000000000") & (cpu_0_data_master_byteenable)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 4);
  --vhdl renameroo for output signals
  cpu_0_data_master_granted_cpu_0_jtag_debug_module <= internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module <= internal_cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_0_data_master_requests_cpu_0_jtag_debug_module <= internal_cpu_0_data_master_requests_cpu_0_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_granted_cpu_0_jtag_debug_module <= internal_cpu_0_instruction_master_granted_cpu_0_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module <= internal_cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_requests_cpu_0_jtag_debug_module <= internal_cpu_0_instruction_master_requests_cpu_0_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_0_jtag_debug_module_reset_n <= internal_cpu_0_jtag_debug_module_reset_n;
--synthesis translate_off
    --cpu_0/jtag_debug_module enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

    --grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line24 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_0_data_master_granted_cpu_0_jtag_debug_module))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_0_instruction_master_granted_cpu_0_jtag_debug_module))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line24, now);
          write(write_line24, string'(": "));
          write(write_line24, string'("> 1 of grant signals are active simultaneously"));
          write(output, write_line24.all);
          deallocate (write_line24);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

    --saved_grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line25 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_saved_grant_cpu_0_jtag_debug_module))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_saved_grant_cpu_0_jtag_debug_module))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line25, now);
          write(write_line25, string'(": "));
          write(write_line25, string'("> 1 of saved_grant signals are active simultaneously"));
          write(output, write_line25.all);
          deallocate (write_line25);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity DM9000A_avalonS_irq_from_sa_clock_crossing_cpu_0_data_master_module is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC
              );
end entity DM9000A_avalonS_irq_from_sa_clock_crossing_cpu_0_data_master_module;


architecture europa of DM9000A_avalonS_irq_from_sa_clock_crossing_cpu_0_data_master_module is
                signal data_in_d1 :  STD_LOGIC;
attribute ALTERA_ATTRIBUTE : string;
attribute ALTERA_ATTRIBUTE of data_in_d1 : signal is "MAX_DELAY=100ns ; PRESERVE_REGISTER=ON";
attribute ALTERA_ATTRIBUTE of data_out : signal is "PRESERVE_REGISTER=ON";

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_in_d1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_in_d1 <= data_in;
      end if;
    end if;

  end process;

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_out <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_out <= data_in_d1;
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity epcs_controller_epcs_control_port_irq_from_sa_clock_crossing_cpu_0_data_master_module is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC
              );
end entity epcs_controller_epcs_control_port_irq_from_sa_clock_crossing_cpu_0_data_master_module;


architecture europa of epcs_controller_epcs_control_port_irq_from_sa_clock_crossing_cpu_0_data_master_module is
                signal data_in_d1 :  STD_LOGIC;
attribute ALTERA_ATTRIBUTE : string;
attribute ALTERA_ATTRIBUTE of data_in_d1 : signal is "MAX_DELAY=100ns ; PRESERVE_REGISTER=ON";
attribute ALTERA_ATTRIBUTE of data_out : signal is "PRESERVE_REGISTER=ON";

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_in_d1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_in_d1 <= data_in;
      end if;
    end if;

  end process;

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_out <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_out <= data_in_d1;
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity jtag_uart_0_avalon_jtag_slave_irq_from_sa_clock_crossing_cpu_0_data_master_module is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC
              );
end entity jtag_uart_0_avalon_jtag_slave_irq_from_sa_clock_crossing_cpu_0_data_master_module;


architecture europa of jtag_uart_0_avalon_jtag_slave_irq_from_sa_clock_crossing_cpu_0_data_master_module is
                signal data_in_d1 :  STD_LOGIC;
attribute ALTERA_ATTRIBUTE : string;
attribute ALTERA_ATTRIBUTE of data_in_d1 : signal is "MAX_DELAY=100ns ; PRESERVE_REGISTER=ON";
attribute ALTERA_ATTRIBUTE of data_out : signal is "PRESERVE_REGISTER=ON";

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_in_d1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_in_d1 <= data_in;
      end if;
    end if;

  end process;

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_out <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_out <= data_in_d1;
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity cpu_0_data_master_arbitrator is 
        port (
              -- inputs:
                 signal DM9000A_avalonS_irq_from_sa : IN STD_LOGIC;
                 signal clk : IN STD_LOGIC;
                 signal clk_1 : IN STD_LOGIC;
                 signal clk_1_reset_n : IN STD_LOGIC;
                 signal clock_0_in_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_0_in_waitrequest_from_sa : IN STD_LOGIC;
                 signal clock_1_in_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_1_in_waitrequest_from_sa : IN STD_LOGIC;
                 signal clock_3_in_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_3_in_waitrequest_from_sa : IN STD_LOGIC;
                 signal clock_4_in_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_4_in_waitrequest_from_sa : IN STD_LOGIC;
                 signal clock_5_in_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal clock_5_in_waitrequest_from_sa : IN STD_LOGIC;
                 signal cpu_0_data_master_address : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable_clock_4_in : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_byteenable_clock_5_in : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_byteenable_sdram_s1 : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_debugaccess : IN STD_LOGIC;
                 signal cpu_0_data_master_granted_clock_0_in : IN STD_LOGIC;
                 signal cpu_0_data_master_granted_clock_1_in : IN STD_LOGIC;
                 signal cpu_0_data_master_granted_clock_3_in : IN STD_LOGIC;
                 signal cpu_0_data_master_granted_clock_4_in : IN STD_LOGIC;
                 signal cpu_0_data_master_granted_clock_5_in : IN STD_LOGIC;
                 signal cpu_0_data_master_granted_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_data_master_granted_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_0_in : IN STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_1_in : IN STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_3_in : IN STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_4_in : IN STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_clock_5_in : IN STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_0_in : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_1_in : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_3_in : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_4_in : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_clock_5_in : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_0_in : IN STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_1_in : IN STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_3_in : IN STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_4_in : IN STD_LOGIC;
                 signal cpu_0_data_master_requests_clock_5_in : IN STD_LOGIC;
                 signal cpu_0_data_master_requests_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_data_master_requests_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_clock_0_in_end_xfer : IN STD_LOGIC;
                 signal d1_clock_1_in_end_xfer : IN STD_LOGIC;
                 signal d1_clock_3_in_end_xfer : IN STD_LOGIC;
                 signal d1_clock_4_in_end_xfer : IN STD_LOGIC;
                 signal d1_clock_5_in_end_xfer : IN STD_LOGIC;
                 signal d1_cpu_0_jtag_debug_module_end_xfer : IN STD_LOGIC;
                 signal d1_sdram_s1_end_xfer : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_irq_from_sa : IN STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_irq_from_sa : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sdram_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal sdram_s1_waitrequest_from_sa : IN STD_LOGIC;

              -- outputs:
                 signal cpu_0_data_master_address_to_slave : OUT STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_dbs_write_16 : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_0_data_master_irq : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_data_master_no_byte_enables_and_last_term : OUT STD_LOGIC;
                 signal cpu_0_data_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_data_master_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of cpu_0_data_master_arbitrator : entity is FALSE;
end entity cpu_0_data_master_arbitrator;


architecture europa of cpu_0_data_master_arbitrator is
component DM9000A_avalonS_irq_from_sa_clock_crossing_cpu_0_data_master_module is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC
                 );
end component DM9000A_avalonS_irq_from_sa_clock_crossing_cpu_0_data_master_module;

component epcs_controller_epcs_control_port_irq_from_sa_clock_crossing_cpu_0_data_master_module is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC
                 );
end component epcs_controller_epcs_control_port_irq_from_sa_clock_crossing_cpu_0_data_master_module;

component jtag_uart_0_avalon_jtag_slave_irq_from_sa_clock_crossing_cpu_0_data_master_module is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC
                 );
end component jtag_uart_0_avalon_jtag_slave_irq_from_sa_clock_crossing_cpu_0_data_master_module;

                signal clk_1_DM9000A_avalonS_irq_from_sa :  STD_LOGIC;
                signal clk_1_epcs_controller_epcs_control_port_irq_from_sa :  STD_LOGIC;
                signal clk_1_jtag_uart_0_avalon_jtag_slave_irq_from_sa :  STD_LOGIC;
                signal cpu_0_data_master_dbs_increment :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_run :  STD_LOGIC;
                signal dbs_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal dbs_count_enable :  STD_LOGIC;
                signal dbs_counter_overflow :  STD_LOGIC;
                signal internal_cpu_0_data_master_address_to_slave :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal internal_cpu_0_data_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_0_data_master_no_byte_enables_and_last_term :  STD_LOGIC;
                signal internal_cpu_0_data_master_waitrequest :  STD_LOGIC;
                signal last_dbs_term_and_run :  STD_LOGIC;
                signal next_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal p1_dbs_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal p1_registered_cpu_0_data_master_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal pre_dbs_count_enable :  STD_LOGIC;
                signal r_0 :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;
                signal registered_cpu_0_data_master_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);

begin

  --r_0 master_run cascaded wait assignment, which is an e_assign
  r_0 <= Vector_To_Std_Logic((((((((((((((((((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_qualified_request_clock_0_in OR NOT cpu_0_data_master_requests_clock_0_in)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_0_in OR NOT ((cpu_0_data_master_read OR cpu_0_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_0_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_read OR cpu_0_data_master_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_0_in OR NOT ((cpu_0_data_master_read OR cpu_0_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_0_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_read OR cpu_0_data_master_write)))))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_qualified_request_clock_1_in OR NOT cpu_0_data_master_requests_clock_1_in)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_1_in OR NOT ((cpu_0_data_master_read OR cpu_0_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_1_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_read OR cpu_0_data_master_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_1_in OR NOT ((cpu_0_data_master_read OR cpu_0_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_1_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_read OR cpu_0_data_master_write)))))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_qualified_request_clock_3_in OR NOT cpu_0_data_master_requests_clock_3_in)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_3_in OR NOT ((cpu_0_data_master_read OR cpu_0_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_3_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_read OR cpu_0_data_master_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_3_in OR NOT ((cpu_0_data_master_read OR cpu_0_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_3_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_read OR cpu_0_data_master_write)))))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((((cpu_0_data_master_qualified_request_clock_4_in OR (((cpu_0_data_master_write AND NOT(or_reduce(cpu_0_data_master_byteenable_clock_4_in))) AND internal_cpu_0_data_master_dbs_address(1)))) OR NOT cpu_0_data_master_requests_clock_4_in)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_4_in OR NOT cpu_0_data_master_read)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_4_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_0_data_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_4_in OR NOT cpu_0_data_master_write)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_4_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_0_data_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((((cpu_0_data_master_qualified_request_clock_5_in OR (((cpu_0_data_master_write AND NOT(or_reduce(cpu_0_data_master_byteenable_clock_5_in))) AND internal_cpu_0_data_master_dbs_address(1)))) OR NOT cpu_0_data_master_requests_clock_5_in)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_5_in OR NOT cpu_0_data_master_read)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_5_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_0_data_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_clock_5_in OR NOT cpu_0_data_master_write)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_5_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_0_data_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_write)))))))));
  --cascaded wait assignment, which is an e_assign
  cpu_0_data_master_run <= r_0 AND r_1;
  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic((((((((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module OR NOT cpu_0_data_master_requests_cpu_0_jtag_debug_module)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_granted_cpu_0_jtag_debug_module OR NOT cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module OR NOT cpu_0_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module OR NOT cpu_0_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((((cpu_0_data_master_qualified_request_sdram_s1 OR ((cpu_0_data_master_read_data_valid_sdram_s1 AND internal_cpu_0_data_master_dbs_address(1)))) OR (((cpu_0_data_master_write AND NOT(or_reduce(cpu_0_data_master_byteenable_sdram_s1))) AND internal_cpu_0_data_master_dbs_address(1)))) OR NOT cpu_0_data_master_requests_sdram_s1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_granted_sdram_s1 OR NOT cpu_0_data_master_qualified_request_sdram_s1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((((NOT cpu_0_data_master_qualified_request_sdram_s1 OR NOT cpu_0_data_master_read) OR (((cpu_0_data_master_read_data_valid_sdram_s1 AND (internal_cpu_0_data_master_dbs_address(1))) AND cpu_0_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_data_master_qualified_request_sdram_s1 OR NOT cpu_0_data_master_write)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT sdram_s1_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_0_data_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_write)))))))));
  --DM9000A_avalonS_irq_from_sa from clk to clk_1
  DM9000A_avalonS_irq_from_sa_clock_crossing_cpu_0_data_master : DM9000A_avalonS_irq_from_sa_clock_crossing_cpu_0_data_master_module
    port map(
      data_out => clk_1_DM9000A_avalonS_irq_from_sa,
      clk => clk_1,
      data_in => DM9000A_avalonS_irq_from_sa,
      reset_n => clk_1_reset_n
    );


  --irq assign, which is an e_assign
  cpu_0_data_master_irq <= Std_Logic_Vector'(A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(clk_1_epcs_controller_epcs_control_port_irq_from_sa) & A_ToStdLogicVector(clk_1_DM9000A_avalonS_irq_from_sa) & A_ToStdLogicVector(clk_1_jtag_uart_0_avalon_jtag_slave_irq_from_sa));
  --optimize select-logic by passing only those address bits which matter.
  internal_cpu_0_data_master_address_to_slave <= cpu_0_data_master_address(24 DOWNTO 0);
  --unpredictable registered wait state incoming data, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      registered_cpu_0_data_master_readdata <= std_logic_vector'("00000000000000000000000000000000");
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        registered_cpu_0_data_master_readdata <= p1_registered_cpu_0_data_master_readdata;
      end if;
    end if;

  end process;

  --registered readdata mux, which is an e_mux
  p1_registered_cpu_0_data_master_readdata <= ((((((A_REP(NOT cpu_0_data_master_requests_clock_0_in, 32) OR clock_0_in_readdata_from_sa)) AND ((A_REP(NOT cpu_0_data_master_requests_clock_1_in, 32) OR (std_logic_vector'("0000000000000000") & (clock_1_in_readdata_from_sa))))) AND ((A_REP(NOT cpu_0_data_master_requests_clock_3_in, 32) OR clock_3_in_readdata_from_sa))) AND ((A_REP(NOT cpu_0_data_master_requests_clock_4_in, 32) OR Std_Logic_Vector'(clock_4_in_readdata_from_sa(15 DOWNTO 0) & dbs_16_reg_segment_0)))) AND ((A_REP(NOT cpu_0_data_master_requests_clock_5_in, 32) OR Std_Logic_Vector'(clock_5_in_readdata_from_sa(15 DOWNTO 0) & dbs_16_reg_segment_0)))) AND ((A_REP(NOT cpu_0_data_master_requests_sdram_s1, 32) OR Std_Logic_Vector'(sdram_s1_readdata_from_sa(15 DOWNTO 0) & dbs_16_reg_segment_0)));
  --cpu_0/data_master readdata mux, which is an e_mux
  cpu_0_data_master_readdata <= (((((((A_REP(NOT cpu_0_data_master_requests_clock_0_in, 32) OR registered_cpu_0_data_master_readdata)) AND ((A_REP(NOT cpu_0_data_master_requests_clock_1_in, 32) OR registered_cpu_0_data_master_readdata))) AND ((A_REP(NOT cpu_0_data_master_requests_clock_3_in, 32) OR registered_cpu_0_data_master_readdata))) AND ((A_REP(NOT cpu_0_data_master_requests_clock_4_in, 32) OR registered_cpu_0_data_master_readdata))) AND ((A_REP(NOT cpu_0_data_master_requests_clock_5_in, 32) OR registered_cpu_0_data_master_readdata))) AND ((A_REP(NOT cpu_0_data_master_requests_cpu_0_jtag_debug_module, 32) OR cpu_0_jtag_debug_module_readdata_from_sa))) AND ((A_REP(NOT cpu_0_data_master_requests_sdram_s1, 32) OR registered_cpu_0_data_master_readdata));
  --actual waitrequest port, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_0_data_master_waitrequest <= Vector_To_Std_Logic(NOT std_logic_vector'("00000000000000000000000000000000"));
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        internal_cpu_0_data_master_waitrequest <= Vector_To_Std_Logic(NOT (A_WE_StdLogicVector((std_logic'((NOT ((cpu_0_data_master_read OR cpu_0_data_master_write)))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_data_master_run AND internal_cpu_0_data_master_waitrequest))))))));
      end if;
    end if;

  end process;

  --no_byte_enables_and_last_term, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_0_data_master_no_byte_enables_and_last_term <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        internal_cpu_0_data_master_no_byte_enables_and_last_term <= last_dbs_term_and_run;
      end if;
    end if;

  end process;

  --compute the last dbs term, which is an e_mux
  last_dbs_term_and_run <= A_WE_StdLogic((std_logic'((cpu_0_data_master_requests_clock_4_in)) = '1'), (((to_std_logic(((internal_cpu_0_data_master_dbs_address = std_logic_vector'("10")))) AND cpu_0_data_master_write) AND NOT(or_reduce(cpu_0_data_master_byteenable_clock_4_in)))), A_WE_StdLogic((std_logic'((cpu_0_data_master_requests_clock_5_in)) = '1'), (((to_std_logic(((internal_cpu_0_data_master_dbs_address = std_logic_vector'("10")))) AND cpu_0_data_master_write) AND NOT(or_reduce(cpu_0_data_master_byteenable_clock_5_in)))), (((to_std_logic(((internal_cpu_0_data_master_dbs_address = std_logic_vector'("10")))) AND cpu_0_data_master_write) AND NOT(or_reduce(cpu_0_data_master_byteenable_sdram_s1))))));
  --pre dbs count enable, which is an e_mux
  pre_dbs_count_enable <= Vector_To_Std_Logic((((((((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((((((NOT internal_cpu_0_data_master_no_byte_enables_and_last_term) AND cpu_0_data_master_requests_clock_4_in) AND cpu_0_data_master_write) AND NOT(or_reduce(cpu_0_data_master_byteenable_clock_4_in))))))) OR (((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_data_master_granted_clock_4_in AND cpu_0_data_master_read)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_4_in_waitrequest_from_sa)))))) OR (((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_data_master_granted_clock_4_in AND cpu_0_data_master_write)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_4_in_waitrequest_from_sa)))))) OR (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((((((NOT internal_cpu_0_data_master_no_byte_enables_and_last_term) AND cpu_0_data_master_requests_clock_5_in) AND cpu_0_data_master_write) AND NOT(or_reduce(cpu_0_data_master_byteenable_clock_5_in)))))))) OR (((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_data_master_granted_clock_5_in AND cpu_0_data_master_read)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_5_in_waitrequest_from_sa)))))) OR (((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_data_master_granted_clock_5_in AND cpu_0_data_master_write)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_5_in_waitrequest_from_sa)))))) OR (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((((((NOT internal_cpu_0_data_master_no_byte_enables_and_last_term) AND cpu_0_data_master_requests_sdram_s1) AND cpu_0_data_master_write) AND NOT(or_reduce(cpu_0_data_master_byteenable_sdram_s1)))))))) OR (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_read_data_valid_sdram_s1)))) OR (((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_data_master_granted_sdram_s1 AND cpu_0_data_master_write)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT sdram_s1_waitrequest_from_sa)))))));
  --input to dbs-16 stored 0, which is an e_mux
  p1_dbs_16_reg_segment_0 <= A_WE_StdLogicVector((std_logic'((cpu_0_data_master_requests_clock_4_in)) = '1'), clock_4_in_readdata_from_sa, A_WE_StdLogicVector((std_logic'((cpu_0_data_master_requests_clock_5_in)) = '1'), clock_5_in_readdata_from_sa, sdram_s1_readdata_from_sa));
  --dbs register for dbs-16 segment 0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      dbs_16_reg_segment_0 <= std_logic_vector'("0000000000000000");
    elsif clk'event and clk = '1' then
      if std_logic'((dbs_count_enable AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_0_data_master_dbs_address(1))))) = std_logic_vector'("00000000000000000000000000000000")))))) = '1' then 
        dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
      end if;
    end if;

  end process;

  --mux write dbs 1, which is an e_mux
  cpu_0_data_master_dbs_write_16 <= A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_dbs_address(1))) = '1'), cpu_0_data_master_writedata(31 DOWNTO 16), A_WE_StdLogicVector((std_logic'((NOT (internal_cpu_0_data_master_dbs_address(1)))) = '1'), cpu_0_data_master_writedata(15 DOWNTO 0), A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_dbs_address(1))) = '1'), cpu_0_data_master_writedata(31 DOWNTO 16), A_WE_StdLogicVector((std_logic'((NOT (internal_cpu_0_data_master_dbs_address(1)))) = '1'), cpu_0_data_master_writedata(15 DOWNTO 0), A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_dbs_address(1))) = '1'), cpu_0_data_master_writedata(31 DOWNTO 16), cpu_0_data_master_writedata(15 DOWNTO 0))))));
  --dbs count increment, which is an e_mux
  cpu_0_data_master_dbs_increment <= A_EXT (A_WE_StdLogicVector((std_logic'((cpu_0_data_master_requests_clock_4_in)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((cpu_0_data_master_requests_clock_5_in)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((cpu_0_data_master_requests_sdram_s1)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000000")))), 2);
  --dbs counter overflow, which is an e_assign
  dbs_counter_overflow <= internal_cpu_0_data_master_dbs_address(1) AND NOT((next_dbs_address(1)));
  --next master address, which is an e_assign
  next_dbs_address <= A_EXT (((std_logic_vector'("0") & (internal_cpu_0_data_master_dbs_address)) + (std_logic_vector'("0") & (cpu_0_data_master_dbs_increment))), 2);
  --dbs count enable, which is an e_mux
  dbs_count_enable <= ((pre_dbs_count_enable AND (NOT ((cpu_0_data_master_requests_clock_4_in AND NOT internal_cpu_0_data_master_waitrequest)))) AND (NOT ((cpu_0_data_master_requests_clock_5_in AND NOT internal_cpu_0_data_master_waitrequest)))) AND (NOT ((cpu_0_data_master_requests_sdram_s1 AND NOT internal_cpu_0_data_master_waitrequest)));
  --dbs counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_0_data_master_dbs_address <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(dbs_count_enable) = '1' then 
        internal_cpu_0_data_master_dbs_address <= next_dbs_address;
      end if;
    end if;

  end process;

  --epcs_controller_epcs_control_port_irq_from_sa from clk to clk_1
  epcs_controller_epcs_control_port_irq_from_sa_clock_crossing_cpu_0_data_master : epcs_controller_epcs_control_port_irq_from_sa_clock_crossing_cpu_0_data_master_module
    port map(
      data_out => clk_1_epcs_controller_epcs_control_port_irq_from_sa,
      clk => clk_1,
      data_in => epcs_controller_epcs_control_port_irq_from_sa,
      reset_n => clk_1_reset_n
    );


  --jtag_uart_0_avalon_jtag_slave_irq_from_sa from clk to clk_1
  jtag_uart_0_avalon_jtag_slave_irq_from_sa_clock_crossing_cpu_0_data_master : jtag_uart_0_avalon_jtag_slave_irq_from_sa_clock_crossing_cpu_0_data_master_module
    port map(
      data_out => clk_1_jtag_uart_0_avalon_jtag_slave_irq_from_sa,
      clk => clk_1,
      data_in => jtag_uart_0_avalon_jtag_slave_irq_from_sa,
      reset_n => clk_1_reset_n
    );


  --vhdl renameroo for output signals
  cpu_0_data_master_address_to_slave <= internal_cpu_0_data_master_address_to_slave;
  --vhdl renameroo for output signals
  cpu_0_data_master_dbs_address <= internal_cpu_0_data_master_dbs_address;
  --vhdl renameroo for output signals
  cpu_0_data_master_no_byte_enables_and_last_term <= internal_cpu_0_data_master_no_byte_enables_and_last_term;
  --vhdl renameroo for output signals
  cpu_0_data_master_waitrequest <= internal_cpu_0_data_master_waitrequest;

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity cpu_0_instruction_master_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_2_in_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_2_in_waitrequest_from_sa : IN STD_LOGIC;
                 signal cpu_0_instruction_master_address : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_instruction_master_granted_clock_2_in : IN STD_LOGIC;
                 signal cpu_0_instruction_master_granted_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_instruction_master_granted_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_instruction_master_qualified_request_clock_2_in : IN STD_LOGIC;
                 signal cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_instruction_master_qualified_request_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_clock_2_in : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                 signal cpu_0_instruction_master_requests_clock_2_in : IN STD_LOGIC;
                 signal cpu_0_instruction_master_requests_cpu_0_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_0_instruction_master_requests_sdram_s1 : IN STD_LOGIC;
                 signal cpu_0_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_clock_2_in_end_xfer : IN STD_LOGIC;
                 signal d1_cpu_0_jtag_debug_module_end_xfer : IN STD_LOGIC;
                 signal d1_sdram_s1_end_xfer : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sdram_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal sdram_s1_waitrequest_from_sa : IN STD_LOGIC;

              -- outputs:
                 signal cpu_0_instruction_master_address_to_slave : OUT STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_instruction_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_instruction_master_latency_counter : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_0_instruction_master_readdatavalid : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of cpu_0_instruction_master_arbitrator : entity is FALSE;
end entity cpu_0_instruction_master_arbitrator;


architecture europa of cpu_0_instruction_master_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal cpu_0_instruction_master_address_last_time :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal cpu_0_instruction_master_dbs_increment :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_instruction_master_dbs_rdv_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_instruction_master_dbs_rdv_counter_inc :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_instruction_master_is_granted_some_slave :  STD_LOGIC;
                signal cpu_0_instruction_master_next_dbs_rdv_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_instruction_master_read_but_no_slave_selected :  STD_LOGIC;
                signal cpu_0_instruction_master_read_last_time :  STD_LOGIC;
                signal cpu_0_instruction_master_run :  STD_LOGIC;
                signal dbs_count_enable :  STD_LOGIC;
                signal dbs_counter_overflow :  STD_LOGIC;
                signal dbs_latent_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal dbs_rdv_count_enable :  STD_LOGIC;
                signal dbs_rdv_counter_overflow :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_address_to_slave :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal internal_cpu_0_instruction_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_0_instruction_master_latency_counter :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_waitrequest :  STD_LOGIC;
                signal latency_load_value :  STD_LOGIC;
                signal next_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal p1_cpu_0_instruction_master_latency_counter :  STD_LOGIC;
                signal p1_dbs_latent_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal pre_dbs_count_enable :  STD_LOGIC;
                signal pre_flush_cpu_0_instruction_master_readdatavalid :  STD_LOGIC;
                signal r_0 :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;

begin

  --r_0 master_run cascaded wait assignment, which is an e_assign
  r_0 <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_instruction_master_qualified_request_clock_2_in OR NOT cpu_0_instruction_master_requests_clock_2_in)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_instruction_master_qualified_request_clock_2_in OR NOT (cpu_0_instruction_master_read))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT clock_2_in_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_instruction_master_read))))))))));
  --cascaded wait assignment, which is an e_assign
  cpu_0_instruction_master_run <= r_0 AND r_1;
  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic((((((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module OR NOT cpu_0_instruction_master_requests_cpu_0_jtag_debug_module)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_instruction_master_granted_cpu_0_jtag_debug_module OR NOT cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module OR NOT cpu_0_instruction_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_cpu_0_jtag_debug_module_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_read)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_instruction_master_qualified_request_sdram_s1 OR NOT cpu_0_instruction_master_requests_sdram_s1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_0_instruction_master_granted_sdram_s1 OR NOT cpu_0_instruction_master_qualified_request_sdram_s1)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_0_instruction_master_qualified_request_sdram_s1 OR NOT cpu_0_instruction_master_read)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT sdram_s1_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_0_instruction_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_read)))))))));
  --optimize select-logic by passing only those address bits which matter.
  internal_cpu_0_instruction_master_address_to_slave <= cpu_0_instruction_master_address(24 DOWNTO 0);
  --cpu_0_instruction_master_read_but_no_slave_selected assignment, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_0_instruction_master_read_but_no_slave_selected <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        cpu_0_instruction_master_read_but_no_slave_selected <= (cpu_0_instruction_master_read AND cpu_0_instruction_master_run) AND NOT cpu_0_instruction_master_is_granted_some_slave;
      end if;
    end if;

  end process;

  --some slave is getting selected, which is an e_mux
  cpu_0_instruction_master_is_granted_some_slave <= (cpu_0_instruction_master_granted_clock_2_in OR cpu_0_instruction_master_granted_cpu_0_jtag_debug_module) OR cpu_0_instruction_master_granted_sdram_s1;
  --latent slave read data valids which may be flushed, which is an e_mux
  pre_flush_cpu_0_instruction_master_readdatavalid <= cpu_0_instruction_master_read_data_valid_sdram_s1 AND dbs_rdv_counter_overflow;
  --latent slave read data valid which is not flushed, which is an e_mux
  cpu_0_instruction_master_readdatavalid <= ((((((cpu_0_instruction_master_read_but_no_slave_selected OR pre_flush_cpu_0_instruction_master_readdatavalid) OR cpu_0_instruction_master_read_data_valid_clock_2_in) OR cpu_0_instruction_master_read_but_no_slave_selected) OR pre_flush_cpu_0_instruction_master_readdatavalid) OR cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module) OR cpu_0_instruction_master_read_but_no_slave_selected) OR pre_flush_cpu_0_instruction_master_readdatavalid;
  --cpu_0/instruction_master readdata mux, which is an e_mux
  cpu_0_instruction_master_readdata <= (((A_REP(NOT ((cpu_0_instruction_master_qualified_request_clock_2_in AND cpu_0_instruction_master_read)) , 32) OR clock_2_in_readdata_from_sa)) AND ((A_REP(NOT ((cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module AND cpu_0_instruction_master_read)) , 32) OR cpu_0_jtag_debug_module_readdata_from_sa))) AND ((A_REP(NOT cpu_0_instruction_master_read_data_valid_sdram_s1, 32) OR Std_Logic_Vector'(sdram_s1_readdata_from_sa(15 DOWNTO 0) & dbs_latent_16_reg_segment_0)));
  --actual waitrequest port, which is an e_assign
  internal_cpu_0_instruction_master_waitrequest <= NOT cpu_0_instruction_master_run;
  --latent max counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_0_instruction_master_latency_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        internal_cpu_0_instruction_master_latency_counter <= p1_cpu_0_instruction_master_latency_counter;
      end if;
    end if;

  end process;

  --latency counter load mux, which is an e_mux
  p1_cpu_0_instruction_master_latency_counter <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(((cpu_0_instruction_master_run AND cpu_0_instruction_master_read))) = '1'), (std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(latency_load_value))), A_WE_StdLogicVector((std_logic'((internal_cpu_0_instruction_master_latency_counter)) = '1'), ((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(internal_cpu_0_instruction_master_latency_counter))) - std_logic_vector'("000000000000000000000000000000001")), std_logic_vector'("000000000000000000000000000000000"))));
  --read latency load values, which is an e_mux
  latency_load_value <= std_logic'('0');
  --input to latent dbs-16 stored 0, which is an e_mux
  p1_dbs_latent_16_reg_segment_0 <= sdram_s1_readdata_from_sa;
  --dbs register for latent dbs-16 segment 0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      dbs_latent_16_reg_segment_0 <= std_logic_vector'("0000000000000000");
    elsif clk'event and clk = '1' then
      if std_logic'((dbs_rdv_count_enable AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_instruction_master_dbs_rdv_counter(1))))) = std_logic_vector'("00000000000000000000000000000000")))))) = '1' then 
        dbs_latent_16_reg_segment_0 <= p1_dbs_latent_16_reg_segment_0;
      end if;
    end if;

  end process;

  --dbs count increment, which is an e_mux
  cpu_0_instruction_master_dbs_increment <= A_EXT (A_WE_StdLogicVector((std_logic'((cpu_0_instruction_master_requests_sdram_s1)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000000")), 2);
  --dbs counter overflow, which is an e_assign
  dbs_counter_overflow <= internal_cpu_0_instruction_master_dbs_address(1) AND NOT((next_dbs_address(1)));
  --next master address, which is an e_assign
  next_dbs_address <= A_EXT (((std_logic_vector'("0") & (internal_cpu_0_instruction_master_dbs_address)) + (std_logic_vector'("0") & (cpu_0_instruction_master_dbs_increment))), 2);
  --dbs count enable, which is an e_mux
  dbs_count_enable <= pre_dbs_count_enable;
  --dbs counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_0_instruction_master_dbs_address <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(dbs_count_enable) = '1' then 
        internal_cpu_0_instruction_master_dbs_address <= next_dbs_address;
      end if;
    end if;

  end process;

  --p1 dbs rdv counter, which is an e_assign
  cpu_0_instruction_master_next_dbs_rdv_counter <= A_EXT (((std_logic_vector'("0") & (cpu_0_instruction_master_dbs_rdv_counter)) + (std_logic_vector'("0") & (cpu_0_instruction_master_dbs_rdv_counter_inc))), 2);
  --cpu_0_instruction_master_rdv_inc_mux, which is an e_mux
  cpu_0_instruction_master_dbs_rdv_counter_inc <= std_logic_vector'("10");
  --master any slave rdv, which is an e_mux
  dbs_rdv_count_enable <= cpu_0_instruction_master_read_data_valid_sdram_s1;
  --dbs rdv counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_0_instruction_master_dbs_rdv_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(dbs_rdv_count_enable) = '1' then 
        cpu_0_instruction_master_dbs_rdv_counter <= cpu_0_instruction_master_next_dbs_rdv_counter;
      end if;
    end if;

  end process;

  --dbs rdv counter overflow, which is an e_assign
  dbs_rdv_counter_overflow <= cpu_0_instruction_master_dbs_rdv_counter(1) AND NOT cpu_0_instruction_master_next_dbs_rdv_counter(1);
  --pre dbs count enable, which is an e_mux
  pre_dbs_count_enable <= Vector_To_Std_Logic(((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_0_instruction_master_granted_sdram_s1 AND cpu_0_instruction_master_read)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT sdram_s1_waitrequest_from_sa)))));
  --vhdl renameroo for output signals
  cpu_0_instruction_master_address_to_slave <= internal_cpu_0_instruction_master_address_to_slave;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_dbs_address <= internal_cpu_0_instruction_master_dbs_address;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_latency_counter <= internal_cpu_0_instruction_master_latency_counter;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_waitrequest <= internal_cpu_0_instruction_master_waitrequest;
--synthesis translate_off
    --cpu_0_instruction_master_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_0_instruction_master_address_last_time <= std_logic_vector'("0000000000000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_0_instruction_master_address_last_time <= cpu_0_instruction_master_address;
        end if;
      end if;

    end process;

    --cpu_0/instruction_master waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_cpu_0_instruction_master_waitrequest AND (cpu_0_instruction_master_read);
        end if;
      end if;

    end process;

    --cpu_0_instruction_master_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_0_instruction_master_address, cpu_0_instruction_master_address_last_time)
    VARIABLE write_line26 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((cpu_0_instruction_master_address /= cpu_0_instruction_master_address_last_time))))) = '1' then 
          write(write_line26, now);
          write(write_line26, string'(": "));
          write(write_line26, string'("cpu_0_instruction_master_address did not heed wait!!!"));
          write(output, write_line26.all);
          deallocate (write_line26);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --cpu_0_instruction_master_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_0_instruction_master_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_0_instruction_master_read_last_time <= cpu_0_instruction_master_read;
        end if;
      end if;

    end process;

    --cpu_0_instruction_master_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_0_instruction_master_read, cpu_0_instruction_master_read_last_time)
    VARIABLE write_line27 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(cpu_0_instruction_master_read) /= std_logic'(cpu_0_instruction_master_read_last_time)))))) = '1' then 
          write(write_line27, now);
          write(write_line27, string'(": "));
          write(write_line27, string'("cpu_0_instruction_master_read did not heed wait!!!"));
          write(output, write_line27.all);
          deallocate (write_line27);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity epcs_controller_epcs_control_port_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_2_out_address_to_slave : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_2_out_read : IN STD_LOGIC;
                 signal clock_2_out_write : IN STD_LOGIC;
                 signal clock_2_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal clock_3_out_address_to_slave : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                 signal clock_3_out_read : IN STD_LOGIC;
                 signal clock_3_out_write : IN STD_LOGIC;
                 signal clock_3_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal epcs_controller_epcs_control_port_dataavailable : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_endofpacket : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_irq : IN STD_LOGIC;
                 signal epcs_controller_epcs_control_port_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal epcs_controller_epcs_control_port_readyfordata : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_2_out_granted_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal clock_2_out_qualified_request_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal clock_2_out_read_data_valid_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal clock_2_out_requests_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal clock_3_out_granted_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal clock_3_out_qualified_request_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal clock_3_out_read_data_valid_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal clock_3_out_requests_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                 signal d1_epcs_controller_epcs_control_port_end_xfer : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal epcs_controller_epcs_control_port_chipselect : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_dataavailable_from_sa : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_endofpacket_from_sa : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_irq_from_sa : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_read_n : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal epcs_controller_epcs_control_port_readyfordata_from_sa : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_reset_n : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_write_n : OUT STD_LOGIC;
                 signal epcs_controller_epcs_control_port_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of epcs_controller_epcs_control_port_arbitrator : entity is FALSE;
end entity epcs_controller_epcs_control_port_arbitrator;


architecture europa of epcs_controller_epcs_control_port_arbitrator is
                signal clock_2_out_arbiterlock :  STD_LOGIC;
                signal clock_2_out_arbiterlock2 :  STD_LOGIC;
                signal clock_2_out_continuerequest :  STD_LOGIC;
                signal clock_2_out_saved_grant_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_3_out_arbiterlock :  STD_LOGIC;
                signal clock_3_out_arbiterlock2 :  STD_LOGIC;
                signal clock_3_out_continuerequest :  STD_LOGIC;
                signal clock_3_out_saved_grant_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_allgrants :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_allow_new_arb_cycle :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_any_bursting_master_saved_grant :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_any_continuerequest :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_arb_addend :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal epcs_controller_epcs_control_port_arb_counter_enable :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_arb_share_counter :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_arb_share_counter_next_value :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_arb_share_set_values :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_arb_winner :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal epcs_controller_epcs_control_port_arbitration_holdoff_internal :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_beginbursttransfer_internal :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_begins_xfer :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_chosen_master_double_vector :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal epcs_controller_epcs_control_port_chosen_master_rot_left :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal epcs_controller_epcs_control_port_end_xfer :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_firsttransfer :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_grant_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal epcs_controller_epcs_control_port_in_a_read_cycle :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_in_a_write_cycle :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_master_qreq_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal epcs_controller_epcs_control_port_non_bursting_master_requests :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_reg_firsttransfer :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_saved_chosen_master_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal epcs_controller_epcs_control_port_slavearbiterlockenable :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_slavearbiterlockenable2 :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_unreg_firsttransfer :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_waits_for_read :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_waits_for_write :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_2_out_granted_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal internal_clock_2_out_qualified_request_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal internal_clock_2_out_requests_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal internal_clock_3_out_granted_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal internal_clock_3_out_qualified_request_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal internal_clock_3_out_requests_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal last_cycle_clock_2_out_granted_slave_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal last_cycle_clock_3_out_granted_slave_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal shifted_address_to_epcs_controller_epcs_control_port_from_clock_2_out :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal shifted_address_to_epcs_controller_epcs_control_port_from_clock_3_out :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal wait_for_epcs_controller_epcs_control_port_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT epcs_controller_epcs_control_port_end_xfer;
      end if;
    end if;

  end process;

  epcs_controller_epcs_control_port_begins_xfer <= NOT d1_reasons_to_wait AND ((internal_clock_2_out_qualified_request_epcs_controller_epcs_control_port OR internal_clock_3_out_qualified_request_epcs_controller_epcs_control_port));
  --assign epcs_controller_epcs_control_port_readdata_from_sa = epcs_controller_epcs_control_port_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  epcs_controller_epcs_control_port_readdata_from_sa <= epcs_controller_epcs_control_port_readdata;
  internal_clock_2_out_requests_epcs_controller_epcs_control_port <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_2_out_read OR clock_2_out_write)))))));
  --assign epcs_controller_epcs_control_port_dataavailable_from_sa = epcs_controller_epcs_control_port_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  epcs_controller_epcs_control_port_dataavailable_from_sa <= epcs_controller_epcs_control_port_dataavailable;
  --assign epcs_controller_epcs_control_port_readyfordata_from_sa = epcs_controller_epcs_control_port_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  epcs_controller_epcs_control_port_readyfordata_from_sa <= epcs_controller_epcs_control_port_readyfordata;
  --epcs_controller_epcs_control_port_arb_share_counter set values, which is an e_mux
  epcs_controller_epcs_control_port_arb_share_set_values <= std_logic'('1');
  --epcs_controller_epcs_control_port_non_bursting_master_requests mux, which is an e_mux
  epcs_controller_epcs_control_port_non_bursting_master_requests <= ((internal_clock_2_out_requests_epcs_controller_epcs_control_port OR internal_clock_3_out_requests_epcs_controller_epcs_control_port) OR internal_clock_2_out_requests_epcs_controller_epcs_control_port) OR internal_clock_3_out_requests_epcs_controller_epcs_control_port;
  --epcs_controller_epcs_control_port_any_bursting_master_saved_grant mux, which is an e_mux
  epcs_controller_epcs_control_port_any_bursting_master_saved_grant <= std_logic'('0');
  --epcs_controller_epcs_control_port_arb_share_counter_next_value assignment, which is an e_assign
  epcs_controller_epcs_control_port_arb_share_counter_next_value <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(epcs_controller_epcs_control_port_firsttransfer) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(epcs_controller_epcs_control_port_arb_share_set_values))) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(epcs_controller_epcs_control_port_arb_share_counter) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(epcs_controller_epcs_control_port_arb_share_counter))) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))));
  --epcs_controller_epcs_control_port_allgrants all slave grants, which is an e_mux
  epcs_controller_epcs_control_port_allgrants <= ((or_reduce(epcs_controller_epcs_control_port_grant_vector) OR or_reduce(epcs_controller_epcs_control_port_grant_vector)) OR or_reduce(epcs_controller_epcs_control_port_grant_vector)) OR or_reduce(epcs_controller_epcs_control_port_grant_vector);
  --epcs_controller_epcs_control_port_end_xfer assignment, which is an e_assign
  epcs_controller_epcs_control_port_end_xfer <= NOT ((epcs_controller_epcs_control_port_waits_for_read OR epcs_controller_epcs_control_port_waits_for_write));
  --end_xfer_arb_share_counter_term_epcs_controller_epcs_control_port arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_epcs_controller_epcs_control_port <= epcs_controller_epcs_control_port_end_xfer AND (((NOT epcs_controller_epcs_control_port_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --epcs_controller_epcs_control_port_arb_share_counter arbitration counter enable, which is an e_assign
  epcs_controller_epcs_control_port_arb_counter_enable <= ((end_xfer_arb_share_counter_term_epcs_controller_epcs_control_port AND epcs_controller_epcs_control_port_allgrants)) OR ((end_xfer_arb_share_counter_term_epcs_controller_epcs_control_port AND NOT epcs_controller_epcs_control_port_non_bursting_master_requests));
  --epcs_controller_epcs_control_port_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      epcs_controller_epcs_control_port_arb_share_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(epcs_controller_epcs_control_port_arb_counter_enable) = '1' then 
        epcs_controller_epcs_control_port_arb_share_counter <= epcs_controller_epcs_control_port_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --epcs_controller_epcs_control_port_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      epcs_controller_epcs_control_port_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((or_reduce(epcs_controller_epcs_control_port_master_qreq_vector) AND end_xfer_arb_share_counter_term_epcs_controller_epcs_control_port)) OR ((end_xfer_arb_share_counter_term_epcs_controller_epcs_control_port AND NOT epcs_controller_epcs_control_port_non_bursting_master_requests)))) = '1' then 
        epcs_controller_epcs_control_port_slavearbiterlockenable <= epcs_controller_epcs_control_port_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_2/out epcs_controller/epcs_control_port arbiterlock, which is an e_assign
  clock_2_out_arbiterlock <= epcs_controller_epcs_control_port_slavearbiterlockenable AND clock_2_out_continuerequest;
  --epcs_controller_epcs_control_port_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  epcs_controller_epcs_control_port_slavearbiterlockenable2 <= epcs_controller_epcs_control_port_arb_share_counter_next_value;
  --clock_2/out epcs_controller/epcs_control_port arbiterlock2, which is an e_assign
  clock_2_out_arbiterlock2 <= epcs_controller_epcs_control_port_slavearbiterlockenable2 AND clock_2_out_continuerequest;
  --clock_3/out epcs_controller/epcs_control_port arbiterlock, which is an e_assign
  clock_3_out_arbiterlock <= epcs_controller_epcs_control_port_slavearbiterlockenable AND clock_3_out_continuerequest;
  --clock_3/out epcs_controller/epcs_control_port arbiterlock2, which is an e_assign
  clock_3_out_arbiterlock2 <= epcs_controller_epcs_control_port_slavearbiterlockenable2 AND clock_3_out_continuerequest;
  --clock_3/out granted epcs_controller/epcs_control_port last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_clock_3_out_granted_slave_epcs_controller_epcs_control_port <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_clock_3_out_granted_slave_epcs_controller_epcs_control_port <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(clock_3_out_saved_grant_epcs_controller_epcs_control_port) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((epcs_controller_epcs_control_port_arbitration_holdoff_internal OR NOT internal_clock_3_out_requests_epcs_controller_epcs_control_port))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_clock_3_out_granted_slave_epcs_controller_epcs_control_port))))));
      end if;
    end if;

  end process;

  --clock_3_out_continuerequest continued request, which is an e_mux
  clock_3_out_continuerequest <= last_cycle_clock_3_out_granted_slave_epcs_controller_epcs_control_port AND internal_clock_3_out_requests_epcs_controller_epcs_control_port;
  --epcs_controller_epcs_control_port_any_continuerequest at least one master continues requesting, which is an e_mux
  epcs_controller_epcs_control_port_any_continuerequest <= clock_3_out_continuerequest OR clock_2_out_continuerequest;
  internal_clock_2_out_qualified_request_epcs_controller_epcs_control_port <= internal_clock_2_out_requests_epcs_controller_epcs_control_port AND NOT (clock_3_out_arbiterlock);
  --epcs_controller_epcs_control_port_writedata mux, which is an e_mux
  epcs_controller_epcs_control_port_writedata <= A_WE_StdLogicVector((std_logic'((internal_clock_2_out_granted_epcs_controller_epcs_control_port)) = '1'), clock_2_out_writedata, clock_3_out_writedata);
  --assign epcs_controller_epcs_control_port_endofpacket_from_sa = epcs_controller_epcs_control_port_endofpacket so that symbol knows where to group signals which may go to master only, which is an e_assign
  epcs_controller_epcs_control_port_endofpacket_from_sa <= epcs_controller_epcs_control_port_endofpacket;
  internal_clock_3_out_requests_epcs_controller_epcs_control_port <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_3_out_read OR clock_3_out_write)))))));
  --clock_2/out granted epcs_controller/epcs_control_port last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_clock_2_out_granted_slave_epcs_controller_epcs_control_port <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_clock_2_out_granted_slave_epcs_controller_epcs_control_port <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(clock_2_out_saved_grant_epcs_controller_epcs_control_port) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((epcs_controller_epcs_control_port_arbitration_holdoff_internal OR NOT internal_clock_2_out_requests_epcs_controller_epcs_control_port))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_clock_2_out_granted_slave_epcs_controller_epcs_control_port))))));
      end if;
    end if;

  end process;

  --clock_2_out_continuerequest continued request, which is an e_mux
  clock_2_out_continuerequest <= last_cycle_clock_2_out_granted_slave_epcs_controller_epcs_control_port AND internal_clock_2_out_requests_epcs_controller_epcs_control_port;
  internal_clock_3_out_qualified_request_epcs_controller_epcs_control_port <= internal_clock_3_out_requests_epcs_controller_epcs_control_port AND NOT (clock_2_out_arbiterlock);
  --allow new arb cycle for epcs_controller/epcs_control_port, which is an e_assign
  epcs_controller_epcs_control_port_allow_new_arb_cycle <= NOT clock_2_out_arbiterlock AND NOT clock_3_out_arbiterlock;
  --clock_3/out assignment into master qualified-requests vector for epcs_controller/epcs_control_port, which is an e_assign
  epcs_controller_epcs_control_port_master_qreq_vector(0) <= internal_clock_3_out_qualified_request_epcs_controller_epcs_control_port;
  --clock_3/out grant epcs_controller/epcs_control_port, which is an e_assign
  internal_clock_3_out_granted_epcs_controller_epcs_control_port <= epcs_controller_epcs_control_port_grant_vector(0);
  --clock_3/out saved-grant epcs_controller/epcs_control_port, which is an e_assign
  clock_3_out_saved_grant_epcs_controller_epcs_control_port <= epcs_controller_epcs_control_port_arb_winner(0) AND internal_clock_3_out_requests_epcs_controller_epcs_control_port;
  --clock_2/out assignment into master qualified-requests vector for epcs_controller/epcs_control_port, which is an e_assign
  epcs_controller_epcs_control_port_master_qreq_vector(1) <= internal_clock_2_out_qualified_request_epcs_controller_epcs_control_port;
  --clock_2/out grant epcs_controller/epcs_control_port, which is an e_assign
  internal_clock_2_out_granted_epcs_controller_epcs_control_port <= epcs_controller_epcs_control_port_grant_vector(1);
  --clock_2/out saved-grant epcs_controller/epcs_control_port, which is an e_assign
  clock_2_out_saved_grant_epcs_controller_epcs_control_port <= epcs_controller_epcs_control_port_arb_winner(1) AND internal_clock_2_out_requests_epcs_controller_epcs_control_port;
  --epcs_controller/epcs_control_port chosen-master double-vector, which is an e_assign
  epcs_controller_epcs_control_port_chosen_master_double_vector <= A_EXT (((std_logic_vector'("0") & ((epcs_controller_epcs_control_port_master_qreq_vector & epcs_controller_epcs_control_port_master_qreq_vector))) AND (((std_logic_vector'("0") & (Std_Logic_Vector'(NOT epcs_controller_epcs_control_port_master_qreq_vector & NOT epcs_controller_epcs_control_port_master_qreq_vector))) + (std_logic_vector'("000") & (epcs_controller_epcs_control_port_arb_addend))))), 4);
  --stable onehot encoding of arb winner
  epcs_controller_epcs_control_port_arb_winner <= A_WE_StdLogicVector((std_logic'(((epcs_controller_epcs_control_port_allow_new_arb_cycle AND or_reduce(epcs_controller_epcs_control_port_grant_vector)))) = '1'), epcs_controller_epcs_control_port_grant_vector, epcs_controller_epcs_control_port_saved_chosen_master_vector);
  --saved epcs_controller_epcs_control_port_grant_vector, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      epcs_controller_epcs_control_port_saved_chosen_master_vector <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(epcs_controller_epcs_control_port_allow_new_arb_cycle) = '1' then 
        epcs_controller_epcs_control_port_saved_chosen_master_vector <= A_WE_StdLogicVector((std_logic'(or_reduce(epcs_controller_epcs_control_port_grant_vector)) = '1'), epcs_controller_epcs_control_port_grant_vector, epcs_controller_epcs_control_port_saved_chosen_master_vector);
      end if;
    end if;

  end process;

  --onehot encoding of chosen master
  epcs_controller_epcs_control_port_grant_vector <= Std_Logic_Vector'(A_ToStdLogicVector(((epcs_controller_epcs_control_port_chosen_master_double_vector(1) OR epcs_controller_epcs_control_port_chosen_master_double_vector(3)))) & A_ToStdLogicVector(((epcs_controller_epcs_control_port_chosen_master_double_vector(0) OR epcs_controller_epcs_control_port_chosen_master_double_vector(2)))));
  --epcs_controller/epcs_control_port chosen master rotated left, which is an e_assign
  epcs_controller_epcs_control_port_chosen_master_rot_left <= A_EXT (A_WE_StdLogicVector((((A_SLL(epcs_controller_epcs_control_port_arb_winner,std_logic_vector'("00000000000000000000000000000001")))) /= std_logic_vector'("00")), (std_logic_vector'("000000000000000000000000000000") & ((A_SLL(epcs_controller_epcs_control_port_arb_winner,std_logic_vector'("00000000000000000000000000000001"))))), std_logic_vector'("00000000000000000000000000000001")), 2);
  --epcs_controller/epcs_control_port's addend for next-master-grant
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      epcs_controller_epcs_control_port_arb_addend <= std_logic_vector'("01");
    elsif clk'event and clk = '1' then
      if std_logic'(or_reduce(epcs_controller_epcs_control_port_grant_vector)) = '1' then 
        epcs_controller_epcs_control_port_arb_addend <= A_WE_StdLogicVector((std_logic'(epcs_controller_epcs_control_port_end_xfer) = '1'), epcs_controller_epcs_control_port_chosen_master_rot_left, epcs_controller_epcs_control_port_grant_vector);
      end if;
    end if;

  end process;

  --epcs_controller_epcs_control_port_reset_n assignment, which is an e_assign
  epcs_controller_epcs_control_port_reset_n <= reset_n;
  epcs_controller_epcs_control_port_chipselect <= internal_clock_2_out_granted_epcs_controller_epcs_control_port OR internal_clock_3_out_granted_epcs_controller_epcs_control_port;
  --epcs_controller_epcs_control_port_firsttransfer first transaction, which is an e_assign
  epcs_controller_epcs_control_port_firsttransfer <= A_WE_StdLogic((std_logic'(epcs_controller_epcs_control_port_begins_xfer) = '1'), epcs_controller_epcs_control_port_unreg_firsttransfer, epcs_controller_epcs_control_port_reg_firsttransfer);
  --epcs_controller_epcs_control_port_unreg_firsttransfer first transaction, which is an e_assign
  epcs_controller_epcs_control_port_unreg_firsttransfer <= NOT ((epcs_controller_epcs_control_port_slavearbiterlockenable AND epcs_controller_epcs_control_port_any_continuerequest));
  --epcs_controller_epcs_control_port_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      epcs_controller_epcs_control_port_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(epcs_controller_epcs_control_port_begins_xfer) = '1' then 
        epcs_controller_epcs_control_port_reg_firsttransfer <= epcs_controller_epcs_control_port_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --epcs_controller_epcs_control_port_beginbursttransfer_internal begin burst transfer, which is an e_assign
  epcs_controller_epcs_control_port_beginbursttransfer_internal <= epcs_controller_epcs_control_port_begins_xfer;
  --epcs_controller_epcs_control_port_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  epcs_controller_epcs_control_port_arbitration_holdoff_internal <= epcs_controller_epcs_control_port_begins_xfer AND epcs_controller_epcs_control_port_firsttransfer;
  --~epcs_controller_epcs_control_port_read_n assignment, which is an e_mux
  epcs_controller_epcs_control_port_read_n <= NOT ((((internal_clock_2_out_granted_epcs_controller_epcs_control_port AND clock_2_out_read)) OR ((internal_clock_3_out_granted_epcs_controller_epcs_control_port AND clock_3_out_read))));
  --~epcs_controller_epcs_control_port_write_n assignment, which is an e_mux
  epcs_controller_epcs_control_port_write_n <= NOT ((((internal_clock_2_out_granted_epcs_controller_epcs_control_port AND clock_2_out_write)) OR ((internal_clock_3_out_granted_epcs_controller_epcs_control_port AND clock_3_out_write))));
  shifted_address_to_epcs_controller_epcs_control_port_from_clock_2_out <= clock_2_out_address_to_slave;
  --epcs_controller_epcs_control_port_address mux, which is an e_mux
  epcs_controller_epcs_control_port_address <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_clock_2_out_granted_epcs_controller_epcs_control_port)) = '1'), (A_SRL(shifted_address_to_epcs_controller_epcs_control_port_from_clock_2_out,std_logic_vector'("00000000000000000000000000000010"))), (A_SRL(shifted_address_to_epcs_controller_epcs_control_port_from_clock_3_out,std_logic_vector'("00000000000000000000000000000010")))), 9);
  shifted_address_to_epcs_controller_epcs_control_port_from_clock_3_out <= clock_3_out_address_to_slave;
  --d1_epcs_controller_epcs_control_port_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_epcs_controller_epcs_control_port_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_epcs_controller_epcs_control_port_end_xfer <= epcs_controller_epcs_control_port_end_xfer;
      end if;
    end if;

  end process;

  --epcs_controller_epcs_control_port_waits_for_read in a cycle, which is an e_mux
  epcs_controller_epcs_control_port_waits_for_read <= epcs_controller_epcs_control_port_in_a_read_cycle AND epcs_controller_epcs_control_port_begins_xfer;
  --epcs_controller_epcs_control_port_in_a_read_cycle assignment, which is an e_assign
  epcs_controller_epcs_control_port_in_a_read_cycle <= ((internal_clock_2_out_granted_epcs_controller_epcs_control_port AND clock_2_out_read)) OR ((internal_clock_3_out_granted_epcs_controller_epcs_control_port AND clock_3_out_read));
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= epcs_controller_epcs_control_port_in_a_read_cycle;
  --epcs_controller_epcs_control_port_waits_for_write in a cycle, which is an e_mux
  epcs_controller_epcs_control_port_waits_for_write <= epcs_controller_epcs_control_port_in_a_write_cycle AND epcs_controller_epcs_control_port_begins_xfer;
  --epcs_controller_epcs_control_port_in_a_write_cycle assignment, which is an e_assign
  epcs_controller_epcs_control_port_in_a_write_cycle <= ((internal_clock_2_out_granted_epcs_controller_epcs_control_port AND clock_2_out_write)) OR ((internal_clock_3_out_granted_epcs_controller_epcs_control_port AND clock_3_out_write));
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= epcs_controller_epcs_control_port_in_a_write_cycle;
  wait_for_epcs_controller_epcs_control_port_counter <= std_logic'('0');
  --assign epcs_controller_epcs_control_port_irq_from_sa = epcs_controller_epcs_control_port_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  epcs_controller_epcs_control_port_irq_from_sa <= epcs_controller_epcs_control_port_irq;
  --vhdl renameroo for output signals
  clock_2_out_granted_epcs_controller_epcs_control_port <= internal_clock_2_out_granted_epcs_controller_epcs_control_port;
  --vhdl renameroo for output signals
  clock_2_out_qualified_request_epcs_controller_epcs_control_port <= internal_clock_2_out_qualified_request_epcs_controller_epcs_control_port;
  --vhdl renameroo for output signals
  clock_2_out_requests_epcs_controller_epcs_control_port <= internal_clock_2_out_requests_epcs_controller_epcs_control_port;
  --vhdl renameroo for output signals
  clock_3_out_granted_epcs_controller_epcs_control_port <= internal_clock_3_out_granted_epcs_controller_epcs_control_port;
  --vhdl renameroo for output signals
  clock_3_out_qualified_request_epcs_controller_epcs_control_port <= internal_clock_3_out_qualified_request_epcs_controller_epcs_control_port;
  --vhdl renameroo for output signals
  clock_3_out_requests_epcs_controller_epcs_control_port <= internal_clock_3_out_requests_epcs_controller_epcs_control_port;
--synthesis translate_off
    --epcs_controller/epcs_control_port enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

    --grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line28 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_clock_2_out_granted_epcs_controller_epcs_control_port))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_clock_3_out_granted_epcs_controller_epcs_control_port))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line28, now);
          write(write_line28, string'(": "));
          write(write_line28, string'("> 1 of grant signals are active simultaneously"));
          write(output, write_line28.all);
          deallocate (write_line28);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

    --saved_grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line29 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(clock_2_out_saved_grant_epcs_controller_epcs_control_port))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(clock_3_out_saved_grant_epcs_controller_epcs_control_port))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line29, now);
          write(write_line29, string'(": "));
          write(write_line29, string'("> 1 of saved_grant signals are active simultaneously"));
          write(output, write_line29.all);
          deallocate (write_line29);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity jtag_uart_0_avalon_jtag_slave_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_0_out_address_to_slave : IN STD_LOGIC_VECTOR (2 DOWNTO 0);
                 signal clock_0_out_nativeaddress : IN STD_LOGIC;
                 signal clock_0_out_read : IN STD_LOGIC;
                 signal clock_0_out_write : IN STD_LOGIC;
                 signal clock_0_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_0_avalon_jtag_slave_dataavailable : IN STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_irq : IN STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_0_avalon_jtag_slave_readyfordata : IN STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_waitrequest : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_0_out_granted_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                 signal clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                 signal clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                 signal clock_0_out_requests_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                 signal d1_jtag_uart_0_avalon_jtag_slave_end_xfer : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_address : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_chipselect : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_irq_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_read_n : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_reset_n : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_write_n : OUT STD_LOGIC;
                 signal jtag_uart_0_avalon_jtag_slave_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of jtag_uart_0_avalon_jtag_slave_arbitrator : entity is FALSE;
end entity jtag_uart_0_avalon_jtag_slave_arbitrator;


architecture europa of jtag_uart_0_avalon_jtag_slave_arbitrator is
                signal clock_0_out_arbiterlock :  STD_LOGIC;
                signal clock_0_out_arbiterlock2 :  STD_LOGIC;
                signal clock_0_out_continuerequest :  STD_LOGIC;
                signal clock_0_out_saved_grant_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal internal_clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal internal_clock_0_out_requests_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal internal_jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_allgrants :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_allow_new_arb_cycle :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_any_continuerequest :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_arb_counter_enable :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_arb_share_counter :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_arb_share_set_values :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_beginbursttransfer_internal :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_begins_xfer :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_end_xfer :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_firsttransfer :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_grant_vector :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_in_a_read_cycle :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_in_a_write_cycle :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_master_qreq_vector :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_reg_firsttransfer :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2 :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_waits_for_read :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_waits_for_write :  STD_LOGIC;
                signal wait_for_jtag_uart_0_avalon_jtag_slave_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT jtag_uart_0_avalon_jtag_slave_end_xfer;
      end if;
    end if;

  end process;

  jtag_uart_0_avalon_jtag_slave_begins_xfer <= NOT d1_reasons_to_wait AND (internal_clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave);
  --assign jtag_uart_0_avalon_jtag_slave_readdata_from_sa = jtag_uart_0_avalon_jtag_slave_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_readdata_from_sa <= jtag_uart_0_avalon_jtag_slave_readdata;
  internal_clock_0_out_requests_jtag_uart_0_avalon_jtag_slave <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_0_out_read OR clock_0_out_write)))))));
  --assign jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa = jtag_uart_0_avalon_jtag_slave_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa <= jtag_uart_0_avalon_jtag_slave_dataavailable;
  --assign jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa = jtag_uart_0_avalon_jtag_slave_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa <= jtag_uart_0_avalon_jtag_slave_readyfordata;
  --assign jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa = jtag_uart_0_avalon_jtag_slave_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa <= jtag_uart_0_avalon_jtag_slave_waitrequest;
  --jtag_uart_0_avalon_jtag_slave_arb_share_counter set values, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_arb_share_set_values <= std_logic'('1');
  --jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests mux, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests <= internal_clock_0_out_requests_jtag_uart_0_avalon_jtag_slave;
  --jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant mux, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant <= std_logic'('0');
  --jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value assignment, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(jtag_uart_0_avalon_jtag_slave_firsttransfer) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(jtag_uart_0_avalon_jtag_slave_arb_share_set_values))) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(jtag_uart_0_avalon_jtag_slave_arb_share_counter) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(jtag_uart_0_avalon_jtag_slave_arb_share_counter))) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))));
  --jtag_uart_0_avalon_jtag_slave_allgrants all slave grants, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_allgrants <= jtag_uart_0_avalon_jtag_slave_grant_vector;
  --jtag_uart_0_avalon_jtag_slave_end_xfer assignment, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_end_xfer <= NOT ((jtag_uart_0_avalon_jtag_slave_waits_for_read OR jtag_uart_0_avalon_jtag_slave_waits_for_write));
  --end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave <= jtag_uart_0_avalon_jtag_slave_end_xfer AND (((NOT jtag_uart_0_avalon_jtag_slave_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --jtag_uart_0_avalon_jtag_slave_arb_share_counter arbitration counter enable, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_arb_counter_enable <= ((end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave AND jtag_uart_0_avalon_jtag_slave_allgrants)) OR ((end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave AND NOT jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests));
  --jtag_uart_0_avalon_jtag_slave_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      jtag_uart_0_avalon_jtag_slave_arb_share_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(jtag_uart_0_avalon_jtag_slave_arb_counter_enable) = '1' then 
        jtag_uart_0_avalon_jtag_slave_arb_share_counter <= jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((jtag_uart_0_avalon_jtag_slave_master_qreq_vector AND end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave)) OR ((end_xfer_arb_share_counter_term_jtag_uart_0_avalon_jtag_slave AND NOT jtag_uart_0_avalon_jtag_slave_non_bursting_master_requests)))) = '1' then 
        jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable <= jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_0/out jtag_uart_0/avalon_jtag_slave arbiterlock, which is an e_assign
  clock_0_out_arbiterlock <= jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable AND clock_0_out_continuerequest;
  --jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2 <= jtag_uart_0_avalon_jtag_slave_arb_share_counter_next_value;
  --clock_0/out jtag_uart_0/avalon_jtag_slave arbiterlock2, which is an e_assign
  clock_0_out_arbiterlock2 <= jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable2 AND clock_0_out_continuerequest;
  --jtag_uart_0_avalon_jtag_slave_any_continuerequest at least one master continues requesting, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_any_continuerequest <= std_logic'('1');
  --clock_0_out_continuerequest continued request, which is an e_assign
  clock_0_out_continuerequest <= std_logic'('1');
  internal_clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave <= internal_clock_0_out_requests_jtag_uart_0_avalon_jtag_slave;
  --jtag_uart_0_avalon_jtag_slave_writedata mux, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_writedata <= clock_0_out_writedata;
  --master is always granted when requested
  internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave <= internal_clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave;
  --clock_0/out saved-grant jtag_uart_0/avalon_jtag_slave, which is an e_assign
  clock_0_out_saved_grant_jtag_uart_0_avalon_jtag_slave <= internal_clock_0_out_requests_jtag_uart_0_avalon_jtag_slave;
  --allow new arb cycle for jtag_uart_0/avalon_jtag_slave, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  jtag_uart_0_avalon_jtag_slave_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  jtag_uart_0_avalon_jtag_slave_master_qreq_vector <= std_logic'('1');
  --jtag_uart_0_avalon_jtag_slave_reset_n assignment, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_reset_n <= reset_n;
  jtag_uart_0_avalon_jtag_slave_chipselect <= internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave;
  --jtag_uart_0_avalon_jtag_slave_firsttransfer first transaction, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_firsttransfer <= A_WE_StdLogic((std_logic'(jtag_uart_0_avalon_jtag_slave_begins_xfer) = '1'), jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer, jtag_uart_0_avalon_jtag_slave_reg_firsttransfer);
  --jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer first transaction, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer <= NOT ((jtag_uart_0_avalon_jtag_slave_slavearbiterlockenable AND jtag_uart_0_avalon_jtag_slave_any_continuerequest));
  --jtag_uart_0_avalon_jtag_slave_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      jtag_uart_0_avalon_jtag_slave_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(jtag_uart_0_avalon_jtag_slave_begins_xfer) = '1' then 
        jtag_uart_0_avalon_jtag_slave_reg_firsttransfer <= jtag_uart_0_avalon_jtag_slave_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --jtag_uart_0_avalon_jtag_slave_beginbursttransfer_internal begin burst transfer, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_beginbursttransfer_internal <= jtag_uart_0_avalon_jtag_slave_begins_xfer;
  --~jtag_uart_0_avalon_jtag_slave_read_n assignment, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_read_n <= NOT ((internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave AND clock_0_out_read));
  --~jtag_uart_0_avalon_jtag_slave_write_n assignment, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_write_n <= NOT ((internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave AND clock_0_out_write));
  --jtag_uart_0_avalon_jtag_slave_address mux, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_address <= clock_0_out_nativeaddress;
  --d1_jtag_uart_0_avalon_jtag_slave_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_jtag_uart_0_avalon_jtag_slave_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_jtag_uart_0_avalon_jtag_slave_end_xfer <= jtag_uart_0_avalon_jtag_slave_end_xfer;
      end if;
    end if;

  end process;

  --jtag_uart_0_avalon_jtag_slave_waits_for_read in a cycle, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_waits_for_read <= jtag_uart_0_avalon_jtag_slave_in_a_read_cycle AND internal_jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;
  --jtag_uart_0_avalon_jtag_slave_in_a_read_cycle assignment, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_in_a_read_cycle <= internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave AND clock_0_out_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= jtag_uart_0_avalon_jtag_slave_in_a_read_cycle;
  --jtag_uart_0_avalon_jtag_slave_waits_for_write in a cycle, which is an e_mux
  jtag_uart_0_avalon_jtag_slave_waits_for_write <= jtag_uart_0_avalon_jtag_slave_in_a_write_cycle AND internal_jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;
  --jtag_uart_0_avalon_jtag_slave_in_a_write_cycle assignment, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_in_a_write_cycle <= internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave AND clock_0_out_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= jtag_uart_0_avalon_jtag_slave_in_a_write_cycle;
  wait_for_jtag_uart_0_avalon_jtag_slave_counter <= std_logic'('0');
  --assign jtag_uart_0_avalon_jtag_slave_irq_from_sa = jtag_uart_0_avalon_jtag_slave_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_0_avalon_jtag_slave_irq_from_sa <= jtag_uart_0_avalon_jtag_slave_irq;
  --vhdl renameroo for output signals
  clock_0_out_granted_jtag_uart_0_avalon_jtag_slave <= internal_clock_0_out_granted_jtag_uart_0_avalon_jtag_slave;
  --vhdl renameroo for output signals
  clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave <= internal_clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave;
  --vhdl renameroo for output signals
  clock_0_out_requests_jtag_uart_0_avalon_jtag_slave <= internal_clock_0_out_requests_jtag_uart_0_avalon_jtag_slave;
  --vhdl renameroo for output signals
  jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa <= internal_jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa;
--synthesis translate_off
    --jtag_uart_0/avalon_jtag_slave enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity linebuffer_inst_avalon_slave_0_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal clock_5_out_address_to_slave : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal clock_5_out_read : IN STD_LOGIC;
                 signal clock_5_out_write : IN STD_LOGIC;
                 signal clock_5_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal linebuffer_inst_avalon_slave_0_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal clock_5_out_granted_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal clock_5_out_requests_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                 signal d1_linebuffer_inst_avalon_slave_0_end_xfer : OUT STD_LOGIC;
                 signal linebuffer_inst_avalon_slave_0_address : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal linebuffer_inst_avalon_slave_0_chipselect : OUT STD_LOGIC;
                 signal linebuffer_inst_avalon_slave_0_read : OUT STD_LOGIC;
                 signal linebuffer_inst_avalon_slave_0_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal linebuffer_inst_avalon_slave_0_reset : OUT STD_LOGIC;
                 signal linebuffer_inst_avalon_slave_0_write : OUT STD_LOGIC;
                 signal linebuffer_inst_avalon_slave_0_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of linebuffer_inst_avalon_slave_0_arbitrator : entity is FALSE;
end entity linebuffer_inst_avalon_slave_0_arbitrator;


architecture europa of linebuffer_inst_avalon_slave_0_arbitrator is
                signal clock_5_out_arbiterlock :  STD_LOGIC;
                signal clock_5_out_arbiterlock2 :  STD_LOGIC;
                signal clock_5_out_continuerequest :  STD_LOGIC;
                signal clock_5_out_saved_grant_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal internal_clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal internal_clock_5_out_requests_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_allgrants :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_allow_new_arb_cycle :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_any_bursting_master_saved_grant :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_any_continuerequest :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_arb_counter_enable :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_arb_share_counter :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_arb_share_counter_next_value :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_arb_share_set_values :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_beginbursttransfer_internal :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_begins_xfer :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_end_xfer :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_firsttransfer :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_grant_vector :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_in_a_read_cycle :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_in_a_write_cycle :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_master_qreq_vector :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_non_bursting_master_requests :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_reg_firsttransfer :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_slavearbiterlockenable :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_slavearbiterlockenable2 :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_unreg_firsttransfer :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_waits_for_read :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_linebuffer_inst_avalon_slave_0_from_clock_5_out :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal wait_for_linebuffer_inst_avalon_slave_0_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT linebuffer_inst_avalon_slave_0_end_xfer;
      end if;
    end if;

  end process;

  linebuffer_inst_avalon_slave_0_begins_xfer <= NOT d1_reasons_to_wait AND (internal_clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0);
  --assign linebuffer_inst_avalon_slave_0_readdata_from_sa = linebuffer_inst_avalon_slave_0_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  linebuffer_inst_avalon_slave_0_readdata_from_sa <= linebuffer_inst_avalon_slave_0_readdata;
  internal_clock_5_out_requests_linebuffer_inst_avalon_slave_0 <= Vector_To_Std_Logic(((std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((clock_5_out_read OR clock_5_out_write)))))));
  --linebuffer_inst_avalon_slave_0_arb_share_counter set values, which is an e_mux
  linebuffer_inst_avalon_slave_0_arb_share_set_values <= std_logic'('1');
  --linebuffer_inst_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  linebuffer_inst_avalon_slave_0_non_bursting_master_requests <= internal_clock_5_out_requests_linebuffer_inst_avalon_slave_0;
  --linebuffer_inst_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  linebuffer_inst_avalon_slave_0_any_bursting_master_saved_grant <= std_logic'('0');
  --linebuffer_inst_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  linebuffer_inst_avalon_slave_0_arb_share_counter_next_value <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(linebuffer_inst_avalon_slave_0_firsttransfer) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(linebuffer_inst_avalon_slave_0_arb_share_set_values))) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(linebuffer_inst_avalon_slave_0_arb_share_counter) = '1'), (((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(linebuffer_inst_avalon_slave_0_arb_share_counter))) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))));
  --linebuffer_inst_avalon_slave_0_allgrants all slave grants, which is an e_mux
  linebuffer_inst_avalon_slave_0_allgrants <= linebuffer_inst_avalon_slave_0_grant_vector;
  --linebuffer_inst_avalon_slave_0_end_xfer assignment, which is an e_assign
  linebuffer_inst_avalon_slave_0_end_xfer <= NOT ((linebuffer_inst_avalon_slave_0_waits_for_read OR linebuffer_inst_avalon_slave_0_waits_for_write));
  --end_xfer_arb_share_counter_term_linebuffer_inst_avalon_slave_0 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_linebuffer_inst_avalon_slave_0 <= linebuffer_inst_avalon_slave_0_end_xfer AND (((NOT linebuffer_inst_avalon_slave_0_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --linebuffer_inst_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  linebuffer_inst_avalon_slave_0_arb_counter_enable <= ((end_xfer_arb_share_counter_term_linebuffer_inst_avalon_slave_0 AND linebuffer_inst_avalon_slave_0_allgrants)) OR ((end_xfer_arb_share_counter_term_linebuffer_inst_avalon_slave_0 AND NOT linebuffer_inst_avalon_slave_0_non_bursting_master_requests));
  --linebuffer_inst_avalon_slave_0_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      linebuffer_inst_avalon_slave_0_arb_share_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(linebuffer_inst_avalon_slave_0_arb_counter_enable) = '1' then 
        linebuffer_inst_avalon_slave_0_arb_share_counter <= linebuffer_inst_avalon_slave_0_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --linebuffer_inst_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      linebuffer_inst_avalon_slave_0_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((linebuffer_inst_avalon_slave_0_master_qreq_vector AND end_xfer_arb_share_counter_term_linebuffer_inst_avalon_slave_0)) OR ((end_xfer_arb_share_counter_term_linebuffer_inst_avalon_slave_0 AND NOT linebuffer_inst_avalon_slave_0_non_bursting_master_requests)))) = '1' then 
        linebuffer_inst_avalon_slave_0_slavearbiterlockenable <= linebuffer_inst_avalon_slave_0_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --clock_5/out linebuffer_inst/avalon_slave_0 arbiterlock, which is an e_assign
  clock_5_out_arbiterlock <= linebuffer_inst_avalon_slave_0_slavearbiterlockenable AND clock_5_out_continuerequest;
  --linebuffer_inst_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  linebuffer_inst_avalon_slave_0_slavearbiterlockenable2 <= linebuffer_inst_avalon_slave_0_arb_share_counter_next_value;
  --clock_5/out linebuffer_inst/avalon_slave_0 arbiterlock2, which is an e_assign
  clock_5_out_arbiterlock2 <= linebuffer_inst_avalon_slave_0_slavearbiterlockenable2 AND clock_5_out_continuerequest;
  --linebuffer_inst_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_assign
  linebuffer_inst_avalon_slave_0_any_continuerequest <= std_logic'('1');
  --clock_5_out_continuerequest continued request, which is an e_assign
  clock_5_out_continuerequest <= std_logic'('1');
  internal_clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 <= internal_clock_5_out_requests_linebuffer_inst_avalon_slave_0;
  --linebuffer_inst_avalon_slave_0_writedata mux, which is an e_mux
  linebuffer_inst_avalon_slave_0_writedata <= clock_5_out_writedata;
  --master is always granted when requested
  internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0 <= internal_clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0;
  --clock_5/out saved-grant linebuffer_inst/avalon_slave_0, which is an e_assign
  clock_5_out_saved_grant_linebuffer_inst_avalon_slave_0 <= internal_clock_5_out_requests_linebuffer_inst_avalon_slave_0;
  --allow new arb cycle for linebuffer_inst/avalon_slave_0, which is an e_assign
  linebuffer_inst_avalon_slave_0_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  linebuffer_inst_avalon_slave_0_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  linebuffer_inst_avalon_slave_0_master_qreq_vector <= std_logic'('1');
  --~linebuffer_inst_avalon_slave_0_reset assignment, which is an e_assign
  linebuffer_inst_avalon_slave_0_reset <= NOT reset_n;
  linebuffer_inst_avalon_slave_0_chipselect <= internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0;
  --linebuffer_inst_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  linebuffer_inst_avalon_slave_0_firsttransfer <= A_WE_StdLogic((std_logic'(linebuffer_inst_avalon_slave_0_begins_xfer) = '1'), linebuffer_inst_avalon_slave_0_unreg_firsttransfer, linebuffer_inst_avalon_slave_0_reg_firsttransfer);
  --linebuffer_inst_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  linebuffer_inst_avalon_slave_0_unreg_firsttransfer <= NOT ((linebuffer_inst_avalon_slave_0_slavearbiterlockenable AND linebuffer_inst_avalon_slave_0_any_continuerequest));
  --linebuffer_inst_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      linebuffer_inst_avalon_slave_0_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(linebuffer_inst_avalon_slave_0_begins_xfer) = '1' then 
        linebuffer_inst_avalon_slave_0_reg_firsttransfer <= linebuffer_inst_avalon_slave_0_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --linebuffer_inst_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  linebuffer_inst_avalon_slave_0_beginbursttransfer_internal <= linebuffer_inst_avalon_slave_0_begins_xfer;
  --linebuffer_inst_avalon_slave_0_read assignment, which is an e_mux
  linebuffer_inst_avalon_slave_0_read <= internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0 AND clock_5_out_read;
  --linebuffer_inst_avalon_slave_0_write assignment, which is an e_mux
  linebuffer_inst_avalon_slave_0_write <= internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0 AND clock_5_out_write;
  shifted_address_to_linebuffer_inst_avalon_slave_0_from_clock_5_out <= clock_5_out_address_to_slave;
  --linebuffer_inst_avalon_slave_0_address mux, which is an e_mux
  linebuffer_inst_avalon_slave_0_address <= A_EXT (A_SRL(shifted_address_to_linebuffer_inst_avalon_slave_0_from_clock_5_out,std_logic_vector'("00000000000000000000000000000001")), 8);
  --d1_linebuffer_inst_avalon_slave_0_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_linebuffer_inst_avalon_slave_0_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_linebuffer_inst_avalon_slave_0_end_xfer <= linebuffer_inst_avalon_slave_0_end_xfer;
      end if;
    end if;

  end process;

  --linebuffer_inst_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  linebuffer_inst_avalon_slave_0_waits_for_read <= linebuffer_inst_avalon_slave_0_in_a_read_cycle AND linebuffer_inst_avalon_slave_0_begins_xfer;
  --linebuffer_inst_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  linebuffer_inst_avalon_slave_0_in_a_read_cycle <= internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0 AND clock_5_out_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= linebuffer_inst_avalon_slave_0_in_a_read_cycle;
  --linebuffer_inst_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  linebuffer_inst_avalon_slave_0_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(linebuffer_inst_avalon_slave_0_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --linebuffer_inst_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  linebuffer_inst_avalon_slave_0_in_a_write_cycle <= internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0 AND clock_5_out_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= linebuffer_inst_avalon_slave_0_in_a_write_cycle;
  wait_for_linebuffer_inst_avalon_slave_0_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  clock_5_out_granted_linebuffer_inst_avalon_slave_0 <= internal_clock_5_out_granted_linebuffer_inst_avalon_slave_0;
  --vhdl renameroo for output signals
  clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 <= internal_clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0;
  --vhdl renameroo for output signals
  clock_5_out_requests_linebuffer_inst_avalon_slave_0 <= internal_clock_5_out_requests_linebuffer_inst_avalon_slave_0;
--synthesis translate_off
    --linebuffer_inst/avalon_slave_0 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module is 
        port (
              -- inputs:
                 signal clear_fifo : IN STD_LOGIC;
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal read : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sync_reset : IN STD_LOGIC;
                 signal write : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC;
                 signal empty : OUT STD_LOGIC;
                 signal fifo_contains_ones_n : OUT STD_LOGIC;
                 signal full : OUT STD_LOGIC
              );
end entity rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module;


architecture europa of rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module is
                signal full_0 :  STD_LOGIC;
                signal full_1 :  STD_LOGIC;
                signal full_2 :  STD_LOGIC;
                signal full_3 :  STD_LOGIC;
                signal full_4 :  STD_LOGIC;
                signal full_5 :  STD_LOGIC;
                signal full_6 :  STD_LOGIC;
                signal full_7 :  STD_LOGIC;
                signal how_many_ones :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal one_count_minus_one :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal one_count_plus_one :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal p0_full_0 :  STD_LOGIC;
                signal p0_stage_0 :  STD_LOGIC;
                signal p1_full_1 :  STD_LOGIC;
                signal p1_stage_1 :  STD_LOGIC;
                signal p2_full_2 :  STD_LOGIC;
                signal p2_stage_2 :  STD_LOGIC;
                signal p3_full_3 :  STD_LOGIC;
                signal p3_stage_3 :  STD_LOGIC;
                signal p4_full_4 :  STD_LOGIC;
                signal p4_stage_4 :  STD_LOGIC;
                signal p5_full_5 :  STD_LOGIC;
                signal p5_stage_5 :  STD_LOGIC;
                signal p6_full_6 :  STD_LOGIC;
                signal p6_stage_6 :  STD_LOGIC;
                signal stage_0 :  STD_LOGIC;
                signal stage_1 :  STD_LOGIC;
                signal stage_2 :  STD_LOGIC;
                signal stage_3 :  STD_LOGIC;
                signal stage_4 :  STD_LOGIC;
                signal stage_5 :  STD_LOGIC;
                signal stage_6 :  STD_LOGIC;
                signal updated_one_count :  STD_LOGIC_VECTOR (3 DOWNTO 0);

begin

  data_out <= stage_0;
  full <= full_6;
  empty <= NOT(full_0);
  full_7 <= std_logic'('0');
  --data_6, which is an e_mux
  p6_stage_6 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_7 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, data_in);
  --data_reg_6, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_6 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_6))))) = '1' then 
        if std_logic'(((sync_reset AND full_6) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_7))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_6 <= std_logic'('0');
        else
          stage_6 <= p6_stage_6;
        end if;
      end if;
    end if;

  end process;

  --control_6, which is an e_mux
  p6_full_6 <= Vector_To_Std_Logic(A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_5))), std_logic_vector'("00000000000000000000000000000000")));
  --control_reg_6, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_6 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_6 <= std_logic'('0');
        else
          full_6 <= p6_full_6;
        end if;
      end if;
    end if;

  end process;

  --data_5, which is an e_mux
  p5_stage_5 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_6 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_6);
  --data_reg_5, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_5 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_5))))) = '1' then 
        if std_logic'(((sync_reset AND full_5) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_6))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_5 <= std_logic'('0');
        else
          stage_5 <= p5_stage_5;
        end if;
      end if;
    end if;

  end process;

  --control_5, which is an e_mux
  p5_full_5 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_4, full_6);
  --control_reg_5, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_5 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_5 <= std_logic'('0');
        else
          full_5 <= p5_full_5;
        end if;
      end if;
    end if;

  end process;

  --data_4, which is an e_mux
  p4_stage_4 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_5 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_5);
  --data_reg_4, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_4 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_4))))) = '1' then 
        if std_logic'(((sync_reset AND full_4) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_5))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_4 <= std_logic'('0');
        else
          stage_4 <= p4_stage_4;
        end if;
      end if;
    end if;

  end process;

  --control_4, which is an e_mux
  p4_full_4 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_3, full_5);
  --control_reg_4, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_4 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_4 <= std_logic'('0');
        else
          full_4 <= p4_full_4;
        end if;
      end if;
    end if;

  end process;

  --data_3, which is an e_mux
  p3_stage_3 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_4 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_4);
  --data_reg_3, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_3 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_3))))) = '1' then 
        if std_logic'(((sync_reset AND full_3) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_4))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_3 <= std_logic'('0');
        else
          stage_3 <= p3_stage_3;
        end if;
      end if;
    end if;

  end process;

  --control_3, which is an e_mux
  p3_full_3 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_2, full_4);
  --control_reg_3, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_3 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_3 <= std_logic'('0');
        else
          full_3 <= p3_full_3;
        end if;
      end if;
    end if;

  end process;

  --data_2, which is an e_mux
  p2_stage_2 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_3 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_3);
  --data_reg_2, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_2 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_2))))) = '1' then 
        if std_logic'(((sync_reset AND full_2) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_3))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_2 <= std_logic'('0');
        else
          stage_2 <= p2_stage_2;
        end if;
      end if;
    end if;

  end process;

  --control_2, which is an e_mux
  p2_full_2 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_1, full_3);
  --control_reg_2, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_2 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_2 <= std_logic'('0');
        else
          full_2 <= p2_full_2;
        end if;
      end if;
    end if;

  end process;

  --data_1, which is an e_mux
  p1_stage_1 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_2 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_2);
  --data_reg_1, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_1))))) = '1' then 
        if std_logic'(((sync_reset AND full_1) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_2))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_1 <= std_logic'('0');
        else
          stage_1 <= p1_stage_1;
        end if;
      end if;
    end if;

  end process;

  --control_1, which is an e_mux
  p1_full_1 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_0, full_2);
  --control_reg_1, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_1 <= std_logic'('0');
        else
          full_1 <= p1_full_1;
        end if;
      end if;
    end if;

  end process;

  --data_0, which is an e_mux
  p0_stage_0 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_1 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_1);
  --data_reg_0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_0 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(((sync_reset AND full_0) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_1))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_0 <= std_logic'('0');
        else
          stage_0 <= p0_stage_0;
        end if;
      end if;
    end if;

  end process;

  --control_0, which is an e_mux
  p0_full_0 <= Vector_To_Std_Logic(A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), std_logic_vector'("00000000000000000000000000000001"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_1)))));
  --control_reg_0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_0 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'((clear_fifo AND NOT write)) = '1' then 
          full_0 <= std_logic'('0');
        else
          full_0 <= p0_full_0;
        end if;
      end if;
    end if;

  end process;

  one_count_plus_one <= A_EXT (((std_logic_vector'("00000000000000000000000000000") & (how_many_ones)) + std_logic_vector'("000000000000000000000000000000001")), 4);
  one_count_minus_one <= A_EXT (((std_logic_vector'("00000000000000000000000000000") & (how_many_ones)) - std_logic_vector'("000000000000000000000000000000001")), 4);
  --updated_one_count, which is an e_mux
  updated_one_count <= A_EXT (A_WE_StdLogicVector((std_logic'(((((clear_fifo OR sync_reset)) AND NOT(write)))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000") & (A_WE_StdLogicVector((std_logic'(((((clear_fifo OR sync_reset)) AND write))) = '1'), (std_logic_vector'("000") & (A_TOSTDLOGICVECTOR(data_in))), A_WE_StdLogicVector((std_logic'(((((read AND (data_in)) AND write) AND (stage_0)))) = '1'), how_many_ones, A_WE_StdLogicVector((std_logic'(((write AND (data_in)))) = '1'), one_count_plus_one, A_WE_StdLogicVector((std_logic'(((read AND (stage_0)))) = '1'), one_count_minus_one, how_many_ones))))))), 4);
  --counts how many ones in the data pipeline, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      how_many_ones <= std_logic_vector'("0000");
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR write)) = '1' then 
        how_many_ones <= updated_one_count;
      end if;
    end if;

  end process;

  --this fifo contains ones in the data pipeline, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      fifo_contains_ones_n <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR write)) = '1' then 
        fifo_contains_ones_n <= NOT (or_reduce(updated_one_count));
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1_module is 
        port (
              -- inputs:
                 signal clear_fifo : IN STD_LOGIC;
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal read : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sync_reset : IN STD_LOGIC;
                 signal write : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC;
                 signal empty : OUT STD_LOGIC;
                 signal fifo_contains_ones_n : OUT STD_LOGIC;
                 signal full : OUT STD_LOGIC
              );
end entity rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1_module;


architecture europa of rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1_module is
                signal full_0 :  STD_LOGIC;
                signal full_1 :  STD_LOGIC;
                signal full_2 :  STD_LOGIC;
                signal full_3 :  STD_LOGIC;
                signal full_4 :  STD_LOGIC;
                signal full_5 :  STD_LOGIC;
                signal full_6 :  STD_LOGIC;
                signal full_7 :  STD_LOGIC;
                signal how_many_ones :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal one_count_minus_one :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal one_count_plus_one :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal p0_full_0 :  STD_LOGIC;
                signal p0_stage_0 :  STD_LOGIC;
                signal p1_full_1 :  STD_LOGIC;
                signal p1_stage_1 :  STD_LOGIC;
                signal p2_full_2 :  STD_LOGIC;
                signal p2_stage_2 :  STD_LOGIC;
                signal p3_full_3 :  STD_LOGIC;
                signal p3_stage_3 :  STD_LOGIC;
                signal p4_full_4 :  STD_LOGIC;
                signal p4_stage_4 :  STD_LOGIC;
                signal p5_full_5 :  STD_LOGIC;
                signal p5_stage_5 :  STD_LOGIC;
                signal p6_full_6 :  STD_LOGIC;
                signal p6_stage_6 :  STD_LOGIC;
                signal stage_0 :  STD_LOGIC;
                signal stage_1 :  STD_LOGIC;
                signal stage_2 :  STD_LOGIC;
                signal stage_3 :  STD_LOGIC;
                signal stage_4 :  STD_LOGIC;
                signal stage_5 :  STD_LOGIC;
                signal stage_6 :  STD_LOGIC;
                signal updated_one_count :  STD_LOGIC_VECTOR (3 DOWNTO 0);

begin

  data_out <= stage_0;
  full <= full_6;
  empty <= NOT(full_0);
  full_7 <= std_logic'('0');
  --data_6, which is an e_mux
  p6_stage_6 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_7 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, data_in);
  --data_reg_6, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_6 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_6))))) = '1' then 
        if std_logic'(((sync_reset AND full_6) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_7))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_6 <= std_logic'('0');
        else
          stage_6 <= p6_stage_6;
        end if;
      end if;
    end if;

  end process;

  --control_6, which is an e_mux
  p6_full_6 <= Vector_To_Std_Logic(A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_5))), std_logic_vector'("00000000000000000000000000000000")));
  --control_reg_6, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_6 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_6 <= std_logic'('0');
        else
          full_6 <= p6_full_6;
        end if;
      end if;
    end if;

  end process;

  --data_5, which is an e_mux
  p5_stage_5 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_6 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_6);
  --data_reg_5, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_5 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_5))))) = '1' then 
        if std_logic'(((sync_reset AND full_5) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_6))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_5 <= std_logic'('0');
        else
          stage_5 <= p5_stage_5;
        end if;
      end if;
    end if;

  end process;

  --control_5, which is an e_mux
  p5_full_5 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_4, full_6);
  --control_reg_5, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_5 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_5 <= std_logic'('0');
        else
          full_5 <= p5_full_5;
        end if;
      end if;
    end if;

  end process;

  --data_4, which is an e_mux
  p4_stage_4 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_5 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_5);
  --data_reg_4, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_4 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_4))))) = '1' then 
        if std_logic'(((sync_reset AND full_4) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_5))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_4 <= std_logic'('0');
        else
          stage_4 <= p4_stage_4;
        end if;
      end if;
    end if;

  end process;

  --control_4, which is an e_mux
  p4_full_4 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_3, full_5);
  --control_reg_4, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_4 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_4 <= std_logic'('0');
        else
          full_4 <= p4_full_4;
        end if;
      end if;
    end if;

  end process;

  --data_3, which is an e_mux
  p3_stage_3 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_4 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_4);
  --data_reg_3, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_3 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_3))))) = '1' then 
        if std_logic'(((sync_reset AND full_3) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_4))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_3 <= std_logic'('0');
        else
          stage_3 <= p3_stage_3;
        end if;
      end if;
    end if;

  end process;

  --control_3, which is an e_mux
  p3_full_3 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_2, full_4);
  --control_reg_3, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_3 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_3 <= std_logic'('0');
        else
          full_3 <= p3_full_3;
        end if;
      end if;
    end if;

  end process;

  --data_2, which is an e_mux
  p2_stage_2 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_3 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_3);
  --data_reg_2, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_2 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_2))))) = '1' then 
        if std_logic'(((sync_reset AND full_2) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_3))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_2 <= std_logic'('0');
        else
          stage_2 <= p2_stage_2;
        end if;
      end if;
    end if;

  end process;

  --control_2, which is an e_mux
  p2_full_2 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_1, full_3);
  --control_reg_2, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_2 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_2 <= std_logic'('0');
        else
          full_2 <= p2_full_2;
        end if;
      end if;
    end if;

  end process;

  --data_1, which is an e_mux
  p1_stage_1 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_2 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_2);
  --data_reg_1, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_1))))) = '1' then 
        if std_logic'(((sync_reset AND full_1) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_2))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_1 <= std_logic'('0');
        else
          stage_1 <= p1_stage_1;
        end if;
      end if;
    end if;

  end process;

  --control_1, which is an e_mux
  p1_full_1 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), full_0, full_2);
  --control_reg_1, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(clear_fifo) = '1' then 
          full_1 <= std_logic'('0');
        else
          full_1 <= p1_full_1;
        end if;
      end if;
    end if;

  end process;

  --data_0, which is an e_mux
  p0_stage_0 <= A_WE_StdLogic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((full_1 AND NOT clear_fifo))))) = std_logic_vector'("00000000000000000000000000000000"))), data_in, stage_1);
  --data_reg_0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      stage_0 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'(((sync_reset AND full_0) AND NOT((((to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_1))) = std_logic_vector'("00000000000000000000000000000000")))) AND read) AND write))))) = '1' then 
          stage_0 <= std_logic'('0');
        else
          stage_0 <= p0_stage_0;
        end if;
      end if;
    end if;

  end process;

  --control_0, which is an e_mux
  p0_full_0 <= Vector_To_Std_Logic(A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((read AND NOT(write)))))) = std_logic_vector'("00000000000000000000000000000000"))), std_logic_vector'("00000000000000000000000000000001"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(full_1)))));
  --control_reg_0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      full_0 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'(((clear_fifo OR ((read XOR write))) OR ((write AND NOT(full_0))))) = '1' then 
        if std_logic'((clear_fifo AND NOT write)) = '1' then 
          full_0 <= std_logic'('0');
        else
          full_0 <= p0_full_0;
        end if;
      end if;
    end if;

  end process;

  one_count_plus_one <= A_EXT (((std_logic_vector'("00000000000000000000000000000") & (how_many_ones)) + std_logic_vector'("000000000000000000000000000000001")), 4);
  one_count_minus_one <= A_EXT (((std_logic_vector'("00000000000000000000000000000") & (how_many_ones)) - std_logic_vector'("000000000000000000000000000000001")), 4);
  --updated_one_count, which is an e_mux
  updated_one_count <= A_EXT (A_WE_StdLogicVector((std_logic'(((((clear_fifo OR sync_reset)) AND NOT(write)))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000") & (A_WE_StdLogicVector((std_logic'(((((clear_fifo OR sync_reset)) AND write))) = '1'), (std_logic_vector'("000") & (A_TOSTDLOGICVECTOR(data_in))), A_WE_StdLogicVector((std_logic'(((((read AND (data_in)) AND write) AND (stage_0)))) = '1'), how_many_ones, A_WE_StdLogicVector((std_logic'(((write AND (data_in)))) = '1'), one_count_plus_one, A_WE_StdLogicVector((std_logic'(((read AND (stage_0)))) = '1'), one_count_minus_one, how_many_ones))))))), 4);
  --counts how many ones in the data pipeline, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      how_many_ones <= std_logic_vector'("0000");
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR write)) = '1' then 
        how_many_ones <= updated_one_count;
      end if;
    end if;

  end process;

  --this fifo contains ones in the data pipeline, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      fifo_contains_ones_n <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'((((clear_fifo OR sync_reset) OR read) OR write)) = '1' then 
        fifo_contains_ones_n <= NOT (or_reduce(updated_one_count));
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity sdram_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_0_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_0_data_master_no_byte_enables_and_last_term : IN STD_LOGIC;
                 signal cpu_0_data_master_read : IN STD_LOGIC;
                 signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                 signal cpu_0_data_master_write : IN STD_LOGIC;
                 signal cpu_0_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                 signal cpu_0_instruction_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_instruction_master_latency_counter : IN STD_LOGIC;
                 signal cpu_0_instruction_master_read : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sdram_s1_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal sdram_s1_readdatavalid : IN STD_LOGIC;
                 signal sdram_s1_waitrequest : IN STD_LOGIC;

              -- outputs:
                 signal cpu_0_data_master_byteenable_sdram_s1 : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_0_data_master_granted_sdram_s1 : OUT STD_LOGIC;
                 signal cpu_0_data_master_qualified_request_sdram_s1 : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_sdram_s1 : OUT STD_LOGIC;
                 signal cpu_0_data_master_read_data_valid_sdram_s1_shift_register : OUT STD_LOGIC;
                 signal cpu_0_data_master_requests_sdram_s1 : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_granted_sdram_s1 : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_qualified_request_sdram_s1 : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_sdram_s1 : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : OUT STD_LOGIC;
                 signal cpu_0_instruction_master_requests_sdram_s1 : OUT STD_LOGIC;
                 signal d1_sdram_s1_end_xfer : OUT STD_LOGIC;
                 signal sdram_s1_address : OUT STD_LOGIC_VECTOR (21 DOWNTO 0);
                 signal sdram_s1_byteenable_n : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal sdram_s1_chipselect : OUT STD_LOGIC;
                 signal sdram_s1_read_n : OUT STD_LOGIC;
                 signal sdram_s1_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal sdram_s1_reset_n : OUT STD_LOGIC;
                 signal sdram_s1_waitrequest_from_sa : OUT STD_LOGIC;
                 signal sdram_s1_write_n : OUT STD_LOGIC;
                 signal sdram_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of sdram_s1_arbitrator : entity is FALSE;
end entity sdram_s1_arbitrator;


architecture europa of sdram_s1_arbitrator is
component rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module is 
           port (
                 -- inputs:
                    signal clear_fifo : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sync_reset : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC;
                    signal empty : OUT STD_LOGIC;
                    signal fifo_contains_ones_n : OUT STD_LOGIC;
                    signal full : OUT STD_LOGIC
                 );
end component rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module;

component rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1_module is 
           port (
                 -- inputs:
                    signal clear_fifo : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sync_reset : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC;
                    signal empty : OUT STD_LOGIC;
                    signal fifo_contains_ones_n : OUT STD_LOGIC;
                    signal full : OUT STD_LOGIC
                 );
end component rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1_module;

                signal cpu_0_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_data_master_byteenable_sdram_s1_segment_0 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_byteenable_sdram_s1_segment_1 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_continuerequest :  STD_LOGIC;
                signal cpu_0_data_master_rdv_fifo_empty_sdram_s1 :  STD_LOGIC;
                signal cpu_0_data_master_rdv_fifo_output_from_sdram_s1 :  STD_LOGIC;
                signal cpu_0_data_master_saved_grant_sdram_s1 :  STD_LOGIC;
                signal cpu_0_instruction_master_arbiterlock :  STD_LOGIC;
                signal cpu_0_instruction_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_0_instruction_master_continuerequest :  STD_LOGIC;
                signal cpu_0_instruction_master_rdv_fifo_empty_sdram_s1 :  STD_LOGIC;
                signal cpu_0_instruction_master_rdv_fifo_output_from_sdram_s1 :  STD_LOGIC;
                signal cpu_0_instruction_master_saved_grant_sdram_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_sdram_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_0_data_master_byteenable_sdram_s1 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_0_data_master_granted_sdram_s1 :  STD_LOGIC;
                signal internal_cpu_0_data_master_qualified_request_sdram_s1 :  STD_LOGIC;
                signal internal_cpu_0_data_master_read_data_valid_sdram_s1_shift_register :  STD_LOGIC;
                signal internal_cpu_0_data_master_requests_sdram_s1 :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_granted_sdram_s1 :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_qualified_request_sdram_s1 :  STD_LOGIC;
                signal internal_cpu_0_instruction_master_requests_sdram_s1 :  STD_LOGIC;
                signal internal_sdram_s1_waitrequest_from_sa :  STD_LOGIC;
                signal last_cycle_cpu_0_data_master_granted_slave_sdram_s1 :  STD_LOGIC;
                signal last_cycle_cpu_0_instruction_master_granted_slave_sdram_s1 :  STD_LOGIC;
                signal module_input :  STD_LOGIC;
                signal module_input1 :  STD_LOGIC;
                signal module_input2 :  STD_LOGIC;
                signal module_input3 :  STD_LOGIC;
                signal module_input4 :  STD_LOGIC;
                signal module_input5 :  STD_LOGIC;
                signal sdram_s1_allgrants :  STD_LOGIC;
                signal sdram_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal sdram_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal sdram_s1_any_continuerequest :  STD_LOGIC;
                signal sdram_s1_arb_addend :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_arb_counter_enable :  STD_LOGIC;
                signal sdram_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_arb_winner :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_arbitration_holdoff_internal :  STD_LOGIC;
                signal sdram_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal sdram_s1_begins_xfer :  STD_LOGIC;
                signal sdram_s1_chosen_master_double_vector :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal sdram_s1_chosen_master_rot_left :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_end_xfer :  STD_LOGIC;
                signal sdram_s1_firsttransfer :  STD_LOGIC;
                signal sdram_s1_grant_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_in_a_read_cycle :  STD_LOGIC;
                signal sdram_s1_in_a_write_cycle :  STD_LOGIC;
                signal sdram_s1_master_qreq_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_move_on_to_next_transaction :  STD_LOGIC;
                signal sdram_s1_non_bursting_master_requests :  STD_LOGIC;
                signal sdram_s1_readdatavalid_from_sa :  STD_LOGIC;
                signal sdram_s1_reg_firsttransfer :  STD_LOGIC;
                signal sdram_s1_saved_chosen_master_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_slavearbiterlockenable :  STD_LOGIC;
                signal sdram_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal sdram_s1_unreg_firsttransfer :  STD_LOGIC;
                signal sdram_s1_waits_for_read :  STD_LOGIC;
                signal sdram_s1_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_sdram_s1_from_cpu_0_data_master :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal shifted_address_to_sdram_s1_from_cpu_0_instruction_master :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal wait_for_sdram_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT sdram_s1_end_xfer;
      end if;
    end if;

  end process;

  sdram_s1_begins_xfer <= NOT d1_reasons_to_wait AND ((internal_cpu_0_data_master_qualified_request_sdram_s1 OR internal_cpu_0_instruction_master_qualified_request_sdram_s1));
  --assign sdram_s1_readdatavalid_from_sa = sdram_s1_readdatavalid so that symbol knows where to group signals which may go to master only, which is an e_assign
  sdram_s1_readdatavalid_from_sa <= sdram_s1_readdatavalid;
  --assign sdram_s1_readdata_from_sa = sdram_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  sdram_s1_readdata_from_sa <= sdram_s1_readdata;
  internal_cpu_0_data_master_requests_sdram_s1 <= to_std_logic(((Std_Logic_Vector'(cpu_0_data_master_address_to_slave(24 DOWNTO 23) & std_logic_vector'("00000000000000000000000")) = std_logic_vector'("0100000000000000000000000")))) AND ((cpu_0_data_master_read OR cpu_0_data_master_write));
  --assign sdram_s1_waitrequest_from_sa = sdram_s1_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_sdram_s1_waitrequest_from_sa <= sdram_s1_waitrequest;
  --sdram_s1_arb_share_counter set values, which is an e_mux
  sdram_s1_arb_share_set_values <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_sdram_s1)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((internal_cpu_0_instruction_master_granted_sdram_s1)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_sdram_s1)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((internal_cpu_0_instruction_master_granted_sdram_s1)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000001"))))), 2);
  --sdram_s1_non_bursting_master_requests mux, which is an e_mux
  sdram_s1_non_bursting_master_requests <= ((internal_cpu_0_data_master_requests_sdram_s1 OR internal_cpu_0_instruction_master_requests_sdram_s1) OR internal_cpu_0_data_master_requests_sdram_s1) OR internal_cpu_0_instruction_master_requests_sdram_s1;
  --sdram_s1_any_bursting_master_saved_grant mux, which is an e_mux
  sdram_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --sdram_s1_arb_share_counter_next_value assignment, which is an e_assign
  sdram_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(sdram_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (sdram_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(sdram_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (sdram_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --sdram_s1_allgrants all slave grants, which is an e_mux
  sdram_s1_allgrants <= ((or_reduce(sdram_s1_grant_vector) OR or_reduce(sdram_s1_grant_vector)) OR or_reduce(sdram_s1_grant_vector)) OR or_reduce(sdram_s1_grant_vector);
  --sdram_s1_end_xfer assignment, which is an e_assign
  sdram_s1_end_xfer <= NOT ((sdram_s1_waits_for_read OR sdram_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_sdram_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_sdram_s1 <= sdram_s1_end_xfer AND (((NOT sdram_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --sdram_s1_arb_share_counter arbitration counter enable, which is an e_assign
  sdram_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_sdram_s1 AND sdram_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_sdram_s1 AND NOT sdram_s1_non_bursting_master_requests));
  --sdram_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sdram_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(sdram_s1_arb_counter_enable) = '1' then 
        sdram_s1_arb_share_counter <= sdram_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --sdram_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sdram_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((or_reduce(sdram_s1_master_qreq_vector) AND end_xfer_arb_share_counter_term_sdram_s1)) OR ((end_xfer_arb_share_counter_term_sdram_s1 AND NOT sdram_s1_non_bursting_master_requests)))) = '1' then 
        sdram_s1_slavearbiterlockenable <= or_reduce(sdram_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu_0/data_master sdram/s1 arbiterlock, which is an e_assign
  cpu_0_data_master_arbiterlock <= sdram_s1_slavearbiterlockenable AND cpu_0_data_master_continuerequest;
  --sdram_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  sdram_s1_slavearbiterlockenable2 <= or_reduce(sdram_s1_arb_share_counter_next_value);
  --cpu_0/data_master sdram/s1 arbiterlock2, which is an e_assign
  cpu_0_data_master_arbiterlock2 <= sdram_s1_slavearbiterlockenable2 AND cpu_0_data_master_continuerequest;
  --cpu_0/instruction_master sdram/s1 arbiterlock, which is an e_assign
  cpu_0_instruction_master_arbiterlock <= sdram_s1_slavearbiterlockenable AND cpu_0_instruction_master_continuerequest;
  --cpu_0/instruction_master sdram/s1 arbiterlock2, which is an e_assign
  cpu_0_instruction_master_arbiterlock2 <= sdram_s1_slavearbiterlockenable2 AND cpu_0_instruction_master_continuerequest;
  --cpu_0/instruction_master granted sdram/s1 last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_0_instruction_master_granted_slave_sdram_s1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_0_instruction_master_granted_slave_sdram_s1 <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_0_instruction_master_saved_grant_sdram_s1) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((sdram_s1_arbitration_holdoff_internal OR NOT internal_cpu_0_instruction_master_requests_sdram_s1))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_0_instruction_master_granted_slave_sdram_s1))))));
      end if;
    end if;

  end process;

  --cpu_0_instruction_master_continuerequest continued request, which is an e_mux
  cpu_0_instruction_master_continuerequest <= last_cycle_cpu_0_instruction_master_granted_slave_sdram_s1 AND internal_cpu_0_instruction_master_requests_sdram_s1;
  --sdram_s1_any_continuerequest at least one master continues requesting, which is an e_mux
  sdram_s1_any_continuerequest <= cpu_0_instruction_master_continuerequest OR cpu_0_data_master_continuerequest;
  internal_cpu_0_data_master_qualified_request_sdram_s1 <= internal_cpu_0_data_master_requests_sdram_s1 AND NOT (((((cpu_0_data_master_read AND ((NOT cpu_0_data_master_waitrequest OR (internal_cpu_0_data_master_read_data_valid_sdram_s1_shift_register))))) OR (((((NOT cpu_0_data_master_waitrequest OR cpu_0_data_master_no_byte_enables_and_last_term) OR NOT(or_reduce(internal_cpu_0_data_master_byteenable_sdram_s1)))) AND cpu_0_data_master_write))) OR cpu_0_instruction_master_arbiterlock));
  --unique name for sdram_s1_move_on_to_next_transaction, which is an e_assign
  sdram_s1_move_on_to_next_transaction <= sdram_s1_readdatavalid_from_sa;
  --rdv_fifo_for_cpu_0_data_master_to_sdram_s1, which is an e_fifo_with_registered_outputs
  rdv_fifo_for_cpu_0_data_master_to_sdram_s1 : rdv_fifo_for_cpu_0_data_master_to_sdram_s1_module
    port map(
      data_out => cpu_0_data_master_rdv_fifo_output_from_sdram_s1,
      empty => open,
      fifo_contains_ones_n => cpu_0_data_master_rdv_fifo_empty_sdram_s1,
      full => open,
      clear_fifo => module_input,
      clk => clk,
      data_in => internal_cpu_0_data_master_granted_sdram_s1,
      read => sdram_s1_move_on_to_next_transaction,
      reset_n => reset_n,
      sync_reset => module_input1,
      write => module_input2
    );

  module_input <= std_logic'('0');
  module_input1 <= std_logic'('0');
  module_input2 <= in_a_read_cycle AND NOT sdram_s1_waits_for_read;

  internal_cpu_0_data_master_read_data_valid_sdram_s1_shift_register <= NOT cpu_0_data_master_rdv_fifo_empty_sdram_s1;
  --local readdatavalid cpu_0_data_master_read_data_valid_sdram_s1, which is an e_mux
  cpu_0_data_master_read_data_valid_sdram_s1 <= ((sdram_s1_readdatavalid_from_sa AND cpu_0_data_master_rdv_fifo_output_from_sdram_s1)) AND NOT cpu_0_data_master_rdv_fifo_empty_sdram_s1;
  --sdram_s1_writedata mux, which is an e_mux
  sdram_s1_writedata <= cpu_0_data_master_dbs_write_16;
  internal_cpu_0_instruction_master_requests_sdram_s1 <= ((to_std_logic(((Std_Logic_Vector'(cpu_0_instruction_master_address_to_slave(24 DOWNTO 23) & std_logic_vector'("00000000000000000000000")) = std_logic_vector'("0100000000000000000000000")))) AND (cpu_0_instruction_master_read))) AND cpu_0_instruction_master_read;
  --cpu_0/data_master granted sdram/s1 last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_0_data_master_granted_slave_sdram_s1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_0_data_master_granted_slave_sdram_s1 <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_0_data_master_saved_grant_sdram_s1) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((sdram_s1_arbitration_holdoff_internal OR NOT internal_cpu_0_data_master_requests_sdram_s1))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_0_data_master_granted_slave_sdram_s1))))));
      end if;
    end if;

  end process;

  --cpu_0_data_master_continuerequest continued request, which is an e_mux
  cpu_0_data_master_continuerequest <= last_cycle_cpu_0_data_master_granted_slave_sdram_s1 AND internal_cpu_0_data_master_requests_sdram_s1;
  internal_cpu_0_instruction_master_qualified_request_sdram_s1 <= internal_cpu_0_instruction_master_requests_sdram_s1 AND NOT ((((cpu_0_instruction_master_read AND to_std_logic((((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000"))) OR ((std_logic_vector'("00000000000000000000000000000001")<(std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_latency_counter)))))))))) OR cpu_0_data_master_arbiterlock));
  --rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1, which is an e_fifo_with_registered_outputs
  rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1 : rdv_fifo_for_cpu_0_instruction_master_to_sdram_s1_module
    port map(
      data_out => cpu_0_instruction_master_rdv_fifo_output_from_sdram_s1,
      empty => open,
      fifo_contains_ones_n => cpu_0_instruction_master_rdv_fifo_empty_sdram_s1,
      full => open,
      clear_fifo => module_input3,
      clk => clk,
      data_in => internal_cpu_0_instruction_master_granted_sdram_s1,
      read => sdram_s1_move_on_to_next_transaction,
      reset_n => reset_n,
      sync_reset => module_input4,
      write => module_input5
    );

  module_input3 <= std_logic'('0');
  module_input4 <= std_logic'('0');
  module_input5 <= in_a_read_cycle AND NOT sdram_s1_waits_for_read;

  cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register <= NOT cpu_0_instruction_master_rdv_fifo_empty_sdram_s1;
  --local readdatavalid cpu_0_instruction_master_read_data_valid_sdram_s1, which is an e_mux
  cpu_0_instruction_master_read_data_valid_sdram_s1 <= ((sdram_s1_readdatavalid_from_sa AND cpu_0_instruction_master_rdv_fifo_output_from_sdram_s1)) AND NOT cpu_0_instruction_master_rdv_fifo_empty_sdram_s1;
  --allow new arb cycle for sdram/s1, which is an e_assign
  sdram_s1_allow_new_arb_cycle <= NOT cpu_0_data_master_arbiterlock AND NOT cpu_0_instruction_master_arbiterlock;
  --cpu_0/instruction_master assignment into master qualified-requests vector for sdram/s1, which is an e_assign
  sdram_s1_master_qreq_vector(0) <= internal_cpu_0_instruction_master_qualified_request_sdram_s1;
  --cpu_0/instruction_master grant sdram/s1, which is an e_assign
  internal_cpu_0_instruction_master_granted_sdram_s1 <= sdram_s1_grant_vector(0);
  --cpu_0/instruction_master saved-grant sdram/s1, which is an e_assign
  cpu_0_instruction_master_saved_grant_sdram_s1 <= sdram_s1_arb_winner(0) AND internal_cpu_0_instruction_master_requests_sdram_s1;
  --cpu_0/data_master assignment into master qualified-requests vector for sdram/s1, which is an e_assign
  sdram_s1_master_qreq_vector(1) <= internal_cpu_0_data_master_qualified_request_sdram_s1;
  --cpu_0/data_master grant sdram/s1, which is an e_assign
  internal_cpu_0_data_master_granted_sdram_s1 <= sdram_s1_grant_vector(1);
  --cpu_0/data_master saved-grant sdram/s1, which is an e_assign
  cpu_0_data_master_saved_grant_sdram_s1 <= sdram_s1_arb_winner(1) AND internal_cpu_0_data_master_requests_sdram_s1;
  --sdram/s1 chosen-master double-vector, which is an e_assign
  sdram_s1_chosen_master_double_vector <= A_EXT (((std_logic_vector'("0") & ((sdram_s1_master_qreq_vector & sdram_s1_master_qreq_vector))) AND (((std_logic_vector'("0") & (Std_Logic_Vector'(NOT sdram_s1_master_qreq_vector & NOT sdram_s1_master_qreq_vector))) + (std_logic_vector'("000") & (sdram_s1_arb_addend))))), 4);
  --stable onehot encoding of arb winner
  sdram_s1_arb_winner <= A_WE_StdLogicVector((std_logic'(((sdram_s1_allow_new_arb_cycle AND or_reduce(sdram_s1_grant_vector)))) = '1'), sdram_s1_grant_vector, sdram_s1_saved_chosen_master_vector);
  --saved sdram_s1_grant_vector, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sdram_s1_saved_chosen_master_vector <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(sdram_s1_allow_new_arb_cycle) = '1' then 
        sdram_s1_saved_chosen_master_vector <= A_WE_StdLogicVector((std_logic'(or_reduce(sdram_s1_grant_vector)) = '1'), sdram_s1_grant_vector, sdram_s1_saved_chosen_master_vector);
      end if;
    end if;

  end process;

  --onehot encoding of chosen master
  sdram_s1_grant_vector <= Std_Logic_Vector'(A_ToStdLogicVector(((sdram_s1_chosen_master_double_vector(1) OR sdram_s1_chosen_master_double_vector(3)))) & A_ToStdLogicVector(((sdram_s1_chosen_master_double_vector(0) OR sdram_s1_chosen_master_double_vector(2)))));
  --sdram/s1 chosen master rotated left, which is an e_assign
  sdram_s1_chosen_master_rot_left <= A_EXT (A_WE_StdLogicVector((((A_SLL(sdram_s1_arb_winner,std_logic_vector'("00000000000000000000000000000001")))) /= std_logic_vector'("00")), (std_logic_vector'("000000000000000000000000000000") & ((A_SLL(sdram_s1_arb_winner,std_logic_vector'("00000000000000000000000000000001"))))), std_logic_vector'("00000000000000000000000000000001")), 2);
  --sdram/s1's addend for next-master-grant
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sdram_s1_arb_addend <= std_logic_vector'("01");
    elsif clk'event and clk = '1' then
      if std_logic'(or_reduce(sdram_s1_grant_vector)) = '1' then 
        sdram_s1_arb_addend <= A_WE_StdLogicVector((std_logic'(sdram_s1_end_xfer) = '1'), sdram_s1_chosen_master_rot_left, sdram_s1_grant_vector);
      end if;
    end if;

  end process;

  --sdram_s1_reset_n assignment, which is an e_assign
  sdram_s1_reset_n <= reset_n;
  sdram_s1_chipselect <= internal_cpu_0_data_master_granted_sdram_s1 OR internal_cpu_0_instruction_master_granted_sdram_s1;
  --sdram_s1_firsttransfer first transaction, which is an e_assign
  sdram_s1_firsttransfer <= A_WE_StdLogic((std_logic'(sdram_s1_begins_xfer) = '1'), sdram_s1_unreg_firsttransfer, sdram_s1_reg_firsttransfer);
  --sdram_s1_unreg_firsttransfer first transaction, which is an e_assign
  sdram_s1_unreg_firsttransfer <= NOT ((sdram_s1_slavearbiterlockenable AND sdram_s1_any_continuerequest));
  --sdram_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sdram_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(sdram_s1_begins_xfer) = '1' then 
        sdram_s1_reg_firsttransfer <= sdram_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --sdram_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  sdram_s1_beginbursttransfer_internal <= sdram_s1_begins_xfer;
  --sdram_s1_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  sdram_s1_arbitration_holdoff_internal <= sdram_s1_begins_xfer AND sdram_s1_firsttransfer;
  --~sdram_s1_read_n assignment, which is an e_mux
  sdram_s1_read_n <= NOT ((((internal_cpu_0_data_master_granted_sdram_s1 AND cpu_0_data_master_read)) OR ((internal_cpu_0_instruction_master_granted_sdram_s1 AND cpu_0_instruction_master_read))));
  --~sdram_s1_write_n assignment, which is an e_mux
  sdram_s1_write_n <= NOT ((internal_cpu_0_data_master_granted_sdram_s1 AND cpu_0_data_master_write));
  shifted_address_to_sdram_s1_from_cpu_0_data_master <= A_EXT (Std_Logic_Vector'(A_SRL(cpu_0_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")) & A_ToStdLogicVector(cpu_0_data_master_dbs_address(1)) & A_ToStdLogicVector(std_logic'('0'))), 25);
  --sdram_s1_address mux, which is an e_mux
  sdram_s1_address <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_sdram_s1)) = '1'), (A_SRL(shifted_address_to_sdram_s1_from_cpu_0_data_master,std_logic_vector'("00000000000000000000000000000001"))), (A_SRL(shifted_address_to_sdram_s1_from_cpu_0_instruction_master,std_logic_vector'("00000000000000000000000000000001")))), 22);
  shifted_address_to_sdram_s1_from_cpu_0_instruction_master <= A_EXT (Std_Logic_Vector'(A_SRL(cpu_0_instruction_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")) & A_ToStdLogicVector(cpu_0_instruction_master_dbs_address(1)) & A_ToStdLogicVector(std_logic'('0'))), 25);
  --d1_sdram_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_sdram_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_sdram_s1_end_xfer <= sdram_s1_end_xfer;
      end if;
    end if;

  end process;

  --sdram_s1_waits_for_read in a cycle, which is an e_mux
  sdram_s1_waits_for_read <= sdram_s1_in_a_read_cycle AND internal_sdram_s1_waitrequest_from_sa;
  --sdram_s1_in_a_read_cycle assignment, which is an e_assign
  sdram_s1_in_a_read_cycle <= ((internal_cpu_0_data_master_granted_sdram_s1 AND cpu_0_data_master_read)) OR ((internal_cpu_0_instruction_master_granted_sdram_s1 AND cpu_0_instruction_master_read));
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= sdram_s1_in_a_read_cycle;
  --sdram_s1_waits_for_write in a cycle, which is an e_mux
  sdram_s1_waits_for_write <= sdram_s1_in_a_write_cycle AND internal_sdram_s1_waitrequest_from_sa;
  --sdram_s1_in_a_write_cycle assignment, which is an e_assign
  sdram_s1_in_a_write_cycle <= internal_cpu_0_data_master_granted_sdram_s1 AND cpu_0_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= sdram_s1_in_a_write_cycle;
  wait_for_sdram_s1_counter <= std_logic'('0');
  --~sdram_s1_byteenable_n byte enable port mux, which is an e_mux
  sdram_s1_byteenable_n <= A_EXT (NOT (A_WE_StdLogicVector((std_logic'((internal_cpu_0_data_master_granted_sdram_s1)) = '1'), (std_logic_vector'("000000000000000000000000000000") & (internal_cpu_0_data_master_byteenable_sdram_s1)), -SIGNED(std_logic_vector'("00000000000000000000000000000001")))), 2);
  (cpu_0_data_master_byteenable_sdram_s1_segment_1(1), cpu_0_data_master_byteenable_sdram_s1_segment_1(0), cpu_0_data_master_byteenable_sdram_s1_segment_0(1), cpu_0_data_master_byteenable_sdram_s1_segment_0(0)) <= cpu_0_data_master_byteenable;
  internal_cpu_0_data_master_byteenable_sdram_s1 <= A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_dbs_address(1)))) = std_logic_vector'("00000000000000000000000000000000"))), cpu_0_data_master_byteenable_sdram_s1_segment_0, cpu_0_data_master_byteenable_sdram_s1_segment_1);
  --vhdl renameroo for output signals
  cpu_0_data_master_byteenable_sdram_s1 <= internal_cpu_0_data_master_byteenable_sdram_s1;
  --vhdl renameroo for output signals
  cpu_0_data_master_granted_sdram_s1 <= internal_cpu_0_data_master_granted_sdram_s1;
  --vhdl renameroo for output signals
  cpu_0_data_master_qualified_request_sdram_s1 <= internal_cpu_0_data_master_qualified_request_sdram_s1;
  --vhdl renameroo for output signals
  cpu_0_data_master_read_data_valid_sdram_s1_shift_register <= internal_cpu_0_data_master_read_data_valid_sdram_s1_shift_register;
  --vhdl renameroo for output signals
  cpu_0_data_master_requests_sdram_s1 <= internal_cpu_0_data_master_requests_sdram_s1;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_granted_sdram_s1 <= internal_cpu_0_instruction_master_granted_sdram_s1;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_qualified_request_sdram_s1 <= internal_cpu_0_instruction_master_qualified_request_sdram_s1;
  --vhdl renameroo for output signals
  cpu_0_instruction_master_requests_sdram_s1 <= internal_cpu_0_instruction_master_requests_sdram_s1;
  --vhdl renameroo for output signals
  sdram_s1_waitrequest_from_sa <= internal_sdram_s1_waitrequest_from_sa;
--synthesis translate_off
    --sdram/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

    --grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line30 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_0_data_master_granted_sdram_s1))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_0_instruction_master_granted_sdram_s1))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line30, now);
          write(write_line30, string'(": "));
          write(write_line30, string'("> 1 of grant signals are active simultaneously"));
          write(output, write_line30.all);
          deallocate (write_line30);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

    --saved_grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line31 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_0_data_master_saved_grant_sdram_s1))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_0_instruction_master_saved_grant_sdram_s1))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line31, now);
          write(write_line31, string'(": "));
          write(write_line31, string'("> 1 of saved_grant signals are active simultaneously"));
          write(output, write_line31.all);
          deallocate (write_line31);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nios_0_reset_clk_domain_synch_module is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC
              );
end entity nios_0_reset_clk_domain_synch_module;


architecture europa of nios_0_reset_clk_domain_synch_module is
                signal data_in_d1 :  STD_LOGIC;
attribute ALTERA_ATTRIBUTE : string;
attribute ALTERA_ATTRIBUTE of data_in_d1 : signal is "MAX_DELAY=100ns ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101";
attribute ALTERA_ATTRIBUTE of data_out : signal is "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101";

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_in_d1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_in_d1 <= data_in;
      end if;
    end if;

  end process;

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_out <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_out <= data_in_d1;
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nios_0_reset_clk_1_domain_synch_module is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC
              );
end entity nios_0_reset_clk_1_domain_synch_module;


architecture europa of nios_0_reset_clk_1_domain_synch_module is
                signal data_in_d1 :  STD_LOGIC;
attribute ALTERA_ATTRIBUTE : string;
attribute ALTERA_ATTRIBUTE of data_in_d1 : signal is "MAX_DELAY=100ns ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101";
attribute ALTERA_ATTRIBUTE of data_out : signal is "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101";

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_in_d1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_in_d1 <= data_in;
      end if;
    end if;

  end process;

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_out <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_out <= data_in_d1;
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nios_0 is 
        port (
              -- 1) global signals:
                 signal clk : IN STD_LOGIC;
                 signal clk_1 : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- the_DM9000A
                 signal ENET_CMD_from_the_DM9000A : OUT STD_LOGIC;
                 signal ENET_CS_N_from_the_DM9000A : OUT STD_LOGIC;
                 signal ENET_DATA_to_and_from_the_DM9000A : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal ENET_INT_to_the_DM9000A : IN STD_LOGIC;
                 signal ENET_RD_N_from_the_DM9000A : OUT STD_LOGIC;
                 signal ENET_RST_N_from_the_DM9000A : OUT STD_LOGIC;
                 signal ENET_WR_N_from_the_DM9000A : OUT STD_LOGIC;

              -- the_arbitrator_inst
                 signal BLUE_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal GREEN_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal HCOUNT_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal RED_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal SRAM_ADDR_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                 signal SRAM_CE_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                 signal SRAM_DQ_to_and_from_the_arbitrator_inst : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal SRAM_LB_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                 signal SRAM_OE_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                 signal SRAM_UB_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                 signal SRAM_WE_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                 signal VCOUNT_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal address_from_dma_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (17 DOWNTO 0);
                 signal busy_to_dma_from_the_arbitrator_inst : OUT STD_LOGIC;
                 signal data_from_dma_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal data_ready_from_dma_to_the_arbitrator_inst : IN STD_LOGIC;
                 signal pixel_clock_from_the_arbitrator_inst : OUT STD_LOGIC;

              -- the_linebuffer_inst
                 signal Field_to_the_linebuffer_inst : IN STD_LOGIC;
                 signal address_from_dma_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (6 DOWNTO 0);
                 signal clk_100_to_the_linebuffer_inst : IN STD_LOGIC;
                 signal clk_27_to_the_linebuffer_inst : IN STD_LOGIC;
                 signal data_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal datavalid_to_the_linebuffer_inst : IN STD_LOGIC;
                 signal field_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC;
                 signal linebufferfull_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC;
                 signal linenumber_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal xpos_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal y_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal ypos_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);

              -- the_sdram
                 signal zs_addr_from_the_sdram : OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
                 signal zs_ba_from_the_sdram : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal zs_cas_n_from_the_sdram : OUT STD_LOGIC;
                 signal zs_cke_from_the_sdram : OUT STD_LOGIC;
                 signal zs_cs_n_from_the_sdram : OUT STD_LOGIC;
                 signal zs_dq_to_and_from_the_sdram : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal zs_dqm_from_the_sdram : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal zs_ras_n_from_the_sdram : OUT STD_LOGIC;
                 signal zs_we_n_from_the_sdram : OUT STD_LOGIC
              );
end entity nios_0;


architecture europa of nios_0 is
component DM9000A_avalonS_arbitrator is 
           port (
                 -- inputs:
                    signal DM9000A_avalonS_irq : IN STD_LOGIC;
                    signal DM9000A_avalonS_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clk : IN STD_LOGIC;
                    signal clock_1_out_address_to_slave : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clock_1_out_nativeaddress : IN STD_LOGIC;
                    signal clock_1_out_read : IN STD_LOGIC;
                    signal clock_1_out_write : IN STD_LOGIC;
                    signal clock_1_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal DM9000A_avalonS_address : OUT STD_LOGIC;
                    signal DM9000A_avalonS_chipselect_n : OUT STD_LOGIC;
                    signal DM9000A_avalonS_irq_from_sa : OUT STD_LOGIC;
                    signal DM9000A_avalonS_read_n : OUT STD_LOGIC;
                    signal DM9000A_avalonS_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal DM9000A_avalonS_reset_n : OUT STD_LOGIC;
                    signal DM9000A_avalonS_wait_counter_eq_0 : OUT STD_LOGIC;
                    signal DM9000A_avalonS_write_n : OUT STD_LOGIC;
                    signal DM9000A_avalonS_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_1_out_granted_DM9000A_avalonS : OUT STD_LOGIC;
                    signal clock_1_out_qualified_request_DM9000A_avalonS : OUT STD_LOGIC;
                    signal clock_1_out_read_data_valid_DM9000A_avalonS : OUT STD_LOGIC;
                    signal clock_1_out_requests_DM9000A_avalonS : OUT STD_LOGIC;
                    signal d1_DM9000A_avalonS_end_xfer : OUT STD_LOGIC
                 );
end component DM9000A_avalonS_arbitrator;

component DM9000A is 
           port (
                 -- inputs:
                    signal ENET_INT : IN STD_LOGIC;
                    signal iCMD : IN STD_LOGIC;
                    signal iCS_N : IN STD_LOGIC;
                    signal iDATA : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal iRD_N : IN STD_LOGIC;
                    signal iRST_N : IN STD_LOGIC;
                    signal iWR_N : IN STD_LOGIC;

                 -- outputs:
                    signal ENET_CMD : OUT STD_LOGIC;
                    signal ENET_CS_N : OUT STD_LOGIC;
                    signal ENET_DATA : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal ENET_RD_N : OUT STD_LOGIC;
                    signal ENET_RST_N : OUT STD_LOGIC;
                    signal ENET_WR_N : OUT STD_LOGIC;
                    signal oDATA : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal oINT : OUT STD_LOGIC
                 );
end component DM9000A;

component arbitrator_inst_avalon_slave_0_arbitrator is 
           port (
                 -- inputs:
                    signal arbitrator_inst_avalon_slave_0_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal arbitrator_inst_avalon_slave_0_waitrequest : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal clock_4_out_address_to_slave : IN STD_LOGIC_VECTOR (16 DOWNTO 0);
                    signal clock_4_out_read : IN STD_LOGIC;
                    signal clock_4_out_write : IN STD_LOGIC;
                    signal clock_4_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal arbitrator_inst_avalon_slave_0_address : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal arbitrator_inst_avalon_slave_0_chipselect : OUT STD_LOGIC;
                    signal arbitrator_inst_avalon_slave_0_read : OUT STD_LOGIC;
                    signal arbitrator_inst_avalon_slave_0_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal arbitrator_inst_avalon_slave_0_reset : OUT STD_LOGIC;
                    signal arbitrator_inst_avalon_slave_0_waitrequest_from_sa : OUT STD_LOGIC;
                    signal arbitrator_inst_avalon_slave_0_write : OUT STD_LOGIC;
                    signal arbitrator_inst_avalon_slave_0_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_4_out_granted_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal clock_4_out_requests_arbitrator_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal d1_arbitrator_inst_avalon_slave_0_end_xfer : OUT STD_LOGIC
                 );
end component arbitrator_inst_avalon_slave_0_arbitrator;

component arbitrator_inst is 
           port (
                 -- inputs:
                    signal HCOUNT : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal VCOUNT : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal address : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal address_from_dma : IN STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal data_from_dma : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal data_ready_from_dma : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal reset : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal BLUE : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal GREEN : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal RED : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal SRAM_ADDR : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal SRAM_CE_N : OUT STD_LOGIC;
                    signal SRAM_DQ : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal SRAM_LB_N : OUT STD_LOGIC;
                    signal SRAM_OE_N : OUT STD_LOGIC;
                    signal SRAM_UB_N : OUT STD_LOGIC;
                    signal SRAM_WE_N : OUT STD_LOGIC;
                    signal busy_to_dma : OUT STD_LOGIC;
                    signal pixel_clock : OUT STD_LOGIC;
                    signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal waitrequest : OUT STD_LOGIC
                 );
end component arbitrator_inst;

component clock_0_in_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_0_in_endofpacket : IN STD_LOGIC;
                    signal clock_0_in_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_0_in_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_0_in_address : OUT STD_LOGIC_VECTOR (2 DOWNTO 0);
                    signal clock_0_in_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal clock_0_in_endofpacket_from_sa : OUT STD_LOGIC;
                    signal clock_0_in_nativeaddress : OUT STD_LOGIC;
                    signal clock_0_in_read : OUT STD_LOGIC;
                    signal clock_0_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_0_in_reset_n : OUT STD_LOGIC;
                    signal clock_0_in_waitrequest_from_sa : OUT STD_LOGIC;
                    signal clock_0_in_write : OUT STD_LOGIC;
                    signal clock_0_in_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_data_master_granted_clock_0_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_0_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_0_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_0_in : OUT STD_LOGIC;
                    signal d1_clock_0_in_end_xfer : OUT STD_LOGIC
                 );
end component clock_0_in_arbitrator;

component clock_0_out_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_0_out_address : IN STD_LOGIC_VECTOR (2 DOWNTO 0);
                    signal clock_0_out_granted_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                    signal clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                    signal clock_0_out_read : IN STD_LOGIC;
                    signal clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                    signal clock_0_out_requests_jtag_uart_0_avalon_jtag_slave : IN STD_LOGIC;
                    signal clock_0_out_write : IN STD_LOGIC;
                    signal clock_0_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_jtag_uart_0_avalon_jtag_slave_end_xfer : IN STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_0_out_address_to_slave : OUT STD_LOGIC_VECTOR (2 DOWNTO 0);
                    signal clock_0_out_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_0_out_reset_n : OUT STD_LOGIC;
                    signal clock_0_out_waitrequest : OUT STD_LOGIC
                 );
end component clock_0_out_arbitrator;

component clock_0 is 
           port (
                 -- inputs:
                    signal master_clk : IN STD_LOGIC;
                    signal master_endofpacket : IN STD_LOGIC;
                    signal master_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal master_reset_n : IN STD_LOGIC;
                    signal master_waitrequest : IN STD_LOGIC;
                    signal slave_address : IN STD_LOGIC_VECTOR (2 DOWNTO 0);
                    signal slave_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal slave_clk : IN STD_LOGIC;
                    signal slave_nativeaddress : IN STD_LOGIC;
                    signal slave_read : IN STD_LOGIC;
                    signal slave_reset_n : IN STD_LOGIC;
                    signal slave_write : IN STD_LOGIC;
                    signal slave_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);

                 -- outputs:
                    signal master_address : OUT STD_LOGIC_VECTOR (2 DOWNTO 0);
                    signal master_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal master_nativeaddress : OUT STD_LOGIC;
                    signal master_read : OUT STD_LOGIC;
                    signal master_write : OUT STD_LOGIC;
                    signal master_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal slave_endofpacket : OUT STD_LOGIC;
                    signal slave_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal slave_waitrequest : OUT STD_LOGIC
                 );
end component clock_0;

component clock_1_in_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_1_in_endofpacket : IN STD_LOGIC;
                    signal clock_1_in_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_1_in_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_1_in_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clock_1_in_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clock_1_in_endofpacket_from_sa : OUT STD_LOGIC;
                    signal clock_1_in_nativeaddress : OUT STD_LOGIC;
                    signal clock_1_in_read : OUT STD_LOGIC;
                    signal clock_1_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_1_in_reset_n : OUT STD_LOGIC;
                    signal clock_1_in_waitrequest_from_sa : OUT STD_LOGIC;
                    signal clock_1_in_write : OUT STD_LOGIC;
                    signal clock_1_in_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_0_data_master_granted_clock_1_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_1_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_1_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_1_in : OUT STD_LOGIC;
                    signal d1_clock_1_in_end_xfer : OUT STD_LOGIC
                 );
end component clock_1_in_arbitrator;

component clock_1_out_arbitrator is 
           port (
                 -- inputs:
                    signal DM9000A_avalonS_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal DM9000A_avalonS_wait_counter_eq_0 : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal clock_1_out_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clock_1_out_granted_DM9000A_avalonS : IN STD_LOGIC;
                    signal clock_1_out_qualified_request_DM9000A_avalonS : IN STD_LOGIC;
                    signal clock_1_out_read : IN STD_LOGIC;
                    signal clock_1_out_read_data_valid_DM9000A_avalonS : IN STD_LOGIC;
                    signal clock_1_out_requests_DM9000A_avalonS : IN STD_LOGIC;
                    signal clock_1_out_write : IN STD_LOGIC;
                    signal clock_1_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal d1_DM9000A_avalonS_end_xfer : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_1_out_address_to_slave : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clock_1_out_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_1_out_reset_n : OUT STD_LOGIC;
                    signal clock_1_out_waitrequest : OUT STD_LOGIC
                 );
end component clock_1_out_arbitrator;

component clock_1 is 
           port (
                 -- inputs:
                    signal master_clk : IN STD_LOGIC;
                    signal master_endofpacket : IN STD_LOGIC;
                    signal master_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal master_reset_n : IN STD_LOGIC;
                    signal master_waitrequest : IN STD_LOGIC;
                    signal slave_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal slave_byteenable : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal slave_clk : IN STD_LOGIC;
                    signal slave_nativeaddress : IN STD_LOGIC;
                    signal slave_read : IN STD_LOGIC;
                    signal slave_reset_n : IN STD_LOGIC;
                    signal slave_write : IN STD_LOGIC;
                    signal slave_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal master_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal master_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal master_nativeaddress : OUT STD_LOGIC;
                    signal master_read : OUT STD_LOGIC;
                    signal master_write : OUT STD_LOGIC;
                    signal master_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal slave_endofpacket : OUT STD_LOGIC;
                    signal slave_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal slave_waitrequest : OUT STD_LOGIC
                 );
end component clock_1;

component clock_2_in_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_2_in_endofpacket : IN STD_LOGIC;
                    signal clock_2_in_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_2_in_waitrequest : IN STD_LOGIC;
                    signal cpu_0_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_instruction_master_latency_counter : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_2_in_address : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_2_in_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal clock_2_in_endofpacket_from_sa : OUT STD_LOGIC;
                    signal clock_2_in_nativeaddress : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal clock_2_in_read : OUT STD_LOGIC;
                    signal clock_2_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_2_in_reset_n : OUT STD_LOGIC;
                    signal clock_2_in_waitrequest_from_sa : OUT STD_LOGIC;
                    signal clock_2_in_write : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_granted_clock_2_in : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_qualified_request_clock_2_in : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_clock_2_in : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_requests_clock_2_in : OUT STD_LOGIC;
                    signal d1_clock_2_in_end_xfer : OUT STD_LOGIC
                 );
end component clock_2_in_arbitrator;

component clock_2_out_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_2_out_address : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_2_out_granted_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_2_out_qualified_request_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_2_out_read : IN STD_LOGIC;
                    signal clock_2_out_read_data_valid_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_2_out_requests_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_2_out_write : IN STD_LOGIC;
                    signal clock_2_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_epcs_controller_epcs_control_port_end_xfer : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_endofpacket_from_sa : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_2_out_address_to_slave : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_2_out_endofpacket : OUT STD_LOGIC;
                    signal clock_2_out_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_2_out_reset_n : OUT STD_LOGIC;
                    signal clock_2_out_waitrequest : OUT STD_LOGIC
                 );
end component clock_2_out_arbitrator;

component clock_2 is 
           port (
                 -- inputs:
                    signal master_clk : IN STD_LOGIC;
                    signal master_endofpacket : IN STD_LOGIC;
                    signal master_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal master_reset_n : IN STD_LOGIC;
                    signal master_waitrequest : IN STD_LOGIC;
                    signal slave_address : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal slave_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal slave_clk : IN STD_LOGIC;
                    signal slave_nativeaddress : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal slave_read : IN STD_LOGIC;
                    signal slave_reset_n : IN STD_LOGIC;
                    signal slave_write : IN STD_LOGIC;
                    signal slave_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);

                 -- outputs:
                    signal master_address : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal master_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal master_nativeaddress : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal master_read : OUT STD_LOGIC;
                    signal master_write : OUT STD_LOGIC;
                    signal master_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal slave_endofpacket : OUT STD_LOGIC;
                    signal slave_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal slave_waitrequest : OUT STD_LOGIC
                 );
end component clock_2;

component clock_3_in_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_3_in_endofpacket : IN STD_LOGIC;
                    signal clock_3_in_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_3_in_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_3_in_address : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_3_in_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal clock_3_in_endofpacket_from_sa : OUT STD_LOGIC;
                    signal clock_3_in_nativeaddress : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal clock_3_in_read : OUT STD_LOGIC;
                    signal clock_3_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_3_in_reset_n : OUT STD_LOGIC;
                    signal clock_3_in_waitrequest_from_sa : OUT STD_LOGIC;
                    signal clock_3_in_write : OUT STD_LOGIC;
                    signal clock_3_in_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_data_master_granted_clock_3_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_3_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_3_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_3_in : OUT STD_LOGIC;
                    signal d1_clock_3_in_end_xfer : OUT STD_LOGIC
                 );
end component clock_3_in_arbitrator;

component clock_3_out_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_3_out_address : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_3_out_granted_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_3_out_qualified_request_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_3_out_read : IN STD_LOGIC;
                    signal clock_3_out_read_data_valid_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_3_out_requests_epcs_controller_epcs_control_port : IN STD_LOGIC;
                    signal clock_3_out_write : IN STD_LOGIC;
                    signal clock_3_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_epcs_controller_epcs_control_port_end_xfer : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_endofpacket_from_sa : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_3_out_address_to_slave : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_3_out_endofpacket : OUT STD_LOGIC;
                    signal clock_3_out_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_3_out_reset_n : OUT STD_LOGIC;
                    signal clock_3_out_waitrequest : OUT STD_LOGIC
                 );
end component clock_3_out_arbitrator;

component clock_3 is 
           port (
                 -- inputs:
                    signal master_clk : IN STD_LOGIC;
                    signal master_endofpacket : IN STD_LOGIC;
                    signal master_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal master_reset_n : IN STD_LOGIC;
                    signal master_waitrequest : IN STD_LOGIC;
                    signal slave_address : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal slave_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal slave_clk : IN STD_LOGIC;
                    signal slave_nativeaddress : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal slave_read : IN STD_LOGIC;
                    signal slave_reset_n : IN STD_LOGIC;
                    signal slave_write : IN STD_LOGIC;
                    signal slave_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);

                 -- outputs:
                    signal master_address : OUT STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal master_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal master_nativeaddress : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal master_read : OUT STD_LOGIC;
                    signal master_write : OUT STD_LOGIC;
                    signal master_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal slave_endofpacket : OUT STD_LOGIC;
                    signal slave_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal slave_waitrequest : OUT STD_LOGIC
                 );
end component clock_3;

component clock_4_in_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_4_in_endofpacket : IN STD_LOGIC;
                    signal clock_4_in_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_4_in_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_0_data_master_no_byte_enables_and_last_term : IN STD_LOGIC;
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_4_in_address : OUT STD_LOGIC_VECTOR (16 DOWNTO 0);
                    signal clock_4_in_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clock_4_in_endofpacket_from_sa : OUT STD_LOGIC;
                    signal clock_4_in_nativeaddress : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_4_in_read : OUT STD_LOGIC;
                    signal clock_4_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_4_in_reset_n : OUT STD_LOGIC;
                    signal clock_4_in_waitrequest_from_sa : OUT STD_LOGIC;
                    signal clock_4_in_write : OUT STD_LOGIC;
                    signal clock_4_in_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_0_data_master_byteenable_clock_4_in : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_granted_clock_4_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_4_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_4_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_4_in : OUT STD_LOGIC;
                    signal d1_clock_4_in_end_xfer : OUT STD_LOGIC
                 );
end component clock_4_in_arbitrator;

component clock_4_out_arbitrator is 
           port (
                 -- inputs:
                    signal arbitrator_inst_avalon_slave_0_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal arbitrator_inst_avalon_slave_0_waitrequest_from_sa : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal clock_4_out_address : IN STD_LOGIC_VECTOR (16 DOWNTO 0);
                    signal clock_4_out_granted_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_4_out_read : IN STD_LOGIC;
                    signal clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_4_out_requests_arbitrator_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_4_out_write : IN STD_LOGIC;
                    signal clock_4_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal d1_arbitrator_inst_avalon_slave_0_end_xfer : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_4_out_address_to_slave : OUT STD_LOGIC_VECTOR (16 DOWNTO 0);
                    signal clock_4_out_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_4_out_reset_n : OUT STD_LOGIC;
                    signal clock_4_out_waitrequest : OUT STD_LOGIC
                 );
end component clock_4_out_arbitrator;

component clock_4 is 
           port (
                 -- inputs:
                    signal master_clk : IN STD_LOGIC;
                    signal master_endofpacket : IN STD_LOGIC;
                    signal master_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal master_reset_n : IN STD_LOGIC;
                    signal master_waitrequest : IN STD_LOGIC;
                    signal slave_address : IN STD_LOGIC_VECTOR (16 DOWNTO 0);
                    signal slave_byteenable : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal slave_clk : IN STD_LOGIC;
                    signal slave_nativeaddress : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal slave_read : IN STD_LOGIC;
                    signal slave_reset_n : IN STD_LOGIC;
                    signal slave_write : IN STD_LOGIC;
                    signal slave_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal master_address : OUT STD_LOGIC_VECTOR (16 DOWNTO 0);
                    signal master_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal master_nativeaddress : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal master_read : OUT STD_LOGIC;
                    signal master_write : OUT STD_LOGIC;
                    signal master_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal slave_endofpacket : OUT STD_LOGIC;
                    signal slave_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal slave_waitrequest : OUT STD_LOGIC
                 );
end component clock_4;

component clock_5_in_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_5_in_endofpacket : IN STD_LOGIC;
                    signal clock_5_in_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_5_in_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_0_data_master_no_byte_enables_and_last_term : IN STD_LOGIC;
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_5_in_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal clock_5_in_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clock_5_in_endofpacket_from_sa : OUT STD_LOGIC;
                    signal clock_5_in_nativeaddress : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal clock_5_in_read : OUT STD_LOGIC;
                    signal clock_5_in_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_5_in_reset_n : OUT STD_LOGIC;
                    signal clock_5_in_waitrequest_from_sa : OUT STD_LOGIC;
                    signal clock_5_in_write : OUT STD_LOGIC;
                    signal clock_5_in_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_0_data_master_byteenable_clock_5_in : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_granted_clock_5_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_5_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_5_in : OUT STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_5_in : OUT STD_LOGIC;
                    signal d1_clock_5_in_end_xfer : OUT STD_LOGIC
                 );
end component clock_5_in_arbitrator;

component clock_5_out_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_5_out_address : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal clock_5_out_granted_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_5_out_read : IN STD_LOGIC;
                    signal clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_5_out_requests_linebuffer_inst_avalon_slave_0 : IN STD_LOGIC;
                    signal clock_5_out_write : IN STD_LOGIC;
                    signal clock_5_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal d1_linebuffer_inst_avalon_slave_0_end_xfer : IN STD_LOGIC;
                    signal linebuffer_inst_avalon_slave_0_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_5_out_address_to_slave : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal clock_5_out_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_5_out_reset_n : OUT STD_LOGIC;
                    signal clock_5_out_waitrequest : OUT STD_LOGIC
                 );
end component clock_5_out_arbitrator;

component clock_5 is 
           port (
                 -- inputs:
                    signal master_clk : IN STD_LOGIC;
                    signal master_endofpacket : IN STD_LOGIC;
                    signal master_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal master_reset_n : IN STD_LOGIC;
                    signal master_waitrequest : IN STD_LOGIC;
                    signal slave_address : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal slave_byteenable : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal slave_clk : IN STD_LOGIC;
                    signal slave_nativeaddress : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal slave_read : IN STD_LOGIC;
                    signal slave_reset_n : IN STD_LOGIC;
                    signal slave_write : IN STD_LOGIC;
                    signal slave_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal master_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal master_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal master_nativeaddress : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal master_read : OUT STD_LOGIC;
                    signal master_write : OUT STD_LOGIC;
                    signal master_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal slave_endofpacket : OUT STD_LOGIC;
                    signal slave_readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal slave_waitrequest : OUT STD_LOGIC
                 );
end component clock_5;

component cpu_0_jtag_debug_module_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_data_master_debugaccess : IN STD_LOGIC;
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_instruction_master_latency_counter : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                    signal cpu_0_jtag_debug_module_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_jtag_debug_module_resetrequest : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_0_data_master_granted_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_data_master_requests_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_granted_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_requests_cpu_0_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal cpu_0_jtag_debug_module_begintransfer : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_jtag_debug_module_chipselect : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_debugaccess : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_jtag_debug_module_reset : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_reset_n : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_resetrequest_from_sa : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_write : OUT STD_LOGIC;
                    signal cpu_0_jtag_debug_module_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_cpu_0_jtag_debug_module_end_xfer : OUT STD_LOGIC
                 );
end component cpu_0_jtag_debug_module_arbitrator;

component cpu_0_data_master_arbitrator is 
           port (
                 -- inputs:
                    signal DM9000A_avalonS_irq_from_sa : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal clk_1 : IN STD_LOGIC;
                    signal clk_1_reset_n : IN STD_LOGIC;
                    signal clock_0_in_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_0_in_waitrequest_from_sa : IN STD_LOGIC;
                    signal clock_1_in_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_1_in_waitrequest_from_sa : IN STD_LOGIC;
                    signal clock_3_in_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_3_in_waitrequest_from_sa : IN STD_LOGIC;
                    signal clock_4_in_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_4_in_waitrequest_from_sa : IN STD_LOGIC;
                    signal clock_5_in_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal clock_5_in_waitrequest_from_sa : IN STD_LOGIC;
                    signal cpu_0_data_master_address : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable_clock_4_in : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_byteenable_clock_5_in : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_byteenable_sdram_s1 : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_debugaccess : IN STD_LOGIC;
                    signal cpu_0_data_master_granted_clock_0_in : IN STD_LOGIC;
                    signal cpu_0_data_master_granted_clock_1_in : IN STD_LOGIC;
                    signal cpu_0_data_master_granted_clock_3_in : IN STD_LOGIC;
                    signal cpu_0_data_master_granted_clock_4_in : IN STD_LOGIC;
                    signal cpu_0_data_master_granted_clock_5_in : IN STD_LOGIC;
                    signal cpu_0_data_master_granted_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_data_master_granted_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_0_in : IN STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_1_in : IN STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_3_in : IN STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_4_in : IN STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_clock_5_in : IN STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_0_in : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_1_in : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_3_in : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_4_in : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_clock_5_in : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_0_in : IN STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_1_in : IN STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_3_in : IN STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_4_in : IN STD_LOGIC;
                    signal cpu_0_data_master_requests_clock_5_in : IN STD_LOGIC;
                    signal cpu_0_data_master_requests_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_data_master_requests_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal cpu_0_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_clock_0_in_end_xfer : IN STD_LOGIC;
                    signal d1_clock_1_in_end_xfer : IN STD_LOGIC;
                    signal d1_clock_3_in_end_xfer : IN STD_LOGIC;
                    signal d1_clock_4_in_end_xfer : IN STD_LOGIC;
                    signal d1_clock_5_in_end_xfer : IN STD_LOGIC;
                    signal d1_cpu_0_jtag_debug_module_end_xfer : IN STD_LOGIC;
                    signal d1_sdram_s1_end_xfer : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_irq_from_sa : IN STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_irq_from_sa : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sdram_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal sdram_s1_waitrequest_from_sa : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_0_data_master_address_to_slave : OUT STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_dbs_write_16 : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_0_data_master_irq : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_data_master_no_byte_enables_and_last_term : OUT STD_LOGIC;
                    signal cpu_0_data_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_data_master_waitrequest : OUT STD_LOGIC
                 );
end component cpu_0_data_master_arbitrator;

component cpu_0_instruction_master_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_2_in_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_2_in_waitrequest_from_sa : IN STD_LOGIC;
                    signal cpu_0_instruction_master_address : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_instruction_master_granted_clock_2_in : IN STD_LOGIC;
                    signal cpu_0_instruction_master_granted_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_instruction_master_granted_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_instruction_master_qualified_request_clock_2_in : IN STD_LOGIC;
                    signal cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_instruction_master_qualified_request_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_clock_2_in : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : IN STD_LOGIC;
                    signal cpu_0_instruction_master_requests_clock_2_in : IN STD_LOGIC;
                    signal cpu_0_instruction_master_requests_cpu_0_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_0_instruction_master_requests_sdram_s1 : IN STD_LOGIC;
                    signal cpu_0_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_clock_2_in_end_xfer : IN STD_LOGIC;
                    signal d1_cpu_0_jtag_debug_module_end_xfer : IN STD_LOGIC;
                    signal d1_sdram_s1_end_xfer : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sdram_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal sdram_s1_waitrequest_from_sa : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_0_instruction_master_address_to_slave : OUT STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_instruction_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_instruction_master_latency_counter : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_0_instruction_master_readdatavalid : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_waitrequest : OUT STD_LOGIC
                 );
end component cpu_0_instruction_master_arbitrator;

component cpu_0 is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal d_irq : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d_waitrequest : IN STD_LOGIC;
                    signal i_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal i_readdatavalid : IN STD_LOGIC;
                    signal i_waitrequest : IN STD_LOGIC;
                    signal jtag_debug_module_address : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal jtag_debug_module_begintransfer : IN STD_LOGIC;
                    signal jtag_debug_module_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal jtag_debug_module_clk : IN STD_LOGIC;
                    signal jtag_debug_module_debugaccess : IN STD_LOGIC;
                    signal jtag_debug_module_reset : IN STD_LOGIC;
                    signal jtag_debug_module_select : IN STD_LOGIC;
                    signal jtag_debug_module_write : IN STD_LOGIC;
                    signal jtag_debug_module_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal d_address : OUT STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal d_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal d_read : OUT STD_LOGIC;
                    signal d_write : OUT STD_LOGIC;
                    signal d_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal i_address : OUT STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal i_read : OUT STD_LOGIC;
                    signal jtag_debug_module_debugaccess_to_roms : OUT STD_LOGIC;
                    signal jtag_debug_module_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_debug_module_resetrequest : OUT STD_LOGIC
                 );
end component cpu_0;

component epcs_controller_epcs_control_port_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_2_out_address_to_slave : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_2_out_read : IN STD_LOGIC;
                    signal clock_2_out_write : IN STD_LOGIC;
                    signal clock_2_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clock_3_out_address_to_slave : IN STD_LOGIC_VECTOR (10 DOWNTO 0);
                    signal clock_3_out_read : IN STD_LOGIC;
                    signal clock_3_out_write : IN STD_LOGIC;
                    signal clock_3_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal epcs_controller_epcs_control_port_dataavailable : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_endofpacket : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_irq : IN STD_LOGIC;
                    signal epcs_controller_epcs_control_port_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal epcs_controller_epcs_control_port_readyfordata : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_2_out_granted_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal clock_2_out_qualified_request_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal clock_2_out_read_data_valid_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal clock_2_out_requests_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal clock_3_out_granted_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal clock_3_out_qualified_request_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal clock_3_out_read_data_valid_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal clock_3_out_requests_epcs_controller_epcs_control_port : OUT STD_LOGIC;
                    signal d1_epcs_controller_epcs_control_port_end_xfer : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal epcs_controller_epcs_control_port_chipselect : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_dataavailable_from_sa : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_endofpacket_from_sa : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_irq_from_sa : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_read_n : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal epcs_controller_epcs_control_port_readyfordata_from_sa : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_reset_n : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_write_n : OUT STD_LOGIC;
                    signal epcs_controller_epcs_control_port_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
                 );
end component epcs_controller_epcs_control_port_arbitrator;

component epcs_controller is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal read_n : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal write_n : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);

                 -- outputs:
                    signal dataavailable : OUT STD_LOGIC;
                    signal endofpacket : OUT STD_LOGIC;
                    signal irq : OUT STD_LOGIC;
                    signal readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal readyfordata : OUT STD_LOGIC
                 );
end component epcs_controller;

component jtag_uart_0_avalon_jtag_slave_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_0_out_address_to_slave : IN STD_LOGIC_VECTOR (2 DOWNTO 0);
                    signal clock_0_out_nativeaddress : IN STD_LOGIC;
                    signal clock_0_out_read : IN STD_LOGIC;
                    signal clock_0_out_write : IN STD_LOGIC;
                    signal clock_0_out_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_0_avalon_jtag_slave_dataavailable : IN STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_irq : IN STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_0_avalon_jtag_slave_readyfordata : IN STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_waitrequest : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_0_out_granted_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                    signal clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                    signal clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                    signal clock_0_out_requests_jtag_uart_0_avalon_jtag_slave : OUT STD_LOGIC;
                    signal d1_jtag_uart_0_avalon_jtag_slave_end_xfer : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_address : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_chipselect : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_irq_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_read_n : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_reset_n : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_write_n : OUT STD_LOGIC;
                    signal jtag_uart_0_avalon_jtag_slave_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
                 );
end component jtag_uart_0_avalon_jtag_slave_arbitrator;

component jtag_uart_0 is 
           port (
                 -- inputs:
                    signal av_address : IN STD_LOGIC;
                    signal av_chipselect : IN STD_LOGIC;
                    signal av_read_n : IN STD_LOGIC;
                    signal av_write_n : IN STD_LOGIC;
                    signal av_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clk : IN STD_LOGIC;
                    signal rst_n : IN STD_LOGIC;

                 -- outputs:
                    signal av_irq : OUT STD_LOGIC;
                    signal av_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal av_waitrequest : OUT STD_LOGIC;
                    signal dataavailable : OUT STD_LOGIC;
                    signal readyfordata : OUT STD_LOGIC
                 );
end component jtag_uart_0;

component linebuffer_inst_avalon_slave_0_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal clock_5_out_address_to_slave : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal clock_5_out_read : IN STD_LOGIC;
                    signal clock_5_out_write : IN STD_LOGIC;
                    signal clock_5_out_writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal linebuffer_inst_avalon_slave_0_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal clock_5_out_granted_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal clock_5_out_requests_linebuffer_inst_avalon_slave_0 : OUT STD_LOGIC;
                    signal d1_linebuffer_inst_avalon_slave_0_end_xfer : OUT STD_LOGIC;
                    signal linebuffer_inst_avalon_slave_0_address : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal linebuffer_inst_avalon_slave_0_chipselect : OUT STD_LOGIC;
                    signal linebuffer_inst_avalon_slave_0_read : OUT STD_LOGIC;
                    signal linebuffer_inst_avalon_slave_0_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal linebuffer_inst_avalon_slave_0_reset : OUT STD_LOGIC;
                    signal linebuffer_inst_avalon_slave_0_write : OUT STD_LOGIC;
                    signal linebuffer_inst_avalon_slave_0_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component linebuffer_inst_avalon_slave_0_arbitrator;

component linebuffer_inst is 
           port (
                 -- inputs:
                    signal Field : IN STD_LOGIC;
                    signal address : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal address_from_dma : IN STD_LOGIC_VECTOR (6 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk_100 : IN STD_LOGIC;
                    signal clk_27 : IN STD_LOGIC;
                    signal clk_50 : IN STD_LOGIC;
                    signal datavalid : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal reset : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal xpos : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal y : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal ypos : IN STD_LOGIC_VECTOR (9 DOWNTO 0);

                 -- outputs:
                    signal data_to_dma : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal field_to_dma : OUT STD_LOGIC;
                    signal linebufferfull_to_dma : OUT STD_LOGIC;
                    signal linenumber_to_dma : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component linebuffer_inst;

component sdram_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_0_data_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_0_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_0_data_master_no_byte_enables_and_last_term : IN STD_LOGIC;
                    signal cpu_0_data_master_read : IN STD_LOGIC;
                    signal cpu_0_data_master_waitrequest : IN STD_LOGIC;
                    signal cpu_0_data_master_write : IN STD_LOGIC;
                    signal cpu_0_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (24 DOWNTO 0);
                    signal cpu_0_instruction_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_instruction_master_latency_counter : IN STD_LOGIC;
                    signal cpu_0_instruction_master_read : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sdram_s1_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal sdram_s1_readdatavalid : IN STD_LOGIC;
                    signal sdram_s1_waitrequest : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_0_data_master_byteenable_sdram_s1 : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_0_data_master_granted_sdram_s1 : OUT STD_LOGIC;
                    signal cpu_0_data_master_qualified_request_sdram_s1 : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_sdram_s1 : OUT STD_LOGIC;
                    signal cpu_0_data_master_read_data_valid_sdram_s1_shift_register : OUT STD_LOGIC;
                    signal cpu_0_data_master_requests_sdram_s1 : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_granted_sdram_s1 : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_qualified_request_sdram_s1 : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_sdram_s1 : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register : OUT STD_LOGIC;
                    signal cpu_0_instruction_master_requests_sdram_s1 : OUT STD_LOGIC;
                    signal d1_sdram_s1_end_xfer : OUT STD_LOGIC;
                    signal sdram_s1_address : OUT STD_LOGIC_VECTOR (21 DOWNTO 0);
                    signal sdram_s1_byteenable_n : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal sdram_s1_chipselect : OUT STD_LOGIC;
                    signal sdram_s1_read_n : OUT STD_LOGIC;
                    signal sdram_s1_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal sdram_s1_reset_n : OUT STD_LOGIC;
                    signal sdram_s1_waitrequest_from_sa : OUT STD_LOGIC;
                    signal sdram_s1_write_n : OUT STD_LOGIC;
                    signal sdram_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component sdram_s1_arbitrator;

component sdram is 
           port (
                 -- inputs:
                    signal az_addr : IN STD_LOGIC_VECTOR (21 DOWNTO 0);
                    signal az_be_n : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal az_cs : IN STD_LOGIC;
                    signal az_data : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal az_rd_n : IN STD_LOGIC;
                    signal az_wr_n : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal za_data : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal za_valid : OUT STD_LOGIC;
                    signal za_waitrequest : OUT STD_LOGIC;
                    signal zs_addr : OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
                    signal zs_ba : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal zs_cas_n : OUT STD_LOGIC;
                    signal zs_cke : OUT STD_LOGIC;
                    signal zs_cs_n : OUT STD_LOGIC;
                    signal zs_dq : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal zs_dqm : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal zs_ras_n : OUT STD_LOGIC;
                    signal zs_we_n : OUT STD_LOGIC
                 );
end component sdram;

component nios_0_reset_clk_domain_synch_module is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC
                 );
end component nios_0_reset_clk_domain_synch_module;

component nios_0_reset_clk_1_domain_synch_module is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC
                 );
end component nios_0_reset_clk_1_domain_synch_module;

                signal DM9000A_avalonS_address :  STD_LOGIC;
                signal DM9000A_avalonS_chipselect_n :  STD_LOGIC;
                signal DM9000A_avalonS_irq :  STD_LOGIC;
                signal DM9000A_avalonS_irq_from_sa :  STD_LOGIC;
                signal DM9000A_avalonS_read_n :  STD_LOGIC;
                signal DM9000A_avalonS_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal DM9000A_avalonS_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal DM9000A_avalonS_reset_n :  STD_LOGIC;
                signal DM9000A_avalonS_wait_counter_eq_0 :  STD_LOGIC;
                signal DM9000A_avalonS_write_n :  STD_LOGIC;
                signal DM9000A_avalonS_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal arbitrator_inst_avalon_slave_0_address :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal arbitrator_inst_avalon_slave_0_chipselect :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_read :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal arbitrator_inst_avalon_slave_0_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal arbitrator_inst_avalon_slave_0_reset :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_waitrequest :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_waitrequest_from_sa :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_write :  STD_LOGIC;
                signal arbitrator_inst_avalon_slave_0_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clk_1_reset_n :  STD_LOGIC;
                signal clk_reset_n :  STD_LOGIC;
                signal clock_0_in_address :  STD_LOGIC_VECTOR (2 DOWNTO 0);
                signal clock_0_in_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_0_in_endofpacket :  STD_LOGIC;
                signal clock_0_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_0_in_nativeaddress :  STD_LOGIC;
                signal clock_0_in_read :  STD_LOGIC;
                signal clock_0_in_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_0_in_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_0_in_reset_n :  STD_LOGIC;
                signal clock_0_in_waitrequest :  STD_LOGIC;
                signal clock_0_in_waitrequest_from_sa :  STD_LOGIC;
                signal clock_0_in_write :  STD_LOGIC;
                signal clock_0_in_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_0_out_address :  STD_LOGIC_VECTOR (2 DOWNTO 0);
                signal clock_0_out_address_to_slave :  STD_LOGIC_VECTOR (2 DOWNTO 0);
                signal clock_0_out_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_0_out_endofpacket :  STD_LOGIC;
                signal clock_0_out_granted_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal clock_0_out_nativeaddress :  STD_LOGIC;
                signal clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal clock_0_out_read :  STD_LOGIC;
                signal clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal clock_0_out_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_0_out_requests_jtag_uart_0_avalon_jtag_slave :  STD_LOGIC;
                signal clock_0_out_reset_n :  STD_LOGIC;
                signal clock_0_out_waitrequest :  STD_LOGIC;
                signal clock_0_out_write :  STD_LOGIC;
                signal clock_0_out_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_1_in_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_in_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_in_endofpacket :  STD_LOGIC;
                signal clock_1_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_1_in_nativeaddress :  STD_LOGIC;
                signal clock_1_in_read :  STD_LOGIC;
                signal clock_1_in_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_1_in_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_1_in_reset_n :  STD_LOGIC;
                signal clock_1_in_waitrequest :  STD_LOGIC;
                signal clock_1_in_waitrequest_from_sa :  STD_LOGIC;
                signal clock_1_in_write :  STD_LOGIC;
                signal clock_1_in_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_1_out_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_out_address_to_slave :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_out_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_out_endofpacket :  STD_LOGIC;
                signal clock_1_out_granted_DM9000A_avalonS :  STD_LOGIC;
                signal clock_1_out_nativeaddress :  STD_LOGIC;
                signal clock_1_out_qualified_request_DM9000A_avalonS :  STD_LOGIC;
                signal clock_1_out_read :  STD_LOGIC;
                signal clock_1_out_read_data_valid_DM9000A_avalonS :  STD_LOGIC;
                signal clock_1_out_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_1_out_requests_DM9000A_avalonS :  STD_LOGIC;
                signal clock_1_out_reset_n :  STD_LOGIC;
                signal clock_1_out_waitrequest :  STD_LOGIC;
                signal clock_1_out_write :  STD_LOGIC;
                signal clock_1_out_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_2_in_address :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_2_in_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_2_in_endofpacket :  STD_LOGIC;
                signal clock_2_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_2_in_nativeaddress :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_2_in_read :  STD_LOGIC;
                signal clock_2_in_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_2_in_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_2_in_reset_n :  STD_LOGIC;
                signal clock_2_in_waitrequest :  STD_LOGIC;
                signal clock_2_in_waitrequest_from_sa :  STD_LOGIC;
                signal clock_2_in_write :  STD_LOGIC;
                signal clock_2_in_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_2_out_address :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_2_out_address_to_slave :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_2_out_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_2_out_endofpacket :  STD_LOGIC;
                signal clock_2_out_granted_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_2_out_nativeaddress :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_2_out_qualified_request_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_2_out_read :  STD_LOGIC;
                signal clock_2_out_read_data_valid_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_2_out_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_2_out_requests_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_2_out_reset_n :  STD_LOGIC;
                signal clock_2_out_waitrequest :  STD_LOGIC;
                signal clock_2_out_write :  STD_LOGIC;
                signal clock_2_out_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_3_in_address :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_3_in_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_3_in_endofpacket :  STD_LOGIC;
                signal clock_3_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_3_in_nativeaddress :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_3_in_read :  STD_LOGIC;
                signal clock_3_in_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_3_in_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_3_in_reset_n :  STD_LOGIC;
                signal clock_3_in_waitrequest :  STD_LOGIC;
                signal clock_3_in_waitrequest_from_sa :  STD_LOGIC;
                signal clock_3_in_write :  STD_LOGIC;
                signal clock_3_in_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_3_out_address :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_3_out_address_to_slave :  STD_LOGIC_VECTOR (10 DOWNTO 0);
                signal clock_3_out_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_3_out_endofpacket :  STD_LOGIC;
                signal clock_3_out_granted_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_3_out_nativeaddress :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_3_out_qualified_request_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_3_out_read :  STD_LOGIC;
                signal clock_3_out_read_data_valid_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_3_out_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_3_out_requests_epcs_controller_epcs_control_port :  STD_LOGIC;
                signal clock_3_out_reset_n :  STD_LOGIC;
                signal clock_3_out_waitrequest :  STD_LOGIC;
                signal clock_3_out_write :  STD_LOGIC;
                signal clock_3_out_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_4_in_address :  STD_LOGIC_VECTOR (16 DOWNTO 0);
                signal clock_4_in_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_4_in_endofpacket :  STD_LOGIC;
                signal clock_4_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_4_in_nativeaddress :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_4_in_read :  STD_LOGIC;
                signal clock_4_in_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_4_in_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_4_in_reset_n :  STD_LOGIC;
                signal clock_4_in_waitrequest :  STD_LOGIC;
                signal clock_4_in_waitrequest_from_sa :  STD_LOGIC;
                signal clock_4_in_write :  STD_LOGIC;
                signal clock_4_in_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_4_out_address :  STD_LOGIC_VECTOR (16 DOWNTO 0);
                signal clock_4_out_address_to_slave :  STD_LOGIC_VECTOR (16 DOWNTO 0);
                signal clock_4_out_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_4_out_endofpacket :  STD_LOGIC;
                signal clock_4_out_granted_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_4_out_nativeaddress :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_4_out_read :  STD_LOGIC;
                signal clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_4_out_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_4_out_requests_arbitrator_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_4_out_reset_n :  STD_LOGIC;
                signal clock_4_out_waitrequest :  STD_LOGIC;
                signal clock_4_out_write :  STD_LOGIC;
                signal clock_4_out_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_5_in_address :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_5_in_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_5_in_endofpacket :  STD_LOGIC;
                signal clock_5_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_5_in_nativeaddress :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal clock_5_in_read :  STD_LOGIC;
                signal clock_5_in_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_5_in_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_5_in_reset_n :  STD_LOGIC;
                signal clock_5_in_waitrequest :  STD_LOGIC;
                signal clock_5_in_waitrequest_from_sa :  STD_LOGIC;
                signal clock_5_in_write :  STD_LOGIC;
                signal clock_5_in_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_5_out_address :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_5_out_address_to_slave :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_5_out_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_5_out_endofpacket :  STD_LOGIC;
                signal clock_5_out_granted_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_5_out_nativeaddress :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_5_out_read :  STD_LOGIC;
                signal clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_5_out_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_5_out_requests_linebuffer_inst_avalon_slave_0 :  STD_LOGIC;
                signal clock_5_out_reset_n :  STD_LOGIC;
                signal clock_5_out_waitrequest :  STD_LOGIC;
                signal clock_5_out_write :  STD_LOGIC;
                signal clock_5_out_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal cpu_0_data_master_address :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal cpu_0_data_master_address_to_slave :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal cpu_0_data_master_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal cpu_0_data_master_byteenable_clock_4_in :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_byteenable_clock_5_in :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_byteenable_sdram_s1 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_data_master_dbs_write_16 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal cpu_0_data_master_debugaccess :  STD_LOGIC;
                signal cpu_0_data_master_granted_clock_0_in :  STD_LOGIC;
                signal cpu_0_data_master_granted_clock_1_in :  STD_LOGIC;
                signal cpu_0_data_master_granted_clock_3_in :  STD_LOGIC;
                signal cpu_0_data_master_granted_clock_4_in :  STD_LOGIC;
                signal cpu_0_data_master_granted_clock_5_in :  STD_LOGIC;
                signal cpu_0_data_master_granted_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_data_master_granted_sdram_s1 :  STD_LOGIC;
                signal cpu_0_data_master_irq :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_0_data_master_no_byte_enables_and_last_term :  STD_LOGIC;
                signal cpu_0_data_master_qualified_request_clock_0_in :  STD_LOGIC;
                signal cpu_0_data_master_qualified_request_clock_1_in :  STD_LOGIC;
                signal cpu_0_data_master_qualified_request_clock_3_in :  STD_LOGIC;
                signal cpu_0_data_master_qualified_request_clock_4_in :  STD_LOGIC;
                signal cpu_0_data_master_qualified_request_clock_5_in :  STD_LOGIC;
                signal cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_data_master_qualified_request_sdram_s1 :  STD_LOGIC;
                signal cpu_0_data_master_read :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_clock_0_in :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_clock_1_in :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_clock_3_in :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_clock_4_in :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_clock_5_in :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_sdram_s1 :  STD_LOGIC;
                signal cpu_0_data_master_read_data_valid_sdram_s1_shift_register :  STD_LOGIC;
                signal cpu_0_data_master_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_0_data_master_requests_clock_0_in :  STD_LOGIC;
                signal cpu_0_data_master_requests_clock_1_in :  STD_LOGIC;
                signal cpu_0_data_master_requests_clock_3_in :  STD_LOGIC;
                signal cpu_0_data_master_requests_clock_4_in :  STD_LOGIC;
                signal cpu_0_data_master_requests_clock_5_in :  STD_LOGIC;
                signal cpu_0_data_master_requests_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_data_master_requests_sdram_s1 :  STD_LOGIC;
                signal cpu_0_data_master_waitrequest :  STD_LOGIC;
                signal cpu_0_data_master_write :  STD_LOGIC;
                signal cpu_0_data_master_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_0_instruction_master_address :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal cpu_0_instruction_master_address_to_slave :  STD_LOGIC_VECTOR (24 DOWNTO 0);
                signal cpu_0_instruction_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_0_instruction_master_granted_clock_2_in :  STD_LOGIC;
                signal cpu_0_instruction_master_granted_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_instruction_master_granted_sdram_s1 :  STD_LOGIC;
                signal cpu_0_instruction_master_latency_counter :  STD_LOGIC;
                signal cpu_0_instruction_master_qualified_request_clock_2_in :  STD_LOGIC;
                signal cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_instruction_master_qualified_request_sdram_s1 :  STD_LOGIC;
                signal cpu_0_instruction_master_read :  STD_LOGIC;
                signal cpu_0_instruction_master_read_data_valid_clock_2_in :  STD_LOGIC;
                signal cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_instruction_master_read_data_valid_sdram_s1 :  STD_LOGIC;
                signal cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register :  STD_LOGIC;
                signal cpu_0_instruction_master_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_0_instruction_master_readdatavalid :  STD_LOGIC;
                signal cpu_0_instruction_master_requests_clock_2_in :  STD_LOGIC;
                signal cpu_0_instruction_master_requests_cpu_0_jtag_debug_module :  STD_LOGIC;
                signal cpu_0_instruction_master_requests_sdram_s1 :  STD_LOGIC;
                signal cpu_0_instruction_master_waitrequest :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_address :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal cpu_0_jtag_debug_module_begintransfer :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal cpu_0_jtag_debug_module_chipselect :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_debugaccess :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_0_jtag_debug_module_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_0_jtag_debug_module_reset :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_reset_n :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_resetrequest :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_resetrequest_from_sa :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_write :  STD_LOGIC;
                signal cpu_0_jtag_debug_module_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal d1_DM9000A_avalonS_end_xfer :  STD_LOGIC;
                signal d1_arbitrator_inst_avalon_slave_0_end_xfer :  STD_LOGIC;
                signal d1_clock_0_in_end_xfer :  STD_LOGIC;
                signal d1_clock_1_in_end_xfer :  STD_LOGIC;
                signal d1_clock_2_in_end_xfer :  STD_LOGIC;
                signal d1_clock_3_in_end_xfer :  STD_LOGIC;
                signal d1_clock_4_in_end_xfer :  STD_LOGIC;
                signal d1_clock_5_in_end_xfer :  STD_LOGIC;
                signal d1_cpu_0_jtag_debug_module_end_xfer :  STD_LOGIC;
                signal d1_epcs_controller_epcs_control_port_end_xfer :  STD_LOGIC;
                signal d1_jtag_uart_0_avalon_jtag_slave_end_xfer :  STD_LOGIC;
                signal d1_linebuffer_inst_avalon_slave_0_end_xfer :  STD_LOGIC;
                signal d1_sdram_s1_end_xfer :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_address :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal epcs_controller_epcs_control_port_chipselect :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_dataavailable :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_dataavailable_from_sa :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_endofpacket :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_endofpacket_from_sa :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_irq :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_irq_from_sa :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_read_n :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal epcs_controller_epcs_control_port_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal epcs_controller_epcs_control_port_readyfordata :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_readyfordata_from_sa :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_reset_n :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_write_n :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal internal_BLUE_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal internal_ENET_CMD_from_the_DM9000A :  STD_LOGIC;
                signal internal_ENET_CS_N_from_the_DM9000A :  STD_LOGIC;
                signal internal_ENET_RD_N_from_the_DM9000A :  STD_LOGIC;
                signal internal_ENET_RST_N_from_the_DM9000A :  STD_LOGIC;
                signal internal_ENET_WR_N_from_the_DM9000A :  STD_LOGIC;
                signal internal_GREEN_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal internal_RED_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal internal_SRAM_ADDR_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (17 DOWNTO 0);
                signal internal_SRAM_CE_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal internal_SRAM_LB_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal internal_SRAM_OE_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal internal_SRAM_UB_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal internal_SRAM_WE_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal internal_busy_to_dma_from_the_arbitrator_inst :  STD_LOGIC;
                signal internal_data_to_dma_from_the_linebuffer_inst :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_field_to_dma_from_the_linebuffer_inst :  STD_LOGIC;
                signal internal_linebufferfull_to_dma_from_the_linebuffer_inst :  STD_LOGIC;
                signal internal_linenumber_to_dma_from_the_linebuffer_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal internal_pixel_clock_from_the_arbitrator_inst :  STD_LOGIC;
                signal internal_zs_addr_from_the_sdram :  STD_LOGIC_VECTOR (11 DOWNTO 0);
                signal internal_zs_ba_from_the_sdram :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_zs_cas_n_from_the_sdram :  STD_LOGIC;
                signal internal_zs_cke_from_the_sdram :  STD_LOGIC;
                signal internal_zs_cs_n_from_the_sdram :  STD_LOGIC;
                signal internal_zs_dqm_from_the_sdram :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_zs_ras_n_from_the_sdram :  STD_LOGIC;
                signal internal_zs_we_n_from_the_sdram :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_address :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_chipselect :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_dataavailable :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_irq :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_irq_from_sa :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_read_n :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal jtag_uart_0_avalon_jtag_slave_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal jtag_uart_0_avalon_jtag_slave_readyfordata :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_reset_n :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_waitrequest :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_write_n :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal linebuffer_inst_avalon_slave_0_address :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal linebuffer_inst_avalon_slave_0_chipselect :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_read :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal linebuffer_inst_avalon_slave_0_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal linebuffer_inst_avalon_slave_0_reset :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_write :  STD_LOGIC;
                signal linebuffer_inst_avalon_slave_0_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal module_input6 :  STD_LOGIC;
                signal module_input7 :  STD_LOGIC;
                signal reset_n_sources :  STD_LOGIC;
                signal sdram_s1_address :  STD_LOGIC_VECTOR (21 DOWNTO 0);
                signal sdram_s1_byteenable_n :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sdram_s1_chipselect :  STD_LOGIC;
                signal sdram_s1_read_n :  STD_LOGIC;
                signal sdram_s1_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal sdram_s1_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal sdram_s1_readdatavalid :  STD_LOGIC;
                signal sdram_s1_reset_n :  STD_LOGIC;
                signal sdram_s1_waitrequest :  STD_LOGIC;
                signal sdram_s1_waitrequest_from_sa :  STD_LOGIC;
                signal sdram_s1_write_n :  STD_LOGIC;
                signal sdram_s1_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);

begin

  --the_DM9000A_avalonS, which is an e_instance
  the_DM9000A_avalonS : DM9000A_avalonS_arbitrator
    port map(
      DM9000A_avalonS_address => DM9000A_avalonS_address,
      DM9000A_avalonS_chipselect_n => DM9000A_avalonS_chipselect_n,
      DM9000A_avalonS_irq_from_sa => DM9000A_avalonS_irq_from_sa,
      DM9000A_avalonS_read_n => DM9000A_avalonS_read_n,
      DM9000A_avalonS_readdata_from_sa => DM9000A_avalonS_readdata_from_sa,
      DM9000A_avalonS_reset_n => DM9000A_avalonS_reset_n,
      DM9000A_avalonS_wait_counter_eq_0 => DM9000A_avalonS_wait_counter_eq_0,
      DM9000A_avalonS_write_n => DM9000A_avalonS_write_n,
      DM9000A_avalonS_writedata => DM9000A_avalonS_writedata,
      clock_1_out_granted_DM9000A_avalonS => clock_1_out_granted_DM9000A_avalonS,
      clock_1_out_qualified_request_DM9000A_avalonS => clock_1_out_qualified_request_DM9000A_avalonS,
      clock_1_out_read_data_valid_DM9000A_avalonS => clock_1_out_read_data_valid_DM9000A_avalonS,
      clock_1_out_requests_DM9000A_avalonS => clock_1_out_requests_DM9000A_avalonS,
      d1_DM9000A_avalonS_end_xfer => d1_DM9000A_avalonS_end_xfer,
      DM9000A_avalonS_irq => DM9000A_avalonS_irq,
      DM9000A_avalonS_readdata => DM9000A_avalonS_readdata,
      clk => clk,
      clock_1_out_address_to_slave => clock_1_out_address_to_slave,
      clock_1_out_nativeaddress => clock_1_out_nativeaddress,
      clock_1_out_read => clock_1_out_read,
      clock_1_out_write => clock_1_out_write,
      clock_1_out_writedata => clock_1_out_writedata,
      reset_n => clk_reset_n
    );


  --the_DM9000A, which is an e_ptf_instance
  the_DM9000A : DM9000A
    port map(
      ENET_CMD => internal_ENET_CMD_from_the_DM9000A,
      ENET_CS_N => internal_ENET_CS_N_from_the_DM9000A,
      ENET_DATA => ENET_DATA_to_and_from_the_DM9000A,
      ENET_RD_N => internal_ENET_RD_N_from_the_DM9000A,
      ENET_RST_N => internal_ENET_RST_N_from_the_DM9000A,
      ENET_WR_N => internal_ENET_WR_N_from_the_DM9000A,
      oDATA => DM9000A_avalonS_readdata,
      oINT => DM9000A_avalonS_irq,
      ENET_INT => ENET_INT_to_the_DM9000A,
      iCMD => DM9000A_avalonS_address,
      iCS_N => DM9000A_avalonS_chipselect_n,
      iDATA => DM9000A_avalonS_writedata,
      iRD_N => DM9000A_avalonS_read_n,
      iRST_N => DM9000A_avalonS_reset_n,
      iWR_N => DM9000A_avalonS_write_n
    );


  --the_arbitrator_inst_avalon_slave_0, which is an e_instance
  the_arbitrator_inst_avalon_slave_0 : arbitrator_inst_avalon_slave_0_arbitrator
    port map(
      arbitrator_inst_avalon_slave_0_address => arbitrator_inst_avalon_slave_0_address,
      arbitrator_inst_avalon_slave_0_chipselect => arbitrator_inst_avalon_slave_0_chipselect,
      arbitrator_inst_avalon_slave_0_read => arbitrator_inst_avalon_slave_0_read,
      arbitrator_inst_avalon_slave_0_readdata_from_sa => arbitrator_inst_avalon_slave_0_readdata_from_sa,
      arbitrator_inst_avalon_slave_0_reset => arbitrator_inst_avalon_slave_0_reset,
      arbitrator_inst_avalon_slave_0_waitrequest_from_sa => arbitrator_inst_avalon_slave_0_waitrequest_from_sa,
      arbitrator_inst_avalon_slave_0_write => arbitrator_inst_avalon_slave_0_write,
      arbitrator_inst_avalon_slave_0_writedata => arbitrator_inst_avalon_slave_0_writedata,
      clock_4_out_granted_arbitrator_inst_avalon_slave_0 => clock_4_out_granted_arbitrator_inst_avalon_slave_0,
      clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 => clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0,
      clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0 => clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0,
      clock_4_out_requests_arbitrator_inst_avalon_slave_0 => clock_4_out_requests_arbitrator_inst_avalon_slave_0,
      d1_arbitrator_inst_avalon_slave_0_end_xfer => d1_arbitrator_inst_avalon_slave_0_end_xfer,
      arbitrator_inst_avalon_slave_0_readdata => arbitrator_inst_avalon_slave_0_readdata,
      arbitrator_inst_avalon_slave_0_waitrequest => arbitrator_inst_avalon_slave_0_waitrequest,
      clk => clk,
      clock_4_out_address_to_slave => clock_4_out_address_to_slave,
      clock_4_out_read => clock_4_out_read,
      clock_4_out_write => clock_4_out_write,
      clock_4_out_writedata => clock_4_out_writedata,
      reset_n => clk_reset_n
    );


  --the_arbitrator_inst, which is an e_ptf_instance
  the_arbitrator_inst : arbitrator_inst
    port map(
      BLUE => internal_BLUE_from_the_arbitrator_inst,
      GREEN => internal_GREEN_from_the_arbitrator_inst,
      RED => internal_RED_from_the_arbitrator_inst,
      SRAM_ADDR => internal_SRAM_ADDR_from_the_arbitrator_inst,
      SRAM_CE_N => internal_SRAM_CE_N_from_the_arbitrator_inst,
      SRAM_DQ => SRAM_DQ_to_and_from_the_arbitrator_inst,
      SRAM_LB_N => internal_SRAM_LB_N_from_the_arbitrator_inst,
      SRAM_OE_N => internal_SRAM_OE_N_from_the_arbitrator_inst,
      SRAM_UB_N => internal_SRAM_UB_N_from_the_arbitrator_inst,
      SRAM_WE_N => internal_SRAM_WE_N_from_the_arbitrator_inst,
      busy_to_dma => internal_busy_to_dma_from_the_arbitrator_inst,
      pixel_clock => internal_pixel_clock_from_the_arbitrator_inst,
      readdata => arbitrator_inst_avalon_slave_0_readdata,
      waitrequest => arbitrator_inst_avalon_slave_0_waitrequest,
      HCOUNT => HCOUNT_to_the_arbitrator_inst,
      VCOUNT => VCOUNT_to_the_arbitrator_inst,
      address => arbitrator_inst_avalon_slave_0_address,
      address_from_dma => address_from_dma_to_the_arbitrator_inst,
      chipselect => arbitrator_inst_avalon_slave_0_chipselect,
      clk => clk,
      data_from_dma => data_from_dma_to_the_arbitrator_inst,
      data_ready_from_dma => data_ready_from_dma_to_the_arbitrator_inst,
      read => arbitrator_inst_avalon_slave_0_read,
      reset => arbitrator_inst_avalon_slave_0_reset,
      write => arbitrator_inst_avalon_slave_0_write,
      writedata => arbitrator_inst_avalon_slave_0_writedata
    );


  --the_clock_0_in, which is an e_instance
  the_clock_0_in : clock_0_in_arbitrator
    port map(
      clock_0_in_address => clock_0_in_address,
      clock_0_in_byteenable => clock_0_in_byteenable,
      clock_0_in_endofpacket_from_sa => clock_0_in_endofpacket_from_sa,
      clock_0_in_nativeaddress => clock_0_in_nativeaddress,
      clock_0_in_read => clock_0_in_read,
      clock_0_in_readdata_from_sa => clock_0_in_readdata_from_sa,
      clock_0_in_reset_n => clock_0_in_reset_n,
      clock_0_in_waitrequest_from_sa => clock_0_in_waitrequest_from_sa,
      clock_0_in_write => clock_0_in_write,
      clock_0_in_writedata => clock_0_in_writedata,
      cpu_0_data_master_granted_clock_0_in => cpu_0_data_master_granted_clock_0_in,
      cpu_0_data_master_qualified_request_clock_0_in => cpu_0_data_master_qualified_request_clock_0_in,
      cpu_0_data_master_read_data_valid_clock_0_in => cpu_0_data_master_read_data_valid_clock_0_in,
      cpu_0_data_master_requests_clock_0_in => cpu_0_data_master_requests_clock_0_in,
      d1_clock_0_in_end_xfer => d1_clock_0_in_end_xfer,
      clk => clk_1,
      clock_0_in_endofpacket => clock_0_in_endofpacket,
      clock_0_in_readdata => clock_0_in_readdata,
      clock_0_in_waitrequest => clock_0_in_waitrequest,
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_byteenable => cpu_0_data_master_byteenable,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      cpu_0_data_master_write => cpu_0_data_master_write,
      cpu_0_data_master_writedata => cpu_0_data_master_writedata,
      reset_n => clk_1_reset_n
    );


  --the_clock_0_out, which is an e_instance
  the_clock_0_out : clock_0_out_arbitrator
    port map(
      clock_0_out_address_to_slave => clock_0_out_address_to_slave,
      clock_0_out_readdata => clock_0_out_readdata,
      clock_0_out_reset_n => clock_0_out_reset_n,
      clock_0_out_waitrequest => clock_0_out_waitrequest,
      clk => clk,
      clock_0_out_address => clock_0_out_address,
      clock_0_out_granted_jtag_uart_0_avalon_jtag_slave => clock_0_out_granted_jtag_uart_0_avalon_jtag_slave,
      clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave => clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave,
      clock_0_out_read => clock_0_out_read,
      clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave => clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave,
      clock_0_out_requests_jtag_uart_0_avalon_jtag_slave => clock_0_out_requests_jtag_uart_0_avalon_jtag_slave,
      clock_0_out_write => clock_0_out_write,
      clock_0_out_writedata => clock_0_out_writedata,
      d1_jtag_uart_0_avalon_jtag_slave_end_xfer => d1_jtag_uart_0_avalon_jtag_slave_end_xfer,
      jtag_uart_0_avalon_jtag_slave_readdata_from_sa => jtag_uart_0_avalon_jtag_slave_readdata_from_sa,
      jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa => jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa,
      reset_n => clk_reset_n
    );


  --the_clock_0, which is an e_ptf_instance
  the_clock_0 : clock_0
    port map(
      master_address => clock_0_out_address,
      master_byteenable => clock_0_out_byteenable,
      master_nativeaddress => clock_0_out_nativeaddress,
      master_read => clock_0_out_read,
      master_write => clock_0_out_write,
      master_writedata => clock_0_out_writedata,
      slave_endofpacket => clock_0_in_endofpacket,
      slave_readdata => clock_0_in_readdata,
      slave_waitrequest => clock_0_in_waitrequest,
      master_clk => clk,
      master_endofpacket => clock_0_out_endofpacket,
      master_readdata => clock_0_out_readdata,
      master_reset_n => clock_0_out_reset_n,
      master_waitrequest => clock_0_out_waitrequest,
      slave_address => clock_0_in_address,
      slave_byteenable => clock_0_in_byteenable,
      slave_clk => clk_1,
      slave_nativeaddress => clock_0_in_nativeaddress,
      slave_read => clock_0_in_read,
      slave_reset_n => clock_0_in_reset_n,
      slave_write => clock_0_in_write,
      slave_writedata => clock_0_in_writedata
    );


  --the_clock_1_in, which is an e_instance
  the_clock_1_in : clock_1_in_arbitrator
    port map(
      clock_1_in_address => clock_1_in_address,
      clock_1_in_byteenable => clock_1_in_byteenable,
      clock_1_in_endofpacket_from_sa => clock_1_in_endofpacket_from_sa,
      clock_1_in_nativeaddress => clock_1_in_nativeaddress,
      clock_1_in_read => clock_1_in_read,
      clock_1_in_readdata_from_sa => clock_1_in_readdata_from_sa,
      clock_1_in_reset_n => clock_1_in_reset_n,
      clock_1_in_waitrequest_from_sa => clock_1_in_waitrequest_from_sa,
      clock_1_in_write => clock_1_in_write,
      clock_1_in_writedata => clock_1_in_writedata,
      cpu_0_data_master_granted_clock_1_in => cpu_0_data_master_granted_clock_1_in,
      cpu_0_data_master_qualified_request_clock_1_in => cpu_0_data_master_qualified_request_clock_1_in,
      cpu_0_data_master_read_data_valid_clock_1_in => cpu_0_data_master_read_data_valid_clock_1_in,
      cpu_0_data_master_requests_clock_1_in => cpu_0_data_master_requests_clock_1_in,
      d1_clock_1_in_end_xfer => d1_clock_1_in_end_xfer,
      clk => clk_1,
      clock_1_in_endofpacket => clock_1_in_endofpacket,
      clock_1_in_readdata => clock_1_in_readdata,
      clock_1_in_waitrequest => clock_1_in_waitrequest,
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_byteenable => cpu_0_data_master_byteenable,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      cpu_0_data_master_write => cpu_0_data_master_write,
      cpu_0_data_master_writedata => cpu_0_data_master_writedata,
      reset_n => clk_1_reset_n
    );


  --the_clock_1_out, which is an e_instance
  the_clock_1_out : clock_1_out_arbitrator
    port map(
      clock_1_out_address_to_slave => clock_1_out_address_to_slave,
      clock_1_out_readdata => clock_1_out_readdata,
      clock_1_out_reset_n => clock_1_out_reset_n,
      clock_1_out_waitrequest => clock_1_out_waitrequest,
      DM9000A_avalonS_readdata_from_sa => DM9000A_avalonS_readdata_from_sa,
      DM9000A_avalonS_wait_counter_eq_0 => DM9000A_avalonS_wait_counter_eq_0,
      clk => clk,
      clock_1_out_address => clock_1_out_address,
      clock_1_out_granted_DM9000A_avalonS => clock_1_out_granted_DM9000A_avalonS,
      clock_1_out_qualified_request_DM9000A_avalonS => clock_1_out_qualified_request_DM9000A_avalonS,
      clock_1_out_read => clock_1_out_read,
      clock_1_out_read_data_valid_DM9000A_avalonS => clock_1_out_read_data_valid_DM9000A_avalonS,
      clock_1_out_requests_DM9000A_avalonS => clock_1_out_requests_DM9000A_avalonS,
      clock_1_out_write => clock_1_out_write,
      clock_1_out_writedata => clock_1_out_writedata,
      d1_DM9000A_avalonS_end_xfer => d1_DM9000A_avalonS_end_xfer,
      reset_n => clk_reset_n
    );


  --the_clock_1, which is an e_ptf_instance
  the_clock_1 : clock_1
    port map(
      master_address => clock_1_out_address,
      master_byteenable => clock_1_out_byteenable,
      master_nativeaddress => clock_1_out_nativeaddress,
      master_read => clock_1_out_read,
      master_write => clock_1_out_write,
      master_writedata => clock_1_out_writedata,
      slave_endofpacket => clock_1_in_endofpacket,
      slave_readdata => clock_1_in_readdata,
      slave_waitrequest => clock_1_in_waitrequest,
      master_clk => clk,
      master_endofpacket => clock_1_out_endofpacket,
      master_readdata => clock_1_out_readdata,
      master_reset_n => clock_1_out_reset_n,
      master_waitrequest => clock_1_out_waitrequest,
      slave_address => clock_1_in_address,
      slave_byteenable => clock_1_in_byteenable,
      slave_clk => clk_1,
      slave_nativeaddress => clock_1_in_nativeaddress,
      slave_read => clock_1_in_read,
      slave_reset_n => clock_1_in_reset_n,
      slave_write => clock_1_in_write,
      slave_writedata => clock_1_in_writedata
    );


  --the_clock_2_in, which is an e_instance
  the_clock_2_in : clock_2_in_arbitrator
    port map(
      clock_2_in_address => clock_2_in_address,
      clock_2_in_byteenable => clock_2_in_byteenable,
      clock_2_in_endofpacket_from_sa => clock_2_in_endofpacket_from_sa,
      clock_2_in_nativeaddress => clock_2_in_nativeaddress,
      clock_2_in_read => clock_2_in_read,
      clock_2_in_readdata_from_sa => clock_2_in_readdata_from_sa,
      clock_2_in_reset_n => clock_2_in_reset_n,
      clock_2_in_waitrequest_from_sa => clock_2_in_waitrequest_from_sa,
      clock_2_in_write => clock_2_in_write,
      cpu_0_instruction_master_granted_clock_2_in => cpu_0_instruction_master_granted_clock_2_in,
      cpu_0_instruction_master_qualified_request_clock_2_in => cpu_0_instruction_master_qualified_request_clock_2_in,
      cpu_0_instruction_master_read_data_valid_clock_2_in => cpu_0_instruction_master_read_data_valid_clock_2_in,
      cpu_0_instruction_master_requests_clock_2_in => cpu_0_instruction_master_requests_clock_2_in,
      d1_clock_2_in_end_xfer => d1_clock_2_in_end_xfer,
      clk => clk_1,
      clock_2_in_endofpacket => clock_2_in_endofpacket,
      clock_2_in_readdata => clock_2_in_readdata,
      clock_2_in_waitrequest => clock_2_in_waitrequest,
      cpu_0_instruction_master_address_to_slave => cpu_0_instruction_master_address_to_slave,
      cpu_0_instruction_master_latency_counter => cpu_0_instruction_master_latency_counter,
      cpu_0_instruction_master_read => cpu_0_instruction_master_read,
      cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register => cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register,
      reset_n => clk_1_reset_n
    );


  --the_clock_2_out, which is an e_instance
  the_clock_2_out : clock_2_out_arbitrator
    port map(
      clock_2_out_address_to_slave => clock_2_out_address_to_slave,
      clock_2_out_endofpacket => clock_2_out_endofpacket,
      clock_2_out_readdata => clock_2_out_readdata,
      clock_2_out_reset_n => clock_2_out_reset_n,
      clock_2_out_waitrequest => clock_2_out_waitrequest,
      clk => clk,
      clock_2_out_address => clock_2_out_address,
      clock_2_out_granted_epcs_controller_epcs_control_port => clock_2_out_granted_epcs_controller_epcs_control_port,
      clock_2_out_qualified_request_epcs_controller_epcs_control_port => clock_2_out_qualified_request_epcs_controller_epcs_control_port,
      clock_2_out_read => clock_2_out_read,
      clock_2_out_read_data_valid_epcs_controller_epcs_control_port => clock_2_out_read_data_valid_epcs_controller_epcs_control_port,
      clock_2_out_requests_epcs_controller_epcs_control_port => clock_2_out_requests_epcs_controller_epcs_control_port,
      clock_2_out_write => clock_2_out_write,
      clock_2_out_writedata => clock_2_out_writedata,
      d1_epcs_controller_epcs_control_port_end_xfer => d1_epcs_controller_epcs_control_port_end_xfer,
      epcs_controller_epcs_control_port_endofpacket_from_sa => epcs_controller_epcs_control_port_endofpacket_from_sa,
      epcs_controller_epcs_control_port_readdata_from_sa => epcs_controller_epcs_control_port_readdata_from_sa,
      reset_n => clk_reset_n
    );


  --the_clock_2, which is an e_ptf_instance
  the_clock_2 : clock_2
    port map(
      master_address => clock_2_out_address,
      master_byteenable => clock_2_out_byteenable,
      master_nativeaddress => clock_2_out_nativeaddress,
      master_read => clock_2_out_read,
      master_write => clock_2_out_write,
      master_writedata => clock_2_out_writedata,
      slave_endofpacket => clock_2_in_endofpacket,
      slave_readdata => clock_2_in_readdata,
      slave_waitrequest => clock_2_in_waitrequest,
      master_clk => clk,
      master_endofpacket => clock_2_out_endofpacket,
      master_readdata => clock_2_out_readdata,
      master_reset_n => clock_2_out_reset_n,
      master_waitrequest => clock_2_out_waitrequest,
      slave_address => clock_2_in_address,
      slave_byteenable => clock_2_in_byteenable,
      slave_clk => clk_1,
      slave_nativeaddress => clock_2_in_nativeaddress,
      slave_read => clock_2_in_read,
      slave_reset_n => clock_2_in_reset_n,
      slave_write => clock_2_in_write,
      slave_writedata => clock_2_in_writedata
    );


  --the_clock_3_in, which is an e_instance
  the_clock_3_in : clock_3_in_arbitrator
    port map(
      clock_3_in_address => clock_3_in_address,
      clock_3_in_byteenable => clock_3_in_byteenable,
      clock_3_in_endofpacket_from_sa => clock_3_in_endofpacket_from_sa,
      clock_3_in_nativeaddress => clock_3_in_nativeaddress,
      clock_3_in_read => clock_3_in_read,
      clock_3_in_readdata_from_sa => clock_3_in_readdata_from_sa,
      clock_3_in_reset_n => clock_3_in_reset_n,
      clock_3_in_waitrequest_from_sa => clock_3_in_waitrequest_from_sa,
      clock_3_in_write => clock_3_in_write,
      clock_3_in_writedata => clock_3_in_writedata,
      cpu_0_data_master_granted_clock_3_in => cpu_0_data_master_granted_clock_3_in,
      cpu_0_data_master_qualified_request_clock_3_in => cpu_0_data_master_qualified_request_clock_3_in,
      cpu_0_data_master_read_data_valid_clock_3_in => cpu_0_data_master_read_data_valid_clock_3_in,
      cpu_0_data_master_requests_clock_3_in => cpu_0_data_master_requests_clock_3_in,
      d1_clock_3_in_end_xfer => d1_clock_3_in_end_xfer,
      clk => clk_1,
      clock_3_in_endofpacket => clock_3_in_endofpacket,
      clock_3_in_readdata => clock_3_in_readdata,
      clock_3_in_waitrequest => clock_3_in_waitrequest,
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_byteenable => cpu_0_data_master_byteenable,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      cpu_0_data_master_write => cpu_0_data_master_write,
      cpu_0_data_master_writedata => cpu_0_data_master_writedata,
      reset_n => clk_1_reset_n
    );


  --the_clock_3_out, which is an e_instance
  the_clock_3_out : clock_3_out_arbitrator
    port map(
      clock_3_out_address_to_slave => clock_3_out_address_to_slave,
      clock_3_out_endofpacket => clock_3_out_endofpacket,
      clock_3_out_readdata => clock_3_out_readdata,
      clock_3_out_reset_n => clock_3_out_reset_n,
      clock_3_out_waitrequest => clock_3_out_waitrequest,
      clk => clk,
      clock_3_out_address => clock_3_out_address,
      clock_3_out_granted_epcs_controller_epcs_control_port => clock_3_out_granted_epcs_controller_epcs_control_port,
      clock_3_out_qualified_request_epcs_controller_epcs_control_port => clock_3_out_qualified_request_epcs_controller_epcs_control_port,
      clock_3_out_read => clock_3_out_read,
      clock_3_out_read_data_valid_epcs_controller_epcs_control_port => clock_3_out_read_data_valid_epcs_controller_epcs_control_port,
      clock_3_out_requests_epcs_controller_epcs_control_port => clock_3_out_requests_epcs_controller_epcs_control_port,
      clock_3_out_write => clock_3_out_write,
      clock_3_out_writedata => clock_3_out_writedata,
      d1_epcs_controller_epcs_control_port_end_xfer => d1_epcs_controller_epcs_control_port_end_xfer,
      epcs_controller_epcs_control_port_endofpacket_from_sa => epcs_controller_epcs_control_port_endofpacket_from_sa,
      epcs_controller_epcs_control_port_readdata_from_sa => epcs_controller_epcs_control_port_readdata_from_sa,
      reset_n => clk_reset_n
    );


  --the_clock_3, which is an e_ptf_instance
  the_clock_3 : clock_3
    port map(
      master_address => clock_3_out_address,
      master_byteenable => clock_3_out_byteenable,
      master_nativeaddress => clock_3_out_nativeaddress,
      master_read => clock_3_out_read,
      master_write => clock_3_out_write,
      master_writedata => clock_3_out_writedata,
      slave_endofpacket => clock_3_in_endofpacket,
      slave_readdata => clock_3_in_readdata,
      slave_waitrequest => clock_3_in_waitrequest,
      master_clk => clk,
      master_endofpacket => clock_3_out_endofpacket,
      master_readdata => clock_3_out_readdata,
      master_reset_n => clock_3_out_reset_n,
      master_waitrequest => clock_3_out_waitrequest,
      slave_address => clock_3_in_address,
      slave_byteenable => clock_3_in_byteenable,
      slave_clk => clk_1,
      slave_nativeaddress => clock_3_in_nativeaddress,
      slave_read => clock_3_in_read,
      slave_reset_n => clock_3_in_reset_n,
      slave_write => clock_3_in_write,
      slave_writedata => clock_3_in_writedata
    );


  --the_clock_4_in, which is an e_instance
  the_clock_4_in : clock_4_in_arbitrator
    port map(
      clock_4_in_address => clock_4_in_address,
      clock_4_in_byteenable => clock_4_in_byteenable,
      clock_4_in_endofpacket_from_sa => clock_4_in_endofpacket_from_sa,
      clock_4_in_nativeaddress => clock_4_in_nativeaddress,
      clock_4_in_read => clock_4_in_read,
      clock_4_in_readdata_from_sa => clock_4_in_readdata_from_sa,
      clock_4_in_reset_n => clock_4_in_reset_n,
      clock_4_in_waitrequest_from_sa => clock_4_in_waitrequest_from_sa,
      clock_4_in_write => clock_4_in_write,
      clock_4_in_writedata => clock_4_in_writedata,
      cpu_0_data_master_byteenable_clock_4_in => cpu_0_data_master_byteenable_clock_4_in,
      cpu_0_data_master_granted_clock_4_in => cpu_0_data_master_granted_clock_4_in,
      cpu_0_data_master_qualified_request_clock_4_in => cpu_0_data_master_qualified_request_clock_4_in,
      cpu_0_data_master_read_data_valid_clock_4_in => cpu_0_data_master_read_data_valid_clock_4_in,
      cpu_0_data_master_requests_clock_4_in => cpu_0_data_master_requests_clock_4_in,
      d1_clock_4_in_end_xfer => d1_clock_4_in_end_xfer,
      clk => clk_1,
      clock_4_in_endofpacket => clock_4_in_endofpacket,
      clock_4_in_readdata => clock_4_in_readdata,
      clock_4_in_waitrequest => clock_4_in_waitrequest,
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_byteenable => cpu_0_data_master_byteenable,
      cpu_0_data_master_dbs_address => cpu_0_data_master_dbs_address,
      cpu_0_data_master_dbs_write_16 => cpu_0_data_master_dbs_write_16,
      cpu_0_data_master_no_byte_enables_and_last_term => cpu_0_data_master_no_byte_enables_and_last_term,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      cpu_0_data_master_write => cpu_0_data_master_write,
      reset_n => clk_1_reset_n
    );


  --the_clock_4_out, which is an e_instance
  the_clock_4_out : clock_4_out_arbitrator
    port map(
      clock_4_out_address_to_slave => clock_4_out_address_to_slave,
      clock_4_out_readdata => clock_4_out_readdata,
      clock_4_out_reset_n => clock_4_out_reset_n,
      clock_4_out_waitrequest => clock_4_out_waitrequest,
      arbitrator_inst_avalon_slave_0_readdata_from_sa => arbitrator_inst_avalon_slave_0_readdata_from_sa,
      arbitrator_inst_avalon_slave_0_waitrequest_from_sa => arbitrator_inst_avalon_slave_0_waitrequest_from_sa,
      clk => clk,
      clock_4_out_address => clock_4_out_address,
      clock_4_out_granted_arbitrator_inst_avalon_slave_0 => clock_4_out_granted_arbitrator_inst_avalon_slave_0,
      clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0 => clock_4_out_qualified_request_arbitrator_inst_avalon_slave_0,
      clock_4_out_read => clock_4_out_read,
      clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0 => clock_4_out_read_data_valid_arbitrator_inst_avalon_slave_0,
      clock_4_out_requests_arbitrator_inst_avalon_slave_0 => clock_4_out_requests_arbitrator_inst_avalon_slave_0,
      clock_4_out_write => clock_4_out_write,
      clock_4_out_writedata => clock_4_out_writedata,
      d1_arbitrator_inst_avalon_slave_0_end_xfer => d1_arbitrator_inst_avalon_slave_0_end_xfer,
      reset_n => clk_reset_n
    );


  --the_clock_4, which is an e_ptf_instance
  the_clock_4 : clock_4
    port map(
      master_address => clock_4_out_address,
      master_byteenable => clock_4_out_byteenable,
      master_nativeaddress => clock_4_out_nativeaddress,
      master_read => clock_4_out_read,
      master_write => clock_4_out_write,
      master_writedata => clock_4_out_writedata,
      slave_endofpacket => clock_4_in_endofpacket,
      slave_readdata => clock_4_in_readdata,
      slave_waitrequest => clock_4_in_waitrequest,
      master_clk => clk,
      master_endofpacket => clock_4_out_endofpacket,
      master_readdata => clock_4_out_readdata,
      master_reset_n => clock_4_out_reset_n,
      master_waitrequest => clock_4_out_waitrequest,
      slave_address => clock_4_in_address,
      slave_byteenable => clock_4_in_byteenable,
      slave_clk => clk_1,
      slave_nativeaddress => clock_4_in_nativeaddress,
      slave_read => clock_4_in_read,
      slave_reset_n => clock_4_in_reset_n,
      slave_write => clock_4_in_write,
      slave_writedata => clock_4_in_writedata
    );


  --the_clock_5_in, which is an e_instance
  the_clock_5_in : clock_5_in_arbitrator
    port map(
      clock_5_in_address => clock_5_in_address,
      clock_5_in_byteenable => clock_5_in_byteenable,
      clock_5_in_endofpacket_from_sa => clock_5_in_endofpacket_from_sa,
      clock_5_in_nativeaddress => clock_5_in_nativeaddress,
      clock_5_in_read => clock_5_in_read,
      clock_5_in_readdata_from_sa => clock_5_in_readdata_from_sa,
      clock_5_in_reset_n => clock_5_in_reset_n,
      clock_5_in_waitrequest_from_sa => clock_5_in_waitrequest_from_sa,
      clock_5_in_write => clock_5_in_write,
      clock_5_in_writedata => clock_5_in_writedata,
      cpu_0_data_master_byteenable_clock_5_in => cpu_0_data_master_byteenable_clock_5_in,
      cpu_0_data_master_granted_clock_5_in => cpu_0_data_master_granted_clock_5_in,
      cpu_0_data_master_qualified_request_clock_5_in => cpu_0_data_master_qualified_request_clock_5_in,
      cpu_0_data_master_read_data_valid_clock_5_in => cpu_0_data_master_read_data_valid_clock_5_in,
      cpu_0_data_master_requests_clock_5_in => cpu_0_data_master_requests_clock_5_in,
      d1_clock_5_in_end_xfer => d1_clock_5_in_end_xfer,
      clk => clk_1,
      clock_5_in_endofpacket => clock_5_in_endofpacket,
      clock_5_in_readdata => clock_5_in_readdata,
      clock_5_in_waitrequest => clock_5_in_waitrequest,
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_byteenable => cpu_0_data_master_byteenable,
      cpu_0_data_master_dbs_address => cpu_0_data_master_dbs_address,
      cpu_0_data_master_dbs_write_16 => cpu_0_data_master_dbs_write_16,
      cpu_0_data_master_no_byte_enables_and_last_term => cpu_0_data_master_no_byte_enables_and_last_term,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      cpu_0_data_master_write => cpu_0_data_master_write,
      reset_n => clk_1_reset_n
    );


  --the_clock_5_out, which is an e_instance
  the_clock_5_out : clock_5_out_arbitrator
    port map(
      clock_5_out_address_to_slave => clock_5_out_address_to_slave,
      clock_5_out_readdata => clock_5_out_readdata,
      clock_5_out_reset_n => clock_5_out_reset_n,
      clock_5_out_waitrequest => clock_5_out_waitrequest,
      clk => clk,
      clock_5_out_address => clock_5_out_address,
      clock_5_out_granted_linebuffer_inst_avalon_slave_0 => clock_5_out_granted_linebuffer_inst_avalon_slave_0,
      clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 => clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0,
      clock_5_out_read => clock_5_out_read,
      clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0 => clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0,
      clock_5_out_requests_linebuffer_inst_avalon_slave_0 => clock_5_out_requests_linebuffer_inst_avalon_slave_0,
      clock_5_out_write => clock_5_out_write,
      clock_5_out_writedata => clock_5_out_writedata,
      d1_linebuffer_inst_avalon_slave_0_end_xfer => d1_linebuffer_inst_avalon_slave_0_end_xfer,
      linebuffer_inst_avalon_slave_0_readdata_from_sa => linebuffer_inst_avalon_slave_0_readdata_from_sa,
      reset_n => clk_reset_n
    );


  --the_clock_5, which is an e_ptf_instance
  the_clock_5 : clock_5
    port map(
      master_address => clock_5_out_address,
      master_byteenable => clock_5_out_byteenable,
      master_nativeaddress => clock_5_out_nativeaddress,
      master_read => clock_5_out_read,
      master_write => clock_5_out_write,
      master_writedata => clock_5_out_writedata,
      slave_endofpacket => clock_5_in_endofpacket,
      slave_readdata => clock_5_in_readdata,
      slave_waitrequest => clock_5_in_waitrequest,
      master_clk => clk,
      master_endofpacket => clock_5_out_endofpacket,
      master_readdata => clock_5_out_readdata,
      master_reset_n => clock_5_out_reset_n,
      master_waitrequest => clock_5_out_waitrequest,
      slave_address => clock_5_in_address,
      slave_byteenable => clock_5_in_byteenable,
      slave_clk => clk_1,
      slave_nativeaddress => clock_5_in_nativeaddress,
      slave_read => clock_5_in_read,
      slave_reset_n => clock_5_in_reset_n,
      slave_write => clock_5_in_write,
      slave_writedata => clock_5_in_writedata
    );


  --the_cpu_0_jtag_debug_module, which is an e_instance
  the_cpu_0_jtag_debug_module : cpu_0_jtag_debug_module_arbitrator
    port map(
      cpu_0_data_master_granted_cpu_0_jtag_debug_module => cpu_0_data_master_granted_cpu_0_jtag_debug_module,
      cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module => cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module,
      cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module => cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module,
      cpu_0_data_master_requests_cpu_0_jtag_debug_module => cpu_0_data_master_requests_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_granted_cpu_0_jtag_debug_module => cpu_0_instruction_master_granted_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module => cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module => cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_requests_cpu_0_jtag_debug_module => cpu_0_instruction_master_requests_cpu_0_jtag_debug_module,
      cpu_0_jtag_debug_module_address => cpu_0_jtag_debug_module_address,
      cpu_0_jtag_debug_module_begintransfer => cpu_0_jtag_debug_module_begintransfer,
      cpu_0_jtag_debug_module_byteenable => cpu_0_jtag_debug_module_byteenable,
      cpu_0_jtag_debug_module_chipselect => cpu_0_jtag_debug_module_chipselect,
      cpu_0_jtag_debug_module_debugaccess => cpu_0_jtag_debug_module_debugaccess,
      cpu_0_jtag_debug_module_readdata_from_sa => cpu_0_jtag_debug_module_readdata_from_sa,
      cpu_0_jtag_debug_module_reset => cpu_0_jtag_debug_module_reset,
      cpu_0_jtag_debug_module_reset_n => cpu_0_jtag_debug_module_reset_n,
      cpu_0_jtag_debug_module_resetrequest_from_sa => cpu_0_jtag_debug_module_resetrequest_from_sa,
      cpu_0_jtag_debug_module_write => cpu_0_jtag_debug_module_write,
      cpu_0_jtag_debug_module_writedata => cpu_0_jtag_debug_module_writedata,
      d1_cpu_0_jtag_debug_module_end_xfer => d1_cpu_0_jtag_debug_module_end_xfer,
      clk => clk_1,
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_byteenable => cpu_0_data_master_byteenable,
      cpu_0_data_master_debugaccess => cpu_0_data_master_debugaccess,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      cpu_0_data_master_write => cpu_0_data_master_write,
      cpu_0_data_master_writedata => cpu_0_data_master_writedata,
      cpu_0_instruction_master_address_to_slave => cpu_0_instruction_master_address_to_slave,
      cpu_0_instruction_master_latency_counter => cpu_0_instruction_master_latency_counter,
      cpu_0_instruction_master_read => cpu_0_instruction_master_read,
      cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register => cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register,
      cpu_0_jtag_debug_module_readdata => cpu_0_jtag_debug_module_readdata,
      cpu_0_jtag_debug_module_resetrequest => cpu_0_jtag_debug_module_resetrequest,
      reset_n => clk_1_reset_n
    );


  --the_cpu_0_data_master, which is an e_instance
  the_cpu_0_data_master : cpu_0_data_master_arbitrator
    port map(
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_dbs_address => cpu_0_data_master_dbs_address,
      cpu_0_data_master_dbs_write_16 => cpu_0_data_master_dbs_write_16,
      cpu_0_data_master_irq => cpu_0_data_master_irq,
      cpu_0_data_master_no_byte_enables_and_last_term => cpu_0_data_master_no_byte_enables_and_last_term,
      cpu_0_data_master_readdata => cpu_0_data_master_readdata,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      DM9000A_avalonS_irq_from_sa => DM9000A_avalonS_irq_from_sa,
      clk => clk_1,
      clk_1 => clk_1,
      clk_1_reset_n => clk_1_reset_n,
      clock_0_in_readdata_from_sa => clock_0_in_readdata_from_sa,
      clock_0_in_waitrequest_from_sa => clock_0_in_waitrequest_from_sa,
      clock_1_in_readdata_from_sa => clock_1_in_readdata_from_sa,
      clock_1_in_waitrequest_from_sa => clock_1_in_waitrequest_from_sa,
      clock_3_in_readdata_from_sa => clock_3_in_readdata_from_sa,
      clock_3_in_waitrequest_from_sa => clock_3_in_waitrequest_from_sa,
      clock_4_in_readdata_from_sa => clock_4_in_readdata_from_sa,
      clock_4_in_waitrequest_from_sa => clock_4_in_waitrequest_from_sa,
      clock_5_in_readdata_from_sa => clock_5_in_readdata_from_sa,
      clock_5_in_waitrequest_from_sa => clock_5_in_waitrequest_from_sa,
      cpu_0_data_master_address => cpu_0_data_master_address,
      cpu_0_data_master_byteenable_clock_4_in => cpu_0_data_master_byteenable_clock_4_in,
      cpu_0_data_master_byteenable_clock_5_in => cpu_0_data_master_byteenable_clock_5_in,
      cpu_0_data_master_byteenable_sdram_s1 => cpu_0_data_master_byteenable_sdram_s1,
      cpu_0_data_master_debugaccess => cpu_0_data_master_debugaccess,
      cpu_0_data_master_granted_clock_0_in => cpu_0_data_master_granted_clock_0_in,
      cpu_0_data_master_granted_clock_1_in => cpu_0_data_master_granted_clock_1_in,
      cpu_0_data_master_granted_clock_3_in => cpu_0_data_master_granted_clock_3_in,
      cpu_0_data_master_granted_clock_4_in => cpu_0_data_master_granted_clock_4_in,
      cpu_0_data_master_granted_clock_5_in => cpu_0_data_master_granted_clock_5_in,
      cpu_0_data_master_granted_cpu_0_jtag_debug_module => cpu_0_data_master_granted_cpu_0_jtag_debug_module,
      cpu_0_data_master_granted_sdram_s1 => cpu_0_data_master_granted_sdram_s1,
      cpu_0_data_master_qualified_request_clock_0_in => cpu_0_data_master_qualified_request_clock_0_in,
      cpu_0_data_master_qualified_request_clock_1_in => cpu_0_data_master_qualified_request_clock_1_in,
      cpu_0_data_master_qualified_request_clock_3_in => cpu_0_data_master_qualified_request_clock_3_in,
      cpu_0_data_master_qualified_request_clock_4_in => cpu_0_data_master_qualified_request_clock_4_in,
      cpu_0_data_master_qualified_request_clock_5_in => cpu_0_data_master_qualified_request_clock_5_in,
      cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module => cpu_0_data_master_qualified_request_cpu_0_jtag_debug_module,
      cpu_0_data_master_qualified_request_sdram_s1 => cpu_0_data_master_qualified_request_sdram_s1,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_read_data_valid_clock_0_in => cpu_0_data_master_read_data_valid_clock_0_in,
      cpu_0_data_master_read_data_valid_clock_1_in => cpu_0_data_master_read_data_valid_clock_1_in,
      cpu_0_data_master_read_data_valid_clock_3_in => cpu_0_data_master_read_data_valid_clock_3_in,
      cpu_0_data_master_read_data_valid_clock_4_in => cpu_0_data_master_read_data_valid_clock_4_in,
      cpu_0_data_master_read_data_valid_clock_5_in => cpu_0_data_master_read_data_valid_clock_5_in,
      cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module => cpu_0_data_master_read_data_valid_cpu_0_jtag_debug_module,
      cpu_0_data_master_read_data_valid_sdram_s1 => cpu_0_data_master_read_data_valid_sdram_s1,
      cpu_0_data_master_read_data_valid_sdram_s1_shift_register => cpu_0_data_master_read_data_valid_sdram_s1_shift_register,
      cpu_0_data_master_requests_clock_0_in => cpu_0_data_master_requests_clock_0_in,
      cpu_0_data_master_requests_clock_1_in => cpu_0_data_master_requests_clock_1_in,
      cpu_0_data_master_requests_clock_3_in => cpu_0_data_master_requests_clock_3_in,
      cpu_0_data_master_requests_clock_4_in => cpu_0_data_master_requests_clock_4_in,
      cpu_0_data_master_requests_clock_5_in => cpu_0_data_master_requests_clock_5_in,
      cpu_0_data_master_requests_cpu_0_jtag_debug_module => cpu_0_data_master_requests_cpu_0_jtag_debug_module,
      cpu_0_data_master_requests_sdram_s1 => cpu_0_data_master_requests_sdram_s1,
      cpu_0_data_master_write => cpu_0_data_master_write,
      cpu_0_data_master_writedata => cpu_0_data_master_writedata,
      cpu_0_jtag_debug_module_readdata_from_sa => cpu_0_jtag_debug_module_readdata_from_sa,
      d1_clock_0_in_end_xfer => d1_clock_0_in_end_xfer,
      d1_clock_1_in_end_xfer => d1_clock_1_in_end_xfer,
      d1_clock_3_in_end_xfer => d1_clock_3_in_end_xfer,
      d1_clock_4_in_end_xfer => d1_clock_4_in_end_xfer,
      d1_clock_5_in_end_xfer => d1_clock_5_in_end_xfer,
      d1_cpu_0_jtag_debug_module_end_xfer => d1_cpu_0_jtag_debug_module_end_xfer,
      d1_sdram_s1_end_xfer => d1_sdram_s1_end_xfer,
      epcs_controller_epcs_control_port_irq_from_sa => epcs_controller_epcs_control_port_irq_from_sa,
      jtag_uart_0_avalon_jtag_slave_irq_from_sa => jtag_uart_0_avalon_jtag_slave_irq_from_sa,
      reset_n => clk_1_reset_n,
      sdram_s1_readdata_from_sa => sdram_s1_readdata_from_sa,
      sdram_s1_waitrequest_from_sa => sdram_s1_waitrequest_from_sa
    );


  --the_cpu_0_instruction_master, which is an e_instance
  the_cpu_0_instruction_master : cpu_0_instruction_master_arbitrator
    port map(
      cpu_0_instruction_master_address_to_slave => cpu_0_instruction_master_address_to_slave,
      cpu_0_instruction_master_dbs_address => cpu_0_instruction_master_dbs_address,
      cpu_0_instruction_master_latency_counter => cpu_0_instruction_master_latency_counter,
      cpu_0_instruction_master_readdata => cpu_0_instruction_master_readdata,
      cpu_0_instruction_master_readdatavalid => cpu_0_instruction_master_readdatavalid,
      cpu_0_instruction_master_waitrequest => cpu_0_instruction_master_waitrequest,
      clk => clk_1,
      clock_2_in_readdata_from_sa => clock_2_in_readdata_from_sa,
      clock_2_in_waitrequest_from_sa => clock_2_in_waitrequest_from_sa,
      cpu_0_instruction_master_address => cpu_0_instruction_master_address,
      cpu_0_instruction_master_granted_clock_2_in => cpu_0_instruction_master_granted_clock_2_in,
      cpu_0_instruction_master_granted_cpu_0_jtag_debug_module => cpu_0_instruction_master_granted_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_granted_sdram_s1 => cpu_0_instruction_master_granted_sdram_s1,
      cpu_0_instruction_master_qualified_request_clock_2_in => cpu_0_instruction_master_qualified_request_clock_2_in,
      cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module => cpu_0_instruction_master_qualified_request_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_qualified_request_sdram_s1 => cpu_0_instruction_master_qualified_request_sdram_s1,
      cpu_0_instruction_master_read => cpu_0_instruction_master_read,
      cpu_0_instruction_master_read_data_valid_clock_2_in => cpu_0_instruction_master_read_data_valid_clock_2_in,
      cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module => cpu_0_instruction_master_read_data_valid_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_read_data_valid_sdram_s1 => cpu_0_instruction_master_read_data_valid_sdram_s1,
      cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register => cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register,
      cpu_0_instruction_master_requests_clock_2_in => cpu_0_instruction_master_requests_clock_2_in,
      cpu_0_instruction_master_requests_cpu_0_jtag_debug_module => cpu_0_instruction_master_requests_cpu_0_jtag_debug_module,
      cpu_0_instruction_master_requests_sdram_s1 => cpu_0_instruction_master_requests_sdram_s1,
      cpu_0_jtag_debug_module_readdata_from_sa => cpu_0_jtag_debug_module_readdata_from_sa,
      d1_clock_2_in_end_xfer => d1_clock_2_in_end_xfer,
      d1_cpu_0_jtag_debug_module_end_xfer => d1_cpu_0_jtag_debug_module_end_xfer,
      d1_sdram_s1_end_xfer => d1_sdram_s1_end_xfer,
      reset_n => clk_1_reset_n,
      sdram_s1_readdata_from_sa => sdram_s1_readdata_from_sa,
      sdram_s1_waitrequest_from_sa => sdram_s1_waitrequest_from_sa
    );


  --the_cpu_0, which is an e_ptf_instance
  the_cpu_0 : cpu_0
    port map(
      d_address => cpu_0_data_master_address,
      d_byteenable => cpu_0_data_master_byteenable,
      d_read => cpu_0_data_master_read,
      d_write => cpu_0_data_master_write,
      d_writedata => cpu_0_data_master_writedata,
      i_address => cpu_0_instruction_master_address,
      i_read => cpu_0_instruction_master_read,
      jtag_debug_module_debugaccess_to_roms => cpu_0_data_master_debugaccess,
      jtag_debug_module_readdata => cpu_0_jtag_debug_module_readdata,
      jtag_debug_module_resetrequest => cpu_0_jtag_debug_module_resetrequest,
      clk => clk_1,
      d_irq => cpu_0_data_master_irq,
      d_readdata => cpu_0_data_master_readdata,
      d_waitrequest => cpu_0_data_master_waitrequest,
      i_readdata => cpu_0_instruction_master_readdata,
      i_readdatavalid => cpu_0_instruction_master_readdatavalid,
      i_waitrequest => cpu_0_instruction_master_waitrequest,
      jtag_debug_module_address => cpu_0_jtag_debug_module_address,
      jtag_debug_module_begintransfer => cpu_0_jtag_debug_module_begintransfer,
      jtag_debug_module_byteenable => cpu_0_jtag_debug_module_byteenable,
      jtag_debug_module_clk => clk_1,
      jtag_debug_module_debugaccess => cpu_0_jtag_debug_module_debugaccess,
      jtag_debug_module_reset => cpu_0_jtag_debug_module_reset,
      jtag_debug_module_select => cpu_0_jtag_debug_module_chipselect,
      jtag_debug_module_write => cpu_0_jtag_debug_module_write,
      jtag_debug_module_writedata => cpu_0_jtag_debug_module_writedata,
      reset_n => cpu_0_jtag_debug_module_reset_n
    );


  --the_epcs_controller_epcs_control_port, which is an e_instance
  the_epcs_controller_epcs_control_port : epcs_controller_epcs_control_port_arbitrator
    port map(
      clock_2_out_granted_epcs_controller_epcs_control_port => clock_2_out_granted_epcs_controller_epcs_control_port,
      clock_2_out_qualified_request_epcs_controller_epcs_control_port => clock_2_out_qualified_request_epcs_controller_epcs_control_port,
      clock_2_out_read_data_valid_epcs_controller_epcs_control_port => clock_2_out_read_data_valid_epcs_controller_epcs_control_port,
      clock_2_out_requests_epcs_controller_epcs_control_port => clock_2_out_requests_epcs_controller_epcs_control_port,
      clock_3_out_granted_epcs_controller_epcs_control_port => clock_3_out_granted_epcs_controller_epcs_control_port,
      clock_3_out_qualified_request_epcs_controller_epcs_control_port => clock_3_out_qualified_request_epcs_controller_epcs_control_port,
      clock_3_out_read_data_valid_epcs_controller_epcs_control_port => clock_3_out_read_data_valid_epcs_controller_epcs_control_port,
      clock_3_out_requests_epcs_controller_epcs_control_port => clock_3_out_requests_epcs_controller_epcs_control_port,
      d1_epcs_controller_epcs_control_port_end_xfer => d1_epcs_controller_epcs_control_port_end_xfer,
      epcs_controller_epcs_control_port_address => epcs_controller_epcs_control_port_address,
      epcs_controller_epcs_control_port_chipselect => epcs_controller_epcs_control_port_chipselect,
      epcs_controller_epcs_control_port_dataavailable_from_sa => epcs_controller_epcs_control_port_dataavailable_from_sa,
      epcs_controller_epcs_control_port_endofpacket_from_sa => epcs_controller_epcs_control_port_endofpacket_from_sa,
      epcs_controller_epcs_control_port_irq_from_sa => epcs_controller_epcs_control_port_irq_from_sa,
      epcs_controller_epcs_control_port_read_n => epcs_controller_epcs_control_port_read_n,
      epcs_controller_epcs_control_port_readdata_from_sa => epcs_controller_epcs_control_port_readdata_from_sa,
      epcs_controller_epcs_control_port_readyfordata_from_sa => epcs_controller_epcs_control_port_readyfordata_from_sa,
      epcs_controller_epcs_control_port_reset_n => epcs_controller_epcs_control_port_reset_n,
      epcs_controller_epcs_control_port_write_n => epcs_controller_epcs_control_port_write_n,
      epcs_controller_epcs_control_port_writedata => epcs_controller_epcs_control_port_writedata,
      clk => clk,
      clock_2_out_address_to_slave => clock_2_out_address_to_slave,
      clock_2_out_read => clock_2_out_read,
      clock_2_out_write => clock_2_out_write,
      clock_2_out_writedata => clock_2_out_writedata,
      clock_3_out_address_to_slave => clock_3_out_address_to_slave,
      clock_3_out_read => clock_3_out_read,
      clock_3_out_write => clock_3_out_write,
      clock_3_out_writedata => clock_3_out_writedata,
      epcs_controller_epcs_control_port_dataavailable => epcs_controller_epcs_control_port_dataavailable,
      epcs_controller_epcs_control_port_endofpacket => epcs_controller_epcs_control_port_endofpacket,
      epcs_controller_epcs_control_port_irq => epcs_controller_epcs_control_port_irq,
      epcs_controller_epcs_control_port_readdata => epcs_controller_epcs_control_port_readdata,
      epcs_controller_epcs_control_port_readyfordata => epcs_controller_epcs_control_port_readyfordata,
      reset_n => clk_reset_n
    );


  --the_epcs_controller, which is an e_ptf_instance
  the_epcs_controller : epcs_controller
    port map(
      dataavailable => epcs_controller_epcs_control_port_dataavailable,
      endofpacket => epcs_controller_epcs_control_port_endofpacket,
      irq => epcs_controller_epcs_control_port_irq,
      readdata => epcs_controller_epcs_control_port_readdata,
      readyfordata => epcs_controller_epcs_control_port_readyfordata,
      address => epcs_controller_epcs_control_port_address,
      chipselect => epcs_controller_epcs_control_port_chipselect,
      clk => clk,
      read_n => epcs_controller_epcs_control_port_read_n,
      reset_n => epcs_controller_epcs_control_port_reset_n,
      write_n => epcs_controller_epcs_control_port_write_n,
      writedata => epcs_controller_epcs_control_port_writedata
    );


  --the_jtag_uart_0_avalon_jtag_slave, which is an e_instance
  the_jtag_uart_0_avalon_jtag_slave : jtag_uart_0_avalon_jtag_slave_arbitrator
    port map(
      clock_0_out_granted_jtag_uart_0_avalon_jtag_slave => clock_0_out_granted_jtag_uart_0_avalon_jtag_slave,
      clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave => clock_0_out_qualified_request_jtag_uart_0_avalon_jtag_slave,
      clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave => clock_0_out_read_data_valid_jtag_uart_0_avalon_jtag_slave,
      clock_0_out_requests_jtag_uart_0_avalon_jtag_slave => clock_0_out_requests_jtag_uart_0_avalon_jtag_slave,
      d1_jtag_uart_0_avalon_jtag_slave_end_xfer => d1_jtag_uart_0_avalon_jtag_slave_end_xfer,
      jtag_uart_0_avalon_jtag_slave_address => jtag_uart_0_avalon_jtag_slave_address,
      jtag_uart_0_avalon_jtag_slave_chipselect => jtag_uart_0_avalon_jtag_slave_chipselect,
      jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa => jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa,
      jtag_uart_0_avalon_jtag_slave_irq_from_sa => jtag_uart_0_avalon_jtag_slave_irq_from_sa,
      jtag_uart_0_avalon_jtag_slave_read_n => jtag_uart_0_avalon_jtag_slave_read_n,
      jtag_uart_0_avalon_jtag_slave_readdata_from_sa => jtag_uart_0_avalon_jtag_slave_readdata_from_sa,
      jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa => jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa,
      jtag_uart_0_avalon_jtag_slave_reset_n => jtag_uart_0_avalon_jtag_slave_reset_n,
      jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa => jtag_uart_0_avalon_jtag_slave_waitrequest_from_sa,
      jtag_uart_0_avalon_jtag_slave_write_n => jtag_uart_0_avalon_jtag_slave_write_n,
      jtag_uart_0_avalon_jtag_slave_writedata => jtag_uart_0_avalon_jtag_slave_writedata,
      clk => clk,
      clock_0_out_address_to_slave => clock_0_out_address_to_slave,
      clock_0_out_nativeaddress => clock_0_out_nativeaddress,
      clock_0_out_read => clock_0_out_read,
      clock_0_out_write => clock_0_out_write,
      clock_0_out_writedata => clock_0_out_writedata,
      jtag_uart_0_avalon_jtag_slave_dataavailable => jtag_uart_0_avalon_jtag_slave_dataavailable,
      jtag_uart_0_avalon_jtag_slave_irq => jtag_uart_0_avalon_jtag_slave_irq,
      jtag_uart_0_avalon_jtag_slave_readdata => jtag_uart_0_avalon_jtag_slave_readdata,
      jtag_uart_0_avalon_jtag_slave_readyfordata => jtag_uart_0_avalon_jtag_slave_readyfordata,
      jtag_uart_0_avalon_jtag_slave_waitrequest => jtag_uart_0_avalon_jtag_slave_waitrequest,
      reset_n => clk_reset_n
    );


  --the_jtag_uart_0, which is an e_ptf_instance
  the_jtag_uart_0 : jtag_uart_0
    port map(
      av_irq => jtag_uart_0_avalon_jtag_slave_irq,
      av_readdata => jtag_uart_0_avalon_jtag_slave_readdata,
      av_waitrequest => jtag_uart_0_avalon_jtag_slave_waitrequest,
      dataavailable => jtag_uart_0_avalon_jtag_slave_dataavailable,
      readyfordata => jtag_uart_0_avalon_jtag_slave_readyfordata,
      av_address => jtag_uart_0_avalon_jtag_slave_address,
      av_chipselect => jtag_uart_0_avalon_jtag_slave_chipselect,
      av_read_n => jtag_uart_0_avalon_jtag_slave_read_n,
      av_write_n => jtag_uart_0_avalon_jtag_slave_write_n,
      av_writedata => jtag_uart_0_avalon_jtag_slave_writedata,
      clk => clk,
      rst_n => jtag_uart_0_avalon_jtag_slave_reset_n
    );


  --the_linebuffer_inst_avalon_slave_0, which is an e_instance
  the_linebuffer_inst_avalon_slave_0 : linebuffer_inst_avalon_slave_0_arbitrator
    port map(
      clock_5_out_granted_linebuffer_inst_avalon_slave_0 => clock_5_out_granted_linebuffer_inst_avalon_slave_0,
      clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0 => clock_5_out_qualified_request_linebuffer_inst_avalon_slave_0,
      clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0 => clock_5_out_read_data_valid_linebuffer_inst_avalon_slave_0,
      clock_5_out_requests_linebuffer_inst_avalon_slave_0 => clock_5_out_requests_linebuffer_inst_avalon_slave_0,
      d1_linebuffer_inst_avalon_slave_0_end_xfer => d1_linebuffer_inst_avalon_slave_0_end_xfer,
      linebuffer_inst_avalon_slave_0_address => linebuffer_inst_avalon_slave_0_address,
      linebuffer_inst_avalon_slave_0_chipselect => linebuffer_inst_avalon_slave_0_chipselect,
      linebuffer_inst_avalon_slave_0_read => linebuffer_inst_avalon_slave_0_read,
      linebuffer_inst_avalon_slave_0_readdata_from_sa => linebuffer_inst_avalon_slave_0_readdata_from_sa,
      linebuffer_inst_avalon_slave_0_reset => linebuffer_inst_avalon_slave_0_reset,
      linebuffer_inst_avalon_slave_0_write => linebuffer_inst_avalon_slave_0_write,
      linebuffer_inst_avalon_slave_0_writedata => linebuffer_inst_avalon_slave_0_writedata,
      clk => clk,
      clock_5_out_address_to_slave => clock_5_out_address_to_slave,
      clock_5_out_read => clock_5_out_read,
      clock_5_out_write => clock_5_out_write,
      clock_5_out_writedata => clock_5_out_writedata,
      linebuffer_inst_avalon_slave_0_readdata => linebuffer_inst_avalon_slave_0_readdata,
      reset_n => clk_reset_n
    );


  --the_linebuffer_inst, which is an e_ptf_instance
  the_linebuffer_inst : linebuffer_inst
    port map(
      data_to_dma => internal_data_to_dma_from_the_linebuffer_inst,
      field_to_dma => internal_field_to_dma_from_the_linebuffer_inst,
      linebufferfull_to_dma => internal_linebufferfull_to_dma_from_the_linebuffer_inst,
      linenumber_to_dma => internal_linenumber_to_dma_from_the_linebuffer_inst,
      readdata => linebuffer_inst_avalon_slave_0_readdata,
      Field => Field_to_the_linebuffer_inst,
      address => linebuffer_inst_avalon_slave_0_address,
      address_from_dma => address_from_dma_to_the_linebuffer_inst,
      chipselect => linebuffer_inst_avalon_slave_0_chipselect,
      clk_100 => clk_100_to_the_linebuffer_inst,
      clk_27 => clk_27_to_the_linebuffer_inst,
      clk_50 => clk,
      datavalid => datavalid_to_the_linebuffer_inst,
      read => linebuffer_inst_avalon_slave_0_read,
      reset => linebuffer_inst_avalon_slave_0_reset,
      write => linebuffer_inst_avalon_slave_0_write,
      writedata => linebuffer_inst_avalon_slave_0_writedata,
      xpos => xpos_to_the_linebuffer_inst,
      y => y_to_the_linebuffer_inst,
      ypos => ypos_to_the_linebuffer_inst
    );


  --the_sdram_s1, which is an e_instance
  the_sdram_s1 : sdram_s1_arbitrator
    port map(
      cpu_0_data_master_byteenable_sdram_s1 => cpu_0_data_master_byteenable_sdram_s1,
      cpu_0_data_master_granted_sdram_s1 => cpu_0_data_master_granted_sdram_s1,
      cpu_0_data_master_qualified_request_sdram_s1 => cpu_0_data_master_qualified_request_sdram_s1,
      cpu_0_data_master_read_data_valid_sdram_s1 => cpu_0_data_master_read_data_valid_sdram_s1,
      cpu_0_data_master_read_data_valid_sdram_s1_shift_register => cpu_0_data_master_read_data_valid_sdram_s1_shift_register,
      cpu_0_data_master_requests_sdram_s1 => cpu_0_data_master_requests_sdram_s1,
      cpu_0_instruction_master_granted_sdram_s1 => cpu_0_instruction_master_granted_sdram_s1,
      cpu_0_instruction_master_qualified_request_sdram_s1 => cpu_0_instruction_master_qualified_request_sdram_s1,
      cpu_0_instruction_master_read_data_valid_sdram_s1 => cpu_0_instruction_master_read_data_valid_sdram_s1,
      cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register => cpu_0_instruction_master_read_data_valid_sdram_s1_shift_register,
      cpu_0_instruction_master_requests_sdram_s1 => cpu_0_instruction_master_requests_sdram_s1,
      d1_sdram_s1_end_xfer => d1_sdram_s1_end_xfer,
      sdram_s1_address => sdram_s1_address,
      sdram_s1_byteenable_n => sdram_s1_byteenable_n,
      sdram_s1_chipselect => sdram_s1_chipselect,
      sdram_s1_read_n => sdram_s1_read_n,
      sdram_s1_readdata_from_sa => sdram_s1_readdata_from_sa,
      sdram_s1_reset_n => sdram_s1_reset_n,
      sdram_s1_waitrequest_from_sa => sdram_s1_waitrequest_from_sa,
      sdram_s1_write_n => sdram_s1_write_n,
      sdram_s1_writedata => sdram_s1_writedata,
      clk => clk_1,
      cpu_0_data_master_address_to_slave => cpu_0_data_master_address_to_slave,
      cpu_0_data_master_byteenable => cpu_0_data_master_byteenable,
      cpu_0_data_master_dbs_address => cpu_0_data_master_dbs_address,
      cpu_0_data_master_dbs_write_16 => cpu_0_data_master_dbs_write_16,
      cpu_0_data_master_no_byte_enables_and_last_term => cpu_0_data_master_no_byte_enables_and_last_term,
      cpu_0_data_master_read => cpu_0_data_master_read,
      cpu_0_data_master_waitrequest => cpu_0_data_master_waitrequest,
      cpu_0_data_master_write => cpu_0_data_master_write,
      cpu_0_instruction_master_address_to_slave => cpu_0_instruction_master_address_to_slave,
      cpu_0_instruction_master_dbs_address => cpu_0_instruction_master_dbs_address,
      cpu_0_instruction_master_latency_counter => cpu_0_instruction_master_latency_counter,
      cpu_0_instruction_master_read => cpu_0_instruction_master_read,
      reset_n => clk_1_reset_n,
      sdram_s1_readdata => sdram_s1_readdata,
      sdram_s1_readdatavalid => sdram_s1_readdatavalid,
      sdram_s1_waitrequest => sdram_s1_waitrequest
    );


  --the_sdram, which is an e_ptf_instance
  the_sdram : sdram
    port map(
      za_data => sdram_s1_readdata,
      za_valid => sdram_s1_readdatavalid,
      za_waitrequest => sdram_s1_waitrequest,
      zs_addr => internal_zs_addr_from_the_sdram,
      zs_ba => internal_zs_ba_from_the_sdram,
      zs_cas_n => internal_zs_cas_n_from_the_sdram,
      zs_cke => internal_zs_cke_from_the_sdram,
      zs_cs_n => internal_zs_cs_n_from_the_sdram,
      zs_dq => zs_dq_to_and_from_the_sdram,
      zs_dqm => internal_zs_dqm_from_the_sdram,
      zs_ras_n => internal_zs_ras_n_from_the_sdram,
      zs_we_n => internal_zs_we_n_from_the_sdram,
      az_addr => sdram_s1_address,
      az_be_n => sdram_s1_byteenable_n,
      az_cs => sdram_s1_chipselect,
      az_data => sdram_s1_writedata,
      az_rd_n => sdram_s1_read_n,
      az_wr_n => sdram_s1_write_n,
      clk => clk_1,
      reset_n => sdram_s1_reset_n
    );


  --reset is asserted asynchronously and deasserted synchronously
  nios_0_reset_clk_domain_synch : nios_0_reset_clk_domain_synch_module
    port map(
      data_out => clk_reset_n,
      clk => clk,
      data_in => module_input6,
      reset_n => reset_n_sources
    );

  module_input6 <= std_logic'('1');

  --reset sources mux, which is an e_mux
  reset_n_sources <= Vector_To_Std_Logic(NOT ((((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT reset_n))) OR std_logic_vector'("00000000000000000000000000000000")) OR std_logic_vector'("00000000000000000000000000000000")) OR (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_jtag_debug_module_resetrequest_from_sa)))) OR (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_0_jtag_debug_module_resetrequest_from_sa))))));
  --reset is asserted asynchronously and deasserted synchronously
  nios_0_reset_clk_1_domain_synch : nios_0_reset_clk_1_domain_synch_module
    port map(
      data_out => clk_1_reset_n,
      clk => clk_1,
      data_in => module_input7,
      reset_n => reset_n_sources
    );

  module_input7 <= std_logic'('1');

  --clock_0_out_endofpacket of type endofpacket does not connect to anything so wire it to default (0)
  clock_0_out_endofpacket <= std_logic'('0');
  --clock_1_out_endofpacket of type endofpacket does not connect to anything so wire it to default (0)
  clock_1_out_endofpacket <= std_logic'('0');
  --clock_2_in_writedata of type writedata does not connect to anything so wire it to default (0)
  clock_2_in_writedata <= std_logic_vector'("00000000000000000000000000000000");
  --clock_4_out_endofpacket of type endofpacket does not connect to anything so wire it to default (0)
  clock_4_out_endofpacket <= std_logic'('0');
  --clock_5_out_endofpacket of type endofpacket does not connect to anything so wire it to default (0)
  clock_5_out_endofpacket <= std_logic'('0');
  --vhdl renameroo for output signals
  BLUE_from_the_arbitrator_inst <= internal_BLUE_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  ENET_CMD_from_the_DM9000A <= internal_ENET_CMD_from_the_DM9000A;
  --vhdl renameroo for output signals
  ENET_CS_N_from_the_DM9000A <= internal_ENET_CS_N_from_the_DM9000A;
  --vhdl renameroo for output signals
  ENET_RD_N_from_the_DM9000A <= internal_ENET_RD_N_from_the_DM9000A;
  --vhdl renameroo for output signals
  ENET_RST_N_from_the_DM9000A <= internal_ENET_RST_N_from_the_DM9000A;
  --vhdl renameroo for output signals
  ENET_WR_N_from_the_DM9000A <= internal_ENET_WR_N_from_the_DM9000A;
  --vhdl renameroo for output signals
  GREEN_from_the_arbitrator_inst <= internal_GREEN_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  RED_from_the_arbitrator_inst <= internal_RED_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  SRAM_ADDR_from_the_arbitrator_inst <= internal_SRAM_ADDR_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  SRAM_CE_N_from_the_arbitrator_inst <= internal_SRAM_CE_N_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  SRAM_LB_N_from_the_arbitrator_inst <= internal_SRAM_LB_N_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  SRAM_OE_N_from_the_arbitrator_inst <= internal_SRAM_OE_N_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  SRAM_UB_N_from_the_arbitrator_inst <= internal_SRAM_UB_N_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  SRAM_WE_N_from_the_arbitrator_inst <= internal_SRAM_WE_N_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  busy_to_dma_from_the_arbitrator_inst <= internal_busy_to_dma_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  data_to_dma_from_the_linebuffer_inst <= internal_data_to_dma_from_the_linebuffer_inst;
  --vhdl renameroo for output signals
  field_to_dma_from_the_linebuffer_inst <= internal_field_to_dma_from_the_linebuffer_inst;
  --vhdl renameroo for output signals
  linebufferfull_to_dma_from_the_linebuffer_inst <= internal_linebufferfull_to_dma_from_the_linebuffer_inst;
  --vhdl renameroo for output signals
  linenumber_to_dma_from_the_linebuffer_inst <= internal_linenumber_to_dma_from_the_linebuffer_inst;
  --vhdl renameroo for output signals
  pixel_clock_from_the_arbitrator_inst <= internal_pixel_clock_from_the_arbitrator_inst;
  --vhdl renameroo for output signals
  zs_addr_from_the_sdram <= internal_zs_addr_from_the_sdram;
  --vhdl renameroo for output signals
  zs_ba_from_the_sdram <= internal_zs_ba_from_the_sdram;
  --vhdl renameroo for output signals
  zs_cas_n_from_the_sdram <= internal_zs_cas_n_from_the_sdram;
  --vhdl renameroo for output signals
  zs_cke_from_the_sdram <= internal_zs_cke_from_the_sdram;
  --vhdl renameroo for output signals
  zs_cs_n_from_the_sdram <= internal_zs_cs_n_from_the_sdram;
  --vhdl renameroo for output signals
  zs_dqm_from_the_sdram <= internal_zs_dqm_from_the_sdram;
  --vhdl renameroo for output signals
  zs_ras_n_from_the_sdram <= internal_zs_ras_n_from_the_sdram;
  --vhdl renameroo for output signals
  zs_we_n_from_the_sdram <= internal_zs_we_n_from_the_sdram;

end europa;


--synthesis translate_off

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;



-- <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
--add your libraries here
-- AND HERE WILL BE PRESERVED </ALTERA_NOTE>

entity test_bench is 
end entity test_bench;


architecture europa of test_bench is
component nios_0 is 
           port (
                 -- 1) global signals:
                    signal clk : IN STD_LOGIC;
                    signal clk_1 : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- the_DM9000A
                    signal ENET_CMD_from_the_DM9000A : OUT STD_LOGIC;
                    signal ENET_CS_N_from_the_DM9000A : OUT STD_LOGIC;
                    signal ENET_DATA_to_and_from_the_DM9000A : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal ENET_INT_to_the_DM9000A : IN STD_LOGIC;
                    signal ENET_RD_N_from_the_DM9000A : OUT STD_LOGIC;
                    signal ENET_RST_N_from_the_DM9000A : OUT STD_LOGIC;
                    signal ENET_WR_N_from_the_DM9000A : OUT STD_LOGIC;

                 -- the_arbitrator_inst
                    signal BLUE_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal GREEN_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal HCOUNT_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal RED_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal SRAM_ADDR_from_the_arbitrator_inst : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal SRAM_CE_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                    signal SRAM_DQ_to_and_from_the_arbitrator_inst : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal SRAM_LB_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                    signal SRAM_OE_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                    signal SRAM_UB_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                    signal SRAM_WE_N_from_the_arbitrator_inst : OUT STD_LOGIC;
                    signal VCOUNT_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal address_from_dma_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal busy_to_dma_from_the_arbitrator_inst : OUT STD_LOGIC;
                    signal data_from_dma_to_the_arbitrator_inst : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal data_ready_from_dma_to_the_arbitrator_inst : IN STD_LOGIC;
                    signal pixel_clock_from_the_arbitrator_inst : OUT STD_LOGIC;

                 -- the_linebuffer_inst
                    signal Field_to_the_linebuffer_inst : IN STD_LOGIC;
                    signal address_from_dma_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (6 DOWNTO 0);
                    signal clk_100_to_the_linebuffer_inst : IN STD_LOGIC;
                    signal clk_27_to_the_linebuffer_inst : IN STD_LOGIC;
                    signal data_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal datavalid_to_the_linebuffer_inst : IN STD_LOGIC;
                    signal field_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC;
                    signal linebufferfull_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC;
                    signal linenumber_to_dma_from_the_linebuffer_inst : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal xpos_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal y_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal ypos_to_the_linebuffer_inst : IN STD_LOGIC_VECTOR (9 DOWNTO 0);

                 -- the_sdram
                    signal zs_addr_from_the_sdram : OUT STD_LOGIC_VECTOR (11 DOWNTO 0);
                    signal zs_ba_from_the_sdram : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal zs_cas_n_from_the_sdram : OUT STD_LOGIC;
                    signal zs_cke_from_the_sdram : OUT STD_LOGIC;
                    signal zs_cs_n_from_the_sdram : OUT STD_LOGIC;
                    signal zs_dq_to_and_from_the_sdram : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal zs_dqm_from_the_sdram : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal zs_ras_n_from_the_sdram : OUT STD_LOGIC;
                    signal zs_we_n_from_the_sdram : OUT STD_LOGIC
                 );
end component nios_0;

component sdram_test_component is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal zs_addr : IN STD_LOGIC_VECTOR (11 DOWNTO 0);
                    signal zs_ba : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal zs_cas_n : IN STD_LOGIC;
                    signal zs_cke : IN STD_LOGIC;
                    signal zs_cs_n : IN STD_LOGIC;
                    signal zs_dqm : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal zs_ras_n : IN STD_LOGIC;
                    signal zs_we_n : IN STD_LOGIC;

                 -- outputs:
                    signal zs_dq : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component sdram_test_component;

                signal BLUE_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal ENET_CMD_from_the_DM9000A :  STD_LOGIC;
                signal ENET_CS_N_from_the_DM9000A :  STD_LOGIC;
                signal ENET_DATA_to_and_from_the_DM9000A :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal ENET_INT_to_the_DM9000A :  STD_LOGIC;
                signal ENET_RD_N_from_the_DM9000A :  STD_LOGIC;
                signal ENET_RST_N_from_the_DM9000A :  STD_LOGIC;
                signal ENET_WR_N_from_the_DM9000A :  STD_LOGIC;
                signal Field_to_the_linebuffer_inst :  STD_LOGIC;
                signal GREEN_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal HCOUNT_to_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal RED_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal SRAM_ADDR_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (17 DOWNTO 0);
                signal SRAM_CE_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal SRAM_DQ_to_and_from_the_arbitrator_inst :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal SRAM_LB_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal SRAM_OE_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal SRAM_UB_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal SRAM_WE_N_from_the_arbitrator_inst :  STD_LOGIC;
                signal VCOUNT_to_the_arbitrator_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal address_from_dma_to_the_arbitrator_inst :  STD_LOGIC_VECTOR (17 DOWNTO 0);
                signal address_from_dma_to_the_linebuffer_inst :  STD_LOGIC_VECTOR (6 DOWNTO 0);
                signal busy_to_dma_from_the_arbitrator_inst :  STD_LOGIC;
                signal clk :  STD_LOGIC;
                signal clk_1 :  STD_LOGIC;
                signal clk_100_to_the_linebuffer_inst :  STD_LOGIC;
                signal clk_27_to_the_linebuffer_inst :  STD_LOGIC;
                signal clock_0_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_0_out_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_0_out_endofpacket :  STD_LOGIC;
                signal clock_1_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_1_out_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_1_out_endofpacket :  STD_LOGIC;
                signal clock_2_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_2_in_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal clock_2_out_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_2_out_nativeaddress :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_3_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_3_out_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal clock_3_out_nativeaddress :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal clock_4_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_4_out_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_4_out_endofpacket :  STD_LOGIC;
                signal clock_4_out_nativeaddress :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal clock_5_in_endofpacket_from_sa :  STD_LOGIC;
                signal clock_5_out_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal clock_5_out_endofpacket :  STD_LOGIC;
                signal clock_5_out_nativeaddress :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal data_from_dma_to_the_arbitrator_inst :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal data_ready_from_dma_to_the_arbitrator_inst :  STD_LOGIC;
                signal data_to_dma_from_the_linebuffer_inst :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal datavalid_to_the_linebuffer_inst :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_dataavailable_from_sa :  STD_LOGIC;
                signal epcs_controller_epcs_control_port_readyfordata_from_sa :  STD_LOGIC;
                signal field_to_dma_from_the_linebuffer_inst :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_dataavailable_from_sa :  STD_LOGIC;
                signal jtag_uart_0_avalon_jtag_slave_readyfordata_from_sa :  STD_LOGIC;
                signal linebufferfull_to_dma_from_the_linebuffer_inst :  STD_LOGIC;
                signal linenumber_to_dma_from_the_linebuffer_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal pixel_clock_from_the_arbitrator_inst :  STD_LOGIC;
                signal reset_n :  STD_LOGIC;
                signal xpos_to_the_linebuffer_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal y_to_the_linebuffer_inst :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal ypos_to_the_linebuffer_inst :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal zs_addr_from_the_sdram :  STD_LOGIC_VECTOR (11 DOWNTO 0);
                signal zs_ba_from_the_sdram :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal zs_cas_n_from_the_sdram :  STD_LOGIC;
                signal zs_cke_from_the_sdram :  STD_LOGIC;
                signal zs_cs_n_from_the_sdram :  STD_LOGIC;
                signal zs_dq_to_and_from_the_sdram :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal zs_dqm_from_the_sdram :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal zs_ras_n_from_the_sdram :  STD_LOGIC;
                signal zs_we_n_from_the_sdram :  STD_LOGIC;


-- <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
--add your component and signal declaration here
-- AND HERE WILL BE PRESERVED </ALTERA_NOTE>


begin

  --Set us up the Dut
  DUT : nios_0
    port map(
      BLUE_from_the_arbitrator_inst => BLUE_from_the_arbitrator_inst,
      ENET_CMD_from_the_DM9000A => ENET_CMD_from_the_DM9000A,
      ENET_CS_N_from_the_DM9000A => ENET_CS_N_from_the_DM9000A,
      ENET_DATA_to_and_from_the_DM9000A => ENET_DATA_to_and_from_the_DM9000A,
      ENET_RD_N_from_the_DM9000A => ENET_RD_N_from_the_DM9000A,
      ENET_RST_N_from_the_DM9000A => ENET_RST_N_from_the_DM9000A,
      ENET_WR_N_from_the_DM9000A => ENET_WR_N_from_the_DM9000A,
      GREEN_from_the_arbitrator_inst => GREEN_from_the_arbitrator_inst,
      RED_from_the_arbitrator_inst => RED_from_the_arbitrator_inst,
      SRAM_ADDR_from_the_arbitrator_inst => SRAM_ADDR_from_the_arbitrator_inst,
      SRAM_CE_N_from_the_arbitrator_inst => SRAM_CE_N_from_the_arbitrator_inst,
      SRAM_DQ_to_and_from_the_arbitrator_inst => SRAM_DQ_to_and_from_the_arbitrator_inst,
      SRAM_LB_N_from_the_arbitrator_inst => SRAM_LB_N_from_the_arbitrator_inst,
      SRAM_OE_N_from_the_arbitrator_inst => SRAM_OE_N_from_the_arbitrator_inst,
      SRAM_UB_N_from_the_arbitrator_inst => SRAM_UB_N_from_the_arbitrator_inst,
      SRAM_WE_N_from_the_arbitrator_inst => SRAM_WE_N_from_the_arbitrator_inst,
      busy_to_dma_from_the_arbitrator_inst => busy_to_dma_from_the_arbitrator_inst,
      data_to_dma_from_the_linebuffer_inst => data_to_dma_from_the_linebuffer_inst,
      field_to_dma_from_the_linebuffer_inst => field_to_dma_from_the_linebuffer_inst,
      linebufferfull_to_dma_from_the_linebuffer_inst => linebufferfull_to_dma_from_the_linebuffer_inst,
      linenumber_to_dma_from_the_linebuffer_inst => linenumber_to_dma_from_the_linebuffer_inst,
      pixel_clock_from_the_arbitrator_inst => pixel_clock_from_the_arbitrator_inst,
      zs_addr_from_the_sdram => zs_addr_from_the_sdram,
      zs_ba_from_the_sdram => zs_ba_from_the_sdram,
      zs_cas_n_from_the_sdram => zs_cas_n_from_the_sdram,
      zs_cke_from_the_sdram => zs_cke_from_the_sdram,
      zs_cs_n_from_the_sdram => zs_cs_n_from_the_sdram,
      zs_dq_to_and_from_the_sdram => zs_dq_to_and_from_the_sdram,
      zs_dqm_from_the_sdram => zs_dqm_from_the_sdram,
      zs_ras_n_from_the_sdram => zs_ras_n_from_the_sdram,
      zs_we_n_from_the_sdram => zs_we_n_from_the_sdram,
      ENET_INT_to_the_DM9000A => ENET_INT_to_the_DM9000A,
      Field_to_the_linebuffer_inst => Field_to_the_linebuffer_inst,
      HCOUNT_to_the_arbitrator_inst => HCOUNT_to_the_arbitrator_inst,
      VCOUNT_to_the_arbitrator_inst => VCOUNT_to_the_arbitrator_inst,
      address_from_dma_to_the_arbitrator_inst => address_from_dma_to_the_arbitrator_inst,
      address_from_dma_to_the_linebuffer_inst => address_from_dma_to_the_linebuffer_inst,
      clk => clk,
      clk_1 => clk_1,
      clk_100_to_the_linebuffer_inst => clk_100_to_the_linebuffer_inst,
      clk_27_to_the_linebuffer_inst => clk_27_to_the_linebuffer_inst,
      data_from_dma_to_the_arbitrator_inst => data_from_dma_to_the_arbitrator_inst,
      data_ready_from_dma_to_the_arbitrator_inst => data_ready_from_dma_to_the_arbitrator_inst,
      datavalid_to_the_linebuffer_inst => datavalid_to_the_linebuffer_inst,
      reset_n => reset_n,
      xpos_to_the_linebuffer_inst => xpos_to_the_linebuffer_inst,
      y_to_the_linebuffer_inst => y_to_the_linebuffer_inst,
      ypos_to_the_linebuffer_inst => ypos_to_the_linebuffer_inst
    );


  --the_sdram_test_component, which is an e_instance
  the_sdram_test_component : sdram_test_component
    port map(
      zs_dq => zs_dq_to_and_from_the_sdram,
      clk => clk_1,
      zs_addr => zs_addr_from_the_sdram,
      zs_ba => zs_ba_from_the_sdram,
      zs_cas_n => zs_cas_n_from_the_sdram,
      zs_cke => zs_cke_from_the_sdram,
      zs_cs_n => zs_cs_n_from_the_sdram,
      zs_dqm => zs_dqm_from_the_sdram,
      zs_ras_n => zs_ras_n_from_the_sdram,
      zs_we_n => zs_we_n_from_the_sdram
    );


  process
  begin
    clk <= '0';
    loop
       wait for 10 ns;
       clk <= not clk;
    end loop;
  end process;
  process
  begin
    clk_1 <= '0';
    loop
       wait for 5 ns;
       clk_1 <= not clk_1;
    end loop;
  end process;
  PROCESS
    BEGIN
       reset_n <= '0';
       wait for 200 ns;
       reset_n <= '1'; 
    WAIT;
  END PROCESS;


-- <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
--add additional architecture here
-- AND HERE WILL BE PRESERVED </ALTERA_NOTE>


end europa;



--synthesis translate_on
