--Legal Notice: (C)2007 Altera Corporation. All rights reserved.  Your
--use of Altera Corporation's design tools, logic functions and other
--software and tools, and its AMPP partner logic functions, and any
--output files any of the foregoing (including device programming or
--simulation files), and any associated documentation or information are
--expressly subject to the terms and conditions of the Altera Program
--License Subscription Agreement or other applicable license agreement,
--including, without limitation, that your use is for the sole purpose
--of programming logic devices manufactured by Altera and sold by Altera
--or its authorized distributors.  Please refer to the applicable
--agreement for further details.


-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity linebuffer_inst is 
        port (
              -- inputs:
                 signal Field : IN STD_LOGIC;
                 signal address : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal address_from_dma : IN STD_LOGIC_VECTOR (6 DOWNTO 0);
                 signal chipselect : IN STD_LOGIC;
                 signal clk_100 : IN STD_LOGIC;
                 signal clk_27 : IN STD_LOGIC;
                 signal clk_50 : IN STD_LOGIC;
                 signal datavalid : IN STD_LOGIC;
                 signal read : IN STD_LOGIC;
                 signal reset : IN STD_LOGIC;
                 signal write : IN STD_LOGIC;
                 signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal xpos : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal y : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal ypos : IN STD_LOGIC_VECTOR (9 DOWNTO 0);

              -- outputs:
                 signal data_to_dma : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal field_to_dma : OUT STD_LOGIC;
                 signal linebufferfull_to_dma : OUT STD_LOGIC;
                 signal linenumber_to_dma : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                 signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
end entity linebuffer_inst;


architecture europa of linebuffer_inst is
component linebuffer is 
           port (
                 -- inputs:
                    signal Field : IN STD_LOGIC;
                    signal address : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal address_from_dma : IN STD_LOGIC_VECTOR (6 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk_100 : IN STD_LOGIC;
                    signal clk_27 : IN STD_LOGIC;
                    signal clk_50 : IN STD_LOGIC;
                    signal datavalid : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal reset : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal xpos : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal y : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal ypos : IN STD_LOGIC_VECTOR (9 DOWNTO 0);

                 -- outputs:
                    signal data_to_dma : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal field_to_dma : OUT STD_LOGIC;
                    signal linebufferfull_to_dma : OUT STD_LOGIC;
                    signal linenumber_to_dma : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
                    signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component linebuffer;

                signal internal_data_to_dma :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_field_to_dma :  STD_LOGIC;
                signal internal_linebufferfull_to_dma :  STD_LOGIC;
                signal internal_linenumber_to_dma :  STD_LOGIC_VECTOR (9 DOWNTO 0);
                signal internal_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);

begin

  --the_linebuffer, which is an e_instance
  the_linebuffer : linebuffer
    port map(
      data_to_dma => internal_data_to_dma,
      field_to_dma => internal_field_to_dma,
      linebufferfull_to_dma => internal_linebufferfull_to_dma,
      linenumber_to_dma => internal_linenumber_to_dma,
      readdata => internal_readdata,
      Field => Field,
      address => address,
      address_from_dma => address_from_dma,
      chipselect => chipselect,
      clk_100 => clk_100,
      clk_27 => clk_27,
      clk_50 => clk_50,
      datavalid => datavalid,
      read => read,
      reset => reset,
      write => write,
      writedata => writedata,
      xpos => xpos,
      y => y,
      ypos => ypos
    );


  --vhdl renameroo for output signals
  data_to_dma <= internal_data_to_dma;
  --vhdl renameroo for output signals
  field_to_dma <= internal_field_to_dma;
  --vhdl renameroo for output signals
  linebufferfull_to_dma <= internal_linebufferfull_to_dma;
  --vhdl renameroo for output signals
  linenumber_to_dma <= internal_linenumber_to_dma;
  --vhdl renameroo for output signals
  readdata <= internal_readdata;

end europa;

