library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DMACONTROLLER is
  
  port (
		clk_50: in std_logic;
		linebufferfull_from_lb: in std_logic;
		data_from_lb: in std_logic_vector(15 downto 0);
		busy_from_arb: in std_logic;
		field_from_lb: in std_logic;
		lineNumber_from_lb: in std_logic_vector (9 downto 0);
		
		address_to_lb: out std_logic_vector(6 downto 0);
		address_to_arb: out std_logic_vector(17 downto 0);
		data_to_arb: out std_logic_vector(15 downto 0);
		data_ready_to_arb: out std_logic
    );
  
end DMACONTROLLER;

architecture behavior of DMACONTROLLER is

begin
	process (clk_50)	
	
	variable state: std_logic := '0';
	variable addressIndex: unsigned (6 downto 0) := "0000000";
	variable tmp: unsigned(19 downto 0);
	
	begin
		if rising_edge(clk_50) then
				
			if state = '0' then
				data_ready_to_arb <= '0';
				if linebufferfull_from_lb = '1' then
					address_to_lb <= std_logic_vector(addressIndex);
					state := '1';
				end if;
				
			elsif state = '1' then
				if busy_from_arb = '0' then
					data_to_arb <= data_from_lb;
					data_ready_to_arb <= '1';
					
					if field_from_lb = '1' then
						tmp := (unsigned(lineNumber_from_lb) * 80) + addressIndex;
						address_to_arb <= std_logic_vector(tmp) (17 downto 0);
					else
						tmp := ((unsigned(lineNumber_from_lb)+1) * 80) + addressIndex;
						address_to_arb <= std_logic_vector(tmp) (17 downto 0);
					end if;

					if (addressIndex = 79) then
						state := '0';
						addressIndex := "0000000";
					else
						addressIndex := addressIndex + 1;
						address_to_lb <= std_logic_vector(addressIndex);
					end if;
					
				end if;
			end if;
		end if;
			
	end process;

end behavior;
