#include <io.h>
#include <system.h>
#include <unistd.h>
#include <stdio.h>
#include "light_saber.h"

#define WriteLightSaber(base, address, data)  IOWR_16DIRECT(base, address*2, data)
#define ReadLightSaber(base,address) IORD_16DIRECT(base, address*2)
#define ReadXY(base,address) IORD_32DIRECT(base, address*4)


struct color{
    int x1;
    int x2;
    int count;
    int first;
    long average;
    int last;
    int final_x;
    int final_y;
    int mycount_x;
    int mean;
};



    
int main(){
int mycount_blue=0,mycount_green=0;   
int i,X_Blue,X_green;
int LineCount;
struct color b1;
struct color g1;
int prevlc=0,TD_VS_edge;
int VGA_HS;
struct lookuptable table[506];
LineCount= ReadLightSaber(CORE_NIOS_BASE,26);
int b=0;
int a=0;
   while(1){
        prevlc=LineCount;
        LineCount= ReadLightSaber(CORE_NIOS_BASE,26);

 //---------------------------X-Y calculation--------------------------------------        
      
            if(LineCount!=prevlc){
                       //blue calc
                       int blue_data = ReadXY(BLUE_INST_BASE,LineCount);
                        int temp_bluedata = blue_data;
                        b1.count = 0x0FFFF & temp_bluedata;
                        X_Blue =temp_bluedata >> 16;
                        b1.x1=(X_Blue+1)-b1.count;
                        if(b1.x1==1)
                         b1.x1=0;
                        b1.x2=X_Blue;
                        
                        //green calc 
                        g1.count=ReadLightSaber(CORE_NIOS_BASE,12);   
                        X_green=ReadLightSaber(CORE_NIOS_BASE,14);
                        g1.x1=(X_green+1)-g1.count;
                        if(g1.x1==1){
                        g1.x1=0;
                        }
                        g1.x2=X_green;
                        
                       
                        if (b1.count> 0) {
                           if(b1.first ==0){
                            b1.first=LineCount;
                            }
                            b1.last=LineCount;
                            mycount_blue ++; 
                            b1.mean=(b1.x1+b1.x2)>>1;
                            b1.average=(b1.average+b1.mean);
                          }
              
                        if (g1.count> 0) {
                           if(g1.first ==0){
                            g1.first=LineCount;
                            }
                            g1.last=LineCount;
                            mycount_green ++;
                            g1.mean=(g1.x1+g1.x2)>>1;
                            g1.average=(g1.average+g1.mean);
                        }
            }   
         
       

 //----------------------------LightSaber Calculation-----------------------------//      
         TD_VS_edge=ReadLightSaber(CORE_NIOS_BASE,28);
    
        if(TD_VS_edge==1){      
         
            WriteLightSaber(CORE_NIOS_BASE,20,0);  //rest the TD_VS_flag
              b1.final_y=(b1.last+b1.first);
              b1.final_y = b1.final_y >> 1;
            g1.final_y=(g1.last+g1.first)>>1;
            
            if(mycount_blue>0)
            b1.final_x=b1.average/mycount_blue;
            else
            b1.final_x=0;
            
            if(mycount_green>0)
            g1.final_x=g1.average/mycount_green;
            else
             g1.final_x=0;

            g1.average=0;
            b1.average=0;
            mycount_green = 0;
            mycount_blue=0;
            b1.first=0;
            b1.last=0;
            g1.first=0;
            g1.last=0;
            g1.count = 0;
            b1.count = 0;
            b=0;
         
            for(i=0;i<506;i++){
                  table[i].x1=0;
                  table[i].x2=0;
                 table[i].in_x1=0;
                  table[i].in_x2=0;
            } 
           
           if((b1.final_x>0 && (b1.final_y<<1)>0) && (g1.final_x>0 && (g1.final_y<<1)>0))
            DrawLightSaber(b1.final_x,(b1.final_y<<1),g1.final_x,(g1.final_y<<1),table);
           
            

            for (i = 0; i<506; i++)
            {
             WriteLightSaber(CORE_NIOS_BASE, 0,table[i].in_x1);
             WriteLightSaber(CORE_NIOS_BASE, 2,table[i].in_x2);
             WriteLightSaber(CORE_NIOS_BASE, 30,table[i].x1);
             WriteLightSaber(CORE_NIOS_BASE, 18,table[i].x2);
             WriteLightSaber(CORE_NIOS_BASE, 24, i);
                
            }
               
          
        }


   }

     return 0;

}

