#define SHIFT 7
#include <stdio.h>
#include <io.h>
#include <system.h>
#include <unistd.h>
#include "light_saber.h"
#define SWAP(x0,y0) {(x0 ^= y0); (y0 ^= x0); (x0 ^= y0);}

int sqrt(int num);
void line1(int x0, int y0, int x1, int y1,struct lookuptable *table);

//------------------------Draw Light Saber-------------------------------------//

void DrawLightSaber(int x0,int y0,int x1,int y1,struct lookuptable* table)
{  
    //struct lookuptable table[480];

int dx = x0 - x1;
int dy = y0 - y1;
int hyp = sqrt((x0 - x1) * (x0 - x1) +  (y0 - y1) * (y0 -y1));
int costheta = dy << SHIFT / hyp;
int sintheta = dx << SHIFT / hyp;

int deltay = (swordwidth  * sintheta) >> SHIFT;
int deltax = (swordwidth  * costheta) >> SHIFT;

line1(x0 + deltax + 1, y0 - deltay - 1, x1 + deltax +1, y1 - deltay - 1 ,table);
line1(x0 - deltax - 1, y0 + deltay + 1, x1 - deltax - 1, y1 + deltay + 1,table);
line1(x0 - deltax - 1, y0 + deltay + 1 , x0 + deltax + 1, y0 - deltay - 1 ,table);
line1(x1 + deltax + 1, y1 - deltay - 1 , x1 - deltax - 1, y1 + deltay + 1 ,table);


}

void line1(int x0, int y0, int x1, int y1,struct lookuptable *table) {
   int Dx = x1 - x0;
   int Dy = y1 - y0;
   int steep = (abs(Dy) >= abs(Dx));
   if (steep) {
       SWAP(x0, y0);
       SWAP(x1, y1);
       // recompute Dx, Dy after swap
       Dx = x1 - x0;
       Dy = y1 - y0;
   }
   int xstep = 1;
   if (Dx < 0) {
       xstep = -1;
       Dx = -Dx;
   }
   int ystep = 1;
   if (Dy < 0) {
       ystep = -1;     
       Dy = -Dy;
   }
   int TwoDy = Dy<<1;
   int TwoDyTwoDx = TwoDy - (Dx<<1); // 2*Dy - 2*Dx
   int E = TwoDy - Dx; //2*Dy - Dx
   int y = y0;
   int xDraw, yDraw;
   int x;  
   int prev_YDraw;
   prev_YDraw=yDraw;
   for (x = x0; x != x1; x += xstep) {     
       if (steep) {        
           xDraw = y;
           yDraw = x;
       } else {        
           xDraw = x;
           yDraw = y;
       }
       // plot
        if (table[yDraw].x1 == 0){
            table[yDraw].x1 = xDraw;
            table[yDraw].in_x1=xDraw-Halowidth;
        }
         if (xDraw <  table[yDraw].x1){
             table[yDraw].x1 = xDraw;
             table[yDraw].in_x1=xDraw-Halowidth;
         }
         if (table[yDraw].x1<0){
           table[yDraw].x1 = 1;
           table[yDraw].in_x1=1;
         }
            
        
       if(xDraw>0){     
       if (table[yDraw].x2 == 0){
            table[yDraw].x2 = xDraw;
            table[yDraw].in_x2=xDraw+Halowidth;
       }
         if (xDraw >  table[yDraw].x2){
             table[yDraw].x2 = xDraw;
             table[yDraw].in_x2=xDraw+Halowidth;
        }
         if (table[yDraw].in_x2>639){
            table[yDraw].x2 = 639;
            table[yDraw].in_x2=639;
         }     
       }             

       // next
       if (E > 0) {
           E += TwoDyTwoDx; //E += 2*Dy - 2*Dx;
           y = y + ystep;
       } else {
           E += TwoDy; //E += 2*Dy;
       }
   }
}

int sqrt(int num) {
        int op = num;
        int res = 0;
        int one = 1 << 14; // The second-to-top bit is set: 1L<<30 for long
 
        // "one" starts at the highest power of four <= the argument.
        while (one > op)
            one >>= 2;
 
        while (one != 0) {
            if (op >= res + one) {
                op -= res + one;
                res += one << 1;
            }
            res >>= 1;
            one >>= 2;
        }
        return res;
    }