-------------------------------------------------------------------------------
--
-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity VGA is
  
  port (
    reset_n : in std_logic;
    clk27   : in std_logic;                    
	clk50   : in std_logic; 
    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0); -- Blue[9:0]
	readin:in std_logic_vector(14 downto 0 );
	--iG,iR,iB: in std_logic_vector(7 downto 0);
	TD_HS,
	TD_VS: in std_logic;
	vga_vsync_edge: in std_logic;
	data_valid: in std_logic;
	
	bluecount, greencount : in std_logic_vector(9 downto 0);
	x_blue, x_green : in std_logic_vector(9 downto 0);
			-- Avalon_signals

		 signal address : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
		 signal chipselect : IN STD_LOGIC;
		 signal read : IN STD_LOGIC;
		 signal write : IN STD_LOGIC;
		 signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);		
		 signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)	
);

end VGA;

architecture rtl of VGA is
  

  constant HTOTAL       : integer := 858;
  constant HSYNC        : integer := 103;
  constant HBACK_PORCH  : integer := 76;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 39;

  constant VTOTAL       : integer := 524;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 34;
  constant VACTIVE      : integer := 478;
  constant VFRONT_PORCH : integer := 10;

  -- Signals for the video controller
  signal Hcount : unsigned(10 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;
  --signal vga_x : std_logic := '0';

  signal vga_hblank, vga_hsync,
    vga_vblank, vga_vsync : std_logic;  -- Sync. signals
                           
type ROMType is array(0 to 719)of std_logic_vector(14 downto 0);
  signal ROM1, ROM2:ROMType := (others => "000000000000000");

signal Read_HS_flag : std_logic := '0';
signal a,b,c: std_logic;
signal INDEX : integer range 0 to 800;
signal regx1, regx2 : integer := 0; 			--range 0 to 640;

begin			
  HCounter : process (clk27)
  begin
    if rising_edge(clk27) then      
      if reset_n = '0'  then-- or  
        Hcount <= (others => '0');
      elsif TD_HS='1'then
		Hcount <=(others =>'0');
		else
		Hcount <= Hcount+1;	
	  end if;
	end if;
  end process HCounter;

  VCounter: process (clk27)
  begin
    if rising_edge(clk27) then      
      if reset_n = '0'then 
        Vcount <= (others => '0');
	  elsif vga_vsync_edge='1' then
		Vcount <= (others => '0');	
		elsif TD_HS='1' then
		Vcount<=Vcount+1;
      end if;
    end if;
  end process VCounter;

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk27)
  begin
    if rising_edge(clk27) then     
      if reset_n = '0' then
        vga_hsync <= '1';
		elsif TD_HS='1' then
		 vga_hsync <= '1';
		elsif Hcount=Htotal-1 then
		 vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 or Hcount=HTOTAL+HSYNC-1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk27)
  begin
    if rising_edge(clk27) then
      if reset_n = '0' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH-1 or Hcount = HTOTAL+HSYNC + HBACK_PORCH-1 then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE-1 or 
			Hcount = HTOTAL + HSYNC + HBACK_PORCH + HACTIVE-1 then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk27)
  begin
if rising_edge(clk27) then	
	if reset_n = '0' then
        vga_vsync <= '1';
    elsif vga_vsync_edge='1' then
		vga_vsync<='1';
	elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';

      end if;
end if;
end process VSyncGen;



  VBlankGen : process (clk27)
  begin
    if rising_edge(clk27) then    
      if reset_n = '0' then
        vga_vblank <= '1';
        if Vcount = VSYNC+VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount =VSYNC+VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;

Read_HS: process(TD_HS)
begin
		if TD_HS'event and TD_HS = '1' then
			Read_HS_flag <= not Read_HS_flag;
		end if;
end process Read_HS;

fill_buffer: process(clk27,data_valid)
variable i,j : integer range 0 to 720 := 0;
begin
	if rising_edge(clk27) then
		if Read_HS_flag = '1' and data_valid='1' then
			ROM1 ( i ) <= readin ;
			i := i+ 1;
			if i = 639 then 
				i := 0;
			elsif TD_HS='1' then 
				i:=0;
			end if;
		elsif Read_HS_flag='0' and data_valid='1' then
			ROM2 ( j ) <= readin ;
			j := j+1;
			if j = 639 then 
				j := 0;
			elsif TD_HS='1' then 
				j:=0;
			end if;
		end if;
	end if;	
end process fill_buffer;


--write process
bus_comm: process (clk50)
  begin
    if rising_edge(clk50) then
		if (chipselect = '1')then
			if address(4 downto 0) = "00000" then
                if write = '1' then
                      regx1 <= to_integer(unsigned(writedata));--x1
                end if;
			elsif address(4 downto 0) = "00010" then
                if write = '1' then
                      regx2 <= to_integer(unsigned(writedata));--x2
                 end if;
            end if;
		end if;
    end if;
  end process bus_comm;

Read_process: process(clk50)
 begin
    if rising_edge(clk50) then
		if (chipselect = '1')then
			
			
	----------------------VGA_HS(ADDR 4)----------------------------------
			if address(4 downto 0) = "00100" then
                if read = '1' then
                    if vga_hsync='0' then
							readdata<="0000000000000001";		-- We send VGA_HS in form of 1 or 0
						else
							readdata<=(others=>'0');
					end if;
                end if;
			 end if;
			
	----------------------ROW_NO (ADDR 6)--------------------------------------------		
			if address(4 downto 0) = "00110" then
                if read = '1' then
					if vga_hsync='0' then
						if  (to_integer(Vcount)-VSYNC - VBACK_PORCH)>0 and (to_integer(Vcount)-VSYNC - VBACK_PORCH) < 478 then		-- line number is sent to NIOS
							readdata <= std_logic_vector(to_unsigned((to_integer(Vcount)-VSYNC - VBACK_PORCH), 16));			-- 
						else 
							readdata<=(others=>'0');
						end if;
					end if;
				end if;
			 end if;

	---------------------------Blue count(ADDR 8)-------------------------------------------		
				if address(4 downto 0) = "01000" then
					if read = '1' then
						--if TD_HS = '0' then
						readdata <= ("000000" & bluecount);
						end if;
						end if;
						--end if;
 -------------------------------Xblue(ADDR 10)-----------------------------------------------						
				if address(4 downto 0) = "01010" then
					if read = '1' then
				   -- if TD_HS = '0' then
				  readdata <= ("000000" & x_blue);				-- software must find x_blue - bluecount 
					end if;
					end if;
					--end if;
----------------------------------Green count(ADDR 12)--------------------------------------					
				if address(4 downto 0) = "01100" then
						if read = '1' then
						--if TD_HS = '0' then
				  readdata <= ("000000" & greencount);
					end if;
					end if;
					--end if;
----------------------------------Xgreen(ADDR 14)------------------------------------------------					
				if address(4 downto 0) = "01110" then
					if read = '1' then
					--	if TD_HS = '0' then
				  readdata <= ("000000" & x_green);				-- software must find x_green - greencount 
					end if;
					end if;
				--	end if;
				
------------------------VGA_VS(ADDR 16)------------------------------------------------		

			if address(4 downto 0) = "10000" then
				if read ='1' then
					if vga_vsync='0' then
							readdata<="0000000000000001";		-- We send VGA_VS in form of 1 or 0
						else
							readdata<=(others=>'0');
					end if;
					end if;
				end if;
-------------------------TD_HS(ADDR 18)------------------------------------------------
		if address(4 downto 0) ="10010" then
			if read='1' then
				if TD_HS ='1'then
				readdata<="0000000000000001";		-- We send TD_HS in form of 1 or 0
				else
				readdata<=(others=>'0');
				end if;
				end if;
				end if;
----------------------------------------------------------------------------------------		 
		end if;
end if;
end process Read_process;


VideoOut: process (clk27, reset_n)
  begin
 if rising_edge(clk27) then
	if(Hcount<HTOTAL) then
	INDEX<=to_integer(HCOUNT-HSYNC-HBACK_PORCH);		-- 
	else
	INDEX<=to_integer(HCOUNT-HSYNC-HBACK_PORCH-HTOTAL);		-- 
	end if;	
			if reset_n = '0' then
			  VGA_R <= "0000000000";
			  VGA_G <= "0000000000";
			  VGA_B <= "0000000000";
			else
			if vga_hblank = '0' and vga_vblank ='0' then
			  if Read_HS_flag = '1' then
				if INDEX > regx1 and INDEX < regx2 then
				VGA_R <= "0000000000";
				VGA_G <= "1111111111";
				VGA_B <= "0000000000"; 
				else
				VGA_R <= ROM2(INDEX)(14 downto 10) & "00000";
				VGA_G <= ROM2(INDEX)(9 downto 5)& "00000";
				VGA_B <= ROM2(INDEX)(4 downto 0)& "00000"; 
				end if;
			  elsif Read_HS_flag = '0' then
				if INDEX > regx1 and INDEX < regx2 then
				VGA_R <= "0000000000";
				VGA_G <= "1111111111";
				VGA_B <= "0000000000";
				else
				VGA_R <= ROM1(INDEX)(14 downto 10) & "00000";
				VGA_G <= ROM1(INDEX)(9 downto 5)& "00000";
				VGA_B <= ROM1(INDEX)(4 downto 0)& "00000"; 
				end if;
	else
        VGA_R <= "0000000000";
        VGA_G <= "0000000000";
        VGA_B <= "0000000000";    
    end if;
  end if;
  end if;
  end if;
  end process VideoOut;

  VGA_CLK <= clk27;
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;
