// --------------------------------------------------------------------
// Copyright (c) 2005 by Terasic Technologies Inc. 
// --------------------------------------------------------------------
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development 
//   Kits made by Terasic.  Other use of this code, including the selling 
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use 
//   or functionality of this code.
//
// --------------------------------------------------------------------
//           
//                     Terasic Technologies Inc
//                     356 Fu-Shin E. Rd Sec. 1. JhuBei City,
//                     HsinChu County, Taiwan
//                     302
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// --------------------------------------------------------------------
//
// Major Functions:	YCbCr to RGB Color Doamin Converter. 
//					( 10 Bits Resolution )
//
// --------------------------------------------------------------------
//
// Revision History :
// --------------------------------------------------------------------
//   Ver  :| Author            :| Mod. Date :| Changes Made:
//   V1.0 :| Johnny Chen       :| 05/09/05  :|      Initial Revision
// --------------------------------------------------------------------

module YCbCr2RGB (	//Red,Green,Blue,oDVAL,
					oRGB, x_blue, x_green, bluecount, greencount,
					datavalid, TD_HS,
					Linecount, TD_VS,
					iY,iCb,iCr,//iDVAL,
					iRESET,iCLK);
//	Input
input [7:0] iY,iCb,iCr;
//input //iDVAL,
input iRESET,iCLK;
input datavalid, TD_HS, TD_VS;
//	Output
output [14:0]oRGB;
output [9:0] Linecount;
output [9:0] x_blue, x_green, bluecount, greencount;
//output [9:0] Red,Green,Blue;
//output reg	oDVAL;
//	Internal Registers/Wires
reg [14:0] oRGB_sig;
reg [9:0] Linecount;
reg [9:0] oRed,oGreen,oBlue;
reg [9:0] x_blue, x_green,Temp_x_blue,Temp_x_green;
reg [10:0] Temp_bluecount,Temp_greencount,bluecount,greencount;
//reg	[3:0] oDVAL_d;
reg [19:0] X_OUT,Y_OUT,Z_OUT;
wire [26:0] X,Y,Z;
reg [12:0] Xcount,Reset_count;
assign oRGB = oRGB_sig;
//assign	Red  =	oRed;
//assign	Green=	oGreen;
//assign	Blue =	oBlue;

// manages the count values
always@(posedge iCLK)
begin
	if(iRESET || TD_HS)
	begin
		Xcount<= 0;
	end	
	else if  (datavalid)
	Xcount <= Xcount + 1; 
end

//line count
always@(posedge iCLK)
begin
if(datavalid)
begin
	if(Xcount == 638)
		Linecount<= Linecount + 1;
	else 
	Linecount<= Linecount + 0;
end	
	if(!TD_VS) 
	Linecount <= 0;
end


//temp values assigned at TD_HS
always@(posedge iCLK)
begin
	if( TD_HS)
	begin
		bluecount<=Temp_bluecount;
		greencount<=Temp_greencount;
		x_blue<= Temp_x_blue;
		x_green<=Temp_x_green;
	end
end


// main part
always@(posedge iCLK)
begin
	Reset_count<=Reset_count+1;
	
	if(iRESET || TD_HS)
	begin
		oRed<=0;
		oGreen<=0;
		oBlue<=0;
		Reset_count<=0;
	end
	


//The Temp values reset 10 clockcycles after TD_HS	
	else if(Reset_count==5)
		begin
		Temp_x_blue<= 0; Temp_x_green <= 0;
		Temp_bluecount<=0; Temp_greencount<= 0;
	end

	else if (datavalid) 
	begin
	 if(iY > 85 && iCb>140 && iCr<120) 		//iY>130		// blue detection
	//if (1)
	begin
	Temp_bluecount<= Temp_bluecount + 1;
	oRed<=1023;
	oGreen<=1023;
	oBlue<=1023;
	Temp_x_blue <= Xcount;
	end
	
	else if(iY>100 && iCb<120 && iCr<110) 			// green detection
	begin
	Temp_greencount <= Temp_greencount + 1;
	oRed<=1023;
	oGreen<=1023;
	oBlue<=1023;
	Temp_x_green <= Xcount;
	end
	
	else //if(iDVAL)
	begin
		// Red
		if(X_OUT[19])
		oRed<=0;  
		else if(X_OUT[18:0]>1023)
		oRed<=1023;
		else
		oRed<=X_OUT[9:0];
        
		// Green
		if(Y_OUT[19])
		oGreen<=0;
		else if(Y_OUT[18:0]>1023)
		oGreen<=1023;
		else
		oGreen<=Y_OUT[9:0];
        
		// Blue
		if(Z_OUT[19])
		oBlue<=0;
		else if(Z_OUT[18:0]>1023)
		oBlue<=1023;
		else
		oBlue<=Z_OUT[9:0];
		// Control
		//{oDVAL,oDVAL_d}<={oDVAL_d,iDVAL};
        		//oDVAL <= 1;
	end
	end
	oRGB_sig <= {oRed[9:5], oGreen[9:5], oBlue[9:5]};
end

always@(posedge iCLK)
begin
	if(iRESET)
	begin
		X_OUT<=0;
		Y_OUT<=0;
		Z_OUT<=0;
	end
	else //if(iDVAL)
	begin
		X_OUT<=( X - 114131 ) >>7;
		Y_OUT<=( Y + 69370  ) >>7;
		Z_OUT<=( Z - 141787 ) >>7;			
	end
end

//	Y		596,		0,			817
MAC_3 u0(	iY,			iCb,		iCr,
			17'h00254,	17'h00000,	17'h00331,
			X,		iRESET,		iCLK);
//	Cb		596,		-200,		-416
MAC_3 u1(	iY,			iCb,		iCr,
			17'h00254,	17'h3FF38,	17'h3FE60,
			Y,		iRESET,		iCLK);
//	Cr		596,		1033,		0
MAC_3 u2(	iY,			iCb,		iCr,
			17'h00254,	17'h00409,	17'h00000,
			Z,		iRESET,		iCLK);
			
			

endmodule