library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity XY_GEN is
  
  port (
    reset_n : in std_logic;
    clk27   : in std_logic;                    
	clk50   : in std_logic; 
	KEY_XY : in std_logic_vector (3 downto 0);
	TD_HS,
	TD_VS: in std_logic;
	iY,iCb,iCr : in std_logic_vector(7 downto 0);
		-- Avalon_signals

		 signal address : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
		 signal chipselect : IN STD_LOGIC;
		 signal read : IN STD_LOGIC;
		 signal write : IN STD_LOGIC;
		 signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);		
		 signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)	
);

end XY_GEN;

architecture rtl of XY_GEN is
signal bluecount, greencount : integer := 0;
signal x_blue, x_green : integer := 0;
signal Hcount : integer := 0;
constant HBACK_PORCH  : integer := 76;
constant HSYNC        : integer := 103;
begin
		
  HCounter : process (clk27)
  begin
    if rising_edge(clk27) then      
      if reset_n = '0'  then-- or  
        Hcount <= 0;
      elsif TD_HS='1'then
		Hcount <= 0;
		else
		Hcount <= Hcount+1;	
	  end if;
	end if;
  end process HCounter;

blue_detect: process(clk27)
variable count : integer := 0;
begin
if rising_edge(clk27)then
if (Hcount - HSYNC-HBACK_PORCH = 0) then
		count := 0;
		x_blue <= 0;
	elsif TD_HS = '0' then
	if (to_integer(unsigned(iCb)) > 150) then
		x_blue <= Hcount -HSYNC - HBACK_PORCH;
		count := count + 1;
	 end if;
end if;
end if;
bluecount <= count;
end process;

green_detect: process(clk27)
variable count : integer := 0;
begin
if rising_edge(clk27)then
if (Hcount - HSYNC - HBACK_PORCH = 0) then
		count := 0;
		x_green <= 0;
	elsif TD_HS = '0' then
    if (to_integer(unsigned(iY)) < 120 and to_integer(unsigned(iCb)) < 90 and to_integer(unsigned(iCr)) < 90) then
			x_green <= Hcount -HSYNC- HBACK_PORCH;
		    count := count + 1;
	 end if;
end if;
end if;
greencount <= count;
end process;
	
	
writing : process(clk50)
begin
if rising_edge(clk50)then
	if TD_HS = '1' then
		
		if (chipselect = '1')then
			if read = '1' then
				if address(1) = '1' then
					readdata <= std_logic_vector(to_unsigned(bluecount, 16));
				elsif address(1) = '0' then
				  readdata <= std_logic_vector(to_unsigned(x_blue, 16));				-- software must find x_blue - bluecount 
				elsif address(4) = '1' then
				  readdata <= std_logic_vector(to_unsigned(greencount, 16));
				elsif address(8) = '1' then
				  readdata <= std_logic_vector(to_unsigned(x_green, 16));				-- software must find x_green - greencount 
				end if;
			end if;
		end if;
	end if;
end if;
end process;
end rtl;

