--
-- DE2 top-level module that includes the simple VGA raster generator
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity LIGHT_SABER is

  port (
    -- Clocks
    OSC_50,
	OSC_27,                                      -- 27 MHz
    EXT_CLOCK : in std_logic;                      -- External Clock

	KEY: in std_logic_vector (3 downto 0); 
    -- VGA output
    
    VGA_CLK,                                            -- Clock
    VGA_HS,                                             -- H_SYNC
    VGA_VS,                                             -- V_SYNC
    VGA_BLANK,                                          -- BLANK
    VGA_SYNC : out std_logic;                           -- SYNC
    VGA_R,                                              -- Red[9:0]
    VGA_G,                                              -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0);             -- Blue[9:0]

	--		
	TD_DATA : in std_logic_vector(7 downto 0);    				--TV Decoder Data bus 8 bits
	TD_RESET: out std_logic;	
	TD_HS,							--	TV Decoder H_SYNC
	TD_VS:	in std_logic;								--	TV Decoder V_SYNC
	--TV Decoder Reset
		
		--I2C
	I2C_SDAT : inout std_logic;				--	I2C Data
	I2C_SCLK: out std_logic;				--	I2C Clock
	
	--SRAM signals
	SRAM_DQ   : inout std_logic_vector(15 downto 0);
    SRAM_ADDR : out std_logic_vector(17 downto 0);
    SRAM_UB_N, SRAM_LB_N : out std_logic;
    SRAM_WE_N, SRAM_CE_N : out std_logic;
    SRAM_OE_N            : out std_logic
    );
  
end LIGHT_SABER;

architecture datapath of LIGHT_SABER is

signal I2C_SDAT1 : std_logic := I2C_SDAT;
signal iY_core, iCb_core, iCr_core : std_logic_vector(7 downto 0);
signal tempaddr : std_logic_vector(9 downto 0);
signal X_blue,blue_count:  std_logic_vector(9 downto 0);

component I2C_AV_Config port(	--	Host Side
						iCLK,
						iRST_N : in std_logic;
						--	I2C Side
						I2C_SCLK : out std_logic;
						I2C_SDAT : inout std_logic);
end component;

begin

V0: I2C_AV_Config port map(	--	Host Side
						iCLK => OSC_27,
						iRST_N => '1',
						--	I2C Side
						I2C_SCLK => I2C_SCLK,
						I2C_SDAT => I2C_SDAT1);

 V4: entity work.nios_top port map (
						clk => OSC_50, --
						reset_n => '1', --
						KEY_core_to_the_CORE_nios => KEY,
						clk27_to_the_CORE_nios => OSC_27,
		-- VGA output
						VGA_CLK_core_from_the_CORE_nios => VGA_CLK,                                            -- Clock
						VGA_HS_core_from_the_CORE_nios => VGA_HS,                                             -- H_SYNC
						VGA_VS_core_from_the_CORE_nios => VGA_VS,                                             -- V_SYNC
						VGA_BLANK_core_from_the_CORE_nios => VGA_BLANK,                                          -- BLANK
						VGA_SYNC_core_from_the_CORE_nios => VGA_SYNC,                                         -- SYNC
						VGA_R_core_from_the_CORE_nios => VGA_R,                                              -- Red[9:0]
						VGA_G_core_from_the_CORE_nios => VGA_G,                                              -- Green[9:0]
						VGA_B_core_from_the_CORE_nios => VGA_B,                                              -- Blue[9:0]
		-- TD ports				
						TD_DATA_core_to_the_CORE_nios => TD_DATA,   				                                   --TV Decoder Data bus 8 bits
						TD_RESET_core_from_the_CORE_nios => TD_RESET,	
						TD_HS_core_to_the_CORE_nios => TD_HS,							                               --	TV Decoder H_SYNC
						TD_VS_core_to_the_CORE_nios => TD_VS,
						Linecount_core_from_the_CORE_nios => tempaddr,
						bluecount_from_the_CORE_nios => blue_count,
						x_blue_from_the_CORE_nios => X_blue,
--						oCb_from_the_CORE_nios => iCb_core,
--						oCr_from_the_CORE_nios => iCr_core,
--						oY_from_the_CORE_nios => iY_core,
						
--	clk27_to_the_XY_GEN_nios => OSC_27,
--	KEY_XY_to_the_XY_GEN_nios => KEY,
--	TD_HS_to_the_XY_GEN_nios => TD_HS,
--	TD_VS_to_the_XY_GEN_nios => TD_VS,
--	iY_to_the_XY_GEN_nios => iY_core,
--	iCb_to_the_XY_GEN_nios => iCb_core,
--	iCr_to_the_XY_GEN_nios => iCr_core,

clk27_to_the_Blue_inst => OSC_27, 
TD_HS_to_the_Blue_inst => TD_HS,
tempaddr_to_the_Blue_inst => tempaddr,
X_blue_to_the_Blue_inst => X_blue,
blue_count_to_the_Blue_inst => blue_count,


						
						SRAM_DQ_to_and_from_the_sram => SRAM_DQ,   
						SRAM_ADDR_from_the_sram => SRAM_ADDR, 
						SRAM_UB_N_from_the_sram => SRAM_UB_N, 
						SRAM_LB_N_from_the_sram => SRAM_LB_N, 
						SRAM_WE_N_from_the_sram => SRAM_WE_N, 
						SRAM_CE_N_from_the_sram => SRAM_CE_N, 
						SRAM_OE_N_from_the_sram => SRAM_OE_N            

  );


--v12: entity work.XY_GEN port map (
--    reset_n => '1',
--    clk27_to_the_XY_GEN_nios => clk27,
--	clk => CLK50,
--	KEY_XY_to_the_XY_GEN_nios => KEY,
--	TD_HS_to_the_XY_GEN_nios => TD_HS,
--	TD_VS_to_the_XY_GEN_nios => TD_VS,
--	iY_to_the_XY_GEN_nios => iY_core,
--	iCb_to_the_XY_GEN_nios => iCb_core,
--	iCr_to_the_XY_GEN_nios => iCr_core
--		-- Avalon_signals
--);

end datapath;
