--
-- DE2 top-level module that includes the simple VGA raster generator
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CORE is

  port (

	clk27 : in std_logic;
	reset_n : in std_logic;
	CLK50 : in std_logic;
	KEY_core : in std_logic_vector (3 downto 0);  
  
	
 -- VGA output
    VGA_CLK_core,                                            -- Clock
    VGA_HS_core,                                             -- H_SYNC
    VGA_VS_core,                                             -- V_SYNC
    VGA_BLANK_core,                                          -- BLANK
    VGA_SYNC_core : out std_logic;                           -- SYNC
    VGA_R_core,                                              -- Red[9:0]
    VGA_G_core,                                              -- Green[9:0]
    VGA_B_core : out std_logic_vector(9 downto 0);             -- Blue[9:0]

		TD_DATA_core : in std_logic_vector(7 downto 0);    				--TV Decoder Data bus 8 bits
		TD_RESET_core: out std_logic;	
		TD_HS_core,							--	TV Decoder H_SYNC
		TD_VS_core:	in std_logic;								--	TV Decoder V_SYNC
				--TV Decoder Reset
		--oY, oCb, oCr : out std_logic_vector(7 downto 0);		--XY_Gen
		Linecount_core : out std_logic_vector(9 downto 0);
		x_blue : out std_logic_vector(9 downto 0);
		bluecount : out std_logic_vector(9 downto 0);
		-- Avalon_signals

		 signal address : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
		 signal chipselect : IN STD_LOGIC;
		 signal read : IN STD_LOGIC;
		 signal write : IN STD_LOGIC;
		 signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);		
		 signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)	
    );
  
end CORE;

architecture datapath of CORE is
signal globalvalid: std_logic;
signal remain_sig: std_logic;
signal YCbCr : std_logic_vector (23 downto 0);
signal TV_X : std_logic_vector (9 downto 0);
signal TV_DVAL : std_logic;
signal DLY1 : std_logic;
signal DLY2,TD_Stable : std_logic;
signal quotient : std_logic_vector(9 downto 0);
signal DLY0 : std_logic;
signal remain : std_logic_vector ( 3 downto 0);
signal vga_vsync_edge, TD_HS_edge: std_logic;
signal Y_sig, Cb_sig, Cr_sig: std_logic_vector(7 downto 0);
signal RGB : std_logic_vector(14 downto 0);
signal b_c, g_c, x_b, x_g : std_logic_vector(9 downto 0);

signal Linecount_core_sig : std_logic_vector(9 downto 0);		--@@

component VGA port (
    reset_n : in std_logic;
    clk27   : in std_logic;                    
	clk50 : in std_logic;
    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0); -- Blue[9:0]
	readin:in std_logic_vector(14 downto 0 );
	TD_HS,TD_HS_edge,
	TD_VS: in std_logic;
	vga_vsync_edge: in std_logic;
	data_valid: in std_logic;
	
	bluecount, greencount : in std_logic_vector(9 downto 0);
	x_blue, x_green : in std_logic_vector(9 downto 0);
	
	Linecount_vga : in std_logic_vector(9 downto 0);
	
	address : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
	 chipselect : IN STD_LOGIC;
	 read : IN STD_LOGIC;
	 write : IN STD_LOGIC;
	 writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);		
	 readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
);

end component;

component ITU_656_Decoder port(	--	TV Decoder Input
							iTD_DATA : in std_logic_vector(7 downto 0);
							--	Position Output
							oTV_X,
							oTV_Y : out std_logic_vector(9 downto 0);
							oTV_Cont : out std_logic_vector(31 downto 0);
							--	YUV 4:2:2 Output
							oYCbCr :out std_logic_vector(23 downto 0);
							oDVAL : out std_logic;
							--	Control Signals
							iSwap_CbCr,
							iSkip,
							iRST_N,
							iCLK_27 : in std_logic	);
							
end component;

component DIV port(
	aclr,
	clock :in std_logic;
	denom :in std_logic_vector(3 downto 0);
	numer:in std_logic_vector(9 downto 0);
	quotient :out std_logic_vector(9 downto 0);
	remain:out std_logic_vector(3 downto 0);
	remain_0: out std_logic);
end component;

component Reset_Delay port (iCLK,iRST : in std_logic;
							oRST_0,oRST_1,oRST_2 : out std_logic);
end component;

component TD_Detect port(oTD_Stable : out std_logic;
					iTD_VS,
					iTD_HS,
					iRST_N	: in std_logic);
end component;

component YUV422_to_444 port(		--	YUV 4:2:2 Input
									iYCbCr:in std_logic_vector(23 downto 0);
									iFlag: in std_logic; 
									--valid: in std_logic;
									--YUV	4:4:4 Output
									--RGB : out std_logic_vector(15 downto 0);
									oY,
									oCb,
									oCr:  out std_logic_vector(7 downto 0);
									--Control Signals
									--iFlag,
									iCLK,
									iRST_N: in std_logic	);
end component;

component YCbCr2RGB port(	oRGB : out std_logic_vector(14 downto 0);
						-- oDVAL: out std_logic;
						x_blue, x_green, bluecount, greencount : out std_logic_vector(9 downto 0);
						datavalid, TD_HS, TD_VS: in std_logic;
						Linecount : out std_logic_vector(9 downto 0); 
						iY,iCb,iCr: in std_logic_vector(7 downto 0);
						iRESET,iCLK : in std_logic --, iDVAL
						);
end component;

component edge_detector port(
						clk:in std_logic;
						TD_VS: in std_logic;
						vga_vsync_edge: out std_logic
);
end component;

component h_edge_detector is
  port(
clk:in std_logic;
TD_HS: in std_logic;
hsync_edge: out std_logic
);
end component;

begin

TD_RESET_core <=KEY_core(0);

Linecount_core <= Linecount_core_sig;			--@@
bluecount <= b_c;
x_blue <= x_b;
--oY <= y_sig;
--oCb <= Cb_sig;
--oCr <= Cr_sig;		--Xy_GEn

						
v5: Reset_Delay	port map(	iCLK =>clk27,
							iRST =>TD_Stable,
							oRST_0 =>DLY0,
							oRST_1 =>DLY1,
							oRST_2 =>DLY2);
							
v6: TD_Detect	port map(oTD_Stable =>TD_Stable,
							iTD_VS =>TD_VS_core,
							iTD_HS =>TD_HS_core,
							iRST_N =>KEY_core(0));
						
v1:	ITU_656_Decoder	port map(iTD_DATA =>TD_DATA_core,
							oTV_X =>TV_X,
							oYCbCr =>YCbCr,
							oDVAL=>globalvalid,
							iSwap_CbCr =>Quotient(0),
							iSkip=>remain_sig,
							iRST_N =>DLY1,
							iCLK_27=>clk27	);
							
	v8:YUV422_to_444 port map(	
								iYCbCr=>YCbCr,
								iFlag => globalvalid,
								oY => y_sig,
								oCr => Cr_sig,
								oCb => Cb_sig,
								--	Control Signals
								iCLK=>clk27,
								iRST_N=> KEY_core(0)	);		
								
v10: YCbCr2RGB port map (	oRGB => RGB, 
					iY => y_sig,
					iCb =>Cb_sig,
					iCr =>Cr_sig,
					iRESET => '0',
					TD_HS => TD_HS_core,
					TD_VS => TD_VS_core,
					Linecount => Linecount_core_sig,
					datavalid => globalvalid,
					bluecount => b_c,
					greencount => g_c,
					x_blue => x_b,
					x_green => x_g,
					iCLK => clk27);
					
v3: DIV port map(	aclr => not (DLY0),	
							clock =>clk27,
							denom =>"1001",
							numer =>TV_X,
							quotient =>Quotient,
							remain =>Remain,
							remain_0 => remain_sig);

  V4: VGA port map (
    reset_n => '1',
    clk27 =>clk27,
	clk50 => CLK50,
    VGA_CLK => VGA_CLK_core,
    VGA_HS => VGA_HS_core,
    VGA_VS => VGA_VS_core,
    VGA_BLANK => VGA_BLANK_core,
    VGA_SYNC => VGA_SYNC_core,
    VGA_R => VGA_R_core,
    VGA_G => VGA_G_core,
    VGA_B => VGA_B_core,
	TD_HS => TD_HS_core,
	TD_VS => not(TD_VS_core),
	vga_vsync_edge=>vga_vsync_edge,
	readin => RGB,
	data_valid=>globalvalid,
	TD_HS_edge => TD_HS_edge,
	bluecount => b_c,
	greencount => g_c,
	x_blue => x_b,
	x_green => x_g,
	
	Linecount_vga => Linecount_core_sig,
	
	address => address,
	chipselect => chipselect,
	read => read,
	write => write,
	writedata => writedata,
	readdata => readdata
  );

V9: edge_detector port map(
clk=>clk27,
TD_VS=>TD_VS_core,
vga_vsync_edge=>vga_vsync_edge
);

v12:h_edge_detector port map(
clk => clk27,
TD_HS => TD_HS_core,
hsync_edge => TD_HS_edge
);
	
end datapath;
