library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Blue is 

generic 
	(
		DATA_WIDTH : natural := 64;
		ADDR_WIDTH : natural := 10
	);
	
port (
reset_n: in std_logic;
clk27,clk50: in std_logic;
TD_HS: in std_logic;
tempaddr : in std_logic_vector(9 downto 0);
X_blue,blue_count: in std_logic_vector(9 downto 0);
		 signal address : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
		 signal chipselect : IN STD_LOGIC;
		 signal read : IN STD_LOGIC;
		 signal write : IN STD_LOGIC;
		 signal writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);		
		 signal readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)	
);
end Blue; 

architecture rtl of Blue is
component ram_dual
port (
		rclk	: in std_logic;
		wclk	: in std_logic;
		raddr	: in natural range 0 to 2**ADDR_WIDTH - 1;
		waddr	: in natural range 0 to 2**ADDR_WIDTH - 1;
		data	: in std_logic_vector((DATA_WIDTH-1) downto 0);
		we		: in std_logic := '1';
		q		: out std_logic_vector((DATA_WIDTH -1) downto 0)
	);

end component;


signal BLUE_data: std_logic_vector(63 downto 0);
subtype word_t is std_logic_vector(31 downto 0);
type memory_t is array(261 downto 0) of word_t;
signal ram : memory_t;

begin 
 
--BLUE_data <= ("000000" & X_blue) & ("000000" & blue_count);
v9: ram_dual port map(
		rclk => clk50,	
		wclk	=> clk27,
		raddr	=>to_integer(unsigned(address)),
		waddr	=>to_integer(unsigned(tempaddr)),
		data	=>BLUE_data,
		--we		=
		q(31 downto 0) => readdata		
	);

concatdataproc: process(clk27)
	begin
	if(rising_edge(clk27)) then 
	  if(TD_HS = '1') then
			BLUE_data <= ("000000" & X_blue) & ("000000" & blue_count) & ("000000" & X_blue) & ("000000" & blue_count);
		end if;
	end if;
	end process concatdataproc;

--writeproc: process(clk27)
--	begin
--	if(rising_edge(clk27)) then 
--	  if(TD_HS = '1') then
--			ram(to_integer(unsigned(tempaddr))) <= BLUE_data;
--		end if;
--	end if;
--	end process writeproc;
--
--readproc:process(clk50)
--begin
--if(rising_edge(clk50)) then
--	if chipselect = '1' then	
--		if read = '1' then
--		readdata <= ram(to_integer(unsigned(address)));
--	end if;
--	end if;
--	end if;
--	end process readproc;

end rtl;



	
